Data repository for bioRxiv preprint https://doi.org/10.1101/2022.03.17.484801v1

Title: A brain-wide analysis maps structural evolution to distinct anatomical
modules.

Authors: Robert A. Kozol1*, Andrew J. Conith2, Anders Yuiska1,
 Alexia Cree-Newman1, Bernadeth Tolentino1, Kasey Banesh1, Alexandra Paz1,
 Evan Lloyd4, Johanna E. Kowalko3, Alex C. Keene4, R. Craig Albertson2
 and Erik R. Duboue1*

Year: 2022

Data and analysis description

Neuroanatomical volumetric data and analysis:

NIfTI (.nii.gz) files are tERK stained brains of surface, pachon and surface to
pachon hybrids used for anatomical analyses. NIfTI files were registered to the
astyanax F2 standard brain (SPF2_021921_010.nii.gz) using a custom script
(ANTs1.sh) calling Advanced Normalization Tools
(ANTs; http://stnava.github.io/ANTs/) binaries. The ANTs1.sh script segments
each tERK stained brain using inverse registration and prints a registered NIfTI
file, matlab affine brain mask (GenericAffine.mat) and segmentation file
(iWarp.nii.gz) needed to run the CobraZ software
(https://www.nichd.nih.gov/research/atNICHD/Investigators/burgess/software).
Condensed brain segments were then created using the custom matlab script
CobraZ_transform_HB.py. CobraZ outputs include holms corrected t-tests comparing
the two analyzed groups, while three to four group comparisons were analyzed
using holm's corrected ANOVA in PRISM graphpad.All registered and inverse
registered image stacks were assessed for accuracy using the MATLAB script
CC_recursive.m which calls the CrossCorrReg2.m analysis script for pixel
resolution overlap of brain staining between individualdal larvae and the
reference brain.

Neuroanatomical shape comparison.

Tiff files of individual segments of iWarp files (e.g. cerebellum) were
generated using custom matlab script (combine_regions_**date**_**region**.m). 
Files were then converted to a mesh (.stl) using Amira (ThermoFisher). Landmarks
were placed along brain segments using LandmarkEditor
(v3.0; https://www.stratovan.com/blog/landmark-editor). Shapes were then
transformed and assessed using the geomorph package in R (v4.0;
https://cran.r-project.org/web/packages/geomorph/index.html).

Pairwise correlation and covariation analysis of brain region volumes and shapes

The custom python script (CorrCoefCobraZ.py) volume or shape data into python
and performs a pairwise correlation of all brain regions, generating a heatmap
and performing a cluster analysis.

For more detailed materials and methods, see https://doi.org/10.1101/2
