#!/usr/bin/env python
# coding: utf-8

# In[1]:


# Load in Pandas and Numpy
# We'll need this to do the data manipulation
import pandas as pd
import numpy as np


# In[6]:


# Load in data.
# This is coming straight from my Desktop for now, but we will want to modify this to take in arguments
file = '/Users/reboot/Documents/out_region_size.xlsx'
df = pd.read_excel(file,skiprows=(0,0))
df.head(5)


# In[8]:


# We will delete this cell. This is just so I can see your column names.
df.columns


# In[12]:


# Now we can start reducing the larger dataframe (the structure that pandas saves your data as) into smaller dfs
# that we can append to a new Excel file later.
#
# This is done using Pandas' 'filter' function. Just put the column names as arguments into the filter function
# and save it to a new variable.
#
# In theory, we will just do this recurcisvly for all of your different regions


df_TeO = df.filter(['File','r003[Optic tectum - neuropil]','r015[Optic tectum - neuropil]','r040[Optic tectum - neuropil]','r083[Optic tectum - neuropil]','r112[Optic tectum - neuropil]','r015[Optic tectum - stratum periventriculare]','r022[Optic tectum - stratum periventriculare]','r053[Optic tectum - stratum periventriculare]','r089[Optic tectum - stratum periventriculare]','r155[Optic tectum - stratum periventriculare]','r062[Torus longitudinalis]','r069[Medial tectal band]','r116[Griseum tectale]'])
df_TeO['Sum'] = df_TeO.loc[:, df_TeO.columns != 'File'].sum(axis=1)
df_Hyp = df.filter(['File','r001[Hypothalamus - Intermediate Zone]','r008[Hypothalamus - Intermediate Zone]','r011[Hypothalamus - Rostral]','r020[Hypothalamus - Intermediate Zone]','r024[Neuropil adjacent to IPN]','r025[Hypothalamus - Intermediate Zone]','r038[Preoptic area - Lateral]','r054[Hypothalamus - Intermediate Zone]','r058[Hypothalamus - Caudal Zone]','r061[Preoptic area]','r066[Pituitary]','r098[Hypothalamus - Rostral Zone]','r104[Preoptic area]','r107[Hypothalamus - Caudal Zone]','r110[Migrated posterior tubercular area M2]','r120[Hypothalamus - Intermediate Zone]','r135[Hypothalamus - Intermediate Zone]','r146[Optic tract - AF2]','r152[Hypothalamus - Rostral Zone]','r163[Optic chiasm]','r172[Preoptic area]','r176[Hypothalamus - Rostral Zone]'])
df_Hyp['Sum'] = df_Hyp.loc[:, df_Hyp.columns != 'File'].sum(axis=1)
df_Pa = df.filter(['File','r005[Pallium]','r037[Pallium]','r076[Pallium]','r133[Pallium]','r180[Pallium]','r103[Olfactory bulb]','r177[Olfactory bulb]'])
df_Pa['Sum'] = df_Pa.loc[:, df_Pa.columns != 'File'].sum(axis=1)
df_Sp = df.filter(['File','r026[Subpallium]','r075[Subpallium]','r137[Anterior commissure]'])
df_Sp['Sum'] = df_Sp.loc[:, df_Sp.columns != 'File'].sum(axis=1)
df_Pp = df.filter(['File','r028[Rhombomere 2 - Ventral]','r046[Rhombomere 2 - Ventrolateral]','r64[Rhombomere1]','r071[Locus coeruleus]','r086[Mesencephalon]','r097[Rhombomere 2 - Ventromedial]','r102[Trigeminal motor neurons - anterior]','r108[Locus coeruleus]','r130[Torus semicircularis]','r140[Rhombomere 1,2 - Ventral]','r157[Rhombomere 2]','r162[Rhombomere 1,2 - Ventral]','r168[Corpus cerebelli]','r169[Rhombomere 2 - Dorsomedial]','r175[Eminentia granularis]'])
df_Pp['Sum'] = df_Pp.loc[:, df_Pp.columns != 'File'].sum(axis=1)
df_Po = df.filter(['File','r009[Rhombomere 3,4 - Dorso medial]','r012[Rhombomere 2-6 - Lateral neuropil]','r021[Rhombomere 4]','r043[Rhombomere 3,4 - Ventromedial]','r049[Rhombomere 3,4,5 - Ventolateral]','r055[Rhombomere 3,4 - Medial]','r073[Rhombomere 3-5 - Ventrolateral]','r077[Rhombomere 3 - Dorsolateral]','r082[Medulla oblongata - Rostrolateral domain]','r085[Medial vestibular nucleus]','r087[Mauthner neuron]','r088[Rhombomere 3]','r123[Rhombomere 3]','r154[Vestibulospinal neurons]','r167[Inferior raphe]','r171[Rhombomere 3-6 - Lateral neuropil]'])
df_Po['Sum'] = df_Po.loc[:, df_Po.columns != 'File'].sum(axis=1)
df_Pr = df.filter(['File','r004[Rhombomere 5 - Ventromedial]','r019[Tangential vestibular nucleus]','r050[Rhombomere 5 - Dorsomedial]','r059[Rhombomere 5]','r065[Rhombomere 3,4]','r070[Rhombomere 5 - Dorsal]','r081[Rhombomere 5,6 - Ventromedial]','r065[Rhombomere 3,4]','r073[Rhombomere 3-5 - Ventrolateral]','r081[Rhombomere 5,6 - Ventromedial]','r100[Rhombomere 5,6]','r109[Rhombomere 6 - Dorsomedial]','r113[Rhombomere 6,7 - Ventromedial]','r126[Rhombomere 5,6 - Dorsomedial]','r127[Rhombomere 6 - Lateral]','r141[Facial octavolateralis motor neurons]','r148[Medial vestibular nucleus]'])
df_Pr['Sum'] = df_Pr.loc[:, df_Pr.columns != 'File'].sum(axis=1)
df_Mo = df.filter(['File','r006[Rhombomere 7]','r007[Rhombomere 7 - Ventromedial]','r023[Rhombomere 6,7 - Ventrolateral]','r027[Rhombomere 6,7 - Ventrolateral]','r031[Rhombomere 7 - Ventromedial domain]','r032[Inferior olive]','r034[Rhombomere 7 - Anterior glycinergic cluster]','r036[Rhombomere 7 - Rostral]','r039[Vagus motor neurons]','r044[Rhombomere 7 - Dorsolateral]','r047[Rhombomere 6 - Dorsal glutamatergic neurons]','r056[Rhombomere 7 - Rostrolateral]','r057[Rhombomere 7 - Intermediate]','r060[Rhombomere 7 - Dorsocaudal]','r063[Rhombomere 7 - Dorsocaudal]','r067[Rhombomere 7 - Medial]','r080[Rhombomere 7]','r095[Rhombomere 7 - Dorsomedial]','r096[Rhombomere 7 - Ventromedial]','r106[Rhombomere 7]','r115[Rhombomere 7 - Ventral]','r119[Rhombomere 7 - Dorsomedial]','r121[Rhombomere 7 - Dorsomedial]','r122[Rhombomere 7 - Dorsomedial]','r132[Vagal region]','r142[Rhombomere 7 - Medial stripe]','r144[Rhombomere 7 - Rostroventral]','r145[Rhombomere 7 - Ventral]','r149[Area postrema]','r150[Rhombomere 7]','r153[Vagus motor neurons]','r156[Rhombomere 7]','r164[Rhombomere 7]','r166[Rhombomere 7 - Caudal]','r179[Posterior lateral line ganglion nerve]'])
df_Mo['Sum'] = df_Mo.loc[:, df_Mo.columns != 'File'].sum(axis=1)
df_Tg = df.filter(['File','r018[Tegmentum]','r030[Tegmentum]','r033[Interpeduncular nucleus tegmentum]','r035[Torus semicircularis]','r068[Tegmentum]','r074[TorusSemicircularis]','r079[Superior raphe]','r093[Tegmentum]','r101[Torus semicircularis]','r125[Tegmentum]','r139[Tegmentum]','r139[Tegmentum]','r143[Torus semicircularis]','r147[Tegmentum]','r160[Torus semicircularis]','r161[Tegmentum]','r173[NucMLF]'])
df_Tg['Sum'] = df_Tg.loc[:, df_Tg.columns != 'File'].sum(axis=1)
df_Sg = df.filter(['File','r014[Statoacoustic ganglion]','r029[Vagal ganglion]','r090[Statoacoustic ganglion]','r111[Anterior lateral line ganglion]','r124[Trigeminal ganglion]','r128[Trigeminal ganglion]','r159[Posterior lateral line ganglion]'])
df_Sg['Sum'] = df_Sg.loc[:, df_Sg.columns != 'File'].sum(axis=1)
df_Pt = df.filter(['File','r010[Posterior tuberculum]','r078[PosteriorTuberculum]','r110[Migrated posterior tubercular area M2]'])
df_Pt['Sum'] = df_Pt.loc[:, df_Pt.columns != 'File'].sum(axis=1)
df_Ce = df.filter(['File','r016[Eminentia granularis]','r052[Valvula cerebelli]','r094[Valvula cerebelli]','r105[Corpus cerebelli]','r131[Corpus cerebelli]','r168[Corpus cerebelli]','r174[Cerebellar neuropil]'])
df_Ce['Sum'] = df_Ce.loc[:, df_Ce.columns != 'File'].sum(axis=1)
df_Dd = df.filter(['File','r048[VentralThalamus]','r041[Habenula]','r042[Migrated pretectal area M1]','r048[VentralThalamus]','r084[Pretectum]','r099[Optic tract - AF4]','r129[Ventral thalamus]','r138[Thalamus]','r170[Pineal complex]','r178[Optic tract - AF9]',])
df_Dd['Sum'] = df_Dd.loc[:, df_Dd.columns != 'File'].sum(axis=1)

# In[13]:


# Now let's set up an Excel writer and start saving all of the different dataframes, starting with the original file
# Notice that I am also hard coding the path and file name here. We will want to modify this later also
# so that it gets the save path and name as an argument.

writer = pd.ExcelWriter('/Users/reboot/Documents/out_region_size_HB_macro.xlsx', engine = 'xlsxwriter')
df.to_excel(writer, sheet_name = 'out_region_size')
df_TeO.to_excel(writer,sheet_name = 'TeO')
df_Hyp.to_excel(writer,sheet_name = 'Hyp')
df_Pa.to_excel(writer,sheet_name = 'Pa')
df_Sp.to_excel(writer,sheet_name = 'Sp')
df_Pp.to_excel(writer,sheet_name = 'Pp')
df_Po.to_excel(writer,sheet_name = 'Po')
df_Pr.to_excel(writer,sheet_name = 'Pr')
df_Mo.to_excel(writer,sheet_name = 'Mo')
df_Tg.to_excel(writer,sheet_name = 'Tg')
df_Sg.to_excel(writer,sheet_name = 'Sg')
df_Pt.to_excel(writer,sheet_name = 'Pt')
df_Ce.to_excel(writer,sheet_name = 'Ce')
df_Dd.to_excel(writer,sheet_name = 'Dd')

writer.save()
writer.close()


# In[ ]:
