%%
% Script to combine regions from ZBB (from the Burgess lab).
% File takes in the regions file from Gupta et al. and combines
% newuroanatomical regions into functiaonlly relevant parts.
%
%%
% Get information and read in file
file = 'C:\Users\18604\Desktop\Pachon_0416_isl1_001_01_1iWarp.tif';
info = imfinfo(file);
nPlane = length(info);
width = info(1).Width;
height = info(1).Height;

data = zeros(height,width,nPlane);
hWaitbar = waitbar(0, 'Reading in data');
for i = 1:nPlane
    data(:,:,i) = imread(file,i);
    waitbar(double(i)/double(nPlane),hWaitbar,sprintf('Reading in stack %i of %i stacks',double(i),double(nPlane)));
end
delete(hWaitbar);

%%
% View orinignal file to ensure it is correct.
for i = 1:size(data,3)
    imshow(label2rgb(data(:,:,i)));
    title(sprintf('Stack # %i',i));
    drawnow;
end
close all

%%
% Transform the orginial file into a vectorized format, and generate a copy
% for space allocation for a new file
data_transform = data(:);
data_transform_new = zeros(size(data_transform));

%%
% Combine reagions.
% Rob, you'll need to finish this
% Cerebellum
data_transform_new(find(data_transform == 424 | data_transform == 387 | data_transform == 361 | data_transform == 350 | data_transform == 308 | data_transform == 272 | data_transform == 16 | data_transform == 52 | data_transform == 94 | data_transform == 105 | data_transform == 131 | data_transform == 168 | data_transform == 174)) = 3;
% Tectum NP
data_transform_new(find(data_transform == 3 | data_transform == 15 | data_transform == 40 | data_transform == 83 | data_transform == 112 | data_transform == 259 | data_transform == 271 | data_transform == 40 | data_transform == 83 | data_transform == 112)) = 4;
% Tectum SV
data_transform_new(find(data_transform == 22 | data_transform == 53 | data_transform == 89 | data_transform == 155 | data_transform == 62 | data_transform == 69 | data_transform == 116 | data_transform == 278 | data_transform == 309 | data_transform == 318 | data_transform == 325 | data_transform == 339 | data_transform == 345 | data_transform == 372 | data_transform == 411)) = 5;
% Thalamus
data_transform_new(find(data_transform == 48 | data_transform == 129 | data_transform == 138 | data_transform == 304 | data_transform == 385 | data_transform == 394)) = 6;
% Dorsal Diencephalon
data_transform_new(find(data_transform == 170 | data_transform == 178 | data_transform == 181 | data_transform == 297 | data_transform == 298 | data_transform == 340 | data_transform == 355 | data_transform == 426 | data_transform == 434 | data_transform == 437)) = 21;
% Medulla Obongata
data_transform_new(find(data_transform == 6 | data_transform == 7 | data_transform == 23 | data_transform == 27 | data_transform == 31 | data_transform == 32 | data_transform == 34 | data_transform == 36 | data_transform == 39 | data_transform == 44 | data_transform == 47 | data_transform == 56 | data_transform == 57 | data_transform == 60 | data_transform == 63 | data_transform == 67 | data_transform == 80 | data_transform == 95 | data_transform == 96 | data_transform == 106 | data_transform == 115 | data_transform == 119 | data_transform == 121 | data_transform == 122 | data_transform == 132 | data_transform == 142 | data_transform == 144 | data_transform == 145 | data_transform == 149 | data_transform == 150 | data_transform == 153 | data_transform == 156 | data_transform == 164 | data_transform == 166 | data_transform == 179 | data_transform == 262 | data_transform == 263 | data_transform == 279 | data_transform == 283 | data_transform == 287 | data_transform == 288 | data_transform == 290 | data_transform == 292 | data_transform == 295 | data_transform == 300 | data_transform == 303 | data_transform == 312 | data_transform == 313 | data_transform == 316 | data_transform == 319 | data_transform == 323 | data_transform == 336 | data_transform == 351 | data_transform == 352 | data_transform == 362 | data_transform == 371 | data_transform == 375 | data_transform == 377 | data_transform == 378 | data_transform == 388 | data_transform == 398 | data_transform == 400 | data_transform == 401 | data_transform == 405 | data_transform == 406 | data_transform == 409 | data_transform == 412 | data_transform == 420 | data_transform == 422 | data_transform == 435)) = 22;
% Pallium
data_transform_new(find(data_transform == 5 | data_transform == 37 | data_transform == 76 | data_transform == 103 | data_transform == 177 | data_transform == 180 | data_transform == 261 | data_transform == 293 | data_transform == 332 | data_transform == 359 | data_transform == 433 | data_transform == 436)) = 1;
% Pons
data_transform_new(find(data_transform == 9 | data_transform == 12 | data_transform == 21 | data_transform == 43 | data_transform == 49 | data_transform == 55 | data_transform == 73 | data_transform == 77 | data_transform == 82 | data_transform == 85 | data_transform == 87 | data_transform == 88 | data_transform == 123 | data_transform == 154 | data_transform == 171 | data_transform == 265 | data_transform == 268 | data_transform == 277 | data_transform == 299 | data_transform == 305 | data_transform == 311 | data_transform == 329 | data_transform == 333 | data_transform == 338 | data_transform == 341 | data_transform == 343 | data_transform == 344 | data_transform == 379 | data_transform == 410 | data_transform == 427)) = 10;
% Prepontine
data_transform_new(find(data_transform == 28 | data_transform == 46 | data_transform == 64 | data_transform == 86 | data_transform == 97 | data_transform == 102 | data_transform == 140 | data_transform == 157 | data_transform == 162 | data_transform == 169 | data_transform == 175 | data_transform == 284 | data_transform == 302 | data_transform == 320 | data_transform == 342 | data_transform == 353 | data_transform == 358 | data_transform == 396 | data_transform == 413 | data_transform == 418 | data_transform == 425 | data_transform == 431)) = 11;
% Reticulopontine
data_transform_new(find(data_transform == 4 | data_transform == 19 | data_transform == 50 | data_transform == 59 | data_transform == 65 | data_transform == 70 | data_transform == 81 | data_transform == 100 | data_transform == 109 | data_transform == 113 | data_transform == 126 | data_transform == 127 | data_transform == 141 | data_transform == 148 | data_transform == 260 | data_transform == 275 | data_transform == 306 | data_transform == 315 | data_transform == 321 | data_transform == 326 | data_transform == 337 | data_transform == 356 | data_transform == 365 | data_transform == 369 | data_transform == 382 | data_transform == 383 | data_transform == 397 | data_transform == 404)) = 12;
% Preoptic Area
data_transform_new(find(data_transform == 61 | data_transform == 104 | data_transform == 172 | data_transform == 38 |data_transform == 317 | data_transform == 360 | data_transform == 428 | data_transform == 294)) = 17;
% Rostral Hypothalamus
data_transform_new(find(data_transform == 11 | data_transform == 98 | data_transform == 152 | data_transform == 176 | data_transform == 267 | data_transform == 354 | data_transform == 408 | data_transform == 432)) = 7;
% Intermediate Hypothalamus
data_transform_new(find(data_transform == 1 | data_transform == 8 | data_transform == 20 | data_transform == 25 | data_transform == 54 | data_transform == 120 | data_transform == 135 | data_transform == 257 | data_transform == 264 | data_transform == 276 | data_transform == 281 |data_transform == 310 | data_transform == 376 | data_transform == 391)) = 8;
% Caudal Hypothalamus
data_transform_new(find(data_transform == 58 | data_transform == 314 | data_transform == 107 | data_transform == 363)) = 9;
% Optic Chiasm
data_transform_new(find(data_transform == 146 | data_transform == 163 | data_transform == 402 | data_transform == 419)) = 19;
% PTadjacent
data_transform_new(find(data_transform == 24 | data_transform == 110 | data_transform == 280 | data_transform == 366)) = 18;
% Pituitary
data_transform_new(find(data_transform == 66 | data_transform == 322)) = 26;
% Posterior Commisure
data_transform_new(find(data_transform == 118 | data_transform == 374)) = 20;
% Posterior Tuberculum
data_transform_new(find(data_transform == 10 | data_transform == 78 | data_transform == 266 | data_transform == 334)) = 13;
% Statoacoustic Ganglion
data_transform_new(find(data_transform == 14 | data_transform == 29 | data_transform == 90 | data_transform == 111 | data_transform == 124 | data_transform == 128 | data_transform == 159 | data_transform == 270 | data_transform == 285 | data_transform == 346 | data_transform == 367 | data_transform == 380 | data_transform == 384 | data_transform == 415)) = 14;
% Subpallium
data_transform_new(find(data_transform == 26 | data_transform == 75 | data_transform == 137 | data_transform == 282 | data_transform == 331 | data_transform == 393)) = 2;
% Tegmentum
data_transform_new(find(data_transform == 33 | data_transform == 68 | data_transform == 93 | data_transform == 125 | data_transform == 139 | data_transform == 147 | data_transform == 161 | data_transform == 274 | data_transform == 286 | data_transform == 289 | data_transform == 291 | data_transform == 324 | data_transform == 335 | data_transform == 349 | data_transform == 381 | data_transform == 395 | data_transform == 403 | data_transform == 417)) = 15;
% Locus Coeruleus
data_transform_new(find(data_transform == 71 | data_transform == 108 | data_transform == 327 | data_transform == 364)) = 16;
% Torus Semicircularis
data_transform_new(find(data_transform == 35 | data_transform == 74 | data_transform == 101 | data_transform == 143 | data_transform == 160 | data_transform == 330 | data_transform == 357 | data_transform == 399 | data_transform == 416 | data_transform == 130 | data_transform == 386)) = 25;
% Raphe Nucleus
data_transform_new(find(data_transform == 79 | data_transform == 167 | data_transform == 423 | data_transform == 335)) = 23;
% Nucleus MLF
data_transform_new(find(data_transform == 173 | data_transform == 429)) = 26;
%%
% Transform the data to dimensions that fit the original
data_transform_new = reshape(data_transform_new, size(data));

%%
% View the new 'regions'
for i = 1:size(data_transform_new,3)
    imshow(label2rgb(data_transform_new(:,:,i)));
    title(sprintf('Stack # %i',i));
    drawnow;
end
close all

%%
% Save to disk
write_file_path = 'C:\Users\18604\Desktop\Pachon_0416_isl1_001_01_1iWarp_26regions.tif';
hWaitbar = waitbar(0,'Writing file to disk');
for i = 1:size(data_transform_new,3)
    imwrite(uint16(data_transform_new(:,:,i)),write_file_path,'WriteMode','append');
    waitbar(double(i)/double(size(data_transform_new,3)),hWaitbar,sprintf('Writing stack %i of %i stacks',double(i),double(size(data_transform_new,3))));
end
delete(hWaitbar)
