function output = CrossCorrReg2(file1,file2,NUMBER_OF_PLANES)    %%

    info = imfinfo(file1);


    %%
    %   Load data
    data1 = zeros(info(1).Height,info(1).Width, NUMBER_OF_PLANES);
    data2 = zeros(info(1).Height,info(1).Width, NUMBER_OF_PLANES);

    % Import data 1
    hWaitbar1 = waitbar(0,'Loading data');
    for i = 1:NUMBER_OF_PLANES
        data1(:,:,i) = imread(strcat(file1),i);
        waitbar(double(i)/double(NUMBER_OF_PLANES),hWaitbar1,sprintf('Loading plane %i out of %i frames',i,NUMBER_OF_PLANES));
    end
    delete(hWaitbar1)

    % Import data 2
    hWaitbar2 = waitbar(0,'Loading data');
    for i = 1:NUMBER_OF_PLANES
        data2(:,:,i) = imread(file2,i);
        waitbar(double(i)/double(NUMBER_OF_PLANES),hWaitbar2,sprintf('Loading plane %i out of %i frames',i,NUMBER_OF_PLANES));
    end
    delete(hWaitbar2)

    output = corr(data1(:),data2(:));
end