#!/bin/sh
#ANTS
cd "/mnt/beegfs/home/rkozol/ANTS/ANTs20"

module load ITK/MASTER
module load ANTs/2.3.4
export ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS=20

antsRegistration --verbose 1 --dimensionality 3 --float 1 --output [/mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_,/mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009.nii.gz] --interpolation WelchWindowedSinc -u 0 -r [/mnt/beegfs/home/rkozol/ANTS/ANTs20/ref/SFrefbrainDS.nii.gz,/mnt/beegfs/home/rkozol/ANTS/ANTs20/refx/SfPaF2009.nii.gz,1] -t rigid[0.1] --metric MI[/mnt/beegfs/home/rkozol/ANTS/ANTs20/ref/SFrefbrainDS.nii.gz,/mnt/beegfs/home/rkozol/ANTS/ANTs20/refx/SfPaF2009.nii.gz,1,32,Regular,0.25] --convergence [200x200x200x0,1e-8,10] --shrink-factors 12x8x4x2 --smoothing-sigmas 4x3x2x1vox --transform Affine[0.1] --metric MI[/mnt/beegfs/home/rkozol/ANTS/ANTs20/ref/SFrefbrainDS.nii.gz,/mnt/beegfs/home/rkozol/ANTS/ANTs20/refx/SfPaF2009.nii.gz,1,32,Regular,0.25] --convergence [200x200x200x0,1e-8,10] --shrink-factors 12x8x4x2 --smoothing-sigmas 4x3x2x1vox --transform SyN[0.1,6,0] --metric CC[/mnt/beegfs/home/rkozol/ANTS/ANTs20/ref/SFrefbrainDS.nii.gz,/mnt/beegfs/home/rkozol/ANTS/ANTs20/refx/SfPaF2009.nii.gz,1,2] --convergence [200x200x200x200x10,1e-7,10] --shrink-factors 12x8x4x2x1 --smoothing-sigmas 4x3x2x1x0vox

antsApplyTransforms -d 3 -v 0 --float -n WelchWindowedSinc -i /mnt/beegfs/home/rkozol/ANTS/ANTs20/refx//SfPaF2009.nii.gz -r /mnt/beegfs/home/rkozol/ANTS/ANTs20/ref/SFrefbrainDS.nii.gz -o /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009.nii.gz -t /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_1Warp.nii.gz -t /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_0GenericAffine.mat

antsApplyTransforms -d 3 -v 0 --float -n MultiLabel -i /mnt/beegfs/home/rkozol/ANTS/ANTs20/regions/SFrefbrain_Sp2.nii.gz -r /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009.nii.gz -o /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_1iWarp.nii.gz -t [/mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_0GenericAffine.mat] -t /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_1InverseWarp.nii.gz

CreateJacobianDeterminantImage 3 /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_1InverseWarp.nii.gz /mnt/beegfs/home/rkozol/ANTS/ANTs20/output/SfPaF2009_ljd.nii.gz 1
