% fig1 = figure (1);
% fig2 = figure (2);
% fig3 = figure (3);
fig4 = figure (4);
fig5 = figure (5);
fig6 = figure (6);
fig7 = figure (7);

for z = 1:8
    clearvars -except fig4 fig5 fig6 fig7 
    load(uigetfile('*.mat','Select a PIV variable .mat file'));
    MigDir = input("Migration Direction?");
    
    allx = cell(144,1);
    ally = cell(144,1);
    allq = cell(144,1);
    order = cell(144,1);
    vectoranglemod = cell(144,1);
    velocity = cell(144,1);
    speed = cell(144,1);
    order_avgpertime = cell(8,1);
    v_avgpertime = cell(8,1);
    s_avgpertime = cell(8,1);
    backtrack_pertime=cell(8,1);
    backtrack = cell(144,1);
    numvectors=cell(8,1);
    sumU = zeros(144,1);
    sumV = zeros(144,1);
    principalSpeed = cell(144,1);
    principalAng = cell(144,1);
    
    for i = 1:144
        allx(i,1)= {zeros(128,172)};
        ally(i,1)= {zeros(128,172)};
        allq(i,1)= {zeros(128,172)};
        order(i,1)={zeros(128,172)};
        vectoranglemod(i,1)={zeros(128,172)};
        velocity(i,1)={zeros(128,172)};
        speed(i,1)={zeros(128,172)};
        backtrack(i,1)={zeros(128,172)};
    end
    
    for i = 1:144
        for j = 1:128
            for k = 1:172
                if isnan(v_original{i,1}(j,k))
                    vectoranglemod{i,1}(j,k) = nan;
                    velocity{i,1}(j,k) = nan;
                    speed{i,1}(j,k) = nan;
                    order{i,1}(j,k) = nan;
                    velWeightedOrder{i,1}(j,k) = nan;
                    backtrack{i,1}(j,k) = nan;
                else
                    %orient u and v axes - if D and R are positive by
                    %default
                    if MigDir == "L" || MigDir == "DL" %left or down-left
                        u_filtered{i,1}(j,k) = -u_filtered{i,1}(j,k);
                    elseif MigDir == "U" || MigDir == "U+R" % up
                        vtemp = v_filtered{i,1}(j,k);
                        utemp = u_filtered{i,1}(j,k);
                        u_filtered{i,1}(j,k) = -vtemp;
                        v_filtered{i,1}(j,k) = utemp;
                    elseif MigDir == "D" || MigDir == "D+R" % down
                        vtemp = v_filtered{i,1}(j,k);
                        utemp = u_filtered{i,1}(j,k);
                        u_filtered{i,1}(j,k) = vtemp;
                        v_filtered{i,1}(j,k) = utemp;
                    elseif MigDir == "UR" % up-right
                        v_filtered{i,1}(j,k) = -v_filtered{i,1}(j,k);
                    elseif MigDir == "UL" % up-left no flip uv
                        u_filtered{i,1}(j,k) = -u_filtered{i,1}(j,k);
                        v_filtered{i,1}(j,k) = -v_filtered{i,1}(j,k);
                    elseif MigDir == "U+L" % up-left w/ flip uv
                        vtemp = v_filtered{i,1}(j,k);
                        utemp = u_filtered{i,1}(j,k);
                        u_filtered{i,1}(j,k) = -vtemp;
                        v_filtered{i,1}(j,k) = -utemp;
                    elseif MigDir == "D+L" % down-left w/ flip uv
                        vtemp = v_filtered{i,1}(j,k);
                        utemp = u_filtered{i,1}(j,k);
                        u_filtered{i,1}(j,k) = vtemp;
                        v_filtered{i,1}(j,k) = -utemp;
                    end
                    sumU(i,1) = u_filtered{i,1}(j,k)+sumU(i,1);
                    sumV(i,1) = v_filtered{i,1}(j,k)+sumV(i,1);
                    vectoranglemod{i,1}(j,k) = atand(v_filtered{i,1}(j,k)/u_filtered{i,1}(j,k));
                    speed{i,1}(j,k) = sqrt((v_filtered{i,1}(j,k)^2)+(u_filtered{i,1}(j,k)^2));
                end
            end
        end
        principalSpeed{i,1} = sqrt((sumU(i,1)^2)+(sumV(i,1)^2));
    end
    
    sumAng48 = 0;
    sumU48 = 0;
    sumV48 = 0;
    for i = 1:48
        principalAng{i,1} = mean2(vectoranglemod{i,1}(~isnan(vectoranglemod{i,1})));
        sumAng48 = principalAng{i,1}+sumAng48;
        sumU48 = sumU(i,1)+sumU48;
        sumV48 = sumV(i,1)+sumV48;
    end    
    
    Ang48 = sumAng48/48;
    U48 = sumU48/48;
    V48 = sumV48/48;
    principalSpeed48 = sqrt(U48^2+V48^2);
    
    for i = 1:144
        for j = 1:128
            for k = 1:172
                if (~isnan(vectoranglemod{i,1}(j,k)))
                    order{i,1}(j,k)= abs(cosd(vectoranglemod{i,1}(j,k)-Ang48));
                    if u_filtered{i,1}(j,k) < 0
                        velocity{i,1}(j,k) = -1*speed{i,1}(j,k);
                        backtrack{i,1}(j,k) = 1;
                        order{i,1}(j,k) = -order{i,1}(j,k);
                    else
                        velocity{i,1}(j,k) = speed{i,1}(j,k);
                        backtrack{i,1}(j,k)= 0;
                    end                    
                end
            end
        end
    end
    
    
    for i = 1:144
        numvectors=nnz(~isnan(backtrack{i,1}));
        backtrack_pertime{i,1}=100*nansum(backtrack{i,1},'all')/numvectors;
        order_avgpertime{i,1} = mean2(order{i,1}(~isnan(order{i,1})));
        v_avgpertime{i,1} = (60*.645/10)*mean2(velocity{i,1}(~isnan(velocity{i,1})));
        s_avgpertime{i,1} = (60*.645/10)*mean2(speed{i,1}(~isnan(speed{i,1})));
    end


    set(0, 'CurrentFigure', fig4)
    A = smoothdata(cell2mat(v_avgpertime),'movmean',20);
    plot(linspace(0,24,144),A);
    hold on;
    set(0, 'CurrentFigure', fig5)
    B = smoothdata(cell2mat(order_avgpertime), 'movmean', 20);
    plot(linspace(0,24,144),B);
    hold on;
    set(0, 'CurrentFigure', fig6)
    C = smoothdata(cell2mat(backtrack_pertime),'movmean',20);
    plot(linspace(0,24,144),C);
    hold on;
    set(0,'CurrentFigure', fig7)
    D = smoothdata(cell2mat(s_avgpertime),'movmean',20);
    plot(linspace(0,24,144),D);
    hold on;
end
condition = 'remove 1-23-22 2 kPa + LMB';

set(0, 'CurrentFigure', fig4)
axObjs = fig4.Children;
dataObjs = axObjs.Children;
alldata_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        alldata_pertime(z,i) = dataObjs(z).YData(i);
    end
end
alldata_mean = mean(alldata_pertime,1);
alldata_stddev = std(alldata_pertime,0,1)/sqrt(length(alldata_pertime(:,1)));
curve1 = alldata_mean + alldata_stddev;
curve2 =  alldata_mean - alldata_stddev;
x2 = [dataObjs(1).XData, fliplr(dataObjs(1).XData)];
inBetween = [curve1, fliplr(curve2)];
figavg = figure (8);
g=fill(x2, inBetween, [ 0    0.4471    0.7412]);
alpha(g,0.5);
hold on;
plot(linspace(0,24,144), alldata_mean, 'k', 'LineWidth', 2);
xlabel('Time (h)','fontweight','bold','fontsize',12);
xlim([0 24])
ylabel('Velocity (um/h)','fontweight','bold','fontsize',12);
ylim([0 50])
saveas(figavg,strcat(condition, 'VoverTime.fig'));
saveas(figavg,strcat(condition, 'VoverTime.jpg'));

set(0, 'CurrentFigure', fig7)
axObjs = fig7.Children;
dataObjs = axObjs.Children;
alldata_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        alldata_pertime(z,i) = dataObjs(z).YData(i);
    end
end
alldata_mean = mean(alldata_pertime,1);
alldata_stddev = std(alldata_pertime,0,1)/sqrt(length(alldata_pertime(:,1)));
curve1 = alldata_mean + alldata_stddev;
curve2 =  alldata_mean - alldata_stddev;
x2 = [dataObjs(1).XData, fliplr(dataObjs(1).XData)];
inBetween = [curve1, fliplr(curve2)];
figavg = figure (9);
g=fill(x2, inBetween, [ 0    0.4471    0.7412]);
alpha(g,0.5);
hold on;
plot(linspace(0,24,144), alldata_mean, 'k', 'LineWidth', 2);
xlabel('Time (h)','fontweight','bold','fontsize',12);
xlim([0 24])
ylabel('Speed (um/h)','fontweight','bold','fontsize',12);
ylim([0 50])
saveas(figavg,strcat(condition, 'SoverTime.fig'));
saveas(figavg,strcat(condition, 'SoverTime.jpg'));

set(0, 'CurrentFigure', fig5)
axObjs = fig5.Children;
dataObjs = axObjs.Children;
alldata_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        alldata_pertime(z,i) = dataObjs(z).YData(i);
    end
end
alldata_mean = mean(alldata_pertime,1);
alldata_stddev = std(alldata_pertime,0,1)/sqrt(length(alldata_pertime(:,1)));
curve1 = alldata_mean + alldata_stddev;
curve2 =  alldata_mean - alldata_stddev;
x2 = [dataObjs(1).XData, fliplr(dataObjs(1).XData)];
inBetween = [curve1, fliplr(curve2)];
figavg = figure (10);
g=fill(x2, inBetween, [ 0    0.4471    0.7412]);
alpha(g,0.5);
hold on;
plot(linspace(0,24,144), alldata_mean, 'k', 'LineWidth', 2);
xlabel('Time (h)','fontweight','bold','fontsize',12);
xlim([0 24])
ylabel('Order (um/h)','fontweight','bold','fontsize',12);
ylim([0 1])
saveas(figavg,strcat(condition, 'OrderoverTime.fig'));
saveas(figavg,strcat(condition, 'OrderoverTime.jpg'));

set(0, 'CurrentFigure', fig6)
axObjs = fig6.Children;
dataObjs = axObjs.Children;
alldata_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        alldata_pertime(z,i) = dataObjs(z).YData(i);
    end
end
alldata_mean = mean(alldata_pertime,1);
alldata_stddev = std(alldata_pertime,0,1)/sqrt(length(alldata_pertime(:,1)));
curve1 = alldata_mean + alldata_stddev;
curve2 =  alldata_mean - alldata_stddev;
x2 = [dataObjs(1).XData, fliplr(dataObjs(1).XData)];
inBetween = [curve1, fliplr(curve2)];
figavg = figure (11);
g=fill(x2, inBetween, [ 0    0.4471    0.7412]);
alpha(g,0.5);
hold on;
plot(linspace(0,24,144), alldata_mean, 'k', 'LineWidth', 2);
xlabel('Time (h)','fontweight','bold','fontsize',12);
xlim([0 24])
ylabel('% Backtracking Vectors (um/h)','fontweight','bold','fontsize',12);
ylim([0 20])
saveas(figavg,strcat(condition, 'BToverTime.fig'));
saveas(figavg,strcat(condition, 'BToverTime.jpg'));


set(0, 'CurrentFigure', fig4)
axObjs = fig4.Children;
dataObjs = axObjs.Children;
allvel_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        allvel_pertime(z,i) = dataObjs(z).YData(i);
    end
end
for i = 1:z
    L12mean(i) = mean(allvel_pertime(i,73:144),'all'); % change me!
end
BigMean = mean(L12mean);
L12_stddev = BigMean/sqrt(z);
fig4L12avg = figure (12);
bar(BigMean, 'k', 'LineWidth', 2);
hold on;
f = errorbar(BigMean,L12_stddev);
f.MarkerSize = 10;
f.Color = 'black';
ylabel('12-24 h Average Velocity (um/h)','fontweight','bold','fontsize',12);
ylim([0 50])
set(gca,'xtick',[])
saveas(fig4L12avg,strcat(condition, 'avgvL12.fig'));
saveas(fig4L12avg,strcat(condition, 'avgvL12.jpg'));

set(0, 'CurrentFigure', fig5)
axObjs = fig5.Children;
dataObjs = axObjs.Children;
allOP_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        allOP_pertime(z,i) = dataObjs(z).YData(i);
    end
end
for i = 1:z
    L12mean(i) = mean(allOP_pertime(i,73:144),'all'); % change me!
end
BigMean = mean(L12mean);
L12_stddev = BigMean/sqrt(z);
fig5L12avg = figure (13);
bar(BigMean, 'k', 'LineWidth', 2);
hold on;
f = errorbar(BigMean,L12_stddev);
f.MarkerSize = 10;
f.Color = 'black';
ylabel('12-24 h Average Order Parameter','fontweight','bold','fontsize',12);
ylim([-.2 1.1])
set(gca,'xtick',[])
saveas(fig5L12avg,strcat(condition, 'avgOPL12.fig'));
saveas(fig5L12avg,strcat(condition, 'avgOPL12.jpg'));

set(0, 'CurrentFigure', fig6)
axObjs = fig6.Children;
dataObjs = axObjs.Children;
allBT_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        allBT_pertime(z,i) = dataObjs(z).YData(i);
    end
end
for i = 1:z
    L12mean(i) = mean(allBT_pertime(i,73:144),'all'); % change me!
end
BigMean = mean(L12mean);
L12_stddev = BigMean/sqrt(z);
fig6L12avg = figure (14);
bar(BigMean, 'k', 'LineWidth', 2);
hold on;
f = errorbar(BigMean,L12_stddev);
f.MarkerSize = 10;
f.Color = 'black';
ylabel('12-24 h Average % Backtracking Vectors','fontweight','bold','fontsize',12);
ylim([0 35])
set(gca,'xtick',[])
saveas(fig6L12avg,strcat(condition, 'avgBTL12.fig'));
saveas(fig6L12avg,strcat(condition, 'avgBTL12.jpg'));

set(0, 'CurrentFigure', fig7)
axObjs = fig7.Children;
dataObjs = axObjs.Children;
alls_pertime = zeros(length(dataObjs),144);
for z = 1:length(dataObjs)
    for i = 1:144
        alls_pertime(z,i) = dataObjs(z).YData(i);
    end
end
for i = 1:z
    L12mean(i) = mean(alls_pertime(i,73:144),'all'); % change me!
end
BigMean = mean(L12mean);
L12_stddev = BigMean/sqrt(z);
fig7L12avg = figure (15);
bar(BigMean, 'k', 'LineWidth', 2);
hold on;
f = errorbar(BigMean,L12_stddev);
f.MarkerSize = 10;
f.Color = 'black';
ylabel('12-24 h Average Speed','fontweight','bold','fontsize',12);
ylim([0 60])
set(gca,'xtick',[])
saveas(fig6L12avg,strcat(condition, 'avgsL12.fig'));
saveas(fig6L12avg,strcat(condition, 'avgsL12.jpg'));