load Comm_data 

%         PA   Strep Prev Staph
% Strep [0.08; 0.50; 0.17; 0.017]
% PA D  [0.78; 0.04; 0.08; 0.03]
% PA M1 [0.55; 0.14; 0.10; 0.01]
% PA M2 [0.67; 0.027; 0.10; 0.025]


Map=zeros(length(indCom.Mcom),4);

M1_ex=sum(abs(M1.EXflux),2)/2;
M2_ex=sum(abs(M2.EXflux),2)/2;
PA_ex=sum(abs(PA_dom.EXflux),2)/2;
Strep_ex=sum(abs(Strep_dom.EXflux),2)/2;

[bla,ind]=sort(PA_ex,'descend');

Map(:,1)=PA_ex(ind);
Map(:,3)=M1_ex(ind);
Map(:,2)=M2_ex(ind);
Map(:,4)=Strep_ex(ind);

names=modelCom.metNames(indCom.Mcom);
names=names(ind);

e=find(sum(Map,2)/4>0.1);
Map=Map(e,:);
names=names(e);

Map_log=log10(Map);

imagesc(Map_log)
%caxis([-2 2])

set(gca,'XTick',[1 2 3 4]);
set(gca,'XTickLabel',{'PA D.','M2','M1','Strep D.'});
set(gca,'XAxisLocation','top')
set(gca,'YTick',[1:length(Map)]);
set(gca,'YTickLabel',names);

ax=gca;
ax.XAxis.FontSize = 20;

caxis([-1 1])
h=colorbar;
h.Ticks=[-1:1];
%h.TickLabels={'0.0001','0.001','0.01','0.1','1','10'};
h.TickLabels={'0.1','1','10'};
h.FontSize=12;
h.Label.String='Metabolite flux (mmol gDW^{−1} hr^{−1})';
h.Label.FontSize=15;


