%%
% Written by Jinyeop Song, 2020/07/20
% This is the demo code for Antibody_ThermoCalc_JY.
% To run the code, follow the description of each sections.
clc; clear;

% To change
addpath(genpath('D:\JY_matlab\210601_Antibody_v2\210601_Antibody_v2')) % Add the entire path of Antibody_ThermoCalc_JY
cmap=0.85*hsv(5);
Project_title_ = "Fig4_extended";
Project_title = Project_title_;


%% binding %
cd(Project_title+'_')
load(Project_title+"_\data.mat")
Project_title = Project_title_;
figure('Renderer', 'painters', 'Position', [10 10 700 600])
Legend=[];
k=0;
excel=[];

for idx=1:5
    k=k+1;
    NN_list=[1,2,3,6,8]
    aa_list=["\sigma=0.5","\sigma=1.0","\sigma=1.5","\sigma=3.0","\sigma=4.0"]
    NN=NN_list(idx)
    color_idx=0;

    %load(datapath)
    color_idx=color_idx+1;
    X=Kd2_list;
    Y=mean(ProbS(NN,1,:,:),4)./Tnum_List(NN);
    Z=std(ProbS(NN,1,:,:),0,4)./Tnum_List(NN);
    semilogx(X,Y(:),'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:),'Linewidth', 3)
    dataname=aa_list(idx)% Change dataname
    Legend=[Legend dataname];
    hold on;
    %mean(ProbS(j, 2:size(Kd2_list,2),:),3)/Tnum,'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:))
    excel=[excel [X(:) Y(:) Z(:)]];


end 
xl = xlim;
X=linspace(xl(1),xl(2),size(X,2));
Y=0.1+0*X;
semilogx(X,Y,'--')
hold on;
dataname="control(no tether)"
Legend=[Legend dataname];
hold on;
excel=[excel [X(:) Y(:)]];


title(["1"])
xlabel("$Kd_{2}$",'Interpreter','latex')
ylabel("$\frac{N_{bound}}{N_{total}}$",'Interpreter','latex')
ylim([0 1])
xlim([10^-11 10^-5])
set(gca, 'XDir','reverse')



    
saveas(gcf,['figure_random_' '.fig']);
export_fig(['figure_random_' '.tif'],'-m5.0','-transparent')
legend(Legend) %"Control" "Self Cohesion" ], 'Location','northeast')
export_fig(['figure_random_' '_legend.tif'],'-m5.0','-transparent')
writematrix(excel,'figure_random.xls')

cd ..

%% kdeff %
cd(Project_title+'_')
load(Project_title+"_\data.mat")
Project_title = Project_title_;
figure('Renderer', 'painters', 'Position', [10 10 700 600])
Legend=[];
excel=[];

k=0;
for idx=1:5
    k=k+1;
    NN_list=[1,2,3,6,8]
    aa_list=["\sigma=0.5","\sigma=1.0","\sigma=1.5","\sigma=3.0","\sigma=4.0"]
    NN=NN_list(idx)
    color_idx=0;

    %load(datapath)
    color_idx=color_idx+1;
    X=Kd2_list;
    Y=mean(ProbS(NN,1,:,:),4)./Tnum_List(NN);
    Z=std(ProbS(NN,1,:,:),0,4)./Tnum_List(NN);
    Z=pA*(Z)./Y+pA*(1-Y)./Y./Y.*Z
    Y=pA*(1-Y)./(Y)
    
    loglog(X,Y(:),'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:),'Linewidth', 3)
    dataname=aa_list(idx)% Change dataname
    Legend=[Legend dataname];
    hold on;
    %mean(ProbS(j, 2:size(Kd2_list,2),:),3)/Tnum,'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:))
    excel=[excel [X(:) Y(:) Z(:)]];


end 
xl = xlim;
X=linspace(xl(1),xl(2),size(X,2));
Y=10^-8+0*X;
semilogx(X,Y,'--')
hold on;
dataname="control(no tether)"
Legend=[Legend dataname];
hold on;
excel=[excel [X(:) Y(:)]];



title(["2"])
xlabel("$p_{tethering}$",'Interpreter','latex')
ylabel("Kd_{eff}")
xlim([10^-8 10^1])
ylim([10^-11.5 10^-7.5])
set(gca, 'XDir','reverse')
set(gca, 'YDir','reverse')


saveas(gcf,['figure_random_Kd' '.fig']);
export_fig(['figure_random_Kd' '.tif'],'-m5.0','-transparent')
legend(Legend) %"Control" "Self Cohesion" ], 'Location','northeast')
export_fig(['figure_random_Kd' '_legend.tif'],'-m5.0','-transparent')
writematrix(excel,'figure_random_Kd.xls')

cd ..

%%
% %% binding %
% cmap=0.85*hsv(9);
% cd(Project_title+'_')
% load(Project_title+"_\data.mat")
% Project_title = Project_title_;
% figure('Renderer', 'painters', 'Position', [10 10 700 600])
% Legend=[];
% k=0;
% for idx=1:8
%     k=k+1;
%     NN_list=1:8
%     aa_list=density_List
%     NN=NN_list(idx)
%     color_idx=0;
% 
%     %load(datapath)
%     p_tethering=1./Kd2_eff_list
%     color_idx=color_idx+1;
%     X=p_tethering;
%     Y=mean(ProbS(NN,1,:,:),4)./Tnum_List(idx);
%     semilogx(X,Y(:),'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:),'Linewidth', 3)
%     dataname=sprintf("density: %.1f",(aa_list(idx)))% Change dataname
%     Legend=[Legend dataname];
%     hold on;
%     %mean(ProbS(j, 2:size(Kd2_list,2),:),3)/Tnum,'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:))
% 
% 
% end 
% xl = xlim;
% X=linspace(xl(1),xl(2),1000);
% Y=0.1+0*X;
% semilogx(X,Y,'--')
% hold on;
% dataname="control(no tether)"
% Legend=[Legend dataname];
% hold on;
% 
% title(["1"])
% xlabel("$p_{tethering}$",'Interpreter','latex')
% ylabel("$\frac{N_{bound}}{N_{total}}$",'Interpreter','latex')
% ylim([0 1])
% xlim([10^-2 10^4])
% 
% 
%     
% saveas(gcf,['figure_random_all' '.fig']);
% export_fig(['figure_random_all' '.tif'],'-m5.0','-transparent')
% legend(Legend) %"Control" "Self Cohesion" ], 'Location','northeast')
% export_fig(['figure_random_all' '_legend.tif'],'-m5.0','-transparent')
% 
% cd ..
% 
% %% kdeff %
% cmap=0.85*hsv(9);
% %% binding %
% cd(Project_title+'_')
% load(Project_title+"_\data.mat")
% Project_title = Project_title_;
% figure('Renderer', 'painters', 'Position', [10 10 700 600])
% Legend=[];
% k=0;
% for idx=1:8
%     k=k+1;
%     NN_list=1:8
%     aa_list=density_List
%     NN=NN_list(idx)
%     color_idx=0;
% 
%     %load(datapath)
%     p_tethering=1./Kd2_eff_list
%     color_idx=color_idx+1;
%     X=p_tethering;
%     Y=mean(ProbS(NN,1,:,:),4)./Tnum_List(idx);
%     Y=pA*(1-Y)./(Y)
%     loglog(X,Y(:),'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:),'Linewidth', 3)
%     dataname=sprintf("density: %.1f",(aa_list(idx)))% Change dataname
%     Legend=[Legend dataname];
%     hold on;
%     %mean(ProbS(j, 2:size(Kd2_list,2),:),3)/Tnum,'-o','Color',cmap(k,:),'MarkerEdgeColor',cmap(k,:))
% 
% 
% end 
% xl = xlim;
% X=linspace(xl(1),xl(2),1000);
% Y=10^-8+0*X;
% semilogx(X,Y,'--')
% hold on;
% dataname="control(no tether)"
% Legend=[Legend dataname];
% hold on;
% 
% title(["2"])
% xlabel("$p_{tethering}$",'Interpreter','latex')
% ylabel("Kd_{eff}")
% xlim([10^-2 10^4])
% ylim([10^-11.5 10^-7.5])
% set(gca, 'YDir','reverse')
% 
% 
% saveas(gcf,['figure_random_Kd_all' '.fig']);
% export_fig(['figure_random_Kd_all' '.tif'],'-m5.0','-transparent')
% legend(Legend) %"Control" "Self Cohesion" ], 'Location','northeast')
% export_fig(['figure_random_Kd_all' '_legend.tif'],'-m5.0','-transparent')
% 
% cd ..



