%%
% Written by Jinyeop Song, 2020/07/20
% This is the demo code for Antibody_ThermoCalc_JY.
% To run the code, follow the description of each sections.
clc; clear;

% To change
addpath(genpath('D:\JY_matlab\210601_Antibody_v2\210601_Antibody_v2')) % Add the entire path of Antibody_ThermoCalc_JY
cmap=0.85*hsv(5);
Project_title_ = "Fig_supple2_uniformdistribution";
Project_title = Project_title_;


%% binding %
cd(Project_title+'_')
Project_title = Project_title_;
k=0;
excel=[D_BS_list ;result_uniform]

writematrix(excel','UniformDistribution_test.xls')

cd ..


%%
D_Linker_list=[7];
D_BS_list=linspace(5,14,9);
result_uniform=zeros(size(D_Linker_list,2),size(D_BS_list,2))
result_WLC=zeros(size(D_Linker_list,2),size(D_BS_list,2))
result_uniform_2=zeros(size(D_Linker_list,2),size(D_BS_list,2))

for i=1:size(D_Linker_list,2)
    for j=1:size(D_BS_list,2)
        D_BS=D_BS_list(j); %nm
        D_Linker=D_Linker_list(i); %nm
        resolution=0.2;
        N_avogadro=6.02*10^23;
        r_p=0.4;

        % uniform distributrion
        x=-D_Linker:resolution:D_Linker+D_BS;
        y=-D_Linker:resolution:D_Linker;
        z=-D_Linker:resolution:D_Linker;
        [X,Y,Z] = meshgrid(x,y,z);
        r=sqrt(X.^2+Y.^2+Z.^2);
        func=@(x) p_uniform(x,D_Linker);
        p1=arrayfun(func,r);
        p1=p1/sum(p1(:));
        r=sqrt((X-D_BS).^2+Y.^2+Z.^2);
        func=@(x) p_uniform(x,D_Linker);
        p2=arrayfun(func,r);
        p2=p2/sum(p2(:));
        p12=p1.*p2;
        disp(sum(p12(:))*resolution^3);
        overlap=sum(p12(:))/resolution^3*(10^-27)*(10^27*10^-3/N_avogadro)^2;
        Kd2=10^-8;
        Kd2_eff=Kd2/overlap/N_avogadro;
        probability_catenating=1/Kd2_eff;
        disp(Kd2_eff)
        disp("catenating prob, uniform")
        result_uniform(i,j)=overlap*N_avogadro;
        hold on

                %
        x=-D_Linker:resolution:D_Linker+D_BS;
        y=-D_Linker:resolution:D_Linker;
        z=-D_Linker:resolution:D_Linker;
        [X,Y,Z] = meshgrid(x,y,z);
        r=sqrt(X.^2+Y.^2+Z.^2);
        func=@(x) p_uniform(x,D_Linker);
        p1=arrayfun(func,r);
        r=sqrt((X-D_BS).^2+Y.^2+Z.^2);
        func=@(x) p_uniform(x,D_Linker);
        p2=arrayfun(func,r);
        p12=p1.*p2;
        vol1=sum(p12(:))*resolution^3*(10^-27)*10^3;
        vol2=4/3*pi*D_Linker^3*(10^-27)*10^3;
        coeff=1/N_avogadro/vol2^2*vol1;
        newKd2_eff=Kd2/coeff;
        result_uniform_2(i,j)=coeff;
        xlabel("r,nm")
        ylabel("pdf")

    end
end

%%
function p=p_uniform(r,rmax)
    if r<rmax
        p=1;
    else
        p=0;
    end
end

function p=p_WLC(r,rmax,r_p)
    if r<rmax-0.001
        p=1/(1-(r^2)/(rmax^2))^(9/2)*exp(-9*rmax/8/r_p*(1/(1-(r^2)/(rmax^2))));
    else
        p=0;
    end
end