%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script takes halogen images and identifies cells. Makes an output
% file to be used by the 'Source-Code-2.m' script.
% Coded by Andrew Bergen.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tic;
file_dir = ''; % path to directory that contains original time-lapse image files. %ie Halogen, GFP, mCh images



XY_list = { 'XY01','XY02','XY03','XY04','XY05','XY06','XY07','XY08','XY09','XY10'};%,'XY11'}; %%

CELL_XYs = [];   %% This is the matrix that will contain all of the cell.
CELL_rad = [];   %% This is the matrix that will contain all of the radii of the circles.
CELL_cent = [];  %% This is the matrix that will contain all of the centroids of colonies.
CELL_mask = [];  %% This structure is for the dilated images.

for a = 1:length(XY_list)
    a
    im = int16.empty(6,0);
    im_GFP = int16.empty(6,0);
    im_mCh = int16.empty(6,0);
    file_name=dir(strcat(file_dir)); % the path tht u hv imges

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    NewFiles = {};
    NewFiles_GFP = {};
    NewFiles_mCh = {};
    for k1 = 1:length(file_name)
        A = strfind(file_name(k1).name, '_Halogen' );
        B = strfind(file_name(k1).name, string(XY_list(a)) );

        A_GFP = strfind(file_name(k1).name, '_GFP' );
        B_GFP = strfind(file_name(k1).name, string(XY_list(a)) );

        A_mCh = strfind(file_name(k1).name, '_mCh' );
        B_mCh = strfind(file_name(k1).name, string(XY_list(a)) );

        if ~isempty(A) && ~isempty(B)
            NewFiles = [NewFiles;  file_name(k1).name];
        end
        if ~isempty(A_GFP) && ~isempty(B_GFP)
            NewFiles_GFP = [NewFiles_GFP;  file_name(k1).name];
        end
        if ~isempty(A_mCh) && ~isempty(B_mCh)
            NewFiles_mCh = [NewFiles_mCh;  file_name(k1).name];
        end
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    for i=1:length(NewFiles) %suppose there are 10 image
    DD = strcat(file_dir ,string(NewFiles(i)) );
    EE = strcat(file_dir ,string(NewFiles_GFP(i)) );
    aa = i*1-1+1;
    im{aa} = imread(DD);
    im_GFP{i} = imread(EE);
    aa = i*2 - 1;
    im_Total{aa} = imread(DD);
    aa = i*2;
    im_Total{aa} = imread(EE);
    % imtool(im);
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Below, go through every image in im{} and mark the cells based on  %%%
    % the circle finder.                                                 %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    CELL_XYs(a).xy = [];            %% This creates a cell array, where every timepoint will be added as an individual cell,
    CELL_XYs(a).xyT = {};           %%  this is done to correspond to the simpletracker funtion input requirments.
    CELL_mask(a).cent_xyT = {};     %% This makes cell array for
    CELL_rad(a).rad = [];           %% This is the matrix that will contain all of the radii of the circles.
    CELL_cent(a).cent = [];         %% This is the matrix that will contain all of the centroids of colonies.
    CELL_cent(a).area = [];         %% This is the matrix that will contain the total area of each colony.
    CELL_cent(a).area_total = [];   %% This is the matrix that will contain the total area of each Image (sum of all colonies).

    for i = 1:37%length(NewFiles) %% This is the number of timepoints images
        I = im{i};
        % figure, imshow(I);
        % I_orig = im{i};
        I_GFP = im_GFP{i};
        %  figure, imshow(I), title('original image');
        %  text(size(I,2),size(I,1)+15, ...
        %  'Image courtesy of Alan Partin', ...
        %  'FontSize',7,'HorizontalAlignment','right');
        %  text(size(I,2),size(I,1)+25, 'Johns Hopkins University', ...
        %  'FontSize',7,'HorizontalAlignment','right');

        [~, threshold] = edge(I, 'Canny');
        fudgeFactor = 3;
        BWs = edge(I,'Canny', threshold * fudgeFactor);
        % figure, imshow(BWs), title('binary gradient mask');

        se90 = strel('diamond',2); %strel('line', 3, 90);
        se0 = strel('diamond',2); %strel('line', 3, 0);
        BWsdil = imdilate(BWs, [se90 se0]);

        %%%% Now I will test
        BWsdil2 = imclearborder(BWsdil,4);  %% remove cells touching borders

        BWdfill = imfill(BWsdil2,8,'holes');
        %% BWsdil3 = imclearborder(BWdfill,4);
        seD = strel('diamond',2);
        BWfinal = imerode(BWdfill,seD);

        % figure, imshowpair(BWs, BWfinal , 'montage'), title('dilated gradient mask');

        %%%%%%%%% see if circles can be found in these images %%%%%%%%%%%%%%%%%

        sizeCell = [25 38]; % gives the radius range for the circles.

        [cCell_pre, rCell_pre] = imfindcircles(BWsdil2,sizeCell,'ObjectPolarity','bright','Sensitivity',0.85,'EdgeThreshold',0.05*graythresh(I));
        tol = 25;    %% tolerance for overlap in pixel number.
        option = 2;  % removes smaller of the two circles
        [cCell, rCell]= RemoveOverLap(cCell_pre,rCell_pre,tol,option);
        cCell = round(cCell);
        rCell = round(rCell);

        imageSizeX = size(BWfinal,2);
        imageSizeY = size(BWfinal,1);
        [columnsInImage rowsInImage] = meshgrid(1:imageSizeX, 1:imageSizeY);

        %%% Next create the circle in the image. %%%%%%%%%%%%

        BW_final_dots = BWfinal*0;

        for j = 1:length(cCell(:,1))
            centerX = cCell(j,1);
            centerY = cCell(j,2);
            radius = rCell(j,1);
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            circlePixels = (rowsInImage - centerY).^2 ...
                + (columnsInImage - centerX).^2 <= radius.^2;
            BW_final_dots = BW_final_dots + circlePixels;
        end

        BWfinal = imclearborder(BWfinal,4);
        BWfinal2 = im2bw(BWfinal, .5);

        %{

        Dtest = -bwdist(~BWfinal2);
        mask4 = imextendedmin(Dtest,2);
        D2 = imimposemin(Dtest,mask4);

        Ld2 = watershed(D2);
        bw3 = BWfinal2;
        bw3(Ld2 == 0) = 0;
        BWfinal2 = bw3;

        %}

        s = regionprops(BWfinal2);
        locate2 = regionprops(BWfinal2,'PixelList');
        centroids = cat(1,s.Centroid);
        areas = cat(1,s.Area);

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        BW_col_temp = BWfinal*0;

        %%% Make a template of the
        col_number = length(locate2);


        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Need to create structure that assign a colony to each         %
        %  each cell number.                                            %
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        count_dot = 0 ;
        for ct2 = 1:col_number
            col_xy = locate2(ct2).PixelList;
            BW_col_temp = BWfinal2*0;
            row = col_xy(:,2)';
            col = col_xy(:,1)';
            BW_col_temp(  sub2ind(  size(BW_col_temp), row, col )) = 1;
            %%%%%%
            for mt2 = 1:length( cCell(:,2) )
                row2 = cCell(mt2,2);
                col2 = cCell(mt2,1);
                if BW_col_temp(row2,col2) == 1;

                    % figure, imshow(BW_col_temp);

                    %{
                    hold on;
                    plot(col2,row2,'b*');
                    viscircles([col2,row2],rCell(mt2),'EdgeColor','b');
                    hold off;
                    %}

                    cCell(mt2,4) = ct2; %% This assigns
                    count_dot = count_dot + 1;
                end

            end
            % figure, imshow(BW_col_temp);
        end

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        %numb_img = insertText(I,cCell(:,1:2),cCell(:,4) );
        % imshow(numb_img);

        %{
        figure, imshow(BWfinal2);
        hold on;
        plot(centroids(:,1),centroids(:,2),'b*');
        hold off;



        figure, imshowpair(I, BWfinal2,'blend');
        %}

        %figure, imshow([I]);
        %viscircles(cCell(:,1:2),rCell,'EdgeColor','b');

        %{
        if i == 1
        figure, imshow([I]); %%%, title('binary gradient mask');
        print('XY1_circles_1', '-djpeg', '-r200');

        figure, imshow([I]); %%%, title('binary gradient mask');
        viscircles(cCell(:,1:2),rCell,'EdgeColor','b');
        print('XY1_circles_2', '-djpeg', '-r200');

        figure, imshow(BWfinal2);
        print('XY1_circles_3', '-djpeg', '-r200');
        end
        %}
        %%%%%%%%% This adds a column with the time for track cells %%%%%%%%%%%%

        num = length(cCell(:,1));
        AA = ones(1,num)*(i);  %% This creates a matrix of all of the cells %%%
        cCell(:,3) = AA;
        cCell(:,5) = rCell;

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%% Now add the timepoint to all the centroid point             %%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        num1 = length(centroids(:,1));
        BB = ones(1,num1)*(i);
        centroids(:,3) = BB;
        areas(:,2) = BB;

        CELL_XYs(a).xy = [CELL_XYs(a).xy ; cCell];
        CELL_XYs(a).xyT{i} = [cCell];
        CELL_mask(a).cent_xyT{i} = centroids(:,1:2);
        CELL_mask(a).cent_area{i} = areas(:,1);
        CELL_rad(a).rad = [CELL_rad(a).rad;rCell];
        CELL_cent(a).cent = [CELL_cent(a).cent;centroids];
        CELL_cent(a).area = [CELL_cent(a).area;areas];
        CELL_cent(a).area_total = [CELL_cent(a).area_total;sum(areas)];
        CELL_cent(a).timepoint(i).colony_pixels = locate2;
        CELL_mask(a).timepoint(i).mask = BWfinal2;              %% the CELL_mask struct will store the mask images
        CELL_mask(a).timepoint(i).cent = centroids(:,1:2);      %%  as well as the centroids to compare to output
    end
end

ALL_cells = struct;
ALL_cells.CELL_XYs = CELL_XYs;
ALL_cells.CELL_cent = CELL_cent;
ALL_cells.CELL_mask = CELL_mask;
ALL_cells.CELL_rad = CELL_rad;
date1 = date;
experiment_label = strcat(experiment, '_circles_', date1);

save(experiment_label,  'ALL_cells' );

% clearvars -except CELL_XYs CELL_rad CELL_cent CELL_mask locate2 cCell_pre rCell cCell s BWfinal2;
toc
