%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script takes the output file from Source-Code-1.m
% and tracks individual cells through time series and extracts
% cell size and TF nuclear localization.
% Coded by Andrew Bergen.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

circle_file = ''; % put the directory path to the input file here. The input is the output file from Segment_find_cells.m

load(circle_file);

file_dir = ''; % path to directory that contains original time-lapse image files. %ie Halogen, GFP, mCh images

tic;

CELL_XYs = ALL_cells.CELL_XYs;
CELL_cent = ALL_cells.CELL_cent;
CELL_mask = ALL_cells.CELL_mask;
CELL_rad = ALL_cells.CELL_rad;

);

% Number of XY field of views within images.
XY_list = {'XY01','XY02','XY03','XY04' ,'XY05','XY06','XY07','XY08','XY09','XY10'};%,'XY11'}; %,'XY12'};

final_nuc_data = struct;
final_GFP3 = [];
final_mCh3 = [];
final_Growth = [];
CELL_XYs2 = struct;
CELL_XYs2 = CELL_XYs;

% Define the timepoints of interest right before stress to see if each colony.
Track1 = struct; % ADDED This struct is for
%  is 3 or less cells.
time_course = 37; %%%  length(NewFiles);

time_pt_cut = [1,12,13]; % Only have colonies that have two or less cells at timepoints.
cell_thresh = 2; % Maximum number of cells in colonies to keep.

for a = [1:10]%length(XY_list)
    a;

    %%%%%%  Track cells based CELL_XYs2 matrix  %%%%%%%%%%%%%%%%%%%%%%%%%

    param.mem = 0;
    param.good = 0;
    param.dim = 2;
    param.quiet = 0;
    CELL_XYs2(a).xyT = CELL_XYs2(a).xyT(1:time_course);
    % cells_tracked = trackCellsLocal( [CELL_XYs2(a).xy(:,1),CELL_XYs2(a).xy(:,2),CELL_XYs2(a).xy(:,3)] , 20 ,param);

    [ tracks, adjacency_tracks] = simpletracker(CELL_XYs2(a).xyT, 'Method','NearestNeighbor','MaxLinkingDistance',50, 'MaxGapClosing', 2);

    colonies_tracked = trackCellsLocal( [CELL_cent(a).cent(:,1),CELL_cent(a).cent(:,2),CELL_cent(a).cent(:,3)] , 10 ,param);

    % Remove colonies that have more than 2 cells at timepoints.
    % time_pt_cut.

    for i = 1:length(time_pt_cut)
        tc = time_pt_cut(i);
        tally_cols = [];

        % (1st) determine which colonies have more than 3 circles ...
        for j = 1:length( CELL_XYs2(a).xyT{tc}(:,4) )
            col_here = CELL_XYs2(a).xyT{tc}(j,4);
            if sum(CELL_XYs2(a).xyT{tc}(:,4)==col_here) > cell_thresh   %% if there are more
                % add to tally_cols if not yet in
                if  any(tally_cols==col_here)==0 %% if tally_cols does not already contain col_here ...
                    tally_cols = [tally_cols, col_here];
                end
            end
        end
        % (2nd) remove all rows with the numbers of tally_cols

        if isempty(tally_cols) == 0  % ADDED if loop to remove empty vectors
            idx= any(CELL_XYs2(a).xyT{tc}(:,4)==tally_cols ,2 );
            CELL_XYs2(a).xyT{tc}(idx,4)=NaN; %[]; % Using NaN keeps the
        end
    end

    im = int8.empty(6,0);
    im_GFP = int8.empty(6,0);
    im_mCh = int8.empty(6,0);
    file_name=dir(strcat( file_dir )); %%%% the path tht u hv imges

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    NewFiles = {};
    NewFiles_GFP = {};
    NewFiles_mCh = {};

    for k1 = 1:length(file_name)
        A = strfind(file_name(k1).name, '_Halogen' );
        B = strfind(file_name(k1).name, string(XY_list(a)) );

        A_GFP = strfind(file_name(k1).name, '_GFP' );
        B_GFP = strfind(file_name(k1).name, string(XY_list(a)) );

        A_mCh = strfind(file_name(k1).name, '_mCh' );
        B_mCh = strfind(file_name(k1).name, string(XY_list(a)) );

        if ~isempty(A) && ~isempty(B)
            NewFiles = [NewFiles;  file_name(k1).name];
        end
        if ~isempty(A_GFP) && ~isempty(B_GFP)
            NewFiles_GFP = [NewFiles_GFP;  file_name(k1).name];
        end
        if ~isempty(A_mCh) && ~isempty(B_mCh)
            NewFiles_mCh = [NewFiles_mCh;  file_name(k1).name];
        end
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    for i=1:length(NewFiles) % suppose there are 10 image
      DD = strcat(file_dir, string(NewFiles(i)) );
      im{i} = imread(DD);
      DD_GFP = strcat(file_dir, string(NewFiles_GFP(i)) );
      im_GFP{i} = imread(DD_GFP);
      DD_mCh = strcat(file_dir, string(NewFiles_mCh(i)) );
      im_mCh{i} = imread(DD_mCh);
      % imtool(im);
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Make another list with images with LUTs
    file_dir1 = strcat('~/Desktop/Nikon_data/',exper_main,'/',experiment1, '/');

    im1 = int8.empty(6,0);
    im_GFP1 = int8.empty(6,0);
    im_mCh1 = int8.empty(6,0);
    file_name1 =dir(strcat( file_dir1 )); %%%% the path tht u hv imges

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    NewFiles_GFP1 = {};
    NewFiles_mCh1 = {};

    for k1 = 1:length(file_name1)

        A_GFP1 = strfind(file_name1(k1).name, '_GFP' );
        B_GFP1 = strfind(file_name1(k1).name, string(XY_list(a)) );

        A_mCh1 = strfind(file_name1(k1).name, '_mCh' );
        B_mCh1 = strfind(file_name1(k1).name, string(XY_list(a)) );

        if ~isempty(A_GFP1) && ~isempty(B_GFP1)
            NewFiles_GFP1 = [NewFiles_GFP1;  file_name1(k1).name];
        end

        if ~isempty(A_mCh1) && ~isempty(B_mCh1)
            NewFiles_mCh1 = [NewFiles_mCh1;  file_name1(k1).name];
        end
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    for i=1:length(NewFiles_GFP1) % suppose there are 10 image

      DD_GFP1 = strcat(file_dir1, string(NewFiles_GFP1(i)) );
      im_GFP1{i} = imread(DD_GFP1);
      DD_mCh1 = strcat(file_dir1, string(NewFiles_mCh1(i)) );
      im_mCh1{i} = imread(DD_mCh1);
      % imtool(im);
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Make pixel_vect struct that contains vectors of all  %%%
    %%% the pixel intensity within each circle for the GFP   %%%
    %%% and mCherry channels.                                %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    circ_Total = length(CELL_XYs2(a).xy(:,1));  %% gives total number of circles in all images.

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%  Now make a struct that contains all the vectors   %%%
    %%%  for a given cell based on the cells_tracked       %%%
    %%%  matrix.                                           %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    last_cell = length(tracks);   %%% This gets the number of tracked cells.

    tracked_vect = struct;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % A
    cells_tracked = [];

    for i = 1:last_cell % (This gives the number of tracked cells)
        for j = 1:length(tracks{1})     %  This gives the number of timepoints
            cell_T = tracks{i}(j);      %  This is cell
            if isnan(cell_T) || isnan(CELL_XYs2(a).xyT{j}(cell_T, 4) )
                tracked_vect.cell(i).time(j).X = [];     % Gives X cordinate for each.
                tracked_vect.cell(i).time(j).Y =  [];    % Count
                tracked_vect.cell(i).time(j).col_numb = []; % Also add the associated colony.
                tracked_vect.cell(i).time(j).rad = [];      % radius of the circle.
                tracked_vect.cell(i).time(j).col_other = [];
                tracked_vect.cell(i).time(j).col_area = [];
            % If the colony has been made to be NaN for the import time
            % points.

            else
                tracked_vect.cell(i).time(j).X =  CELL_XYs2(a).xyT{j}(cell_T, 1);     % Gives X cordinate for each
                tracked_vect.cell(i).time(j).Y =  CELL_XYs2(a).xyT{j}(cell_T, 2);     % Count
                tracked_vect.cell(i).time(j).col_numb = CELL_XYs2(a).xyT{j}(cell_T, 4);      % Also add the associated colony.
                tracked_vect.cell(i).time(j).rad = CELL_XYs2(a).xyT{j}(cell_T, 5);      % radius of the circle.
                tracked_vect.cell(i).time(j).col_other = [];
                tracked_vect.cell(i).time(j).col_area = [];
            end
        end
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Add GFP and mCherry vectors to each cell and timepoint in the  %%%
    %%% tracked_vect struct.                                           %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    for i = 1:last_cell %% This gives the number of tracked cells)
        for j = 1:length(tracks{1})     %  This gives the number of timepoints
            if ~isempty(tracked_vect.cell(i).time(j).X) == 1
                img_numb = j; %%
                BWfinal2 = CELL_mask(a).timepoint(j).mask;
                imageSizeX = size(BWfinal2,2);
                imageSizeY = size(BWfinal2,1);
                [columnsInImage rowsInImage] = meshgrid(1:imageSizeX, 1:imageSizeY);
                %%% Next create the circle in the image  %%%%%%%%
                centerX = tracked_vect.cell(i).time(j).X;
                centerY = tracked_vect.cell(i).time(j).Y;
                radius = tracked_vect.cell(i).time(j).rad;
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                circlePixels = (rowsInImage - centerY).^2 ...
                      + (columnsInImage - centerX).^2 <= radius.^2;
                % circlePixels is a 2D "logical" array.
                % Now, display it.
                image(circlePixels) ;
                colormap([0 0 0; 1 1 1]);

                %%% Make a vector %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                circlePixels = int16(circlePixels);
                MAT_GFP = int16( cell2mat( im_GFP(img_numb) ));  %% This converts cell array to matrix and in the correct class.
                MAT_mCh = int16( cell2mat( im_mCh(img_numb) ));  %%
                mask_pix_GFP = circlePixels.*MAT_GFP;
                mask_pix_mCh = circlePixels.*MAT_mCh;
                vect_pix_GFP = mask_pix_GFP(mask_pix_GFP ~= 0)';
                vect_pix_mCh = mask_pix_mCh(mask_pix_mCh ~= 0)';
                tracked_vect.cell(i).time(j).GFP = vect_pix_GFP;
                tracked_vect.cell(i).time(j).mCh = vect_pix_mCh;
            end
        end
    end

    full_cell = []; % This is a test_one that actually keeps all of the colonies
    impt_pts = [1,time_pt_cut, time_course]; % This gives the timepoint that will be important for measuring the total

    % The following for loop only keeps the tracked cells that have a cell.
    % at the impt time point.

    % Importan Cell Timepoints. % ADDED blocking this loop to remove cells.

    for i = 1:last_cell % This gives the number of tracked cells)
        cut_cell = 0;
        for j = impt_pts
            if isempty(tracked_vect.cell(i).time(j).X) == 1
                cut_cell = 1; % if any of the important timepoints are empty, cut_cell will be 1(true).
            end
        end
        if cut_cell == 0   % If no timepoints were empty, keep the cell
            full_cell = [full_cell, i];
        end
    end

    % full_cell = [1:last_cell]; % ADDED This line of the code was placed in to record

    % Make a vector containing coordinates.

    full_cell_pre = full_cell;

    for time_point = [1,10,15,20,25] % This is the timepoint at which to make an print an image
                          % with each cell labeled with its colony number.
        full_cell_XYs = zeros(length(full_cell_pre),2);
        for i = 1:length(full_cell_pre)
            cell_number = full_cell_pre(i);
            if ~isempty(tracked_vect.cell(cell_number).time(time_point).X)
                full_cell_XYs(i,1) = tracked_vect.cell(cell_number).time(time_point).X;
                full_cell_XYs(i,2) = tracked_vect.cell(cell_number).time(time_point).Y;
            end
        end

        %%% Make a figure with each cell numbered.
        %{
        figure;

        % subplot(4,6,counter);

        % plot(nuclear_ratio_mCh(i,:) );

        numb_img = insertText(im{time_point},full_cell_XYs,full_cell_pre);
        imshow(numb_img);
        bud_file1 = strcat( 'Bud_images_time23_', sprintf('%02d', a) );
        %}
        %print(bud_file1,'-dpdf');  % ADDED these two lines to create
        % title(num2str(  ""  );
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Also make a pdf with all of the masked cells that contain   %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %{

    figure;
    for time_point = 1:length( CELL_cent(1).timepoint ) ;  %% This gives the total timepoints.
        full_cell_XYs = [];
        for i = 1:length(full_cell_pre)
            cell_number = full_cell_pre(i);
            full_cell_XYs(i,1) = tracked_vect.cell(cell_number).time(time_point).X;
            full_cell_XYs(i,2) = tracked_vect.cell(cell_number).time(time_point).Y;
        end

        %%% Make a figure with each cell numbered.
        % figure;

        numb_img = insertText( single( CELL_mask(a).timepoint(time_point).mask ),full_cell_XYs,full_cell_pre);
        %% subplot(46,1,time_point);
        imshow(numb_img),  title(num2str(time_point) );
        mask_file = strcat( experiment, '_', string(XY_list(a)), '_T', sprintf('%02d', time_point) );
        print(mask_file,'-dpdf');
    end

    %}

    %%%% convert to to numeric vector %%%%%%%%%%%%%%%%%%%%%%%%%%
    x_cells = [];
    x_cell_numb = [];
    for i =1:length(x_cells)
        x_cell_numb(i) = str2num(x_cells{i});
    end

    % Now, create a field that contains all the cells that contain a
    % are in a given colony. This is given by the number.

    for j = 1:length(tracks{1})   % This gives the number of timepoints.
        for i = full_cell   % (This gives the number of tracked cells)
            match1 = tracked_vect.cell(i).time(j).col_numb;
            for fd = full_cell
                col_other = tracked_vect.cell(fd).time(j).col_numb;
                if col_other == match1
                    tracked_vect.cell(i).time(j).col_other = [tracked_vect.cell(i).time(j).col_other, fd];
                end
            end
        end
    end

    col_ID_here = 1; % This gives the colonies
    ct_im = 1; % This is used if you want to make example images.
    for i = full_cell
        cells_incol_T1 = []; % initiate here so that only time point 1 is tracked.
        for j = 1:length(tracks{1}) % This gives the number of timepoints.
            if isempty( tracked_vect.cell(i).time(j).col_area )==1 && ...       %% If there are currently no colony area for this cell ...
                    isempty( tracked_vect.cell(i).time(j).X )==0  && ...        %%  ... and there IS a marked cell at this time
                    tracked_vect.cell(i).time(j).col_numb > 0                   %% This ensures that a colony was attached to the cell at this timepoint

                % only label for time 1 so that other colonies are not
                % taken from another colony

                if j ==1
                    cells_incol_T1 = tracked_vect.cell(i).time(j).col_other;
                end

                % now get the colony numbers for current timepoint j

                cols_timej = tracked_vect.cell(i).time(j).col_other;

                % only keep colonies in current timepoint that were also
                % present at time point 1 (i.e. j ==1)
                cells_incol = intersect(cols_timej, cells_incol_T1);

                col_num_here = tracked_vect.cell(i).time(j).col_numb;

                %%% Create the blackwhite image of only the colony %%%%%%
                BWfinal2 = CELL_mask(a).timepoint(j).mask;
                %{
                if j == 1 && i< 4
                    here_A = uint16(BWfinal2).*im{j};
                    figure, imshow(here_A);
                    bud_file1 = strcat( 'Example_images_', sprintf('%02d', ct_im) );
                    print(bud_file1,'-djpeg', '-r100');
                    % ADDED these two lines to create
                    ct_im = ct_im + 1;
                end
                %}
                BW_col_temp = BWfinal2*0;
                locate2 = regionprops(BWfinal2,'PixelList');
                col_xy = locate2(col_num_here).PixelList;
                row = col_xy(:,2)';
                col = col_xy(:,1)';
                BW_col_temp(  sub2ind(  size(BW_col_temp), row, col )) = 1; %% Makes BW_col_temp the image with only the colony as 1's.

                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                imageSizeX = size(BWfinal2,2);
                imageSizeY = size(BWfinal2,1);

                power_dis_mx = {}; %%% inititate a power distrance matrix for
                               %%% all of the circles in the colony.
                % For each cell given in the col_area
                for o = 1:length(cells_incol)
                    % Make a power diagram for each colony
                    cell_split = cells_incol(o); %% This is the cell number to use among

                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    [columnsInImage rowsInImage] = meshgrid(1:imageSizeX, 1:imageSizeY);
                    centerX = tracked_vect.cell(cell_split).time(j).X;
                    centerY = tracked_vect.cell(cell_split).time(j).Y;
                    radius = tracked_vect.cell(cell_split).time(j).rad;

                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    circlePixels = (rowsInImage - centerY).^2 ...
                        + (columnsInImage - centerX).^2 - radius.^2;

                    power_dis_mx{o} = circlePixels;
                    % figure, imshow(circlePixels);

                    %{
                    figure, imshow(BW_col_temp);
                    hold on;
                    %% plot(col2,row2,'b*');
                    viscircles([X1,Y1],rad1,'EdgeColor','b');
                    hold off;
                    %}
                end

                %%% now create power distance matrix for each matrix.

                seg_pwr_dis_mx = {};
                for o = 1:length(cells_incol)
                    cell_split = cells_incol(o);
                    pwr_calc = power_dis_mx{o}*0 +1 ;  %% initiate power distance matrix of 1's.

                    for p = 1:length(cells_incol)
                        if o~=p
                            pwr_calc_T = power_dis_mx{o} <= power_dis_mx{p};
                            pwr_calc = pwr_calc.* pwr_calc_T; %% This only keeps area where the are equal.
                        end
                    end

                    pwr_calc = pwr_calc.*BW_col_temp;
                    seg_pwr_dis_mx{o} = pwr_calc;
                    A4 = regionprops(seg_pwr_dis_mx{o},'Area');
                    tracked_vect.cell(cell_split).time(j).col_area = A4.Area;

                    % chose specific cells do display and print if desired.
                    %
                    %{
                    if j ==1 && i >4 && i < 8
                        here_A = uint16(seg_pwr_dis_mx{o}).*im{j};
                        figure, imshow(here_A);
                        i
                        cell_split

                        bud_file1 = strcat( 'Example_images_', sprintf('%02d', ct_im) );
                        print(bud_file1,'-djpeg', '-r200');
                        % ADDED these two lines to create
                        ct_im = ct_im + 1;

                        here_A = uint16(BWfinal2).*im{j};
                        figure, imshow(here_A);
                        bud_file1 = strcat( 'Example_images_', sprintf('%02d', ct_im) );
                        print(bud_file1,'-djpeg', '-r200');

                        ct_im = ct_im + 1;

                        here_A = BWfinal2;
                        figure, imshow(here_A);
                        bud_file1 = strcat( 'Example_images_', sprintf('%02d', ct_im) );
                        print(bud_file1,'-djpeg', '-r200');

                        ct_im = ct_im + 1;
                    end
                    %}

                    % Also get data for the ENTIRE colony, including size
                    % and shape data. The entire colony is in BW_col_temp.
                    A_col = regionprops(BW_col_temp,'Area','MajorAxisLength','MinorAxisLength','Circularity');

                    tracked_vect.cell(cell_split).time(j).full_col_Area = A_col.Area;
                    tracked_vect.cell(cell_split).time(j).full_col_MajL = A_col.MajorAxisLength;
                    tracked_vect.cell(cell_split).time(j).full_col_MinL = A_col.MinorAxisLength;
                    tracked_vect.cell(cell_split).time(j).full_col_Circul = A_col.Circularity;
                    % Now add a picture of each cell area to the colony
                    % area.

                    Xcor = tracked_vect.cell(cell_split).time(j).X;
                    Ycor = tracked_vect.cell(cell_split).time(j).Y;
                    radi = tracked_vect.cell(cell_split).time(j).rad;

                    last_row = length(BWfinal2(:,1));
                    last_col = length(BWfinal2(1,:));

                        row1 = round( Ycor - radi*3.0 );
                        if row1 < 1, row1 = 1; end;
                        row2 = round( Ycor + radi*3.0 );
                        if row2 > last_row, row2 = last_row; end;
                        colm1 = round( Xcor - radi*3.0);
                        if colm1 < 1, colm1 = 1; end;
                        colm2 = round( Xcor + radi*3.0);
                        if colm2 > last_col, colm2 = last_col; end;

                    % make masked image
                    %imgA1 = uint16(seg_pwr_dis_mx{o}).*im1{j}; % This is for POWER DISTANCE masked image.
                    imgA1 = uint16(BW_col_temp).*im{j};
                    img_mCh1 = uint16(BW_col_temp).*im_mCh1{j}; % Make whole colony images of mCh channel
                    img_GFP1 = uint16(BW_col_temp).*im_GFP1{j}; % Make whole colony images of GFP channel

                    % imgA_mask =
                    % uint16(seg_pwr_dis_mx{o}(row1:row2,colm1:colm2)); % This is the POWER DISTANCE mask.
                    imgA_mask = uint16(BW_col_temp(row1:row2,colm1:colm2));

                    imgA = imgA1(row1:row2,colm1:colm2); % Cut out power dis cell from the entire image.
                    Y_mid = round(size(imgA,1)/2 );
                    X_mid = round(size(imgA,2)/2 );
                    %imgA = insertText(imgA,[8 8],num2str(j) );
                    %imgA = insertMarker(imgA,[X_mid Y_mid] );

                    mid1 = ones(9);
                    imgA((Y_mid-4):(Y_mid+4),(X_mid-4):(X_mid+4)) = mid1;

                    img_mCh = img_mCh1(row1:row2,colm1:colm2); % Cut out colony from the entire image.

                    img_GFP = img_GFP1(row1:row2,colm1:colm2); % Cut out colony from the entire image.


                    tracked_vect.cell(cell_split).time(j).col_pic = imgA;
                    tracked_vect.cell(cell_split).time(j).ALLcol_pic_mCh = img_mCh;
                    tracked_vect.cell(cell_split).time(j).ALLcol_pic_GFP = img_GFP;

                    tracked_vect.cell(cell_split).time(j).col_pic_mask= imgA_mask;
                    tracked_vect.cell(cell_split).time(j).col_ID = col_ID_here;  % This gives a number ID so that all cells in the same colony
                                                                            % have the same ID number.
                    % Below, confirms that that cell in tracked_vect and
                    % th calulated area belong to the same cell.
                    centerX = tracked_vect.cell(cell_split).time(j).X;
                    centerY = tracked_vect.cell(cell_split).time(j).Y;
                    radius = tracked_vect.cell(cell_split).time(j).rad;

                    % figure, imshow(seg_pwr_dis_mx{o});

                    % hold on;
                    % plot(col2,row2,'b*');
                    % viscircles([centerX,centerY],radius,'EdgeColor','b');
                    % hold off;
                end
            end
        end
        col_ID_here = col_ID_here + 1;
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Connect colony size at each timepoint to the colony size    %%%
    %%% of that tracked cell at each timepoint.                     %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %{
    for h = 1:full_cell_numb
        i = full_cell(h);
        i
        for j = 2:time_course
            %% Changed to 2 because first timepoint bad
            for k = 1:length( CELL_cent(a).timepoint(j).colony_pixels) %%  This gives the number of colonies at that time point.
                for l = 1:length(CELL_cent(a).timepoint(j).colony_pixels(k).PixelList(:,1) )
                    if isempty(tracked_vect.cell(i).time(j).X ) == 0 ...
                            && CELL_cent(a).timepoint(j).colony_pixels(k).PixelList(l,1) == tracked_vect.cell(i).time(j).X ...
                            && CELL_cent(a).timepoint(j).colony_pixels(k).PixelList(l,2) == tracked_vect.cell(i).time(j).Y

                        tracked_vect.cell(i).time(j).col_area = length(CELL_cent(a).timepoint(j).colony_pixels(k).PixelList);
                        %%%% also want to keep track of the total cells
                        %%%% that have been assigned to the white colony.
                    end
                end
            end
        end
    end
    %}

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Now determine the number                                 %%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    nuclear_ratio_GFP = [];
    nuclear_ratio_mCh = [];
    growth_rate_cells = [];

    full_col_Area = [];
    MajorAxisLength = [];
    MinorAxisLength = [];
    full_col_Circul = [];

    col_ID = [];

    radius_cells = [];

    growth_rate_pics = {}; % Make a cell array to store pictures.
    growth_rate_pics_mCh = {};
    growth_rate_pics_GFP = {};
    growth_rate_pics_mask = {};


    full_cell_numb = length(full_cell); % number of cells that have the entire time series.
    for i = 1:full_cell_numb
        % Changed to 2 to ignore 1 timepoint
        for j = 1:time_course
            cell_here = full_cell(i);

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            if isempty( tracked_vect.cell(cell_here).time(j).GFP) == 0
                data_GFP = tracked_vect.cell(cell_here).time(j).GFP;
                data_mCh = tracked_vect.cell(cell_here).time(j).mCh;
                data_GFP_sort = sort(data_GFP,'descend');
                data_mCh_sort = sort(data_mCh,'descend');
                % now get the MEAN of the time points that that are top 5 %%%%%%%
                GFP_top5 = mean( data_GFP_sort(1:ceil(length(data_GFP_sort)*.05)) );
                mCh_top5 = mean( data_mCh_sort(1:ceil(length(data_mCh_sort)*.05)) );

                GFP_median50 = mean( data_GFP_sort( ceil(length(data_GFP_sort)*.49):ceil( length(data_GFP_sort)*.50) ) );
                mCh_median50 = mean( data_mCh_sort( ceil(length(data_mCh_sort)*.49):ceil( length(data_mCh_sort)*.50) ) );


                % divide to get the ratio of the two  %%%%%%%%%%%%%%%%%%%%%%%%%%%
                GFP_ratio = (GFP_top5/GFP_median50);
                mCh_ratio = (mCh_top5/mCh_median50);
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                nuclear_ratio_GFP(i,j) = GFP_ratio;
                nuclear_ratio_mCh(i,j) = mCh_ratio;

                nuclear_median_GFP(i,j) = GFP_median50;
                nuclear_median_mCh(i,j) = mCh_median50;

            elseif isempty( tracked_vect.cell(cell_here).time(j).GFP) == 1
                nuclear_ratio_GFP(i,j) = NaN;
                nuclear_ratio_mCh(i,j) = NaN;
            end

            %%% Now, for the colony area, if it is zero it will give an
            %%% error. So, if it is 0, make it a 1.
            if isempty(tracked_vect.cell(cell_here).time(j).col_area) == 1
                tracked_vect.cell(cell_here).time(j).col_area = NaN;

                tracked_vect.cell(cell_here).time(j).full_col_Area = NaN;
                tracked_vect.cell(cell_here).time(j).full_col_MajL = NaN;
                tracked_vect.cell(cell_here).time(j).full_col_MinL = NaN;
                tracked_vect.cell(cell_here).time(j).full_col_Circul = NaN;

                tracked_vect.cell(cell_here).time(j).col_ID = NaN;

                tracked_vect.cell(cell_here).time(j).rad = NaN;
                tracked_vect.cell(cell_here).time(j).col_pic = [];
                tracked_vect.cell(cell_here).time(j).col_pic_mask = [];
            end

            growth_rate_cells(i,j) = tracked_vect.cell(cell_here).time(j).col_area;
            radius_cells(i,j) = tracked_vect.cell(cell_here).time(j).rad;

            growth_rate_pics{i,j} = tracked_vect.cell(cell_here).time(j).col_pic;
            growth_rate_pics_mCh{i,j} = tracked_vect.cell(cell_here).time(j).ALLcol_pic_mCh;
            growth_rate_pics_GFP{i,j} = tracked_vect.cell(cell_here).time(j).ALLcol_pic_GFP;
            growth_rate_pics_mask{i,j} = tracked_vect.cell(cell_here).time(j).col_pic_mask;

            full_col_Area(i,j) = tracked_vect.cell(cell_here).time(j).full_col_Area;
            MajorAxisLength(i,j) = tracked_vect.cell(cell_here).time(j).full_col_MajL;
            MinorAxisLength(i,j) = tracked_vect.cell(cell_here).time(j).full_col_MinL;
            full_col_Circul(i,j) = tracked_vect.cell(cell_here).time(j).full_col_Circul;

            col_ID(i,j) = tracked_vect.cell(cell_here).time(j).col_ID;
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        end
    end

    Track1(a).tracked_vect = tracked_vect; % ADDED

    % Next, remove any cells with more than TooNan 'Nan'

    nuclear_ratio_GFP2 = nuclear_ratio_GFP;
    nuclear_ratio_mCh2 = nuclear_ratio_mCh;

    nuclear_median_GFP2 = nuclear_median_GFP;
    nuclear_median_mCh2 = nuclear_median_mCh;

    growth_rate_cells2 = growth_rate_cells;

    full_col_Area2 = full_col_Area;
    MajorAxisLength2 = MajorAxisLength;
    MinorAxisLength2 = MinorAxisLength;
    full_col_Circul2 = full_col_Circul;

    col_ID2 = col_ID;

    radius_cells2 = radius_cells;
    growth_rate_pics2 = {};
    growth_rate_pics_mCh2 = {};
    growth_rate_pics_GFP2 = {};

    growth_rate_pics_mask2 = {};

    TooNaN = 0;
    cells_before = length(nuclear_ratio_GFP2(:,1));
    tally_nan = zeros(cells_before,1);   % row vector of zeros of length of cells

    for i = 1:cells_before
        here_vec_GFP = nuclear_ratio_GFP(i,:);
        sum_NaN_GFP = sum(isnan(here_vec_GFP));
        if sum_NaN_GFP > TooNaN
            tally_nan(i) = 1;  % Make logically true if less than TooNaN NaN's
        end
        % Also, determine if the sum of NaN's in the growth vector are
        % equal to the GFP vector. This is important to make sure the cell
        % size assignment always kept the same cell as the nuclear
        % localization assignment.
        here_grow_vec = growth_rate_cells(i,:);
        sum_NaN_grow = sum(isnan(here_grow_vec));
        if sum_NaN_GFP ~= sum_NaN_grow
            tally_nan(i) = 1;  % Make logically true if the number of NaN's don't match.
        end
    end
    tally_nanL = logical(tally_nan);

    % Now clear these cells with too many NaN's from each matrix.

    nuclear_ratio_GFP2(tally_nanL,:)=[];
    nuclear_ratio_mCh2(tally_nanL,:)=[];

    nuclear_median_GFP2(tally_nanL,:)=[];
    nuclear_median_mCh2(tally_nanL,:)=[];

    growth_rate_cells2(tally_nanL,:)=[];

    full_col_Area2(tally_nanL,:)=[];
    MajorAxisLength2(tally_nanL,:)=[];
    MinorAxisLength2(tally_nanL,:)=[];
    full_col_Circul2(tally_nanL,:)=[];

    col_ID2(tally_nanL,:)=[];

    radius_cells2(tally_nanL,:)=[];

    % Make col_ID2

    col_ID2 = col_ID2(:,1);

    ID_count = 1;
    for e = 1:col_ID_here % this is the number of colony ID#s given above.
        if any(col_ID2==e)
            col_ID2(col_ID2==e)=ID_count;
            ID_count = ID_count + 1;
        end
    end

    % This makes the same growth_rate_pics2{} with the same tally_nanL.

    count = 1;
    for i1=1:length(tally_nanL)
        if tally_nanL(i1)==0 % only keeps the rows
            for j1 = 1:time_course
                growth_rate_pics2{count,j1} = growth_rate_pics{i1,j1};
                growth_rate_pics_mCh2{count,j1} = growth_rate_pics_mCh{i1,j1};
                growth_rate_pics_GFP2{count,j1} = growth_rate_pics_GFP{i1,j1};

                growth_rate_pics_mask2{count,j1} = growth_rate_pics_mask{i1,j1};
            end
            count = count + 1;
        end
    end

    growth_rate_pics3 = {};
    growth_rate_pics_mCh3 = {};
    growth_rate_pics_GFP3 = {};
    growth_rate_pics_mask3 = {};

    for i = 1:length(growth_rate_pics2(:,1) )
        pic_size = [];
        % determine the biggest picture
        for j = 1:length( growth_rate_pics2(1,:) )
            if isempty(growth_rate_pics2{i,j})==0  % if there is a picture ...
                sz_here=length(growth_rate_pics2{i,j}(1,:));
                pic_size = [pic_size, sz_here];
            end
        end

        biggest_sz = max(pic_size);  % Get the biggest picture size.
        big_pic = uint16(zeros(biggest_sz)); % Make a matrix of zeros the size of the biggest picture
        for j = 1:length( growth_rate_pics2(1,:) )
            if isempty(growth_rate_pics2{i,j})==0  % if there is a picture ...
                sz_here_row = length(growth_rate_pics2{i,j}(:,1));
                sz_here_col = length(growth_rate_pics2{i,j}(1,:));

                pic_here = big_pic;
                pic_mCh_here = big_pic;
                pic_GFP_here = big_pic;
                pic_here_mask = big_pic;

                pic_here(1:sz_here_row,1:sz_here_col) = growth_rate_pics2{i,j};
                pic_mCh_here(1:sz_here_row,1:sz_here_col) = growth_rate_pics_mCh2{i,j};
                pic_GFP_here(1:sz_here_row,1:sz_here_col) = growth_rate_pics_GFP2{i,j};
                pic_here_mask(1:sz_here_row,1:sz_here_col) = growth_rate_pics_mask2{i,j};

                growth_rate_pics2{i,j} = pic_here;
                growth_rate_pics_mCh2{i,j} = pic_mCh_here;
                growth_rate_pics_GFP2{i,j} = pic_GFP_here;
                growth_rate_pics_mask2{i,j} = pic_here_mask;

            else
                growth_rate_pics2{i,j} = big_pic;
                growth_rate_pics_mCh2{i,j} = big_pic;
                growth_rate_pics_GFP2{i,j} = big_pic;
                growth_rate_pics_mask2{i,j} = big_pic;
            end
        end

        % Now round
        x = time_course;
        fig_size_row = round( x / 5 );
        fig_size_col = 5;

        pic_tile = imtile(growth_rate_pics2(i,:), 'GridSize', [fig_size_row fig_size_col]);
        pic_tile_mCh = imtile(growth_rate_pics_mCh2(i,:), 'GridSize', [fig_size_row fig_size_col]);
        pic_tile_GFP = imtile(growth_rate_pics_GFP2(i,:), 'GridSize', [fig_size_row fig_size_col]);
        pic_tile_mask = imtile(growth_rate_pics_mask2(i,:), 'GridSize', [fig_size_row fig_size_col]);

        growth_rate_pics3{i} = pic_tile;
        growth_rate_pics_mCh3{i} = pic_tile_mCh;
        growth_rate_pics_GFP3{i} = pic_tile_GFP;
        growth_rate_pics_mask3{i} = pic_tile_mask;
    end

    % These structs are for seeing full cells in each image stack %%%%%%%%%

    final_nuc_data(a).GFP = nuclear_ratio_GFP2;
    final_nuc_data(a).mCh = nuclear_ratio_mCh2;

    final_nuc_data(a).GFP_median = nuclear_median_GFP2;
    final_nuc_data(a).mCh_median = nuclear_median_mCh2;

    final_nuc_data(a).growth = growth_rate_cells2;

    final_nuc_data(a).full_col_Area = full_col_Area2;
    final_nuc_data(a).MajorAxisLength = MajorAxisLength2;
    final_nuc_data(a).MinorAxisLength = MinorAxisLength2;
    final_nuc_data(a).full_col_Circul = full_col_Circul2;

    final_nuc_data(a).col_ID = col_ID2;

    final_nuc_data(a).rad = radius_cells2;

    final_nuc_data(a).pics = growth_rate_pics3;
    final_nuc_data(a).col_pics_mCh = growth_rate_pics_mCh3;
    final_nuc_data(a).col_pics_GFP = growth_rate_pics_GFP3;
    final_nuc_data(a).pics_mask =growth_rate_pics_mask3;

    % ADDED This next loop was added so that  .number was corrected

    cell_numb = [];
    for uu = 1:length(tally_nan)
        if tally_nanL(uu) == 0
            cell_numb = [cell_numb, uu];
        end
    end

    cell_numb = cell_numb';

    final_nuc_data(a).number = cell_numb;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    final_GFP3 = [final_GFP3; nuclear_ratio_GFP2];
    final_mCh3 = [final_mCh3; nuclear_ratio_mCh2];
    final_Growth = [final_Growth; growth_rate_cells2];

    % Count the the number of cells that are still left after removing NaN's
    final_cell_numb = length(nuclear_ratio_GFP2(:,1) );

    %{
    counter =1;
    figure;
    for i = 1:length(final_nuc_data(a).number)
        if counter < 25
            subplot(4,6,counter);
            plot(nuclear_ratio_GFP2(i,1:time_course));
            title(num2str( final_nuc_data(a).number(i))); %ADDED changed how number is titled
            counter = counter +1;
        end

        if counter == 25
            counter = 1;
            figure;
        end
    end

    counter =1;
    figure;
    for i = 1:length(final_nuc_data(a).number)
        if counter < 25
            subplot(4,6,counter);
            plot(nuclear_ratio_mCh2(i,1:time_course) );
            title(num2str( final_nuc_data(a).number(i)) );
            counter = counter +1;
        end
        if counter == 25
            counter = 1;
            figure;
        end
    end

    counter =1;
    figure;
    for i = 1:length(final_nuc_data(a).number)
        if counter < 25
            subplot(4,6,counter);
            plot(( final_nuc_data(a).growth(i,1:time_course) ));
            title(num2str( final_nuc_data(a).number(i)) );
            counter = counter +1;
        end
        if counter == 25
            counter = 1;
            figure;
        end
    end
    %}
    %%clearvars -except CELL_XYs CELL_rad CELL_cent final_nuc_data final_GFP3 final_mCh3 experiment file_dir XY_list tracked_vect;
end

date1 = date;
experiment_label = strcat(experiment, '_DATA_', date1);
save(experiment_label,  'final_nuc_data' );
toc
