function [] = Fig3()
dir = 'D:\eLife_Data_Code\Data\Human\DBS\';
load([dir 'MATRIX_DBS.mat']);

%fooof settings
return_model=1;
settings = struct();
settings.peak_threshold=2;
settings.aperiodic_mode='fixed';
settings.peak_width_limits=[2,12]; % [2,12]

% vars
freq1=10; %10
freq2=50; %50
exponents_rest = NaN(1,length(MATRIX_DBS.fs));
exponents_dbs = NaN(1,length(MATRIX_DBS.fs));
R_rest = NaN(1,length(MATRIX_DBS.fs));
R_dbs = NaN(1,length(MATRIX_DBS.fs));

datbase.alpha = NaN(1,length(MATRIX_DBS.fs));
datbase.beta_whole = NaN(1,length(MATRIX_DBS.fs));
datbase.low_beta = NaN(1,length(MATRIX_DBS.fs));
datbase.high_beta = NaN(1,length(MATRIX_DBS.fs));
datbase.gamma_whole = NaN(1,length(MATRIX_DBS.fs));
datbase.low_gamma = NaN(1,length(MATRIX_DBS.fs));
datbase.high_gamma = NaN(1,length(MATRIX_DBS.fs));
datbase.beta_per = NaN(1,length(MATRIX_DBS.fs));
datdbs.alpha = NaN(1,length(MATRIX_DBS.fs));
datdbs.beta_whole = NaN(1,length(MATRIX_DBS.fs));
datdbs.low_beta = NaN(1,length(MATRIX_DBS.fs));
datdbs.high_beta = NaN(1,length(MATRIX_DBS.fs));
datdbs.gamma_whole = NaN(1,length(MATRIX_DBS.fs));
datdbs.low_gamma = NaN(1,length(MATRIX_DBS.fs));
datdbs.high_gamma = NaN(1,length(MATRIX_DBS.fs));
datdbs.beta_per = NaN(1,length(MATRIX_DBS.fs));

OFF.freqs = NaN(1,freq2-freq1+1);
OFF.ap_fit = NaN(1,freq2-freq1+1);
OFF.spec = NaN(length(MATRIX_DBS.fs),90);
ON.freqs = NaN(1,freq2-freq1+1);
ON.ap_fit = NaN(1,freq2-freq1+1);
ON.spec = NaN(length(MATRIX_DBS.fs),90);

figure(1);
kik=1;
for i= 1:length(MATRIX_DBS.fs) 
    fs=MATRIX_DBS.fs(i);
    disp(['Sub: ' num2str(i)]);
    %% Signal Base
    signal_base=MATRIX_DBS.signal_base{i};
    
    % wavelet
    nData=size(signal_base,2);
    stfr=1;   enfr=90;  dfr=1.0;
    froi=stfr:dfr:enfr;
    tmoi=(1:nData)*(1/fs);
    cfg.width=50;
    cfg.gwidth=3;
    cfg.pad = ceil(nData/fs);
    cfg.Method='Wavlet';
    [cmmatall,f,~] = ft_specest_wavelet(signal_base,tmoi,'freqoi',froi,'width', cfg.width,'gwidth',cfg.gwidth, 'pad', cfg.pad, 'verbose', 0);
    cmmatall=squeeze(cmmatall);
    temppower=abs(cmmatall).^2;
    spec = nanmean(temppower,2);
    
    %remove mains noise
    spec(47:53)=NaN;
    spec = fillmissing(spec,'linear');
    
    %normalise
    spec = spec./mean(spec);
    
    % 1/F remove
    f_range = [1, 90];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    
    %figure; loglog(f,spec); hold on; loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');
    rel_spec = spec(1:90)';
    f_rem_spec = rel_spec - 10.^(fooof_results.ap_fit);
    %figure; plot(f_rem_spec);
    
    % all other frequencies
    [datbase] = more_frequencies(f_rem_spec,f,settings,return_model,kik,datbase,spec);
    
    
    % get aperiodic component
    f_range = [freq1, freq2];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    
    if contains(settings.aperiodic_mode,'fixed')
        exponents_rest(kik) = fooof_results.aperiodic_params(1,2);
    else
        exponents_rest(kik) = fooof_results.aperiodic_params(1,3);
    end
    
    
    figure(1);
    subplot(4,7,kik);
    loglog(spec); hold on; title(['Hem: ' num2str(i)]);
    loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k');
    
    OFF.freqs(kik,:) = fooof_results.freqs;
    OFF.ap_fit(kik,:) = fooof_results.ap_fit;
    OFF.spec(kik,:) = spec;
    R_rest(kik) = fooof_results.r_squared;
    
   %% Signal DBS
   signal_dbs=MATRIX_DBS.signal_dbs{i};
        
    % wavelet
    nData=size(signal_dbs,2);
    stfr=1;   enfr=90;  dfr=1.0;
    froi=stfr:dfr:enfr;
    tmoi=(1:nData)*(1/fs);
    cfg.width=50;
    cfg.gwidth=3;
    cfg.pad = ceil(nData/fs);
    cfg.Method='Wavlet';
    [cmmatall,f,ft_toi] = ft_specest_wavelet(signal_dbs,tmoi,'freqoi',froi,'width', cfg.width,'gwidth',cfg.gwidth, 'pad', cfg.pad, 'verbose', 0);
    cmmatall=squeeze(cmmatall);
    temppower=abs(cmmatall).^2;
    spec = nanmean(temppower,2);
    
    %remove mains noise
    spec(47:53)=NaN;
    spec = fillmissing(spec,'linear');
    
    %normalise
    spec = spec./mean(spec);
    
     % 1/F remove
    f_range = [1, 90];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    
    %figure; loglog(f,spec); hold on; loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');
    rel_spec = spec(1:90)';
    f_rem_spec = rel_spec - 10.^(fooof_results.ap_fit);
    %figure; plot(f_rem_spec);
    
    % all other frequencies
    [datdbs] = more_frequencies(f_rem_spec,f,settings,return_model,kik,datdbs,spec);
    
    
    % get aperiodic component
    f_range = [freq1, freq2];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    
    if contains(settings.aperiodic_mode,'fixed')
        exponents_dbs(kik) = fooof_results.aperiodic_params(1,2);
    else
        exponents_dbs(kik) = fooof_results.aperiodic_params(1,3);
    end
       
    loglog(spec);
    loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');
    
    ON.freqs(kik,:) = fooof_results.freqs;
    ON.ap_fit(kik,:) = fooof_results.ap_fit;
    ON.spec(kik,:) = spec;
    R_dbs(kik) = fooof_results.r_squared;
    
    
    kik=kik+1;
end


%% Figure 3B
figure; hold on;
box_X= [ones(1,length(exponents_rest)),ones(1,length(exponents_dbs))*2]';
box_Y=[exponents_rest,exponents_dbs]';
boxplot(box_Y,box_X,'Colors','k','Labels',{'no DBS','DBS'}); ylabel('aperiodic exponents');

Rand = (rand(1,length(exponents_rest))-0.5)./4;
scatter(ones(1,length(exponents_rest))+Rand,exponents_rest,'filled'); alpha .2;
scatter(ones(1,length(exponents_dbs))*2+Rand,exponents_dbs,'filled'); alpha .2;

for it=1:length(exponents_rest)
    line([1+Rand(it) 2+Rand(it)],[exponents_rest(it) exponents_dbs(it)],'Color','k','LineStyle',':');
end


% permutation test
dif = exponents_rest - exponents_dbs; %difference between conditions
[pval, t_orig, crit_t, est_alpha, seed_state]=mult_comp_perm_t1(dif',50000);
disp(pval); sigstar([1 2],pval); %adjusted p-values

d = computeCohen_d(exponents_dbs, exponents_rest, 'paired');
disp(d);

%% Figure 3C
figure; hold on;
box_Y=[datbase.beta_per;datdbs.beta_per]';
[pval] = plot_paired_results(box_Y);
ylabel('periodic beta');


%% Figure 3A

av_spec_OFF = mean(OFF.spec,1);
av_spec_ON = mean(ON.spec,1);

figure;
loglog(av_spec_OFF,'b'); hold on;
loglog(av_spec_ON),'y';

%OFF
fooof_results = fooof(f, av_spec_OFF, f_range, settings,return_model);
loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k');

upper_lim = av_spec_OFF + std(OFF.spec,0,1)./sqrt(size(OFF.spec,1));
lower_lim = av_spec_OFF - std(OFF.spec,0,1)./sqrt(size(OFF.spec,1));
shadedplot(f,upper_lim,lower_lim,[0.1 0.1 1]); alpha(.2); grid off;


% ON
fooof_results = fooof(f, av_spec_ON, f_range, settings,return_model);
loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');

upper_lim = av_spec_ON + std(ON.spec,0,1)./sqrt(size(ON.spec,1));
lower_lim = av_spec_ON - std(ON.spec,0,1)./sqrt(size(ON.spec,1));
shadedplot(f,upper_lim,lower_lim,[1 1 0.1]); alpha(.2); grid off;


%% Figure S3C
P=[];
figure; 
subplot(171); hold on;
box_Y=[datbase.beta_whole;datdbs.beta_whole]';
[pval] = plot_paired_results(box_Y);
ylabel('whole beta (13-35 Hz)'); P = [P pval];

subplot(172); hold on;
box_Y=[datbase.low_beta;datdbs.low_beta]';
[pval] = plot_paired_results(box_Y);
ylabel('low beta (13-20 Hz)'); P = [P pval];

subplot(173); hold on;
box_Y=[datbase.high_beta;datdbs.high_beta]';
[pval] = plot_paired_results(box_Y);
ylabel('high beta (21-35 Hz)'); P = [P pval];

subplot(174); hold on;
box_Y=[datbase.gamma_whole;datdbs.gamma_whole]';
[pval] = plot_paired_results(box_Y);
ylabel('whole gamma (35-90 Hz)'); P = [P pval];

subplot(175); hold on;
box_Y=[datbase.low_gamma;datdbs.low_gamma]';
[pval] = plot_paired_results(box_Y);
ylabel('low gamma (35-50 Hz)'); P = [P pval];

subplot(176); hold on;
box_Y=[datbase.high_gamma;datdbs.high_gamma]';
[pval] = plot_paired_results(box_Y);
ylabel('high gamma (51-90 Hz)'); P = [P pval];

subplot(177); hold on;
box_Y=[datbase.beta_per;datdbs.beta_per]';
[pval] = plot_paired_results(box_Y);
ylabel('periodic beta'); P = [P pval];

sgtitle('Spectral Changes with 130 Hz STN-DBS');

 
%% Figure S3D
diff_epo = exponents_rest - exponents_dbs;
diff_alpha = datbase.alpha - datdbs.alpha;
diff_betwhole = datbase.beta_whole - datdbs.beta_whole;
diff_betlow = datbase.low_beta - datdbs.low_beta;
diff_bethigh = datbase.high_beta - datdbs.high_beta;
diff_gamwhole = datbase.gamma_whole - datdbs.gamma_whole;
diff_gamlow = datbase.low_gamma - datdbs.low_gamma;
diff_gamhigh = datbase.high_gamma - datdbs.high_gamma;
diff_betper = datbase.beta_per - datdbs.beta_per;

figure; 
subplot(171); my_correlations(diff_epo,diff_betwhole);
xlabel('Aperiodic Exponents OFF-ON DBS'); ylabel('beta (13-35 Hz) OFF-ON DBS');

subplot(172); my_correlations(diff_epo,diff_betlow);
xlabel('Aperiodic Exponents OFF-ON DBS'); ylabel(' low beta (13-20 Hz) OFF-ON DBS');

subplot(173); my_correlations(diff_epo,diff_bethigh);
xlabel('Aperiodic Exponents OFF-ON DBS'); ylabel('high beta (21-35 Hz) OFF-ON DBS');

subplot(174); my_correlations(diff_epo,diff_gamwhole);
xlabel('Aperiodic Exponents OFF-ON DBS'); ylabel('gamma (35-90 Hz) OFF-ON DBS');

subplot(175); my_correlations(diff_epo,diff_gamlow);
xlabel('Aperiodic Exponents OFF-ON DBS'); ylabel('low gamma (35-50 Hz) OFF-ON DBS');

subplot(176); my_correlations(diff_epo,diff_gamhigh);
xlabel('Aperiodic Exponents OFF-ON DBS'); ylabel('high gamma (51-90 Hz) OFF-ON DBS');

in2keep = ~isnan(diff_betper);
diff_betper = diff_betper(in2keep);
diff_epo2 = diff_epo(in2keep);
subplot(177); my_correlations(diff_epo2,diff_betper);
xlabel('Aperiodic Exponents OFF-ON DBS'); ylabel('periodic beta OFF-ON DBS');



end

