function [dat] = more_frequencies(spec,f,settings,return_model,kik,dat,spec2)
    %% alpha
    dat.alpha(kik) = mean(spec(8:12)); 
    
    %% beta
    dat.beta_whole(kik) = mean(spec(13:35));
    dat.low_beta(kik) = mean(spec(13:20));
    dat.high_beta(kik) = mean(spec(21:35));
    
    %% gamma
    dat.gamma_whole(kik) = mean(spec(35:90));
    dat.low_gamma(kik) = mean(spec(35:50));
    dat.high_gamma(kik) = mean(spec(51:90));
    
    % get periodic beta
    f_range = [5, 90];
    fooof_results = fooof(f, spec2, f_range, settings,return_model);
    
    low_cut=find(fooof_results.peak_params(:,1) > 8);
    up_cut=find(fooof_results.peak_params(:,1) < 35);
    val=intersect(low_cut,up_cut);
    
    if ~isempty(val)
        if numel(val) > 1
            [~,max_beta]=max(fooof_results.peak_params(val,2));
            dat.beta_per(kik) = fooof_results.peak_params(val(max_beta),2);
            dat.beta_freq(kik) = fooof_results.peak_params(val(max_beta),1);
        else
            dat.beta_per(kik) = fooof_results.peak_params(val,2);
            dat.beta_freq(kik) = fooof_results.peak_params(val,1);
        end
    else
        dat.beta_per(kik) = NaN;
        dat.beta_freq(kik) = NaN;
    end
    %loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k');
end

