function [] = scatter_swa2(ap_STN_high,ap_STN_low,exp)
figure; hold on;

load('colorbrewer.mat');
colormap=colorbrewer.div.Spectral{1,8};
colormap=colormap./255;

big_dots_STN_highe = squeeze(nanmean(nanmean(ap_STN_high,2),3));
big_dots_STN_lowe = squeeze(nanmean(nanmean(ap_STN_low,2),3));

for ox=1:length(big_dots_STN_highe)
    sz=20;
    hb=scatter(ones(1,length(ap_STN_high(ox,:)))+(rand(1,length(ap_STN_high(ox,:)))-0.5)./2,ap_STN_high(ox,:),sz,colormap(ox,:),'filled'); alpha(hb, .5);
    ha=scatter(ones(1,length(ap_STN_low(ox,:)))*2+(rand(1,length(ap_STN_low(ox,:)))-0.5)./2,ap_STN_low(ox,:),sz,colormap(ox,:),'filled'); alpha(ha, .5);

    sz=100;
    scatter(ones(1,1),big_dots_STN_highe(ox),sz,colormap(ox,:),'filled');
    scatter(ones(1,1)*2,big_dots_STN_lowe(ox),sz,colormap(ox,:),'filled');
end

for it=1:length(big_dots_STN_highe)
    line([1 2],[big_dots_STN_highe(it) big_dots_STN_lowe(it)],'Color','k','LineStyle',':');
end
xlim([0.5 2.5]);
xticks([1 2])
xticklabels({'high SWA','low SWA'}); 
if exp==1
    ylabel('exponents'); end
if exp==2
    ylabel('Power (\muV^2)'); end
if exp==3
    ylabel('Spiking Rate'); end

% lme1
data = [ap_STN_high(:); ap_STN_low(:)];
subj = repmat(1:8,1,50)';
block = [ones(1,200), repmat(2,1,200)]';

Newdat = [subj block data];
Table_lme = array2table(Newdat,'VariableNames',{'Sub','block','data'});
lme = fitlme(Table_lme,'data~block+(1+block|Sub)');

[~,~,stats] = fixedEffects(lme);
lme_data = dataset2cell(stats);
sigstar([1 2],lme_data{3,6});
disp(['LME: estimate: ' string(lme_data{3,2}) ' tStat: ' string(lme_data{3,4}) ' pVal: ' string(lme_data{3,6})]);

end

