function [] = Fig1()
cm.fs=2048;

freq1=30; % 30-100 Hz
freq2=100;

% common vars
cm.width=50;
cm.thresh=2;
cm.f_mode='fixed';
cm.freq_band=[freq1, freq2];
cm.freq1=freq1;
cm.freq2=freq2;
cm.sliding_win=0.25;
cm.TF_method='wavelet';
cm.percent_up = 75;
cm.percent_down = 25;

% BUA var
cm.length_spike_segment=.5;
cm.SD_thres=4;
%

fileNames = {'NPR059.mat','NPR046.mat','NPR052e.mat','NPR040d.mat','NPR057.mat','pjx286c.mat','pjx289c.mat','pjx310c.mat'};
% vars swa
swa.exp_pow30100_corr = NaN(1,length(fileNames));
swa.ap_STN_high = NaN(length(fileNames),5,5);
swa.ap_STN_low = NaN(length(fileNames),5,5);
swa.r_high = NaN(length(fileNames),5,5);
swa.r_low = NaN(length(fileNames),5,5);
swa.ap_Ti_high = NaN(length(fileNames),5,5);
swa.ap_Ti_low = NaN(length(fileNames),5,5);
swa.ap_Ta_high = NaN(length(fileNames),5,5);
swa.ap_Ta_low = NaN(length(fileNames),5,5);
swa.power_STN_high = NaN(length(fileNames),5,5);
swa.power_STN_low = NaN(length(fileNames),5,5);
swa.power_Ti_high = NaN(length(fileNames),5,5);
swa.power_Ti_low = NaN(length(fileNames),5,5);
swa.power_Ta_high = NaN(length(fileNames),5,5);
swa.power_Ta_low = NaN(length(fileNames),5,5);
swa.STN_chan=NaN(1,8);
swa.PSD_STN_high = NaN(length(fileNames),5,5,100);
swa.PSD_STN_low = NaN(length(fileNames),5,5,100);
swa.PSD_TI_high = NaN(length(fileNames),5,5,100);
swa.PSD_TI_low = NaN(length(fileNames),5,5,100);
swa.PSD_TA_high = NaN(length(fileNames),5,5,100);
swa.PSD_TA_low = NaN(length(fileNames),5,5,100);
swa.hi_stn_spikes = NaN(length(fileNames),5,5);
swa.lo_stn_spikes = NaN(length(fileNames),5,5);
swa.hi_ti_spikes = NaN(length(fileNames),5,5);
swa.lo_ti_spikes = NaN(length(fileNames),5,5);
swa.hi_ta_spikes = NaN(length(fileNames),5,5);
swa.lo_ta_spikes = NaN(length(fileNames),5,5);
%



%
%%
[swa] = swa_lesioned_LFP(swa,cm);


%% Figure 1C

clear PSD1 PSD2 
ix=1;
for sub=1:8
    for units=1:5
        for lp=1:5
            PSD1(ix,:) = squeeze(swa.PSD_STN_high(sub,units,lp,:));
            PSD2(ix,:) = squeeze(swa.PSD_STN_low(sub,units,lp,:));
            ix=ix+1;
        end
    end
end
PSD1 = PSD1(~isnan(PSD1)); PSD1 = reshape(PSD1,70,100);
PSD2 = PSD2(~isnan(PSD2)); PSD2 = reshape(PSD2,70,100);

% plot
mPSD1 = mean(PSD1,1); mPSD2 = mean(PSD2,1);
figure; 
loglog(mPSD1,'b'); hold on;
loglog(mPSD2,'r');

colorw = [0.1 0.1 1];
[fooof_results] = plot_SEM_4Magill(PSD1,mPSD1,colorw);

colorw = [1 0.1 0.1];
[fooof_results] = plot_SEM_4Magill(PSD2,mPSD2,colorw);
xlim([10 100]); 


%% Aperiodic Exponents Figure 1D
exp=1;
ap_STN_high=swa.ap_STN_high;
ap_STN_low=swa.ap_STN_low;

scatter_swa2(ap_STN_high,ap_STN_low,exp);
sgtitle('STN');


%% Power Figure 1E
exp=2;
power_STN_high=swa.power_STN_high;
power_STN_low=swa.power_STN_low;

scatter_swa2(power_STN_high,power_STN_low,exp)
sgtitle('STN');
end

