function [p] = paired_MEDS_OFF_ON(gamma_OFF,gamma_ON)

figure; hold on;
box_X= [ones(1,length(gamma_OFF)),ones(1,length(gamma_ON))*2]';
box_Y=[gamma_OFF,gamma_ON]';
boxplot(box_Y,box_X,'Colors','k','Labels',{'OFF','ON'}); %ylabel('gamma power (30-90 Hz)');

Rand = (rand(1,length(gamma_OFF))-0.5)./4;
scatter(ones(1,length(gamma_OFF))+Rand,gamma_OFF,'filled'); alpha .2;
scatter(ones(1,length(gamma_ON))*2+Rand,gamma_ON,'filled'); alpha .2;

for it=1:length(gamma_OFF)
    line([1+Rand(it) 2+Rand(it)],[gamma_OFF(it) gamma_ON(it)],'Color','k','LineStyle',':');
end


h1 = lillietest(gamma_OFF);
h2 = lillietest(gamma_ON);

if h1 == 0 && h2 ==0
    [~,p] = ttest(gamma_OFF,gamma_ON);
    sigstar([1 2],p);
    title(['paired ttest p= ' num2str(p)]);
else
    p = signrank(gamma_OFF,gamma_ON);
    sigstar([1 2],p);
    title(['signrank p= ' num2str(p)]);
end
end

