function [pval, t_orig] = plot_paired_results_med(box_Y)

boxplot(box_Y,'Colors','k','Labels',{'OFF','ON'},'symbol','');

Rand = (rand(1,length(box_Y))-0.5)./4;
scatter(ones(1,length(box_Y))+Rand,box_Y(:,1),'filled'); alpha .2;
scatter(ones(1,length(box_Y))*2+Rand,box_Y(:,2),'filled'); alpha .2;

for it=1:length(box_Y)
    line([1+Rand(it) 2+Rand(it)],[box_Y(it,1) box_Y(it,2)],'Color','k','LineStyle',':');
end
dif = box_Y(:,1) - box_Y(:,2); %difference between conditions
in2keep = ~isnan(dif);
dif = dif(in2keep);
[pval, t_orig, crit_t, est_alpha, seed_state]=mult_comp_perm_t1(dif,50000);
disp(pval); %adjusted p-values
sigstar([1 2],pval);
end

