function [swa] = swa_lesioned_LFP(swa,cm)

dir='D:\eLife_Data_Code\Data\Animal\';
fileNames = {'NPR059.mat','NPR046.mat','NPR052e.mat','NPR040d.mat','NPR057.mat','pjx286c.mat','pjx289c.mat','pjx310c.mat'};
STN_channels={[22:24],[21:23],[22:26],[24],[22:26],[23:25],[22:26],[22:24]};
chan_names={{'gp_ti4','gp_ti5','stn_mua20','stn_mua21','gp_ti1','gp_ti4','gp_ti8','stn_sua19'},{'stn_mua19','stn_mua20','gp_ti1','gp_ti4','gp_ti3a','gp_ti11a'},...
    {'stn_sua19','stn_sua21','gp_ta1','gp_ti2a','gp_ti6','gp_ti8'},{'gp_ti2','gp_ti9','gp_ti5','gp_ti8','gp_ti10','gp_ta10','stn_su21a','stn_su21b'},...
    {'gp_ti3','gp_ti7','stn_sua5','stn_sua20','gp_ta2b'},{'stn_mua20','stn_mua21','stn_mua22','gp_ti4','gp_ti1','gp_ti2'},...
    {'stn_mua20','stn_mua21','stn_mua19','gp_ti5','gp_ti7A','gp_ti7B','gp_ti7C','gp_ta7D'},{'gp_ta3','gp_ti4','gp_ti8','stn_sua21','stn_sua19','gp_ta1','gp_ti9','stn_sua20'}};
unit_activity = {[7:8,13:18],[11:16],[11,13,16:19],[10:17],[17,19,21:22,25],[5:10],[10:11,17:22],[13:20]};
limits = [25,2;25,25;25,25;0,25;10,25;0,25;25,0;25,25];

fs=cm.fs;
width=cm.width;
thresh=cm.thresh;
f_mode=cm.f_mode;
freq_band=cm.freq_band;
sliding_win=cm.sliding_win;
TF_method=cm.TF_method;
freq1=cm.freq1;
freq2=cm.freq2;

percent_up = cm.percent_up;
percent_down = cm.percent_down;

% BUA var
length_spike_segment=cm.length_spike_segment;
SD_thres=cm.SD_thres;

for sub=1:8
    
    load([dir fileNames{1,sub}]);
    display(['Sub = ' num2str(sub)])
    %% Get Spiking data
    win_length=sliding_win;
    TIs=[]; STNs=[]; TAs=[];
    clear av_STN_activity av_Ti_activity av_Ta_activity
    spike_start=NaN(1,length(chan_names{1,sub}));
    spike_end=NaN(1,length(chan_names{1,sub}));
    ox=1;
    for chans=unit_activity{1,sub}
        clear spikes
        STN_spikes = SmrData.EvData{1,chans};
        spike_start(ox) = STN_spikes(1);
        spike_end(ox) = STN_spikes(end);
        
        if sub==7 && chans==17
            no_indeces = (round(STN_spikes(end)) - round(STN_spikes(1)))/sliding_win;
            ord=1;
            for tspot=1:no_indeces
                spikes_segment = find(STN_spikes >= round(STN_spikes(1))+(tspot-1)*win_length & STN_spikes < round(STN_spikes(1))+tspot*win_length);
                spikes (ord) = numel(spikes_segment);
                ord=ord+1;
            end
        else
            no_indeces = (ceil(STN_spikes(end)) - floor(STN_spikes(1)))/sliding_win;
            ord=1;
            for tspot=1:no_indeces
                spikes_segment = find(STN_spikes >= floor(STN_spikes(1))+(tspot-1)*win_length & STN_spikes < floor(STN_spikes(1))+tspot*win_length);
                spikes (ord) = numel(spikes_segment);
                ord=ord+1;
            end
        end
        
        if contains(chan_names{1,sub}{1,ox},'ti')
            TIs=[TIs; spikes];
        end
        
        if contains(chan_names{1,sub}{1,ox},'ta')
            TAs=[TAs; spikes];
        end
        
        if contains(chan_names{1,sub}{1,ox},'stn')
            if length(spikes) ~= length(STNs)
                laengenunterschied =  length(STNs)-length(spikes);
                spikes=[spikes, NaN(1,laengenunterschied)];
            end
            STNs=[STNs; spikes];
        end
        ox=ox+1;
    end
    
    
    %% Process LFP signal
    originalFs=SmrData.Fs;
    % downsampling
    desiredFs = fs;
    
    ONSET = floor(min(spike_start));
    OFFSET = ceil(max(spike_end));
    if sub==7
        ONSET = round(min(spike_start));
        OFFSET = round(max(spike_end));
    end
    
    return_model=1;
    f_range = freq_band;
    settings = struct();
    settings.peak_threshold=thresh;
    settings.aperiodic_mode=f_mode;
    settings.peak_width_limits=[2,12];
    
    %Fhp=300; Flp=300;
    % pick the right STN channel
    for ui=1:length(STN_channels{1,sub})
        display(['Sub = ' num2str(sub) '; channel = ' num2str(ui)])
        clear STN_orig STN_orig_hpfilt spike_threshold spike_free STN_orig_hpfilt_rect STN_orig_hpfilt_rect_lpfilt
        %% 
        STN_orig = SmrData.WvData{STN_channels{1,sub}(ui),1};
        
        % low-pass filter
        Flp = 300;
        STN_orig=ft_preproc_lowpassfilter(STN_orig,originalFs,Flp,3,'but','twopass');
        
        % downsample to 2048 Hz
        [p,q] = rat(desiredFs/originalFs);
        STN_signal = resample(STN_orig,p,q);
        
        % identify all Probe channels & exclude fProbe
        [TF_probe]=contains(SmrData.WvTits,'Probe');
        [TF_fprobe]=contains(SmrData.WvTits,'fProbe');
        probe_chan_index = TF_probe-TF_fprobe;
        probe_chans = find(probe_chan_index==1);
        
        % re-referencing
        ox=1;
        laenge=NaN(1,length(probe_chans));
        for i=probe_chans'
            laenge(ox) = length(SmrData.WvData{i,1});
            ox=ox+1;
        end
        shortest_length = min(laenge);
        
        
        clear STN_chans
        ox=1; %Fhp=300; Flp=300;
        Kanal_STN_nr=find(probe_chans==STN_channels{1,sub}(ui));
        for i=probe_chans(Kanal_STN_nr-3:Kanal_STN_nr+3)'
            signal = SmrData.WvData{i,1}(1:shortest_length);
            signal=ft_preproc_lowpassfilter(signal,originalFs,Flp,3,'but','twopass');

            STN_chans (ox,:) = signal;
            ox=ox+1;
        end
        STN_chans_av = mean(STN_chans,1);
        STN_chans_av_resampled = resample(STN_chans_av,p,q);
        
        STN_referenced = STN_signal - STN_chans_av_resampled;
        
        
        %% extract the part for which we have spiking info
        STN_cropped = STN_referenced(ONSET*fs+1-limits(sub,1)*fs:OFFSET*fs+1+limits(sub,2)*fs);
        
        nData=size(STN_cropped,2);
        stfr=1;   enfr=100;  dfr=1.0;
        froi=stfr:dfr:enfr;
        tmoi=(1:nData)*(1/fs);
        cfg.width=width;
        cfg.gwidth=3;
        cfg.pad = ceil(nData/fs);
        cfg.Method='Wavlet';
        [cmmatall,f,~] = ft_specest_wavelet(STN_cropped,tmoi,'freqoi',froi,'width', cfg.width,'gwidth',cfg.gwidth, 'pad', cfg.pad, 'verbose', 0);
        cmmatall=squeeze(cmmatall);
        cmmatall=cmmatall(:,limits(sub,1)*fs+1:end-limits(sub,2)*fs);
        
        fe=f;
        temppower=abs(cmmatall).^2;
        
        % all segments
        iterations=(OFFSET-ONSET)/sliding_win;
        exponents=NaN(1,iterations);
        R_sq=NaN(1,iterations);
        
        store_segments=NaN(iterations,100);
        power30_100=NaN(1,iterations);
        for lul=1:iterations
            segment = temppower(:,round(sliding_win*fs*(lul-1)+1):round(sliding_win*fs*lul));%wavelet
            segment_av = nanmean(segment,2);
            
            %normalise
            segment_av = segment_av./mean(segment_av);
            
            if sum(isnan(segment_av(30:100))) > 0
                exponents(lul) = NaN;
                R_sq(lul) = NaN;
            else
                fooof_results = fooof(fe', segment_av, f_range, settings,return_model);
                if contains(f_mode,'fixed')
                    exponents(lul) = fooof_results.aperiodic_params(1,2);
                else
                    exponents(lul) = fooof_results.aperiodic_params(1,3);
                end
                R_sq(lul) = fooof_results.r_squared(1,1);
            end
            store_segments(lul,:) = segment_av;
            power30_100(lul) = mean(segment_av(freq1:freq2));
        end
        
        if sum(isnan(exponents)) > 0 && ui==1
            NaN_values=find(isnan(exponents));
            exponents(NaN_values)=[];
            
            store_segments(NaN_values,:)=[];
            STNs(:,NaN_values)=[];
            TIs(:,NaN_values)=[];
            power30_100(NaN_values)=[];
            
            if ~isempty(TAs)
                TAs(:,NaN_values)=[];
            end
        end
        
        if sum(isnan(exponents)) > 0 && ui>1
            NaN_values=find(isnan(exponents));
            exponents(NaN_values)=[];
            store_segments(NaN_values,:)=[];
            power30_100(NaN_values)=[];
        end
        
        
        %%
        for elmo=1:size(STNs,1)
            activity = STNs(elmo,:);
            
            % STN
            upper_lim = prctile(activity,percent_up);
            lower_lim = prctile(activity,percent_down);
            if lower_lim==0; lower_lim=1; end
            
            upper_class = find(activity>upper_lim);
            lower_class = find(activity<lower_lim);
            
            
            PSD_high_spike = store_segments(upper_class,:);
            psd_high = nanmean(PSD_high_spike,1);
            psd_high(47:53) = NaN;
            psd_high = fillmissing(psd_high,'linear');
            swa.PSD_STN_high(sub,elmo,ui,:) = psd_high;
            
            PSD_low_spike = store_segments(lower_class,:);
            psd_low = nanmean(PSD_low_spike,1);
            psd_low(47:53) = NaN;
            psd_low = fillmissing(psd_low,'linear');
            swa.PSD_STN_low(sub,elmo,ui,:) = psd_low;
            
            fooof_results = fooof(fe',psd_high, f_range, settings,return_model);
            
            
            if contains(f_mode,'fixed')
                apero = fooof_results.aperiodic_params(1,2);
            else
                apero = fooof_results.aperiodic_params(1,3);
            end
            
            swa.ap_STN_high(sub,elmo,ui) = apero;
            swa.power_STN_high(sub,elmo,ui) = mean(psd_high(freq1:freq2));
            swa.r_high(sub,elmo,ui) = fooof_results.r_squared;
            
            fooof_results = fooof(fe', psd_low, f_range, settings,return_model);
            if contains(f_mode,'fixed')
                apero = fooof_results.aperiodic_params(1,2);
            else
                apero = fooof_results.aperiodic_params(1,3);
            end
            
            swa.ap_STN_low(sub,elmo,ui) = apero;
            swa.power_STN_low(sub,elmo,ui) = mean(psd_low(freq1:freq2));
            swa.r_low(sub,elmo,ui) = fooof_results.r_squared;
            %
            
            swa.hi_stn_spikes(sub,elmo,ui) = mean(activity(upper_class));
            swa.lo_stn_spikes(sub,elmo,ui) = mean(activity(lower_class));
        end
        
        
        
        for elmo=1:size(TIs,1)
            activity = TIs(elmo,:);
            
            % TI
            upper_lim = prctile(activity,percent_up);
            lower_lim = prctile(activity,percent_down);
            if lower_lim==0; lower_lim=1; end
            
            upper_class = find(activity>upper_lim);
            lower_class = find(activity<lower_lim);
            
            
            PSD_high_spike = store_segments(upper_class,:);
            psd_high = nanmean(PSD_high_spike,1);
            swa.PSD_TI_high(sub,elmo,ui,:) = psd_high;
            
            PSD_low_spike = store_segments(lower_class,:);
            psd_low = nanmean(PSD_low_spike,1);
            swa.PSD_TI_low(sub,elmo,ui,:) = psd_low;
            
            fooof_results = fooof(fe', psd_high, f_range, settings,return_model);
            %loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k--');
            if contains(f_mode,'fixed')
                apero = fooof_results.aperiodic_params(1,2);
            else
                apero = fooof_results.aperiodic_params(1,3);
            end
            
            swa.ap_Ti_high(sub,elmo,ui) = apero;
            swa.power_Ti_high(sub,elmo,ui) = mean(psd_high(freq1:freq2));
            
            fooof_results = fooof(fe', psd_low, f_range, settings,return_model);
            if contains(f_mode,'fixed')
                apero = fooof_results.aperiodic_params(1,2);
            else
                apero = fooof_results.aperiodic_params(1,3);
            end
            
            swa.ap_Ti_low(sub,elmo,ui) = apero;
            swa.power_Ti_low(sub,elmo,ui) = mean(psd_low(freq1:freq2));
            %
            swa.hi_ti_spikes(sub,elmo,ui) = mean(activity(upper_class));
            swa.lo_ti_spikes(sub,elmo,ui) = mean(activity(lower_class));
        end
        
        
        
        if ~isempty(TAs)
            %figure;
            %im_ind=1;
            for elmo=1:size(TAs,1)
                activity = TAs(elmo,:);
                % TA
                upper_lim = prctile(activity,percent_up);
                lower_lim = prctile(activity,percent_down);
                if lower_lim==0; lower_lim=1; end
                
                upper_class = find(activity>upper_lim);
                lower_class = find(activity<lower_lim);
                
                
                
                PSD_high_spike = store_segments(upper_class,:);
                psd_high = nanmean(PSD_high_spike,1);
                swa.PSD_TA_high(sub,elmo,ui,:) = psd_high;
                
                PSD_low_spike = store_segments(lower_class,:);
                psd_low = nanmean(PSD_low_spike,1);
                swa.PSD_TA_low(sub,elmo,ui,:) = psd_low;
                
                
                fooof_results = fooof(fe', psd_high, f_range, settings,return_model);
                %loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k--');
                if contains(f_mode,'fixed')
                    apero = fooof_results.aperiodic_params(1,2);
                else
                    apero = fooof_results.aperiodic_params(1,3);
                end
                
                swa.ap_Ta_high(sub,elmo,ui) = apero;
                swa.power_Ta_high(sub,elmo,ui) = mean(psd_high(freq1:freq2));
                
                fooof_results = fooof(fe', psd_low, f_range, settings,return_model);
                %loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'b--');
                if contains(f_mode,'fixed')
                    apero = fooof_results.aperiodic_params(1,2);
                else
                    apero = fooof_results.aperiodic_params(1,3);
                end
                
                swa.ap_Ta_low(sub,elmo,ui) = apero;
                swa.power_Ta_low(sub,elmo,ui) = mean(psd_low(freq1:freq2));
                %im_ind=im_ind+3;
                %
                swa.hi_ta_spikes(sub,elmo,ui) = mean(activity(upper_class));
                swa.lo_ta_spikes(sub,elmo,ui) = mean(activity(lower_class));
            end
        end
    end
end

end

