function [] = Fig2()

% set fitting range for aperiodic exponents here
cm.freq1=40; 
cm.freq2=90; 
%% OFF meds
[OFF_meds] = Med_OFFs(cm);
%%
[ON_meds] = Med_ONs(cm);
%%

%% Figure 2C
% exponents
[p1]=paired_MEDS_OFF_ON(OFF_meds.exponents,ON_meds.exponents);
ylabel('Exponent (\muV^2/Hz)');

% permutation test
dif=OFF_meds.exponents-ON_meds.exponents; %difference between conditions
[pval, t_orig, crit_t, est_alpha, seed_state]=mult_comp_perm_t1(dif',50000);
disp(pval); %adjusted p-values

d = computeCohen_d(ON_meds.exponents, OFF_meds.exponents, 'paired');
disp(d);

% periodic beta
figure; hold on;
box_Y=[OFF_meds.datOFF.beta_per;ON_meds.datON.beta_per]';
[pval, t_orig] = plot_paired_results_med(box_Y);
ylabel('periodic beta'); 


%% Figure S3A
P=[];
figure; 
subplot(171); hold on;
box_Y=[OFF_meds.datOFF.beta_whole;ON_meds.datON.beta_whole]';
[pval] = plot_paired_results_med(box_Y);
ylabel('whole beta (13-35 Hz)'); P = [P pval];

subplot(172); hold on;
box_Y=[OFF_meds.datOFF.low_beta;ON_meds.datON.low_beta]';
[pval] = plot_paired_results_med(box_Y);
ylabel('low beta (13-20 Hz)'); P = [P pval];

subplot(173); hold on;
box_Y=[OFF_meds.datOFF.high_beta;ON_meds.datON.high_beta]';
[pval] = plot_paired_results_med(box_Y);
ylabel('high beta (21-35 Hz)'); P = [P pval];

subplot(174); hold on;
box_Y=[OFF_meds.datOFF.gamma_whole;ON_meds.datON.gamma_whole]';
[pval] = plot_paired_results_med(box_Y);
ylabel('whole gamma (35-90 Hz)'); P = [P pval];

subplot(175); hold on;
box_Y=[OFF_meds.datOFF.low_gamma;ON_meds.datON.low_gamma]';
[pval] = plot_paired_results_med(box_Y); 
ylabel('low gamma (35-50 Hz)'); P = [P pval];

subplot(176); hold on;
box_Y=[OFF_meds.datOFF.high_gamma;ON_meds.datON.high_gamma]';
[pval] = plot_paired_results_med(box_Y);
ylabel('high gamma (51-90 Hz)'); P = [P pval];

subplot(177); hold on;
box_Y=[OFF_meds.datOFF.beta_per;ON_meds.datON.beta_per]';
[pval] = plot_paired_results_med(box_Y);
ylabel('periodic beta'); P = [P pval];

sgtitle('Spectral Changes with medication');

 

%% Figure 2D

figure;
diff_beta = OFF_meds.datOFF.beta_per - ON_meds.datON.beta_per;
diff_exponents = OFF_meds.exponents - ON_meds.exponents;
my_correlations(diff_beta,diff_exponents)
xlabel('diff OFF-ON periodic beta'); ylabel('diff OFF-ON exponents');


%% Figure S3B
diff_exp = OFF_meds.exponents - ON_meds.exponents;
diff_betwhole = OFF_meds.datOFF.beta_whole - ON_meds.datON.beta_whole;
diff_bethigh = OFF_meds.datOFF.high_beta - ON_meds.datON.high_beta;
diff_betper = OFF_meds.datOFF.beta_per - ON_meds.datON.beta_per;
diff_alpha = OFF_meds.datOFF.alpha - ON_meds.datON.alpha;
diff_gamwhole = OFF_meds.datOFF.gamma_whole - ON_meds.datON.gamma_whole;
diff_gamlow = OFF_meds.datOFF.low_gamma - ON_meds.datON.low_gamma;
diff_gamhigh = OFF_meds.datOFF.high_gamma - ON_meds.datON.high_gamma;
diff_betlow = OFF_meds.datOFF.low_beta - ON_meds.datON.low_beta;


figure; 
subplot(171);
my_correlations(diff_exp,diff_betwhole);
xlabel('Aperiodic Exponents OFF-ON meds'); ylabel('beta (13-35 Hz) OFF-ON meds');

subplot(172); 
my_correlations(diff_exp,diff_betlow);
xlabel('Aperiodic Exponents OFF-ON meds'); ylabel('low beta (13-20 Hz) OFF-ON meds');

subplot(173); 
my_correlations(diff_exp,diff_bethigh);
xlabel('Aperiodic Exponents OFF-ON meds'); ylabel('high beta (21-35 Hz) OFF-ON meds');

subplot(174); 
my_correlations(diff_exp,diff_gamwhole);
xlabel('Aperiodic Exponents OFF-ON meds'); ylabel('gamma (35-90 Hz) OFF-ON meds');

subplot(175); 
my_correlations(diff_exp,diff_gamlow);
xlabel('Aperiodic Exponents OFF-ON meds'); ylabel('low gamma (35-50 Hz) OFF-ON meds');

subplot(176); 
my_correlations(diff_exp,diff_gamhigh);
xlabel('Aperiodic Exponents OFF-ON meds'); ylabel('high gamma (51-90 Hz) OFF-ON meds');

subplot(177);
in2keep = ~isnan(diff_betper);
diff_betper = diff_betper(in2keep);
diff_exp2 = diff_exp(in2keep);
my_correlations(diff_exp2,diff_betper);
xlabel('Aperiodic Exponents OFF-ON meds'); ylabel('periodic beta OFF-ON meds');


%% Figure 2F
diff_UPDRS = [6 5 7 9 3 3 NaN NaN 1 3 11 3 6 7 8 6 4 5 14 8 6 5 8 13 7 10.5 18 12.5 6 1];
diff_exp = OFF_meds.exponents - ON_meds.exponents;

in2del = ~isnan(diff_UPDRS);
diff_UPDRS = diff_UPDRS(in2del);
diff_exp = diff_exp(in2del);
figure;
my_correlations(diff_UPDRS,diff_exp);
xlabel('delta UPDRS'); ylabel('delta Exponents');

%% Figure 2E
diff_beta = OFF_meds.datOFF.beta_per  - ON_meds.datON.beta_per;
diff_UPDRS = [6 5 7 9 3 3 NaN NaN 1 3 11 3 6 7 8 6 4 5 14 8 6 5 8 13 7 10.5 18 12.5 6 1];
in2del = ~isnan(diff_UPDRS);
in2del2 = ~isnan(diff_beta);
in2de = [in2del;in2del2];

for ui=1:length(in2de)
    if in2de(:,ui)==logical([1;1])
        in2(ui) = 1;
    else
        in2(ui) = 0;
    end
end
in2=logical(in2);
diff_beta = diff_beta(in2);
diff_UPDRS = diff_UPDRS(in2);

figure;
my_correlations(diff_UPDRS,diff_beta);
xlabel('delta UPDRS'); ylabel('delta beta');

%% Figure 2B
av_spec_OFF = mean(OFF_meds.spectra,1);
av_spec_ON = mean(ON_meds.spectra,1);

figure;
loglog(av_spec_OFF,'b'); hold on;
loglog(av_spec_ON,'y');

% 4 fooof
f=1:90;
return_model=1;
settings = struct();
settings.peak_threshold=2;
settings.aperiodic_mode='fixed';
settings.peak_width_limits=[2,12];
f_range=[cm.freq1 cm.freq2];

%OFF
fooof_results = fooof(f, av_spec_OFF, f_range, settings,return_model);
loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k');

upper_lim = av_spec_OFF + std(OFF_meds.spectra,0,1)./sqrt(size(OFF_meds.spectra,1));
lower_lim = av_spec_OFF - std(OFF_meds.spectra,0,1)./sqrt(size(OFF_meds.spectra,1));
shadedplot(f,upper_lim,lower_lim,[0.1 0.1 1]); alpha(.2); grid off;
disp(['OFF meds: ' num2str(fooof_results.aperiodic_params(1,2))]);

% ON
fooof_results = fooof(f, av_spec_ON, f_range, settings,return_model);
loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');

upper_lim = av_spec_ON + std(ON_meds.spectra,0,1)./sqrt(size(ON_meds.spectra,1));
lower_lim = av_spec_ON - std(ON_meds.spectra,0,1)./sqrt(size(ON_meds.spectra,1));
shadedplot(f,upper_lim,lower_lim,[1 1 0.1]); alpha(.2); grid off;
disp(['ON meds: ' num2str(fooof_results.aperiodic_params(1,2))]);

% small plots
settings.aperiodic_mode='knee';
fooof_results = fooof(f, av_spec_OFF, [5 90], settings,return_model);
figure; fooof_plot_inv(fooof_results); grid off;

settings.aperiodic_mode='fixed';
fooof_results = fooof(f, av_spec_OFF, [40 90], settings,return_model);
figure; fooof_plot_inv(fooof_results); grid off;


end

