(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    870135,      19728]
NotebookOptionsPosition[    828122,      19061]
NotebookOutlinePosition[    828710,      19083]
CellTagsIndexPosition[    828667,      19080]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "Text",
 CellChangeTimes->{
  3.892838061691792*^9},ExpressionUUID->"3f2048e1-a330-4ae8-b6ee-\
fa9307b20e45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$Version", " ", 
  RowBox[{"(*", 
   RowBox[{
   "Mathematica", " ", "version", " ", "used", " ", "to", " ", "generate", 
    " ", "this", " ", "file", " ", "on", " ", "April", " ", "14", " ", 
    "2023."}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.7692734567819357`*^9, 3.7692735142255883`*^9}, {
  3.8905258336061263`*^9, 
  3.890525838747757*^9}},ExpressionUUID->"de37deb7-7626-43b7-8ac4-\
82899f29a343"],

Cell[BoxData["\<\"12.0.0 for Microsoft Windows (64-bit) (April 6, \
2019)\"\>"], "Output",
 CellChangeTimes->{3.8905258241930046`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"d1bc0aaf-984e-4ed7-9529-3d05b6619ff9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Distinct Mechanisms of PA", "Subtitle",
 CellChangeTimes->{{3.8448831596161394`*^9, 3.844883200949134*^9}, {
  3.8448836856030593`*^9, 
  3.844883694651808*^9}},ExpressionUUID->"a433517c-f554-4ea8-a67e-\
eaed72c059ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"baseparams", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"KA", "\[Rule]", "10"}], ",", 
     RowBox[{"Kdim", "\[Rule]", "0.1"}], ",", 
     RowBox[{"RAF", "\[Rule]", "0.04"}], ",", 
     RowBox[{"f", "\[Rule]", "0.01"}], ",", 
     RowBox[{"g", "\[Rule]", "100"}]}], "}"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{"units", ":", " ", 
    RowBox[{"\[Mu]M", " ", 
     RowBox[{"\[ForAll]", " ", 
      RowBox[{"params", " ", "but", " ", "KA"}]}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.7694414514569345`*^9, 3.7694414573922005`*^9}, {
   3.76944149182374*^9, 3.7694415974588203`*^9}, {3.7694416321176305`*^9, 
   3.769441632249299*^9}, {3.7694416704143496`*^9, 3.7694416740412297`*^9}, {
   3.7694417649156733`*^9, 3.7694418207731805`*^9}, {3.7704935587940426`*^9, 
   3.770493559185046*^9}, {3.7760926345873213`*^9, 3.776092658119856*^9}, {
   3.812398856373369*^9, 3.8123988694120045`*^9}, {3.8134208055798473`*^9, 
   3.8134208340614614`*^9}, {3.8134254027165527`*^9, 
   3.8134254462935405`*^9}, {3.817824781117114*^9, 3.817824782536111*^9}, 
   3.832686108148877*^9, {3.8326901372255416`*^9, 3.832690139773032*^9}, 
   3.8326949727528095`*^9, 3.840204404995281*^9, {3.84020476888146*^9, 
   3.8402047800397406`*^9}, 3.8402093485772605`*^9, {3.840209451893335*^9, 
   3.8402095018970814`*^9}, {3.840560717615514*^9, 3.840560725518449*^9}, {
   3.8405622868680534`*^9, 3.840562294409857*^9}, {3.840563106169935*^9, 
   3.840563106888686*^9}, {3.840563249787462*^9, 3.840563251554287*^9}, 
   3.8405633638091836`*^9, {3.840563398312266*^9, 3.8405633990472946`*^9}, 
   3.8405634715003414`*^9, {3.8405635551506157`*^9, 3.8405635610469136`*^9}, {
   3.840563663967639*^9, 3.84056366492946*^9}, {3.840563948543414*^9, 
   3.840563982212055*^9}, {3.840564133611978*^9, 3.840564136169669*^9}, {
   3.8405642023669577`*^9, 3.8405642325875387`*^9}, {3.8405643673614454`*^9, 
   3.840564428258319*^9}, 3.8405644605934925`*^9, 3.8449452214467926`*^9, {
   3.8449453826719832`*^9, 3.8449453826876597`*^9}, 3.8449454621154766`*^9, 
   3.8449455753158655`*^9, 3.844964696943206*^9, {3.8449657887844553`*^9, 
   3.8449657888879595`*^9}, {3.8449662640966043`*^9, 
   3.8449662658314333`*^9}, {3.890503739023881*^9, 3.890503739117629*^9}, {
   3.8905255461286182`*^9, 3.8905255639982204`*^9}, {3.8905257195047464`*^9, 
   3.890525745728763*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"85be83ef-dee6-420b-b284-800acb342fd8"],

Cell[CellGroupData[{

Cell["Section 1.1. Dimer Potentiation (DP) Model", "Section",
 CellChangeTimes->{{3.76919880174008*^9, 3.7691988613532224`*^9}, 
   3.769273566954769*^9, {3.8402032805684576`*^9, 3.840203284256183*^9}, {
   3.8402033256104307`*^9, 3.8402033398969493`*^9}, {3.8448836707757597`*^9, 
   3.844883671015089*^9}, {3.852300140355068*^9, 
   3.8523001451705713`*^9}},ExpressionUUID->"8339e549-a61a-4bef-b426-\
1d8f9a6db9b3"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.769456144052461*^9, 3.7694561471807184`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"f6703684-f41a-4cbb-ba18-db4410003c7e"],

Cell[CellGroupData[{

Cell["1.1.1. Analytic Solution to the model", "Subsubsection",
 CellChangeTimes->{{3.7692694154543457`*^9, 3.7692694289690504`*^9}, {
  3.769436772449255*^9, 3.769436772675357*^9}, {3.8324323477216988`*^9, 
  3.83243234796869*^9}, {3.8331596409988627`*^9, 3.8331596677817163`*^9}, {
  3.8449390771987324`*^9, 
  3.8449390774908333`*^9}},ExpressionUUID->"3ebbc829-ac63-4d88-b00e-\
2626264f778e"],

Cell["\<\
The assembled kinase state can dimerize (AA) or bind with  a drug (Ad). The \
kinase dimer (AA), upon drug administration can occur in either partly (AAd) \
or fully inhibited state (AdAd). The equilibrium state relationships and \
protein concentration conservation equations for both total RAF (RAF) and \
total drug (DTOT) are defined as follows.\
\>", "Text",
 CellChangeTimes->{{3.7692038930283422`*^9, 3.769204042191204*^9}, {
   3.7692041782201395`*^9, 3.769204211165009*^9}, {3.7692042428710303`*^9, 
   3.769204276661768*^9}, {3.7692675966867456`*^9, 3.769267724788076*^9}, 
   3.840204405025261*^9, {3.8906707135573874`*^9, 3.8906707334207544`*^9}, {
   3.8906728086058097`*^9, 
   3.8906728116494455`*^9}},ExpressionUUID->"cee0b026-1f77-4e18-9234-\
d634864d569f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vars", "=", 
    RowBox[{"{", 
     RowBox[{
     "a", ",", "A", ",", "d", ",", "AA", ",", "Ad", ",", "AAd", ",", "AdAd"}],
      "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"A", " ", "list", " ", "of", " ", "all", " ", "variables"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rep1", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AA", "\[Rule]", 
        FractionBox[
         SuperscriptBox["A", "2"], "Kdim"]}], ",", 
       RowBox[{"AAd", "\[Rule]", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["A", "2"], "d"}], 
         RowBox[{"f", " ", "Kdim", " ", "Kd"}]]}], ",", 
       RowBox[{"AdAd", "\[Rule]", 
        FractionBox[
         RowBox[{
          SuperscriptBox["A", "2"], 
          SuperscriptBox["d", "2"]}], 
         RowBox[{"f", " ", "g", " ", "Kdim", " ", 
          SuperscriptBox["Kd", "2"]}]]}], ",", 
       RowBox[{"Ad", "\[Rule]", 
        FractionBox[
         RowBox[{"A", " ", "d"}], "Kd"]}], ",", 
       RowBox[{"a", "\[Rule]", "0"}]}], "}"}], "/.", 
     RowBox[{"g", "\[Rule]", "1"}]}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "equations", " ", "derived", " ", "from", " ", "equilibrium", " ", 
    "relationships"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Consrv", "[", "eqns_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"eqns", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "5", "]"}], "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"eqns", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "+", 
          RowBox[{"eqns", "[", 
           RowBox[{"[", "6", "]"}], "]"}], "+", 
          RowBox[{"eqns", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"eqns", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "5", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "6", "]"}], "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"eqns", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ")"}]}]}], "]"}]}], "}"}]}], 
  RowBox[{"(*", 
   RowBox[{
   "conservation", " ", "relations", " ", "for", " ", "RAF", " ", "and", " ", 
    "DTOT"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"eqnsconsrv", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Consrv", "[", "vars", "]"}], "/.", "rep1"}], "]"}], 
     "\[Equal]", 
     RowBox[{"{", 
      RowBox[{"RAF", ",", "DTOT"}], "}"}]}], "]"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Solve", " ", "the", " ", "conservation", " ", "equations", " ", 
     "simplifying", " ", "to", " ", "two", " ", "variables", " ", "RAF"}], 
    ",", " ", 
    RowBox[{
    "DTOT", " ", "using", " ", "the", " ", "equilibrium", " ", 
     "relationships", " ", "above"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7692042154998837`*^9, 3.7692042369245358`*^9}, {
   3.769204285127771*^9, 3.769204341657061*^9}, {3.769204538745946*^9, 
   3.769204548488737*^9}, {3.7692045887400646`*^9, 3.7692047475109215`*^9}, {
   3.769204807283332*^9, 3.7692048197677355`*^9}, {3.7692050383825026`*^9, 
   3.769205039460601*^9}, 3.7692678297233763`*^9, {3.769267866117442*^9, 
   3.769267932844144*^9}, 3.831920876102366*^9, {3.840203420465253*^9, 
   3.8402034244005575`*^9}, {3.8402034588172636`*^9, 3.840203493631587*^9}, {
   3.8402035590005283`*^9, 3.8402036105294175`*^9}, {3.840203640947667*^9, 
   3.840203652149537*^9}, 3.8402044050372953`*^9, 3.840205102933262*^9, {
   3.8402054346609364`*^9, 3.8402054383333316`*^9}, {3.8402059632575264`*^9, 
   3.840205973480773*^9}, 3.840556391205759*^9, 3.8405564336527853`*^9, {
   3.8906708579281583`*^9, 3.8906708978241186`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"b27594b2-3328-4515-a770-ff8cf15cf958"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", "Kd", "+", 
       FractionBox[
        RowBox[{"2", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["d", "2"], "+", 
           RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
           RowBox[{"f", " ", 
            SuperscriptBox["Kd", "2"]}]}], ")"}]}], 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}]]}], ")"}]}], "\[Equal]", 
    RowBox[{"Kd", " ", "RAF"}]}], ",", 
   RowBox[{
    RowBox[{"d", "+", 
     FractionBox[
      RowBox[{"A", " ", "d"}], "Kd"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["A", "2"], " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", "Kd"}], ")"}]}], 
      RowBox[{"f", " ", 
       SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", "DTOT"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.84020358612233*^9, {3.8402036420185766`*^9, 3.840203652476896*^9}, 
   3.840205116437304*^9, 3.8402054388798523`*^9, {3.8402059636767764`*^9, 
   3.8402059789754367`*^9}, 3.840209726566143*^9, {3.8405562752292366`*^9, 
   3.840556287249528*^9}, 3.8405564210473747`*^9, 3.840556457725634*^9, 
   3.840556488652396*^9, 3.8405620386180143`*^9, 3.840563509793502*^9, 
   3.8405636766244116`*^9, 3.840564851321288*^9, 3.8405653652238607`*^9, 
   3.8406362932058015`*^9, 3.840645397059389*^9, 3.8407376748480854`*^9, 
   3.8449452735245705`*^9, 3.8449657420076237`*^9, 3.84496611588599*^9, 
   3.85230046765668*^9, 3.8905252857791996`*^9, 3.890670033012956*^9, 
   3.8906709131509695`*^9, 3.892838348809033*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"5cc72e61-8a37-4fd7-9b84-c97c5c53783b"]
}, Open  ]],

Cell["\<\
A simultaneous solution to both the above conservation equations is unwieldy \
and hard to obtain. Instead, we find partial solutions for kinase protomers \
as a function of free drug and then free drug as a function of the total drug \
and the kinase protomers. The latter solution is used to construct d vs DTOT \
relationship and prove monotonocity thereof leading to a complete solution to \
PA existence problem.\
\>", "Text",
 CellChangeTimes->{{3.769268480156312*^9, 3.7692685358509054`*^9}, {
  3.769268566916627*^9, 3.7692686085566883`*^9}, {3.890670930747447*^9, 
  3.8906709591419477`*^9}},ExpressionUUID->"2251075d-d5de-49ef-bdae-\
29a0f5988bc4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SimplifyPars", "[", "x_", "]"}], ":=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RAF", ">", "0"}], ",", 
       RowBox[{"DTOT", ">", "0"}], ",", 
       RowBox[{"Kd", ">", "0"}], ",", 
       RowBox[{"Kdim", ">", "0"}], ",", 
       RowBox[{"KA", ">", "0"}], ",", 
       RowBox[{"d", ">", "0"}], ",", 
       RowBox[{"f", ">", "0"}], ",", 
       RowBox[{"g", ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["d", "rel"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1A", "=", 
   RowBox[{
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"eqnsconsrv", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "A"}], "]"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "  ", 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol1d", "=", 
  RowBox[{
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eqnsconsrv", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "d"}], "]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7692048471231923`*^9, 3.769204893862154*^9}, {
   3.76920497064507*^9, 3.7692050944975214`*^9}, {3.7692051323859997`*^9, 
   3.7692051514924307`*^9}, 3.7692052273412123`*^9, {3.769265303470145*^9, 
   3.7692653221119733`*^9}, {3.769265358603253*^9, 3.769265393912998*^9}, {
   3.7692654276106925`*^9, 3.769265462871611*^9}, {3.7692660477712846`*^9, 
   3.7692660513184977`*^9}, {3.7692663939422703`*^9, 
   3.7692664234293437`*^9}, {3.7692681049231358`*^9, 3.769268105891485*^9}, {
   3.7692682434167233`*^9, 3.7692682738420897`*^9}, {3.7692683203389816`*^9, 
   3.7692683654636745`*^9}, {3.769436803124284*^9, 3.7694368039228525`*^9}, {
   3.812208796618473*^9, 3.812208800884694*^9}, {3.8402036688763957`*^9, 
   3.840203717780062*^9}, 3.8402044050482736`*^9, {3.8402051298175573`*^9, 
   3.8402051928218875`*^9}, {3.8402052257640953`*^9, 
   3.8402052261410127`*^9}, {3.8402054456999483`*^9, 
   3.8402054760995655`*^9}, {3.8405561466886845`*^9, 3.840556169146513*^9}, {
   3.840564863635984*^9, 3.8405648665681925`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"6c56d9b5-ff63-4ade-acb0-ddb5a27f4c02"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"A", "\[Rule]", 
   FractionBox[
    RowBox[{"Kd", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "d"}], " ", "f", " ", "Kdim"}], "-", 
       RowBox[{"f", " ", "Kd", " ", "Kdim"}], "+", 
       SqrtBox[
        RowBox[{"f", " ", "Kdim", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", 
            SuperscriptBox["Kd", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"Kdim", "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["d", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", " ", "Kdim"}], "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "d", " ", "Kd", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", " ", "Kdim"}], "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}]}], 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "+", 
       RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["Kd", "2"]}]}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, {
   3.8402051251399913`*^9, 3.8402051578204355`*^9}, 3.840205193408192*^9, 
   3.8402052267579527`*^9, {3.840205441287237*^9, 3.8402054770072174`*^9}, 
   3.840209726835723*^9, {3.8405562755417376`*^9, 3.840556287530774*^9}, 
   3.840556421159231*^9, 3.840556457996581*^9, 3.840556488905675*^9, 
   3.840562038964306*^9, 3.840563510348503*^9, 3.840563678235159*^9, {
   3.8405648543911085`*^9, 3.840564867392606*^9}, 3.8405653655781393`*^9, 
   3.840636296424547*^9, 3.8406454035205173`*^9, 3.8407376752521524`*^9, 
   3.8449452739413815`*^9, 3.844965743902709*^9, 3.844966117692833*^9, 
   3.8523004707818375`*^9, 3.890525296947047*^9, 3.8906700341320043`*^9, 
   3.8906709606601872`*^9, 3.8928383501272917`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"7e3fba42-c9a3-4abf-ba3d-2dee47f246c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"Kd", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"]}], "+", 
        RowBox[{"A", " ", "f", " ", "Kdim"}], "+", 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["A", "2"], " ", "DTOT", " ", "f", " ", "Kdim"}], 
          "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["A", "2"]}], "+", 
             RowBox[{"A", " ", "f", " ", "Kdim"}], "+", 
             RowBox[{"f", " ", "Kd", " ", "Kdim"}]}], ")"}], "2"]}]]}], 
       ")"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["A", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, {
   3.8402051251399913`*^9, 3.8402051578204355`*^9}, 3.840205193408192*^9, 
   3.8402052267579527`*^9, {3.840205441287237*^9, 3.8402054770072174`*^9}, 
   3.840209726835723*^9, {3.8405562755417376`*^9, 3.840556287530774*^9}, 
   3.840556421159231*^9, 3.840556457996581*^9, 3.840556488905675*^9, 
   3.840562038964306*^9, 3.840563510348503*^9, 3.840563678235159*^9, {
   3.8405648543911085`*^9, 3.840564867392606*^9}, 3.8405653655781393`*^9, 
   3.840636296424547*^9, 3.8406454035205173`*^9, 3.8407376752521524`*^9, 
   3.8449452739413815`*^9, 3.844965743902709*^9, 3.844966117692833*^9, 
   3.8523004707818375`*^9, 3.890525296947047*^9, 3.8906700341320043`*^9, 
   3.8906709606601872`*^9, 3.892838350472249*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"5337e15a-07c5-432b-933c-468f7facc6ac"]
}, Open  ]],

Cell["\<\
We estimate the total activity by counting all of the drug-free protomers \
which occur within a partly active or fully active dimer. Substituting the \
above solution into the expression for Raf activity and dividing by total RAF \
concentration, we obtain the proportionate activity as a function of total \
drug and other parameters.\
\>", "Text",
 CellChangeTimes->{{3.7692051569956264`*^9, 3.7692052249831033`*^9}, {
   3.7692053058924074`*^9, 3.7692053326957016`*^9}, {3.7692665900295753`*^9, 
   3.7692665948921833`*^9}, 3.7692684645670233`*^9, {3.7692686287467785`*^9, 
   3.7692686294649706`*^9}},ExpressionUUID->"1f7f02c7-2bdf-4345-bfcb-\
5176b8813e31"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RafActivity", "[", "vars_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"vars", "[", 
     RowBox[{"[", "4", "]"}], "]"}]}], " ", "+", " ", 
   RowBox[{"vars", "[", 
    RowBox[{"[", "6", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fnActiveRAFDS", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RafActivity", "[", "vars", "]"}], "/", "RAF"}], "/.", 
      "rep1"}], "/.", "sol1A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repratios", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RAF", "\[Rule]", 
      RowBox[{"Kdim", " ", 
       SubscriptBox["RAF", "rel"]}]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"Kd", " ", 
       SubscriptBox["d", "rel"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAFDS", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"fnActiveRAFDS", "/.", "repratios"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Kd", ">", "0"}], ",", 
      RowBox[{"Kdim", ">", "0"}], ",", 
      RowBox[{"RAF", ">", "0"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAF2DS", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SimplifyPars", "[", 
      RowBox[{"fnActiveRAFDS", "//.", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["RAF", "rel"], "\[Rule]", 
         FractionBox["E2d", 
          RowBox[{"8", " ", "f", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{"2", " ", 
              SubscriptBox["d", "rel"]}], "+", 
             SubsuperscriptBox["d", "rel", "2"]}], ")"}]}]]}], "}"}]}], "]"}],
      "/.", 
     RowBox[{
      SubscriptBox["d", "rel"], "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"E1d", "/", "f"}], "-", "1"}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"E1d", ">", "0"}], ",", 
      RowBox[{"E2", ">", "0"}], ",", 
      RowBox[{"f", ">", "0"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.769205220141611*^9, 3.769205289672014*^9}, {
   3.769205345593025*^9, 3.769205353284094*^9}, {3.7692054655437536`*^9, 
   3.7692054685969486`*^9}, {3.769265526917851*^9, 3.7692655613369493`*^9}, {
   3.7692655940807266`*^9, 3.7692657331243925`*^9}, {3.7692657719746237`*^9, 
   3.769265864876149*^9}, {3.7692658997040854`*^9, 3.7692659006156936`*^9}, {
   3.769266749046686*^9, 3.769266750912019*^9}, {3.769268445259807*^9, 
   3.76926844899031*^9}, {3.769268639956765*^9, 3.769268644269384*^9}, {
   3.769268830483199*^9, 3.7692688709844255`*^9}, {3.7692689173114767`*^9, 
   3.769269038442933*^9}, {3.769269089183334*^9, 3.769269285211043*^9}, {
   3.7692695137259455`*^9, 3.7692695528466825`*^9}, {3.769269651781829*^9, 
   3.76926965421002*^9}, {3.7694368136077976`*^9, 3.7694368142564898`*^9}, {
   3.7694375986201754`*^9, 3.7694376029376187`*^9}, {3.7694382649841013`*^9, 
   3.769438269629182*^9}, {3.769439034726965*^9, 3.7694390745272303`*^9}, {
   3.812214333570692*^9, 3.812214391783123*^9}, {3.8123859575711336`*^9, 
   3.812386008423128*^9}, {3.8123860614959884`*^9, 3.8123861254690137`*^9}, 
   3.831474994890194*^9, {3.8319208702531366`*^9, 3.831920870955785*^9}, {
   3.8319211759273367`*^9, 3.8319211759273367`*^9}, {3.8319237689036894`*^9, 
   3.8319237970863533`*^9}, {3.831923844715188*^9, 3.831923850773985*^9}, {
   3.831924074308251*^9, 3.8319240757594156`*^9}, {3.840203742192509*^9, 
   3.8402039027208576`*^9}, {3.840203969207242*^9, 3.8402039799679236`*^9}, {
   3.840204018691835*^9, 3.840204049292286*^9}, {3.840205234479842*^9, 
   3.8402052512181773`*^9}, {3.8402052813074675`*^9, 
   3.8402052833819304`*^9}, {3.840205495743764*^9, 3.8402055000156975`*^9}, {
   3.8402055897309823`*^9, 3.840205627554854*^9}, {3.8402057065603113`*^9, 
   3.8402057100329475`*^9}, {3.840556071641519*^9, 3.8405560932890515`*^9}, {
   3.8405561746305532`*^9, 3.8405561819378624`*^9}, 3.8405564407531*^9, {
   3.8405621660058184`*^9, 3.840562166090156*^9}, {3.840564896955063*^9, 
   3.840564904082262*^9}, {3.8405649380506086`*^9, 3.840564967764183*^9}, {
   3.8405650012661114`*^9, 3.8405650034594035`*^9}, {3.84056504334383*^9, 
   3.8405650597415347`*^9}, {3.840565103743606*^9, 3.8405651228462515`*^9}, 
   3.84056522945516*^9, {3.840565267559388*^9, 3.840565294908468*^9}, {
   3.840565354861538*^9, 3.840565357568914*^9}, {3.8406364015929375`*^9, 
   3.8406364292536926`*^9}, {3.8406364820363007`*^9, 
   3.8406365608402567`*^9}, {3.8406366048650208`*^9, 
   3.8406366134151793`*^9}, {3.840636657576851*^9, 3.840636734106155*^9}, {
   3.8406368610005436`*^9, 3.8406368683948097`*^9}, {3.8448842247374153`*^9, 
   3.844884224753049*^9}, 3.852300530430927*^9, {3.85230057912403*^9, 
   3.85230058852695*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"82f29254-105e-4d43-a7bb-4589b92ba9fe"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", 
       SubscriptBox["d", "rel"]}], "-", 
      SqrtBox[
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{
              SubscriptBox["d", "rel"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
           SubscriptBox["RAF", "rel"]}]}], ")"}]}]]}], ")"}], "2"]}], 
  RowBox[{"8", " ", "f", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{
       SubscriptBox["d", "rel"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], "2"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{{3.840205619120756*^9, 3.8402056278711433`*^9}, 
   3.8402057110197525`*^9, 3.8402097278542595`*^9, {3.8405562764506893`*^9, 
   3.840556288343272*^9}, 3.840556421268607*^9, 3.8405564589335155`*^9, 
   3.8405564898274984`*^9, 3.84056204118886*^9, 3.840562167312905*^9, 
   3.840563511398162*^9, 3.8405636794161005`*^9, 3.8405648700338926`*^9, {
   3.8405649013194375`*^9, 3.84056490459939*^9}, {3.840564952918137*^9, 
   3.8405649684184604`*^9}, 3.840565004725614*^9, {3.8405650453682985`*^9, 
   3.840565060127614*^9}, 3.8405651286996*^9, {3.8405652297518377`*^9, 
   3.840565237055297*^9}, {3.840565268405302*^9, 3.8405652955955877`*^9}, 
   3.8405653662792654`*^9, 3.840636297893309*^9, {3.8406364042640295`*^9, 
   3.840636429699123*^9}, {3.8406365247780647`*^9, 3.8406365612653103`*^9}, {
   3.8406366054590173`*^9, 3.840636614208523*^9}, {3.840636657934595*^9, 
   3.8406367348446217`*^9}, {3.840636862184847*^9, 3.840636868937417*^9}, 
   3.840645406246716*^9, 3.8407376761970916`*^9, 3.844945274627756*^9, 
   3.8449657449846153`*^9, 3.844966122669734*^9, 3.852300474123487*^9, 
   3.852300589852606*^9, 3.8905253015963726`*^9, 3.890670040863874*^9, 
   3.8906709746864853`*^9, 3.892838352183034*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"bb6110d6-91fa-47a2-b3e6-15ab737d7f76"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"E1d", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["E1d", "2"], "+", "E2d"}]]}], ")"}], "2"], " ", "f", 
   " ", 
   RowBox[{"(", 
    RowBox[{"E1d", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "f"}], ")"}], " ", "f"}]}], ")"}]}], 
  RowBox[{"E2d", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["E1d", "2"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "f"}], ")"}], " ", 
      SuperscriptBox["f", "2"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.840205619120756*^9, 3.8402056278711433`*^9}, 
   3.8402057110197525`*^9, 3.8402097278542595`*^9, {3.8405562764506893`*^9, 
   3.840556288343272*^9}, 3.840556421268607*^9, 3.8405564589335155`*^9, 
   3.8405564898274984`*^9, 3.84056204118886*^9, 3.840562167312905*^9, 
   3.840563511398162*^9, 3.8405636794161005`*^9, 3.8405648700338926`*^9, {
   3.8405649013194375`*^9, 3.84056490459939*^9}, {3.840564952918137*^9, 
   3.8405649684184604`*^9}, 3.840565004725614*^9, {3.8405650453682985`*^9, 
   3.840565060127614*^9}, 3.8405651286996*^9, {3.8405652297518377`*^9, 
   3.840565237055297*^9}, {3.840565268405302*^9, 3.8405652955955877`*^9}, 
   3.8405653662792654`*^9, 3.840636297893309*^9, {3.8406364042640295`*^9, 
   3.840636429699123*^9}, {3.8406365247780647`*^9, 3.8406365612653103`*^9}, {
   3.8406366054590173`*^9, 3.840636614208523*^9}, {3.840636657934595*^9, 
   3.8406367348446217`*^9}, {3.840636862184847*^9, 3.840636868937417*^9}, 
   3.840645406246716*^9, 3.8407376761970916`*^9, 3.844945274627756*^9, 
   3.8449657449846153`*^9, 3.844966122669734*^9, 3.852300474123487*^9, 
   3.852300589852606*^9, 3.8905253015963726`*^9, 3.890670040863874*^9, 
   3.8906709746864853`*^9, 3.8928383524026833`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"1e5d0f8e-faac-449d-b378-469d4797daf3"]
}, Open  ]],

Cell["\<\
Note that the above equations represent the total active RAF protomers in \
proportion to the total RAF kinase as a function of unbound drug (d). In \
order to analytically establish parameter values which correspond to \
activation of the kinase, we find the first derivative of the function \
fnActiveRAFDS and search for it\[CloseCurlyQuote]s zeroes in section 1.1.3. \
\>", "Text",
 CellChangeTimes->{{3.8314750261787057`*^9, 3.831475036190924*^9}, {
  3.8324318762945156`*^9, 3.832431882900982*^9}, {3.890671007739927*^9, 
  3.890671024521431*^9}, {3.8906710545564346`*^9, 
  3.8906710592512827`*^9}},ExpressionUUID->"51773d8e-ed7f-4ebd-8421-\
d1e8c1433dd1"],

Cell["\<\
First, we identify total RAF dimers and it\[CloseCurlyQuote]s proportion to \
active RAF dimers.\
\>", "Text",
 CellChangeTimes->{{3.8314750261787057`*^9, 3.831475036190924*^9}, {
  3.8324318762945156`*^9, 3.832431882900982*^9}, {3.890671007739927*^9, 
  3.890671024521431*^9}, {3.8906710545564346`*^9, 
  3.890671115721246*^9}},ExpressionUUID->"868df680-48c7-40dc-8e13-\
99cbca882402"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RafDimers", "[", "eqns_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"eqns", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnDimers", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"SimplifyPars", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"RafDimers", "[", "vars", "]"}], "/", "RAF"}], "/.", 
         "rep1"}], "/.", "sol1A"}], ")"}], "/.", "repratios"}], "]"}], ",", 
    RowBox[{"Kd", ">", "0"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"fnDimers", "/", "fnActiveRAFDS"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8319238615172873`*^9, 3.83192390513754*^9}, {
   3.831923943703373*^9, 3.8319239810051637`*^9}, {3.83192408057911*^9, 
   3.8319240873711205`*^9}, 3.84020440505526*^9, {3.840204452736744*^9, 
   3.840204473036141*^9}, {3.8402053445587087`*^9, 3.8402053629657197`*^9}, {
   3.8402060921947107`*^9, 3.840206097747354*^9}, {3.8405564461394444`*^9, 
   3.8405564711592712`*^9}, {3.840562187621331*^9, 3.8405622019040112`*^9}, 
   3.844884224753049*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"885c8a21-7b55-471d-ba00-ead600613c39"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"f", "+", 
     RowBox[{"f", " ", 
      SubscriptBox["d", "rel"]}], "-", 
     SqrtBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{
             SubscriptBox["d", "rel"], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}]}], ")"}]}]]}], ")"}], "2"], 
  RowBox[{"16", " ", "f", " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     RowBox[{
      SubscriptBox["d", "rel"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, {
   3.8402053377747016`*^9, 3.8402053639384937`*^9}, 3.8402061004365444`*^9, 
   3.84020973009111*^9, {3.840556277419983*^9, 3.840556290668762*^9}, 
   3.840556423700811*^9, {3.840556461451314*^9, 3.84055649270984*^9}, 
   3.84056204301275*^9, {3.8405621973801622`*^9, 3.8405622022899103`*^9}, 
   3.840563512944019*^9, 3.840563680886679*^9, 3.840565307311515*^9, 
   3.840565368072919*^9, 3.840636299002678*^9, 3.840636952551394*^9, 
   3.840645408705636*^9, 3.840737676971177*^9, 3.8449452752608213`*^9, 
   3.8449657457178173`*^9, 3.852300660412676*^9, 3.8905253051708713`*^9, 
   3.890670054676697*^9, 3.890671030384448*^9, 3.892838353673671*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"ad04d51a-cc29-47cc-8115-b3827ef0f956"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", "+", 
   RowBox[{
    SubscriptBox["d", "rel"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SubscriptBox["d", "rel"]}], ")"}]}]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, {
   3.8402053377747016`*^9, 3.8402053639384937`*^9}, 3.8402061004365444`*^9, 
   3.84020973009111*^9, {3.840556277419983*^9, 3.840556290668762*^9}, 
   3.840556423700811*^9, {3.840556461451314*^9, 3.84055649270984*^9}, 
   3.84056204301275*^9, {3.8405621973801622`*^9, 3.8405622022899103`*^9}, 
   3.840563512944019*^9, 3.840563680886679*^9, 3.840565307311515*^9, 
   3.840565368072919*^9, 3.840636299002678*^9, 3.840636952551394*^9, 
   3.840645408705636*^9, 3.840737676971177*^9, 3.8449452752608213`*^9, 
   3.8449657457178173`*^9, 3.852300660412676*^9, 3.8905253051708713`*^9, 
   3.890670054676697*^9, 3.890671030384448*^9, 3.892838353673671*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"fd93ad65-1120-4298-b85f-8eaaf911b561"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.2. Baseline Signaling (drug-free)", "Subsubsection",
 CellChangeTimes->{{3.812385908612563*^9, 3.812385920080598*^9}, {
  3.833159643863964*^9, 3.8331596657361794`*^9}, {3.844939079366455*^9, 
  3.8449390795295644`*^9}},ExpressionUUID->"74e2ad52-b3ff-4ee1-b099-\
cb44eae2345d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"baselineActiveRAFDS", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"fnActiveRAFDS", "/.", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", "0"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"baselineActiveRAFDS", ",", 
     SubscriptBox["RAF", "rel"]}], "]"}], ",", 
   RowBox[{
    SubscriptBox["RAF", "rel"], ">", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8123859215610027`*^9, 3.812385936919848*^9}, {
   3.8123861495330424`*^9, 3.812386224346416*^9}, {3.812386278673541*^9, 
   3.812386294471064*^9}, {3.8123863259077187`*^9, 3.8123863683020535`*^9}, {
   3.8123864109056587`*^9, 3.8123864240308285`*^9}, {3.8319211091015835`*^9, 
   3.8319211176118765`*^9}, 3.8319211759429626`*^9, {3.8402045142905054`*^9, 
   3.8402045162565413`*^9}, {3.84020537431262*^9, 3.8402054253856096`*^9}, {
   3.8402061207889004`*^9, 3.8402062072782025`*^9}, {3.840565337235036*^9, 
   3.840565337614023*^9}, {3.8405653792647724`*^9, 3.840565384166542*^9}, 
   3.844884224753049*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"865403cb-3294-412f-89b4-03418b4fce05"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"8", " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
  RowBox[{"8", " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, {3.84020537689568*^9, 3.8402053875436134`*^9}, {
   3.840206113972437*^9, 3.8402061265274963`*^9}, {3.84020616027526*^9, 
   3.8402062076542625`*^9}, 3.8405653402625895`*^9, 3.840565385330366*^9, 
   3.84063629919018*^9, 3.8406454251832085`*^9, 3.890525319426519*^9, 
   3.890670105189934*^9, 3.890671359572144*^9, 3.8928383876370726`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"14c9c3e3-a5a4-4d69-9b53-72b4190db019"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"8", " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
  RowBox[{"8", " ", 
   SubsuperscriptBox["RAF", "rel", "2"], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"8", " ", 
      SubscriptBox["RAF", "rel"]}]}]]}]]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, {3.84020537689568*^9, 3.8402053875436134`*^9}, {
   3.840206113972437*^9, 3.8402061265274963`*^9}, {3.84020616027526*^9, 
   3.8402062076542625`*^9}, 3.8405653402625895`*^9, 3.840565385330366*^9, 
   3.84063629919018*^9, 3.8406454251832085`*^9, 3.890525319426519*^9, 
   3.890670105189934*^9, 3.890671359572144*^9, 3.892838387715682*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"e44a4934-4a23-4c3e-b2da-bc971044a0d2"]
}, Open  ]],

Cell[TextData[{
 "The derivative of baseline signaling relative to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["RAF", "rel"], TraditionalForm]],ExpressionUUID->
  "f3a138bf-45e7-48d3-a8d4-fa46a67f58b0"],
 " is a positive definite function. Therefore, baseline signaling is a \
monotonically proportionate to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["RAF", "rel"], TraditionalForm]],ExpressionUUID->
  "4cc0d701-42d2-45bb-ba40-ad61b0fc64d7"],
 ", which is in turn, monotonically proportionate to RAF concentration and \
monotonically inverse relationship to Kdim."
}], "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
  3.812386377540579*^9, 3.8123864833252983`*^9}, {3.840565407742777*^9, 
  3.840565441838941*^9}},ExpressionUUID->"48905c9e-1437-480a-a669-\
046d84cba7c5"],

Cell[TextData[{
 "Hence in the DS model, increasing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["RAF", "rel"], " "}], TraditionalForm]],ExpressionUUID->
  "5c8b8f78-9073-48f0-a2fb-3d7ff5de2cd6"],
 " increases baseline signaling. This is a simple analytic cross-check of \
expected behaviors in this model."
}], "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
   3.812386377540579*^9, 3.812386508943284*^9}, 3.831493576900573*^9, {
   3.840565448325954*^9, 3.8405654516410184`*^9}, {3.8906713814950824`*^9, 
   3.8906713961110954`*^9}},ExpressionUUID->"41655097-1be6-40db-a179-\
aac69eeabe24"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.1.3. Conditions on parameter regions for activation in response to the drug\
\>", "Subsubsection",
 CellChangeTimes->{{3.769352693017748*^9, 3.7693527442245555`*^9}, 
   3.8319232589041615`*^9, {3.833159646729958*^9, 3.833159664629573*^9}, {
   3.844939080546801*^9, 
   3.844939080662428*^9}},ExpressionUUID->"0fe2acce-8a85-4b6e-a315-\
83eea93ccf3a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dfn12", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"fnActiveRAFDS", ",", 
     SubscriptBox["d", "rel"]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.755541810342499*^9, 3.7555418608619113`*^9}, {
   3.755541978622472*^9, 3.7555419807907124`*^9}, {3.7555571218326187`*^9, 
   3.7555571219456987`*^9}, {3.7556152697929463`*^9, 3.755615271368307*^9}, {
   3.755615528332312*^9, 3.7556155322520323`*^9}, {3.755615647889366*^9, 
   3.755615736790206*^9}, {3.7556192151498156`*^9, 3.7556192592915344`*^9}, {
   3.755619311851678*^9, 3.75561931599358*^9}, {3.7556396242742844`*^9, 
   3.755639637221635*^9}, {3.7590911604934464`*^9, 3.759091242876088*^9}, {
   3.759091274647378*^9, 3.759091275112709*^9}, 3.7646075097588253`*^9, {
   3.7692693888047943`*^9, 3.769269390671215*^9}, {3.7692695640617847`*^9, 
   3.7692696334602895`*^9}, {3.7692696651592636`*^9, 3.7692696859256325`*^9}, 
   3.769436826714548*^9, {3.8129938947361474`*^9, 3.8129939100528193`*^9}, 
   3.831920887884055*^9, 3.8319211759429626`*^9, 3.8402045504842486`*^9, {
   3.8405654709095154`*^9, 3.8405654709940224`*^9}, 3.844884224753049*^9},
 CellLabel->"In[18]:=",ExpressionUUID->"f6e18b61-0dca-45de-b934-eb117728eb8e"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", "f", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"f", "+", 
       RowBox[{
        SubscriptBox["d", "rel"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], "3"], " ", 
    SubscriptBox["RAF", "rel"]}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"f", "+", 
     RowBox[{"f", " ", 
      SubscriptBox["d", "rel"]}], "-", 
     SqrtBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{
             SubscriptBox["d", "rel"], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}]}], ")"}]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{
         SubscriptBox["d", "rel"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "-", 
        FractionBox[
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SubscriptBox["d", "rel"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{"8", " ", 
             SubscriptBox["RAF", "rel"]}]}], ")"}]}], 
         SqrtBox[
          RowBox[{"f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
             RowBox[{"8", " ", 
              RowBox[{"(", 
               RowBox[{"f", "+", 
                RowBox[{
                 SubscriptBox["d", "rel"], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
              SubscriptBox["RAF", "rel"]}]}], ")"}]}]]]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"f", " ", 
         SubscriptBox["d", "rel"]}], "-", 
        SqrtBox[
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{"f", "+", 
               RowBox[{
                SubscriptBox["d", "rel"], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
             SubscriptBox["RAF", "rel"]}]}], ")"}]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{
         SubscriptBox["d", "rel"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"f", " ", 
         SubscriptBox["d", "rel"]}], "-", 
        SqrtBox[
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{"f", "+", 
               RowBox[{
                SubscriptBox["d", "rel"], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
             SubscriptBox["RAF", "rel"]}]}], ")"}]}]]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.8928384016685677`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"c0f78e60-322f-4548-bd0a-1176a7531857"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"existPADS", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Reduce", "[", 
    RowBox[{"dfn12", ">", "0"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8406454416015234`*^9, 3.840645455094884*^9}, {
  3.840645527623123*^9, 3.840645548071183*^9}, {3.8406455793475046`*^9, 
  3.8406455802647233`*^9}, {3.840645730738617*^9, 3.8406457329731913`*^9}, {
  3.8406466256361165`*^9, 3.8406466256983*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"dd19bc0a-bd97-4a2e-90d5-7782d45fdfe4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", 
     SubscriptBox["RAF", "rel"], "<", 
     FractionBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{"8", " ", "f"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["f", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"6", " ", "f"}]}], ")"}], " ", 
          SubscriptBox["d", "rel"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "f", "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["f", "2"]}]}], ")"}], " ", 
          SubsuperscriptBox["d", "rel", "2"]}], "-", 
         RowBox[{"4", " ", "f", " ", 
          SubsuperscriptBox["d", "rel", "3"]}], "-", 
         SubsuperscriptBox["d", "rel", "4"]}], ")"}]}], 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"2", " ", "f", " ", 
           SubscriptBox["d", "rel"]}], "+", 
          SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "f"}], "+", 
      SubscriptBox["d", "rel"]}], "<", "1"}], "&&", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[LessEqual]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"f", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"]}], 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"2", " ", 
           SubscriptBox["d", "rel"]}], "+", 
          SubsuperscriptBox["d", "rel", "2"]}], ")"}]}]]}], "<", 
     SubscriptBox["RAF", "rel"], "<", "0"}], "&&", 
    RowBox[{"f", ">", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{"8", " ", "f"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["f", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"6", " ", "f"}]}], ")"}], " ", 
          SubscriptBox["d", "rel"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "f", "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["f", "2"]}]}], ")"}], " ", 
          SubsuperscriptBox["d", "rel", "2"]}], "-", 
         RowBox[{"4", " ", "f", " ", 
          SubsuperscriptBox["d", "rel", "3"]}], "-", 
         SubsuperscriptBox["d", "rel", "4"]}], ")"}]}], 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"2", " ", "f", " ", 
           SubscriptBox["d", "rel"]}], "+", 
          SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]], "<", 
     SubscriptBox["RAF", "rel"], "<", "0"}], "&&", 
    RowBox[{"f", "\[LessEqual]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["d", "rel"], ">", "1"}], "||", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "f"}], "+", 
        SubscriptBox["d", "rel"]}], ">", "1"}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.840645451202583*^9, 3.8406454743784385`*^9}, {
   3.8406455405860806`*^9, 3.840645584502401*^9}, 3.8406457387303486`*^9, 
   3.840646627375697*^9, 3.8905253591998916`*^9, {3.890671426018639*^9, 
   3.8906714408603563`*^9}, 3.89283846455672*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"a0b5c974-5f8c-4be1-aacc-ed3ab5379200"]
}, Open  ]],

Cell["\<\
Conditions for positive derivative of active RAF relative to unbound drug are \
shown above. However, RAF concentration is a positive definite quantity.\
\>", "Text",
 CellChangeTimes->{{3.8406455159354043`*^9, 3.8406455226362214`*^9}, {
  3.840645586307036*^9, 3.8406455955655184`*^9}, {3.840645694674875*^9, 
  3.840645725719434*^9}, {3.8406457620525007`*^9, 3.840645769791148*^9}, {
  3.890671421662835*^9, 
  3.890671425002516*^9}},ExpressionUUID->"7f0c2200-0553-4b67-a494-\
c35cbd9bfaea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"existPADS", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"existPADS", ",", 
    RowBox[{
     SubscriptBox["RAF", "rel"], ">", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8406457392856026`*^9, 3.840645782502263*^9}, {
  3.8906714342447786`*^9, 3.89067143549606*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"c87db696-04c5-4ca6-b35f-ea9031104adb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["RAF", "rel"], "<", 
   FractionBox[
    RowBox[{"f", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"8", " ", "f"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["f", "2"]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"6", " ", "f"}]}], ")"}], " ", 
        SubscriptBox["d", "rel"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "f", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["f", "2"]}]}], ")"}], " ", 
        SubsuperscriptBox["d", "rel", "2"]}], "-", 
       RowBox[{"4", " ", "f", " ", 
        SubsuperscriptBox["d", "rel", "3"]}], "-", 
       SubsuperscriptBox["d", "rel", "4"]}], ")"}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"2", " ", "f", " ", 
         SubscriptBox["d", "rel"]}], "+", 
        SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "f"}], "+", 
    SubscriptBox["d", "rel"]}], "<", "1"}], "&&", 
  RowBox[{
   SubscriptBox["d", "rel"], "\[LessEqual]", "1"}]}]], "Output",
 CellChangeTimes->{
  3.840645752771097*^9, 3.840645784349844*^9, 3.840646629158352*^9, 
   3.8905253593219414`*^9, {3.890671426190538*^9, 3.8906714412577524`*^9}, 
   3.8928384648232317`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"83f562ba-8223-485f-a3fd-e42d8fdb22f9"]
}, Open  ]],

Cell["\<\
The above condition is realizable only when, the second and third conditions \
are true:  d<Kd(1-2f) and d<Kd. The latter condition is automatically true  \
when former one is. Further, the former condition can only be true when 2f<1, \
i.e. f<0.5 instead of f<1: which one would naively expect.\
\>", "Text",
 CellChangeTimes->{{3.8406457864258285`*^9, 3.8406459081496286`*^9}, {
  3.8406467104769263`*^9, 3.840646721580673*^9}, {3.890671544677163*^9, 
  3.8906715522648616`*^9}, {3.890671594147986*^9, 
  3.890671654906542*^9}},ExpressionUUID->"30791d99-5caf-4ac6-8203-\
6577e4585885"],

Cell["\<\
The first condition can only be True when the RHS is positive, since LHS is \
always so.\
\>", "Text",
 CellChangeTimes->{{3.8406457864258285`*^9, 3.8406459081496286`*^9}, {
  3.8406467104769263`*^9, 3.8406467396482663`*^9}, {3.8906715295255575`*^9, 
  3.890671538929841*^9}},ExpressionUUID->"fe89cd92-ca04-4900-a937-\
d08e9e99ea96"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"existPADS2", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Reduce", "[", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"existPADS", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], ">", "0"}], ")"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8406459097104216`*^9, 3.840646029538254*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"9195e0b1-cb56-4518-9f61-c36b36ae9f80"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "f"}], "+", 
      SubscriptBox["d", "rel"]}], "<", "1"}], "&&", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[LessEqual]", "1"}]}], ")"}], "||", 
  RowBox[{"f", ">", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      SubscriptBox["d", "rel"], "+", 
      RowBox[{"2", " ", 
       SubsuperscriptBox["d", "rel", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SubscriptBox["d", "rel"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{"9", "+", 
         RowBox[{"4", " ", 
          SubscriptBox["d", "rel"]}], "+", 
         RowBox[{"4", " ", 
          SubsuperscriptBox["d", "rel", "2"]}]}]]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{{3.840645915988125*^9, 3.8406460306558447`*^9}, 
   3.8406466326966677`*^9, 3.890525359437704*^9, 3.89067166437088*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"58e57a75-6833-4145-942c-82065dc31446"]
}, Open  ]],

Cell["\<\
The first condition is identical to second and third conditions of existPADS \
which implies that f<0.5. The second alternate condition is f>3/4 + a \
positive number, which is a direct contradiction. Only one of these \
conditions can be satisfied. However, since the logic of existPADS equation \
is (A|B)&A the solution is A alone.\
\>", "Text",
 CellChangeTimes->{{3.8406461947838926`*^9, 3.8406462435219827`*^9}, {
  3.8906718068879848`*^9, 
  3.890671999313088*^9}},ExpressionUUID->"040c1850-bc86-4d71-8314-\
bc2dad28feee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"existPADS", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.840646590205721*^9, 3.840646591046356*^9}, {
  3.8906719886788006`*^9, 3.8906719888202977`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"8bd4d828-2a2c-41d5-a0cf-3c35780a0d31"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "f"}], "+", 
   SubscriptBox["d", "rel"]}], "<", "1"}]], "Output",
 CellChangeTimes->{
  3.840646756354841*^9, 3.8905253598848147`*^9, {3.8906719827824116`*^9, 
   3.890671989194996*^9}},
 CellLabel->"Out[26]=",ExpressionUUID->"2cdbf8fc-1637-460b-a743-c1e0e5f1c240"]
}, Open  ]],

Cell[TextData[{
 "Hence we derive the above, necessary but not sufficient condition for PA. \
It also suggests that for sufficiently small concentration of RAF and \
sufficiently small f, there is a small enough concentration of drug for which \
PA will be observed within this model. \[LineSeparator]Also, since ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", "rel"], TraditionalForm]],ExpressionUUID->
  "35faff34-992f-44e4-bd5b-f2146c70a6ac"],
 "<DTOT/Kd, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "f"}], "<", 
    RowBox[{"1", "-", 
     SubscriptBox["d", "rel"]}]}], TraditionalForm]],ExpressionUUID->
  "bee01298-6b9e-4c0f-9df6-676c51a361ad"],
 " is automatically satisfied if 2f<1-DTOT/Kd.\[LineSeparator]A corollary: \
with sufficiently high drug concentration, this condition cannot be \
satisfied. That is a validation that this model does not support motonic rise \
in activation in repsonse to the drug, eventually, the activity gets reduced."
}], "Text",
 CellChangeTimes->{{3.8406467613049736`*^9, 3.840646936909045*^9}, {
  3.840647717320901*^9, 3.84064779199535*^9}, {3.890672098734612*^9, 
  3.890672171426286*^9}},ExpressionUUID->"083ab68a-95f6-4477-9708-\
f781d792feab"],

Cell["\<\
Can PA exist even when above conditions are not satisfied? That is the first \
derivative of active RAF relative to drug is negative near zero drug but then \
becomes positive? And then negative again (since high drug conc have to go to \
zero)? - the possibility cannot be ruled out at this stage. This is why the \
conditions are necessary but not sufficient.\
\>", "Text",
 CellChangeTimes->{{3.840648878693261*^9, 3.8406490237229977`*^9}, {
  3.8906722466155577`*^9, 
  3.8906722694926634`*^9}},ExpressionUUID->"63379602-4ce2-43f2-bc46-\
53ae78521334"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.1.4. Monotonic relationship between unbound (d) and total (DTOT) drug \
concentrations\
\>", "Subsubsection",
 CellChangeTimes->{{3.7692694343293085`*^9, 3.76926946891394*^9}, 
   3.7692701230017385`*^9, {3.769436773797412*^9, 3.7694367744539824`*^9}, 
   3.8319232632660522`*^9, {3.833159649860316*^9, 3.8331596633192616`*^9}, {
   3.8449390816181946`*^9, 
   3.8449390817028*^9}},ExpressionUUID->"74e2a222-c776-4787-ac90-\
c0ce9cfa9513"],

Cell["\<\
For some of the conclusions with regards to PA to hold, the relationship \
between unbount and total drug has to be monotonic.\
\>", "Text",
 CellChangeTimes->{{3.8906723003575497`*^9, 
  3.890672367990926*^9}},ExpressionUUID->"b6694f68-5f92-44d1-8d1b-\
e64ea9ac20f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqnsconsrv", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8406493185496225`*^9, 3.8406493229729967`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"8ef732bd-85cb-446e-a7f5-ddf2aec74a77"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "+", 
   FractionBox[
    RowBox[{"A", " ", "d"}], "Kd"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["A", "2"], " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", "Kd"}], ")"}]}], 
    RowBox[{"f", " ", 
     SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", 
  "DTOT"}]], "Output",
 CellChangeTimes->{{3.8406493203772135`*^9, 3.8406493232503595`*^9}, 
   3.8905253629152417`*^9, 3.890672283095463*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"92269618-d152-4d09-83db-e78c895b8b36"]
}, Open  ]],

Cell["\<\
The derivative of the function DTOT relative to d is the sum of the \
derivative of different terms within the second equation in expression above. \
Among these the derivative of the first term is 1. And the derivative of the \
second and third term are shown as non-negative functions of unbound drug d, \
below.\
\>", "Text",
 CellChangeTimes->{{3.8320850810009933`*^9, 3.8320851682942505`*^9}, {
  3.8406493515681677`*^9, 
  3.8406493647694645`*^9}},ExpressionUUID->"57b21d77-b8d9-4e30-95d7-\
d008271a1e57"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd11", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"A", "*", "d"}], "/.", "sol1A"}], ",", "d"}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd11", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd11", "<", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", "rd11", "]"}]}], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.812209716555067*^9}, 3.840204651633864*^9, {3.8406490428350587`*^9, 
   3.8406490754211674`*^9}, {3.840649109957098*^9, 3.8406491183726187`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"341ebc5c-9ee4-40ee-9a09-fb54e34dd28a"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.840204662010409*^9, 3.840206479673562*^9, {3.840649038833641*^9, 
   3.8406490791421223`*^9}, {3.8406491113870277`*^9, 3.840649120376279*^9}, 
   3.890525379683055*^9, 3.890672295103896*^9, 3.8906723779848394`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"ee35e12e-cc4e-4d62-822d-76b9791fea21"]
}, Open  ]],

Cell["The first component is positive definite.", "Text",
 CellChangeTimes->{{3.890672407765128*^9, 
  3.8906724180578847`*^9}},ExpressionUUID->"8a0e952d-db16-470f-81d6-\
ba07185cf988"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sd12", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["A", "2"], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", "Kd"}], ")"}]}], "/.", "sol1A"}], "]"}], ",", 
     "d"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.8122097406433277`*^9}, {3.812209825300347*^9, 3.8122098312563896`*^9}, {
   3.812209894920068*^9, 3.812209908923931*^9}, {3.812210163614968*^9, 
   3.8122102029627514`*^9}, 3.8129943016148033`*^9, {3.832085249170616*^9, 
   3.832085251410651*^9}, {3.8320853702376328`*^9, 3.8320853722836037`*^9}, {
   3.832085440475006*^9, 3.8320854515514917`*^9}, {3.8406491281449385`*^9, 
   3.8406491378230104`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"49ecb16e-6066-4ef7-9cfa-aad45f9a87b9"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "+", 
       RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["Kd", "2"]}]}], ")"}], "3"]}]], 
  RowBox[{
   SuperscriptBox["Kd", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", " ", "f", " ", "Kdim"}], "+", 
     RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
     SqrtBox[
      RowBox[{"f", " ", "Kdim", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", " ", 
          SuperscriptBox["Kd", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"Kdim", "+", 
            RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "Kdim"}], "+", 
            RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "d", " ", "Kd", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "Kdim"}], "+", 
            RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"f", " ", "Kdim"}], "-", 
        FractionBox[
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"d", "+", "Kd"}], ")"}], " ", "Kdim", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "Kdim"}], "+", 
            RowBox[{"8", " ", "RAF"}]}], ")"}]}], 
         SqrtBox[
          RowBox[{"f", " ", "Kdim", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", " ", 
              SuperscriptBox["Kd", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"Kdim", "+", 
                RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["d", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", " ", "Kdim"}], "+", 
                RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
             RowBox[{"2", " ", "d", " ", "Kd", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", " ", "Kdim"}], "+", 
                RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", "d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"d", "+", "Kd"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", "f", " ", "Kdim"}], "+", 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
        SqrtBox[
         RowBox[{"f", " ", "Kdim", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", 
             SuperscriptBox["Kd", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"Kdim", "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["d", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", " ", "Kdim"}], "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", "d", " ", "Kd", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", " ", "Kdim"}], "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}]}], 
     "+", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", "f", " ", "Kdim"}], "+", 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
        SqrtBox[
         RowBox[{"f", " ", "Kdim", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", 
             SuperscriptBox["Kd", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"Kdim", "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["d", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", " ", "Kdim"}], "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", "d", " ", "Kd", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", " ", "Kdim"}], "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}]}], 
     "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", "f", " ", "Kdim"}], "+", 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
        SqrtBox[
         RowBox[{"f", " ", "Kdim", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", 
             SuperscriptBox["Kd", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"Kdim", "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["d", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", " ", "Kdim"}], "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", "d", " ", "Kd", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", " ", "Kdim"}], "+", 
               RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.8406491382272882`*^9, 3.8905253821543784`*^9, 
  3.8906724266430035`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"6a2a4d41-9063-450d-b10e-586d18261a16"]
}, Open  ]],

Cell["\<\
Note that the first non-trivial product term in this expression is negative \
definite. This is because the term inside the square root is always greater \
than the term outside. So we focus on the second, larger term.\
\>", "Text",
 CellChangeTimes->{{3.832085456271301*^9, 3.8320855058848753`*^9}, {
  3.890672457082588*^9, 
  3.8906724781691875`*^9}},ExpressionUUID->"d6628e93-9b95-4723-b10e-\
8654ea9d5959"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd121", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"sd12", "[", 
     RowBox[{"[", 
      RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd12", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd121", ">", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", "rd12", "]"}]}], "Input",
 CellChangeTimes->{{3.8320855104825225`*^9, 3.832085576939461*^9}, 
   3.8320856157697144`*^9, {3.832085673481617*^9, 3.832085684156937*^9}, {
   3.8406492934872203`*^9, 3.840649294199462*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"b495ae07-b582-422d-801e-a90de1868dea"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.8406492925583153`*^9, 3.8406493056123333`*^9}, 
   3.8905254234492273`*^9, 3.8906725021263943`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"dd55b333-6d78-4bb3-a6db-bfcd131f1a6d"]
}, Open  ]],

Cell["\<\
Since the expression sd121 is never positive. Also, the coefficient to sd121 \
in sd12 is negative definite as stated above. Therefore the full expression \
sd12 which a product of the two is non negative for all positive values of \
the parameters.\
\>", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211189353238*^9}, {3.832085645561462*^9, 3.8320857371734977`*^9}, {
  3.8406494312123423`*^9, 3.8406494964348993`*^9}, {3.8906725032232275`*^9, 
  3.890672511403341*^9}},ExpressionUUID->"c740681e-cf82-47e5-91a7-\
e7a3c012d834"],

Cell["DTOT=d+sd11+sd12", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211207502667*^9}},ExpressionUUID->"80f5c64f-6d66-40ec-b0de-\
08dc0da31ea2"],

Cell["\<\
Since all three expressions on RHS are non-negative derivatives as a function \
of unbound drug - the total drug has a non-negative derivative. Therefore, \
DTOT(d) is monotonically positive/increasing function.\[LineSeparator]We \
exemplify this point numerically with an example set of parameters in the \
plot below.\
\>", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.8122112898940353`*^9}, {3.832085750901709*^9, 3.8320858105658555`*^9}, {
  3.890672544017391*^9, 
  3.8906725497225866`*^9}},ExpressionUUID->"7643025b-c049-4a17-be9c-\
4af9f64d3160"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fnDTOT", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"eqnsconsrv", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "/.", "rep1"}], "/.", "sol1A"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7585572574558153`*^9, 3.7585573278649125`*^9}, {
   3.759595163226753*^9, 3.7595951983626966`*^9}, {3.759600640284622*^9, 
   3.7596006451030445`*^9}, 3.7646075104463263`*^9, {3.7646202269105544`*^9, 
   3.764620227426238*^9}, {3.7692714662387505`*^9, 3.7692714835925064`*^9}, {
   3.76927153667768*^9, 3.769271545331811*^9}, 3.769436866848941*^9, 
   3.840206492524761*^9, {3.8406495109769974`*^9, 3.8406495537697053`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"efb92fb1-1aec-4c64-9a11-756d08a0386b"],

Cell[BoxData[
 RowBox[{"d", "+", 
  FractionBox[
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"d", "+", "Kd"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", " ", "f", " ", "Kdim"}], "+", 
       RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
       SqrtBox[
        RowBox[{"f", " ", "Kdim", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", 
            SuperscriptBox["Kd", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"Kdim", "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["d", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", " ", "Kdim"}], "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "d", " ", "Kd", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", " ", "Kdim"}], "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}], 
     "2"]}], 
   RowBox[{"8", " ", "f", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "+", 
       RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["Kd", "2"]}]}], ")"}], "2"], " ", "Kdim"}]], "+", 
  FractionBox[
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", "f", " ", "Kdim"}], "-", 
      RowBox[{"f", " ", "Kd", " ", "Kdim"}], "+", 
      SqrtBox[
       RowBox[{"f", " ", "Kdim", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", " ", 
           SuperscriptBox["Kd", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"Kdim", "+", 
             RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["d", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", " ", "Kdim"}], "+", 
             RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
          RowBox[{"2", " ", "d", " ", "Kd", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", " ", "Kdim"}], "+", 
             RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}]}], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["d", "2"], "+", 
      RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["Kd", "2"]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.8406495156370397`*^9, 3.8406495540664597`*^9}, 
   3.890525424096425*^9, 3.8906725283519897`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"c8cacd6d-1f51-4e7c-a9a0-7ebe9974b203"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Sty", "[", "x_", "]"}], ":=", 
   RowBox[{"Style", "[", 
    RowBox[{"x", ",", "20", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KTarr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}], ",", 
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], ",", 
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kdarr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kd", "\[Rule]", " ", 
      RowBox[{"1.", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], " ", ",", 
     RowBox[{"Kd", "\[Rule]", " ", 
      RowBox[{"1.", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pltfn", "=", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"fnDTOT", "/.", "kd"}], ",", 
       RowBox[{"{", 
        RowBox[{"kd", ",", "kdarr"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"RAF", ",", "KTarr"}], "}"}]}], "]"}], "]"}], "/.", 
    "baseparams"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ps", "=", 
   RowBox[{"{", 
    RowBox[{"Blue", ",", "Green", ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Thick"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Blue", ",", "Dashed"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Green", ",", "Dashed"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Dashed", ",", "Thick"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LogLogPlot", "[", 
  RowBox[{"pltfn", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "9"}]], ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "5"}]]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "20"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "ps"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Green", ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"Sty", "/@", "KTarr"}], ",", 
        RowBox[{"LegendLabel", "\[Rule]", 
         RowBox[{"Sty", "[", "\"\<RAF(M)\>\"", "]"}]}], ",", 
        RowBox[{"LegendFunction", "\[Rule]", "Panel"}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", "12"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"Sty", "/@", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Unbound Drug [d] (M)\>\"", ",", "\"\<Total Drug [DTOT] (M)\>\""}],
        "}"}]}], ")"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", "500", "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "0.004", "]"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{
    "Sty", "[", 
     "\"\<\!\(\*SubscriptBox[\(K\), \(d\)]\): \[LongDash]100nM  - -1nM \
\!\(\*SubscriptBox[\(K\), \(A\)]\):10\>\"", "]"}]}]}], 
  RowBox[{"(*", 
   RowBox[{"N", "[", 
    RowBox[{"TableForm", "[", 
     RowBox[{"parset01", ",", 
      RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}], "]"}], "*)"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.7585573502790737`*^9, {3.758557416662918*^9, 3.758557417800726*^9}, {
   3.7585574593029137`*^9, 3.75855752487545*^9}, {3.75855757528645*^9, 
   3.758557667757551*^9}, {3.758563426348437*^9, 3.7585634495480337`*^9}, 
   3.7590891396170406`*^9, {3.7596006546458197`*^9, 3.7596006554774103`*^9}, {
   3.7596011740167646`*^9, 3.75960122809816*^9}, {3.759601636287717*^9, 
   3.7596016621483*^9}, 3.7646075104932013`*^9, {3.7646203458456097`*^9, 
   3.764620454737575*^9}, {3.7646854996493673`*^9, 3.7646855037115173`*^9}, {
   3.7646859794921045`*^9, 3.7646860158481245`*^9}, {3.764686073184255*^9, 
   3.7646861544838943`*^9}, {3.764686211793691*^9, 3.7646862572125545`*^9}, {
   3.7646862904244523`*^9, 3.764686405427883*^9}, {3.7646864687285037`*^9, 
   3.7646865180442343`*^9}, {3.764686572759493*^9, 3.7646866878734045`*^9}, {
   3.764686719694611*^9, 3.7646867785222187`*^9}, {3.764686812610632*^9, 
   3.764686838179757*^9}, {3.7646868689586616`*^9, 3.7646868700991297`*^9}, {
   3.7646869951421323`*^9, 3.7646870070846577`*^9}, 3.764687038631254*^9, {
   3.766864949929313*^9, 3.7668649867287836`*^9}, {3.766865028396298*^9, 
   3.766865051889716*^9}, {3.7668656601959724`*^9, 3.766865718566044*^9}, {
   3.7668667541434526`*^9, 3.7668669007405806`*^9}, {3.7692715532102327`*^9, 
   3.7692715605764265`*^9}, {3.769271606645773*^9, 3.769271608832777*^9}, {
   3.7692716587496634`*^9, 3.7692716848105907`*^9}, {3.832168622315541*^9, 
   3.8321686610862274`*^9}, 3.8402044051998596`*^9, {3.840204677480768*^9, 
   3.8402046829517097`*^9}, {3.84064956027425*^9, 3.8406495873354588`*^9}, {
   3.8406496288792133`*^9, 3.840649655902847*^9}, {3.8905255144084764`*^9, 
   3.8905255329221826`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"5a15040c-b22f-44b8-98c0-7d06e7c097a0"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVj3tUjHkAhiMZSRrhREeI5vvNN9fv+2baQm51rBpJq6YJlUuSKcSmjrC2
TjVtV87u1kkuSy5bWyTdW9aLsWitVLqX2hYRNV1UyGHbP57z/vm8j+2OsI1B
E42MjNaP8//+eW1SP6lQ4swWn1NCNYe0lL7qfeVKFLjpyQFvDprdTQUlZUrc
sAsqqfDi8GpBfphLqRKePJenqo0cTI97GQKKlGjSJizcu4GD+97svvQrSgy/
HxoqdONQS6/qNc5WYixBl+K0gkNH9pGejiQllOcNZWrC4cMJ3foiXyVi0oIt
7wyz4PJ3/dNMK9HNJVT+fJ+F6Pm18jdjCpzf5jt7fxYLuznH38+pUsBGo6q5
oGXhFOWsPXlKgekDgVtUTix8GhKd7bUKjITdnhRkxkLuuWzrDQcFnP2T/Qpb
GVCjt/MzTBXgpL9cjCtgsCCrbUdKI4dHXbXclGgGX4U8cqvP4TD4k+Kt0JvB
NA110PQIh3dLE8N/pRk8XzmLt2m86/DkHP6O93K0qBurxqzHu8VLSkcvylEb
LButeMXigkvuao27HIkZhl2BZSzythzz3T0qQ8BgPG9bIovoReFa1W8y2Kuu
8Q9pWBhXD/AVm2QQVReo/hWyuJx0mS/gy2Dr6dKrHWEwUrp2nbVeisbeVXWt
egZFN2mP6qNS5JXP7DmXwYAn9TXsXy5FzPeHtTE7Gbj2qwqXfZIgIrx0bok9
g8L408Zn70hAx/mZP+UxWO3vpbVKleCmrbRuXr4c/u1PLtj4SLAzfV2vwwY5
XnssdNQKJLCY8GNTYo8Mz4ZGoiYOieF4OV91PUGGZNf+2KC7Ypy5dGB+jFgG
2cNwf+tMMSafCbiruy9FzYOcg+VaMfL6hh9yIVL4G8W9Vq8Qozpqu6ZkuhSX
rur8BTPFGPn0rmRfngSiYo28t0uETS1c5GMPCf6qvTF3cbEIKMjkBfWIoV/c
wxiOiRDYkfPxfIoYS3xMBIkqEeJdUw+WMGKE1jU4amaJkJd78taXRyJYzYKA
a6BhHuS5pz9MBMc2Q81QJo1v58h7rMxECOUnbzT3ouFj0tU3O4fGg5i8ewNT
aUS6r1RXrqPhHZveV6YXIitZn5LeLYTlhLiAtAghPtq9E1glCfGmNLTejBai
eXR0TZhMiNqp332payX4/c5ih89VBL36LHV9PEFz94dExT6Cz0n9s28pCDbf
S1em7yE43VjT4s4RtGWzHSMhBIcMxdEtDEGnv1ZZGUxwzLkqbFhK8LKu6dmq
7QR3g5XttJBg8FaZwsObQARTk9R5BNMyI9p3LyV4wcbylpsQpEXM+KHKkcDt
XKfFfWMCC68rnMSB4HpVzJjnRALL6S8SDOM/jrbWH935hcLcOG8uctyTKiqk
kz5QoPYrEmIXElTKopc96aWQs76afTGfoH3NhmjftxRocWjb1zYEdoKo3M4e
CpKX2exUawKxxaLc/m4KnJ9l24mZBPdqcrZadFEoXnJVNziDwPSU7GFGJwV7
KxXrzScotcm0mt9BwbE2RmdlTuDrsjlQ0kahssCGjTIjKH/8dFtRCwWn1IrW
FlMCv+eRLkubKfwRotY5TSF4tusbs9uNFFa6DjBnJxP8zUaUr22g8B/FYFmD

         "]]},
       Annotation[#, "Charting`Private`Tag$20465#1"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVjns41Xccx4k5GbmdROm++J673w0VT6yaW2lWLmtKySWXogxL2sqSS3SP
pCydaR3PIW06kUrv7s+s8jzK7WTTTRcct52cxGxnf3ye1/N+Pe/neX/mbUpa
HT3JwMAgQH//895F40FyhUN4d8tN7WQOBwv6mxLrOJRly/M99Dk0tr1aVctB
q7MNyeJxeDunMmnZZQ4Zi/7u45twMD20ZiC8hsOA7fH5rBGHlVvl/YVVHIb8
2qq2/8OiWeilMZJzUChUPgNDLLrkGT1d+zlsO5Ne3qdmMXo4O6Dmaw7S9xZx
/AoWTGXM8w4hh8A9DtUndrIQvbpY1zvGQhrS62AXwGKB/aEP9o0sSjMbupod
WHikL407eYpFmtOSX4c1DEJa85a6xLE46mKRtf4aA+dA9w3X3FhY5SSPtucz
cNLdrCwyZfGD0fKyW+EM5pR0bipoY/Du/EzvaTIGrvEP/FoUDBq8L7e+MGBg
HuqUYprB4NlEllvLExqvPKfy1voxcFBOsgk/R0Md3NY4NoPBxhLLkcR0Gs2b
Zborb2mUfzWR4+lPI69oICaylobqtjgwYSaN8OF9vI15NEpSHWOFwxRc/C9a
7Qilseve3ZDuOxRETdX+LwU0is7YxHCnKMwLXKaJG6FgUJxifT6RQpvG6/FT
fa8h0toqbxkFZR2/p6yIApVr2tfqQCFz9864zCgKAfGr38pfOCP128vTVS4U
Vpbnjpkdd4Ywa92UJzwK/ruY+iM+zrg+T/p4ZqUzEo7r3Me1MkQVrtC4femM
s7l9O4wVMlgaHm3P65EhstR9SWyQDAt/qfT/LUeGFcNnFrQZylB6bvvsTLEM
403fvxZdksKkNPx29n0pdI1XfSZtkELZ//53Jl6K+tC5lpkWUjSlR4Sq9Kys
qdh7oEGCkXGtKlEpwZ6xaW3FMRKsVTNpj1ZJMPhHwo3NfAlQXcyL7hFjyRFG
xqsTI7JL8fFsgRgPn+afLI8QY5/vgRQVJUZWvm6cZy6GsuLkjX8fiHDs6nO+
+wURpkQHbhlMEqEsrGp/d7AIyfbOPXZmIthtCTod916IkE9e9NsqhPAM8uEb
FwmRttIzuH6FEK/MEix/9BCiJP9OQeEbAaLflWh1agE+LtA62u0XQJn8Xd/e
3QJ06HRfJMkEqDr2s1eBowBXb33mNtFIUFMaJii/TdDxZjSPTSRoGvRrMYsl
+OZuIVe4hcDPUbgpOYagU053jcQTvA5f3NseRfBsfRxXv5ngc9+JoXMRev+4
/S8vPT8EhTV7hhEM36hlVwURCA27niWvIjAvTv0zdjGB9/IA31aO4GCqdW7j
QoJdMY82erAElmuqGIkbwfiMjlQ5TWBj0Z0zoPcvLxQWJsoIpmcFMWlSgl4f
rdJEQOC0jc3ZO5fAJCPH1dWBQBHQRHfPJrh+os3+9HT9rjih03sWwaPlap2h
PYHktZz+dAbBaKBh5cOpBMw6m87DfIKUFgdNlAXBpUUXsoetCdIdvVWN5gQu
dv50kBWBrdp1J2VGsLA5M9tuCoHV4tSPYzyC+upZdLreH7l7XxVhQuBx4MpT
tSmBYVrP1vvGBA3xwdkek/V/13bNlxoRePoOUT/pe5rhiidHDQn+A1j/V0M=

         "]]},
       Annotation[#, "Charting`Private`Tag$20465#2"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVz3kw1nkABvBa8SZJugiRan3f+/1dotWuN6rNmV13pxyJeumia2Z3jKJX
kmn3pWMVbzJ2KaZyJOVZWTtsk6LD+6ZsCe0rREWFbX/7xzOfef55Zh7HyMTv
Y76YNGmSH5//bSyf8oZc5zDZaErueD6HrMyBloRqDv8EeBZ48j10W3tZRRWH
vOr8kozzHF45lCZ6VnLoNq+E9TkOpicCBzdd5TDm7/eaO8vBV6Ud0FziYJ+s
9FJpOLSKlP1GWg4XqPs2z9QcOrWHDJ0ZHPK5TEfs5vAxO83vahgHEuSQq1Vy
YEq3PteJOCgOzpmnt+Qgflle3TfGQrA2qfxzF4sl1ic+WDezKByMPr36Covl
BzziTp9lsaH11OWuVBYhj9QeznEsLGNjCgu/Y6EIcNtc68IioyJpV+hCFk6j
v5fmmLJoSAi1jRxm4HCmIzLzMYOj7TuHNGCwNP6O18NiBtpH9eGLTzKYHuq0
1/QQgx8Xjby7GM3gpfscQbgXg/p63w9hLAN98OPmMRsGjU/Hc2ONGbTGykev
v6LxzE/XU9pGQ50zuDWqioZXytPZg1oam4aPCCLUNE4EZHkeT6Lh7F0+c38o
jVmUkItfSUPcUubdJaRhrlHVFsyj4Rjg2R83QmGpfn+ybTeFx/3KticNFGJt
zQKzr1EoqZ5tyM+hkLJ535WQdN4fD8alRFOoayzKXR9CIWlP5fwKZwpOLrhZ
LKQgOrzB/IGAQvRPum9vjSpw01HWZleqQN/zmqasHAWiNT79LmsV8HnvFnXf
TQGLySfb1QY51IFhiyJ1crgWlXpfSZfjwW3nsPP75ci7uMs+RSJHpe2Q49f2
cpjkbbqd9qcMBn2GxqJWhpKB901MvAzaYw0TyggZWg5sCa2YIcPbfWcu2JjI
MDL+riKhRAqh4a6xfaEU4Xom+a6/FHfdJnqPrZECZacEMQYJGlxnmjt2SxDV
WfypIFOC10bvDeKjEhxZc3xvBSWBoH1VcZ9UgpJfT9d9viNGfkJ/4qMmMcxj
Ana8SRSjbmL9ytUqMXZbKwxWZmJkaRdTL6aKEWL8YmBusQjJUaoB9yJeX/fg
Gh8Rarv+2qPwFuHMsYZMTa8QGdHR4/49Qnxa8u5LqwwhSm/6dBurhdCNjq5K
lAtxxzdhXC0T4kb9Ypd/mwlcCoablLy63o9qNoEgZe6EnUZFsO4PDafZQdBv
M7ZqdDtBh5buHIknKMvVJITz/r0xjquJJfAQFtxawNvT1v5MuYUgd8hmXVEE
wXBdFesfRPDNPf0PVYEE008lPd32FcEvZlkpumUEWUmWR5tdCWwbfzvnxmsR
eImRuhBIbVQ38pYSzJrRnT7IEly+2PV2C+/8w0FMsozgUsf5CIOUwGknm566
kCC7Jls05kBQ7NdCd9sTuHmTFRt5RZLtHasXENyrjA2rs+N3e7T0NBuCh1Tv
kdT5BMyGWR3Zswn0Xb0dZrzXll1OG7Yk6Mt9MKTidbbypoNmEpi4qkzuWRC4
tqakWZkTbFdekP88naCmbAF9wIyAE6/wGJlGsPz49Sd6U/6PUWZwGO+t+OC0
5VMJNpsd3lYjIHBfM0SdMyFYlCo6ZMf7H8KDWLU=
         "]]},
       Annotation[#, "Charting`Private`Tag$20465#3"]& ], 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVkWs0lHkAxl2TlW5WGlHEvv+Zed+5z6xJNl13US5nI9pTLomMWpRyknPK
lExjiVORlK10Wa0pTjFR0lNN7XJqnUMuTaSLcLRDVOSSdvbDc54Pz4ff75zH
dUvizzFmJiYm/sb8348qLN6TGimO75/YyDbn4Wj2QGNCtRQ+qzbRiWY8hMa1
l1fdlGKxW6i31pSHvkWaxFVaKV7dZwnWmPBgnbt+MPyGFOkndLzYLwzW/Voy
kH9ViskYqz8qRxk0cZYbzEukOFIUkX7oXwZdJWn9XVlS2AsM/n2tDMbyMv1v
hElhWlYwlV/GQKyJffWMI8W0+HSbaBUDbndF9bsJCZJVzH7tNgbu83M/z2+Q
YEH1NbNIXwZeqSsVp05LIPc1Lc4VMtjQql4pU0jAv9a5y53FQBC0NKLWQwLH
HPU5f0sG1Og9TYG1BA88eWd8P9FYVNSxJbtNDH5M2TK/Hhrfxz/2bSkVo3dM
xpHpacwIpXZbp4lxR/SF091Io9v7W6uNvmIQVm2LyyMa+pC2hglHMar37vzo
XEejaRt/tKZPhFGtZVqkloa6YDA2+qYIpbYJbfvLaYQPH7aKVIswvc9xMuMK
DZlfxey9oSIkhQXHBl2gwW0s93vDFmHZnPVThcU0XINWGRQjQhxTWnz46SSN
NsPy5uc6IZxCk8br8miUVdv1nysQou5ifQo7i4bywD6FcqsQeuslrSsO0tiT
rGVVyYRIbVlt9SGVBidjk+1TKyGuGKrttUk07rjymp00AqQs8e8Ux9DYmr/W
4BEogDhrILk+jMYs02Pt6n4+QgJjGZEvDflljd91FR+1Lk6m4R40ii/tXKik
+TC/3dfCuNOYVhz+IPMvHqbL47fKZhj9Bj7Vi+N5iA5TvMkZ5qIxNSq0aiYP
1cXDNTatXIxMfqxKMP5+IdKycPYNLjbqxSn/BDCojL7MjjvKBcoLrWL6aajU
l6xZW7iI7iodP59NY+q9cnOwlIvDPjm7q4Q0fE4EHg4y56Lsyqm7Xx9zcd9O
bp1Xz4FtTNCO94lceCY/Ue3L5WDXfEG/gw0XpR9W3+Ov42CD5esB+1IO2Mef
asYtOUhZ5x1yay0HuiFdp909Nop+02Xn97Lh7HJgx9guNsbdP37nkMVGrHKp
n4Cw8Wx0dE0in42MH7zG0/QEt++7eUw1ENTO657qziB41jumliQQVEzGNdtJ
CH55mC/N30GgOGt/pkRE0FEi6hqJJ5D/vWa1SEjwcrNCemsbwconByUBPIKe
5vYXy6MI5p3W5GYSguG7NyUBwcb9ujpoaAHBjMI9nXGeBLvP96SXWxAc3TPn
SIOcIF3gFuVpTjBr/VUx42HkyKPdHpoSzJ35VjVo9KiMWBqgn6LAyggWpxg5
dYkKb/MxClSSRHXIhcAkOOtcoIFCqX+j6O1CgmM6iz/b31Hg0Ns7fnQm+Mqq
Kojqp8D0lIi+cSSwazRzTO6lIN40tyPPjmCiO6LhxCsKlUuuZQ7PMe7eJwed
XlKQOfiJgmcTcH2KPl98QUHepMx0sCVwOOuvrXxO4Va5syjVhmBkaPF2Lz0F
r5ya53prAsMXWwtdO4W6+JBMr+kE1/muyrVtFLx9hoS/TyNo7kl43dRC4T8h
r1Gq
         "]]},
       Annotation[#, "Charting`Private`Tag$20465#4"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVkH1QDHgcxu0VXdeLXmTLkTrx2/f97UuXaC4nuu0FzfV2krpItKXl2B1x
M6ajiF4cNoVMbSPRsnnZXk89R3I66ihkLRVJcm10KWKu2/vjO888n3lmnvk+
nusU32/4bMqUKSvM97+2VFm+IXVShPfWlRW2UuTlmNrTaqWgA8rIRWYfvalL
p6+Rwj94DTHeohiYq1UEVEvBZ5/iepi9dX74cNxlKT6V9uvP3qQI3awxqc9L
EWRS/nWtmeIee8mQhUaK+15+znZNFN2aXYPdB6Qg4Q5xjCsUHw5lrbj8gxRx
ToHejcUUYm1S7yO2FE4Kk+WHAxScvqra1x8lIEzJ+5idFF6u+e9dWyXg/dF1
lyen8Etfmlx0QoKiC2HqsliKqAfZS72TJYi2JQ2qVRTCsMXxv/lIwPA89md7
AMWC8d+1BdYSdDSUkx5firnHjetyHoqRVnQQvUKKr+W3g+5XiGHMt/jFgVDY
Ri/Ybr1LjIvWfSUX3Sn6/GdYrQ4So7ttrEbnQmGIfNj6cZYYLyJci7+yM/+7
UTBeNyDCz72WSpUFRXbBcNL6GhG2lXspS0aEiBvJtPoxWwTZq5B3zKdCeAdX
OeyIFiEmseT0iRtCcNp1wc9ZIij6P5V+qxXCMyxgKHmMwvFO25pTuUI8HFrS
8di869D0/XdfpwhRWes8WFJAUZznHGySCZGxe2dyRiLFsrDOnk53IZTbqt30
3hQVe43PUv4RgL031q7TiuLuDr/5A80CXPXkd8w293yjMoZO5AqQqA4Z8lkl
RPyWyVW/RgkwnXG4K3tQgKBtFgb3mQIsLNcGX9onwJEt5+pO3uOj+PRW9wyu
ANzV+knXQ3xMK467nnWTj3UM9enEZXxUmt7dEsv58B533HFugof29IRovT0f
PUEpvu06HsY+jerTKnloYzr8zYjlYbVBrGpbyUPMYU2tzoYH6AqtNgxy0bZV
rim4xMX67oqJ0hwuTh4bYDeu5SJTlrtdT7kIjO8YXGTNReXZoqbJ2xxknmk4
K9NyYLchLPWNggMX9p23eyI4+MlVOMi04SC9LLxaNcpG1NRnJpcKNq7LLh6N
VbOhCvWPrA9h48HV1Fc2fmwcP9ico37JAmMyRXLGwMKE1+h85gEW3HMbNoXs
ZuHR+PhyhYAF37RL6YnzWWi4Ns/n31aC/MjNltnXCR69/JAtSSMYlBUa3m8k
iLmhlqpTCTikNjM+icCoEXWPyQmcZht4LYkEPWuTpfXmnOMTqjiSQNDf0fV0
iVlNizOa+WsIRppqJCsjCKYeS7iSsJLAtlD5ZNMiggfPAxtbpAR5Ssf9rQsJ
QnyPDvMkBNPDz4t5PgRVNwLmHBGZe+xf7Bs282pT5+Z4AYHb3gixik+gHLPv
GycEC7ZI9u3xIOiLjSKsLwkqVrSLXrgTHBS7eeS5EbC5KcbAOQQZb+Quo0wC
Xr9G9MUsgivTWt41zSAQxzoZDzkTfBdWnhttb+a+F7JGHAkkXF7KVVsCb2aw
KMKBADujls+zIVh4LyOLaUeQOrNs2GRFUK+bI0o382Zta1PENAK/3LrHBmsC
fmhpTr0lQaM8Msvvc4LSo+woDwsCf9lbesqcc/VKmp3FIPgPX4ZTvA==
         "]]},
       Annotation[#, "Charting`Private`Tag$20465#5"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV0ns0lHkYB3CVEoVue5CEo/rNfeZ9ZxipTemyIa1damrDdqOMWwkbna2j
mDFW6VQcl21asxUOUjGFlr612kotResWTaHGThmSSNd994/nfM7zff54znPO
47w95vvQiSYmJn5M/e9fF02HSLUEtX4HXyUYaRzLMDZFV0kgSR16b8H0st3t
5dqrEvSF5DmdGaDR71gas/KKBOTjgUu3X9EwzwwYDKmQQBh9q9/uJY11URpj
VpkEci8U3tTTaGYvH5ikkeD0U7l04TMaOs0Bgy5dAiPX6R3vEY3x4wq/ik0S
TDxmv55XTYMuDXvWwZbAXN6rFhbQ4PRdrHr5QQyveS3X8tNpLLDNfGfbIEYr
cU/ri6WxNNErPDdfjL7NlQ/EwTQ2tqq8XMPF2GQfr25dTUPov+THP6RidM5S
9lwS0Fg0dqM021yMsi1ipdqWhmNe1/aMNhpmQ9sc275QcJPf9/6niMbZ/FBD
sZ7CdNmiOPMDNMLaLWV3Gin0ec4x2+xNY77CtNL7MoXODW0NH+bS8FpQNomf
TaF5l2Csup/CjYDAKWPxFFTZg2E7rlJ4tcrjXGYghZDhVLOtKgo/eeaOt4op
uPpcnLFfRqFx2LaxwooCp6ncp5dFIcrYyz9lEMHZf+VA+KgIs9XdNaM3RGgb
WN7yuF6EiuZC+bUcEUqqZht+yxbhXvqMz/y9IiQfSgpP3ilCtMGnYdlqEeL3
XbHTuoqQ80YbusVeBHZKkOUjM2be8K6F3StErTO/ZV6pEJ5xtvcWKoXYmeU7
IP1WiMiwlFGOSAjrCSfaVQYBqssj2rofCOB+vtTnslKAwiRVcUSsAKfP7Z2f
zBUgqDgsqthOgCmnQ/5U3ObDrTcz7l4VHyXGt3dpOR935mj0PcF8NCVuk2mt
+Dha2Gy6w5SP0Y8j2ugSHu538Q/+q+Fhcyed0Lieh7T8/W7l3/CA8hyzUAMX
SS31nml9XOzQFb0vyOBi2Emmr1Nykbr2aJxWxMV37W4TzvC4KCnOvf7lPgeq
8ZN1BXc5sAz1jxyK4UCqaXV1juIg1lZosJnGwT7pocE7UznYOLnH+FURGwJv
XYHgPBsJ6zw31PiycUFj7u/iw0beL/UZWXoWFu0R1Kx5wcL7BSMLbdJZaPR1
cDFRsdAxNrY6RsDCw6Tx16l8Fq7ddJF+biAIyrCyWMbYoR9XiaMJnjz8mzoZ
RfDDrSxJViSBm6ku+G0EQZeG0o3KCU7VK1UyxqfB4ZKaXQSHPAt09owvWtqf
LN9G0Lzik+LsVoLh61fF6wMJEqsKbmoDCKbnxHfv9iCYMPnhYNtigmPxM9Ma
3Jn8015rD0brgDKaJyUoTqsU/OpGMMvquXJQTJh/cYzcymiXEkgn8AkmH8zq
6ecR5k6x8ogTwc8JXnXjjgRFfk3U8/kEHo2O7VsY2dyIrjUOBNdDfn9dO4+A
90JDWcwlWOWrdjlsR0AHzeo6PpvAQhBxxIKxcvEFxfBMgq/Zh/MiGV1tfKjA
GQS1uSsuNVoTuDcnK2wsCdQjNd0nphPUlDtQidMIEiLi34xYECw9Wv2405xA
sadjqoyxTr5BsXQqQay33qHajMBz7WuRegqzZ8kZ2p7xP05eXck=
         "]]},
       Annotation[#, "Charting`Private`Tag$20465#6"]& ]}, {}}, InsetBox[
     TemplateBox[{
      StyleBox["1.`*^-6", 20, FontFamily -> "Arial", StripOnInput -> False],
       StyleBox["1.`*^-7", 20, FontFamily -> "Arial", StripOnInput -> False],
       StyleBox["1.`*^-8", 20, FontFamily -> "Arial", StripOnInput -> False]},
      "LineLegend",
      DisplayFunction->(FormBox[
        PanelBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 StyleBox[
                 "\"RAF(M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
                  False], {FontSize -> 12, FontFamily -> "Arial"}, 
                 StripOnInput -> False]}, {
                TagBox[
                 GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Center}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"],
             Alignment -> Left, AppearanceElements -> None, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontSize -> 12, FontFamily -> "Arial"}, StripOnInput -> False], 
         Background -> Automatic, ContentPadding -> True, 
         FrameMargins -> {{5, 5}, {5, 5}}], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", "12"}], ",", 
           RowBox[{"LegendFunction", "\[Rule]", "Panel"}], ",", 
           RowBox[{"LegendLabel", "\[Rule]", 
             StyleBox[
             "\"RAF(M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
              False]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.99, 0.01}], ImageScaled[{1, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{-20.72326583694641, -20.628854216079166`},
   BaseStyle->{FontFamily -> "Times"},
   CoordinatesToolOptions:>{"DisplayFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& ), "CopiedValueFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& )},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       StyleBox[
       "\"Total Drug [DTOT] (M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
        False], TraditionalForm], None}, {
      FormBox[
       StyleBox[
       "\"Unbound Drug [d] (M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
        False], TraditionalForm], None}},
   FrameStyle->Thickness[0.004],
   FrameTicks->FrontEndValueCache[{{Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-20.72326583694641, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}, {{-20.72326583694641, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}, {{{-20.72326583694641, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}, {{-20.72326583694641, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}}],
   FrameTicksStyle->20,
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->{500},
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None},
   PlotLabel->FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(K\\), \\(d\\)]\\): \[LongDash]100nM  - -1nM \
\\!\\(\\*SubscriptBox[\\(K\\), \\(A\\)]\\):10\"", 20, FontFamily -> "Arial", 
      StripOnInput -> False], TraditionalForm],
   PlotRange->
    NCache[{{-Log[1000000000], -
       Log[100000]}, {-20.628854216079166`, -11.417624546087074`}}, \
{{-20.72326583694641, -11.512925464970229`}, {-20.628854216079166`, \
-11.417624546087074`}}],
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          Line[CompressedData["
1:eJwVj3tUjHkAhiMZSRrhREeI5vvNN9fv+2baQm51rBpJq6YJlUuSKcSmjrC2
TjVtV87u1kkuSy5bWyTdW9aLsWitVLqX2hYRNV1UyGHbP57z/vm8j+2OsI1B
E42MjNaP8//+eW1SP6lQ4swWn1NCNYe0lL7qfeVKFLjpyQFvDprdTQUlZUrc
sAsqqfDi8GpBfphLqRKePJenqo0cTI97GQKKlGjSJizcu4GD+97svvQrSgy/
HxoqdONQS6/qNc5WYixBl+K0gkNH9pGejiQllOcNZWrC4cMJ3foiXyVi0oIt
7wyz4PJ3/dNMK9HNJVT+fJ+F6Pm18jdjCpzf5jt7fxYLuznH38+pUsBGo6q5
oGXhFOWsPXlKgekDgVtUTix8GhKd7bUKjITdnhRkxkLuuWzrDQcFnP2T/Qpb
GVCjt/MzTBXgpL9cjCtgsCCrbUdKI4dHXbXclGgGX4U8cqvP4TD4k+Kt0JvB
NA110PQIh3dLE8N/pRk8XzmLt2m86/DkHP6O93K0qBurxqzHu8VLSkcvylEb
LButeMXigkvuao27HIkZhl2BZSzythzz3T0qQ8BgPG9bIovoReFa1W8y2Kuu
8Q9pWBhXD/AVm2QQVReo/hWyuJx0mS/gy2Dr6dKrHWEwUrp2nbVeisbeVXWt
egZFN2mP6qNS5JXP7DmXwYAn9TXsXy5FzPeHtTE7Gbj2qwqXfZIgIrx0bok9
g8L408Zn70hAx/mZP+UxWO3vpbVKleCmrbRuXr4c/u1PLtj4SLAzfV2vwwY5
XnssdNQKJLCY8GNTYo8Mz4ZGoiYOieF4OV91PUGGZNf+2KC7Ypy5dGB+jFgG
2cNwf+tMMSafCbiruy9FzYOcg+VaMfL6hh9yIVL4G8W9Vq8Qozpqu6ZkuhSX
rur8BTPFGPn0rmRfngSiYo28t0uETS1c5GMPCf6qvTF3cbEIKMjkBfWIoV/c
wxiOiRDYkfPxfIoYS3xMBIkqEeJdUw+WMGKE1jU4amaJkJd78taXRyJYzYKA
a6BhHuS5pz9MBMc2Q81QJo1v58h7rMxECOUnbzT3ouFj0tU3O4fGg5i8ewNT
aUS6r1RXrqPhHZveV6YXIitZn5LeLYTlhLiAtAghPtq9E1glCfGmNLTejBai
eXR0TZhMiNqp332payX4/c5ih89VBL36LHV9PEFz94dExT6Cz0n9s28pCDbf
S1em7yE43VjT4s4RtGWzHSMhBIcMxdEtDEGnv1ZZGUxwzLkqbFhK8LKu6dmq
7QR3g5XttJBg8FaZwsObQARTk9R5BNMyI9p3LyV4wcbylpsQpEXM+KHKkcDt
XKfFfWMCC68rnMSB4HpVzJjnRALL6S8SDOM/jrbWH935hcLcOG8uctyTKiqk
kz5QoPYrEmIXElTKopc96aWQs76afTGfoH3NhmjftxRocWjb1zYEdoKo3M4e
CpKX2exUawKxxaLc/m4KnJ9l24mZBPdqcrZadFEoXnJVNziDwPSU7GFGJwV7
KxXrzScotcm0mt9BwbE2RmdlTuDrsjlQ0kahssCGjTIjKH/8dFtRCwWn1IrW
FlMCv+eRLkubKfwRotY5TSF4tusbs9uNFFa6DjBnJxP8zUaUr22g8B/FYFmD

           "]]}, "Charting`Private`Tag$20465#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJwVjns41Xccx4k5GbmdROm++J673w0VT6yaW2lWLmtKySWXogxL2sqSS3SP
pCydaR3PIW06kUrv7s+s8jzK7WTTTRcct52cxGxnf3ye1/N+Pe/neX/mbUpa
HT3JwMAgQH//895F40FyhUN4d8tN7WQOBwv6mxLrOJRly/M99Dk0tr1aVctB
q7MNyeJxeDunMmnZZQ4Zi/7u45twMD20ZiC8hsOA7fH5rBGHlVvl/YVVHIb8
2qq2/8OiWeilMZJzUChUPgNDLLrkGT1d+zlsO5Ne3qdmMXo4O6Dmaw7S9xZx
/AoWTGXM8w4hh8A9DtUndrIQvbpY1zvGQhrS62AXwGKB/aEP9o0sSjMbupod
WHikL407eYpFmtOSX4c1DEJa85a6xLE46mKRtf4aA+dA9w3X3FhY5SSPtucz
cNLdrCwyZfGD0fKyW+EM5pR0bipoY/Du/EzvaTIGrvEP/FoUDBq8L7e+MGBg
HuqUYprB4NlEllvLExqvPKfy1voxcFBOsgk/R0Md3NY4NoPBxhLLkcR0Gs2b
Zborb2mUfzWR4+lPI69oICaylobqtjgwYSaN8OF9vI15NEpSHWOFwxRc/C9a
7Qilseve3ZDuOxRETdX+LwU0is7YxHCnKMwLXKaJG6FgUJxifT6RQpvG6/FT
fa8h0toqbxkFZR2/p6yIApVr2tfqQCFz9864zCgKAfGr38pfOCP128vTVS4U
Vpbnjpkdd4Ywa92UJzwK/ruY+iM+zrg+T/p4ZqUzEo7r3Me1MkQVrtC4femM
s7l9O4wVMlgaHm3P65EhstR9SWyQDAt/qfT/LUeGFcNnFrQZylB6bvvsTLEM
403fvxZdksKkNPx29n0pdI1XfSZtkELZ//53Jl6K+tC5lpkWUjSlR4Sq9Kys
qdh7oEGCkXGtKlEpwZ6xaW3FMRKsVTNpj1ZJMPhHwo3NfAlQXcyL7hFjyRFG
xqsTI7JL8fFsgRgPn+afLI8QY5/vgRQVJUZWvm6cZy6GsuLkjX8fiHDs6nO+
+wURpkQHbhlMEqEsrGp/d7AIyfbOPXZmIthtCTod916IkE9e9NsqhPAM8uEb
FwmRttIzuH6FEK/MEix/9BCiJP9OQeEbAaLflWh1agE+LtA62u0XQJn8Xd/e
3QJ06HRfJMkEqDr2s1eBowBXb33mNtFIUFMaJii/TdDxZjSPTSRoGvRrMYsl
+OZuIVe4hcDPUbgpOYagU053jcQTvA5f3NseRfBsfRxXv5ngc9+JoXMRev+4
/S8vPT8EhTV7hhEM36hlVwURCA27niWvIjAvTv0zdjGB9/IA31aO4GCqdW7j
QoJdMY82erAElmuqGIkbwfiMjlQ5TWBj0Z0zoPcvLxQWJsoIpmcFMWlSgl4f
rdJEQOC0jc3ZO5fAJCPH1dWBQBHQRHfPJrh+os3+9HT9rjih03sWwaPlap2h
PYHktZz+dAbBaKBh5cOpBMw6m87DfIKUFgdNlAXBpUUXsoetCdIdvVWN5gQu
dv50kBWBrdp1J2VGsLA5M9tuCoHV4tSPYzyC+upZdLreH7l7XxVhQuBx4MpT
tSmBYVrP1vvGBA3xwdkek/V/13bNlxoRePoOUT/pe5rhiidHDQn+A1j/V0M=

           "]]}, "Charting`Private`Tag$20465#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwVz3kw1nkABvBa8SZJugiRan3f+/1dotWuN6rNmV13pxyJeumia2Z3jKJX
kmn3pWMVbzJ2KaZyJOVZWTtsk6LD+6ZsCe0rREWFbX/7xzOfef55Zh7HyMTv
Y76YNGmSH5//bSyf8oZc5zDZaErueD6HrMyBloRqDv8EeBZ48j10W3tZRRWH
vOr8kozzHF45lCZ6VnLoNq+E9TkOpicCBzdd5TDm7/eaO8vBV6Ud0FziYJ+s
9FJpOLSKlP1GWg4XqPs2z9QcOrWHDJ0ZHPK5TEfs5vAxO83vahgHEuSQq1Vy
YEq3PteJOCgOzpmnt+Qgflle3TfGQrA2qfxzF4sl1ic+WDezKByMPr36Covl
BzziTp9lsaH11OWuVBYhj9QeznEsLGNjCgu/Y6EIcNtc68IioyJpV+hCFk6j
v5fmmLJoSAi1jRxm4HCmIzLzMYOj7TuHNGCwNP6O18NiBtpH9eGLTzKYHuq0
1/QQgx8Xjby7GM3gpfscQbgXg/p63w9hLAN98OPmMRsGjU/Hc2ONGbTGykev
v6LxzE/XU9pGQ50zuDWqioZXytPZg1oam4aPCCLUNE4EZHkeT6Lh7F0+c38o
jVmUkItfSUPcUubdJaRhrlHVFsyj4Rjg2R83QmGpfn+ybTeFx/3KticNFGJt
zQKzr1EoqZ5tyM+hkLJ535WQdN4fD8alRFOoayzKXR9CIWlP5fwKZwpOLrhZ
LKQgOrzB/IGAQvRPum9vjSpw01HWZleqQN/zmqasHAWiNT79LmsV8HnvFnXf
TQGLySfb1QY51IFhiyJ1crgWlXpfSZfjwW3nsPP75ci7uMs+RSJHpe2Q49f2
cpjkbbqd9qcMBn2GxqJWhpKB901MvAzaYw0TyggZWg5sCa2YIcPbfWcu2JjI
MDL+riKhRAqh4a6xfaEU4Xom+a6/FHfdJnqPrZECZacEMQYJGlxnmjt2SxDV
WfypIFOC10bvDeKjEhxZc3xvBSWBoH1VcZ9UgpJfT9d9viNGfkJ/4qMmMcxj
Ana8SRSjbmL9ytUqMXZbKwxWZmJkaRdTL6aKEWL8YmBusQjJUaoB9yJeX/fg
Gh8Rarv+2qPwFuHMsYZMTa8QGdHR4/49Qnxa8u5LqwwhSm/6dBurhdCNjq5K
lAtxxzdhXC0T4kb9Ypd/mwlcCoablLy63o9qNoEgZe6EnUZFsO4PDafZQdBv
M7ZqdDtBh5buHIknKMvVJITz/r0xjquJJfAQFtxawNvT1v5MuYUgd8hmXVEE
wXBdFesfRPDNPf0PVYEE008lPd32FcEvZlkpumUEWUmWR5tdCWwbfzvnxmsR
eImRuhBIbVQ38pYSzJrRnT7IEly+2PV2C+/8w0FMsozgUsf5CIOUwGknm566
kCC7Jls05kBQ7NdCd9sTuHmTFRt5RZLtHasXENyrjA2rs+N3e7T0NBuCh1Tv
kdT5BMyGWR3Zswn0Xb0dZrzXll1OG7Yk6Mt9MKTidbbypoNmEpi4qkzuWRC4
tqakWZkTbFdekP88naCmbAF9wIyAE6/wGJlGsPz49Sd6U/6PUWZwGO+t+OC0
5VMJNpsd3lYjIHBfM0SdMyFYlCo6ZMf7H8KDWLU=
           "]]}, "Charting`Private`Tag$20465#3"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwVkWs0lHkAxl2TlW5WGlHEvv+Zed+5z6xJNl13US5nI9pTLomMWpRyknPK
lExjiVORlK10Wa0pTjFR0lNN7XJqnUMuTaSLcLRDVOSSdvbDc54Pz4ff75zH
dUvizzFmJiYm/sb8348qLN6TGimO75/YyDbn4Wj2QGNCtRQ+qzbRiWY8hMa1
l1fdlGKxW6i31pSHvkWaxFVaKV7dZwnWmPBgnbt+MPyGFOkndLzYLwzW/Voy
kH9ViskYqz8qRxk0cZYbzEukOFIUkX7oXwZdJWn9XVlS2AsM/n2tDMbyMv1v
hElhWlYwlV/GQKyJffWMI8W0+HSbaBUDbndF9bsJCZJVzH7tNgbu83M/z2+Q
YEH1NbNIXwZeqSsVp05LIPc1Lc4VMtjQql4pU0jAv9a5y53FQBC0NKLWQwLH
HPU5f0sG1Og9TYG1BA88eWd8P9FYVNSxJbtNDH5M2TK/Hhrfxz/2bSkVo3dM
xpHpacwIpXZbp4lxR/SF091Io9v7W6uNvmIQVm2LyyMa+pC2hglHMar37vzo
XEejaRt/tKZPhFGtZVqkloa6YDA2+qYIpbYJbfvLaYQPH7aKVIswvc9xMuMK
DZlfxey9oSIkhQXHBl2gwW0s93vDFmHZnPVThcU0XINWGRQjQhxTWnz46SSN
NsPy5uc6IZxCk8br8miUVdv1nysQou5ifQo7i4bywD6FcqsQeuslrSsO0tiT
rGVVyYRIbVlt9SGVBidjk+1TKyGuGKrttUk07rjymp00AqQs8e8Ux9DYmr/W
4BEogDhrILk+jMYs02Pt6n4+QgJjGZEvDflljd91FR+1Lk6m4R40ii/tXKik
+TC/3dfCuNOYVhz+IPMvHqbL47fKZhj9Bj7Vi+N5iA5TvMkZ5qIxNSq0aiYP
1cXDNTatXIxMfqxKMP5+IdKycPYNLjbqxSn/BDCojL7MjjvKBcoLrWL6aajU
l6xZW7iI7iodP59NY+q9cnOwlIvDPjm7q4Q0fE4EHg4y56Lsyqm7Xx9zcd9O
bp1Xz4FtTNCO94lceCY/Ue3L5WDXfEG/gw0XpR9W3+Ov42CD5esB+1IO2Mef
asYtOUhZ5x1yay0HuiFdp909Nop+02Xn97Lh7HJgx9guNsbdP37nkMVGrHKp
n4Cw8Wx0dE0in42MH7zG0/QEt++7eUw1ENTO657qziB41jumliQQVEzGNdtJ
CH55mC/N30GgOGt/pkRE0FEi6hqJJ5D/vWa1SEjwcrNCemsbwconByUBPIKe
5vYXy6MI5p3W5GYSguG7NyUBwcb9ujpoaAHBjMI9nXGeBLvP96SXWxAc3TPn
SIOcIF3gFuVpTjBr/VUx42HkyKPdHpoSzJ35VjVo9KiMWBqgn6LAyggWpxg5
dYkKb/MxClSSRHXIhcAkOOtcoIFCqX+j6O1CgmM6iz/b31Hg0Ns7fnQm+Mqq
Kojqp8D0lIi+cSSwazRzTO6lIN40tyPPjmCiO6LhxCsKlUuuZQ7PMe7eJwed
XlKQOfiJgmcTcH2KPl98QUHepMx0sCVwOOuvrXxO4Va5syjVhmBkaPF2Lz0F
r5ya53prAsMXWwtdO4W6+JBMr+kE1/muyrVtFLx9hoS/TyNo7kl43dRC4T8h
r1Gq
           "]]}, "Charting`Private`Tag$20465#4"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwVkH1QDHgcxu0VXdeLXmTLkTrx2/f97UuXaC4nuu0FzfV2krpItKXl2B1x
M6ajiF4cNoVMbSPRsnnZXk89R3I66ihkLRVJcm10KWKu2/vjO888n3lmnvk+
nusU32/4bMqUKSvM97+2VFm+IXVShPfWlRW2UuTlmNrTaqWgA8rIRWYfvalL
p6+Rwj94DTHeohiYq1UEVEvBZ5/iepi9dX74cNxlKT6V9uvP3qQI3awxqc9L
EWRS/nWtmeIee8mQhUaK+15+znZNFN2aXYPdB6Qg4Q5xjCsUHw5lrbj8gxRx
ToHejcUUYm1S7yO2FE4Kk+WHAxScvqra1x8lIEzJ+5idFF6u+e9dWyXg/dF1
lyen8Etfmlx0QoKiC2HqsliKqAfZS72TJYi2JQ2qVRTCsMXxv/lIwPA89md7
AMWC8d+1BdYSdDSUkx5firnHjetyHoqRVnQQvUKKr+W3g+5XiGHMt/jFgVDY
Ri/Ybr1LjIvWfSUX3Sn6/GdYrQ4So7ttrEbnQmGIfNj6cZYYLyJci7+yM/+7
UTBeNyDCz72WSpUFRXbBcNL6GhG2lXspS0aEiBvJtPoxWwTZq5B3zKdCeAdX
OeyIFiEmseT0iRtCcNp1wc9ZIij6P5V+qxXCMyxgKHmMwvFO25pTuUI8HFrS
8di869D0/XdfpwhRWes8WFJAUZznHGySCZGxe2dyRiLFsrDOnk53IZTbqt30
3hQVe43PUv4RgL031q7TiuLuDr/5A80CXPXkd8w293yjMoZO5AqQqA4Z8lkl
RPyWyVW/RgkwnXG4K3tQgKBtFgb3mQIsLNcGX9onwJEt5+pO3uOj+PRW9wyu
ANzV+knXQ3xMK467nnWTj3UM9enEZXxUmt7dEsv58B533HFugof29IRovT0f
PUEpvu06HsY+jerTKnloYzr8zYjlYbVBrGpbyUPMYU2tzoYH6AqtNgxy0bZV
rim4xMX67oqJ0hwuTh4bYDeu5SJTlrtdT7kIjO8YXGTNReXZoqbJ2xxknmk4
K9NyYLchLPWNggMX9p23eyI4+MlVOMi04SC9LLxaNcpG1NRnJpcKNq7LLh6N
VbOhCvWPrA9h48HV1Fc2fmwcP9ico37JAmMyRXLGwMKE1+h85gEW3HMbNoXs
ZuHR+PhyhYAF37RL6YnzWWi4Ns/n31aC/MjNltnXCR69/JAtSSMYlBUa3m8k
iLmhlqpTCTikNjM+icCoEXWPyQmcZht4LYkEPWuTpfXmnOMTqjiSQNDf0fV0
iVlNizOa+WsIRppqJCsjCKYeS7iSsJLAtlD5ZNMiggfPAxtbpAR5Ssf9rQsJ
QnyPDvMkBNPDz4t5PgRVNwLmHBGZe+xf7Bs282pT5+Z4AYHb3gixik+gHLPv
GycEC7ZI9u3xIOiLjSKsLwkqVrSLXrgTHBS7eeS5EbC5KcbAOQQZb+Quo0wC
Xr9G9MUsgivTWt41zSAQxzoZDzkTfBdWnhttb+a+F7JGHAkkXF7KVVsCb2aw
KMKBADujls+zIVh4LyOLaUeQOrNs2GRFUK+bI0o382Zta1PENAK/3LrHBmsC
fmhpTr0lQaM8Msvvc4LSo+woDwsCf9lbesqcc/VKmp3FIPgPX4ZTvA==
           "]]}, "Charting`Private`Tag$20465#5"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Dashing[{Small, Small}], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwV0ns0lHkYB3CVEoVue5CEo/rNfeZ9ZxipTemyIa1damrDdqOMWwkbna2j
mDFW6VQcl21asxUOUjGFlr612kotResWTaHGThmSSNd994/nfM7zff54znPO
47w95vvQiSYmJn5M/e9fF02HSLUEtX4HXyUYaRzLMDZFV0kgSR16b8H0st3t
5dqrEvSF5DmdGaDR71gas/KKBOTjgUu3X9EwzwwYDKmQQBh9q9/uJY11URpj
VpkEci8U3tTTaGYvH5ikkeD0U7l04TMaOs0Bgy5dAiPX6R3vEY3x4wq/ik0S
TDxmv55XTYMuDXvWwZbAXN6rFhbQ4PRdrHr5QQyveS3X8tNpLLDNfGfbIEYr
cU/ri6WxNNErPDdfjL7NlQ/EwTQ2tqq8XMPF2GQfr25dTUPov+THP6RidM5S
9lwS0Fg0dqM021yMsi1ipdqWhmNe1/aMNhpmQ9sc275QcJPf9/6niMbZ/FBD
sZ7CdNmiOPMDNMLaLWV3Gin0ec4x2+xNY77CtNL7MoXODW0NH+bS8FpQNomf
TaF5l2Csup/CjYDAKWPxFFTZg2E7rlJ4tcrjXGYghZDhVLOtKgo/eeaOt4op
uPpcnLFfRqFx2LaxwooCp6ncp5dFIcrYyz9lEMHZf+VA+KgIs9XdNaM3RGgb
WN7yuF6EiuZC+bUcEUqqZht+yxbhXvqMz/y9IiQfSgpP3ilCtMGnYdlqEeL3
XbHTuoqQ80YbusVeBHZKkOUjM2be8K6F3StErTO/ZV6pEJ5xtvcWKoXYmeU7
IP1WiMiwlFGOSAjrCSfaVQYBqssj2rofCOB+vtTnslKAwiRVcUSsAKfP7Z2f
zBUgqDgsqthOgCmnQ/5U3ObDrTcz7l4VHyXGt3dpOR935mj0PcF8NCVuk2mt
+Dha2Gy6w5SP0Y8j2ugSHu538Q/+q+Fhcyed0Lieh7T8/W7l3/CA8hyzUAMX
SS31nml9XOzQFb0vyOBi2Emmr1Nykbr2aJxWxMV37W4TzvC4KCnOvf7lPgeq
8ZN1BXc5sAz1jxyK4UCqaXV1juIg1lZosJnGwT7pocE7UznYOLnH+FURGwJv
XYHgPBsJ6zw31PiycUFj7u/iw0beL/UZWXoWFu0R1Kx5wcL7BSMLbdJZaPR1
cDFRsdAxNrY6RsDCw6Tx16l8Fq7ddJF+biAIyrCyWMbYoR9XiaMJnjz8mzoZ
RfDDrSxJViSBm6ku+G0EQZeG0o3KCU7VK1UyxqfB4ZKaXQSHPAt09owvWtqf
LN9G0Lzik+LsVoLh61fF6wMJEqsKbmoDCKbnxHfv9iCYMPnhYNtigmPxM9Ma
3Jn8015rD0brgDKaJyUoTqsU/OpGMMvquXJQTJh/cYzcymiXEkgn8AkmH8zq
6ecR5k6x8ogTwc8JXnXjjgRFfk3U8/kEHo2O7VsY2dyIrjUOBNdDfn9dO4+A
90JDWcwlWOWrdjlsR0AHzeo6PpvAQhBxxIKxcvEFxfBMgq/Zh/MiGV1tfKjA
GQS1uSsuNVoTuDcnK2wsCdQjNd0nphPUlDtQidMIEiLi34xYECw9Wv2405xA
sadjqoyxTr5BsXQqQay33qHajMBz7WuRegqzZ8kZ2p7xP05eXck=
           "]]}, "Charting`Private`Tag$20465#6"]}}, {}}, {
     DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
      Ticks -> {Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, 
      AxesOrigin -> {-20.72326583694641, -20.628854216079166`}, 
      FrameTicks -> {{Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLines -> {None, None}, 
      DisplayFunction -> Identity, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "ClippingRange" -> {{{-20.72326564898028, \
-11.512925652936358`}, {-20.628854216079166`, -11.417624546087074`}}, \
{{-20.72326564898028, -11.512925652936358`}, {-20.628854216079166`, \
-11.417624546087074`}}}}, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {-20.72326583694641, -20.628854216079166`}, 
      BaseStyle -> {FontFamily -> "Times"}, 
      CoordinatesToolOptions -> {"DisplayFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& )}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         Style["Total Drug [DTOT] (M)", 20, FontFamily -> "Arial"], None}, {
         Style["Unbound Drug [d] (M)", 20, FontFamily -> "Arial"], None}}, 
      FrameStyle -> Thickness[0.004], 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      FrameTicksStyle -> 20, GridLines -> {None, None}, GridLinesStyle -> 
      Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, PlotLabel -> 
      Style["\!\(\*SubscriptBox[\(K\), \(d\)]\): \[LongDash]100nM  - -1nM \
\!\(\*SubscriptBox[\(K\), \(A\)]\):10", 20, FontFamily -> "Arial"], 
      PlotRange -> {{-Log[1000000000], -
         Log[100000]}, {-20.628854216079166`, -11.417624546087074`}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        RGBColor[0, 0, 1], 
        RGBColor[0, 1, 0], 
        Directive[
         RGBColor[1, 0, 0], 
         Thickness[Large]]}, {
        Style[1.*^-6, 20, FontFamily -> "Arial"], 
        Style[1.*^-7, 20, FontFamily -> "Arial"], 
        Style[1.*^-8, 20, FontFamily -> "Arial"]}, LabelStyle -> 12, 
       LegendFunction -> Panel, LegendLabel -> 
       Style["RAF(M)", 20, FontFamily -> "Arial"], LegendLayout -> 
       "Column"]], {Right, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.812994407784314*^9, 3.8321686622364225`*^9, 3.8402046849217443`*^9, 
   3.840206501319479*^9, {3.8406496434766445`*^9, 3.8406496563932285`*^9}, 
   3.890525425503158*^9, {3.8905255343396254`*^9, 3.890525571420909*^9}, 
   3.8905257544424996`*^9, 3.890672554759573*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"c5d5967f-fce0-4ba1-b0fc-bc0c0227ca7e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.5. Analytic Expressions for maximum Fold Change (FC) ", \
"Subsubsection",
 CellChangeTimes->{{3.831920558274994*^9, 3.831920568951131*^9}, {
   3.8319206099444203`*^9, 3.8319206382915373`*^9}, {3.8319228274578667`*^9, 
   3.831922828296911*^9}, {3.831923265609557*^9, 3.831923265941924*^9}, 
   3.832088767728548*^9, {3.8331596529044495`*^9, 3.8331596605908427`*^9}, {
   3.844939082606372*^9, 
   3.8449390827065983`*^9}},ExpressionUUID->"56ac3ecf-0453-4e4f-a8ea-\
4f7885edeca7"],

Cell["\<\
Fold change is defined as the ratio between maximum RAF activity (active \
protomers) to that in absence of drug\
\>", "Text",
 CellChangeTimes->{{3.8319210014332504`*^9, 3.831921044927513*^9}, {
  3.8906725852674694`*^9, 
  3.8906725882255793`*^9}},ExpressionUUID->"b71310fa-47b9-44db-a4f2-\
fdef5ec1c6a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rafFC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"fnActiveRAFDS", "/", "baselineActiveRAFDS"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8319206411308155`*^9, 3.831920654543648*^9}, {
   3.8319209514436145`*^9, 3.831920964234915*^9}, {3.8319210462861276`*^9, 
   3.8319210808824434`*^9}, {3.8319211410192847`*^9, 
   3.8319211418294463`*^9}, {3.8319212907129707`*^9, 3.831921293775152*^9}, 
   3.831929927406506*^9, {3.8320860698850856`*^9, 3.8320861755815163`*^9}, {
   3.8320864795071588`*^9, 3.8320865564244003`*^9}, {3.8320866370022855`*^9, 
   3.832086656919811*^9}, {3.8321657983699083`*^9, 3.8321657985708137`*^9}, {
   3.840649711763365*^9, 3.8406497234905877`*^9}, 3.844884224799922*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"6d1325ce-593a-48f2-98b2-9532f80e6da3"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", 
       SubscriptBox["d", "rel"]}], "-", 
      SqrtBox[
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{
              SubscriptBox["d", "rel"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], " ", 
           SubscriptBox["RAF", "rel"]}]}], ")"}]}]]}], ")"}], "2"]}], 
  RowBox[{"f", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{
       SubscriptBox["d", "rel"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{3.8406497239192505`*^9, 3.8905254262841773`*^9, 
  3.8906725936848717`*^9, 3.892838481487412*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"74ace51e-6f0d-4041-b616-f05c22a7d7eb"]
}, Open  ]],

Cell["\<\
Activating Range is defined as the lowest concentration above which the drug \
no longer acts as a paradoxical activator and becomes an inhibitor. This \
function is not easily solved analytically, and to understand its variation \
within the range of parameters defined in conditions for PA above, is \
calculated numerically.\
\>", "Text",
 CellChangeTimes->{{3.8319217033257265`*^9, 3.831921756276883*^9}, {
  3.831921925837969*^9, 
  3.831921981729839*^9}},ExpressionUUID->"3661432a-e614-4446-bbdf-\
72d7b7d7bbbd"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Section 1.2. Negative Cooperativity (NC) Model", "Section",
 CellChangeTimes->{{3.76919880174008*^9, 3.7691988613532224`*^9}, 
   3.769273566954769*^9, {3.8402032805684576`*^9, 3.840203284256183*^9}, {
   3.8402033256104307`*^9, 3.8402033678827577`*^9}, {3.840650802253913*^9, 
   3.8406508023353205`*^9}, {3.8448836735187883`*^9, 
   3.8448836736249914`*^9}},ExpressionUUID->"d7ff5b79-c4e9-4160-bc58-\
e2ff5db2174c"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.769456144052461*^9, 3.7694561471807184`*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"38333c1b-dc5a-42ce-a106-7515c5802c02"],

Cell[CellGroupData[{

Cell["1.2.1. Analytic Solution to the model", "Subsubsection",
 CellChangeTimes->{{3.7692694154543457`*^9, 3.7692694289690504`*^9}, {
  3.769436772449255*^9, 3.769436772675357*^9}, {3.8324323477216988`*^9, 
  3.83243234796869*^9}, {3.8331596409988627`*^9, 3.8331596677817163`*^9}, {
  3.8406508042172966`*^9, 3.8406508043011646`*^9}, {3.8449390883546505`*^9, 
  3.8449390884921684`*^9}},ExpressionUUID->"d64f97bc-9a70-47d5-813c-\
a1c296d9f00f"],

Cell["\<\
The assembled kinase state can dimerize (AA) or bind with  a drug (Ad). The \
kinase dimer (AA), upon drug administration can occur in either partly (AAd) \
or fully inhibited state (AdAd). The equilibrium state relationships and \
protein concentration conservation equations for both total RAF (RAF) and \
total drug (DTOT) are defined as follows.\
\>", "Text",
 CellChangeTimes->{{3.7692038930283422`*^9, 3.769204042191204*^9}, {
   3.7692041782201395`*^9, 3.769204211165009*^9}, {3.7692042428710303`*^9, 
   3.769204276661768*^9}, {3.7692675966867456`*^9, 3.769267724788076*^9}, 
   3.840204405025261*^9, {3.8906727950698805`*^9, 
   3.890672796540653*^9}},ExpressionUUID->"d92db8b4-0eb2-4ccd-826f-\
465f6aaafe80"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vars", "=", 
    RowBox[{"{", 
     RowBox[{
     "a", ",", "A", ",", "d", ",", "AA", ",", "Ad", ",", "AAd", ",", "AdAd"}],
      "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"A", " ", "list", " ", "of", " ", "all", " ", "variables"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rep2", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AA", "\[Rule]", 
        FractionBox[
         SuperscriptBox["A", "2"], "Kdim"]}], ",", 
       RowBox[{"AAd", "\[Rule]", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["A", "2"], "d"}], 
         RowBox[{"f", " ", "Kdim", " ", "Kd"}]]}], ",", 
       RowBox[{"AdAd", "\[Rule]", 
        FractionBox[
         RowBox[{
          SuperscriptBox["A", "2"], 
          SuperscriptBox["d", "2"]}], 
         RowBox[{"f", " ", "g", " ", "Kdim", " ", 
          SuperscriptBox["Kd", "2"]}]]}], ",", 
       RowBox[{"Ad", "\[Rule]", 
        FractionBox[
         RowBox[{"A", " ", "d"}], "Kd"]}], ",", 
       RowBox[{"a", "\[Rule]", "0"}]}], "}"}], "/.", 
     RowBox[{"f", "\[Rule]", "1"}]}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"derived", " ", "from", " ", "equilibrium", " ", "relationships"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Consrv", "[", "eqns_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"eqns", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "+", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eqns", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "+", 
           RowBox[{"eqns", "[", 
            RowBox[{"[", "6", "]"}], "]"}], "+", 
           RowBox[{"eqns", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}]}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"eqns", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "6", "]"}], "]"}], "+", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"eqns", "[", 
           RowBox[{"[", "7", "]"}], "]"}], ")"}]}]}], "]"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
   "conservation", " ", "relations", " ", "for", " ", "RAF", " ", "and", " ", 
    "DTOT"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"eqnsconsrv", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Consrv", "[", "vars", "]"}], "/.", "rep2"}], "]"}], 
     "\[Equal]", 
     RowBox[{"{", 
      RowBox[{"RAF", ",", "DTOT"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7692042154998837`*^9, 3.7692042369245358`*^9}, {
   3.769204285127771*^9, 3.769204341657061*^9}, {3.769204538745946*^9, 
   3.769204548488737*^9}, {3.7692045887400646`*^9, 3.7692047475109215`*^9}, {
   3.769204807283332*^9, 3.7692048197677355`*^9}, {3.7692050383825026`*^9, 
   3.769205039460601*^9}, 3.7692678297233763`*^9, {3.769267866117442*^9, 
   3.769267932844144*^9}, 3.831920876102366*^9, {3.840203420465253*^9, 
   3.8402034244005575`*^9}, {3.8402034588172636`*^9, 3.840203493631587*^9}, {
   3.8402035590005283`*^9, 3.8402036105294175`*^9}, {3.840203640947667*^9, 
   3.840203652149537*^9}, 3.8402044050372953`*^9, {3.840206530217841*^9, 
   3.8402065402541914`*^9}, 3.840556387529007*^9, 3.8405564920735006`*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"817691c6-ca38-4c28-b3d3-024cc6ddddef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", "Kd", "+", 
       FractionBox[
        RowBox[{"2", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["d", "2"], "+", 
           RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
           RowBox[{"g", " ", 
            SuperscriptBox["Kd", "2"]}]}], ")"}]}], 
        RowBox[{"g", " ", "Kd", " ", "Kdim"}]]}], ")"}]}], "\[Equal]", 
    RowBox[{"Kd", " ", "RAF"}]}], ",", 
   RowBox[{
    RowBox[{"d", "+", 
     FractionBox[
      RowBox[{"A", " ", "d"}], "Kd"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["A", "2"], " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"g", " ", "Kd"}]}], ")"}]}], 
      RowBox[{"g", " ", 
       SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", "DTOT"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.84020358612233*^9, {3.8402036420185766`*^9, 3.840203652476896*^9}, 
   3.8402065432314997`*^9, 3.8405564238258085`*^9, 3.8405564931473246`*^9, 
   3.840562043219204*^9, 3.8405635156630077`*^9, 3.840563681083188*^9, 
   3.840650008496459*^9, 3.8406518430568833`*^9, 3.8407376776211777`*^9, 
   3.8449452816645813`*^9, 3.844965746118973*^9, 3.8905259203506246`*^9, 
   3.8906728827494793`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"523ffc19-8cde-4086-b2bd-d58ad919e7e8"]
}, Open  ]],

Cell["\<\
A simultaneous solution to both the above conservation equations is unwieldy \
and hard to obtain. Instead, we find partial solutions for kinase protomers \
as a function of free drug and then free drug as a function of the total drug \
and the kinase protomers. The latter solution is used to numerically \
construct d vs DTOT relationship.\
\>", "Text",
 CellChangeTimes->{{3.769268480156312*^9, 3.7692685358509054`*^9}, {
  3.769268566916627*^9, 
  3.7692686085566883`*^9}},ExpressionUUID->"52239470-3bad-456b-a447-\
6b1c2f6ac5cc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SimplifyPars", "[", "x_", "]"}], ":=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RAF", ">", "0"}], ",", 
       RowBox[{"DTOT", ">", "0"}], ",", 
       RowBox[{"Kd", ">", "0"}], ",", 
       RowBox[{"Kdim", ">", "0"}], ",", 
       RowBox[{"KA", ">", "0"}], ",", 
       RowBox[{"d", ">", "0"}], ",", 
       RowBox[{"f", ">", "0"}], ",", 
       RowBox[{"g", ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["d", "rel"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2A", "=", 
   RowBox[{
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"eqnsconsrv", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "A"}], "]"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "  ", 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol2d", "=", 
  RowBox[{
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eqnsconsrv", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "d"}], "]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7692048471231923`*^9, 3.769204893862154*^9}, {
   3.76920497064507*^9, 3.7692050944975214`*^9}, {3.7692051323859997`*^9, 
   3.7692051514924307`*^9}, 3.7692052273412123`*^9, {3.769265303470145*^9, 
   3.7692653221119733`*^9}, {3.769265358603253*^9, 3.769265393912998*^9}, {
   3.7692654276106925`*^9, 3.769265462871611*^9}, {3.7692660477712846`*^9, 
   3.7692660513184977`*^9}, {3.7692663939422703`*^9, 
   3.7692664234293437`*^9}, {3.7692681049231358`*^9, 3.769268105891485*^9}, {
   3.7692682434167233`*^9, 3.7692682738420897`*^9}, {3.7692683203389816`*^9, 
   3.7692683654636745`*^9}, {3.769436803124284*^9, 3.7694368039228525`*^9}, {
   3.812208796618473*^9, 3.812208800884694*^9}, {3.8402036688763957`*^9, 
   3.840203717780062*^9}, 3.8402044050482736`*^9, {3.8402065760048027`*^9, 
   3.840206623098114*^9}, {3.840556212620172*^9, 3.8405562150099587`*^9}, {
   3.84065086318596*^9, 3.840650874652392*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"ebc9bc83-e02e-4ced-9ecf-ba28f20458cb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"A", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"g", " ", "Kd", " ", "Kdim", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"2", " ", "d", " ", "g", " ", "Kd", " ", 
            RowBox[{"(", 
             RowBox[{"Kdim", "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{"g", " ", 
            SuperscriptBox["Kd", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"Kdim", "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["d", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"g", " ", "Kdim"}], "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], 
          RowBox[{"g", " ", "Kdim"}]]]}], ")"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
        RowBox[{"g", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, 
   3.840206579252473*^9, {3.840206611945136*^9, 3.840206623481783*^9}, 
   3.840556423903917*^9, 3.8405564965826397`*^9, 3.8405620434219627`*^9, 
   3.840563515948162*^9, 3.8405636812837934`*^9, 3.8406500115221567`*^9, 
   3.840650875162216*^9, 3.8406518457565145`*^9, 3.840737677826247*^9, 
   3.8449452818803616`*^9, 3.844965746335193*^9, 3.8905259210127363`*^9, 
   3.890672885408806*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"7c8fbab3-4b30-417d-bf52-69df1a05bbab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"g", " ", "Kd", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"]}], "+", 
        RowBox[{"A", " ", "Kdim"}], "+", 
        RowBox[{"Kd", " ", "Kdim"}], "+", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["A", "2"], " ", "DTOT", " ", "Kdim"}], "+", 
           RowBox[{"g", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["A", "2"]}], "+", 
               RowBox[{"A", " ", "Kdim"}], "+", 
               RowBox[{"Kd", " ", "Kdim"}]}], ")"}], "2"]}]}], "g"]]}], 
       ")"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["A", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, 
   3.840206579252473*^9, {3.840206611945136*^9, 3.840206623481783*^9}, 
   3.840556423903917*^9, 3.8405564965826397`*^9, 3.8405620434219627`*^9, 
   3.840563515948162*^9, 3.8405636812837934`*^9, 3.8406500115221567`*^9, 
   3.840650875162216*^9, 3.8406518457565145`*^9, 3.840737677826247*^9, 
   3.8449452818803616`*^9, 3.844965746335193*^9, 3.8905259210127363`*^9, 
   3.8906728856431804`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"1803ee89-4062-4c92-bee2-49aa73136090"]
}, Open  ]],

Cell["\<\
We estimate the total activity by counting all of the drug-free protomers \
which occur within a partly active or fully active dimer. Substituting the \
above solution into the expression for Raf activity and dividing by total RAF \
concentration, we obtain the proportionate activity as a function of total \
drug and other parameters.\
\>", "Text",
 CellChangeTimes->{{3.7692051569956264`*^9, 3.7692052249831033`*^9}, {
   3.7692053058924074`*^9, 3.7692053326957016`*^9}, {3.7692665900295753`*^9, 
   3.7692665948921833`*^9}, 3.7692684645670233`*^9, {3.7692686287467785`*^9, 
   3.7692686294649706`*^9}},ExpressionUUID->"9a4fad16-4886-4b98-9719-\
bfd93fa8dd28"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RafActivity", "[", "vars_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"vars", "[", 
     RowBox[{"[", "4", "]"}], "]"}]}], " ", "+", " ", 
   RowBox[{"vars", "[", 
    RowBox[{"[", "6", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fnActiveRAF", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RafActivity", "[", "vars", "]"}], "/", "RAF"}], "/.", 
      "rep2"}], "/.", "sol2A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repratios", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kdim", "\[Rule]", 
      FractionBox["RAF", 
       SubscriptBox["RAF", "rel"]]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"Kd", " ", 
       SubscriptBox["d", "rel"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAFNC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"fnActiveRAF", "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAF2NC", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"fnActiveRAFNC", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "\[Rule]", "E1n"}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], "\[Rule]", 
        RowBox[{
         RowBox[{"E2n", "/", 
          RowBox[{"(", 
           RowBox[{"g", "+", 
            RowBox[{"2", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SuperscriptBox[
             SubscriptBox["d", "rel"], "2"]}], ")"}]}], "/", "8"}]}]}], 
      "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.769205220141611*^9, 3.769205289672014*^9}, {
   3.769205345593025*^9, 3.769205353284094*^9}, {3.7692054655437536`*^9, 
   3.7692054685969486`*^9}, {3.769265526917851*^9, 3.7692655613369493`*^9}, {
   3.7692655940807266`*^9, 3.7692657331243925`*^9}, {3.7692657719746237`*^9, 
   3.769265864876149*^9}, {3.7692658997040854`*^9, 3.7692659006156936`*^9}, {
   3.769266749046686*^9, 3.769266750912019*^9}, {3.769268445259807*^9, 
   3.76926844899031*^9}, {3.769268639956765*^9, 3.769268644269384*^9}, {
   3.769268830483199*^9, 3.7692688709844255`*^9}, {3.7692689173114767`*^9, 
   3.769269038442933*^9}, {3.769269089183334*^9, 3.769269285211043*^9}, {
   3.7692695137259455`*^9, 3.7692695528466825`*^9}, {3.769269651781829*^9, 
   3.76926965421002*^9}, {3.7694368136077976`*^9, 3.7694368142564898`*^9}, {
   3.7694375986201754`*^9, 3.7694376029376187`*^9}, {3.7694382649841013`*^9, 
   3.769438269629182*^9}, {3.769439034726965*^9, 3.7694390745272303`*^9}, {
   3.812214333570692*^9, 3.812214391783123*^9}, {3.8123859575711336`*^9, 
   3.812386008423128*^9}, {3.8123860614959884`*^9, 3.8123861254690137`*^9}, 
   3.831474994890194*^9, {3.8319208702531366`*^9, 3.831920870955785*^9}, {
   3.8319211759273367`*^9, 3.8319211759273367`*^9}, {3.8319237689036894`*^9, 
   3.8319237970863533`*^9}, {3.831923844715188*^9, 3.831923850773985*^9}, {
   3.831924074308251*^9, 3.8319240757594156`*^9}, {3.840203742192509*^9, 
   3.8402039027208576`*^9}, {3.840203969207242*^9, 3.8402039799679236`*^9}, {
   3.840204018691835*^9, 3.840204049292286*^9}, {3.8402066283547745`*^9, 
   3.8402066392013884`*^9}, {3.8405561033091955`*^9, 
   3.8405561061737723`*^9}, {3.840556217923959*^9, 3.8405562228186655`*^9}, 
   3.8405565012434216`*^9, {3.8405621485526843`*^9, 3.840562148769286*^9}, {
   3.8406500274579215`*^9, 3.8406500462139273`*^9}, {3.840650076961545*^9, 
   3.840650082304112*^9}, {3.840650392336549*^9, 3.8406504122881966`*^9}, {
   3.840651825440974*^9, 3.8406518705658555`*^9}, {3.8906729217793803`*^9, 
   3.890672933851634*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"16a4f37d-cc66-477f-974f-b6a58180704a"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SubscriptBox["d", "rel"], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"g", "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], "g"]}]]}], ")"}], "2"]}], 
  RowBox[{"8", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"g", "+", 
      RowBox[{"2", " ", "g", " ", 
       SubscriptBox["d", "rel"]}], "+", 
      SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, 3.840206641421914*^9, 
   3.840556424013302*^9, 3.8405565033339224`*^9, 3.8405620447223825`*^9, 
   3.840562149672517*^9, 3.840563517471935*^9, 3.8405636826517663`*^9, 
   3.8406500155233583`*^9, {3.84065005526573*^9, 3.840650083708341*^9}, {
   3.840650396420232*^9, 3.840650428562503*^9}, {3.840651856512575*^9, 
   3.840651871537578*^9}, 3.8407376793853564`*^9, 3.8449452831148543`*^9, 
   3.84496574793958*^9, 3.8905259247597575`*^9, {3.890672898205347*^9, 
   3.890672934238029*^9}},
 CellLabel->"Out[66]=",ExpressionUUID->"68269cc3-3fcf-4825-a4de-fd894aaf8fb5"],

Cell[BoxData[
 FractionBox[
  RowBox[{"E1n", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"E1n", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["E1n", "2"], "+", 
        FractionBox["E2n", "g"]}]]}], ")"}], "2"], " ", 
   SuperscriptBox["g", "2"]}], 
  RowBox[{"E2n", " ", 
   RowBox[{"(", 
    RowBox[{"g", "+", 
     RowBox[{"2", " ", "g", " ", 
      SubscriptBox["d", "rel"]}], "+", 
     SubsuperscriptBox["d", "rel", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, 3.840206641421914*^9, 
   3.840556424013302*^9, 3.8405565033339224`*^9, 3.8405620447223825`*^9, 
   3.840562149672517*^9, 3.840563517471935*^9, 3.8405636826517663`*^9, 
   3.8406500155233583`*^9, {3.84065005526573*^9, 3.840650083708341*^9}, {
   3.840650396420232*^9, 3.840650428562503*^9}, {3.840651856512575*^9, 
   3.840651871537578*^9}, 3.8407376793853564`*^9, 3.8449452831148543`*^9, 
   3.84496574793958*^9, 3.8905259247597575`*^9, {3.890672898205347*^9, 
   3.8906729343005204`*^9}},
 CellLabel->"Out[67]=",ExpressionUUID->"8b25b237-da68-479b-ae5e-92dee3b2b660"]
}, Open  ]],

Cell["\<\
Note that the above equations represent the total active RAF protomers in \
proportion to the total RAF kinase as a function of unbound drug (d). In \
order to analytically establish parameter values which correspond to \
activation of the kinase, we find the first derivative of this function and \
search for it\[CloseCurlyQuote]s zeroes.\
\>", "Text",
 CellChangeTimes->{{3.8314750261787057`*^9, 3.831475036190924*^9}, {
  3.8324318762945156`*^9, 3.832431882900982*^9}, {3.8906730251848035`*^9, 
  3.890673030704776*^9}},ExpressionUUID->"b848f17c-ee20-429b-acf6-\
01946e865880"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RafDimers", "[", "eqns_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"eqns", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnDimersNC", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RafDimers", "[", "vars", "]"}], "/", "RAF"}], "/.", 
        "rep2"}], "/.", "sol2A"}], ")"}], "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"fnDimersNC", "/", "fnActiveRAFNC"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8319238615172873`*^9, 3.83192390513754*^9}, {
   3.831923943703373*^9, 3.8319239810051637`*^9}, {3.83192408057911*^9, 
   3.8319240873711205`*^9}, 3.84020440505526*^9, {3.840204452736744*^9, 
   3.840204473036141*^9}, {3.84020671392641*^9, 3.8402067230549016`*^9}, {
   3.840556506171677*^9, 3.8405565150331097`*^9}, {3.8405565935081615`*^9, 
   3.8405566038436413`*^9}, {3.840650315375628*^9, 3.840650337319457*^9}, {
   3.8406505201176662`*^9, 3.840650553239172*^9}, {3.840650593459399*^9, 
   3.8406505948184524`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"32739ff3-926e-46c4-a502-ea36af6febd4"],

Cell[BoxData[
 FractionBox[
  RowBox[{"g", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SubscriptBox["d", "rel"], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"g", "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], "g"]}]]}], ")"}], "2"]}], 
  RowBox[{"16", " ", 
   RowBox[{"(", 
    RowBox[{"g", "+", 
     RowBox[{"2", " ", "g", " ", 
      SubscriptBox["d", "rel"]}], "+", 
     SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840206725107705*^9, 3.840556424107044*^9, {3.8405565080686965`*^9, 
   3.840556515540002*^9}, 3.84055660426995*^9, 3.8405620462485685`*^9, 
   3.8405635183847413`*^9, 3.840563683423008*^9, {3.840650322848297*^9, 
   3.840650337560209*^9}, {3.8406505234899263`*^9, 3.840650533374672*^9}, 
   3.8406505951864223`*^9, 3.840737680251919*^9, 3.844945283985131*^9, 
   3.844965748942275*^9, 3.8905259260408688`*^9, 3.890673010634741*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"d5f8c037-bd77-4707-be57-9e977622ece4"],

Cell[BoxData[
 FractionBox[
  RowBox[{"g", "+", 
   RowBox[{"2", " ", "g", " ", 
    SubscriptBox["d", "rel"]}], "+", 
   SubsuperscriptBox["d", "rel", "2"]}], 
  RowBox[{
   RowBox[{"2", " ", "g"}], "+", 
   RowBox[{"2", " ", "g", " ", 
    SubscriptBox["d", "rel"]}]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840206725107705*^9, 3.840556424107044*^9, {3.8405565080686965`*^9, 
   3.840556515540002*^9}, 3.84055660426995*^9, 3.8405620462485685`*^9, 
   3.8405635183847413`*^9, 3.840563683423008*^9, {3.840650322848297*^9, 
   3.840650337560209*^9}, {3.8406505234899263`*^9, 3.840650533374672*^9}, 
   3.8406505951864223`*^9, 3.840737680251919*^9, 3.844945283985131*^9, 
   3.844965748942275*^9, 3.8905259260408688`*^9, 3.890673010634741*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"28de2892-a589-4315-9c7e-1ae422295386"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.2. Baseline Signaling (drug-free)", "Subsubsection",
 CellChangeTimes->{{3.812385908612563*^9, 3.812385920080598*^9}, {
  3.833159643863964*^9, 3.8331596657361794`*^9}, {3.8406508057503386`*^9, 
  3.840650805840488*^9}, {3.8449390907004795`*^9, 
  3.84493909087908*^9}},ExpressionUUID->"15ca7b6b-4abc-4edd-89dd-\
b918be2f3710"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"baselineActiveRAFNC", "=", 
  RowBox[{"fnActiveRAFNC", "/.", 
   RowBox[{
    SubscriptBox["d", "rel"], "\[Rule]", "0"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"D", "[", 
   RowBox[{"baselineActiveRAFNC", ",", 
    SubscriptBox["RAF", "rel"]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8123859215610027`*^9, 3.812385936919848*^9}, {
   3.8123861495330424`*^9, 3.812386224346416*^9}, {3.812386278673541*^9, 
   3.812386294471064*^9}, {3.8123863259077187`*^9, 3.8123863683020535`*^9}, {
   3.8123864109056587`*^9, 3.8123864240308285`*^9}, {3.8319211091015835`*^9, 
   3.8319211176118765`*^9}, 3.8319211759429626`*^9, {3.8402045142905054`*^9, 
   3.8402045162565413`*^9}, {3.8402067486235056`*^9, 3.840206770774847*^9}, {
   3.8406506137043695`*^9, 3.8406506354465046`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"7744aafb-34f1-4cfe-884b-4bdf1a8db257"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"8", " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
  RowBox[{"8", " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, {3.8402067557002115`*^9, 3.8402067712903657`*^9}, {
   3.840650607931018*^9, 3.8406506358532248`*^9}, 3.89052592615189*^9, 
   3.890673039859514*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"16ab5423-2658-486f-a016-b55fe8921e54"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"8", " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
  RowBox[{"8", " ", 
   SubsuperscriptBox["RAF", "rel", "2"], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"8", " ", 
      SubscriptBox["RAF", "rel"]}]}]]}]]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, {3.8402067557002115`*^9, 3.8402067712903657`*^9}, {
   3.840650607931018*^9, 3.8406506358532248`*^9}, 3.89052592615189*^9, 
   3.890673039875121*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"3ef173cd-b1b4-465e-a7f7-c72950dc91ed"]
}, Open  ]],

Cell[TextData[{
 "The derivative of baseline signaling relative to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["RAF", "rel"], " "}], TraditionalForm]],ExpressionUUID->
  "83639a59-ba12-44e8-b9ed-df8c28c50ad9"],
 "is a positive definite function. Therefore, baseline signaling is a \
monotonically proportionate to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["RAF", "rel"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7e7d620d-674f-4078-9597-10632585930e"],
 "."
}], "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
  3.812386377540579*^9, 3.8123864833252983`*^9}, {3.8402067868526497`*^9, 
  3.8402067897971535`*^9}, {3.8906732219263363`*^9, 
  3.890673227322343*^9}},ExpressionUUID->"2e1ea1e4-b7de-461f-9dcf-\
c4530fc07346"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.2.3. Conditions on parameter regions for activation in response to the drug\
\>", "Subsubsection",
 CellChangeTimes->{{3.769352693017748*^9, 3.7693527442245555`*^9}, 
   3.8319232589041615`*^9, {3.833159646729958*^9, 3.833159664629573*^9}, {
   3.8406508068873453`*^9, 3.840650806981097*^9}, {3.8449390919053555`*^9, 
   3.8449390922531495`*^9}},ExpressionUUID->"b5bcc4d3-6dae-4e66-913c-\
7d7af9530db2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dfn2", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"fnActiveRAFNC", ",", 
     SubscriptBox["d", "rel"]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.755541810342499*^9, 3.7555418608619113`*^9}, {
   3.755541978622472*^9, 3.7555419807907124`*^9}, {3.7555571218326187`*^9, 
   3.7555571219456987`*^9}, {3.7556152697929463`*^9, 3.755615271368307*^9}, {
   3.755615528332312*^9, 3.7556155322520323`*^9}, {3.755615647889366*^9, 
   3.755615736790206*^9}, {3.7556192151498156`*^9, 3.7556192592915344`*^9}, {
   3.755619311851678*^9, 3.75561931599358*^9}, {3.7556396242742844`*^9, 
   3.755639637221635*^9}, {3.7590911604934464`*^9, 3.759091242876088*^9}, {
   3.759091274647378*^9, 3.759091275112709*^9}, 3.7646075097588253`*^9, {
   3.7692693888047943`*^9, 3.769269390671215*^9}, {3.7692695640617847`*^9, 
   3.7692696334602895`*^9}, {3.7692696651592636`*^9, 3.7692696859256325`*^9}, 
   3.769436826714548*^9, {3.8129938947361474`*^9, 3.8129939100528193`*^9}, 
   3.831920887884055*^9, 3.8319211759429626`*^9, 3.8402045504842486`*^9, {
   3.8405654709095154`*^9, 3.8405654709940224`*^9}, {3.840650824791685*^9, 
   3.840650833025722*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"90848e76-0424-416f-9aa5-51530d31daf1"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"g", "+", 
       RowBox[{"2", " ", "g", " ", 
        SubscriptBox["d", "rel"]}], "+", 
       SubsuperscriptBox["d", "rel", "2"]}], ")"}], "3"], " ", 
    SubscriptBox["RAF", "rel"]}]], 
  RowBox[{
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["d", "rel"], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{"g", "+", 
           RowBox[{"2", " ", "g", " ", 
            SubscriptBox["d", "rel"]}], "+", 
           SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
         SubscriptBox["RAF", "rel"]}], "g"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"g", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubscriptBox["d", "rel"], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"g", "+", 
              RowBox[{"2", " ", "g", " ", 
               SubscriptBox["d", "rel"]}], "+", 
              SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
            SubscriptBox["RAF", "rel"]}], "g"]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"g", "+", 
        RowBox[{"2", " ", "g", " ", 
         SubscriptBox["d", "rel"]}], "+", 
        SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubscriptBox["d", "rel"], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"g", "+", 
              RowBox[{"2", " ", "g", " ", 
               SubscriptBox["d", "rel"]}], "+", 
              SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
            SubscriptBox["RAF", "rel"]}], "g"]}]]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"g", "+", 
        RowBox[{"2", " ", "g", " ", 
         SubscriptBox["d", "rel"]}], "+", 
        SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "g"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"8", " ", 
              SubscriptBox["RAF", "rel"]}]}], ")"}]}], "-", 
          RowBox[{
           SubscriptBox["d", "rel"], " ", 
           RowBox[{"(", 
            RowBox[{"g", "+", 
             RowBox[{"8", " ", 
              SubscriptBox["RAF", "rel"]}]}], ")"}]}]}], 
         RowBox[{"g", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
            FractionBox[
             RowBox[{"8", " ", 
              RowBox[{"(", 
               RowBox[{"g", "+", 
                RowBox[{"2", " ", "g", " ", 
                 SubscriptBox["d", "rel"]}], "+", 
                SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
              SubscriptBox["RAF", "rel"]}], "g"]}]]}]]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.8402045507751465`*^9, 3.840206279165141*^9, {3.840565466994125*^9, 
   3.8405654720815754`*^9}, 3.8406363071040087`*^9, 3.8406434608794775`*^9, {
   3.8406454226829123`*^9, 3.8406454367614737`*^9}, {3.8406508280526695`*^9, 
   3.840650833389456*^9}, 3.840650884601083*^9, 3.8905259274041357`*^9, 
   3.890673240574709*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"b46ae39c-0bd6-4628-9579-cb34b6ec34af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"existPANC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Reduce", "[", 
    RowBox[{"(", 
     RowBox[{"dfn2", ">", "0"}], ")"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8406454416015234`*^9, 3.840645455094884*^9}, {
  3.840645527623123*^9, 3.840645548071183*^9}, {3.8406455793475046`*^9, 
  3.8406455802647233`*^9}, {3.840645730738617*^9, 3.8406457329731913`*^9}, {
  3.8406466256361165`*^9, 3.8406466256983*^9}, {3.8406508362114973`*^9, 
  3.84065085434888*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"6e0898da-0581-4d4c-a1cf-0a5b85887e14"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.840645451202583*^9, 3.8406454743784385`*^9}, {
   3.8406455405860806`*^9, 3.840645584502401*^9}, 3.8406457387303486`*^9, 
   3.840646627375697*^9, 3.8406508440410557`*^9, 3.840650889695984*^9, 
   3.8905259327930756`*^9, 3.89067324628649*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"b90c5b77-c9f3-484f-b75a-3036497167d5"]
}, Open  ]],

Cell[TextData[{
 "Therefore, the derivative of active RAF relative to unbound drug may never \
be positive, independent of the drug concentration and negative \
cooperativity. ",
 StyleBox["This mechanism does not produce PA",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.8406455159354043`*^9, 3.8406455226362214`*^9}, {
  3.840645586307036*^9, 3.8406455955655184`*^9}, {3.840645694674875*^9, 
  3.840645725719434*^9}, {3.8406457620525007`*^9, 3.840645769791148*^9}, {
  3.8406508989603453`*^9, 3.8406509503940315`*^9}, {3.8906732519891148`*^9, 
  3.890673253254682*^9}},ExpressionUUID->"cbbbc5e4-0cd1-4e8d-b031-\
59dd0c1777c9"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.5. Analytic Expressions for maximum Fold Change (FC) ", \
"Subsubsection",
 CellChangeTimes->{{3.831920558274994*^9, 3.831920568951131*^9}, {
   3.8319206099444203`*^9, 3.8319206382915373`*^9}, {3.8319228274578667`*^9, 
   3.831922828296911*^9}, {3.831923265609557*^9, 3.831923265941924*^9}, 
   3.832088767728548*^9, {3.8331596529044495`*^9, 3.8331596605908427`*^9}, {
   3.8406508108778505`*^9, 3.840650810979351*^9}, {3.8449390933877096`*^9, 
   3.844939093535036*^9}},ExpressionUUID->"35e80607-04c2-48ef-94c8-\
da6cda04703c"],

Cell["\<\
Fold change is defined as the ratio between maximum RAF activity (no/conc of \
active protomers) to that in absence of drug\
\>", "Text",
 CellChangeTimes->{{3.8319210014332504`*^9, 
  3.831921044927513*^9}},ExpressionUUID->"f35a1d20-9afc-4bbf-a252-\
16fa75bfe488"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maxActiveRAFNC", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"SimplifyPars", "[", "fnActiveRAFNC", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rafFC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"maxActiveRAFNC", "/", "baselineActiveRAFNC"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8319206411308155`*^9, 3.831920654543648*^9}, {
   3.8319209514436145`*^9, 3.831920964234915*^9}, {3.8319210462861276`*^9, 
   3.8319210808824434`*^9}, {3.8319211410192847`*^9, 
   3.8319211418294463`*^9}, {3.8319212907129707`*^9, 3.831921293775152*^9}, 
   3.831929927406506*^9, {3.8320860698850856`*^9, 3.8320861755815163`*^9}, {
   3.8320864795071588`*^9, 3.8320865564244003`*^9}, {3.8320866370022855`*^9, 
   3.832086656919811*^9}, {3.8321657983699083`*^9, 3.8321657985708137`*^9}, {
   3.8406509835918937`*^9, 3.840651001137063*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"b96ced7a-d61c-4e53-9a2a-816669f64f80"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SubscriptBox["d", "rel"], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"g", "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], "g"]}]]}], ")"}], "2"]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"g", "+", 
      RowBox[{"2", " ", "g", " ", 
       SubscriptBox["d", "rel"]}], "+", 
      SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.8406509919503746`*^9, 3.8406510017457495`*^9}, 
   3.8905259331633463`*^9, 3.8906735000136724`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"fce580bc-3a2d-4888-8803-b50061b0ca6f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dRAFrafFC", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"D", "[", 
     RowBox[{"rafFC", ",", 
      SubscriptBox["RAF", "rel"]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dgrafFC", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"D", "[", 
     RowBox[{"rafFC", ",", "g"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{"dRAFrafFC", ">", "0"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{"dgrafFC", ">", "0"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.832086689751876*^9, 3.8320867350715184`*^9}, {
  3.832087084899557*^9, 3.8320870857655926`*^9}, {3.8320873820129504`*^9, 
  3.832087506095231*^9}, {3.832087718396454*^9, 3.8320877721038113`*^9}, {
  3.840651135469471*^9, 3.840651183051739*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"f0b1eeee-25ad-4d37-8964-5789af8ed38b"],

Cell[BoxData[
 RowBox[{"g", ">", "1"}]], "Output",
 CellChangeTimes->{{3.8320867192948036`*^9, 3.832086735541482*^9}, {
   3.832087390453227*^9, 3.8320873958642416`*^9}, {3.8320874327581825`*^9, 
   3.83208743999654*^9}, {3.832087473760183*^9, 3.8320875067748528`*^9}, 
   3.832087772873245*^9, {3.840651142415084*^9, 3.840651187626205*^9}, 
   3.890525942292343*^9, 3.89067351882686*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"741f29df-ad90-468d-b88c-3f93694b62a1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8320867192948036`*^9, 3.832086735541482*^9}, {
   3.832087390453227*^9, 3.8320873958642416`*^9}, {3.8320874327581825`*^9, 
   3.83208743999654*^9}, {3.832087473760183*^9, 3.8320875067748528`*^9}, 
   3.832087772873245*^9, {3.840651142415084*^9, 3.840651187626205*^9}, 
   3.890525942292343*^9, 3.8906735192956147`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"770fdb74-ac4c-43df-bd45-8f328de68cd5"]
}, Open  ]],

Cell[TextData[{
 "Hence, first derivative of the fold change expression relative to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["RAF", "rel"], TraditionalForm]],ExpressionUUID->
  "fdf7138f-643c-431d-9a39-f8df770b6b18"],
 " is always positive in the negative cooperativity model and always negative \
in positive cooperativity model. That is when g>1: negative cooperativity \
mediates increase in activity with increase in [RAF]."
}], "Text",
 CellChangeTimes->{{3.832087510939499*^9, 3.8320875447076406`*^9}, {
  3.832087599566928*^9, 3.8320876870914345`*^9}, {3.840651200901719*^9, 
  3.8406512164308424`*^9}, {3.840651262930973*^9, 3.840651292179845*^9}, {
  3.8906735498350534`*^9, 3.8906735796296916`*^9}, {3.8906736313718224`*^9, 
  3.890673681124655*^9}},ExpressionUUID->"9afe74c5-e4d4-414b-bbd0-\
eba044b30b21"],

Cell["\<\
Even though fold change is not paradoxical (PA<1), as negative cooperativity \
increases, fold change increases. In other mechanisms where PA exists, \
negative cooperativity increases PA further.\
\>", "Text",
 CellChangeTimes->{{3.832087510939499*^9, 3.8320875447076406`*^9}, {
  3.832087599566928*^9, 3.8320876870914345`*^9}, {3.840651200901719*^9, 
  3.8406512164308424`*^9}, {3.840651262930973*^9, 3.8406513192067847`*^9}, {
  3.8906736872089844`*^9, 
  3.890673744430663*^9}},ExpressionUUID->"96dab82c-4d00-4c04-8aaa-\
f1520dea301d"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Section 1.3. Conformal Autoinhibition (CA/base) Model", "Section",
 CellChangeTimes->{{3.76919880174008*^9, 3.7691988613532224`*^9}, 
   3.769273566954769*^9, {3.8402032805684576`*^9, 3.840203284256183*^9}, 
   3.8402033256104307`*^9, {3.840203372846386*^9, 3.8402033810709023`*^9}, {
   3.8407375834075775`*^9, 3.8407375953007126`*^9}, {3.844883675865032*^9, 
   3.8448836776850986`*^9}, {3.85230041812926*^9, 
   3.85230042070566*^9}},ExpressionUUID->"4378eacf-defd-4bd9-84a4-\
11a9f19bafdc"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.769456144052461*^9, 3.7694561471807184`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"a1f4172a-8b71-44be-b407-9885a9e549f9"],

Cell[CellGroupData[{

Cell["1.3.1. Analytic Solution to the model", "Subsubsection",
 CellChangeTimes->{{3.7692694154543457`*^9, 3.7692694289690504`*^9}, {
  3.769436772449255*^9, 3.769436772675357*^9}, {3.8324323477216988`*^9, 
  3.83243234796869*^9}, {3.8331596409988627`*^9, 3.8331596677817163`*^9}, {
  3.8407375849841375`*^9, 3.84073759780503*^9}, {3.8449390983378143`*^9, 
  3.8449390985227118`*^9}},ExpressionUUID->"9ad30ae3-023e-42c3-82f7-\
93a33d5cd2f5"],

Cell["\<\
This model incorporates all the mechanisms from the part models to combine \
into a model of kinase which auto-inhibits (a), which, for simplicity, is \
modeled to relieve at a first order rate to an assembled state (A). The \
assembled kinase state can dimerize (AA) or bind with  a drug (Ad). The \
kinase dimer (AA), upon drug administration can occur in either partly (AAd) \
or fully inhibited state (AdAd). The equilibrium state relationships and \
protein concentration conservation equations for both total RAF (RAF) and \
total drug (DTOT) are defined as follows.\
\>", "Text",
 CellChangeTimes->{{3.7692038930283422`*^9, 3.769204042191204*^9}, {
   3.7692041782201395`*^9, 3.769204211165009*^9}, {3.7692042428710303`*^9, 
   3.769204276661768*^9}, {3.7692675966867456`*^9, 3.769267724788076*^9}, 
   3.840204405025261*^9},ExpressionUUID->"cab4411e-ab1f-4622-a317-\
f91b3e023e2d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vars", "=", 
    RowBox[{"{", 
     RowBox[{
     "a", ",", "A", ",", "d", ",", "AA", ",", "Ad", ",", "AAd", ",", "AdAd"}],
      "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"A", " ", "list", " ", "of", " ", "all", " ", "variables"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rep3", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AA", "\[Rule]", 
        FractionBox[
         SuperscriptBox["A", "2"], "Kdim"]}], ",", 
       RowBox[{"AAd", "\[Rule]", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["A", "2"], "d"}], 
         RowBox[{"f", " ", "Kdim", " ", "Kd"}]]}], ",", 
       RowBox[{"AdAd", "\[Rule]", 
        FractionBox[
         RowBox[{
          SuperscriptBox["A", "2"], 
          SuperscriptBox["d", "2"]}], 
         RowBox[{"f", " ", "g", " ", "Kdim", " ", 
          SuperscriptBox["Kd", "2"]}]]}], ",", 
       RowBox[{"Ad", "\[Rule]", 
        FractionBox[
         RowBox[{"A", " ", "d"}], "Kd"]}], ",", 
       RowBox[{"a", "\[Rule]", 
        RowBox[{"A", " ", "KA"}]}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "1"}]}], "}"}]}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"derived", " ", "from", " ", "equilibrium", " ", "relationships"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Consrv", "[", "eqns_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"eqns", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "+", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eqns", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "+", 
           RowBox[{"eqns", "[", 
            RowBox[{"[", "6", "]"}], "]"}], "+", 
           RowBox[{"eqns", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}]}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"eqns", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "6", "]"}], "]"}], "+", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"eqns", "[", 
           RowBox[{"[", "7", "]"}], "]"}], ")"}]}]}], "]"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
   "conservation", " ", "relations", " ", "for", " ", "RAF", " ", "and", " ", 
    "DTOT"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"eqnsconsrv", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Consrv", "[", "vars", "]"}], "/.", "rep3"}], "]"}], 
     "\[Equal]", 
     RowBox[{"{", 
      RowBox[{"RAF", ",", "DTOT"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7692042154998837`*^9, 3.7692042369245358`*^9}, {
   3.769204285127771*^9, 3.769204341657061*^9}, {3.769204538745946*^9, 
   3.769204548488737*^9}, {3.7692045887400646`*^9, 3.7692047475109215`*^9}, {
   3.769204807283332*^9, 3.7692048197677355`*^9}, {3.7692050383825026`*^9, 
   3.769205039460601*^9}, 3.7692678297233763`*^9, {3.769267866117442*^9, 
   3.769267932844144*^9}, 3.831920876102366*^9, {3.840203420465253*^9, 
   3.8402034244005575`*^9}, {3.8402034588172636`*^9, 3.840203493631587*^9}, {
   3.8402035590005283`*^9, 3.8402036105294175`*^9}, {3.840203640947667*^9, 
   3.840203652149537*^9}, 3.8402044050372953`*^9, {3.8402068695510616`*^9, 
   3.8402068772958307`*^9}, {3.840556379872716*^9, 3.8405563839001265`*^9}, 
   3.840556529639718*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"08bc4639-0467-4935-832f-99f6dc437dbe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"A", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "A", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", "Kd"}], ")"}], "2"]}], "+", 
        RowBox[{"Kd", " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", "Kd", "+", 
           RowBox[{"KA", " ", "Kd"}]}], ")"}], " ", "Kdim"}]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["Kd", "2"], " ", "Kdim"}]], "\[Equal]", "RAF"}], ",", 
   RowBox[{
    RowBox[{"d", "+", 
     FractionBox[
      RowBox[{"A", " ", "d"}], "Kd"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["A", "2"], " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", "Kd"}], ")"}]}], 
      RowBox[{
       SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", "DTOT"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.84020358612233*^9, {3.8402036420185766`*^9, 3.840203652476896*^9}, 
   3.840206878312575*^9, 3.840206934134245*^9, 3.840209266037239*^9, 
   3.8405563034236493`*^9, 3.8405565306063356`*^9, 3.840562108758385*^9, 
   3.8405635205505867`*^9, 3.8405636843772464`*^9, 3.840651344105236*^9, 
   3.840651955932725*^9, 3.840737680537919*^9, 3.8449452874637938`*^9, 
   3.8449657498983464`*^9, 3.8449661638329477`*^9, 3.8905259846120024`*^9, 
   3.8906737517536077`*^9, 3.8928387750346403`*^9, 3.898647225382369*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"dd1e283b-5fc9-4b77-a139-04523ed6d3ed"]
}, Open  ]],

Cell["\<\
A simultaneous solution to both the above conservation equations is unwieldy \
and hard to obtain. Instead, we find partial solutions for kinase protomers \
as a function of free drug and then free drug as a function of the total drug \
and the kinase protomers. The latter solution is used to numerically \
construct d vs DTOT relationship.\
\>", "Text",
 CellChangeTimes->{{3.769268480156312*^9, 3.7692685358509054`*^9}, {
  3.769268566916627*^9, 
  3.7692686085566883`*^9}},ExpressionUUID->"e991cd86-41c3-4b63-acd2-\
ef684e8f803f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SimplifyPars", "[", "x_", "]"}], ":=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RAF", ">", "0"}], ",", 
       RowBox[{"DTOT", ">", "0"}], ",", 
       RowBox[{"Kd", ">", "0"}], ",", 
       RowBox[{"Kdim", ">", "0"}], ",", 
       RowBox[{"KA", ">", "0"}], ",", 
       RowBox[{"d", ">", "0"}], ",", 
       RowBox[{"f", ">", "0"}], ",", 
       RowBox[{"g", ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol3A", "=", 
   RowBox[{
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"eqnsconsrv", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "A"}], "]"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "  ", 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol3d", "=", 
  RowBox[{
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eqnsconsrv", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "d"}], "]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7692048471231923`*^9, 3.769204893862154*^9}, {
   3.76920497064507*^9, 3.7692050944975214`*^9}, {3.7692051323859997`*^9, 
   3.7692051514924307`*^9}, 3.7692052273412123`*^9, {3.769265303470145*^9, 
   3.7692653221119733`*^9}, {3.769265358603253*^9, 3.769265393912998*^9}, {
   3.7692654276106925`*^9, 3.769265462871611*^9}, {3.7692660477712846`*^9, 
   3.7692660513184977`*^9}, {3.7692663939422703`*^9, 
   3.7692664234293437`*^9}, {3.7692681049231358`*^9, 3.769268105891485*^9}, {
   3.7692682434167233`*^9, 3.7692682738420897`*^9}, {3.7692683203389816`*^9, 
   3.7692683654636745`*^9}, {3.769436803124284*^9, 3.7694368039228525`*^9}, {
   3.812208796618473*^9, 3.812208800884694*^9}, {3.8402036688763957`*^9, 
   3.840203717780062*^9}, 3.8402044050482736`*^9, {3.840206921831241*^9, 
   3.840206923735265*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"848cec35-acef-42f9-8e4e-eafe8844686d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"A", "\[Rule]", 
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"d", "+", "Kd"}], ")"}], "2"]}]], 
     RowBox[{"Kd", " ", "Kdim", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", "Kd", "+", 
               RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], " ", "Kdim"}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", "Kd"}], ")"}], "2"], " ", "RAF"}]}], 
          "Kdim"]]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, 
   3.8402068814933186`*^9, 3.840206934366068*^9, 3.84020926652293*^9, 
   3.840556303662549*^9, 3.8405565335592537`*^9, 3.8405621090056915`*^9, 
   3.840563520851194*^9, 3.840563684681675*^9, 3.840651345449269*^9, 
   3.840651956219513*^9, 3.8407376808219223`*^9, 3.844945287804796*^9, 
   3.8449657502313824`*^9, 3.8449661654360332`*^9, 3.8905259852810163`*^9, 
   3.8906737546791677`*^9, 3.8928387760857916`*^9, 3.898647226268465*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"daac0413-05b7-4303-8c7a-fa0453bc3815"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"Kd", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"]}], "+", 
        RowBox[{"A", " ", "Kdim"}], "+", 
        RowBox[{"Kd", " ", "Kdim"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["A", "2"], " ", "DTOT", " ", "Kdim"}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["A", "2"]}], "+", 
             RowBox[{"A", " ", "Kdim"}], "+", 
             RowBox[{"Kd", " ", "Kdim"}]}], ")"}], "2"]}]]}], ")"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["A", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, 
   3.8402068814933186`*^9, 3.840206934366068*^9, 3.84020926652293*^9, 
   3.840556303662549*^9, 3.8405565335592537`*^9, 3.8405621090056915`*^9, 
   3.840563520851194*^9, 3.840563684681675*^9, 3.840651345449269*^9, 
   3.840651956219513*^9, 3.8407376808219223`*^9, 3.844945287804796*^9, 
   3.8449657502313824`*^9, 3.8449661654360332`*^9, 3.8905259852810163`*^9, 
   3.8906737546791677`*^9, 3.8928387760857916`*^9, 3.898647226587637*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"77074133-4088-4aa9-9af5-e9ecb983ba36"]
}, Open  ]],

Cell["\<\
We estimate the total activity by counting all of the drug-free protomers \
which occur within a partly active or fully active dimer. Substituting the \
above solution into the expression for Raf activity and dividing by total RAF \
concentration, we obtain the proportionate activity as a function of total \
drug and other parameters.\
\>", "Text",
 CellChangeTimes->{{3.7692051569956264`*^9, 3.7692052249831033`*^9}, {
   3.7692053058924074`*^9, 3.7692053326957016`*^9}, {3.7692665900295753`*^9, 
   3.7692665948921833`*^9}, 3.7692684645670233`*^9, {3.7692686287467785`*^9, 
   3.7692686294649706`*^9}},ExpressionUUID->"46fc7494-f096-442f-b4f4-\
d6212fda1e73"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RafActivity", "[", "vars_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"vars", "[", 
     RowBox[{"[", "4", "]"}], "]"}]}], " ", "+", " ", 
   RowBox[{"vars", "[", 
    RowBox[{"[", "6", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fnActiveRAF", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RafActivity", "[", "vars", "]"}], "/", "RAF"}], "/.", 
      "rep3"}], "/.", "sol3A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repratios", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kdim", "\[Rule]", 
      FractionBox["RAF", 
       SubscriptBox["RAF", "rel"]]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"Kd", " ", 
       SubscriptBox["d", "rel"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAFCA", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"fnActiveRAF", "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAF2CA", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"fnActiveRAFCA", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "\[Rule]", "E1c"}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], "\[Rule]", 
        RowBox[{
         RowBox[{"E2c", " ", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", 
             SubscriptBox["d", "rel"]}], "+", 
            SuperscriptBox[
             SubscriptBox["d", "rel"], "2"]}], ")"}]}], "/", "8"}]}]}], 
      "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.769205220141611*^9, 3.769205289672014*^9}, {
   3.769205345593025*^9, 3.769205353284094*^9}, {3.7692054655437536`*^9, 
   3.7692054685969486`*^9}, {3.769265526917851*^9, 3.7692655613369493`*^9}, {
   3.7692655940807266`*^9, 3.7692657331243925`*^9}, {3.7692657719746237`*^9, 
   3.769265864876149*^9}, {3.7692658997040854`*^9, 3.7692659006156936`*^9}, {
   3.769266749046686*^9, 3.769266750912019*^9}, {3.769268445259807*^9, 
   3.76926844899031*^9}, {3.769268639956765*^9, 3.769268644269384*^9}, {
   3.769268830483199*^9, 3.7692688709844255`*^9}, {3.7692689173114767`*^9, 
   3.769269038442933*^9}, {3.769269089183334*^9, 3.769269285211043*^9}, {
   3.7692695137259455`*^9, 3.7692695528466825`*^9}, {3.769269651781829*^9, 
   3.76926965421002*^9}, {3.7694368136077976`*^9, 3.7694368142564898`*^9}, {
   3.7694375986201754`*^9, 3.7694376029376187`*^9}, {3.7694382649841013`*^9, 
   3.769438269629182*^9}, {3.769439034726965*^9, 3.7694390745272303`*^9}, {
   3.812214333570692*^9, 3.812214391783123*^9}, {3.8123859575711336`*^9, 
   3.812386008423128*^9}, {3.8123860614959884`*^9, 3.8123861254690137`*^9}, 
   3.831474994890194*^9, {3.8319208702531366`*^9, 3.831920870955785*^9}, {
   3.8319211759273367`*^9, 3.8319211759273367`*^9}, {3.8319237689036894`*^9, 
   3.8319237970863533`*^9}, {3.831923844715188*^9, 3.831923850773985*^9}, {
   3.831924074308251*^9, 3.8319240757594156`*^9}, {3.840203742192509*^9, 
   3.8402039027208576`*^9}, {3.840203969207242*^9, 3.8402039799679236`*^9}, {
   3.840204018691835*^9, 3.840204049292286*^9}, {3.840206889277243*^9, 
   3.84020689835734*^9}, {3.8402069454511704`*^9, 3.840206946891079*^9}, {
   3.8405561151920075`*^9, 3.8405561171437654`*^9}, 3.840556539740471*^9, {
   3.840562012259675*^9, 3.840562012364845*^9}, {3.8406513553618574`*^9, 
   3.8406513845743375`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"7b0dff14-b4c6-493f-a667-527995c2f6e8"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "KA", "+", 
     SubscriptBox["d", "rel"], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
  RowBox[{"8", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SubscriptBox["d", "rel"]}], ")"}], "3"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, 3.8402068999930506`*^9, {
   3.840206936719915*^9, 3.8402069480410695`*^9}, 3.840209269123561*^9, 
   3.840556304603263*^9, 3.840556542359208*^9, 3.840562018771406*^9, 
   3.840562109897445*^9, 3.8405635215998793`*^9, 3.8405636858001957`*^9, {
   3.8406513482061076`*^9, 3.840651384902851*^9}, 3.8406519570944843`*^9, 
   3.8407376818809805`*^9, 3.844945288824538*^9, 3.84496575135728*^9, 
   3.844966167728468*^9, 3.8905259866047974`*^9, 3.8906737605751443`*^9, 
   3.89283877864294*^9, 3.8986472282968597`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"a4ed6177-3bc6-4432-9b07-5d62ddee9a15"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"E1c", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["E1c", "2"], "+", "E2c"}]]}], ")"}], "2"], 
  RowBox[{"E2c", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["d", "rel"]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, 3.8402068999930506`*^9, {
   3.840206936719915*^9, 3.8402069480410695`*^9}, 3.840209269123561*^9, 
   3.840556304603263*^9, 3.840556542359208*^9, 3.840562018771406*^9, 
   3.840562109897445*^9, 3.8405635215998793`*^9, 3.8405636858001957`*^9, {
   3.8406513482061076`*^9, 3.840651384902851*^9}, 3.8406519570944843`*^9, 
   3.8407376818809805`*^9, 3.844945288824538*^9, 3.84496575135728*^9, 
   3.844966167728468*^9, 3.8905259866047974`*^9, 3.8906737605751443`*^9, 
   3.89283877864294*^9, 3.898647228365306*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"94158ba7-6724-45c7-b67e-70880af48d5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Test the hypothesis that the auto-inhibition model and dimer potentiation \
model can be inter-converted upon parametric transformation\
\>", "Subsubsubsection",
 CellChangeTimes->{{3.8906918957750163`*^9, 3.8906919312653823`*^9}, {
  3.890692932444708*^9, 
  3.8906929383076143`*^9}},ExpressionUUID->"dcd7c124-94cd-4797-b158-\
5b5e96269f53"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Kd", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "d"}], " ", "f", " ", "Kdim"}], "-", 
         RowBox[{"f", " ", "Kd", " ", "Kdim"}], "+", 
         SqrtBox[
          RowBox[{"f", " ", "Kdim", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", " ", 
              SuperscriptBox["Kd", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"Kdim", "+", 
                RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["d", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", " ", "Kdim"}], "+", 
                RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
             RowBox[{"2", " ", "d", " ", "Kd", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", " ", "Kdim"}], "+", 
                RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}]]}], ")"}]}], 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["d", "2"], "+", 
         RowBox[{"2", " ", "d", " ", "Kd"}], "+", 
         RowBox[{"f", " ", 
          SuperscriptBox["Kd", "2"]}]}], ")"}]}]], "==", 
     FractionBox[
      RowBox[{"Kd", " ", "Kdim", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", "Kd", "+", 
         RowBox[{"KA", " ", "Kd"}], "-", 
         SqrtBox[
          FractionBox[
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"d", "+", "Kd", "+", 
                RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], " ", "Kdim"}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"d", "+", "Kd"}], ")"}], "2"], " ", "RAF"}]}], 
           "Kdim"]]}], ")"}]}], 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"d", "+", "Kd"}], ")"}], "2"]}]]}], ",", "f"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.8906919319234056`*^9, {3.8906919684857893`*^9, 3.89069196917478*^9}, {
   3.890692373215317*^9, 3.8906924620479193`*^9}, {3.8906925255948772`*^9, 
   3.890692525828906*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"e4045351-3b81-4d66-926d-78b9646727bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"2", " ", "Kd"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["d", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"Kdim", "+", 
              RowBox[{"2", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{"d", " ", "Kd", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{"3", " ", "KA"}]}], ")"}], " ", "Kdim"}], "+", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", "d", " ", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{"Kdim", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["d", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"Kdim", "+", 
                    RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "d", " ", "Kd", " ", 
                  RowBox[{"(", 
                   RowBox[{"Kdim", "+", 
                    RowBox[{"KA", " ", "Kdim"}], "+", 
                    RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["Kd", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", "KA"}], ")"}], "2"], " ", "Kdim"}], "+", 
                    RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}], 
              ")"}]}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "+", "KA"}], ")"}], " ", "Kd", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}], " ", "Kd", " ", "Kdim"}], 
              "-", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{"Kdim", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["d", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"Kdim", "+", 
                    RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
                   RowBox[{"2", " ", "d", " ", "Kd", " ", 
                    RowBox[{"(", 
                    RowBox[{"Kdim", "+", 
                    RowBox[{"KA", " ", "Kdim"}], "+", 
                    RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["Kd", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", "KA"}], ")"}], "2"], " ", "Kdim"}], "+", 
                    RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], ")"}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", "d", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "KA"}], ")"}], " ", 
            SuperscriptBox["Kd", "3"], " ", "Kdim"}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"2", "+", "KA"}], ")"}], "2"], " ", 
            SuperscriptBox["Kd", "4"], " ", "Kdim"}], "+", 
           RowBox[{
            SuperscriptBox["d", "3"], " ", "Kd", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8", "+", "KA"}], ")"}], " ", "Kdim"}], "-", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["d", "2"], " ", 
            SuperscriptBox["Kd", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"14", "+", 
                 RowBox[{"3", " ", "KA"}]}], ")"}], " ", "Kdim"}], "-", 
              RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["d", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"Kdim", "-", "RAF"}], ")"}]}]}], ")"}]}], ")"}]}], 
      ")"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.8906924378094435`*^9, 3.8906924530102262`*^9}, 
   3.8906925286265945`*^9, 3.8928387812322464`*^9, 3.8986472302750025`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"5f54d472-0e64-4b79-9c78-e0af7dc8ba5a"]
}, Open  ]],

Cell["\<\
Note that the above equations represent the total active RAF protomers in \
proportion to the total RAF kinase as a function of unbound drug (d). In \
order to analytically establish parameter values which correspond to \
activation of the kinase, we find the first derivative of this function \
(equation 11) and search for it\[CloseCurlyQuote]s zeroes (equation 12).\
\>", "Text",
 CellChangeTimes->{{3.8314750261787057`*^9, 3.831475036190924*^9}, {
  3.8324318762945156`*^9, 
  3.832431882900982*^9}},ExpressionUUID->"1a3bd1e1-5675-4826-b078-\
7b329977f1fc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RafDimers", "[", "eqns_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"eqns", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnDimersCA", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RafDimers", "[", "vars", "]"}], "/", "RAF"}], "/.", 
        "rep3"}], "/.", "sol3A"}], ")"}], "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"fnDimersCA", "/", "fnActiveRAFCA"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8319238615172873`*^9, 3.83192390513754*^9}, {
   3.831923943703373*^9, 3.8319239810051637`*^9}, {3.83192408057911*^9, 
   3.8319240873711205`*^9}, 3.84020440505526*^9, {3.840204452736744*^9, 
   3.840204473036141*^9}, {3.8402069055106783`*^9, 3.840206909710287*^9}, {
   3.8402069557624893`*^9, 3.8402069894247684`*^9}, {3.8405565446444273`*^9, 
   3.8405565778563232`*^9}, {3.8406514240660276`*^9, 3.8406514265590057`*^9}, 
   3.844966174162793*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"8e04afcc-0aa2-4c47-8141-84916abe08a2"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "KA", "+", 
     SubscriptBox["d", "rel"], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
  RowBox[{"16", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840206911152722*^9, {3.8402069566017013`*^9, 3.8402069897763844`*^9}, 
   3.8402092697445755`*^9, 3.8405563070812798`*^9, {3.840556547751231*^9, 
   3.8405565790606165`*^9}, 3.840562110291912*^9, 3.84056352198501*^9, 
   3.840563686346242*^9, 3.8406514274950294`*^9, 3.8406519574787607`*^9, 
   3.840737682350976*^9, 3.8449452892413235`*^9, 3.8449657519033165`*^9, 
   3.8449661770089264`*^9, 3.890525987167168*^9, 3.890673763063013*^9, 
   3.892838782064672*^9, 3.898647231062358*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"d009250f-305b-44c0-be37-280ae8d640de"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SubscriptBox["d", "rel"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840206911152722*^9, {3.8402069566017013`*^9, 3.8402069897763844`*^9}, 
   3.8402092697445755`*^9, 3.8405563070812798`*^9, {3.840556547751231*^9, 
   3.8405565790606165`*^9}, 3.840562110291912*^9, 3.84056352198501*^9, 
   3.840563686346242*^9, 3.8406514274950294`*^9, 3.8406519574787607`*^9, 
   3.840737682350976*^9, 3.8449452892413235`*^9, 3.8449657519033165`*^9, 
   3.8449661770089264`*^9, 3.890525987167168*^9, 3.890673763063013*^9, 
   3.892838782064672*^9, 3.898647231062358*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"b0ea706c-591a-4101-bd9b-e20b9c58b5a9"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.2. Baseline Signaling (drug-free)", "Subsubsection",
 CellChangeTimes->{{3.812385908612563*^9, 3.812385920080598*^9}, {
  3.833159643863964*^9, 3.8331596657361794`*^9}, {3.8407375864399567`*^9, 
  3.8407375986515427`*^9}, {3.8449390997200384`*^9, 
  3.844939099888921*^9}},ExpressionUUID->"a8b7c0a0-3d32-4d90-a231-\
3e15a5e2d7b0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"baselineActiveRAFCA", "=", 
   RowBox[{"fnActiveRAFCA", "/.", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", "0"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep3b", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["RAF", "rel"], "\[Rule]", 
     RowBox[{"E3", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA"}], ")"}], "2"], "/", "8"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"baselineActiveRAF1", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"baselineActiveRAFCA", "/.", "rep3b"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"baselineActiveRAF1", ",", "E3"}], "]"}], "/.", "rep3b"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8123859215610027`*^9, 3.812385936919848*^9}, {
   3.8123861495330424`*^9, 3.812386224346416*^9}, {3.812386278673541*^9, 
   3.812386294471064*^9}, {3.8123863259077187`*^9, 3.8123863683020535`*^9}, {
   3.8123864109056587`*^9, 3.8123864240308285`*^9}, {3.8319211091015835`*^9, 
   3.8319211176118765`*^9}, 3.8319211759429626`*^9, {3.8402045142905054`*^9, 
   3.8402045162565413`*^9}, {3.8402070042137656`*^9, 3.840207004445817*^9}, {
   3.84065145613931*^9, 3.8406515077995834`*^9}, {3.840651627453356*^9, 
   3.8406516297405624`*^9}, 3.852301009888685*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"1cba30c8-a29f-4f85-9c9e-3a8c883a4e8d"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", "E3"}]]}], ")"}], "2"], "E3"]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, 3.840207005170474*^9, {3.8406514894872036`*^9, 
   3.840651508127841*^9}, 3.8406516320462*^9, 3.8406519606447515`*^9, 
   3.8905259872559357`*^9, 3.890673777014206*^9, 3.892838782221385*^9, 
   3.898647231314247*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"069f02fd-8f3d-461e-bca1-cab47b6b0b57"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", "E3"}]]}], ")"}], "2"], 
  RowBox[{
   SuperscriptBox["E3", "2"], " ", 
   SqrtBox[
    RowBox[{"1", "+", "E3"}]]}]]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, 3.840207005170474*^9, {3.8406514894872036`*^9, 
   3.840651508127841*^9}, 3.8406516320462*^9, 3.8406519606447515`*^9, 
   3.8905259872559357`*^9, 3.890673777014206*^9, 3.892838782221385*^9, 
   3.898647231329917*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"0231bd9b-e107-47d0-8099-7ae772c76193"]
}, Open  ]],

Cell["\<\
The derivative of baseline signaling relative to E3 is a positive definite \
function. Therefore, baseline signaling is a monotonically proportionate to \
E3, which is in turn, monotonically proportionate to RAF concentration and \
monotonically inverse relationship to KA.\
\>", "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
  3.812386377540579*^9, 
  3.8123864833252983`*^9}},ExpressionUUID->"96d7147e-955d-4411-b01e-\
11fd3a688747"],

Cell[TextData[{
 "Hence in the base model, increasing KA decreases baseline signaling and \
increasing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["RAF", "rel"], " "}], TraditionalForm]],ExpressionUUID->
  "3a333ae2-4286-4a66-8e1f-9dbb7a3ef7c0"],
 " increases baseline signaling."
}], "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
   3.812386377540579*^9, 3.812386508943284*^9}, 
   3.831493576900573*^9},ExpressionUUID->"9436439d-2246-4463-9cba-\
24cf225804d1"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.3.3. Conditions on parameter regions for activation in response to the drug\
\>", "Subsubsection",
 CellChangeTimes->{{3.769352693017748*^9, 3.7693527442245555`*^9}, 
   3.8319232589041615`*^9, {3.833159646729958*^9, 3.833159664629573*^9}, {
   3.8407375875198774`*^9, 3.840737599612014*^9}, {3.844939106120983*^9, 
   3.8449391071927214`*^9}},ExpressionUUID->"1d33ca09-a76a-4a40-bfde-\
a60b6acbb261"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dfn3", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"fnActiveRAFCA", ",", 
     SubscriptBox["d", "rel"]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.755541810342499*^9, 3.7555418608619113`*^9}, {
   3.755541978622472*^9, 3.7555419807907124`*^9}, {3.7555571218326187`*^9, 
   3.7555571219456987`*^9}, {3.7556152697929463`*^9, 3.755615271368307*^9}, {
   3.755615528332312*^9, 3.7556155322520323`*^9}, {3.755615647889366*^9, 
   3.755615736790206*^9}, {3.7556192151498156`*^9, 3.7556192592915344`*^9}, {
   3.755619311851678*^9, 3.75561931599358*^9}, {3.7556396242742844`*^9, 
   3.755639637221635*^9}, {3.7590911604934464`*^9, 3.759091242876088*^9}, {
   3.759091274647378*^9, 3.759091275112709*^9}, 3.7646075097588253`*^9, {
   3.7692693888047943`*^9, 3.769269390671215*^9}, {3.7692695640617847`*^9, 
   3.7692696334602895`*^9}, {3.7692696651592636`*^9, 3.7692696859256325`*^9}, 
   3.769436826714548*^9, {3.8129938947361474`*^9, 3.8129939100528193`*^9}, 
   3.831920887884055*^9, 3.8319211759429626`*^9, 3.8402045504842486`*^9, {
   3.8406519730045977`*^9, 3.840651976488284*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"654db261-2074-4acb-8797-0434f967aa1d"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["d", "rel"]}], ")"}], "4"], " ", 
    SubscriptBox["RAF", "rel"]}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "KA", "+", 
     SubscriptBox["d", "rel"], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"], "+", 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SubscriptBox["d", "rel"]}], ")"}], " ", 
           SubscriptBox["RAF", "rel"]}]}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
            SubscriptBox["RAF", "rel"]}]}]]]}], ")"}]}], "-", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "KA", "+", 
        SubscriptBox["d", "rel"], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
           SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.8402045507751465`*^9, 3.8402070121984787`*^9, {3.8406519699372034`*^9, 
   3.8406519771608896`*^9}, 3.890525987682059*^9, 3.890673783829625*^9, 
   3.8928387831159*^9, 3.8986472321817713`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"d4cbbe74-b45f-4355-b442-1003ec843d1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"dfn3", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "\[Rule]", "E1"}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], "\[Rule]", 
        RowBox[{
         RowBox[{"E2", " ", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SuperscriptBox[
             SubscriptBox["d", "rel"], "2"]}], ")"}]}], "/", "8"}]}]}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"E1", ">", "0"}], ",", 
     RowBox[{"E2", ">", "0"}], ",", 
     RowBox[{
      SubscriptBox["d", "rel"], ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.83148934340346*^9, 3.8314893619530306`*^9}, {
  3.8314894038589935`*^9, 3.831489440238714*^9}, {3.8319208905440626`*^9, 
  3.8319209074350414`*^9}, {3.840204568899231*^9, 3.8402045910230446`*^9}, {
  3.8402070180152884`*^9, 3.840207022346157*^9}, {3.8406519799975896`*^9, 
  3.8406519904900713`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"37d92b4f-ee9d-42f6-9af2-c3cee7cdc1e8"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "E1"}], "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["E1", "2"], "+", "E2"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["E1", "2"]}], "+", "E2", "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["E1", "2"], "+", "E2"}]]}], "-", 
      RowBox[{"E1", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["E1", "2"], "+", "E2"}]]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "E1"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["E1", "2"], "+", "E2"}]]}], ")"}], " ", 
       SubscriptBox["d", "rel"]}]}], ")"}]}], 
   RowBox[{"E2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["E1", "2"], "+", "E2"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["d", "rel"]}], ")"}], "2"]}]]}]], "Output",
 CellChangeTimes->{{3.8314893496277685`*^9, 3.83148938220708*^9}, {
   3.8314894229355*^9, 3.8314894464476614`*^9}, 3.831929908465158*^9, 
   3.8320847422034435`*^9, 3.8324315185775566`*^9, {3.8402045716339617`*^9, 
   3.840204591624158*^9}, 3.84020702459922*^9, {3.8406519811009045`*^9, 
   3.840651991225115*^9}, 3.8905259881919746`*^9, 3.890673785487791*^9, 
   3.8928387833979597`*^9, 3.898647232466634*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"ab39ce02-cc52-46c3-b9a1-3ca557b21dc5"]
}, Open  ]],

Cell["\<\
The first two roots are complex coming from the first bracket term.\
\>", "Text",
 CellChangeTimes->{{3.755616011649972*^9, 3.755616017298216*^9}, {
   3.7556162954979105`*^9, 3.755616319122348*^9}, 3.7645970962275047`*^9, {
   3.764618521544237*^9, 
   3.7646185260131917`*^9}},ExpressionUUID->"74d83c06-8c17-4867-89ae-\
0e099d1cd289"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zeroes", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"dfn3", "\[Equal]", "0"}], ",", 
     SubscriptBox["d", "rel"], ",", 
     RowBox[{"VerifySolutions", "\[Rule]", "True"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.755541989072197*^9, 3.7555420037094855`*^9}, {
   3.7555448520523195`*^9, 3.7555448726056957`*^9}, {3.755544917757202*^9, 
   3.755544930580393*^9}, {3.755544971180496*^9, 3.7555449951722126`*^9}, {
   3.7556152155154743`*^9, 3.7556152173406396`*^9}, {3.7556155593795424`*^9, 
   3.75561558823169*^9}, {3.7556158119219775`*^9, 3.7556158357473307`*^9}, {
   3.7556159869586897`*^9, 3.7556159923967276`*^9}, 3.7590911798731813`*^9, {
   3.7590912606104107`*^9, 3.759091312740535*^9}, 3.7646075098213253`*^9, {
   3.7692697119381285`*^9, 3.7692697289151955`*^9}, 3.76943683146959*^9, 
   3.81299392247276*^9, 3.8319209118697786`*^9, 3.840204613872306*^9, {
   3.840651998733414*^9, 3.8406520000209627`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"9f410a57-87f3-48bc-ab75-6ce77bfa833b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "KA", "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}], "+", 
        RowBox[{"2", " ", "KA", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}]}], 
       RowBox[{"1", "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "KA", "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}], "-", 
        RowBox[{"2", " ", "KA", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}]}], 
       RowBox[{"1", "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.840204636395675*^9, 3.8402070277316294`*^9, 
  3.8406520006358757`*^9, 3.890525988463519*^9, 3.890673787068388*^9, 
  3.8928387836960387`*^9, 3.898647232891361*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"a68b3043-a74d-481e-9ece-e2a3f446eec5"]
}, Open  ]],

Cell["\<\
The first solution is negative definite. Below, we derive the rules \
(expression 13) which allow the second solution to be positive\
\>", "Text",
 CellChangeTimes->{{3.759091361547437*^9, 3.7590913680495505`*^9}, {
  3.769269749681785*^9, 
  3.7692698135732317`*^9}},ExpressionUUID->"961a221b-155c-4d78-b1bb-\
2cdbb8d67e73"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exist", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["d", "rel"], "/.", 
        RowBox[{"zeroes", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}], ">", "0"}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{"KA", ">", "0"}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["RAF", "rel"], ">", "0"}], ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.759091395330793*^9, 3.7590914705945797`*^9}, {
   3.759092635935361*^9, 3.759092638528202*^9}, 3.7646075098525753`*^9, {
   3.769269834345808*^9, 3.769269849315876*^9}, 3.7694368345423703`*^9, 
   3.812993929793637*^9, 3.8319209167016697`*^9, 3.840207030187523*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"9a8212ea-7073-4aa9-b673-81e9e75f5203"],

Cell[BoxData[
 RowBox[{
  RowBox[{"KA", ">", "1"}], "&&", 
  RowBox[{"0", "<", 
   SubscriptBox["RAF", "rel"], "<", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"2", " ", "KA"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["KA", "2"]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.8402070305727043`*^9, 3.8406520081534395`*^9, 
  3.8905259885855293`*^9, 3.8906737946846666`*^9, 3.8928387838693204`*^9, 
  3.898647233064745*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"35a4d9b8-2794-4516-834c-92747988d271"]
}, Open  ]],

Cell["\<\
Hence with a sufficiently small ratio of raf concentration to dimerization \
constant ratio, the auto-inhibition mechanism can by itself mediate \
activation of the kinase in response to drug administration.\
\>", "Text",
 CellChangeTimes->{{3.769269873357497*^9, 
  3.7692699566944485`*^9}},ExpressionUUID->"e1f08b8b-7c61-4f2c-93f7-\
a0ff89d534b3"],

Cell["\<\
In section 1.2 we will show that our analytic results as a function of \
unbound drug concentration also extend to the complete case where we consider \
the relationship between unbound and bound drug.\
\>", "Text",
 CellChangeTimes->{{3.769269873357497*^9, 3.7692700228399725`*^9}, {
   3.769270086192499*^9, 3.769270090607915*^9}, {3.7693527607614584`*^9, 
   3.769352761620617*^9}, 3.8123825881303115`*^9, {3.812993951958707*^9, 
   3.812993981749937*^9}},ExpressionUUID->"bc119c3f-e36a-45e3-b81c-\
71a7e8a95fd1"],

Cell["\<\
To establish that the above constraints imply existence of activation \
(maxima), we derive the second derivative of fnActiveRAFCA, find it\
\[CloseCurlyQuote]s value at the critical point in variable \
\[OpenCurlyQuote]zeroes\[CloseCurlyQuote]. We then find the conditions under \
which this function is negative.\
\>", "Text",
 CellChangeTimes->{{3.7692703124754715`*^9, 3.7692704622175894`*^9}, {
  3.890673835027152*^9, 
  3.8906738829611444`*^9}},ExpressionUUID->"bfdecca9-5475-4a2d-9945-\
c4b147735601"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2fn3", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"dfn3", ",", 
     SubscriptBox["d", "rel"]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.7650568486607113`*^9, {3.7692702065179834`*^9, 3.769270223610836*^9}, 
   3.7694368388201976`*^9, 3.8129939841166162`*^9, 3.831920926762268*^9, 
   3.840207036172144*^9, {3.84065216861963*^9, 3.8406521716592636`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"9a58a91a-25bf-4029-bf93-cb24088b4d79"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["d", "rel"]}], ")"}], "5"], " ", 
    SubscriptBox["RAF", "rel"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["d", "rel"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "KA", "+", 
       SubscriptBox["d", "rel"], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "KA", "+", 
            SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
          SubscriptBox["RAF", "rel"]}]}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       FractionBox[
        RowBox[{"16", " ", 
         SuperscriptBox["KA", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         SubscriptBox["RAF", "rel"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
            SubscriptBox["RAF", "rel"]}]}], ")"}], 
         RowBox[{"3", "/", "2"}]]], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"], "+", 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SubscriptBox["d", "rel"]}], ")"}], " ", 
            SubscriptBox["RAF", "rel"]}]}], ")"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
           SubscriptBox["RAF", "rel"]}]}]]], "+", 
       FractionBox[
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           RowBox[{"8", " ", 
            SubscriptBox["RAF", "rel"]}], "+", 
           RowBox[{
            SubscriptBox["d", "rel"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"8", " ", 
               SubscriptBox["RAF", "rel"]}]}], ")"}]}]}], ")"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
           SubscriptBox["RAF", "rel"]}]}]]]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["d", "rel"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"1", "+", "KA", "+", 
         SubscriptBox["d", "rel"], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SubscriptBox["d", "rel"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
           SubscriptBox["RAF", "rel"]}]}]]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SubscriptBox["d", "rel"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"1", "+", "KA", "+", 
            SubscriptBox["d", "rel"], "+", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SubscriptBox["d", "rel"]}], ")"}], " ", 
             SubscriptBox["RAF", "rel"]}]}], 
           SqrtBox[
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
              SubscriptBox["RAF", "rel"]}]}]]]}], ")"}]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"], "-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", "KA", "+", 
               SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
             SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "KA", "+", 
       SubscriptBox["d", "rel"], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "KA", "+", 
            SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
          SubscriptBox["RAF", "rel"]}]}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SubscriptBox["d", "rel"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"1", "+", "KA", "+", 
            SubscriptBox["d", "rel"], "+", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SubscriptBox["d", "rel"]}], ")"}], " ", 
             SubscriptBox["RAF", "rel"]}]}], 
           SqrtBox[
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
              SubscriptBox["RAF", "rel"]}]}]]]}], ")"}]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"], "-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", "KA", "+", 
               SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
             SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.8402070371214743`*^9, {3.840652166460883*^9, 3.840652174382373*^9}, 
   3.890525989592744*^9, 3.890673891158629*^9, 3.8928387857051973`*^9, 
   3.8986472345469437`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"ca997acd-168f-4933-8743-2cf150a8481e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2fn3z", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"d2fn3", "/.", 
     RowBox[{"zeroes", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"KA", ">", "0"}], ",", 
      RowBox[{
       SubscriptBox["RAF", "rel"], ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.765056877442114*^9, 3.765056880938139*^9}, 
   3.7650569941039143`*^9, {3.767564894649585*^9, 3.7675648954451675`*^9}, {
   3.7692702305775337`*^9, 3.7692702775194626`*^9}, 3.769436842310711*^9, 
   3.8129940042467594`*^9, 3.8319209285682616`*^9, 3.8402070405458183`*^9, {
   3.840652177558148*^9, 3.840652180441888*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"87ccd942-2004-487a-bf14-ce4747353e16"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"162", " ", 
    SuperscriptBox["KA", "3"], " ", 
    SubscriptBox["RAF", "rel"]}]], 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"6", " ", 
       SubscriptBox["RAF", "rel"]}]}]], "+", 
    RowBox[{"3", " ", 
     SubscriptBox["RAF", "rel"], " ", 
     RowBox[{"(", 
      RowBox[{"6", "-", 
       RowBox[{"5", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"6", " ", 
           SubscriptBox["RAF", "rel"]}]}]]}], "-", 
       RowBox[{"24", " ", 
        SubscriptBox["RAF", "rel"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox[
           RowBox[{"1", "+", 
            RowBox[{"6", " ", 
             SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.8402070410688686`*^9, 3.8406521836675653`*^9, 
  3.8905259901249523`*^9, 3.8906738937708015`*^9, 3.892838786615347*^9, 
  3.898647235520094*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"b09385b5-2465-4c66-b8d5-d927435040f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Numerator", "[", "d2fn3z", "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["RAF", "rel"], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", "1"}], ")"}], "/", "6"}]}], "}"}]}], 
    ",", 
    RowBox[{"a", ">", "0"}]}], "]"}], "/.", 
  RowBox[{"a", "->", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"6", " ", 
      SubscriptBox["RAF", "rel"]}]}]]}]}]], "Input",
 CellChangeTimes->{{3.898647245690042*^9, 3.8986472970747967`*^9}, {
  3.8986474745250072`*^9, 3.898647645592281*^9}, {3.8986477522003*^9, 
  3.8986477531940584`*^9}},ExpressionUUID->"f14aaa02-a21c-4c35-99e1-\
9581da58c95e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  SqrtBox[
   RowBox[{"1", "+", 
    RowBox[{"6", " ", 
     SubscriptBox["RAF", "rel"]}]}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"6", " ", 
        SubscriptBox["RAF", "rel"]}]}]], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"6", " ", 
         SubscriptBox["RAF", "rel"]}]}], ")"}]}]}], ")"}], "2"]}]], "Output",
 CellChangeTimes->{{3.898647627725089*^9, 3.898647646020259*^9}},
 CellLabel->"Out[38]=",ExpressionUUID->"1c2ef5cf-d0fc-4608-ac18-3932cd03d6bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d2fn3z", "<", "0"}], ")"}], "&&", 
   RowBox[{"(", 
    RowBox[{"KA", ">=", "0"}], ")"}], "&&", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["RAF", "rel"], ">=", "0"}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.765056913853697*^9, 3.7650569628895283`*^9}, 
   3.7650571358338194`*^9, {3.7692702714368963`*^9, 3.76927027238888*^9}, 
   3.769355075736458*^9, 3.769436845114371*^9, 3.8129940113765926`*^9, 
   3.8319209434656467`*^9, 3.8402070440950255`*^9, {3.840652186994707*^9, 
   3.840652187276284*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"cfa66477-7416-4d66-b5c9-c832e99ca06e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"KA", ">", "0"}], "&&", 
  RowBox[{
   SubscriptBox["RAF", "rel"], ">", "0"}]}]], "Output",
 CellChangeTimes->{3.8402070443788004`*^9, 3.840652188458864*^9, 
  3.8905259902060966`*^9, 3.8906738950073075`*^9, 3.8928387867250595`*^9, 
  3.898647235660911*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"c15d864b-517b-43bd-a1d9-b5f922672f8e"]
}, Open  ]],

Cell["\<\
No additional constraints from second derivative condition that the critical \
point be a maxima. The \[OpenCurlyQuote]exist\[CloseCurlyQuote] condition \
above is necessary and sufficient as long as monotonocity between unbound and \
total drug can be established. \
\>", "Text",
 CellChangeTimes->{{3.8129940518801394`*^9, 3.8129940666030893`*^9}, {
  3.8906739002044735`*^9, 
  3.890673940462715*^9}},ExpressionUUID->"1e3c3ca2-b864-42d5-974e-\
cb19b8d75379"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.3.4. Monotonic relationship between unbound (d) and total (DTOT) drug \
concentrations\
\>", "Subsubsection",
 CellChangeTimes->{{3.7692694343293085`*^9, 3.76926946891394*^9}, 
   3.7692701230017385`*^9, {3.769436773797412*^9, 3.7694367744539824`*^9}, 
   3.8319232632660522`*^9, {3.833159649860316*^9, 3.8331596633192616`*^9}, {
   3.840737588463739*^9, 3.840737600460015*^9}, {3.844939108266823*^9, 
   3.844939108351198*^9}},ExpressionUUID->"fe2a04ae-5791-47ef-a84a-\
c516c6441850"],

Cell["\<\
The derivative of the function DTOT relative to unbound drug d is the sum of \
the derivative of different composing terms. Among these the derivative of \
the first term is 1. And the derivative of the second and third term are \
shown as non-negative functions of unbound drug d, below.\
\>", "Text",
 CellChangeTimes->{{3.8320850810009933`*^9, 3.8320851682942505`*^9}, {
  3.890673986553563*^9, 
  3.890674011705832*^9}},ExpressionUUID->"7f4166d4-b0e7-497e-a19b-\
0dfe99db5ef3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd311", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"A", "*", "d"}], "/.", "sol3A"}], ",", "d"}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd311", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd311", "<", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", "rd311", "]"}]}], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.812209716555067*^9}, 3.840204651633864*^9, {3.8402070598013134`*^9, 
   3.8402070600121202`*^9}, {3.8406522082337675`*^9, 3.8406522331459618`*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"b5007838-fb74-41e1-9f87-6eb59928947d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "d"}], "\[LessEqual]", "Kd"}], "||", 
    RowBox[{"d", "<", "Kd"}]}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"d", "<", "Kd", "<", 
     RowBox[{"3", " ", "d"}]}], "||", 
    RowBox[{"KA", "<", 
     FractionBox[
      RowBox[{"d", "+", "Kd"}], 
      RowBox[{"d", "-", "Kd"}]]}], "||", 
    RowBox[{"Kd", ">", 
     RowBox[{"3", " ", "d"}]}]}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "+", "Kd"}], 
      RowBox[{"d", "-", "Kd"}]], "<", "KA", "<", 
     FractionBox["Kd", 
      RowBox[{"d", "-", "Kd"}]]}], "||", 
    RowBox[{"KA", "<", 
     FractionBox[
      RowBox[{"d", "+", "Kd"}], 
      RowBox[{"d", "-", "Kd"}]]}]}], ")"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{"Kdim", "-", 
       RowBox[{
        SuperscriptBox["KA", "2"], " ", "Kdim"}], "+", 
       RowBox[{"8", " ", "RAF"}]}], ")"}]}], "+", 
    RowBox[{"Kd", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], " ", "Kdim"}], "+", 
       RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], "<", "0"}]}]], "Output",
 CellChangeTimes->{
  3.840204662010409*^9, {3.8402070557236414`*^9, 3.840207068372545*^9}, {
   3.8406522242662573`*^9, 3.84065224867375*^9}, 3.8905260403076105`*^9, 
   3.8906739782351513`*^9, 3.8906740540067835`*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"25e1d2a2-36ee-4672-98aa-5e9b691d7ff4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sd312", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["A", "2"], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", "Kd"}], ")"}]}], "/.", "sol3A"}], "]"}], ",", 
     "d"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.8122097406433277`*^9}, {3.812209825300347*^9, 3.8122098312563896`*^9}, {
   3.812209894920068*^9, 3.812209908923931*^9}, {3.812210163614968*^9, 
   3.8122102029627514`*^9}, 3.8129943016148033`*^9, {3.832085249170616*^9, 
   3.832085251410651*^9}, {3.8320853702376328`*^9, 3.8320853722836037`*^9}, {
   3.832085440475006*^9, 3.8320854515514917`*^9}, {3.8402070658014565`*^9, 
   3.840207066180502*^9}, 3.840652218386231*^9},
 CellLabel->
  "In[125]:=",ExpressionUUID->"edae4c81-98fb-4170-8baf-a6c26157f69e"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", "Kd"}], ")"}], "4"]}]], 
  RowBox[{
   SuperscriptBox["Kd", "2"], " ", 
   SuperscriptBox["Kdim", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", "Kd", "+", 
     RowBox[{"KA", " ", "Kd"}], "-", 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", "Kd", "+", 
            RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], " ", "Kdim"}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", "Kd"}], ")"}], "2"], " ", "RAF"}]}], "Kdim"]]}], 
    ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", "Kd", "+", 
               RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], " ", "Kdim"}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", "Kd"}], ")"}], "2"], " ", "RAF"}]}], 
          "Kdim"]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", "Kd", "+", 
               RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], " ", "Kdim"}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", "Kd"}], ")"}], "2"], " ", "RAF"}]}], 
          "Kdim"]]}], ")"}]}], "+", 
     RowBox[{"2", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "d"}], " ", 
           RowBox[{"(", 
            RowBox[{"Kdim", "+", 
             RowBox[{"8", " ", "RAF"}]}], ")"}]}], "-", 
          RowBox[{"Kd", " ", 
           RowBox[{"(", 
            RowBox[{"Kdim", "+", 
             RowBox[{"KA", " ", "Kdim"}], "+", 
             RowBox[{"8", " ", "RAF"}]}], ")"}]}]}], 
         SqrtBox[
          RowBox[{"Kdim", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", "Kd", "+", 
                 RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], " ", "Kdim"}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", "Kd"}], ")"}], "2"], " ", "RAF"}]}], 
            ")"}]}]]]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.840652249702524*^9, 3.890526041928919*^9, 
  3.8906739795014915`*^9, 3.8906740551786504`*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"7f3d682c-a825-4929-8acb-be245efea358"]
}, Open  ]],

Cell["\<\
Note that the first non-trivial product term in this expression is negative \
definite as the term inside the square root is always greater than the term \
outside. So we focus on the second term.\
\>", "Text",
 CellChangeTimes->{{3.832085456271301*^9, 
  3.8320855058848753`*^9}},ExpressionUUID->"173c5d03-7769-47de-bc8e-\
c7b642ddbad2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd3121", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"sd312", "[", 
     RowBox[{"[", 
      RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd312", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd3121", ">", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"SimplifyPars", "[", "rd312", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8320855104825225`*^9, 3.832085576939461*^9}, 
   3.8320856157697144`*^9, {3.832085673481617*^9, 3.832085684156937*^9}, {
   3.8406522428947597`*^9, 3.8406522819147463`*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"4691977a-e34b-445b-9d91-6cb242f81779"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Kd", ">", 
   RowBox[{"2", " ", "d"}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "+", "Kd"}], 
      RowBox[{
       RowBox[{"2", " ", "d"}], "-", "Kd"}]], "<", "KA", "<", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Kd", " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", "Kd"}], ")"}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["d", "2"]}], "+", 
        SuperscriptBox["Kd", "2"]}]]}]}], "||", 
    RowBox[{"KA", "<", 
     FractionBox[
      RowBox[{"d", "+", "Kd"}], 
      RowBox[{
       RowBox[{"2", " ", "d"}], "-", "Kd"}]]}]}], ")"}], "&&", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["d", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["KA", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], " ", "Kd"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "KA"}], ")"}], "2"], " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "Kdim"}], 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"d", "+", "Kd"}], ")"}], "2"]}]], "+", "RAF"}], "<", 
   "0"}]}]], "Output",
 CellChangeTimes->{{3.840652287718157*^9, 3.8406523010722694`*^9}, 
   3.8905260831341724`*^9, 3.8906740025551195`*^9, 3.890674077434698*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"8c594ec1-e0f7-4a41-a57b-0450551943bc"]
}, Open  ]],

Cell["\<\
The first two conditions imply:  d<Kd/2 combined with KA<~1/(2d-Kd) which \
gives KA<0. As KA is positive definite, the expression sd3121 is non \
positive. Also, the coefficient to sd3121 in sd312 is negative definite as \
stated above. Therefore the full expression sd12 is non negative for all \
positive values of the parameters.\
\>", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211189353238*^9}, {3.832085645561462*^9, 3.8320857371734977`*^9}, {
  3.840652313960535*^9, 3.8406523299325*^9}, {3.8906741288528185`*^9, 
  3.890674171060829*^9}},ExpressionUUID->"a0b156c3-68fd-4c4a-9f43-\
fe754bb22afc"],

Cell["DTOT=d+sd11+sd12", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211207502667*^9}},ExpressionUUID->"97538cf5-cd1e-4a81-b975-\
5663f45f61ca"],

Cell["\<\
Since all three expressions on RHS are non-negative derivatives as a function \
of unbound drug - the total drug has a non-negative derivative. Therefore, \
DTOT(d) is monotonically positive/increasing function.\[LineSeparator]We show \
this point with an example set of parameters in the plot below.\
\>", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.8122112898940353`*^9}, {3.832085750901709*^9, 
  3.8320858105658555`*^9}},ExpressionUUID->"d2a25e4c-e5a6-4e03-96f3-\
c9a8b3d2af10"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fnDTOT", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Consrv", "[", "vars", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/.", "rep3"}], "/.", "sol3A"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7585572574558153`*^9, 3.7585573278649125`*^9}, {
   3.759595163226753*^9, 3.7595951983626966`*^9}, {3.759600640284622*^9, 
   3.7596006451030445`*^9}, 3.7646075104463263`*^9, {3.7646202269105544`*^9, 
   3.764620227426238*^9}, {3.7692714662387505`*^9, 3.7692714835925064`*^9}, {
   3.76927153667768*^9, 3.769271545331811*^9}, 3.769436866848941*^9, {
   3.8402070839625173`*^9, 3.8402070841989784`*^9}, 3.840652337796776*^9},
 CellLabel->
  "In[129]:=",ExpressionUUID->"5f1ee64e-3847-4d35-9c17-7c1e8dc7d360"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Sty", "[", "x_", "]"}], ":=", 
   RowBox[{"Style", "[", 
    RowBox[{"x", ",", "20", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"parset01", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"KA", "\[Rule]", "2."}], ",", 
     RowBox[{"Kdim", "\[Rule]", " ", 
      RowBox[{"1.", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], " ", 
     RowBox[{"(*", 
      RowBox[{"100", "nM"}], "*)"}], ",", 
     RowBox[{"f", "\[Rule]", "0.01"}], ",", 
     RowBox[{"g", "\[Rule]", "4"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KTarr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}], ",", 
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], ",", 
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kdarr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kd", "\[Rule]", " ", 
      RowBox[{"1.", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], " ", ",", 
     RowBox[{"Kd", "\[Rule]", " ", 
      RowBox[{"1.", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pltfn", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"fnDTOT", "/.", "parset01"}], "/.", "kd"}], ",", 
      RowBox[{"{", 
       RowBox[{"kd", ",", "kdarr"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"RAF", ",", "KTarr"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ps", "=", 
   RowBox[{"{", 
    RowBox[{"Blue", ",", "Green", ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Thick"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Blue", ",", "Dashed"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Green", ",", "Dashed"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Dashed", ",", "Thick"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LogLogPlot", "[", 
  RowBox[{"pltfn", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "9"}]], ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "5"}]]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "20"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "ps"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Green", ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"Sty", "/@", "KTarr"}], ",", 
        RowBox[{"LegendLabel", "\[Rule]", 
         RowBox[{"Sty", "[", "\"\<RAF(M)\>\"", "]"}]}], ",", 
        RowBox[{"LegendFunction", "\[Rule]", "Panel"}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", "12"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"Sty", "/@", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Unbound Drug [d] (M)\>\"", ",", "\"\<Total Drug [DTOT] (M)\>\""}],
        "}"}]}], ")"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", "500", "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "0.004", "]"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{
    "Sty", "[", 
     "\"\<\!\(\*SubscriptBox[\(K\), \(d\)]\): \[LongDash]100nM  - -1nM \
\!\(\*SubscriptBox[\(K\), \(A\)]\):2\>\"", "]"}]}]}], 
  RowBox[{"(*", 
   RowBox[{"N", "[", 
    RowBox[{"TableForm", "[", 
     RowBox[{"parset01", ",", 
      RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}], "]"}], "*)"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.7585573502790737`*^9, {3.758557416662918*^9, 3.758557417800726*^9}, {
   3.7585574593029137`*^9, 3.75855752487545*^9}, {3.75855757528645*^9, 
   3.758557667757551*^9}, {3.758563426348437*^9, 3.7585634495480337`*^9}, 
   3.7590891396170406`*^9, {3.7596006546458197`*^9, 3.7596006554774103`*^9}, {
   3.7596011740167646`*^9, 3.75960122809816*^9}, {3.759601636287717*^9, 
   3.7596016621483*^9}, 3.7646075104932013`*^9, {3.7646203458456097`*^9, 
   3.764620454737575*^9}, {3.7646854996493673`*^9, 3.7646855037115173`*^9}, {
   3.7646859794921045`*^9, 3.7646860158481245`*^9}, {3.764686073184255*^9, 
   3.7646861544838943`*^9}, {3.764686211793691*^9, 3.7646862572125545`*^9}, {
   3.7646862904244523`*^9, 3.764686405427883*^9}, {3.7646864687285037`*^9, 
   3.7646865180442343`*^9}, {3.764686572759493*^9, 3.7646866878734045`*^9}, {
   3.764686719694611*^9, 3.7646867785222187`*^9}, {3.764686812610632*^9, 
   3.764686838179757*^9}, {3.7646868689586616`*^9, 3.7646868700991297`*^9}, {
   3.7646869951421323`*^9, 3.7646870070846577`*^9}, 3.764687038631254*^9, {
   3.766864949929313*^9, 3.7668649867287836`*^9}, {3.766865028396298*^9, 
   3.766865051889716*^9}, {3.7668656601959724`*^9, 3.766865718566044*^9}, {
   3.7668667541434526`*^9, 3.7668669007405806`*^9}, {3.7692715532102327`*^9, 
   3.7692715605764265`*^9}, {3.769271606645773*^9, 3.769271608832777*^9}, {
   3.7692716587496634`*^9, 3.7692716848105907`*^9}, {3.832168622315541*^9, 
   3.8321686610862274`*^9}, 3.8402044051998596`*^9, {3.840204677480768*^9, 
   3.8402046829517097`*^9}, 3.840207086620818*^9},
 CellLabel->
  "In[130]:=",ExpressionUUID->"22040dfe-f604-4cf5-a887-798c75943143"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVyHs0lHkAh3Ga1aQosR10VCt6f3P3vu+8ohKi3RNFNoMutJFibNFskWJX
tlxGii5mu9lTnC0xjC5TpPRNSVmlw8q16KqjUK1Yl9a2fzznc85jGxazatME
AwMDny/9793Sr96Tcg7lkUTtXsziYGZffXQZh1O39VHpWhZBkS06/VUOAbrP
Kx4VsXgzRxvjeYWDl891iw2FLIyz/PvXX+Jgs5RXmHSOxYqteX05xRzyg2Uj
lWdYNAjde3l5HFSmNyWuGhadeQk9nRkc5h1ZMuKaxGI4O9Xn0moOIRNvJUX7
sGC1m5+1Cjm42g11jc1mIXpZWvZ2VI7Ki4cS0z8wsLfK+seqVo6HquoSBRi4
7PJQHj8pB78ivjDtMIPAx2oPR6Uc9yr1p01CGTj4LfrhupMckZqn1QU0A2ro
llZjLIfMfvG0ch6DOSc6wjKbWew4OonxaKQxP6rOq6mAhWfS3098z9IwCaJ2
GCewiDC5F3NoN42Xbl/z13ixeKc5VJyxnEZbQHPt6EwW588Zpdl9Q6MhQjZU
/oZB9EDiaMQLB6g1/Zs3XmWgC4NZidoB6z+m8DeoGZSsU5QlOTnA0bvULD6I
wdqnrXtdu2QQ1eu8XwgYaFU6q4fZMtj6efYqB2k8O+hZKFssQ3Ove2P7HRrn
9Nv0Tb1SFJVZ9JzW0AjIMhlLPCtFctJuZXI4jdNmypVuwVLEbr9irXekYWDK
Phi2lkK4L9j0Lz4Nf0+D6tftEtywlTbaaB2Q6+fuhZMShOcs73Va6QCjGYsu
VIRJMM3wcIu6R4aFpb8mgEjgfFbrfTFNhrlBqv5l78XI/UM1O1ksQ32b8JNn
pRgTc9ffTq2Rws98EL5qMYr6Pt1no6SQ/mzSn7hajPpdoUH6qVKUp3VnnxGI
MTg2oI8ukqB2wmcPswER1rSxcQ99JbCJ3nmi9ZYI0B3jb+oRY3r8/aFstQgb
OwtGzmSKUZHyaGrDKhFSlh3YoafF2JOlXlA1U4Si88dvjteJUFPH/96wXQjT
TX5b3seI8MKuSqM5JcRPVg49llNECFmQu1UfIESg0fO+GQVCjMuCfusyESJu
hVvAteVCGA6M6u3vCnBi/53MnG4BSjrHAg/HCTBiPzDPMkOAqvgL/HtCAVqH
hr6NkQkgVh1bFdxBUFFl5/RvLYFvjXUXl0rQ2j2slkcTNLWoAnkcwdrqHC5n
y5dv/8vlbJagI4/pHIwiUH6yHZjFEHSFKLlrEQQqbZyVs4zgdWPLU/dQgrrJ
S4aiBAQfb16V+yoI/K2Lbf60ITA5FvskciHBUi58T6wRwcHY6em1zgRl+ZR8
nEcwzb+YlTgRHDleeD99AoH51Fdp/XICw2cL806OU7Dep2DjpARbzAN5GKZA
bZOn7f2GYLKL9Civj0KBTz3zajbB/JDejP3vKAjFP3Z8N4tgXXzCZou3FCSv
85jJMwkWdXvWzX1DgQ0278i2IFCsUyjcn1O4vKAk9eN0ghaR//aaLgqOlt6M
woyA9OTv9O2k4NyQnGppSvDgRiId3EHhmm4Ws2sKQXjKvFfP2yi4HChvbzMm
cM8PTVK2UqiMCkh1mUSwMXTJeH8zBbdlH+jfJxKk85rC4x5T+A/57VqR
         "]]},
       Annotation[#, "Charting`Private`Tag$45631#1"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVjHk01XkAxUOFsbYdy5TlKN+3v9/2IhRtiBgtvFEoZB3LZHDSOk5Rz0hq
hommodemQV4kS4tbmRY0JpF9zEKK8VSKtlPz5o977jn3fu61DUtcH6E9bdo0
H43+9zuq6c9JHYd/Q4KDAoM45GSrWxNqOZReTYkv3sxBHt1VUV2j6c9f2ju8
icNT67LElVc4XMr74VRKIAf9IxvGQ6o0uwL9Z0cDOKyNV6rzyjnYWd7d2+TH
oY3vNqaj5FBX7HXHeTWHAeWukYEsDp3himYrCYe3uZk+VV9ykBZdaNL5wIIp
i/yrm8+hvbHLadkDFoJBVe3oexbSYzkRUUUsFpofeWPexCIi47pdVTwLl7QV
MQUnWCT+cnvQ35VFwGPFClkMi+Gc9tNWRpqdn/OWaw4s6ksuu/b2MrCfulmW
r89i+bIZP74oZ2Bd2BeW3cnglsPHK7LdDBbHtqzpKGHgO9TW/NiHgaHcPll/
FwOD/g/SJBsGg65zdQPXMGg+WiLxHKfR49/Z9N5S81u6ITL9Jo22KMlU3VMa
OwcnhDq5NBT545HhNTRUaTOU32+hEfIyQ3ergkZ1h7Iml6Eh81KZ7pDTeLNk
j/2EFg1Ba4XXPzwaesYz/ZrbKdj6rRyLmaQQfE/SYXeGQueY26PeRgrnWtKc
K5IplNbOGSnOpyArLtxV60khfd/OmPRtFMr3dOnEWlBI+eaKRbWMglx/3yK6
Vwr+gSCjdl0K84O776ozpLhuK340v0wKLb0H2+0EUmzL8x5z+EKK1DGb3aYd
EphoHetSjEiQERduGJYmgeO5Mq/KgxJY2yarGqwlOHl2u1W6UIKH7hEG61rE
mHky5HbmXTFWz5WGPt4uRqn69X0mVgxTj9B8boEYrWmh8mpjMdZ/jIsavy/C
5IdX1QmlIiTE3zO2TBQhsIdJ/c1XhHJr29mtFiKg4rhuxIgQZdGWqRevCRE+
UPLuVLYQPrDnTCOEyPA8nFxNCZHtmrcsy1iI0gsFDZ9aBDj8emuAtkoAowi/
uOeJAhwpn3VCLBcgyVw6YmYgQNtyDyffST4CZvytnlfCx+jiswWn8/lIXevq
X+/Nh4HM5syECx+F3zVm5w3z0LrV0829l4d3C18tMsviwVF7xbyr+3jonppa
nSjhIfE1z6tqEQ9Xb9k5fGwiaLnFH7txm6B7+K2CTSAIO2VTbBVNsOnXPC4v
juCiu9wkI5KgT0kPTMYSrHJW7xzdRvBncAxXH0WwPtjDozaU4Mmjrj/cNN7o
rL68bjPBy4Ya1ncjga+Bx5P9vgSGx1P6o50I7pgUVg5xBDkpsw41ORIs1a6v
9GYJTDaUMyIHgv5KRcUlmmC28dDBcU2e1bm8aI+EwOLARiZVTEAVyuXzeAT2
X7MH99sQTGQR0arPCUp8WukhK4IHwSFvLlgQ8IVf9bkvIKiIir1pYk4geqKk
P7PUcN4GXr1zCZig2X25cwieUSpZkjHB5SUXM1/OIriv/P1ppyGBzMyL3mhK
4Le76/hSAwLHtvRMMyMC//Dz43p6BPUVC+g0Td4wmpSfMJPA5XBdb48+QelD
iVP7dIIbsf6ZLhruk29/zxIdAlfPF9TPGo796dsdRVoE/wHhGU2y
         "]]},
       Annotation[#, "Charting`Private`Tag$45631#2"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVznkw1nkABnBd5ErpcEwSydd7v78DHdrezZaIKImiNym5ylHYbFs7b/JG
KbZBaJSsLCF2kXo7PLZjp7eGjZWjt1T7Uvu2jo6lsuz+9o9nPjPPzDPz2IXF
bQyfrKen58Plf+/VTh0m11hsfvrIMb6WxanMwdbYqyw6HB8bN9awCIzsqmlo
ZDHV5tnw+GUWr22r4tyvsBiz+qQ6Uc3CMMt/SF7HIrI42PfHSyy895YM5nL9
dpeOA89KWbTxZANTSliYl1a3eBew6C05qOs9zuLu0Gkl7wiLT9lKn7ogFmWe
t29M+LKgq3a/6Oax6E58JSd2LPja2qtvxhh0pR86v/w9AwfLrI+WagbCc2bT
9jQzcEtZFVVwlsG83XUTQ6cZbH6csco5isEAPyQpO5SBxG/59huuDCjdb6Y2
EgaOo81VeYYMQnM6D43rMbAt1IRldtJ4b5UmGWuh4RL90LOjnMZb4yJ9n2Ia
JoGOiYYHuf7+rcIT+2hoV84x2OJJo95iQ8VrGY2egE71mDWNyzJ5TKE5jbYI
8ei11xSqU7XDMc8pZOQN7d7ZSMELCkNhDQX5uzSD0AwKTSVn8r9UUHD2qp15
IJBC6WJlQoovBX5rjdcfThRqs97sN7CjYOfnPhA1IsXLjvsGqkEpOgdk7U/u
SPFnl4eF/KYUlVdn64rzpNgXb98SlCWF4rtvohS7pDg8f0J+cJsUSfuvWDU4
S3Ev5+z+D2IpeEdDTH83kCInYFmVfJIUN+1E7fOrJFDre3zUnpdgV+66AVdf
Ca40j++od5fAbNLprgydGMZZCVMe94qxpKzK6+djYmj7tHXth8QoupiwQCEQ
Y1mPKiLWXgz9Ivlt5a8imBhNTt/YJELl4N/36WgRPBa1Xn8QJkJryo7Ahhki
qAsSa2ZNF2Hknw8NsZVCPKLPBOReFGJLD53csl4IVcRcUuYpBGryDcJ1AmgW
dr8Z6BNgZ2/55wuZAvzwU3Nwc7oAaWtPJjZIBTA2vqTbIhKgsqKg6d+HfLhF
qNMd1HyYhvvtGY7jQ+F5+MjhvXzss5ToLIz5eOo3GGxoyMfmaS8H55bz8H2g
TBZcxkOy98oA1Toegtzj+lZ58VB44k5m7isnjDrHh4X0O+Gzw4fFFsedoNHO
CTDLcEL36OjqOLETkjWNFdkiJ1z/ZZHrhJogyPvBttWc3a8+ZTCxBHnJqf75
ewm23s1lc/cQTFfHfv05hkBTQvWORBPMU0wUhnA+3xbFqiII0q1NXizk7G/v
eibbQRA40h9ZEUrwrqmRWb+JQNTQFqHyJzDJT3oauYxgRZ+zg2YpwamkWenq
JQT6LmTFF5xm/tW00JWgvPxOQLELgfmMvmNDDMHdF1OVuzitjm6ik0UECtsL
L/8SEjjGM8dSFxKsdP42c9yW2/m0Un0LCDzWrCvezskTxGjW2BAstlfXNc8n
EPaXUEbWBG22Xd1pVgR0iLkmezaBdcJy+xmc9UsvK9/NIphmmcXEczpbeFGb
ZhIYbcj5qs2MYEmbQmlhShC3tT48z4RAVWNDpRgTjBe2Jn00InA7ee1JjyHB
5PVFaVs5b0UHKN2mE8gqbXJvGHA/176VntMn8Nf5lS7g/A9eFlZH
         "]]},
       Annotation[#, "Charting`Private`Tag$45631#3"]& ], 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVUWs0lHkcJsWqJEWklax6/zPzvsO8MyOydum2lZCKrJIyGhqJEpW0p6PG
2JFJZ6PTZbWiNmpa2hrRJo9WOayTjXIZt1TiTAexSi7Lzn74nefLc57bz0ES
u0U6zcDAwFd//+PToukfSKkYIZPu/3ru5eNMen9dTIkYy7vNrkki+Qja21yo
uS/GL6sdVSkRfPTaq2NXF+v5Eyuo2j18mGZsHQi9K0bUzfkJIWF8+OzP7c+6
LcbjlQ4q5XY+6rlefUa5YpR1bX5l5ctHZ26SrjNNDC9D8fXPQj5Gzyp8734v
Rs9kVbThJAOhOqKrhStG9L6mkwueM+C9LSp5Py7CDgvHLasKGCy1yfhsUyNC
WFiHf85JBh6Jq2QXL4vgvDP3eYGEwbZG5SoXmQgvuAfK2TUMnP2/3vXQVQTl
4unhHB4DaqRCfd5UBFmzeaCBFQP7S22S9CYhVtqukS00ZLA8qnbDy3whOiJt
HUwGacwOouJNk4TwKD5tsukNjbeelibBG4RQa7K4oY00tIFNNeO2QnilKXfW
/0WjPtJppLSXRabpuvFHFTSU5wciwu+ziJ/KEAyU0AgdSjHZrWThIigYjr1D
w8W7aO7RIBY/d1W1NxXQ4NUVer/hsJhyzvOcmUfDwX91n+yTAC1wFZRdptHU
59XQWinAeruB8YhMGrdK5utyzgsgvVFzR6CikXzimCx5jwBHDa68LJXTSDhU
vFDjIgCudnwznkSDKw8xe2Gi19Pq7kniaJQ58Bu+VDvDVjLTRBVBY0/Wxj7X
Tc64vKn285tgGuaGPzUrdU6Ytd/h2TxvGm6/qr1/T3WCYc3whIUbjezrBxcn
0074mzFsLFtKwzg79E9FFR/St4UhN2br8/V/rBZG8SE3TvPvHeKhLjEsSDOH
j7n5AZu3NvLwaWJYE3OLQU7jruJ1d3kI1goPP/NjkGGcYnDuDA8ovGAi1dEY
fOoWvELCQ3hn/tjVdP1fAhPHosU8pKxXxWsENK4dyXYNN+LhVsHF8qlaHpJ6
pNXZ1VyYSf2jP8TyYNNbUSnP4CLOxllnPYuHifYPS5b7cLFtxut+q3wujn51
fHRqBheHfTwDH2zkIi9z2kPrCg4una5Mz+rhIL2wiEzEcTC2dHiZdRoHKVU5
XizhoGVkZG2sEwfP4zvDf9AS/PHY0XWyhsB+SftYt5ygpWdUKYohmKzOVFiK
CLY/yRJnRROwVgK/PJagLZft/BRF4H7c/yMrIHi1UyZ+EEkwqIl77ccneNfQ
3OEVRpCekeieSgiGyu+L/AII/EKD/xlcRDD7QkL7XncCtbzOsmg6wZkEix9r
3Ah8fbjD7kYE5ltvCxlXgrDXqZonhgTz5nSnDuhzBFte7dBOUlgoDxAe1vuU
1+6uNRqlQB0QpZ5aQnBQ3UX591HI961juxcTOBaonFveU+DS+9q+syM4hgOL
JDoKzLtcdqYtwZNzJPtQDwVhyLy2s/MJltlLvbO6KNxb8ZtiyIKAOdUUY/eK
gou1Nxswl+DbRwuOXO+g4FafrLA20/fTrRVpWik8KLRjE2cRnGjf3uOhpeCh
Km3VmhL03VScqGym8CgqUOHxhX6Xh63jG5soeK4fFFwxJtgRHx3S8JLCfwTz
XB8=
         "]]},
       Annotation[#, "Charting`Private`Tag$45631#4"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVUHtUzHkcTVmZHlLaHdFDGn3nPb/fPDSUrVOy9NLRZNajWnpQ9FgKbc7a
dnvIJslOTKSV16wm00GlNut6lCNWTkUPMaKSnB5sSsXa2T8+557PPfeee+51
3py4JtrYyMgo0HD/Y0PF9BFSI4Xxzxf00R408nKHmhKuSjE9Sa3rdqeh3Nqu
q6yWIiP27okww9/vpE30qZLiwk2rptClNBiHQobDL0uhyOT99o2cRkB86ZCq
XIrBFzINJaXRzPEaNCmVot/5jdiOT0NfmjagPyCF69+vVb72NCbyswIvfyvF
mXj1lbNTFMTamO4OjsHvo59Yp6fA7am4+mZKgs9Jt1dX1FNgzT30YW6jBEdn
r4/mayl4pHrHqo9L4Fv3zGJvIYW1j3O8ZbESLLY9LOenUxAFu0fUuUlQZuxw
xi+Bguv4DW0hQ4KSzuDkoHAKTkVdm3PbxFhdrjb6KYjC4rj7qx5pxJCzPDMG
vShYKF2TGWlizH8gF+6VUujxtDVdt0qMuNz2gAuEQmdoW+PUPDEs8p652thT
aN4iHK/pp7HtjMZFbUUhp3A4JrKaRtpLZRXLhEL4u0zT73JoGMU53mENiSDz
q5i9R0njXBRzIKpZBG6Tzu8lm8Yc3fLJzCoRnIN9BmPHKBxmUEFnVSK0DXq1
PLlN4XQMiePtEKHs6pyB3w29zdfkffU4UIT0fT/EpkdRWJHp0XN4oQgpO6vs
KmUUWp4/bPUfE4KTsdGy1ZSC7/oOmf0dIa45C1rstSK8/fqGcfEhIaJU/oNu
q0UoenX89D2lEFbTCtpzBoQozXN0NmEKIT+n9buULYR7pCPDu0WA4rPfO6bz
hNh50ye5IF+AGcXht7LuCGBh5vG+drkAZUPv74rjBNjtU9jSP8lHU+omZeUs
AU7k04qPOj7GPo5WJpTx4V7e+aPzRj7WdYp3PQjiIyT7gHeDOR/QHTONHuBh
8fmXsnOXeIjUayZP5fLgcj+NfTeMh8yVB5MrKR4+BddXejN4KPtDff3zfS6q
xYUmQVouLKODt48kcjHZpriSreBix1zRANOcC2uzOt/UUQ7WfvFi6EsNB+o9
kaHhKg52BXiG1vpzoC1isSw9OCj69Xau6hUbPffiGZpONiZZo4uYB9ho7e37
5L+PjY7xcd9EIRshicoXUYvY+POmi9u/jQTHbYv9c24RdLyayJEkEIgzvC0m
thCsr1dJVdsJPGFTHRFD0FVK68fiCJYV9IY1RBE8D4uV1hp0ZH9JyZFNBH0t
7c+8DPhoUd0/gg0E765XS4IUBCPn/bs3BRFYHEt5unUpwcmmnr4GKUFeivX+
RjmB6dQIUyAhsAopF/PdCErqI3yP0AQ2s3qzhw2826kkVYSQwC5DId4lIHjd
etHsAyFwTZJk/7KAIHKhdQB7PoEmsInudSSIn6FenmdHwOFt61rhQOBAVywZ
ZRLw+0pps3kEKUuO2sHW0HOjTVf+HIKHNUcqlLMIriy5mPXO2pCf2X3wmgWB
jOlHK2YT3HNq3eJiTiBvTs9iWhLUbLhkPWxKUKtzoFMNfOGK092KGQQeB2ue
dDIIZhb4XKydTvBXXGiWx0yCjKeq3QtMDDuufEudNOh2NJxYljWN4D+U7ks4

         "]]},
       Annotation[#, "Charting`Private`Tag$45631#5"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVznk01XkYx3HJEIVEIVQoX3f1W64Ig6PTdqNMiJBIZNcIJ5pNi+uWEs0V
7e5Uo0FElquaPhUVKUUzWkShkjkoidE6v/njOa/z/PM8b8uNiWsi1NXU1Ly4
+d8bFRpviEqCC20uR923sNifPdSaUCdBc4Kn29lEFv5RD8urayVInpT+zoDb
++eWJi6ukWB1kFtObzwL7Ryf4ZAqCXI1+36VxbLwjFcOKcokCFqg19kWyaKN
5z44WSmBVfPx5NT1LLqV2we690iw60pg3oiUxcSBTK+qAAkMvex/abRmwZRG
Pn/Ek8DIzKAiSo0Fv6+i7p+PLNQbChZ0dzGYb5Lzr0kzi1iLLueqiwxc0jyi
C4+wsPmUu6z/CIO1f8s97KNZ3HGOsY5KZ2Dn7bzhkgP3R/2U1COQgc341dJ8
bRZbCwaGKl0YzD3cuTG7g0FZiWHAA3MGC2NaVvxVzOBdoiLr4xca0/xtkrW3
M3AyV90Kf06jz81Ia90KBh75wYXFoPHYr6P542wGwToRt3yLaLRtFo+r+mmE
9Y7f9vuJhjx/ODK8lsbu2VWRLYE0QkZ2a4XKaVx9Ktua5UjDXloxfZs/ja6j
I9EWM2jwW8ulvbY0FnVrhxoPUrD0XjwYPUZB6ta0AdcpdAy6tz9poOC841SW
2mEKJXWGAyfzKSSqIp+bJFHI+Dk9OmMThW0aO0d6llBI2VpjWm1PIf9T7pp7
ZhR4u4J1H2hRKDtk33mv1w6XLUXt5qV2sGJXrC6U2WGTYuWgw2o7qDfuLPyB
soP+pLyH8gExaP0W1cz7YjieKZVWysToDFIa5yWJcez093MyBGL0VupubzAV
Q/NYyPXMmyK0p3S8flonQsnQ+yYmRoQ/0qLuDq8XoTUtzL9aT4SR372N4zRE
GPs0Wp1QIsSz3BNlw0oh1j1mUu+uEuLIjSXyqmVCoLxAK2JAgL0+o6K9fQKE
dxd/KMoWoC71zhvIBNi9fF9yNSVAULhlwkmhACVnC698beEjjXKtUTbxoRvh
HfcmkQ9V5tIey3g+kkzsBoyn8nHC82140xQ+1n7TMzSzmIeea7pvxWd4SPV0
86tfyQO/aLnMWsrD4b0N2YpXthC35nYvfWmLD/NHFxjvscU8K6Nv1eS2eDQ+
viRRbIvvbKw0MkW2uHjN2uFLM4ERGzrLlfPRqwk5m0DACwhzOhhPENiokCji
CNjaTZHvYwk6lXT3WAxBRv3XXH/OZ+ujJfWbCU5//vzKjPNl+8Mu9zAChWJ+
zqlQgpErtewqX+6eeGNztQ/BtIKUp1FOBEWVbWMdiwj2pxhkNTsSDIVEzXLi
1PcpY4QOBJPPn7A/upBght4L2TBLIEkdTQrlNN3ly6SKCHQaXV/3CwlstrCy
nfO47vOHGibmEhR7tdIv5hBcb4/pCuLkCWI7l1pwXa5945fNCYQvlbTObILf
DG7zdpgSMMEzOg8YErRkbJHrcF5YdC5zxIBg9OaPJ+M47Y2ltO90rvsgW3tX
n8CxLSPTWJfg3P3C3rxpBPXlFnTaVIL0+9KJUR0Cl32qJ4+1CS4lnNbz5/wz
xi/TZQqB5vBZa5UWgdvyt9RxTYKaQwGOZpz/AfQSWEY=
         "]]},
       Annotation[#, "Charting`Private`Tag$45631#6"]& ]}, {}}, InsetBox[
     TemplateBox[{
      StyleBox["1.`*^-6", 20, FontFamily -> "Arial", StripOnInput -> False],
       StyleBox["1.`*^-7", 20, FontFamily -> "Arial", StripOnInput -> False],
       StyleBox["1.`*^-8", 20, FontFamily -> "Arial", StripOnInput -> False]},
      "LineLegend",
      DisplayFunction->(FormBox[
        PanelBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 StyleBox[
                 "\"RAF(M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
                  False], {FontSize -> 12, FontFamily -> "Arial"}, 
                 StripOnInput -> False]}, {
                TagBox[
                 GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                  False, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Center}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"],
             Alignment -> Left, AppearanceElements -> None, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontSize -> 12, FontFamily -> "Arial"}, StripOnInput -> False], 
         Background -> Automatic, ContentPadding -> True, 
         FrameMargins -> {{5, 5}, {5, 5}}], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", "12"}], ",", 
           RowBox[{"LegendFunction", "\[Rule]", "Panel"}], ",", 
           RowBox[{"LegendLabel", "\[Rule]", 
             StyleBox[
             "\"RAF(M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
              False]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.99, 0.01}], ImageScaled[{1, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{-20.72326583694641, -20.68921129821441},
   BaseStyle->{FontFamily -> "Times"},
   CoordinatesToolOptions:>{"DisplayFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& ), "CopiedValueFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& )},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       StyleBox[
       "\"Total Drug [DTOT] (M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
        False], TraditionalForm], None}, {
      FormBox[
       StyleBox[
       "\"Unbound Drug [d] (M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
        False], TraditionalForm], None}},
   FrameStyle->Thickness[0.004],
   FrameTicks->FrontEndValueCache[{{Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-20.72326583694641, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}, {{-20.72326583694641, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}, {{{-20.72326583694641, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}, {{-20.72326583694641, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}}],
   FrameTicksStyle->20,
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->{500},
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None},
   PlotLabel->FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(K\\), \\(d\\)]\\): \[LongDash]100nM  - -1nM \
\\!\\(\\*SubscriptBox[\\(K\\), \\(A\\)]\\):2\"", 20, FontFamily -> "Arial", 
      StripOnInput -> False], TraditionalForm],
   PlotRange->
    NCache[{{-Log[1000000000], -
       Log[100000]}, {-20.68921129821441, -11.41762818168552}}, \
{{-20.72326583694641, -11.512925464970229`}, {-20.68921129821441, \
-11.41762818168552}}],
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          Line[CompressedData["
1:eJwVyHs0lHkAh3Ga1aQosR10VCt6f3P3vu+8ohKi3RNFNoMutJFibNFskWJX
tlxGii5mu9lTnC0xjC5TpPRNSVmlw8q16KqjUK1Yl9a2fzznc85jGxazatME
AwMDny/9793Sr96Tcg7lkUTtXsziYGZffXQZh1O39VHpWhZBkS06/VUOAbrP
Kx4VsXgzRxvjeYWDl891iw2FLIyz/PvXX+Jgs5RXmHSOxYqteX05xRzyg2Uj
lWdYNAjde3l5HFSmNyWuGhadeQk9nRkc5h1ZMuKaxGI4O9Xn0moOIRNvJUX7
sGC1m5+1Cjm42g11jc1mIXpZWvZ2VI7Ki4cS0z8wsLfK+seqVo6HquoSBRi4
7PJQHj8pB78ivjDtMIPAx2oPR6Uc9yr1p01CGTj4LfrhupMckZqn1QU0A2ro
llZjLIfMfvG0ch6DOSc6wjKbWew4OonxaKQxP6rOq6mAhWfS3098z9IwCaJ2
GCewiDC5F3NoN42Xbl/z13ixeKc5VJyxnEZbQHPt6EwW588Zpdl9Q6MhQjZU
/oZB9EDiaMQLB6g1/Zs3XmWgC4NZidoB6z+m8DeoGZSsU5QlOTnA0bvULD6I
wdqnrXtdu2QQ1eu8XwgYaFU6q4fZMtj6efYqB2k8O+hZKFssQ3Ove2P7HRrn
9Nv0Tb1SFJVZ9JzW0AjIMhlLPCtFctJuZXI4jdNmypVuwVLEbr9irXekYWDK
Phi2lkK4L9j0Lz4Nf0+D6tftEtywlTbaaB2Q6+fuhZMShOcs73Va6QCjGYsu
VIRJMM3wcIu6R4aFpb8mgEjgfFbrfTFNhrlBqv5l78XI/UM1O1ksQ32b8JNn
pRgTc9ffTq2Rws98EL5qMYr6Pt1no6SQ/mzSn7hajPpdoUH6qVKUp3VnnxGI
MTg2oI8ukqB2wmcPswER1rSxcQ99JbCJ3nmi9ZYI0B3jb+oRY3r8/aFstQgb
OwtGzmSKUZHyaGrDKhFSlh3YoafF2JOlXlA1U4Si88dvjteJUFPH/96wXQjT
TX5b3seI8MKuSqM5JcRPVg49llNECFmQu1UfIESg0fO+GQVCjMuCfusyESJu
hVvAteVCGA6M6u3vCnBi/53MnG4BSjrHAg/HCTBiPzDPMkOAqvgL/HtCAVqH
hr6NkQkgVh1bFdxBUFFl5/RvLYFvjXUXl0rQ2j2slkcTNLWoAnkcwdrqHC5n
y5dv/8vlbJagI4/pHIwiUH6yHZjFEHSFKLlrEQQqbZyVs4zgdWPLU/dQgrrJ
S4aiBAQfb16V+yoI/K2Lbf60ITA5FvskciHBUi58T6wRwcHY6em1zgRl+ZR8
nEcwzb+YlTgRHDleeD99AoH51Fdp/XICw2cL806OU7Dep2DjpARbzAN5GKZA
bZOn7f2GYLKL9Civj0KBTz3zajbB/JDejP3vKAjFP3Z8N4tgXXzCZou3FCSv
85jJMwkWdXvWzX1DgQ0278i2IFCsUyjcn1O4vKAk9eN0ghaR//aaLgqOlt6M
woyA9OTv9O2k4NyQnGppSvDgRiId3EHhmm4Ws2sKQXjKvFfP2yi4HChvbzMm
cM8PTVK2UqiMCkh1mUSwMXTJeH8zBbdlH+jfJxKk85rC4x5T+A/57VqR
           "]]}, "Charting`Private`Tag$45631#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJwVjHk01XkAxUOFsbYdy5TlKN+3v9/2IhRtiBgtvFEoZB3LZHDSOk5Rz0hq
hommodemQV4kS4tbmRY0JpF9zEKK8VSKtlPz5o977jn3fu61DUtcH6E9bdo0
H43+9zuq6c9JHYd/Q4KDAoM45GSrWxNqOZReTYkv3sxBHt1VUV2j6c9f2ju8
icNT67LElVc4XMr74VRKIAf9IxvGQ6o0uwL9Z0cDOKyNV6rzyjnYWd7d2+TH
oY3vNqaj5FBX7HXHeTWHAeWukYEsDp3himYrCYe3uZk+VV9ykBZdaNL5wIIp
i/yrm8+hvbHLadkDFoJBVe3oexbSYzkRUUUsFpofeWPexCIi47pdVTwLl7QV
MQUnWCT+cnvQ35VFwGPFClkMi+Gc9tNWRpqdn/OWaw4s6ksuu/b2MrCfulmW
r89i+bIZP74oZ2Bd2BeW3cnglsPHK7LdDBbHtqzpKGHgO9TW/NiHgaHcPll/
FwOD/g/SJBsGg65zdQPXMGg+WiLxHKfR49/Z9N5S81u6ITL9Jo22KMlU3VMa
OwcnhDq5NBT545HhNTRUaTOU32+hEfIyQ3ergkZ1h7Iml6Eh81KZ7pDTeLNk
j/2EFg1Ba4XXPzwaesYz/ZrbKdj6rRyLmaQQfE/SYXeGQueY26PeRgrnWtKc
K5IplNbOGSnOpyArLtxV60khfd/OmPRtFMr3dOnEWlBI+eaKRbWMglx/3yK6
Vwr+gSCjdl0K84O776ozpLhuK340v0wKLb0H2+0EUmzL8x5z+EKK1DGb3aYd
EphoHetSjEiQERduGJYmgeO5Mq/KgxJY2yarGqwlOHl2u1W6UIKH7hEG61rE
mHky5HbmXTFWz5WGPt4uRqn69X0mVgxTj9B8boEYrWmh8mpjMdZ/jIsavy/C
5IdX1QmlIiTE3zO2TBQhsIdJ/c1XhHJr29mtFiKg4rhuxIgQZdGWqRevCRE+
UPLuVLYQPrDnTCOEyPA8nFxNCZHtmrcsy1iI0gsFDZ9aBDj8emuAtkoAowi/
uOeJAhwpn3VCLBcgyVw6YmYgQNtyDyffST4CZvytnlfCx+jiswWn8/lIXevq
X+/Nh4HM5syECx+F3zVm5w3z0LrV0829l4d3C18tMsviwVF7xbyr+3jonppa
nSjhIfE1z6tqEQ9Xb9k5fGwiaLnFH7txm6B7+K2CTSAIO2VTbBVNsOnXPC4v
juCiu9wkI5KgT0kPTMYSrHJW7xzdRvBncAxXH0WwPtjDozaU4Mmjrj/cNN7o
rL68bjPBy4Ya1ncjga+Bx5P9vgSGx1P6o50I7pgUVg5xBDkpsw41ORIs1a6v
9GYJTDaUMyIHgv5KRcUlmmC28dDBcU2e1bm8aI+EwOLARiZVTEAVyuXzeAT2
X7MH99sQTGQR0arPCUp8WukhK4IHwSFvLlgQ8IVf9bkvIKiIir1pYk4geqKk
P7PUcN4GXr1zCZig2X25cwieUSpZkjHB5SUXM1/OIriv/P1ppyGBzMyL3mhK
4Le76/hSAwLHtvRMMyMC//Dz43p6BPUVC+g0Td4wmpSfMJPA5XBdb48+QelD
iVP7dIIbsf6ZLhruk29/zxIdAlfPF9TPGo796dsdRVoE/wHhGU2y
           "]]}, "Charting`Private`Tag$45631#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwVznkw1nkABnBd5ErpcEwSydd7v78DHdrezZaIKImiNym5ylHYbFs7b/JG
KbZBaJSsLCF2kXo7PLZjp7eGjZWjt1T7Uvu2jo6lsuz+9o9nPjPPzDPz2IXF
bQyfrKen58Plf+/VTh0m11hsfvrIMb6WxanMwdbYqyw6HB8bN9awCIzsqmlo
ZDHV5tnw+GUWr22r4tyvsBiz+qQ6Uc3CMMt/SF7HIrI42PfHSyy895YM5nL9
dpeOA89KWbTxZANTSliYl1a3eBew6C05qOs9zuLu0Gkl7wiLT9lKn7ogFmWe
t29M+LKgq3a/6Oax6E58JSd2LPja2qtvxhh0pR86v/w9AwfLrI+WagbCc2bT
9jQzcEtZFVVwlsG83XUTQ6cZbH6csco5isEAPyQpO5SBxG/59huuDCjdb6Y2
EgaOo81VeYYMQnM6D43rMbAt1IRldtJ4b5UmGWuh4RL90LOjnMZb4yJ9n2Ia
JoGOiYYHuf7+rcIT+2hoV84x2OJJo95iQ8VrGY2egE71mDWNyzJ5TKE5jbYI
8ei11xSqU7XDMc8pZOQN7d7ZSMELCkNhDQX5uzSD0AwKTSVn8r9UUHD2qp15
IJBC6WJlQoovBX5rjdcfThRqs97sN7CjYOfnPhA1IsXLjvsGqkEpOgdk7U/u
SPFnl4eF/KYUlVdn64rzpNgXb98SlCWF4rtvohS7pDg8f0J+cJsUSfuvWDU4
S3Ev5+z+D2IpeEdDTH83kCInYFmVfJIUN+1E7fOrJFDre3zUnpdgV+66AVdf
Ca40j++od5fAbNLprgydGMZZCVMe94qxpKzK6+djYmj7tHXth8QoupiwQCEQ
Y1mPKiLWXgz9Ivlt5a8imBhNTt/YJELl4N/36WgRPBa1Xn8QJkJryo7Ahhki
qAsSa2ZNF2Hknw8NsZVCPKLPBOReFGJLD53csl4IVcRcUuYpBGryDcJ1AmgW
dr8Z6BNgZ2/55wuZAvzwU3Nwc7oAaWtPJjZIBTA2vqTbIhKgsqKg6d+HfLhF
qNMd1HyYhvvtGY7jQ+F5+MjhvXzss5ToLIz5eOo3GGxoyMfmaS8H55bz8H2g
TBZcxkOy98oA1Toegtzj+lZ58VB44k5m7isnjDrHh4X0O+Gzw4fFFsedoNHO
CTDLcEL36OjqOLETkjWNFdkiJ1z/ZZHrhJogyPvBttWc3a8+ZTCxBHnJqf75
ewm23s1lc/cQTFfHfv05hkBTQvWORBPMU0wUhnA+3xbFqiII0q1NXizk7G/v
eibbQRA40h9ZEUrwrqmRWb+JQNTQFqHyJzDJT3oauYxgRZ+zg2YpwamkWenq
JQT6LmTFF5xm/tW00JWgvPxOQLELgfmMvmNDDMHdF1OVuzitjm6ik0UECtsL
L/8SEjjGM8dSFxKsdP42c9yW2/m0Un0LCDzWrCvezskTxGjW2BAstlfXNc8n
EPaXUEbWBG22Xd1pVgR0iLkmezaBdcJy+xmc9UsvK9/NIphmmcXEczpbeFGb
ZhIYbcj5qs2MYEmbQmlhShC3tT48z4RAVWNDpRgTjBe2Jn00InA7ee1JjyHB
5PVFaVs5b0UHKN2mE8gqbXJvGHA/176VntMn8Nf5lS7g/A9eFlZH
           "]]}, "Charting`Private`Tag$45631#3"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwVUWs0lHkcJsWqJEWklax6/zPzvsO8MyOydum2lZCKrJIyGhqJEpW0p6PG
2JFJZ6PTZbWiNmpa2hrRJo9WOayTjXIZt1TiTAexSi7Lzn74nefLc57bz0ES
u0U6zcDAwFd//+PToukfSKkYIZPu/3ru5eNMen9dTIkYy7vNrkki+Qja21yo
uS/GL6sdVSkRfPTaq2NXF+v5Eyuo2j18mGZsHQi9K0bUzfkJIWF8+OzP7c+6
LcbjlQ4q5XY+6rlefUa5YpR1bX5l5ctHZ26SrjNNDC9D8fXPQj5Gzyp8734v
Rs9kVbThJAOhOqKrhStG9L6mkwueM+C9LSp5Py7CDgvHLasKGCy1yfhsUyNC
WFiHf85JBh6Jq2QXL4vgvDP3eYGEwbZG5SoXmQgvuAfK2TUMnP2/3vXQVQTl
4unhHB4DaqRCfd5UBFmzeaCBFQP7S22S9CYhVtqukS00ZLA8qnbDy3whOiJt
HUwGacwOouJNk4TwKD5tsukNjbeelibBG4RQa7K4oY00tIFNNeO2QnilKXfW
/0WjPtJppLSXRabpuvFHFTSU5wciwu+ziJ/KEAyU0AgdSjHZrWThIigYjr1D
w8W7aO7RIBY/d1W1NxXQ4NUVer/hsJhyzvOcmUfDwX91n+yTAC1wFZRdptHU
59XQWinAeruB8YhMGrdK5utyzgsgvVFzR6CikXzimCx5jwBHDa68LJXTSDhU
vFDjIgCudnwznkSDKw8xe2Gi19Pq7kniaJQ58Bu+VDvDVjLTRBVBY0/Wxj7X
Tc64vKn285tgGuaGPzUrdU6Ytd/h2TxvGm6/qr1/T3WCYc3whIUbjezrBxcn
0074mzFsLFtKwzg79E9FFR/St4UhN2br8/V/rBZG8SE3TvPvHeKhLjEsSDOH
j7n5AZu3NvLwaWJYE3OLQU7jruJ1d3kI1goPP/NjkGGcYnDuDA8ovGAi1dEY
fOoWvELCQ3hn/tjVdP1fAhPHosU8pKxXxWsENK4dyXYNN+LhVsHF8qlaHpJ6
pNXZ1VyYSf2jP8TyYNNbUSnP4CLOxllnPYuHifYPS5b7cLFtxut+q3wujn51
fHRqBheHfTwDH2zkIi9z2kPrCg4una5Mz+rhIL2wiEzEcTC2dHiZdRoHKVU5
XizhoGVkZG2sEwfP4zvDf9AS/PHY0XWyhsB+SftYt5ygpWdUKYohmKzOVFiK
CLY/yRJnRROwVgK/PJagLZft/BRF4H7c/yMrIHi1UyZ+EEkwqIl77ccneNfQ
3OEVRpCekeieSgiGyu+L/AII/EKD/xlcRDD7QkL7XncCtbzOsmg6wZkEix9r
3Ah8fbjD7kYE5ltvCxlXgrDXqZonhgTz5nSnDuhzBFte7dBOUlgoDxAe1vuU
1+6uNRqlQB0QpZ5aQnBQ3UX591HI961juxcTOBaonFveU+DS+9q+syM4hgOL
JDoKzLtcdqYtwZNzJPtQDwVhyLy2s/MJltlLvbO6KNxb8ZtiyIKAOdUUY/eK
gou1Nxswl+DbRwuOXO+g4FafrLA20/fTrRVpWik8KLRjE2cRnGjf3uOhpeCh
Km3VmhL03VScqGym8CgqUOHxhX6Xh63jG5soeK4fFFwxJtgRHx3S8JLCfwTz
XB8=
           "]]}, "Charting`Private`Tag$45631#4"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwVUHtUzHkcTVmZHlLaHdFDGn3nPb/fPDSUrVOy9NLRZNajWnpQ9FgKbc7a
dnvIJslOTKSV16wm00GlNut6lCNWTkUPMaKSnB5sSsXa2T8+557PPfeee+51
3py4JtrYyMgo0HD/Y0PF9BFSI4Xxzxf00R408nKHmhKuSjE9Sa3rdqeh3Nqu
q6yWIiP27okww9/vpE30qZLiwk2rptClNBiHQobDL0uhyOT99o2cRkB86ZCq
XIrBFzINJaXRzPEaNCmVot/5jdiOT0NfmjagPyCF69+vVb72NCbyswIvfyvF
mXj1lbNTFMTamO4OjsHvo59Yp6fA7am4+mZKgs9Jt1dX1FNgzT30YW6jBEdn
r4/mayl4pHrHqo9L4Fv3zGJvIYW1j3O8ZbESLLY9LOenUxAFu0fUuUlQZuxw
xi+Bguv4DW0hQ4KSzuDkoHAKTkVdm3PbxFhdrjb6KYjC4rj7qx5pxJCzPDMG
vShYKF2TGWlizH8gF+6VUujxtDVdt0qMuNz2gAuEQmdoW+PUPDEs8p652thT
aN4iHK/pp7HtjMZFbUUhp3A4JrKaRtpLZRXLhEL4u0zT73JoGMU53mENiSDz
q5i9R0njXBRzIKpZBG6Tzu8lm8Yc3fLJzCoRnIN9BmPHKBxmUEFnVSK0DXq1
PLlN4XQMiePtEKHs6pyB3w29zdfkffU4UIT0fT/EpkdRWJHp0XN4oQgpO6vs
KmUUWp4/bPUfE4KTsdGy1ZSC7/oOmf0dIa45C1rstSK8/fqGcfEhIaJU/oNu
q0UoenX89D2lEFbTCtpzBoQozXN0NmEKIT+n9buULYR7pCPDu0WA4rPfO6bz
hNh50ye5IF+AGcXht7LuCGBh5vG+drkAZUPv74rjBNjtU9jSP8lHU+omZeUs
AU7k04qPOj7GPo5WJpTx4V7e+aPzRj7WdYp3PQjiIyT7gHeDOR/QHTONHuBh
8fmXsnOXeIjUayZP5fLgcj+NfTeMh8yVB5MrKR4+BddXejN4KPtDff3zfS6q
xYUmQVouLKODt48kcjHZpriSreBix1zRANOcC2uzOt/UUQ7WfvFi6EsNB+o9
kaHhKg52BXiG1vpzoC1isSw9OCj69Xau6hUbPffiGZpONiZZo4uYB9ho7e37
5L+PjY7xcd9EIRshicoXUYvY+POmi9u/jQTHbYv9c24RdLyayJEkEIgzvC0m
thCsr1dJVdsJPGFTHRFD0FVK68fiCJYV9IY1RBE8D4uV1hp0ZH9JyZFNBH0t
7c+8DPhoUd0/gg0E765XS4IUBCPn/bs3BRFYHEt5unUpwcmmnr4GKUFeivX+
RjmB6dQIUyAhsAopF/PdCErqI3yP0AQ2s3qzhw2826kkVYSQwC5DId4lIHjd
etHsAyFwTZJk/7KAIHKhdQB7PoEmsInudSSIn6FenmdHwOFt61rhQOBAVywZ
ZRLw+0pps3kEKUuO2sHW0HOjTVf+HIKHNUcqlLMIriy5mPXO2pCf2X3wmgWB
jOlHK2YT3HNq3eJiTiBvTs9iWhLUbLhkPWxKUKtzoFMNfOGK092KGQQeB2ue
dDIIZhb4XKydTvBXXGiWx0yCjKeq3QtMDDuufEudNOh2NJxYljWN4D+U7ks4

           "]]}, "Charting`Private`Tag$45631#5"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Dashing[{Small, Small}], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwVznk01XkYx3HJEIVEIVQoX3f1W64Ig6PTdqNMiJBIZNcIJ5pNi+uWEs0V
7e5Uo0FElquaPhUVKUUzWkShkjkoidE6v/njOa/z/PM8b8uNiWsi1NXU1Ly4
+d8bFRpviEqCC20uR923sNifPdSaUCdBc4Kn29lEFv5RD8urayVInpT+zoDb
++eWJi6ukWB1kFtObzwL7Ryf4ZAqCXI1+36VxbLwjFcOKcokCFqg19kWyaKN
5z44WSmBVfPx5NT1LLqV2we690iw60pg3oiUxcSBTK+qAAkMvex/abRmwZRG
Pn/Ek8DIzKAiSo0Fv6+i7p+PLNQbChZ0dzGYb5Lzr0kzi1iLLueqiwxc0jyi
C4+wsPmUu6z/CIO1f8s97KNZ3HGOsY5KZ2Dn7bzhkgP3R/2U1COQgc341dJ8
bRZbCwaGKl0YzD3cuTG7g0FZiWHAA3MGC2NaVvxVzOBdoiLr4xca0/xtkrW3
M3AyV90Kf06jz81Ia90KBh75wYXFoPHYr6P542wGwToRt3yLaLRtFo+r+mmE
9Y7f9vuJhjx/ODK8lsbu2VWRLYE0QkZ2a4XKaVx9Ktua5UjDXloxfZs/ja6j
I9EWM2jwW8ulvbY0FnVrhxoPUrD0XjwYPUZB6ta0AdcpdAy6tz9poOC841SW
2mEKJXWGAyfzKSSqIp+bJFHI+Dk9OmMThW0aO0d6llBI2VpjWm1PIf9T7pp7
ZhR4u4J1H2hRKDtk33mv1w6XLUXt5qV2sGJXrC6U2WGTYuWgw2o7qDfuLPyB
soP+pLyH8gExaP0W1cz7YjieKZVWysToDFIa5yWJcez093MyBGL0VupubzAV
Q/NYyPXMmyK0p3S8flonQsnQ+yYmRoQ/0qLuDq8XoTUtzL9aT4SR372N4zRE
GPs0Wp1QIsSz3BNlw0oh1j1mUu+uEuLIjSXyqmVCoLxAK2JAgL0+o6K9fQKE
dxd/KMoWoC71zhvIBNi9fF9yNSVAULhlwkmhACVnC698beEjjXKtUTbxoRvh
HfcmkQ9V5tIey3g+kkzsBoyn8nHC82140xQ+1n7TMzSzmIeea7pvxWd4SPV0
86tfyQO/aLnMWsrD4b0N2YpXthC35nYvfWmLD/NHFxjvscU8K6Nv1eS2eDQ+
viRRbIvvbKw0MkW2uHjN2uFLM4ERGzrLlfPRqwk5m0DACwhzOhhPENiokCji
CNjaTZHvYwk6lXT3WAxBRv3XXH/OZ+ujJfWbCU5//vzKjPNl+8Mu9zAChWJ+
zqlQgpErtewqX+6eeGNztQ/BtIKUp1FOBEWVbWMdiwj2pxhkNTsSDIVEzXLi
1PcpY4QOBJPPn7A/upBght4L2TBLIEkdTQrlNN3ly6SKCHQaXV/3CwlstrCy
nfO47vOHGibmEhR7tdIv5hBcb4/pCuLkCWI7l1pwXa5945fNCYQvlbTObILf
DG7zdpgSMMEzOg8YErRkbJHrcF5YdC5zxIBg9OaPJ+M47Y2ltO90rvsgW3tX
n8CxLSPTWJfg3P3C3rxpBPXlFnTaVIL0+9KJUR0Cl32qJ4+1CS4lnNbz5/wz
xi/TZQqB5vBZa5UWgdvyt9RxTYKaQwGOZpz/AfQSWEY=
           "]]}, "Charting`Private`Tag$45631#6"]}}, {}}, {
     DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
      Ticks -> {Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, 
      AxesOrigin -> {-20.72326583694641, -20.68921129821441}, 
      FrameTicks -> {{Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLines -> {None, None}, 
      DisplayFunction -> Identity, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "ClippingRange" -> {{{-20.72326564898028, \
-11.512925652936358`}, {-20.68921129821441, -11.41762818168552}}, \
{{-20.72326564898028, -11.512925652936358`}, {-20.68921129821441, \
-11.41762818168552}}}}, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {-20.72326583694641, -20.68921129821441}, 
      BaseStyle -> {FontFamily -> "Times"}, 
      CoordinatesToolOptions -> {"DisplayFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& )}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         Style["Total Drug [DTOT] (M)", 20, FontFamily -> "Arial"], None}, {
         Style["Unbound Drug [d] (M)", 20, FontFamily -> "Arial"], None}}, 
      FrameStyle -> Thickness[0.004], 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      FrameTicksStyle -> 20, GridLines -> {None, None}, GridLinesStyle -> 
      Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, PlotLabel -> 
      Style["\!\(\*SubscriptBox[\(K\), \(d\)]\): \[LongDash]100nM  - -1nM \
\!\(\*SubscriptBox[\(K\), \(A\)]\):2", 20, FontFamily -> "Arial"], 
      PlotRange -> {{-Log[1000000000], -
         Log[100000]}, {-20.68921129821441, -11.41762818168552}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        RGBColor[0, 0, 1], 
        RGBColor[0, 1, 0], 
        Directive[
         RGBColor[1, 0, 0], 
         Thickness[Large]]}, {
        Style[1.*^-6, 20, FontFamily -> "Arial"], 
        Style[1.*^-7, 20, FontFamily -> "Arial"], 
        Style[1.*^-8, 20, FontFamily -> "Arial"]}, LabelStyle -> 12, 
       LegendFunction -> Panel, LegendLabel -> 
       Style["RAF(M)", 20, FontFamily -> "Arial"], LegendLayout -> 
       "Column"]], {Right, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{3.812994407784314*^9, 3.8321686622364225`*^9, 
  3.8402046849217443`*^9, 3.840207088163101*^9, 3.8406523405796227`*^9, 
  3.8905260843546095`*^9, 3.890674003055136*^9, 3.8906741980947714`*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"2d3de93f-aea2-451b-b49c-50ddd0b9a27c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.5. Analytic Expressions for maximum Fold Change (FC) ", \
"Subsubsection",
 CellChangeTimes->{{3.831920558274994*^9, 3.831920568951131*^9}, {
   3.8319206099444203`*^9, 3.8319206382915373`*^9}, {3.8319228274578667`*^9, 
   3.831922828296911*^9}, {3.831923265609557*^9, 3.831923265941924*^9}, 
   3.832088767728548*^9, {3.8331596529044495`*^9, 3.8331596605908427`*^9}, {
   3.8407375893996086`*^9, 3.840737601563978*^9}, {3.8449391091477575`*^9, 
   3.8449391092171035`*^9}},ExpressionUUID->"9a1e0050-330b-4829-8b75-\
904554714e4e"],

Cell["\<\
Fold change is defined as the ratio between maximum RAF activity (no/conc of \
active protomers) to that in absence of drug\
\>", "Text",
 CellChangeTimes->{{3.8319210014332504`*^9, 
  3.831921044927513*^9}},ExpressionUUID->"1e932f9b-de9c-47b8-b721-\
2a28605fd63a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maxActiveRAFCA", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"fnActiveRAFCA", "/.", 
      RowBox[{"zeroes", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rafFC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"maxActiveRAFCA", "/", "baselineActiveRAFCA"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8319206411308155`*^9, 3.831920654543648*^9}, {
   3.8319209514436145`*^9, 3.831920964234915*^9}, {3.8319210462861276`*^9, 
   3.8319210808824434`*^9}, {3.8319211410192847`*^9, 
   3.8319211418294463`*^9}, {3.8319212907129707`*^9, 3.831921293775152*^9}, 
   3.831929927406506*^9, {3.8320860698850856`*^9, 3.8320861755815163`*^9}, {
   3.8320864795071588`*^9, 3.8320865564244003`*^9}, {3.8320866370022855`*^9, 
   3.832086656919811*^9}, {3.8321657983699083`*^9, 3.8321657985708137`*^9}, 
   3.8402070952948265`*^9, {3.8406523549400873`*^9, 3.840652365604474*^9}, {
   3.8928388131617684`*^9, 
   3.892838817162482*^9}},ExpressionUUID->"dbdb16eb-db63-44fa-b9da-\
e4d4c5d1fb9f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"8", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"6", " ", 
        SubscriptBox["RAF", "rel"]}]}]], "+", 
     RowBox[{
      SubscriptBox["RAF", "rel"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "9"}], "+", 
        RowBox[{"6", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"27", " ", "KA", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.840207096981233*^9, {3.840652351018113*^9, 3.8406523659399633`*^9}, 
   3.8905260854390697`*^9, 3.890674204772754*^9, 3.892838787337045*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"6bfec464-55d4-4725-99c3-882e965d6c3e"]
}, Open  ]],

Cell[TextData[{
 "When the \[OpenCurlyQuote]exist\[CloseCurlyQuote] conditions derived above \
to qualify for existence of PA within this model are satisfied, we can \
evaluate the functional dependence of the raf fold change expression on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["RAF", "rel"], TraditionalForm]],ExpressionUUID->
  "af175b04-8b40-4e09-9f4e-14e52595b982"],
 " and KA:"
}], "Text",
 CellChangeTimes->{{3.832087546777257*^9, 
  3.8320875941822586`*^9}},ExpressionUUID->"2a8eee47-e26e-4e61-bcc2-\
65b9868530f7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"dRAFrafFC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"rafFC", ",", 
     SubscriptBox["RAF", "rel"]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"dKArafFC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"rafFC", ",", "KA"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{"dRAFrafFC", "<", "0"}], "]"}], ",", "exist"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{"dKArafFC", ">", "0"}], "]"}], ",", "exist"}], "]"}]}], "Input",
 CellChangeTimes->{{3.832086689751876*^9, 3.8320867350715184`*^9}, {
  3.832087084899557*^9, 3.8320870857655926`*^9}, {3.8320873820129504`*^9, 
  3.832087506095231*^9}, {3.832087718396454*^9, 3.8320877721038113`*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"0bb3208e-5af5-4e8b-a557-f46c5be4feaa"],

Cell[BoxData[
 FractionBox[
  RowBox[{"8", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"6", " ", 
          SubscriptBox["RAF", "rel"]}], "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "KA", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
           RowBox[{"8", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"6", " ", 
         SubscriptBox["RAF", "rel"]}]}]]], "+", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]], "+", 
         RowBox[{
          SubscriptBox["RAF", "rel"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            RowBox[{"6", " ", 
             SqrtBox[
              RowBox[{"1", "+", 
               RowBox[{"6", " ", 
                SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}]}], ")"}]}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]]}], ")"}]}], 
  RowBox[{"27", " ", "KA", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "3"]}]]], "Output",
 CellChangeTimes->{{3.8320867192948036`*^9, 3.832086735541482*^9}, {
   3.832087390453227*^9, 3.8320873958642416`*^9}, {3.8320874327581825`*^9, 
   3.83208743999654*^9}, {3.832087473760183*^9, 3.8320875067748528`*^9}, 
   3.832087772873245*^9, 3.8402071007625055`*^9, 3.84065237911744*^9, 
   3.8905260858816266`*^9, 3.8906742069301643`*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"ad71f2ba-9ad3-45ef-9dbb-d4f9a7dc31ab"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "KA"}], "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"6", " ", 
         SubscriptBox["RAF", "rel"]}]}]], "+", 
      RowBox[{
       SubscriptBox["RAF", "rel"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "9"}], "+", 
         RowBox[{"6", " ", 
          SqrtBox[
           RowBox[{"1", "+", 
            RowBox[{"6", " ", 
             SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}]}], ")"}]}], 
   RowBox[{"27", " ", 
    SuperscriptBox["KA", "2"], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
      RowBox[{"8", " ", 
       SubscriptBox["RAF", "rel"]}]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "KA", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
         RowBox[{"8", " ", 
          SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"]}]]}]], "Output",
 CellChangeTimes->{{3.8320867192948036`*^9, 3.832086735541482*^9}, {
   3.832087390453227*^9, 3.8320873958642416`*^9}, {3.8320874327581825`*^9, 
   3.83208743999654*^9}, {3.832087473760183*^9, 3.8320875067748528`*^9}, 
   3.832087772873245*^9, 3.8402071007625055`*^9, 3.84065237911744*^9, 
   3.8905260858816266`*^9, 3.8906742070239162`*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"9628f40a-49fc-49bf-98dd-25cc3a375b78"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8320867192948036`*^9, 3.832086735541482*^9}, {
   3.832087390453227*^9, 3.8320873958642416`*^9}, {3.8320874327581825`*^9, 
   3.83208743999654*^9}, {3.832087473760183*^9, 3.8320875067748528`*^9}, 
   3.832087772873245*^9, 3.8402071007625055`*^9, 3.84065237911744*^9, 
   3.8905260858816266`*^9, 3.890674207320814*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"dffdd323-792d-423e-ba98-83822cab76c9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8320867192948036`*^9, 3.832086735541482*^9}, {
   3.832087390453227*^9, 3.8320873958642416`*^9}, {3.8320874327581825`*^9, 
   3.83208743999654*^9}, {3.832087473760183*^9, 3.8320875067748528`*^9}, 
   3.832087772873245*^9, 3.8402071007625055`*^9, 3.84065237911744*^9, 
   3.8905260858816266`*^9, 3.8906742074614124`*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"e2acd11e-fe95-490a-983e-4d56ff8ab6b6"]
}, Open  ]],

Cell["\<\
Hence, first derivative of the fold change expression relative to KA is \
always positive when the model displays PA and the first derivative relative \
to RAF rel always negative. \[LineSeparator]In other words, an equilibrium \
that more and more favors the inactive state (increasing KA), the fold change \
continues to increase as a function of KA. And as the concentration of RAF \
increases or it\[CloseCurlyQuote]s dimerization rate increases (Kdim \
reduces), the fold change relative to baseline continues to reduce.\
\>", "Text",
 CellChangeTimes->{{3.832087510939499*^9, 3.8320875447076406`*^9}, {
  3.832087599566928*^9, 
  3.8320876870914345`*^9}},ExpressionUUID->"51eb8cd6-e68d-4061-b7d9-\
6a83afd2dfb7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"maxActiveRAFCA", ",", "baselineActiveRAFCA"}], "}"}]], "Input",
 CellChangeTimes->{{3.831921309557544*^9, 3.831921313809476*^9}, {
  3.83192149143499*^9, 3.831921516429093*^9}, {3.831921839511224*^9, 
  3.831921840863959*^9}, {3.8319219854236984`*^9, 3.8319219975312634`*^9}, {
  3.8406523851940784`*^9, 3.840652385303643*^9}, {3.8906742383564053`*^9, 
  3.890674238418898*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"8e19d870-4a56-4f8d-97f0-ad604fe63d4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"6", " ", 
        SubscriptBox["RAF", "rel"]}]}]], "+", 
     RowBox[{
      SubscriptBox["RAF", "rel"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "9"}], "+", 
        RowBox[{"6", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}]}], 
    RowBox[{"27", " ", "KA", " ", 
     SubscriptBox["RAF", "rel"]}]], ",", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "KA", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
         RowBox[{"8", " ", 
          SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
    RowBox[{"8", " ", 
     SubscriptBox["RAF", "rel"]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.8319215058299084`*^9, 3.8319215176454945`*^9}, 
   3.8319218472108855`*^9, {3.831921986970317*^9, 3.83192199783183*^9}, 
   3.831929929795315*^9, 3.8320866581927166`*^9, 3.840207104731703*^9, 
   3.840652385970027*^9, 3.890526086718381*^9, 3.8906742399846087`*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"2212dae8-d190-481e-bca7-dfc6390f5321"]
}, Open  ]],

Cell["\<\
Activating Range is defined as the lowest concentration above which the drug \
no longer acts as a paradoxical activator and becomes an inhibitor. This \
function is not easily solved analytically, and to understand its variation \
within the range of parameters defined in conditions for PA above, is \
calculated numerically in python files.\
\>", "Text",
 CellChangeTimes->{{3.8319217033257265`*^9, 3.831921756276883*^9}, {
  3.831921925837969*^9, 3.831921981729839*^9}, {3.890674248035087*^9, 
  3.8906742522420845`*^9}},ExpressionUUID->"c875d813-5cd6-4488-ae15-\
a458080f794b"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Section 1.4. Unified Model", "Section",
 CellChangeTimes->{{3.76919880174008*^9, 3.7691988613532224`*^9}, 
   3.769273566954769*^9, {3.8402032805684576`*^9, 3.840203284256183*^9}, 
   3.8402033256104307`*^9, {3.8402033853654327`*^9, 3.840203389849573*^9}, {
   3.844883679604762*^9, 
   3.844883681259268*^9}},ExpressionUUID->"16346496-a787-4b87-bd4e-\
2f260596ec56"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.769456144052461*^9, 3.7694561471807184`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"a4a5fd6e-6a56-40aa-a338-632b95775732"],

Cell[CellGroupData[{

Cell["1.4.1. Analytic Solution to the model", "Subsubsection",
 CellChangeTimes->{{3.7692694154543457`*^9, 3.7692694289690504`*^9}, {
  3.769436772449255*^9, 3.769436772675357*^9}, {3.8324323477216988`*^9, 
  3.83243234796869*^9}, {3.8331596409988627`*^9, 3.8331596677817163`*^9}, {
  3.840653138832727*^9, 3.8406531391140285`*^9}, {3.8449391143712893`*^9, 
  3.8449391146192307`*^9}},ExpressionUUID->"ec7c3265-99b5-40b3-955d-\
940ab57786ab"],

Cell["This model incorporates all the mechanisms.", "Text",
 CellChangeTimes->{{3.7692038930283422`*^9, 3.769204042191204*^9}, {
   3.7692041782201395`*^9, 3.769204211165009*^9}, {3.7692042428710303`*^9, 
   3.769204276661768*^9}, {3.7692675966867456`*^9, 3.769267724788076*^9}, 
   3.840204405025261*^9, {3.8906742728451004`*^9, 
   3.8906742783624725`*^9}},ExpressionUUID->"cc58651c-9334-46ab-8394-\
65cf4a55198e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vars", "=", 
    RowBox[{"{", 
     RowBox[{
     "a", ",", "A", ",", "d", ",", "AA", ",", "Ad", ",", "AAd", ",", "AdAd"}],
      "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"A", " ", "list", " ", "of", " ", "all", " ", "variables"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rep4", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AA", "\[Rule]", 
       FractionBox[
        SuperscriptBox["A", "2"], "Kdim"]}], ",", 
      RowBox[{"AAd", "\[Rule]", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"], "d"}], 
        RowBox[{"f", " ", "Kdim", " ", "Kd"}]]}], ",", 
      RowBox[{"AdAd", "\[Rule]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["A", "2"], 
         SuperscriptBox["d", "2"]}], 
        RowBox[{"f", " ", "g", " ", "Kdim", " ", 
         SuperscriptBox["Kd", "2"]}]]}], ",", 
      RowBox[{"Ad", "\[Rule]", 
       FractionBox[
        RowBox[{"A", " ", "d"}], "Kd"]}], ",", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"A", " ", "KA"}]}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"derived", " ", "from", " ", "equilibrium", " ", "relationships"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Consrv", "[", "eqns_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"eqns", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "+", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eqns", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "+", 
           RowBox[{"eqns", "[", 
            RowBox[{"[", "6", "]"}], "]"}], "+", 
           RowBox[{"eqns", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}]}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"eqns", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "+", 
        RowBox[{"eqns", "[", 
         RowBox[{"[", "6", "]"}], "]"}], "+", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"eqns", "[", 
           RowBox[{"[", "7", "]"}], "]"}], ")"}]}]}], "]"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
   "conservation", " ", "relations", " ", "for", " ", "RAF", " ", "and", " ", 
    "DTOT"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"eqnsconsrv", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Consrv", "[", "vars", "]"}], "/.", "rep4"}], "]"}], 
     "\[Equal]", 
     RowBox[{"{", 
      RowBox[{"RAF", ",", "DTOT"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7692042154998837`*^9, 3.7692042369245358`*^9}, {
   3.769204285127771*^9, 3.769204341657061*^9}, {3.769204538745946*^9, 
   3.769204548488737*^9}, {3.7692045887400646`*^9, 3.7692047475109215`*^9}, {
   3.769204807283332*^9, 3.7692048197677355`*^9}, {3.7692050383825026`*^9, 
   3.769205039460601*^9}, 3.7692678297233763`*^9, {3.769267866117442*^9, 
   3.769267932844144*^9}, 3.831920876102366*^9, {3.840203420465253*^9, 
   3.8402034244005575`*^9}, {3.8402034588172636`*^9, 3.840203493631587*^9}, {
   3.8402035590005283`*^9, 3.8402036105294175`*^9}, {3.840203640947667*^9, 
   3.840203652149537*^9}, 3.8402044050372953`*^9, 3.840556372264454*^9, 
   3.8405566153999057`*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"269adec3-0804-44e3-9bcc-1ca71755f339"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", "Kd", "+", 
       RowBox[{"KA", " ", "Kd"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["d", "2"], "+", 
           RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
           RowBox[{"f", " ", "g", " ", 
            SuperscriptBox["Kd", "2"]}]}], ")"}]}], 
        RowBox[{"f", " ", "g", " ", "Kd", " ", "Kdim"}]]}], ")"}]}], 
    "\[Equal]", 
    RowBox[{"Kd", " ", "RAF"}]}], ",", 
   RowBox[{
    RowBox[{"d", "+", 
     FractionBox[
      RowBox[{"A", " ", "d"}], "Kd"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["A", "2"], " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"g", " ", "Kd"}]}], ")"}]}], 
      RowBox[{"f", " ", "g", " ", 
       SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", "DTOT"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.84020358612233*^9, {3.8402036420185766`*^9, 3.840203652476896*^9}, {
   3.8402084225567703`*^9, 3.84020847107111*^9}, 3.840209416490608*^9, 
   3.840209908004015*^9, 3.840556307393776*^9, 3.840556616552673*^9, 
   3.8405622173626137`*^9, 3.8405635249126854`*^9, 3.8405636880528765`*^9, {
   3.8406523971563377`*^9, 3.840652418080085*^9}, {3.8407322676841116`*^9, 
   3.8407322787473526`*^9}, 3.8407368954723454`*^9, 3.840737683754156*^9, 
   3.8449452947548866`*^9, 3.8449657538784*^9, 3.844966247043932*^9, 
   3.85239780641673*^9, 3.852398652394961*^9, 3.8905261075755925`*^9, 
   3.890674280442261*^9, 3.890692492857328*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"7f9a85d5-4046-4704-a776-c2c095e8695e"]
}, Open  ]],

Cell["\<\
A simultaneous solution to both the above conservation equations is unwieldy \
and hard to obtain. Instead, we find partial solutions for kinase protomers \
as a function of free drug and then free drug as a function of the total drug \
and the kinase protomers. The latter solution is used to numerically \
construct d vs DTOT relationship.\
\>", "Text",
 CellChangeTimes->{{3.769268480156312*^9, 3.7692685358509054`*^9}, {
  3.769268566916627*^9, 
  3.7692686085566883`*^9}},ExpressionUUID->"3f68c915-08aa-4863-9c3f-\
a5b3502133bd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SimplifyPars", "[", "x_", "]"}], ":=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RAF", ">", "0"}], ",", 
       RowBox[{"DTOT", ">", "0"}], ",", 
       RowBox[{"Kd", ">", "0"}], ",", 
       RowBox[{"Kdim", ">", "0"}], ",", 
       RowBox[{"KA", ">", "0"}], ",", 
       RowBox[{"d", ">", "0"}], ",", 
       RowBox[{"f", ">", "0"}], ",", 
       RowBox[{"g", ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["d", "rel"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol4A", "=", 
   RowBox[{
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"eqnsconsrv", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "A"}], "]"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "  ", 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol4d", "=", 
  RowBox[{
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eqnsconsrv", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "d"}], "]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7692048471231923`*^9, 3.769204893862154*^9}, {
   3.76920497064507*^9, 3.7692050944975214`*^9}, {3.7692051323859997`*^9, 
   3.7692051514924307`*^9}, 3.7692052273412123`*^9, {3.769265303470145*^9, 
   3.7692653221119733`*^9}, {3.769265358603253*^9, 3.769265393912998*^9}, {
   3.7692654276106925`*^9, 3.769265462871611*^9}, {3.7692660477712846`*^9, 
   3.7692660513184977`*^9}, {3.7692663939422703`*^9, 
   3.7692664234293437`*^9}, {3.7692681049231358`*^9, 3.769268105891485*^9}, {
   3.7692682434167233`*^9, 3.7692682738420897`*^9}, {3.7692683203389816`*^9, 
   3.7692683654636745`*^9}, {3.769436803124284*^9, 3.7694368039228525`*^9}, {
   3.812208796618473*^9, 3.812208800884694*^9}, {3.8402036688763957`*^9, 
   3.840203717780062*^9}, 3.8402044050482736`*^9, {3.8402086149337215`*^9, 
   3.8402086163065677`*^9}, {3.8406524039042435`*^9, 3.8406524114524503`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"c7ff7298-e82f-47f0-90b8-0f1e40759a1b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"A", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"f", " ", "g", " ", "Kd", " ", "Kdim", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", "Kd", "+", 
             RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["d", "2"], "+", 
              RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
              RowBox[{"f", " ", "g", " ", 
               SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
           RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]}], ")"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "g", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, {
   3.8402084253169756`*^9, 3.840208471136625*^9}, 3.8402086172796245`*^9, 
   3.8402094196491776`*^9, 3.8402099083705187`*^9, 3.8405563078312774`*^9, 
   3.840556618554001*^9, 3.8405622177162385`*^9, 3.8405635252981243`*^9, 
   3.840563688424765*^9, {3.8406523996172123`*^9, 3.8406524210731707`*^9}, {
   3.8407322681005325`*^9, 3.840732278857686*^9}, 3.8407368959024644`*^9, 
   3.8407376838951836`*^9, 3.8449452951090145`*^9, 3.8449657543638515`*^9, 
   3.844966248866232*^9, 3.8523978096308002`*^9, 3.852398656823492*^9, 
   3.89052610840032*^9, 3.890674282728734*^9, 3.8906924944208956`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"05d812f4-a7de-4b47-a511-cb96580a21f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"g", " ", "Kd", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"]}], "+", 
        RowBox[{"A", " ", "f", " ", "Kdim"}], "+", 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["A", "2"], " ", "DTOT", " ", "f", " ", "Kdim"}], 
           "+", 
           RowBox[{"g", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["A", "2"]}], "+", 
               RowBox[{"A", " ", "f", " ", "Kdim"}], "+", 
               RowBox[{"f", " ", "Kd", " ", "Kdim"}]}], ")"}], "2"]}]}], 
          "g"]]}], ")"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["A", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, {
   3.8402084253169756`*^9, 3.840208471136625*^9}, 3.8402086172796245`*^9, 
   3.8402094196491776`*^9, 3.8402099083705187`*^9, 3.8405563078312774`*^9, 
   3.840556618554001*^9, 3.8405622177162385`*^9, 3.8405635252981243`*^9, 
   3.840563688424765*^9, {3.8406523996172123`*^9, 3.8406524210731707`*^9}, {
   3.8407322681005325`*^9, 3.840732278857686*^9}, 3.8407368959024644`*^9, 
   3.8407376838951836`*^9, 3.8449452951090145`*^9, 3.8449657543638515`*^9, 
   3.844966248866232*^9, 3.8523978096308002`*^9, 3.852398656823492*^9, 
   3.89052610840032*^9, 3.890674282728734*^9, 3.8906924946712923`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"c72c74fc-5bf6-40d8-8b84-4054a7a5f7ef"]
}, Open  ]],

Cell["\<\
We estimate the total activity by counting all of the drug-free protomers \
which occur within a partly active or fully active dimer. Substituting the \
above solution into the expression for Raf activity and dividing by total RAF \
concentration, we obtain the proportionate \[LineSeparator]activity as a \
function of total drug and other parameters.\
\>", "Text",
 CellChangeTimes->{{3.7692051569956264`*^9, 3.7692052249831033`*^9}, {
   3.7692053058924074`*^9, 3.7692053326957016`*^9}, {3.7692665900295753`*^9, 
   3.7692665948921833`*^9}, 3.7692684645670233`*^9, {3.7692686287467785`*^9, 
   3.7692686294649706`*^9}, 
   3.8523978111517706`*^9},ExpressionUUID->"3a913887-8fd8-439d-95e7-\
28c129c79fe7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RafActivity", "[", "vars_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"vars", "[", 
     RowBox[{"[", "4", "]"}], "]"}]}], " ", "+", " ", 
   RowBox[{"vars", "[", 
    RowBox[{"[", "6", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fnActiveRAF", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RafActivity", "[", "vars", "]"}], "/", "RAF"}], "/.", 
      "rep4"}], "/.", "sol4A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repratios", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kdim", "\[Rule]", 
      FractionBox["RAF", 
       SubscriptBox["RAF", "rel"]]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"Kd", " ", 
       SubscriptBox["d", "rel"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAF", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"fnActiveRAF", "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAF2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"fnActiveRAF", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "\[Rule]", "E1c"}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], "\[Rule]", 
        RowBox[{"E2u", " ", "f", " ", 
         RowBox[{
          RowBox[{"g", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", " ", "g"}], "+", 
             RowBox[{"2", "g", " ", 
              SubscriptBox["d", "rel"]}], "+", 
             SuperscriptBox[
              SubscriptBox["d", "rel"], "2"]}], ")"}]}], "/", "8"}]}]}]}], 
      "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.769205220141611*^9, 3.769205289672014*^9}, {
   3.769205345593025*^9, 3.769205353284094*^9}, {3.7692054655437536`*^9, 
   3.7692054685969486`*^9}, {3.769265526917851*^9, 3.7692655613369493`*^9}, {
   3.7692655940807266`*^9, 3.7692657331243925`*^9}, {3.7692657719746237`*^9, 
   3.769265864876149*^9}, {3.7692658997040854`*^9, 3.7692659006156936`*^9}, {
   3.769266749046686*^9, 3.769266750912019*^9}, {3.769268445259807*^9, 
   3.76926844899031*^9}, {3.769268639956765*^9, 3.769268644269384*^9}, {
   3.769268830483199*^9, 3.7692688709844255`*^9}, {3.7692689173114767`*^9, 
   3.769269038442933*^9}, {3.769269089183334*^9, 3.769269285211043*^9}, {
   3.7692695137259455`*^9, 3.7692695528466825`*^9}, {3.769269651781829*^9, 
   3.76926965421002*^9}, {3.7694368136077976`*^9, 3.7694368142564898`*^9}, {
   3.7694375986201754`*^9, 3.7694376029376187`*^9}, {3.7694382649841013`*^9, 
   3.769438269629182*^9}, {3.769439034726965*^9, 3.7694390745272303`*^9}, {
   3.812214333570692*^9, 3.812214391783123*^9}, {3.8123859575711336`*^9, 
   3.812386008423128*^9}, {3.8123860614959884`*^9, 3.8123861254690137`*^9}, 
   3.831474994890194*^9, {3.8319208702531366`*^9, 3.831920870955785*^9}, {
   3.8319211759273367`*^9, 3.8319211759273367`*^9}, {3.8319237689036894`*^9, 
   3.8319237970863533`*^9}, {3.831923844715188*^9, 3.831923850773985*^9}, {
   3.831924074308251*^9, 3.8319240757594156`*^9}, {3.840203742192509*^9, 
   3.8402039027208576`*^9}, {3.840203969207242*^9, 3.8402039799679236`*^9}, {
   3.840204018691835*^9, 3.840204049292286*^9}, 3.840208620490014*^9, {
   3.840556125640686*^9, 3.8405561283031545`*^9}, 3.840556621532282*^9, {
   3.8406524512431946`*^9, 3.840652459172752*^9}, {3.840652823634708*^9, 
   3.840652837369789*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"a79bac88-6a6e-48e0-872b-019a995410f0"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", " ", 
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "+", 
      SubscriptBox["d", "rel"], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], 
         RowBox[{"f", " ", "g"}]]}]]}], ")"}], "2"]}], 
  RowBox[{"8", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", " ", "g"}], "+", 
      RowBox[{"2", " ", "g", " ", 
       SubscriptBox["d", "rel"]}], "+", 
      SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, {3.840208455288518*^9, 
   3.8402084712106323`*^9}, 3.8402094223121557`*^9, 3.8402099121853905`*^9, 
   3.8405563102290754`*^9, 3.84055662444647*^9, 3.840562219598998*^9, 
   3.840563526960758*^9, 3.840563690214009*^9, 3.8406524691688547`*^9, {
   3.840652827519314*^9, 3.8406528378547935`*^9}, {3.8407322713626957`*^9, 
   3.8407322790738554`*^9}, 3.8407368997257347`*^9, 3.8407376842712126`*^9, 
   3.844945296810011*^9, 3.844965756152608*^9, 3.8449662512716455`*^9, 
   3.85239781523048*^9, 3.852398660528982*^9, 3.890526110997628*^9, 
   3.890674287099436*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"2f6494d2-92fa-468a-8cde-c31a999e496e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"E1c", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["E1c", "2"], "+", "E2u"}]]}], ")"}], "2"], " ", "g", 
   " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}]}], 
  RowBox[{"E2u", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", " ", "g"}], "+", 
     RowBox[{"2", " ", "g", " ", 
      SubscriptBox["d", "rel"]}], "+", 
     SubsuperscriptBox["d", "rel", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, {3.840208455288518*^9, 
   3.8402084712106323`*^9}, 3.8402094223121557`*^9, 3.8402099121853905`*^9, 
   3.8405563102290754`*^9, 3.84055662444647*^9, 3.840562219598998*^9, 
   3.840563526960758*^9, 3.840563690214009*^9, 3.8406524691688547`*^9, {
   3.840652827519314*^9, 3.8406528378547935`*^9}, {3.8407322713626957`*^9, 
   3.8407322790738554`*^9}, 3.8407368997257347`*^9, 3.8407376842712126`*^9, 
   3.844945296810011*^9, 3.844965756152608*^9, 3.8449662512716455`*^9, 
   3.85239781523048*^9, 3.852398660528982*^9, 3.890526110997628*^9, 
   3.8906742871775627`*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"1f7a588d-87f6-460f-aff8-5f9c0623fc78"]
}, Open  ]],

Cell["\<\
Note that the above equations represent the total active RAF protomers in \
proportion to the total RAF kinase as a function of unbound drug (d). In \
order to analytically establish parameter values which correspond to \
activation of the kinase, we find the first derivative of this function and \
search for it\[CloseCurlyQuote]s zeroes.\
\>", "Text",
 CellChangeTimes->{{3.8314750261787057`*^9, 3.831475036190924*^9}, {
  3.8324318762945156`*^9, 3.832431882900982*^9}, {3.890674299772274*^9, 
  3.8906743025879145`*^9}},ExpressionUUID->"63a8061e-fd9d-4bb3-aa0a-\
a783572a4eeb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RafDimers", "[", "eqns_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"eqns", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnDimers", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RafDimers", "[", "vars", "]"}], "/", "RAF"}], "/.", 
        "rep4"}], "/.", "sol4A"}], ")"}], "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"fnDimers", "/", "fnActiveRAF"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8319238615172873`*^9, 3.83192390513754*^9}, {
   3.831923943703373*^9, 3.8319239810051637`*^9}, {3.83192408057911*^9, 
   3.8319240873711205`*^9}, 3.84020440505526*^9, {3.840204452736744*^9, 
   3.840204473036141*^9}, 3.840208625048671*^9, {3.840556628223157*^9, 
   3.840556661079576*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"a844e2bf-e030-4381-96dc-475e4ff850db"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", " ", "g", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "+", 
      SubscriptBox["d", "rel"], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], 
         RowBox[{"f", " ", "g"}]]}]]}], ")"}], "2"]}], 
  RowBox[{"16", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", " ", "g"}], "+", 
     RowBox[{"2", " ", "g", " ", 
      SubscriptBox["d", "rel"]}], "+", 
     SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840208471858531*^9, 3.840209423453854*^9, 3.840209913429438*^9, 
   3.8405563114250174`*^9, {3.8405566396889153`*^9, 3.8405566614566936`*^9}, 
   3.840562220507329*^9, 3.840563527832856*^9, 3.8405636910686436`*^9, 
   3.840652578620533*^9, {3.8407322724585733`*^9, 3.840732279151969*^9}, 
   3.8407369010333624`*^9, 3.840737684517725*^9, 3.8449452979935184`*^9, 
   3.844965757086109*^9, 3.852397819523621*^9, 3.852398662420703*^9, 
   3.890526112162033*^9, 3.8906742916055098`*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"29883c21-8ce2-43f0-928d-3219e34f2093"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"f", " ", "g"}], "+", 
   RowBox[{"2", " ", "g", " ", 
    SubscriptBox["d", "rel"]}], "+", 
   SubsuperscriptBox["d", "rel", "2"]}], 
  RowBox[{
   RowBox[{"2", " ", "f", " ", "g"}], "+", 
   RowBox[{"2", " ", "g", " ", 
    SubscriptBox["d", "rel"]}]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840208471858531*^9, 3.840209423453854*^9, 3.840209913429438*^9, 
   3.8405563114250174`*^9, {3.8405566396889153`*^9, 3.8405566614566936`*^9}, 
   3.840562220507329*^9, 3.840563527832856*^9, 3.8405636910686436`*^9, 
   3.840652578620533*^9, {3.8407322724585733`*^9, 3.840732279151969*^9}, 
   3.8407369010333624`*^9, 3.840737684517725*^9, 3.8449452979935184`*^9, 
   3.844965757086109*^9, 3.852397819523621*^9, 3.852398662420703*^9, 
   3.890526112162033*^9, 3.8906742916211367`*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"0a126919-f289-40f3-ae6a-463aa6f78d3a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4.2. Baseline Signaling (drug-free)", "Subsubsection",
 CellChangeTimes->{{3.812385908612563*^9, 3.812385920080598*^9}, {
  3.833159643863964*^9, 3.8331596657361794`*^9}, {3.8406531404445868`*^9, 
  3.8406531405383387`*^9}, {3.844939115290556*^9, 
  3.844939115522788*^9}},ExpressionUUID->"a81dec3d-af14-4eef-b5c2-\
f23c62d97577"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"baselineActiveRAF", "=", 
   RowBox[{"fnActiveRAF", "/.", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", "0"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep3b", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["RAF", "rel"], "\[Rule]", 
     RowBox[{"E3", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA"}], ")"}], "2"], "/", "8"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"baselineActiveRAF1", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"baselineActiveRAF", "/.", "rep3b"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"baselineActiveRAF1", ",", "E3"}], "]"}], "/.", "rep3b"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8123859215610027`*^9, 3.812385936919848*^9}, {
   3.8123861495330424`*^9, 3.812386224346416*^9}, {3.812386278673541*^9, 
   3.812386294471064*^9}, {3.8123863259077187`*^9, 3.8123863683020535`*^9}, {
   3.8123864109056587`*^9, 3.8123864240308285`*^9}, {3.8319211091015835`*^9, 
   3.8319211176118765`*^9}, 3.8319211759429626`*^9, {3.8402045142905054`*^9, 
   3.8402045162565413`*^9}, {3.840651651834156*^9, 3.8406516611802745`*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"9bd773d7-3e17-47e0-848f-cdf55228ccf0"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", "E3"}]]}], ")"}], "2"], "E3"]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, 3.840652654930914*^9, {3.840732272543256*^9, 
   3.840732279437253*^9}, 3.840736901146335*^9, 3.852397826895773*^9, 
   3.8523986628742237`*^9, 3.890526112270384*^9, 3.890674309346922*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"3fddebc5-e142-4cb0-8cf7-ec02ce27daed"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", "E3"}]]}], ")"}], "2"], 
  RowBox[{
   SuperscriptBox["E3", "2"], " ", 
   SqrtBox[
    RowBox[{"1", "+", "E3"}]]}]]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, 3.840652654930914*^9, {3.840732272543256*^9, 
   3.840732279437253*^9}, 3.840736901146335*^9, 3.852397826895773*^9, 
   3.8523986628742237`*^9, 3.890526112270384*^9, 3.890674309363113*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"1a622938-51b1-475e-bb4d-d842fe803e79"]
}, Open  ]],

Cell["\<\
The derivative of baseline signaling relative to E3 is a positive definite \
function. Therefore, baseline signaling is a monotonically proportionate to \
E3, which is in turn, monotonically proportionate to RAF concentration and \
monotonically inverse relationship to KA.\
\>", "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
  3.812386377540579*^9, 
  3.8123864833252983`*^9}},ExpressionUUID->"11213e4d-f8c6-4296-b6b5-\
6e73de66c9dd"],

Cell[TextData[{
 "Hence in the base model, increasing KA decreases baseline signaling and \
increasing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["RAF", "rel"], " "}], TraditionalForm]],ExpressionUUID->
  "64be8e39-3a29-44bb-8c30-38a2bbb91e24"],
 " increases baseline signaling. Without drug, only autoinhibition and \
dimerization drive the activation, as validated in above expressions. "
}], "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
   3.812386377540579*^9, 3.812386508943284*^9}, 3.831493576900573*^9, {
   3.890674321587675*^9, 
   3.8906743624073267`*^9}},ExpressionUUID->"89bae1f5-d0c8-4cb3-a078-\
39ae09be6a93"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.4.3. Conditions on parameter regions for activation in response to the drug\
\>", "Subsubsection",
 CellChangeTimes->{{3.769352693017748*^9, 3.7693527442245555`*^9}, 
   3.8319232589041615`*^9, {3.833159646729958*^9, 3.833159664629573*^9}, {
   3.840653141522718*^9, 3.8406531416320944`*^9}, {3.844939116427272*^9, 
   3.844939116612567*^9}},ExpressionUUID->"6c57ebcb-dc85-49fb-a1aa-\
c8d30ff04c79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dfn4", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"fnActiveRAF", ",", 
     SubscriptBox["d", "rel"]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.755541810342499*^9, 3.7555418608619113`*^9}, {
   3.755541978622472*^9, 3.7555419807907124`*^9}, {3.7555571218326187`*^9, 
   3.7555571219456987`*^9}, {3.7556152697929463`*^9, 3.755615271368307*^9}, {
   3.755615528332312*^9, 3.7556155322520323`*^9}, {3.755615647889366*^9, 
   3.755615736790206*^9}, {3.7556192151498156`*^9, 3.7556192592915344`*^9}, {
   3.755619311851678*^9, 3.75561931599358*^9}, {3.7556396242742844`*^9, 
   3.755639637221635*^9}, {3.7590911604934464`*^9, 3.759091242876088*^9}, {
   3.759091274647378*^9, 3.759091275112709*^9}, 3.7646075097588253`*^9, {
   3.7692693888047943`*^9, 3.769269390671215*^9}, {3.7692695640617847`*^9, 
   3.7692696334602895`*^9}, {3.7692696651592636`*^9, 3.7692696859256325`*^9}, 
   3.769436826714548*^9, {3.8129938947361474`*^9, 3.8129939100528193`*^9}, 
   3.831920887884055*^9, 3.8319211759429626`*^9, 3.8402045504842486`*^9, {
   3.8405654709095154`*^9, 3.8405654709940224`*^9}, {3.840653152693887*^9, 
   3.840653156306715*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"0ec49ffb-69b9-4354-8376-09e2d5487a4f"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", " ", "g"}], "+", 
       RowBox[{"2", " ", "g", " ", 
        SubscriptBox["d", "rel"]}], "+", 
       SubsuperscriptBox["d", "rel", "2"]}], ")"}], "3"], " ", 
    SubscriptBox["RAF", "rel"]}]], 
  RowBox[{"f", " ", 
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "KA", "+", 
     SubscriptBox["d", "rel"], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"2", " ", "g", " ", 
            SubscriptBox["d", "rel"]}], "+", 
           SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
         SubscriptBox["RAF", "rel"]}], 
        RowBox[{"f", " ", "g"}]]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"f", " ", "g"}], "+", 
        RowBox[{"2", " ", "g", " ", 
         SubscriptBox["d", "rel"]}], "+", 
        SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"g", "+", 
              SubscriptBox["d", "rel"]}], ")"}], " ", 
            SubscriptBox["RAF", "rel"]}], 
           RowBox[{"f", " ", "g"}]]}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
           FractionBox[
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", " ", "g"}], "+", 
               RowBox[{"2", " ", "g", " ", 
                SubscriptBox["d", "rel"]}], "+", 
               SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
             SubscriptBox["RAF", "rel"]}], 
            RowBox[{"f", " ", "g"}]]}]]]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"g", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "KA", "+", 
        SubscriptBox["d", "rel"], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", " ", "g"}], "+", 
              RowBox[{"2", " ", "g", " ", 
               SubscriptBox["d", "rel"]}], "+", 
              SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
            SubscriptBox["RAF", "rel"]}], 
           RowBox[{"f", " ", "g"}]]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"f", " ", "g"}], "+", 
        RowBox[{"2", " ", "g", " ", 
         SubscriptBox["d", "rel"]}], "+", 
        SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "KA", "+", 
        SubscriptBox["d", "rel"], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", " ", "g"}], "+", 
              RowBox[{"2", " ", "g", " ", 
               SubscriptBox["d", "rel"]}], "+", 
              SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
            SubscriptBox["RAF", "rel"]}], 
           RowBox[{"f", " ", "g"}]]}]]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.8402045507751465`*^9, 3.840206279165141*^9, {3.840565466994125*^9, 
   3.8405654720815754`*^9}, 3.8406363071040087`*^9, 3.8406434608794775`*^9, {
   3.8406454226829123`*^9, 3.8406454367614737`*^9}, 3.840653156566115*^9, 
   3.8523978587282305`*^9, 3.852398666169172*^9, 3.890526113326406*^9, 
   3.890674364778837*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"956ae98e-bc8f-4622-92da-65c326a44960"]
}, Open  ]],

Cell[TextData[{
 "The first product term in the numerator is negative definite being of the \
form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "-", 
    RowBox[{"Sqrt", "[", 
     SuperscriptBox["x", "2"]}]}], TraditionalForm]],ExpressionUUID->
  "26e533d4-3844-48d1-9e8e-5c1cf02b7c7a"],
 "+<positive term>]. We evaluate the conditions under which the second term \
may also be negative."
}], "Text",
 CellChangeTimes->{{3.8523983119427595`*^9, 3.8523983226567388`*^9}, {
  3.8523983747205095`*^9, 3.8523984059770927`*^9}, {3.8523985509360685`*^9, 
  3.852398578199337*^9}, {3.8906743889548807`*^9, 
  3.8906743900798807`*^9}},ExpressionUUID->"a1f3a16f-ffa1-4e2a-8b8e-\
46aa676f0fbd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dfn4", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8406536389683332`*^9, 3.8406536453097773`*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"f5e8b412-80ca-4700-96eb-348b3c551309"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", " ", "g"}], "+", 
     RowBox[{"2", " ", "g", " ", 
      SubscriptBox["d", "rel"]}], "+", 
     SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"1", "+", "KA", "+", 
       SubscriptBox["d", "rel"], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{"g", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         SubscriptBox["RAF", "rel"]}], 
        RowBox[{"f", " ", "g"}]]}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], 
         RowBox[{"f", " ", "g"}]]}]]]}], ")"}]}], "-", 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"g", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "KA", "+", 
     SubscriptBox["d", "rel"], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"2", " ", "g", " ", 
            SubscriptBox["d", "rel"]}], "+", 
           SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
         SubscriptBox["RAF", "rel"]}], 
        RowBox[{"f", " ", "g"}]]}]]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", " ", "g"}], "+", 
     RowBox[{"2", " ", "g", " ", 
      SubscriptBox["d", "rel"]}], "+", 
     SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "KA", "+", 
     SubscriptBox["d", "rel"], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA", "+", 
          SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"2", " ", "g", " ", 
            SubscriptBox["d", "rel"]}], "+", 
           SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
         SubscriptBox["RAF", "rel"]}], 
        RowBox[{"f", " ", "g"}]]}]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.840653641607397*^9, 3.8406536455871997`*^9}, 
   3.852398668221568*^9, 3.8905261134206057`*^9, 3.890674365512555*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"7699d386-997f-48c4-9bac-023bf440b991"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rd4", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"dfn4", "[", 
      RowBox[{"[", 
       RowBox[{"-", "1"}], "]"}], "]"}], "<", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"existPA4", "=", 
  RowBox[{"SimplifyPars", "[", "rd4", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8406454416015234`*^9, 3.840645455094884*^9}, {
  3.840645527623123*^9, 3.840645548071183*^9}, {3.8406455793475046`*^9, 
  3.8406455802647233`*^9}, {3.840645730738617*^9, 3.8406457329731913`*^9}, {
  3.8406466256361165`*^9, 3.8406466256983*^9}, {3.840653161216005*^9, 
  3.840653171664316*^9}, {3.8406535919502687`*^9, 3.840653602892721*^9}, {
  3.8406536522058964`*^9, 3.84065365294055*^9}, {3.852399744664355*^9, 
  3.8523997453004875`*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"20e63737-d488-4c67-bded-3adbd8c6c570"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "+", "KA"}], ">", 
   RowBox[{
    RowBox[{"2", " ", "f"}], "+", 
    SubscriptBox["d", "rel"]}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "\[Equal]", "1"}], "&&", 
      RowBox[{
       SubscriptBox["RAF", "rel"], "<", 
       FractionBox[
        RowBox[{"f", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"]}], "-", 
              RowBox[{"8", " ", "f", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "8"}], " ", 
               SuperscriptBox["f", "2"], " ", "KA"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", "KA"}], ")"}], "2"]}], "+", 
              RowBox[{"f", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "6"}], "-", 
                 RowBox[{"2", " ", "KA"}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["KA", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SubscriptBox["d", "rel"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "f", "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"]}], "-", 
              RowBox[{"2", " ", "KA"}], "+", 
              RowBox[{"8", " ", "f", " ", "KA"}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["KA", "2"]}]}], ")"}], " ", 
            SubsuperscriptBox["d", "rel", "2"]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "f"}], "+", "KA"}], ")"}], " ", 
            SubsuperscriptBox["d", "rel", "3"]}], "-", 
           SubsuperscriptBox["d", "rel", "4"]}], ")"}]}], 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{"2", " ", "f", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                SuperscriptBox["f", "2"]}], "-", 
               RowBox[{"8", " ", "f", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "KA"}], ")"}]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["f", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "KA"}], ")"}]}], "+", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
               RowBox[{"f", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "4"}], "-", 
                  RowBox[{"3", " ", "KA"}], "+", 
                  SuperscriptBox["KA", "2"]}], ")"}]}]}], ")"}], " ", 
             SubscriptBox["d", "rel"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"5", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["f", "2"]}], "+", 
               RowBox[{"2", " ", "KA"}], "-", 
               RowBox[{"3", " ", 
                SuperscriptBox["KA", "2"]}], "+", 
               RowBox[{"f", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "6"}], "+", 
                  RowBox[{"8", " ", "KA"}]}], ")"}]}]}], ")"}], " ", 
             SubsuperscriptBox["d", "rel", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"2", " ", "f"}], "+", "KA"}], ")"}], " ", 
             SubsuperscriptBox["d", "rel", "3"]}], "+", 
            SubsuperscriptBox["d", "rel", "4"]}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f"}], "+", 
             RowBox[{"2", " ", "f", " ", 
              SubscriptBox["d", "rel"]}], "+", 
             SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]], "+", 
        SubscriptBox["RAF", "rel"]}], "<", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["RAF", "rel"], "<", 
       FractionBox[
        RowBox[{"f", " ", "g", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "f"}], "-", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "g", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "f"}], "-", 
              RowBox[{"3", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "f", " ", "g"}], "-", 
              RowBox[{"4", " ", "f", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}], "-", 
              RowBox[{"2", " ", "g", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}]}], ")"}], " ", 
            SubscriptBox["d", "rel"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "f"}], "-", 
              RowBox[{"2", " ", "g"}], "+", 
              RowBox[{"3", " ", "KA"}]}], ")"}], " ", 
            SubsuperscriptBox["d", "rel", "2"]}], "-", 
           SubsuperscriptBox["d", "rel", "3"]}], ")"}]}], 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"2", " ", "f", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "<", "g", "<", "2"}], "||", 
        RowBox[{"g", "<", "1"}], "||", 
        RowBox[{"g", ">", "2"}]}], ")"}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.840645451202583*^9, 3.8406454743784385`*^9}, {
   3.8406455405860806`*^9, 3.840645584502401*^9}, 3.8406457387303486`*^9, 
   3.840646627375697*^9, 3.840653585494299*^9, 3.8406536362316313`*^9, 
   3.8406539576410646`*^9, 3.8406651986848845`*^9, 3.8523997040457554`*^9, 
   3.852400778203678*^9, 3.8905266636248794`*^9, 3.8906750333447523`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"90431863-1b8b-4e65-8966-511e92303ad2"]
}, Open  ]],

Cell["\<\
Conditions for positive derivative of active RAF relative to unbound drug are \
shown above.\
\>", "Text",
 CellChangeTimes->{{3.8406455159354043`*^9, 3.8406455226362214`*^9}, {
   3.840645586307036*^9, 3.8406455955655184`*^9}, {3.840645694674875*^9, 
   3.840645725719434*^9}, {3.8406457620525007`*^9, 3.840645769791148*^9}, 
   3.840705971028569*^9},ExpressionUUID->"b0bc8c19-8f15-4c90-be43-\
77a7a9dfaa10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"existPAU", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"existPA4", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"g", ">=", "1"}], ",", 
      RowBox[{"f", "<=", "1"}], ",", 
      RowBox[{"f", ">", "0"}], ",", 
      RowBox[{"KA", ">=", "1"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8406457392856026`*^9, 3.840645782502263*^9}, {
  3.840653311968548*^9, 3.8406533174525733`*^9}, {3.840705923352321*^9, 
  3.8407059523105507`*^9}, {3.8407059901571007`*^9, 3.8407060226713657`*^9}, {
  3.840706070880514*^9, 3.840706084272894*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"37d291df-e62f-4f18-91c8-4bf0388ff618"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "+", "KA"}], ">", 
   RowBox[{
    RowBox[{"2", " ", "f"}], "+", 
    SubscriptBox["d", "rel"]}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "\[Equal]", "1"}], "&&", 
      RowBox[{
       SubscriptBox["RAF", "rel"], "<", 
       FractionBox[
        RowBox[{"f", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "f"}], "-", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "f"}], "-", 
              RowBox[{"3", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SubscriptBox["d", "rel"], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "f", "+", 
              RowBox[{"2", " ", "KA"}], "+", 
              RowBox[{"4", " ", "f", " ", "KA"}], "+", 
              RowBox[{
               SubscriptBox["d", "rel"], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"2", " ", "f"}], "+", 
                 RowBox[{"3", " ", "KA"}], "+", 
                 SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{"2", " ", "f", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "\[Equal]", "2"}], "&&", 
      RowBox[{
       SubscriptBox["RAF", "rel"], "<", 
       FractionBox[
        RowBox[{"f", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "f"}], "-", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "f", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "f"}], "-", 
              RowBox[{"3", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SubscriptBox["d", "rel"], " ", 
            RowBox[{"(", 
             RowBox[{"4", "-", 
              RowBox[{"2", " ", "f"}], "+", 
              RowBox[{"4", " ", "KA"}], "+", 
              RowBox[{"4", " ", "f", " ", "KA"}], "+", 
              RowBox[{
               SubscriptBox["d", "rel"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"2", " ", "f"}], "+", 
                 RowBox[{"3", " ", "KA"}], "+", 
                 SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f"}], "+", 
            RowBox[{"2", " ", "f", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["RAF", "rel"], "<", 
       FractionBox[
        RowBox[{"f", " ", "g", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "f"}], "-", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "g", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "f"}], "-", 
              RowBox[{"3", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SubscriptBox["d", "rel"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "g", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "KA"}], ")"}]}], "+", 
              RowBox[{"f", " ", 
               RowBox[{"(", 
                RowBox[{"4", "-", 
                 RowBox[{"3", " ", "g"}], "+", 
                 RowBox[{"4", " ", "KA"}]}], ")"}]}], "+", 
              RowBox[{
               SubscriptBox["d", "rel"], " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "f"}], "-", 
                 RowBox[{"2", " ", "g"}], "+", 
                 RowBox[{"3", " ", "KA"}], "+", 
                 SubscriptBox["d", "rel"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"2", " ", "f", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"]}]]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "<", "g", "<", "2"}], "||", 
        RowBox[{"g", ">", "2"}]}], ")"}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.840645752771097*^9, 3.840645784349844*^9, 3.840646629158352*^9, 
   3.8406651997217007`*^9, {3.840705926051515*^9, 3.8407059410237875`*^9}, 
   3.840705975739455*^9, 3.840706055882402*^9, 3.8407061538664236`*^9, 
   3.8523997432917495`*^9, 3.8524008011894474`*^9, 3.890675073261403*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"76d6120d-f475-44ca-b1ba-83b26200c421"]
}, Open  ]],

Cell["\<\
The above condition is quite complex and dependent strongly on the drug \
concentration. \
\>", "Text",
 CellChangeTimes->{{3.8406457864258285`*^9, 3.8406459081496286`*^9}, {
  3.8406467104769263`*^9, 3.840646721580673*^9}, {3.840706290557987*^9, 
  3.840706322737523*^9}},ExpressionUUID->"03b3db4d-4e5a-445f-a265-\
0c009639e965"],

Cell[TextData[{
 "Also, the smallest value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["d", "rel"], " "}], TraditionalForm]],ExpressionUUID->
  "db822ed9-be88-456d-9184-5bf46c5f9214"],
 "is 0, corresponding to which a condition can be set upon f and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["RAF", "rel"], TraditionalForm]],ExpressionUUID->
  "e564699c-7962-4b2e-b3a9-f4958c2a3718"],
 " for PA to exist."
}], "Text",
 CellChangeTimes->{{3.84064781351019*^9, 
  3.8406478681240215`*^9}},ExpressionUUID->"4e587fb5-1dd8-4723-9f17-\
73e904ebe161"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"existPAU0", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"existPAU", "/.", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.840647871773096*^9, 3.840647885753196*^9}, {
  3.840706361453478*^9, 3.840706371523197*^9}, {3.8407065837701473`*^9, 
  3.8407065869055185`*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"af5f0fe1-e781-4280-aa34-572a98187c30"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", "KA"}], "+", 
      SubscriptBox["RAF", "rel"]}], ")"}]}], "<", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["f", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}]}], "&&", 
  RowBox[{
   RowBox[{"1", "+", "KA"}], ">", 
   RowBox[{"2", " ", "f"}]}]}]], "Output",
 CellChangeTimes->{
  3.840706372231301*^9, 3.840706588042333*^9, 3.8523997439291487`*^9, {
   3.8524008014025035`*^9, 3.8524008113854494`*^9}, 3.8906750734801693`*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"011c004d-4e7b-4343-854f-0faae51c82c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"existPAU0", ",", 
   SubscriptBox["RAF", "rel"]}], "]"}]], "Input",
 CellChangeTimes->{{3.852400834914572*^9, 3.8524008865955963`*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"8d13bbb0-a043-4edb-adcd-7e6e0ec2d45f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"KA", "\[Element]", 
   TemplateBox[{},
    "Reals"]}], "&&", 
  RowBox[{"g", "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{"f", "<", 
   FractionBox[
    RowBox[{"1", "+", "KA"}], "2"]}], "&&", 
  RowBox[{
   SubscriptBox["RAF", "rel"], "<", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      RowBox[{"8", " ", "f"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["f", "2"]}], "+", 
      RowBox[{"6", " ", "KA"}], "-", 
      RowBox[{"8", " ", "f", " ", "KA"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["KA", "2"]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{{3.8524008714034233`*^9, 3.852400886952106*^9}, 
   3.890675073589845*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"7915bed4-855c-4f00-bc66-fa8553eefafb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"(", 
    RowBox[{"3", "-", 
     RowBox[{"8", " ", "f"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["f", "2"]}], "+", 
     RowBox[{"6", " ", "KA"}], "-", 
     RowBox[{"8", " ", "f", " ", "KA"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["KA", "2"]}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8407067120784683`*^9, 3.8407068022338853`*^9}, {
  3.8524009102640743`*^9, 3.852400918715297*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"9b902620-3fe2-4528-bc25-24030b547d3b"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["f", "2"]}], "-", 
    RowBox[{"8", " ", "f", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "KA"}], ")"}]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8407067336063185`*^9, 3.8407067504089966`*^9}, {
   3.8407067834096837`*^9, 3.8407068025300713`*^9}, 3.852399744264294*^9, 
   3.852400801596622*^9, 3.852400919253792*^9, 3.8906750737305098`*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"1284dd60-948e-4337-9758-795755b35f8b"]
}, Open  ]],

Cell["\<\
Since PA is experimentally observed  at smaller values for the drug (in other \
words, inhibition then activation phenotype is not observed in dose \
response), the derivative of active RAF limiting to zero drug concentration \
can only be positive if above conditions are satisfied.\
\>", "Text",
 CellChangeTimes->{{3.8406478942792416`*^9, 3.8406479883789563`*^9}, {
  3.8906744314488497`*^9, 
  3.8906744704565697`*^9}},ExpressionUUID->"b194a8cd-acf4-44fe-a3ef-\
ac11a896d770"],

Cell["\<\
However, when the above conditions are satisfied, will PA always exist? Yes. \
\>", "Text",
 CellChangeTimes->{{3.840648878693261*^9, 
  3.840648913571316*^9}},ExpressionUUID->"aa198fa3-b5e4-4218-952c-\
10a327ebe85d"],

Cell["\<\
Can PA exist even when above conditions are not satisfied? That is the first \
derivative of active raf relative to drug is negative near zero drug but then \
becomes positive? And then negative again (since high drug conc have to go to \
zero)? - the possibility cannot be ruled out at this stage. \
\>", "Text",
 CellChangeTimes->{{3.840648878693261*^9, 
  3.8406490237229977`*^9}},ExpressionUUID->"a517b73d-d2bf-4f81-a74f-\
2bf3a352fe37"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.4.4. Monotonic relationship between unbound (d) and total (DTOT) drug \
concentrations\
\>", "Subsubsection",
 CellChangeTimes->{{3.7692694343293085`*^9, 3.76926946891394*^9}, 
   3.7692701230017385`*^9, {3.769436773797412*^9, 3.7694367744539824`*^9}, 
   3.8319232632660522`*^9, {3.833159649860316*^9, 3.8331596633192616`*^9}, {
   3.840653142491212*^9, 3.840653142553959*^9}, {3.844939117213809*^9, 
   3.844939117414105*^9}},ExpressionUUID->"9ed3376b-0dce-4d26-b408-\
009d9a7609d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqnsconsrv", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8406493185496225`*^9, 3.8406493229729967`*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"8fd7da1d-5429-420a-9409-d6b58ae28166"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "+", 
   FractionBox[
    RowBox[{"A", " ", "d"}], "Kd"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["A", "2"], " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"g", " ", "Kd"}]}], ")"}]}], 
    RowBox[{"f", " ", "g", " ", 
     SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", 
  "DTOT"}]], "Output",
 CellChangeTimes->{{3.8406493203772135`*^9, 3.8406493232503595`*^9}, 
   3.840654000311644*^9, 3.852399744469811*^9, 3.890675073824608*^9},
 CellLabel->
  "Out[171]=",ExpressionUUID->"b7b46eb8-4c87-4bd2-889d-595b179909ad"]
}, Open  ]],

Cell["\<\
The derivative of the function DTOT relative to d is the sum of the \
derivative of different terms within the second equation in expression above. \
Among these the derivative of the first term is 1. And the derivative of the \
second and third term are shown as non-negative functions of unbound drug d, \
below.\
\>", "Text",
 CellChangeTimes->{{3.8320850810009933`*^9, 3.8320851682942505`*^9}, {
  3.8406493515681677`*^9, 
  3.8406493647694645`*^9}},ExpressionUUID->"b58f3a2e-d880-45c9-a322-\
35f0813ed990"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd11", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"A", "*", "d"}], "/.", "sol4A"}], ",", "d"}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd11", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd11", "<", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", "rd11", "]"}]}], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.812209716555067*^9}, 3.840204651633864*^9, {3.8406490428350587`*^9, 
   3.8406490754211674`*^9}, {3.840649109957098*^9, 3.8406491183726187`*^9}, {
   3.840654011434971*^9, 3.8406540120602393`*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"c6dcbb55-aa15-42dc-b7e7-cdc08eb8cbc7"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.840204662010409*^9, 3.840206479673562*^9, {3.840649038833641*^9, 
   3.8406490791421223`*^9}, {3.8406491113870277`*^9, 3.840649120376279*^9}, 
   3.8406540077829075`*^9, 3.8406540456516104`*^9, 3.852399770134286*^9, 
   3.8906751137937512`*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"102f21af-9c4d-4d95-a8b5-d9da1f02babf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sd12", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["A", "2"], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"g", " ", "Kd"}]}], ")"}]}], "/.", "sol4A"}], "]"}], ",", 
     "d"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.8122097406433277`*^9}, {3.812209825300347*^9, 3.8122098312563896`*^9}, {
   3.812209894920068*^9, 3.812209908923931*^9}, {3.812210163614968*^9, 
   3.8122102029627514`*^9}, 3.8129943016148033`*^9, {3.832085249170616*^9, 
   3.832085251410651*^9}, {3.8320853702376328`*^9, 3.8320853722836037`*^9}, {
   3.832085440475006*^9, 3.8320854515514917`*^9}, {3.8406491281449385`*^9, 
   3.8406491378230104`*^9}, {3.840654063800126*^9, 3.8406540695051517`*^9}},
 CellLabel->
  "In[175]:=",ExpressionUUID->"18d77e13-d91a-447d-8207-cd3921755cba"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "+", 
       RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
       RowBox[{"f", " ", "g", " ", 
        SuperscriptBox["Kd", "2"]}]}], ")"}], "3"]}]], 
  RowBox[{
   SuperscriptBox["f", "2"], " ", 
   SuperscriptBox["g", "2"], " ", 
   SuperscriptBox["Kd", "2"], " ", 
   SuperscriptBox["Kdim", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", "Kd", "+", 
     RowBox[{"KA", " ", "Kd"}], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"d", "+", "Kd", "+", 
          RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["d", "2"], "+", 
           RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
           RowBox[{"f", " ", "g", " ", 
            SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
        RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"g", " ", "Kd"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "g", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"d", "+", "Kd", "+", 
          RowBox[{"KA", " ", "Kd"}], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"g", " ", "Kd"}]}], ")"}], " ", "RAF"}], 
           RowBox[{"f", " ", "g", " ", "Kdim"}]]}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"d", "+", "Kd", "+", 
              RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
           FractionBox[
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["d", "2"], "+", 
               RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
               RowBox[{"f", " ", "g", " ", 
                SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
            RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]]}], ")"}]}], "-", 
     RowBox[{"4", " ", "d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"g", " ", "Kd"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", "Kd", "+", 
             RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["d", "2"], "+", 
              RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
              RowBox[{"f", " ", "g", " ", 
               SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
           RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]}], ")"}]}], "+", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "g", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", "Kd", "+", 
             RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["d", "2"], "+", 
              RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
              RowBox[{"f", " ", "g", " ", 
               SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
           RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"g", " ", "Kd"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "g", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", "Kd", "+", 
             RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["d", "2"], "+", 
              RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
              RowBox[{"f", " ", "g", " ", 
               SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
           RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.8406491382272882`*^9, {3.8406540658348675`*^9, 3.840654071505348*^9}, 
   3.8906751154815207`*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"e3a7b0b3-49bc-49df-a9b5-9e8bc8d2a5d2"]
}, Open  ]],

Cell["\<\
Note that the first non-trivial product term in this expression is negative \
definite as the term inside the square root is always greater than the term \
outside. So we focus on the second term.\
\>", "Text",
 CellChangeTimes->{{3.832085456271301*^9, 
  3.8320855058848753`*^9}},ExpressionUUID->"7c2ee777-60f7-454c-bf56-\
ba693d761c64"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd121", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"sd12", "[", 
     RowBox[{"[", 
      RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd12", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd121", ">", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", "rd12", "]"}]}], "Input",
 CellChangeTimes->{{3.8320855104825225`*^9, 3.832085576939461*^9}, 
   3.8320856157697144`*^9, {3.832085673481617*^9, 3.832085684156937*^9}, {
   3.8406492934872203`*^9, 3.840649294199462*^9}, 3.840654341117176*^9},
 CellLabel->
  "In[176]:=",ExpressionUUID->"a83bee54-19f7-431f-804c-03de4a22a0b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"RAF", "<", 
     FractionBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", " ", 
          RowBox[{"(", 
           RowBox[{"g", "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "KA"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"g", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "KA"}], ")"}], " ", "Kd"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "g"}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "KA"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{"4", " ", "f"}], "+", 
            RowBox[{"2", " ", "g"}], "-", 
            RowBox[{"3", " ", "KA"}]}], ")"}], " ", "Kd"}], "+", 
         RowBox[{"d", " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "g", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "KA"}], ")"}]}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", "g"}], "+", 
               RowBox[{"2", " ", "KA"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["Kd", "2"]}], "+", 
         RowBox[{"f", " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "KA"}], ")"}], " ", 
          SuperscriptBox["Kd", "3"]}]}], ")"}], " ", "Kdim"}], 
      RowBox[{"8", " ", "g", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["d", "2"], "+", 
          RowBox[{"2", " ", "d", " ", "f", " ", "Kd"}], "+", 
          RowBox[{"f", " ", "g", " ", 
           SuperscriptBox["Kd", "2"]}]}], ")"}], "2"]}]]}], "&&", 
    RowBox[{"g", "\[NotEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{"2", " ", "g"}], "\[NotEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{"2", " ", "g"}], "\[NotEqual]", "3"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"g", " ", 
          SuperscriptBox["Kd", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "d", " ", 
             RowBox[{"(", 
              RowBox[{"f", "-", "g"}], ")"}]}], "+", 
            RowBox[{"f", " ", "g", " ", "Kd"}]}], ")"}]}], ">", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "d"}], "+", 
            RowBox[{"3", " ", "g", " ", "Kd"}]}], ")"}]}]}], "&&", 
        RowBox[{"KA", "<", 
         FractionBox[
          RowBox[{
           RowBox[{
            SuperscriptBox["d", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              RowBox[{"3", " ", "g"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["d", "2"], " ", "g", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"4", " ", "f"}], "+", 
              RowBox[{"2", " ", "g"}]}], ")"}], " ", "Kd"}], "+", 
           RowBox[{"d", " ", "g", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "g"}], "+", 
              RowBox[{"f", " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{"3", " ", "g"}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox["Kd", "2"]}], "+", 
           RowBox[{"f", " ", 
            SuperscriptBox["g", "2"], " ", 
            SuperscriptBox["Kd", "3"]}]}], 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["d", "3"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["d", "2"], " ", "g", " ", "Kd"}], "+", 
           RowBox[{"2", " ", "d", " ", "g", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "f"}], "+", "g"}], ")"}], " ", 
            SuperscriptBox["Kd", "2"]}], "-", 
           RowBox[{"f", " ", 
            SuperscriptBox["g", "2"], " ", 
            SuperscriptBox["Kd", "3"]}]}]]}]}], ")"}], "||", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "KA"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "d"}], "+", 
          RowBox[{"g", " ", "Kd"}]}], ")"}]}], "<", 
       RowBox[{"d", " ", "g"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"f", ">", 
     FractionBox[
      RowBox[{"2", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"]}], "+", 
         RowBox[{"3", " ", "d", " ", "Kd"}], "+", 
         SuperscriptBox["Kd", "2"]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["Kd", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "d"}], "+", "Kd"}], ")"}]}]]}], "&&", 
    RowBox[{
     RowBox[{"2", " ", "g"}], "\[Equal]", "1"}], "&&", 
    RowBox[{"RAF", "<", 
     FractionBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "d"}], "+", 
         RowBox[{"4", " ", "d", " ", "KA"}], "+", "Kd", "+", 
         RowBox[{"KA", " ", "Kd"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"8", " ", "KA"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["d", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"4", " ", "f"}], "+", 
            RowBox[{"3", " ", "KA"}]}], ")"}], " ", "Kd"}], "+", 
         RowBox[{"d", " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"7", " ", "f"}], "+", 
            RowBox[{"2", " ", "KA"}], "-", 
            RowBox[{"4", " ", "f", " ", "KA"}]}], ")"}], " ", 
          SuperscriptBox["Kd", "2"]}], "-", 
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "KA"}], ")"}], " ", 
          SuperscriptBox["Kd", "3"]}]}], ")"}], " ", "Kdim"}], 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["d", "2"]}], "+", 
          RowBox[{"4", " ", "d", " ", "f", " ", "Kd"}], "+", 
          RowBox[{"f", " ", 
           SuperscriptBox["Kd", "2"]}]}], ")"}], "2"]}]]}], "&&", 
    RowBox[{"KA", "<", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["d", "3"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["d", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "f"}]}], ")"}], " ", "Kd"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{"7", " ", "f"}]}], ")"}], " ", 
        SuperscriptBox["Kd", "2"]}], "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["Kd", "3"]}]}], 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["d", "3"]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["d", "2"], " ", "Kd"}], "+", 
       RowBox[{"2", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "f"}]}], ")"}], " ", 
        SuperscriptBox["Kd", "2"]}], "-", 
       RowBox[{"f", " ", 
        SuperscriptBox["Kd", "3"]}]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["Kd", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "f"}], ")"}]}], "+", 
        RowBox[{"f", " ", "Kd"}]}], ")"}]}], ">", 
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "d"}], "+", 
        RowBox[{"3", " ", "Kd"}]}], ")"}]}]}], "&&", 
    RowBox[{"g", "\[Equal]", "1"}], "&&", 
    RowBox[{"RAF", "<", 
     FractionBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"2", " ", "d", " ", "KA"}], "+", "Kd", "+", 
         RowBox[{"KA", " ", "Kd"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "KA"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"4", " ", "f"}], "+", 
            RowBox[{"3", " ", "KA"}]}], ")"}], " ", "Kd"}], "+", 
         RowBox[{"d", " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"5", " ", "f"}], "+", 
            RowBox[{"2", " ", "KA"}], "-", 
            RowBox[{"2", " ", "f", " ", "KA"}]}], ")"}], " ", 
          SuperscriptBox["Kd", "2"]}], "-", 
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "KA"}], ")"}], " ", 
          SuperscriptBox["Kd", "3"]}]}], ")"}], " ", "Kdim"}], 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["d", "2"], "+", 
          RowBox[{"2", " ", "d", " ", "f", " ", "Kd"}], "+", 
          RowBox[{"f", " ", 
           SuperscriptBox["Kd", "2"]}]}], ")"}], "2"]}]]}], "&&", 
    RowBox[{"KA", "<", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", "Kd"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["d", "2"], "+", 
         RowBox[{"2", " ", "d", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "f"}]}], ")"}], " ", "Kd"}], "+", 
         RowBox[{"f", " ", 
          SuperscriptBox["Kd", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["d", "3"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["d", "2"], " ", "Kd"}], "-", 
       RowBox[{"2", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "f"}], ")"}], " ", 
        SuperscriptBox["Kd", "2"]}], "-", 
       RowBox[{"f", " ", 
        SuperscriptBox["Kd", "3"]}]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["Kd", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{"4", " ", "f"}]}], ")"}]}], "+", 
        RowBox[{"3", " ", "f", " ", "Kd"}]}], ")"}]}], ">", 
     RowBox[{"2", " ", 
      SuperscriptBox["d", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "d"}], "+", 
        RowBox[{"9", " ", "Kd"}]}], ")"}]}]}], "&&", 
    RowBox[{
     RowBox[{"2", " ", "g"}], "\[Equal]", "3"}], "&&", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"4", " ", "d", " ", "KA"}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "KA"}], ")"}], " ", "Kd"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["d", "3"], " ", 
           RowBox[{"(", 
            RowBox[{"10", "-", 
             RowBox[{"8", " ", "KA"}]}], ")"}]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["d", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "f"}], "-", 
             RowBox[{"3", " ", "KA"}]}], ")"}], " ", "Kd"}], "+", 
          RowBox[{"3", " ", "d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "6"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "KA"}], ")"}]}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{"13", "+", 
                RowBox[{"4", " ", "KA"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["Kd", "2"]}], "+", 
          RowBox[{"9", " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "KA"}], ")"}], " ", 
           SuperscriptBox["Kd", "3"]}]}], ")"}], " ", "Kdim"}], 
       RowBox[{"24", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["d", "2"]}], "+", 
           RowBox[{"4", " ", "d", " ", "f", " ", "Kd"}], "+", 
           RowBox[{"3", " ", "f", " ", 
            SuperscriptBox["Kd", "2"]}]}], ")"}], "2"]}]], "+", "RAF"}], "<", 
     "0"}], "&&", 
    RowBox[{"KA", "<", 
     FractionBox[
      RowBox[{
       RowBox[{"10", " ", 
        SuperscriptBox["d", "3"]}], "+", 
       RowBox[{"24", " ", 
        SuperscriptBox["d", "2"], " ", "f", " ", "Kd"}], "+", 
       RowBox[{"3", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "6"}], "+", 
          RowBox[{"13", " ", "f"}]}], ")"}], " ", 
        SuperscriptBox["Kd", "2"]}], "+", 
       RowBox[{"9", " ", "f", " ", 
        SuperscriptBox["Kd", "3"]}]}], 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["d", "3"]}], "+", 
       RowBox[{"18", " ", 
        SuperscriptBox["d", "2"], " ", "Kd"}], "-", 
       RowBox[{"6", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", "f"}]}], ")"}], " ", 
        SuperscriptBox["Kd", "2"]}], "-", 
       RowBox[{"9", " ", "f", " ", 
        SuperscriptBox["Kd", "3"]}]}]]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8406492925583153`*^9, 3.8406493056123333`*^9}, 
   3.840654338643058*^9, 3.8406565773452053`*^9, 3.890676447229206*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"c9523fc5-6572-4da2-948d-ec3f4953f8a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"rd12", "&&", "existPAU0"}], "]"}]], "Input",
 CellChangeTimes->{{3.8906748943502445`*^9, 3.8906749184031477`*^9}, 
   3.8906895586689777`*^9, {3.8906897475383444`*^9, 3.8906897830246706`*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"3683d30c-a9fb-4d02-b2fc-5ee6eff1f92f"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.89068954950321*^9, 3.890689745959859*^9, 
  3.8906897772064943`*^9, 3.890689845313031*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"edfcbebb-b169-43a7-9be4-9806dcc5a849"]
}, Open  ]],

Cell["rd12 needs more detailed analysis.", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211189353238*^9}, {3.832085645561462*^9, 3.8320857371734977`*^9}, {
  3.8406494312123423`*^9, 3.8406494964348993`*^9}, {3.8407058224008303`*^9, 
  3.840705830448329*^9}},ExpressionUUID->"34af0427-1731-459a-a026-\
8724520095ba"],

Cell["DTOT=d+sd11+sd12", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211207502667*^9}},ExpressionUUID->"70e66af9-0a71-422d-b794-\
7ef770cdda29"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fnDTOT", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"eqnsconsrv", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "/.", "rep4"}], "/.", "sol4A"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7585572574558153`*^9, 3.7585573278649125`*^9}, {
   3.759595163226753*^9, 3.7595951983626966`*^9}, {3.759600640284622*^9, 
   3.7596006451030445`*^9}, 3.7646075104463263`*^9, {3.7646202269105544`*^9, 
   3.764620227426238*^9}, {3.7692714662387505`*^9, 3.7692714835925064`*^9}, {
   3.76927153667768*^9, 3.769271545331811*^9}, 3.769436866848941*^9, 
   3.840206492524761*^9, {3.8406495109769974`*^9, 3.8406495537697053`*^9}, {
   3.84065410700562*^9, 3.8406541144896355`*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"c231e28d-407f-40af-8a47-94242b64621a"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", "d", " ", 
  RowBox[{"(", 
   RowBox[{"8", "-", 
    FractionBox[
     RowBox[{"2", " ", "f", " ", "g", " ", "Kdim", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", "Kd", "+", 
             RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["d", "2"], "+", 
              RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
              RowBox[{"f", " ", "g", " ", 
               SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
           RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["d", "2"], "+", 
      RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
      RowBox[{"f", " ", "g", " ", 
       SuperscriptBox["Kd", "2"]}]}]], "+", 
    FractionBox[
     RowBox[{"f", " ", "g", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"g", " ", "Kd"}]}], ")"}], " ", "Kdim", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"d", "+", "Kd", "+", 
         RowBox[{"KA", " ", "Kd"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"d", "+", "Kd", "+", 
              RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"], "+", 
           FractionBox[
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["d", "2"], "+", 
               RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
               RowBox[{"f", " ", "g", " ", 
                SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "RAF"}], 
            RowBox[{"f", " ", "g", " ", "Kdim"}]]}]]}], ")"}], "2"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "g", " ", 
         SuperscriptBox["Kd", "2"]}]}], ")"}], "2"]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8406495156370397`*^9, 3.8406495540664597`*^9}, 
   3.8406565814725723`*^9, 3.8407058396186967`*^9, 3.8906764476679277`*^9},
 CellLabel->
  "Out[179]=",ExpressionUUID->"b1118c7c-1b40-42cc-876a-43ae06d24a91"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Sty", "[", "x_", "]"}], ":=", 
   RowBox[{"Style", "[", 
    RowBox[{"x", ",", "20", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KTarr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}], ",", 
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], ",", 
     RowBox[{"1.", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kdarr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kd", "\[Rule]", " ", 
      RowBox[{"1.", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], " ", ",", 
     RowBox[{"Kd", "\[Rule]", " ", 
      RowBox[{"1.", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pltfn", "=", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"fnDTOT", "/.", "kd"}], ",", 
       RowBox[{"{", 
        RowBox[{"kd", ",", "kdarr"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"RAF", ",", "KTarr"}], "}"}]}], "]"}], "]"}], "/.", 
    "baseparams"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ps", "=", 
   RowBox[{"{", 
    RowBox[{"Blue", ",", "Green", ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Thick"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Blue", ",", "Dashed"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Green", ",", "Dashed"}], "]"}], ",", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Dashed", ",", "Thick"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LogLogPlot", "[", 
  RowBox[{"pltfn", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "9"}]], ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "5"}]]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "20"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "ps"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Green", ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"Sty", "/@", "KTarr"}], ",", 
        RowBox[{"LegendLabel", "\[Rule]", 
         RowBox[{"Sty", "[", "\"\<RAF(M)\>\"", "]"}]}], ",", 
        RowBox[{"LegendFunction", "\[Rule]", "Panel"}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", "12"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"Sty", "/@", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Unbound Drug [d] (M)\>\"", ",", "\"\<Total Drug [DTOT] (M)\>\""}],
        "}"}]}], ")"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", "500", "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "0.004", "]"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{
    "Sty", "[", 
     "\"\<\!\(\*SubscriptBox[\(K\), \(d\)]\): \[LongDash]100nM  - -1nM \
\!\(\*SubscriptBox[\(K\), \(A\)]\):10\>\"", "]"}]}]}], 
  RowBox[{"(*", 
   RowBox[{"N", "[", 
    RowBox[{"TableForm", "[", 
     RowBox[{"parset01", ",", 
      RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}], "]"}], "*)"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.7585573502790737`*^9, {3.758557416662918*^9, 3.758557417800726*^9}, {
   3.7585574593029137`*^9, 3.75855752487545*^9}, {3.75855757528645*^9, 
   3.758557667757551*^9}, {3.758563426348437*^9, 3.7585634495480337`*^9}, 
   3.7590891396170406`*^9, {3.7596006546458197`*^9, 3.7596006554774103`*^9}, {
   3.7596011740167646`*^9, 3.75960122809816*^9}, {3.759601636287717*^9, 
   3.7596016621483*^9}, 3.7646075104932013`*^9, {3.7646203458456097`*^9, 
   3.764620454737575*^9}, {3.7646854996493673`*^9, 3.7646855037115173`*^9}, {
   3.7646859794921045`*^9, 3.7646860158481245`*^9}, {3.764686073184255*^9, 
   3.7646861544838943`*^9}, {3.764686211793691*^9, 3.7646862572125545`*^9}, {
   3.7646862904244523`*^9, 3.764686405427883*^9}, {3.7646864687285037`*^9, 
   3.7646865180442343`*^9}, {3.764686572759493*^9, 3.7646866878734045`*^9}, {
   3.764686719694611*^9, 3.7646867785222187`*^9}, {3.764686812610632*^9, 
   3.764686838179757*^9}, {3.7646868689586616`*^9, 3.7646868700991297`*^9}, {
   3.7646869951421323`*^9, 3.7646870070846577`*^9}, 3.764687038631254*^9, {
   3.766864949929313*^9, 3.7668649867287836`*^9}, {3.766865028396298*^9, 
   3.766865051889716*^9}, {3.7668656601959724`*^9, 3.766865718566044*^9}, {
   3.7668667541434526`*^9, 3.7668669007405806`*^9}, {3.7692715532102327`*^9, 
   3.7692715605764265`*^9}, {3.769271606645773*^9, 3.769271608832777*^9}, {
   3.7692716587496634`*^9, 3.7692716848105907`*^9}, {3.832168622315541*^9, 
   3.8321686610862274`*^9}, 3.8402044051998596`*^9, {3.840204677480768*^9, 
   3.8402046829517097`*^9}, {3.84064956027425*^9, 3.8406495873354588`*^9}, {
   3.8406496288792133`*^9, 3.840649655902847*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"795991e9-c991-4b29-9e3b-5cbee1bd16cc"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVz3lUzXkABfCY9BSVFpKlxPP79tZ+Wyo6UyNLRXFowSFEvBKhbfIwUkob
Bq9jy5iGJqdHyIuyXSODpjOpSFq0lxPtKpTMmz/uuef+8znn2gSGrQoaq6Oj
46XN//33Dd0eUsAjNS11qcaMx7HUrtJdd3kUX/i2YMSUh7+iKldzh8dlzQHa
TbvfW6vD3PJ5zBfmWJZN4qF/fHV3QB4PlbTg40dDHst3ZnaprvGwOpirEo7n
US5y7fwhk8eLoBX9p0Y41GcqO+qTeRQZfajf28rhy4kEr7w1PCQvyy945XFg
1dsa34p4dFvNV+6P5yBuuXH3wzCHlozTxmf8OAinHv88tZiD9dF+g3IhB+eY
hcFnz2tdzfSXmwZZ+FUmLbQP5nCIRIUYF7GwW7lg430HDr23NY3qkyyoocfq
dH0OWSMx7pe2srA+VxuY+oaFqbjun3yWxbyQEo/X2SxKytQXhbosJvpTEfpK
FiY304zjKxm0uJgL1nqwmLJtisXEKwyqfd8UD09j0R4+hu+KYlC+XT5U8J5B
9Cs9wfdFDJLSu7dtucNAc9tSZWDOIKDviGBTEoMNrFNtRBsNe88bk372Z6DQ
PRQ9XUNDXJrr2WzLQKbaPYtKpGGz0q0zeJCG0k9VoPSl8abTtaKmiMbrEv+6
RiGNnLtmHZfSaZRfirQN7bZD7C/7gmO30jhcUveuPc0OkeH5lhp7GuHbe275
cHYQxa83fCWgcTOrc2hCjRwPbGQVM9R2yPl1blanUo6tqmWdDivs8Mc65Ujt
HDmMx5ysSuqQY/FlKbPkqQyOWWrPW4lyzIh7EL8xWIaMK3usYiVymNg8G043
l0EvI+BJwjMZ+t0WNNwrkCKna+AFGyJDj7TkyXCQFKUxm/01RjIMFA+cbzaX
YnDkk2ZXjhQpvRXJow8kWFvNRv3rLYVCWVzXtFMC5J4RBHVI4JE3ef9nCwm2
1Gd//T1Vgmv5y53Dn4txxD0tQkNLYL4xZeDTPjFyrp599L1EjPTKXgsZEcMw
aGVoT5gYoQc599EqEfZOteuwmCBG2NEmXZ14EfzGNXVNzhYhduB6my4tQtRy
F9/CZSKY29/6bbTBFudSilJV7bboepqZHJhsi6/CT3MttL0hUGKW4miLt0ND
i8PktvgzfHLvqnaCe3/NcRgtJjjJf/5meozgbfuXJG4XQZSRbPxDJ4J1T1W8
KpSgbOYpRzdHgtpMpn4whMD7apzv83kEDRuC+cLtBD70FN9yjqCtouqd62aC
J/GHdrTKCPoe3eG8fQg09w9+EcwmmHgmsk4xn0Cxyen+jwYExyJNjhZr3eYQ
WeLj8QTGq6+xUgeCZH8Pl0UCAlOj1sRurVvmbBTtoUtgGe/DRmldkzVbxq0e
pUDt5hLjZhHkfNXLDOyjkO1VyrRaEdgECBa29FAQSXbULplJcKUpsTSom4K0
LZMxmEYQbTMrT/GRArvetPaEGcEBhXfGzjYKt52uJ/SZECzJ6Lna1ULB3sKT
8ZlEsHT2T5fDmik4lscmWBgSWJ/WDdzTQKEwdyYTM4HAwzNubt87Cs5pBTXV
+gSHG59V7q2j8DDEN8FZ+8vHsyqyv4aCi3svfVGP4PW+wrER1RT+A6VPXsk=

         "]]},
       Annotation[#, "Charting`Private`Tag$362669#1"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVz3s41XccB3DpIreUyw4qscn33M/5XUwry61VSDyjTElzQjnaUULJNo6h
3Eo9HV0VNqVRpycdIVvviildLJJLJC2q04PIIq22sz8+z/v5vJ7383mej4Ms
9utIfT09PT/d/J9/XJj2mtSwSJ8cjhkoYbEvd6hZUc3i+9Bt/iLdHrylQ625
zMJWPkbHF7N4saAi1quKxQ8l+pNTilgY7g8cDqtksXNy6d75hSxWfVcypDrH
YvyAS2nQYRYtPPfBqbo71bPZvus5LHpLkrW92Sxch+6En4pn8S4/06/yGxap
tx6YxnuyoCui+jp5LD6cuGJ5woIF/9mF6lfvGZjlNZxS9zNwtN4/Yd3EIMR7
mU1vJQPXJM/oo8cZjFSNGckyGKx9mOXpHM0gpfkNf0ogA0nAko11Lgyin1tK
ch0YOI1fqygwZGB/V/FY/obGgmPdstx2GqccHFdHXaPxufyOd1sZDXHx9NOa
gzRMgp3iDZNp3HaxDx2JoPHMzdIgxJtG1Iv8Bh+GRtea9qb3tjT6f2UPTEyj
0bJZPF7zgsLhj2l2DS0UsgqGozZdphB33uF4SjGFsNEMg2+zKNy96Oq1fwcF
Z58Ls3cFUyj4kKAHDwr8ZrXPX1wK2qOf3F1uQcEhwGsw+q0UaUXKhSNPpGgf
dG99VC/FPJFsTp5aivJqC21RgRQ30nLOpCqlUKbsjlZGSHGex2074S9Fwo4q
G42zFCbirSvMHaTgpYeaPjCQojNkaf/EgAS/OYha51VIYH5mxUxhugQRKt9B
F38JOprN11txJTCbcrAjSytGaLIdJ7pejEWnK3wu7hFD8tJxySWZGIWl2+2U
AjG+vK2o0xiIMaMw7EZmowjZGREvJaUilA/9fYuWi5DaNm63wVuE5qTwYM0s
ETjyxaO7h4V4+8+YRlEuRNEhZprVPiFCuujEe6uFaOfaPApghID6iEGkVoDk
q41p+vcF2NRbNlmcK4Cvn0fasgQBMlbmxWukAtRx7sUHzxWg/OzRq//e4UOs
jLS8WcOHaWTA1texfMgHFennwviIs5ZoOcZ8qCo39nS/52Ht9KdDVmU8jP3Z
01V7jIfEVW5ran15MFsV8eqjGw/HcupzVc+56DVaEZvYw8Wk49hCTjYXetuz
wwOVXHSOj38VK+ZCu2xXXbcTF1euf+bysYngbG5lUn49Qefzd1mMgmBnlu/w
pS0E6xpUrGorwdyonB9tNxN0l1C9b+UEE8MxxqmRBE82RLO1Oj/zs7mdr4xg
oLXjsXs4QWOrGelbTzB69TKzOojA682hmyb+BCZHEnq2LCboM3QNkDkT7EuY
s7dpEYHjxmBVI0NgFniOFroQEK20Q0gTmM/q3zOs876YT4PHxQQ26UF0oohg
ZanN4lwugdM2Zs9P9gQeHLFKM5egzK+Z6rcjUDw8WWVrS8ATxHQvn09w37in
LcWaQDhQQhnpPEfdYOpjRUCHmnfnW+j+aZVtejyL4NIX5zNH5xAMOa/b4WVK
4MzxoYJmE5y84aQsMyZY1KLM5Oj8gbtXQdxMglr1fCpJ52b2qsL2GQSueTWP
ugwJ4oxQ4jqd4Hf5mkxXXS9ior60eCqB28oR6Uldz/PpL6dn6BP8Byc2UVA=

         "]]},
       Annotation[#, "Charting`Private`Tag$362669#2"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVz3lQ1HUYBnAv3EUEUStAOaKU7967vwNBM1AcRUCU4lJHkWNBWTmyVLwY
h9CFJRQ6FgVHoy0OZ5cAYbnMeFATRYoUFDkMEwVaA4nABTHr1x/vfOZ53z+e
eV2jkz+MnTVjxoxAbv73RsWcUVLPIs13OqqzhsXp7JG2pDoW+U2+Ps5cDt/z
oNxYyyKuQ/tOrJHFkIsheR23T82j+seqWFjmBD+P4IwpTFDaVLLYlKgb0Zax
KHxrNG69nsVd4Zrh2ToW6l/lCVVfs+jTHTX1ZbFQ3r+QkpPJYipXHVi1lcWf
FitfR4exoA1xv3cJWQTz2QYNYSF6UlH3bJqB17EzODfFYJl9zqR9C4OiOTyv
W80MVh/2ic8/x+BZ88xxv3wGYfc1Pu7xDOZ9OkIG4hjIg97b9YMHg5KHuopE
dwZu5iZDniV3D1KmbOQxcCnojc7upJHa8/C21z0aK1StfvdKaTyOmFRmFtOY
H+623/Ioja7quZFXDtF44v0Gb5sfjT6hxWwbXxrdoZ0t00to9J9pMVfa07i7
W2auH6Lw+kJR5b4BCpq853ExtRTyrA2TjkYKEWMneZEaCk5lS0qWZlBw96+w
PRRO4Uxn1fYVoRREbeX+/QIKaRrX09+5UXANWjcc/0KBji3J8+TjCnQOr2nv
ua4AfaMlpeiqAvq6xabCPAUaq0tyk79SIO34kfg0pQKe9bHHwqIVOPBJjYPR
XYGJDx55fc4oIDyxw7qDp4AbJfets1Dgiqu03dEgx8DNSuNUiRxKbcCwxxY5
HJNW/SEKkGPBzC8eaEwy2CnlqrMDMngWG/wvZcjQal072Jcuw/mifc5pYhk2
uHSp2ogMc89HXFM3S6FMjze8uiaFfmTiFq2SgubzT92Jk6LtcFS40UaKn2d9
WXDcSooXr8aNSXoJJE0VF/eWSrCtmz74y2YJzDrH/f8ESIDys7xYkxjtpovH
WgfFiOkrfflNthhNWps47ywxTm48td+oEMNWs3NhpkwM/cX8xn9bRdjuvyPG
6rYI1rFBCaPJIrT0H7kuTxLhY3u5yc5KhFhNdmO2pQhhFo9H3iwVQttRM325
WIiDm7xDGwKEuLPb+lGWvxAFn13P1g4KYBp66pw7IMDLZePL7bIE8A0c4rtr
BOgym9cnywTovtnoYpAKcPnqux6vWwhGB/2MWzm7Bqc0TBLB5Z4UujiRYPtP
WlabQPDMVL2Wz9mro/peqAj6J6uCVJyPdsazDbsJJvZNJso4B9of/LYmiiAq
83xRTSTBWGMtszmEIMeUaNkcTDD/7IGHe1YR2Eff/3ZwJcHpAwszWzwJbGPT
9X6cC4LLaIkHwc6MiUv6FQSLbJ5mPGcI9uYKm5I5HU6E0AelBG7H27vNEs6P
mIz0twlkPutn8zlLA9uop84EDe8H8VScQvHe3g1OBKl/u1q1OhJIBnTUvCUE
6gmHRbkOBPSORb25iwm63XY52XNWr/xePbaQgH9L53KE093Onwqx5f4cL3Pt
XUDgeTdNbWdN4Bi0dHnhfK6n3Ik6bEXgU53qNotz9an6nm5LgkjLUqLk/FEV
ql7NJ7BRFQhu8Ai8N/6luDCXIHw0RCjg/A8dPVWh
         "]]},
       Annotation[#, "Charting`Private`Tag$362669#3"]& ], 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVkX001XcAxlVKQqWXkSVZ9fve+/vdl9+99ye3spFY17tFVJNItzCRxJmZ
7J64jSRpDDt6sWqEkMnLaj29rdNdm1DjckcWMg1NCulld3885znPX5/nPI/t
zphNyukGBgZeev3vv1QZPiMNHMbk0z2b3VhkZQ43RddzuJNFxxJ9Dgxvr6yt
42A6GXs6WcFiwKY8ZsNlDueCE6zpjSyMj/mNBNdwUB00yDnkwsJzb/FwbgUH
tjcpUu7IooXvNDSjmMPZ4UuGFzgW3cVJg90ZHLKqslwu2rCYzFZ71WzhMOdd
Mr+0Twxp+e4eLZ9DuMPD+toTYtC9VfVPp2SYqDS383EVY6XlsQlLjQxc89lP
ro6K4JDoHFHwnQzHVRdPeJaIEPBHurNdhAxJ3q3PmreJIPZdt+OKvQxzmfDo
TQtEoMavl+cZy6De6udItwhhU6jbmdkmhUdgSML5bCFWR95ze1giRWfaN4kp
gUKYBlIHjJOk4CY2eAWtEKLXcZHRVjcpPl07ESsfEaBjc5tmykqKO+oATd0N
AVr2iMYbBiRQrIamP0+A9LyR3WF1EoToflMx+wQIHk0zCkmXYJFGt+WMjwB2
7lXzPw+UoLrQ7fu/xQLQTZXuj3kSZDhvNPZZLICt74ahiJcs1kdVuvhMMWgb
cmrtvMXigcc/oUwvg7L6hYOn81gseWF4wfU+A1XKFxGqXSwqZFFqsysM4uMu
L6m10/96xCT5TSkDfmqQ2QMjFuaZFWEn8xlctRW2Li0X483lxN6yNAa7cj2G
7H3EIAYij/1xDOZNy2lPHxRh/XPLjQXBDOTny90vHRZBnjzWlapgUHQudpmK
ESHROvr8HCmDWUXBN9V3hHh/duNXKy30/YZf3JVGCmH19sYepykaTYmhgbVz
haixm7FuVEfj5eux2ugyAU5V+PuG1dPY2iFN+N1bgF+bh82O5tBAZb6RcpDB
3pYUj7VKGmHdJa/OZDLQFvL2162mkaY4eqCW1XNEGtp2Jo2y0oJr7+7RyB+j
3+vX8GGm9I16FkOjuZgoE7P52G8pHrQwocF7uia235OPgJl/DS8u4aMnJ+jW
wVl8JHg6bm704MN09m2/A9d5KDxyKzP3CQ9R2hXZH8bx8Grl2CqLDB6KcuJd
QggP2vFx1xgRDyHPuY9OdRD8dGOF/VsNgWO/LudNKoH2yWS6LJrg3vNw71Uy
gm23c7ncKALrmOjXNRICXbGk+2UkQejEsgxnluDR9giucQ/B4rgWlx1Cgv7W
9i6nUILjQw1rviUEo9fqZN7+BNU3V8mmLSUwzY//M3wtQcHylJGrhgRZ8eZf
a+QEzSYnGxQzCOb5VUgF9gQHk3uUrdMIFsztOzyi7/Fa+4Fy4C2FJan+0gQ9
p/vmDwbmkxSofbLDh5YTrNfuuBI0RKHEq0nSt4zA52xddd9TCnzmM93H1gTb
U8MyogcpCPqLJXOsCALspvenPKEgDVqgy15IcN1ql+JMD4Uf11xUj5oTuBYp
t/EfUbCzcJf4zyfIK/Xxre6iIG9RqS3MCCaGqQF0UmistJYkmuj30MozFB0U
HI42dHYY6/e49OX8++0Ufo7crHaYTdDeaJgU2EbBUfEve3IWQaPw8d2uhxT+
A994WBI=
         "]]},
       Annotation[#, "Charting`Private`Tag$362669#4"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVT3s0lHkAVYpsQ4katKkp9Zv3fN83n2hzDtVpy4RsiRAhhIqS6QhtWSJM
2E7jUHRK++Cg0WNIRVd6SA+7tHmndnuSRx2ZsGln/7jnnnvPPffcywuJ2RQ2
1cDAwF2P//lu5bRhUsOi6o4uyu8Qg2zVYHP0VRa+J27N1SQx8Ilo12irWfRH
FN031Ou3C8tj1lSxaKjLd6tIYGCSs3ko8DKLHGsnGMQzcNtTPKiuYHHyeX9I
aSyDFoHLgGExi3e8xTemRDDoLU7s681kUftsbLR5E4Ox3DT3y1tZPDX3cIhZ
yoApD3/RIWAxITib3TNBQ/iy8mr/hBzFnLCAz6007KxyPls1yXH+yP5z90pp
OB1cHVlwWg7LT16pWSk0vJ9mrLaPlOOGevuMJH8aMs+V2284yNFv4Xq3zJ7G
Ml19eZ6JHMfW9rp0WNBYeKo7RNXGYNI6d+zJMIXlUQ9d/yph0FjhZ1f7JwWO
z7I4k0QGNolSbv0VCi+dLY19XRmc28+zG8qj0LmlrWnChoFx9d2srCQKLTul
upq3NMJTCuK3BlPIyBsK31FNgwSa+XWsoxD48ahxUAYNz9IZ+95RFOwVlbPj
fWiwtr/vKbGiIGzWKP7h63+EXDmzcSoFnueagchRCvcnvuQveSJD24BLa9dt
CkaFsvNN52Uou2rRd1a/w7BnfVC0UobkwwmRyaEU4hSNcctXyaDcX2Wttaew
tmanmm8mgyB1m+kTYwq6FyGCgg4panmS1m/LZRCNDiQnFEkRqt4w4LBRBqPF
DVmKEClmTTnRntEnRVno486LtlI4/lauuJQuRbyo8HZXuwRFv+6zTRZJEfuz
UbL2pARGRYENafck0EQ/8tWsk6Bs8NN9JkqCx9WXjph+EaP5YLCP1kyCnM8J
qsyLYoz+O6KNLhOjSujIWxEghm8nc+CxhxiCF05B2RwxoMk3DusTYVXhlxbq
sgg7ekvGz6lEmLQ0kogCRTi6/niclhJhl80frsdMRCgrLbj59aEQF75Kuw6V
C2Ea5rl7OEYIi3xv/1IvIWKtZH3cmUIEsCfsc0cE8J7+9+DcEgGm7lNyotUC
HHBz3nJtgwA9zRqRlZMAp7Juq9Rv+HhQ+2OmppOPcbuRpdxMPqqVR1f8cJiP
Dp1ubYyUj0fOe7MjlvJx/dYSh8kmgl6V94OsBoKON2MZ8miC6Wcqm8Z3Evjd
UbPq3QQ2SdrY4HCC7mK6dzSKwDSifl5jKMHzgEj2mj4X3Da+SR1M8Lq1/ZmL
nhfdVBTK/Ak+3qyWe3gRLHbiKHd4EHDylT0R3xHkrTbxamQJspXmx5ocCeYP
P/hJKieYtbmCETsQbHg9UnGSJphj9ip9SO+b6lLHgqQE1qlezAEJwfH492Fj
hGDZXnl6yiIC56/r8gTzCUrcm+lXtgRuznWqHGsCgWhX9/cLCAot7h3+xCUQ
vy6mv7EhmOZ62r/ekoDZNqc714Ig7EN+31YzgisrLqR9NCeomxy8U8chsOcq
aK/ZBO8NBorsZhI4tiSncU0JEiP71wwbE1zTLKAP6n2/WR/MvY0InI7XdHWa
EFjxS7uvT9P3RG1Jc5pB4Os+7xeeoX7n+g/UGX1ujLsyIn0KwX/A8lUD
         "]]},
       Annotation[#, "Charting`Private`Tag$362669#5"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVx39czHcAx/HbhoSKyvodTXzu9933Rz/ktu5Ro/RLKpotFUm/y6+ibA9r
KJfI6FJZWCzR0WGXLj96txjioSk/iqxRYmd1auomYeeP1+P5eLmszAiL/5jD
4QQb++Dv6nEviZbF0UWzxGNOLHYXDrSm17NQUWlWAcaPTOyo1Zxj0Z7j+na/
I4vnM1QZvnUszFJ7HjEOLEyLwvXRZ1k8FunupNiyCEqrHFCeZHG7YPaBLksW
bTx5/yeVLMK7OGVNJiy6KzfrugtYxDfnPi4bZPB6T17w2a9YlDfqR+81MaBV
qx938lic9mv696CSAb9XXf/iDYOeozv7jiczcLUt+s+2hUHKWfnFQhkDWbZP
UtkBBouddG0cSwZL7yl83JIYHE6QZ2X20pCEzou54MFAfkL2LqKexhxDk6rE
lEGAmzbodBGNGeVdKwvv0+CYJ7oIVtFwT7658G41jcx/tDYcGY0pkXM2mG6m
wYsTD761ptHrbW2ybCENq2udvDEdhQdL7re8saeRbupaOtpMoS1BbNA+p5Cw
8ZrFlTIKihL96rhzFBKby0/4rqEQPbTdJFZBISTmTGnMQgpuAeqpmyIpWM/k
1HQ7U+C31gb0cCmsUxcr/xiRwiXUtz/J6EjcwNpnLVLc75e3P7wsxQLej/7z
DklRU2+lO1wixcY2hb0hU4rcLTlJuaukCGrgbq3ylyJzfZ2dxk0KuQN/9W0n
KXjboszumEhhBTuOtk+Ciy6idkeVBJvnesuOKCRYpQzs91gkQbn3vNJBSgKL
j/Z2KHRi2Ifo1DZtYnhWqQLO5Iux33Lxuy/Xi1Hxy1rnXIEY74N2+/jaizGh
Iro576oIUdl+L1mtCDUDw9fpZBG0p0ZfCKNFaM1eEakxF6Hx0HzZ/nEijIy9
0qTXCKFefoY2OyLEsgd01q0QIQIduF7X/IRAbalJvE6ALeYun5f1ChDXXT36
c6EAM/XZ51vyBdjuv2uDRirAd/OtAo8JBag5Xtb4/iYf49/ExB67zodZfGjq
yww+5G0Vn81O42OdrURnM5kPnntxyY2JfCwd/2RgejUPhU+GMqRVPGQFeS9p
CORhhCnf6xrAQ/nOy4XKZ1y43S0u9uvjYtT11WybAi4QeK+Bo+Ci02CYnyHm
QstzjsoTcXH+t1ke71oIomKnh31htPPZawWTTpATPBy3L43g6ytKVplKkKrW
FA2nEHRVUt0jyQT6WebnI43+tTyJbUggSN6xY6qj0b72jj/lKwiyQ1V1R2MJ
hhrPMSERBIZvDXpNOMGU0sxHiV4ENwpu2HbMJdidOW1HiydBXQ7f08uoRfhJ
WuhBMJogiPzJncDS/Gm+niHwT7IujjVqty2CzhIRBHvtNP1bSDBnDZO/dSbB
iodBPa9nEFQHt1JPnQnCcgfGvjHKE6R0LXAi2AT3Ty85Egj7KqlJ9gRxvAt+
P9gR0FGWXXusCK6mVFZNMvrr3FN5Q9MItlR9fzHVqJtNABUxlWDXaZM7tywI
PNty82zMCHpDp3H2TSFoqHWisicT+K0tnj48iUC2S/vwgSmBT3YTP9LopeQl
ebKJBIMnS721JgTe/oPSgxMIKsLsIxyM/g8VRk1o
         "]]},
       Annotation[#, "Charting`Private`Tag$362669#6"]& ]}, {}}, InsetBox[
     TemplateBox[{
      StyleBox["1.`*^-6", 20, FontFamily -> "Arial", StripOnInput -> False],
       StyleBox["1.`*^-7", 20, FontFamily -> "Arial", StripOnInput -> False],
       StyleBox["1.`*^-8", 20, FontFamily -> "Arial", StripOnInput -> False]},
      "LineLegend",
      DisplayFunction->(FormBox[
        PanelBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 StyleBox[
                 "\"RAF(M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
                  False], {FontSize -> 12, FontFamily -> "Arial"}, 
                 StripOnInput -> False]}, {
                TagBox[
                 GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.038000000000000006`] -> 
                    Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Center}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"],
             Alignment -> Left, AppearanceElements -> None, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontSize -> 12, FontFamily -> "Arial"}, StripOnInput -> False], 
         Background -> Automatic, ContentPadding -> True, 
         FrameMargins -> {{5, 5}, {5, 5}}], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", "12"}], ",", 
           RowBox[{"LegendFunction", "\[Rule]", "Panel"}], ",", 
           RowBox[{"LegendLabel", "\[Rule]", 
             StyleBox[
             "\"RAF(M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
              False]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.99, 0.01}], ImageScaled[{1, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{-20.72326583694641, -20.714223979804505`},
   BaseStyle->{FontFamily -> "Times"},
   CoordinatesToolOptions:>{"DisplayFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& ), "CopiedValueFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& )},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       StyleBox[
       "\"Total Drug [DTOT] (M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
        False], TraditionalForm], None}, {
      FormBox[
       StyleBox[
       "\"Unbound Drug [d] (M)\"", 20, FontFamily -> "Arial", StripOnInput -> 
        False], TraditionalForm], None}},
   FrameStyle->Thickness[0.004],
   FrameTicks->FrontEndValueCache[{{Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-20.72326583694641, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}, {{-20.72326583694641, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}, {{{-20.72326583694641, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}, {{-20.72326583694641, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-22.33270374938051, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.927238641272346`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.639556568820566`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.416413017506358`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.234091460712403`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-21.079940780885142`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.94640938826062, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.82862635260424, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.030118656386467`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.624653548278303`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.33697147582652, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-19.11382792451231, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.931506367718356`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.7773556878911, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.643824295266576`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-18.526041259610192`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.72753356339242, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.322068455284256`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-17.034386382832476`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.811242831518264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.62892127472431, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}}],
   FrameTicksStyle->20,
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->{500},
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None},
   PlotLabel->FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(K\\), \\(d\\)]\\): \[LongDash]100nM  - -1nM \
\\!\\(\\*SubscriptBox[\\(K\\), \\(A\\)]\\):10\"", 20, FontFamily -> "Arial", 
      StripOnInput -> False], TraditionalForm],
   PlotRange->
    NCache[{{-Log[1000000000], -
       Log[100000]}, {-20.714223979804505`, -11.41771536729981}}, \
{{-20.72326583694641, -11.512925464970229`}, {-20.714223979804505`, \
-11.41771536729981}}],
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          Line[CompressedData["
1:eJwVz3lUzXkABfCY9BSVFpKlxPP79tZ+Wyo6UyNLRXFowSFEvBKhbfIwUkob
Bq9jy5iGJqdHyIuyXSODpjOpSFq0lxPtKpTMmz/uuef+8znn2gSGrQoaq6Oj
46XN//33Dd0eUsAjNS11qcaMx7HUrtJdd3kUX/i2YMSUh7+iKldzh8dlzQHa
TbvfW6vD3PJ5zBfmWJZN4qF/fHV3QB4PlbTg40dDHst3ZnaprvGwOpirEo7n
US5y7fwhk8eLoBX9p0Y41GcqO+qTeRQZfajf28rhy4kEr7w1PCQvyy945XFg
1dsa34p4dFvNV+6P5yBuuXH3wzCHlozTxmf8OAinHv88tZiD9dF+g3IhB+eY
hcFnz2tdzfSXmwZZ+FUmLbQP5nCIRIUYF7GwW7lg430HDr23NY3qkyyoocfq
dH0OWSMx7pe2srA+VxuY+oaFqbjun3yWxbyQEo/X2SxKytQXhbosJvpTEfpK
FiY304zjKxm0uJgL1nqwmLJtisXEKwyqfd8UD09j0R4+hu+KYlC+XT5U8J5B
9Cs9wfdFDJLSu7dtucNAc9tSZWDOIKDviGBTEoMNrFNtRBsNe88bk372Z6DQ
PRQ9XUNDXJrr2WzLQKbaPYtKpGGz0q0zeJCG0k9VoPSl8abTtaKmiMbrEv+6
RiGNnLtmHZfSaZRfirQN7bZD7C/7gmO30jhcUveuPc0OkeH5lhp7GuHbe275
cHYQxa83fCWgcTOrc2hCjRwPbGQVM9R2yPl1blanUo6tqmWdDivs8Mc65Ujt
HDmMx5ysSuqQY/FlKbPkqQyOWWrPW4lyzIh7EL8xWIaMK3usYiVymNg8G043
l0EvI+BJwjMZ+t0WNNwrkCKna+AFGyJDj7TkyXCQFKUxm/01RjIMFA+cbzaX
YnDkk2ZXjhQpvRXJow8kWFvNRv3rLYVCWVzXtFMC5J4RBHVI4JE3ef9nCwm2
1Gd//T1Vgmv5y53Dn4txxD0tQkNLYL4xZeDTPjFyrp599L1EjPTKXgsZEcMw
aGVoT5gYoQc599EqEfZOteuwmCBG2NEmXZ14EfzGNXVNzhYhduB6my4tQtRy
F9/CZSKY29/6bbTBFudSilJV7bboepqZHJhsi6/CT3MttL0hUGKW4miLt0ND
i8PktvgzfHLvqnaCe3/NcRgtJjjJf/5meozgbfuXJG4XQZSRbPxDJ4J1T1W8
KpSgbOYpRzdHgtpMpn4whMD7apzv83kEDRuC+cLtBD70FN9yjqCtouqd62aC
J/GHdrTKCPoe3eG8fQg09w9+EcwmmHgmsk4xn0Cxyen+jwYExyJNjhZr3eYQ
WeLj8QTGq6+xUgeCZH8Pl0UCAlOj1sRurVvmbBTtoUtgGe/DRmldkzVbxq0e
pUDt5hLjZhHkfNXLDOyjkO1VyrRaEdgECBa29FAQSXbULplJcKUpsTSom4K0
LZMxmEYQbTMrT/GRArvetPaEGcEBhXfGzjYKt52uJ/SZECzJ6Lna1ULB3sKT
8ZlEsHT2T5fDmik4lscmWBgSWJ/WDdzTQKEwdyYTM4HAwzNubt87Cs5pBTXV
+gSHG59V7q2j8DDEN8FZ+8vHsyqyv4aCi3svfVGP4PW+wrER1RT+A6VPXsk=

           "]]}, "Charting`Private`Tag$362669#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJwVz3s41XccB3DpIreUyw4qscn33M/5XUwry61VSDyjTElzQjnaUULJNo6h
3Eo9HV0VNqVRpycdIVvviildLJJLJC2q04PIIq22sz8+z/v5vJ7383mej4Ms
9utIfT09PT/d/J9/XJj2mtSwSJ8cjhkoYbEvd6hZUc3i+9Bt/iLdHrylQ625
zMJWPkbHF7N4saAi1quKxQ8l+pNTilgY7g8cDqtksXNy6d75hSxWfVcypDrH
YvyAS2nQYRYtPPfBqbo71bPZvus5LHpLkrW92Sxch+6En4pn8S4/06/yGxap
tx6YxnuyoCui+jp5LD6cuGJ5woIF/9mF6lfvGZjlNZxS9zNwtN4/Yd3EIMR7
mU1vJQPXJM/oo8cZjFSNGckyGKx9mOXpHM0gpfkNf0ogA0nAko11Lgyin1tK
ch0YOI1fqygwZGB/V/FY/obGgmPdstx2GqccHFdHXaPxufyOd1sZDXHx9NOa
gzRMgp3iDZNp3HaxDx2JoPHMzdIgxJtG1Iv8Bh+GRtea9qb3tjT6f2UPTEyj
0bJZPF7zgsLhj2l2DS0UsgqGozZdphB33uF4SjGFsNEMg2+zKNy96Oq1fwcF
Z58Ls3cFUyj4kKAHDwr8ZrXPX1wK2qOf3F1uQcEhwGsw+q0UaUXKhSNPpGgf
dG99VC/FPJFsTp5aivJqC21RgRQ30nLOpCqlUKbsjlZGSHGex2074S9Fwo4q
G42zFCbirSvMHaTgpYeaPjCQojNkaf/EgAS/OYha51VIYH5mxUxhugQRKt9B
F38JOprN11txJTCbcrAjSytGaLIdJ7pejEWnK3wu7hFD8tJxySWZGIWl2+2U
AjG+vK2o0xiIMaMw7EZmowjZGREvJaUilA/9fYuWi5DaNm63wVuE5qTwYM0s
ETjyxaO7h4V4+8+YRlEuRNEhZprVPiFCuujEe6uFaOfaPApghID6iEGkVoDk
q41p+vcF2NRbNlmcK4Cvn0fasgQBMlbmxWukAtRx7sUHzxWg/OzRq//e4UOs
jLS8WcOHaWTA1texfMgHFennwviIs5ZoOcZ8qCo39nS/52Ht9KdDVmU8jP3Z
01V7jIfEVW5ran15MFsV8eqjGw/HcupzVc+56DVaEZvYw8Wk49hCTjYXetuz
wwOVXHSOj38VK+ZCu2xXXbcTF1euf+bysYngbG5lUn49Qefzd1mMgmBnlu/w
pS0E6xpUrGorwdyonB9tNxN0l1C9b+UEE8MxxqmRBE82RLO1Oj/zs7mdr4xg
oLXjsXs4QWOrGelbTzB69TKzOojA682hmyb+BCZHEnq2LCboM3QNkDkT7EuY
s7dpEYHjxmBVI0NgFniOFroQEK20Q0gTmM/q3zOs876YT4PHxQQ26UF0oohg
ZanN4lwugdM2Zs9P9gQeHLFKM5egzK+Z6rcjUDw8WWVrS8ATxHQvn09w37in
LcWaQDhQQhnpPEfdYOpjRUCHmnfnW+j+aZVtejyL4NIX5zNH5xAMOa/b4WVK
4MzxoYJmE5y84aQsMyZY1KLM5Oj8gbtXQdxMglr1fCpJ52b2qsL2GQSueTWP
ugwJ4oxQ4jqd4Hf5mkxXXS9ior60eCqB28oR6Uldz/PpL6dn6BP8Byc2UVA=

           "]]}, "Charting`Private`Tag$362669#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwVz3lQ1HUYBnAv3EUEUStAOaKU7967vwNBM1AcRUCU4lJHkWNBWTmyVLwY
h9CFJRQ6FgVHoy0OZ5cAYbnMeFATRYoUFDkMEwVaA4nABTHr1x/vfOZ53z+e
eV2jkz+MnTVjxoxAbv73RsWcUVLPIs13OqqzhsXp7JG2pDoW+U2+Ps5cDt/z
oNxYyyKuQ/tOrJHFkIsheR23T82j+seqWFjmBD+P4IwpTFDaVLLYlKgb0Zax
KHxrNG69nsVd4Zrh2ToW6l/lCVVfs+jTHTX1ZbFQ3r+QkpPJYipXHVi1lcWf
FitfR4exoA1xv3cJWQTz2QYNYSF6UlH3bJqB17EzODfFYJl9zqR9C4OiOTyv
W80MVh/2ic8/x+BZ88xxv3wGYfc1Pu7xDOZ9OkIG4hjIg97b9YMHg5KHuopE
dwZu5iZDniV3D1KmbOQxcCnojc7upJHa8/C21z0aK1StfvdKaTyOmFRmFtOY
H+623/Ioja7quZFXDtF44v0Gb5sfjT6hxWwbXxrdoZ0t00to9J9pMVfa07i7
W2auH6Lw+kJR5b4BCpq853ExtRTyrA2TjkYKEWMneZEaCk5lS0qWZlBw96+w
PRRO4Uxn1fYVoRREbeX+/QIKaRrX09+5UXANWjcc/0KBji3J8+TjCnQOr2nv
ua4AfaMlpeiqAvq6xabCPAUaq0tyk79SIO34kfg0pQKe9bHHwqIVOPBJjYPR
XYGJDx55fc4oIDyxw7qDp4AbJfets1Dgiqu03dEgx8DNSuNUiRxKbcCwxxY5
HJNW/SEKkGPBzC8eaEwy2CnlqrMDMngWG/wvZcjQal072Jcuw/mifc5pYhk2
uHSp2ogMc89HXFM3S6FMjze8uiaFfmTiFq2SgubzT92Jk6LtcFS40UaKn2d9
WXDcSooXr8aNSXoJJE0VF/eWSrCtmz74y2YJzDrH/f8ESIDys7xYkxjtpovH
WgfFiOkrfflNthhNWps47ywxTm48td+oEMNWs3NhpkwM/cX8xn9bRdjuvyPG
6rYI1rFBCaPJIrT0H7kuTxLhY3u5yc5KhFhNdmO2pQhhFo9H3iwVQttRM325
WIiDm7xDGwKEuLPb+lGWvxAFn13P1g4KYBp66pw7IMDLZePL7bIE8A0c4rtr
BOgym9cnywTovtnoYpAKcPnqux6vWwhGB/2MWzm7Bqc0TBLB5Z4UujiRYPtP
WlabQPDMVL2Wz9mro/peqAj6J6uCVJyPdsazDbsJJvZNJso4B9of/LYmiiAq
83xRTSTBWGMtszmEIMeUaNkcTDD/7IGHe1YR2Eff/3ZwJcHpAwszWzwJbGPT
9X6cC4LLaIkHwc6MiUv6FQSLbJ5mPGcI9uYKm5I5HU6E0AelBG7H27vNEs6P
mIz0twlkPutn8zlLA9uop84EDe8H8VScQvHe3g1OBKl/u1q1OhJIBnTUvCUE
6gmHRbkOBPSORb25iwm63XY52XNWr/xePbaQgH9L53KE093Onwqx5f4cL3Pt
XUDgeTdNbWdN4Bi0dHnhfK6n3Ik6bEXgU53qNotz9an6nm5LgkjLUqLk/FEV
ql7NJ7BRFQhu8Ai8N/6luDCXIHw0RCjg/A8dPVWh
           "]]}, "Charting`Private`Tag$362669#3"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwVkX001XcAxlVKQqWXkSVZ9fve+/vdl9+99ye3spFY17tFVJNItzCRxJmZ
7J64jSRpDDt6sWqEkMnLaj29rdNdm1DjckcWMg1NCulld3885znPX5/nPI/t
zphNyukGBgZeev3vv1QZPiMNHMbk0z2b3VhkZQ43RddzuJNFxxJ9Dgxvr6yt
42A6GXs6WcFiwKY8ZsNlDueCE6zpjSyMj/mNBNdwUB00yDnkwsJzb/FwbgUH
tjcpUu7IooXvNDSjmMPZ4UuGFzgW3cVJg90ZHLKqslwu2rCYzFZ71WzhMOdd
Mr+0Twxp+e4eLZ9DuMPD+toTYtC9VfVPp2SYqDS383EVY6XlsQlLjQxc89lP
ro6K4JDoHFHwnQzHVRdPeJaIEPBHurNdhAxJ3q3PmreJIPZdt+OKvQxzmfDo
TQtEoMavl+cZy6De6udItwhhU6jbmdkmhUdgSML5bCFWR95ze1giRWfaN4kp
gUKYBlIHjJOk4CY2eAWtEKLXcZHRVjcpPl07ESsfEaBjc5tmykqKO+oATd0N
AVr2iMYbBiRQrIamP0+A9LyR3WF1EoToflMx+wQIHk0zCkmXYJFGt+WMjwB2
7lXzPw+UoLrQ7fu/xQLQTZXuj3kSZDhvNPZZLICt74ahiJcs1kdVuvhMMWgb
cmrtvMXigcc/oUwvg7L6hYOn81gseWF4wfU+A1XKFxGqXSwqZFFqsysM4uMu
L6m10/96xCT5TSkDfmqQ2QMjFuaZFWEn8xlctRW2Li0X483lxN6yNAa7cj2G
7H3EIAYij/1xDOZNy2lPHxRh/XPLjQXBDOTny90vHRZBnjzWlapgUHQudpmK
ESHROvr8HCmDWUXBN9V3hHh/duNXKy30/YZf3JVGCmH19sYepykaTYmhgbVz
haixm7FuVEfj5eux2ugyAU5V+PuG1dPY2iFN+N1bgF+bh82O5tBAZb6RcpDB
3pYUj7VKGmHdJa/OZDLQFvL2162mkaY4eqCW1XNEGtp2Jo2y0oJr7+7RyB+j
3+vX8GGm9I16FkOjuZgoE7P52G8pHrQwocF7uia235OPgJl/DS8u4aMnJ+jW
wVl8JHg6bm704MN09m2/A9d5KDxyKzP3CQ9R2hXZH8bx8Grl2CqLDB6KcuJd
QggP2vFx1xgRDyHPuY9OdRD8dGOF/VsNgWO/LudNKoH2yWS6LJrg3vNw71Uy
gm23c7ncKALrmOjXNRICXbGk+2UkQejEsgxnluDR9giucQ/B4rgWlx1Cgv7W
9i6nUILjQw1rviUEo9fqZN7+BNU3V8mmLSUwzY//M3wtQcHylJGrhgRZ8eZf
a+QEzSYnGxQzCOb5VUgF9gQHk3uUrdMIFsztOzyi7/Fa+4Fy4C2FJan+0gQ9
p/vmDwbmkxSofbLDh5YTrNfuuBI0RKHEq0nSt4zA52xddd9TCnzmM93H1gTb
U8MyogcpCPqLJXOsCALspvenPKEgDVqgy15IcN1ql+JMD4Uf11xUj5oTuBYp
t/EfUbCzcJf4zyfIK/Xxre6iIG9RqS3MCCaGqQF0UmistJYkmuj30MozFB0U
HI42dHYY6/e49OX8++0Ufo7crHaYTdDeaJgU2EbBUfEve3IWQaPw8d2uhxT+
A994WBI=
           "]]}, "Charting`Private`Tag$362669#4"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwVT3s0lHkAVYpsQ4katKkp9Zv3fN83n2hzDtVpy4RsiRAhhIqS6QhtWSJM
2E7jUHRK++Cg0WNIRVd6SA+7tHmndnuSRx2ZsGln/7jnnnvPPffcywuJ2RQ2
1cDAwF2P//lu5bRhUsOi6o4uyu8Qg2zVYHP0VRa+J27N1SQx8Ilo12irWfRH
FN031Ou3C8tj1lSxaKjLd6tIYGCSs3ko8DKLHGsnGMQzcNtTPKiuYHHyeX9I
aSyDFoHLgGExi3e8xTemRDDoLU7s681kUftsbLR5E4Ox3DT3y1tZPDX3cIhZ
yoApD3/RIWAxITib3TNBQ/iy8mr/hBzFnLCAz6007KxyPls1yXH+yP5z90pp
OB1cHVlwWg7LT16pWSk0vJ9mrLaPlOOGevuMJH8aMs+V2284yNFv4Xq3zJ7G
Ml19eZ6JHMfW9rp0WNBYeKo7RNXGYNI6d+zJMIXlUQ9d/yph0FjhZ1f7JwWO
z7I4k0QGNolSbv0VCi+dLY19XRmc28+zG8qj0LmlrWnChoFx9d2srCQKLTul
upq3NMJTCuK3BlPIyBsK31FNgwSa+XWsoxD48ahxUAYNz9IZ+95RFOwVlbPj
fWiwtr/vKbGiIGzWKP7h63+EXDmzcSoFnueagchRCvcnvuQveSJD24BLa9dt
CkaFsvNN52Uou2rRd1a/w7BnfVC0UobkwwmRyaEU4hSNcctXyaDcX2Wttaew
tmanmm8mgyB1m+kTYwq6FyGCgg4panmS1m/LZRCNDiQnFEkRqt4w4LBRBqPF
DVmKEClmTTnRntEnRVno486LtlI4/lauuJQuRbyo8HZXuwRFv+6zTRZJEfuz
UbL2pARGRYENafck0EQ/8tWsk6Bs8NN9JkqCx9WXjph+EaP5YLCP1kyCnM8J
qsyLYoz+O6KNLhOjSujIWxEghm8nc+CxhxiCF05B2RwxoMk3DusTYVXhlxbq
sgg7ekvGz6lEmLQ0kogCRTi6/niclhJhl80frsdMRCgrLbj59aEQF75Kuw6V
C2Ea5rl7OEYIi3xv/1IvIWKtZH3cmUIEsCfsc0cE8J7+9+DcEgGm7lNyotUC
HHBz3nJtgwA9zRqRlZMAp7Juq9Rv+HhQ+2OmppOPcbuRpdxMPqqVR1f8cJiP
Dp1ubYyUj0fOe7MjlvJx/dYSh8kmgl6V94OsBoKON2MZ8miC6Wcqm8Z3Evjd
UbPq3QQ2SdrY4HCC7mK6dzSKwDSifl5jKMHzgEj2mj4X3Da+SR1M8Lq1/ZmL
nhfdVBTK/Ak+3qyWe3gRLHbiKHd4EHDylT0R3xHkrTbxamQJspXmx5ocCeYP
P/hJKieYtbmCETsQbHg9UnGSJphj9ip9SO+b6lLHgqQE1qlezAEJwfH492Fj
hGDZXnl6yiIC56/r8gTzCUrcm+lXtgRuznWqHGsCgWhX9/cLCAot7h3+xCUQ
vy6mv7EhmOZ62r/ekoDZNqc714Ig7EN+31YzgisrLqR9NCeomxy8U8chsOcq
aK/ZBO8NBorsZhI4tiSncU0JEiP71wwbE1zTLKAP6n2/WR/MvY0InI7XdHWa
EFjxS7uvT9P3RG1Jc5pB4Os+7xeeoX7n+g/UGX1ujLsyIn0KwX/A8lUD
           "]]}, "Charting`Private`Tag$362669#5"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Dashing[{Small, Small}], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwVx39czHcAx/HbhoSKyvodTXzu9933Rz/ktu5Ro/RLKpotFUm/y6+ibA9r
KJfI6FJZWCzR0WGXLj96txjioSk/iqxRYmd1auomYeeP1+P5eLmszAiL/5jD
4QQb++Dv6nEviZbF0UWzxGNOLHYXDrSm17NQUWlWAcaPTOyo1Zxj0Z7j+na/
I4vnM1QZvnUszFJ7HjEOLEyLwvXRZ1k8FunupNiyCEqrHFCeZHG7YPaBLksW
bTx5/yeVLMK7OGVNJiy6KzfrugtYxDfnPi4bZPB6T17w2a9YlDfqR+81MaBV
qx938lic9mv696CSAb9XXf/iDYOeozv7jiczcLUt+s+2hUHKWfnFQhkDWbZP
UtkBBouddG0cSwZL7yl83JIYHE6QZ2X20pCEzou54MFAfkL2LqKexhxDk6rE
lEGAmzbodBGNGeVdKwvv0+CYJ7oIVtFwT7658G41jcx/tDYcGY0pkXM2mG6m
wYsTD761ptHrbW2ybCENq2udvDEdhQdL7re8saeRbupaOtpMoS1BbNA+p5Cw
8ZrFlTIKihL96rhzFBKby0/4rqEQPbTdJFZBISTmTGnMQgpuAeqpmyIpWM/k
1HQ7U+C31gb0cCmsUxcr/xiRwiXUtz/J6EjcwNpnLVLc75e3P7wsxQLej/7z
DklRU2+lO1wixcY2hb0hU4rcLTlJuaukCGrgbq3ylyJzfZ2dxk0KuQN/9W0n
KXjboszumEhhBTuOtk+Ciy6idkeVBJvnesuOKCRYpQzs91gkQbn3vNJBSgKL
j/Z2KHRi2Ifo1DZtYnhWqQLO5Iux33Lxuy/Xi1Hxy1rnXIEY74N2+/jaizGh
Iro576oIUdl+L1mtCDUDw9fpZBG0p0ZfCKNFaM1eEakxF6Hx0HzZ/nEijIy9
0qTXCKFefoY2OyLEsgd01q0QIQIduF7X/IRAbalJvE6ALeYun5f1ChDXXT36
c6EAM/XZ51vyBdjuv2uDRirAd/OtAo8JBag5Xtb4/iYf49/ExB67zodZfGjq
yww+5G0Vn81O42OdrURnM5kPnntxyY2JfCwd/2RgejUPhU+GMqRVPGQFeS9p
CORhhCnf6xrAQ/nOy4XKZ1y43S0u9uvjYtT11WybAi4QeK+Bo+Ci02CYnyHm
QstzjsoTcXH+t1ke71oIomKnh31htPPZawWTTpATPBy3L43g6ytKVplKkKrW
FA2nEHRVUt0jyQT6WebnI43+tTyJbUggSN6xY6qj0b72jj/lKwiyQ1V1R2MJ
hhrPMSERBIZvDXpNOMGU0sxHiV4ENwpu2HbMJdidOW1HiydBXQ7f08uoRfhJ
WuhBMJogiPzJncDS/Gm+niHwT7IujjVqty2CzhIRBHvtNP1bSDBnDZO/dSbB
iodBPa9nEFQHt1JPnQnCcgfGvjHKE6R0LXAi2AT3Ty85Egj7KqlJ9gRxvAt+
P9gR0FGWXXusCK6mVFZNMvrr3FN5Q9MItlR9fzHVqJtNABUxlWDXaZM7tywI
PNty82zMCHpDp3H2TSFoqHWisicT+K0tnj48iUC2S/vwgSmBT3YTP9LopeQl
ebKJBIMnS721JgTe/oPSgxMIKsLsIxyM/g8VRk1o
           "]]}, "Charting`Private`Tag$362669#6"]}}, {}}, {
     DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
      Ticks -> {Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, 
      AxesOrigin -> {-20.72326583694641, -20.714223979804505`}, 
      FrameTicks -> {{Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLines -> {None, None}, 
      DisplayFunction -> Identity, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "ClippingRange" -> {{{-20.72326564898028, \
-11.512925652936358`}, {-20.714223979804505`, -11.41771536729981}}, \
{{-20.72326564898028, -11.512925652936358`}, {-20.714223979804505`, \
-11.41771536729981}}}}, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {-20.72326583694641, -20.714223979804505`}, 
      BaseStyle -> {FontFamily -> "Times"}, 
      CoordinatesToolOptions -> {"DisplayFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& )}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         Style["Total Drug [DTOT] (M)", 20, FontFamily -> "Arial"], None}, {
         Style["Unbound Drug [d] (M)", 20, FontFamily -> "Arial"], None}}, 
      FrameStyle -> Thickness[0.004], 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      FrameTicksStyle -> 20, GridLines -> {None, None}, GridLinesStyle -> 
      Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, PlotLabel -> 
      Style["\!\(\*SubscriptBox[\(K\), \(d\)]\): \[LongDash]100nM  - -1nM \
\!\(\*SubscriptBox[\(K\), \(A\)]\):10", 20, FontFamily -> "Arial"], 
      PlotRange -> {{-Log[1000000000], -
         Log[100000]}, {-20.714223979804505`, -11.41771536729981}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        RGBColor[0, 0, 1], 
        RGBColor[0, 1, 0], 
        Directive[
         RGBColor[1, 0, 0], 
         Thickness[Large]]}, {
        Style[1.*^-6, 20, FontFamily -> "Arial"], 
        Style[1.*^-7, 20, FontFamily -> "Arial"], 
        Style[1.*^-8, 20, FontFamily -> "Arial"]}, LabelStyle -> 12, 
       LegendFunction -> Panel, LegendLabel -> 
       Style["RAF(M)", 20, FontFamily -> "Arial"], LegendLayout -> 
       "Column"]], {Right, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.812994407784314*^9, 3.8321686622364225`*^9, 3.8402046849217443`*^9, 
   3.840206501319479*^9, {3.8406496434766445`*^9, 3.8406496563932285`*^9}, 
   3.8406565877405043`*^9, 3.8407058589715796`*^9, 3.890676448043749*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"541a1811-1d01-4432-85a0-6b24d498b254"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4.5. Analytic Expressions for maximum Fold Change (FC) ", \
"Subsubsection",
 CellChangeTimes->{{3.831920558274994*^9, 3.831920568951131*^9}, {
   3.8319206099444203`*^9, 3.8319206382915373`*^9}, {3.8319228274578667`*^9, 
   3.831922828296911*^9}, {3.831923265609557*^9, 3.831923265941924*^9}, 
   3.832088767728548*^9, {3.8331596529044495`*^9, 3.8331596605908427`*^9}, {
   3.8406531434670486`*^9, 3.840653143591988*^9}, {3.844939118499941*^9, 
   3.844939118668473*^9}},ExpressionUUID->"b280461f-9f56-4f1d-aa3d-\
31ede6df9b6a"],

Cell["\<\
Fold change is defined as the ratio between maximum RAF activity (no/conc of \
active protomers) to that in absence of drug\
\>", "Text",
 CellChangeTimes->{{3.8319210014332504`*^9, 
  3.831921044927513*^9}},ExpressionUUID->"e3cbcad8-35da-4dcd-97f9-\
72e35b9feb2b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rafFC", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"fnActiveRAF", "/", "baselineActiveRAF"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8319206411308155`*^9, 3.831920654543648*^9}, {
   3.8319209514436145`*^9, 3.831920964234915*^9}, {3.8319210462861276`*^9, 
   3.8319210808824434`*^9}, {3.8319211410192847`*^9, 
   3.8319211418294463`*^9}, {3.8319212907129707`*^9, 3.831921293775152*^9}, 
   3.831929927406506*^9, {3.8320860698850856`*^9, 3.8320861755815163`*^9}, {
   3.8320864795071588`*^9, 3.8320865564244003`*^9}, {3.8320866370022855`*^9, 
   3.832086656919811*^9}, {3.8321657983699083`*^9, 3.8321657985708137`*^9}, {
   3.840649711763365*^9, 3.8406497234905877`*^9}, {3.8407058665770035`*^9, 
   3.840705868151228*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"430b95cf-ba36-4e79-9e43-8f52c0dbcdea"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", " ", 
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "+", 
      SubscriptBox["d", "rel"], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], 
         RowBox[{"f", " ", "g"}]]}]]}], ")"}], "2"]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", " ", "g"}], "+", 
      RowBox[{"2", " ", "g", " ", 
       SubscriptBox["d", "rel"]}], "+", 
      SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{3.8406497239192505`*^9, 3.840705868803048*^9, 
  3.890689850611724*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"833f5031-771d-482b-9ac8-4a2e6af87e17"]
}, Open  ]],

Cell["\<\
Activating Range is defined as the lowest concentration above which the drug \
no longer acts as a paradoxical activator and becomes an inhibitor. This \
function is not easily solved analytically, and to understand its variation \
within the range of parameters defined in conditions for PA above, is \
calculated numerically.\
\>", "Text",
 CellChangeTimes->{{3.8319217033257265`*^9, 3.831921756276883*^9}, {
  3.831921925837969*^9, 
  3.831921981729839*^9}},ExpressionUUID->"e029c8cf-0707-4a0a-bcbc-\
f56a0c53a2b6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "1.4.6. ",
 StyleBox["Convert to Python",
  FontColor->RGBColor[0.5, 0, 0.5]]
}], "Subsubsection",
 CellChangeTimes->{{3.7704919114871416`*^9, 3.7704919445024767`*^9}, 
   3.8123825895844336`*^9, {3.812397826965497*^9, 3.812397837097242*^9}, 
   3.832432366892311*^9, {3.833159715284217*^9, 3.8331597166584487`*^9}, {
   3.8406531453875723`*^9, 3.8406531467386913`*^9}, {3.844939119248996*^9, 
   3.844939119402705*^9}},ExpressionUUID->"162df404-efdf-4373-b147-\
74849dec5015"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
   "The", " ", "analytic", " ", "results", " ", "of", " ", "this", " ", 
    "model", " ", "are", " ", "only", " ", "valid", " ", "in", " ", "some", 
    " ", "limits", " ", "so", " ", "to", " ", "fully", " ", "characterize", 
    " ", "the", " ", "model"}], ",", " ", 
   RowBox[{
    RowBox[{"we", " ", "use", " ", "a", " ", "semi"}], "-", 
    RowBox[{
    "analytic", " ", "approach", " ", "where", " ", "we", " ", "solve", " ", 
     "analytically", " ", "simplified", " ", "expressions", " ", 
     RowBox[{"numerically", ".", " "}]}]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.813421080132156*^9, 3.813421137943551*^9}, {
  3.832249883754384*^9, 
  3.832249933492428*^9}},ExpressionUUID->"8d152330-b189-4049-a7e3-\
09ac738ddc85"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
   "Python", " ", "implementation", " ", "of", " ", "the", " ", "full", " ", 
    "model", " ", "works", " ", "best", " ", "if", " ", "we", " ", 
    "analytically", " ", "solve", " ", "unbound", " ", "14"}], "-", "3", "-", 
   RowBox[{
   "3", " ", "as", " ", "a", " ", "function", " ", "of", " ", "unbound", " ", 
    "RAF", " ", 
    RowBox[{"(", "A", ")"}], " ", "and", " ", "undbound", " ", "drug", " ", 
    RowBox[{"(", "d", ")"}], " ", "and", " ", "then", " ", "solve", " ", 
    "the", " ", "RAF", " ", "and", " ", "Drug", " ", "conservation", " ", 
    "equations", " ", 
    RowBox[{"numerically", "."}]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.813421080132156*^9, 3.813421137943551*^9}, {
  3.832249883754384*^9, 
  3.832249930591899*^9}},ExpressionUUID->"8622f49a-39b4-4c17-9b55-\
d6dd1f7f4395"],

Cell["\<\
Run the block \[OpenCurlyQuote]Analytic solutions of the model\
\[CloseCurlyQuote] before converting to python\
\>", "Text",
 CellChangeTimes->{{3.8326897449558125`*^9, 
  3.832689770616206*^9}},ExpressionUUID->"105f5074-c65e-4ae0-82e4-\
139f2b9fb310"],

Cell[CellGroupData[{

Cell[BoxData["eqnsconsrv"], "Input",
 CellChangeTimes->{{3.8407373260503035`*^9, 3.8407373267054305`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"a0c6cdcb-328c-4949-97eb-f135a69daf38"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", "Kd", "+", 
       RowBox[{"KA", " ", "Kd"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["d", "2"], "+", 
           RowBox[{"2", " ", "d", " ", "g", " ", "Kd"}], "+", 
           RowBox[{"f", " ", "g", " ", 
            SuperscriptBox["Kd", "2"]}]}], ")"}]}], 
        RowBox[{"f", " ", "g", " ", "Kd", " ", "Kdim"}]]}], ")"}]}], 
    "\[Equal]", 
    RowBox[{"Kd", " ", "RAF"}]}], ",", 
   RowBox[{
    RowBox[{"d", "+", 
     FractionBox[
      RowBox[{"A", " ", "d"}], "Kd"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["A", "2"], " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"g", " ", "Kd"}]}], ")"}]}], 
      RowBox[{"f", " ", "g", " ", 
       SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", "DTOT"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8407373270751367`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"7b9b09f6-da2f-4ef7-8880-c49ec4ff154e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"baseparams", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"baseparams", ",", 
    RowBox[{"{", 
     RowBox[{"Kd", "->", "0.1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.840732413705201*^9, 3.840732438178855*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"0af04c4f-09e5-4df5-9a4d-327c7a91e5d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"KA", "\[Rule]", "10"}], ",", 
   RowBox[{"Kdim", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"RAF", "\[Rule]", "0.4`"}], ",", 
   RowBox[{"f", "\[Rule]", "0.01`"}], ",", 
   RowBox[{"g", "\[Rule]", "100"}], ",", 
   RowBox[{"Kd", "\[Rule]", "0.1`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8407324388083086`*^9, 3.8407369030723886`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"9111f275-2be5-4c93-bb42-ec7e133e6863"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"fnActiveRAF", "\[IndentingNewLine]", 
 RowBox[{"DTOTeqnLHS", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"eqnsconsrv", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/.", 
    RowBox[{"d", "\[Rule]", 
     RowBox[{
      SubscriptBox["d", "rel"], " ", "Kd"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8134211636647153`*^9, 3.813421222954856*^9}, {
   3.8134212595611086`*^9, 3.813421282414217*^9}, {3.8134213175742826`*^9, 
   3.8134214203525867`*^9}, {3.813421820572929*^9, 3.8134218561918864`*^9}, {
   3.8134218881059895`*^9, 3.813421917161536*^9}, {3.813422143409217*^9, 
   3.8134221438227987`*^9}, {3.8134222666659565`*^9, 
   3.8134222982705493`*^9}, {3.8134223760722322`*^9, 
   3.8134224088689785`*^9}, {3.8134225280461407`*^9, 3.813422651564104*^9}, {
   3.8134230306767406`*^9, 3.81342308547256*^9}, {3.8134234795354877`*^9, 
   3.8134235119078674`*^9}, {3.8134242563400793`*^9, 
   3.8134242585631695`*^9}, {3.813424333898652*^9, 3.813424344415054*^9}, {
   3.8134244054830093`*^9, 3.813424406784157*^9}, 3.8319237262070484`*^9, {
   3.8326946307886257`*^9, 3.8326946850123353`*^9}, {3.8330757327711325`*^9, 
   3.83307573448262*^9}, {3.8402048808292375`*^9, 3.8402049631628265`*^9}, {
   3.8407322338927913`*^9, 3.8407322761052885`*^9}, {3.8407373167545257`*^9, 
   3.8407373332252307`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"adcd7a26-7ec3-4e0c-ac2e-475fb8cae040"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", " ", 
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     SubscriptBox["d", "rel"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "+", 
      SubscriptBox["d", "rel"], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"2", " ", "g", " ", 
             SubscriptBox["d", "rel"]}], "+", 
            SubsuperscriptBox["d", "rel", "2"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], 
         RowBox[{"f", " ", "g"}]]}]]}], ")"}], "2"]}], 
  RowBox[{"8", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", " ", "g"}], "+", 
      RowBox[{"2", " ", "g", " ", 
       SubscriptBox["d", "rel"]}], "+", 
      SubsuperscriptBox["d", "rel", "2"]}], ")"}], "2"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{{3.8402049434946623`*^9, 3.8402049635121813`*^9}, {
   3.8407322482480197`*^9, 3.840732280910565*^9}, 3.8407369048885775`*^9, 
   3.8407373434444895`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"c789442c-cbaf-4830-96ec-b776741f828d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["d", "rel"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"]}], "+", 
        RowBox[{"A", " ", "f", " ", "Kdim"}], "+", 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["A", "2"], " ", 
      SubscriptBox["d", "rel"]}]}], ")"}]}], 
  RowBox[{"f", " ", "g", " ", "Kdim"}]]], "Output",
 CellChangeTimes->{{3.8402049434946623`*^9, 3.8402049635121813`*^9}, {
   3.8407322482480197`*^9, 3.840732280910565*^9}, 3.8407369048885775`*^9, 
   3.8407373434444895`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"3fdcf883-bbb7-40cc-ab37-7a831eb36ca9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "String", " ", "replacement", " ", "functions", " ", "to", " ", "convert", 
    " ", "mathematica", " ", "results", " ", "into", " ", "python"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"names1", "=", 
     RowBox[{"{", 
      RowBox[{"KA", ",", "Kdim", ",", "Kd", ",", "RAF", ",", "f", ",", "g"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"paramnames", "=", 
     RowBox[{"{", 
      RowBox[{"KA", ",", "Kdim", ",", "Kd", ",", "RAF", ",", "f", ",", "g"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"addparams", "[", "x_", "]"}], ":=", 
     RowBox[{"\"\<params['\>\"", "<>", 
      RowBox[{"ToString", "[", "x", "]"}], "<>", "\"\<']\>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"reppython", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<^\>\"", "\[Rule]", "\"\<**\>\""}], ",", 
         RowBox[{"\"\<Sqrt[\>\"", "\[Rule]", "\"\<np.sqrt(\>\""}], ",", 
         RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}], ",", 
         RowBox[{"\"\<->\>\"", "\[Rule]", "\"\<:\>\""}]}], "}"}], ",", 
       RowBox[{"Thread", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"#", "//", "InputForm"}], "]"}], "&"}], "/@", 
           "paramnames"}], ")"}], "->", 
         RowBox[{"(", 
          RowBox[{"addparams", "/@", "names1"}], ")"}]}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Unbound", " ", "RAF"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"tryAsol", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"RAFeqn", "\[Equal]", 
             RowBox[{"Kd", " ", "RAF"}]}], ")"}], "/.", "baseparams"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["d", "rel"], "\[Rule]", 
            RowBox[{
             RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}]}], "}"}]}], ",", 
         RowBox[{"A", "\[GreaterEqual]", "0"}]}], "}"}], ",", "A"}], "]"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Active", " ", "Kinase"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", 
       RowBox[{"fnActiveRAF", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["RAF", "rel"], "\[Rule]", 
           RowBox[{"RAF", "/", "Kdim"}]}], ",", 
          RowBox[{
           SubscriptBox["d", "rel"], "\[Rule]", 
           RowBox[{"d", "/", "Kd"}]}]}], "}"}]}], "]"}], "]"}], ",", 
     "reppython"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "Validation", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fnActiveRAF", "/.", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["RAF", "rel"], "\[Rule]", 
          RowBox[{"RAF", "/", "Kdim"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["d", "rel"], "\[Rule]", 
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}]}], "}"}]}], "/.", 
      "baseparams"}], ",", "10"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7704920138853006`*^9, 3.7704920353261833`*^9}, {
   3.7704921129339495`*^9, 3.770492135710803*^9}, {3.770492174328393*^9, 
   3.770492272814272*^9}, {3.7704923632304277`*^9, 3.7704923723502135`*^9}, {
   3.7704924330859566`*^9, 3.770492581244342*^9}, {3.770492730237709*^9, 
   3.770492736443832*^9}, {3.770492815742259*^9, 3.7704928185155263`*^9}, {
   3.7704930077890444`*^9, 3.7704930117396774`*^9}, {3.8123988088913603`*^9, 
   3.812398809289182*^9}, {3.8134184072755165`*^9, 3.8134184112702684`*^9}, {
   3.8134201614072924`*^9, 3.813420207458439*^9}, {3.81342193745055*^9, 
   3.8134219657080927`*^9}, 3.8319237262226486`*^9, {3.832431594177392*^9, 
   3.832431594177392*^9}, {3.8326947021270723`*^9, 3.8326947040820785`*^9}, {
   3.83269487140688*^9, 3.8326949118468947`*^9}, {3.8326955443598905`*^9, 
   3.8326955483900394`*^9}, {3.83269617297003*^9, 3.832696194736244*^9}, {
   3.833045049185959*^9, 3.833045128668701*^9}, {3.840204970121526*^9, 
   3.840205028103076*^9}, {3.840732311191211*^9, 3.840732342789525*^9}, {
   3.84073245979243*^9, 3.840732466862323*^9}, {3.8407327776496763`*^9, 
   3.840732784107133*^9}, 3.840732914503558*^9, 3.8407367951647825`*^9, {
   3.8407371112346945`*^9, 3.840737155960045*^9}, {3.8407373484655247`*^9, 
   3.8407373491530085`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"c8633a90-3a95-4c5b-9e9f-98b6b88d7d58"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"A", "\[Rule]", "0.009957620521767154`"}], "}"}]], "Output",
 CellChangeTimes->{{3.813420148781396*^9, 3.8134201631269407`*^9}, 
   3.813420207843923*^9, {3.8134219628546524`*^9, 3.8134219663044305`*^9}, 
   3.813423097312482*^9, 3.8134319801092105`*^9, {3.8326952211486235`*^9, 
   3.8326952416730795`*^9}, {3.8326959137651343`*^9, 3.832695916886273*^9}, 
   3.832696196396628*^9, 3.8330450329888043`*^9, {3.833045111692555*^9, 
   3.833045129070509*^9}, {3.8402050122098856`*^9, 3.8402050289280424`*^9}, {
   3.8407323058579845`*^9, 3.84073232022552*^9}, 3.8407323524722185`*^9, {
   3.8407324414377384`*^9, 3.8407324677035975`*^9}, 3.8407327844297533`*^9, 
   3.840732915359844*^9, 3.840736911197631*^9, {3.8407371350909758`*^9, 
   3.8407371564301033`*^9}, 3.840737350138365*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"ab566221-e8f8-4818-b130-b218ff957dcf"],

Cell[BoxData["\<\"(params['f']*params['g']**2*(params['f'] + \
d/params['Kd'])*params['Kdim']*(1 + params['KA'] + d/params['Kd'] - \
np.sqrt((1 + params['KA'] + d/params['Kd'])**2 + (8*(params['f']*params['g'] \
+ d**2/params['Kd']**2 + \
(2*d*params['g'])/params['Kd'])*params['RAF'])/(params['f']*params['g']*\
params['Kdim'])))**2)/(8*(params['f']*params['g'] + d**2/params['Kd']**2 + \
(2*d*params['g'])/params['Kd'])**2*params['RAF'])\"\>"], "Output",
 CellChangeTimes->{{3.813420148781396*^9, 3.8134201631269407`*^9}, 
   3.813420207843923*^9, {3.8134219628546524`*^9, 3.8134219663044305`*^9}, 
   3.813423097312482*^9, 3.8134319801092105`*^9, {3.8326952211486235`*^9, 
   3.8326952416730795`*^9}, {3.8326959137651343`*^9, 3.832695916886273*^9}, 
   3.832696196396628*^9, 3.8330450329888043`*^9, {3.833045111692555*^9, 
   3.833045129070509*^9}, {3.8402050122098856`*^9, 3.8402050289280424`*^9}, {
   3.8407323058579845`*^9, 3.84073232022552*^9}, 3.8407323524722185`*^9, {
   3.8407324414377384`*^9, 3.8407324677035975`*^9}, 3.8407327844297533`*^9, 
   3.840732915359844*^9, 3.840736911197631*^9, {3.8407371350909758`*^9, 
   3.8407371564301033`*^9}, 3.840737350143661*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"5dc5ced0-6b32-483a-b803-bf18fe3bfaf1"],

Cell[BoxData["0.35552076916211589052707608971104491502`10."], "Output",
 CellChangeTimes->{{3.813420148781396*^9, 3.8134201631269407`*^9}, 
   3.813420207843923*^9, {3.8134219628546524`*^9, 3.8134219663044305`*^9}, 
   3.813423097312482*^9, 3.8134319801092105`*^9, {3.8326952211486235`*^9, 
   3.8326952416730795`*^9}, {3.8326959137651343`*^9, 3.832695916886273*^9}, 
   3.832696196396628*^9, 3.8330450329888043`*^9, {3.833045111692555*^9, 
   3.833045129070509*^9}, {3.8402050122098856`*^9, 3.8402050289280424`*^9}, {
   3.8407323058579845`*^9, 3.84073232022552*^9}, 3.8407323524722185`*^9, {
   3.8407324414377384`*^9, 3.8407324677035975`*^9}, 3.8407327844297533`*^9, 
   3.840732915359844*^9, 3.840736911197631*^9, {3.8407371350909758`*^9, 
   3.8407371564301033`*^9}, 3.8407373501478577`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"030b9995-ab5d-49b7-80a8-74d5e146218c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "RAF", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", "RAFeqn", "]"}], "]"}], ",", "reppython"}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "Validation", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RAF", "-", "RAFeqn"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A", "\[Rule]", "0.001"}], ",", 
         RowBox[{
          SubscriptBox["d", "rel"], "\[Rule]", 
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}]}]}], "}"}]}], "/.", 
      "baseparams"}], ",", "10"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8326953170418234`*^9, 3.8326953301996627`*^9}, {
  3.832695537622925*^9, 3.8326955415208607`*^9}, {3.832696246887146*^9, 
  3.8326962486792135`*^9}, {3.8402050434579024`*^9, 3.840205043737171*^9}, {
  3.840732485285264*^9, 3.840732489518019*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"a7004a1d-906a-42b2-98cd-5d67d5976763"],

Cell[BoxData["\<\"(A*params['Kd']*(params['f']*params['g']*(2*A + \
params['Kdim'] + params['KA']*params['Kdim']) + params['g']*(4*A + \
params['f']*params['Kdim'])*dr + \
2*A*dr**2))/(params['f']*params['g']*params['Kdim'])\"\>"], "Output",
 CellChangeTimes->{
  3.832695332491807*^9, 3.832695918433138*^9, {3.832696222926503*^9, 
   3.8326962489948616`*^9}, 3.833045160548159*^9, {3.8402050379305253`*^9, 
   3.840205044060116*^9}, 3.84073250203303*^9, 3.840736921895876*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"3e543919-b2a6-4e51-b85c-ab49b42d16ce"],

Cell[BoxData["0.39854344660940677069760340600623749197`10."], "Output",
 CellChangeTimes->{
  3.832695332491807*^9, 3.832695918433138*^9, {3.832696222926503*^9, 
   3.8326962489948616`*^9}, 3.833045160548159*^9, {3.8402050379305253`*^9, 
   3.840205044060116*^9}, 3.84073250203303*^9, 3.8407369219028926`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"91382f02-0a0f-4e5b-b32b-b98083b0c440"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DTOTeqnLHS", "/.", "tryAsol"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["d", "rel"], "\[Rule]", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}]}], "}"}]}], "/.", 
    "baseparams"}], ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.840737365457438*^9, 3.840737392722887*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"a6aed713-b6e0-46b0-9e7a-2c74b799627a"],

Cell[BoxData["0.21896854471436980049681153559504309669`10."], "Output",
 CellChangeTimes->{{3.8407373687773094`*^9, 3.840737395164567*^9}},
 CellLabel->"Out[79]=",ExpressionUUID->"326b03a8-6c88-45ea-9462-783b27cbe0b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Drug", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"DTOTeqnLHSA", "=", 
     RowBox[{"SimplifyPars", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"DTOTeqnLHS", "/.", "sol4A"}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["RAF", "rel"], "\[Rule]", 
          RowBox[{"RAF", "/", "Kdim"}]}], ",", 
         RowBox[{
          SubscriptBox["d", "rel"], "\[Rule]", 
          RowBox[{"d", "/", "Kd"}]}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", "DTOTeqnLHSA", "]"}], "]"}], ",", 
     "reppython"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "Validation", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DTOTeqnLHSA", "/.", 
       RowBox[{"{", 
        RowBox[{"d", "\[Rule]", 
         RowBox[{"Kd", "*", 
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}]}]}], "}"}]}], "/.", 
      "baseparams"}], ",", "10"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8326953170418234`*^9, 3.832695354942745*^9}, {
  3.832695529479746*^9, 3.8326955346962957`*^9}, {3.832696268043007*^9, 
  3.832696277801447*^9}, {3.8407325131534557`*^9, 3.8407325156307116`*^9}, {
  3.840736926576873*^9, 3.840737056686473*^9}, {3.840737173853619*^9, 
  3.8407372755030346`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"4173856d-a832-4452-ab03-72bb6aa25396"],

Cell[BoxData["\<\"(d*(8*(d**2 + 2*d*params['g']*params['Kd'] + \
params['f']*params['g']*params['Kd']**2)**2 - 2*params['f']*params['g']*(d**2 \
+ 2*d*params['g']*params['Kd'] + \
params['f']*params['g']*params['Kd']**2)*params['Kdim']*(d + params['Kd'] + \
params['KA']*params['Kd'] - np.sqrt((d + params['Kd'] + \
params['KA']*params['Kd'])**2 + (8*(d**2 + 2*d*params['g']*params['Kd'] + \
params['f']*params['g']*params['Kd']**2)*params['RAF'])/(params['f']*params['\
g']*params['Kdim']))) + d*params['f']*params['g']*params['Kdim']*(d + \
params['Kd'] + params['KA']*params['Kd'] - np.sqrt((d + params['Kd'] + \
params['KA']*params['Kd'])**2 + (8*(d**2 + 2*d*params['g']*params['Kd'] + \
params['f']*params['g']*params['Kd']**2)*params['RAF'])/(params['f']*params['\
g']*params['Kdim'])))**2 + \
params['f']*params['g']**2*params['Kd']*params['Kdim']*(d + params['Kd'] + \
params['KA']*params['Kd'] - np.sqrt((d + params['Kd'] + \
params['KA']*params['Kd'])**2 + (8*(d**2 + 2*d*params['g']*params['Kd'] + \
params['f']*params['g']*params['Kd']**2)*params['RAF'])/(params['f']*params['\
g']*params['Kdim'])))**2))/(8*(d**2 + 2*d*params['g']*params['Kd'] + \
params['f']*params['g']*params['Kd']**2)**2)\"\>"], "Output",
 CellChangeTimes->{3.84073727674548*^9, 3.840737396724597*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"69797233-a8a5-4569-9a25-daaf04ac4997"],

Cell[BoxData["0.21896854471436971723008468870830256492`10."], "Output",
 CellChangeTimes->{3.84073727674548*^9, 3.840737396724597*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"226cd914-04d8-44c6-bec9-103d19be83ad"]
}, Open  ]],

Cell["\<\
All the numerically output values are compared with respective python output \
to validate the function transfer.\
\>", "Text",
 CellChangeTimes->{{3.8407374101843853`*^9, 
  3.840737428168679*^9}},ExpressionUUID->"25e7cf92-ccd8-429c-8298-\
88f45b496f77"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Section 1.5. Unified Model: fully-analytic solution to special case where g=f\
\>", "Subsection",
 CellChangeTimes->{{3.76919880174008*^9, 3.7691988613532224`*^9}, 
   3.769273566954769*^9, {3.8402032805684576`*^9, 3.840203284256183*^9}, 
   3.8402033256104307`*^9, {3.8402033853654327`*^9, 3.840203389849573*^9}, {
   3.840733058405177*^9, 3.8407330679725523`*^9}, 3.8407331292345624`*^9, {
   3.8407336035174503`*^9, 3.8407336071610203`*^9}, {3.8407376086845827`*^9, 
   3.8407376551881824`*^9}, {3.844885273315256*^9, 3.844885273349594*^9}, {
   3.8906750094773207`*^9, 3.8906750096491766`*^9}, {3.8906906383634195`*^9, 
   3.8906906442906275`*^9}},ExpressionUUID->"49b79216-cf44-491a-9767-\
a58cf0b584ac"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.769456144052461*^9, 3.7694561471807184`*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"80e4128c-1195-467d-ae99-4c5e3d21a220"],

Cell[CellGroupData[{

Cell["1.5.1. Analytic Solution to the model", "Subsubsection",
 CellChangeTimes->{{3.7692694154543457`*^9, 3.7692694289690504`*^9}, {
  3.769436772449255*^9, 3.769436772675357*^9}, {3.8324323477216988`*^9, 
  3.83243234796869*^9}, {3.8331596409988627`*^9, 3.8331596677817163`*^9}, {
  3.840653138832727*^9, 3.8406531391140285`*^9}, {3.8407376207635946`*^9, 
  3.840737620863952*^9}, {3.8448856584025135`*^9, 
  3.844885658433798*^9}},ExpressionUUID->"ccc2ae3c-d859-48c6-a5e0-\
1c5c57602d0d"],

Cell["\<\
This model is a solvable limit to the general all-mechanisms model and can \
therefore be used to test some of the analytic results. However, it is not \
compatible with the data. f<1 and g>1 respectively support PA mechanism and \
f>1 and g<1 do not. Therefore f=g with PA extant would mean that the two \
mechanisms act in opposite  manner relative to PA. This may still be \
instructive as a theoretical limit applicable in dimer kinase inhibition \
where positive cooperativity as well as dimer stabilization mechanisms exist.\
\>", "Text",
 CellChangeTimes->{{3.7692038930283422`*^9, 3.769204042191204*^9}, {
   3.7692041782201395`*^9, 3.769204211165009*^9}, {3.7692042428710303`*^9, 
   3.769204276661768*^9}, {3.7692675966867456`*^9, 3.769267724788076*^9}, 
   3.840204405025261*^9, {3.8906906536194487`*^9, 
   3.890690823498042*^9}},ExpressionUUID->"371afa2c-3d88-4db2-a050-\
7d08248f3497"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vars", "=", 
    RowBox[{"{", 
     RowBox[{
     "a", ",", "A", ",", "d", ",", "AA", ",", "Ad", ",", "AAd", ",", "AdAd"}],
      "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"A", " ", "list", " ", "of", " ", "all", " ", "variables"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep5", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AA", "\[Rule]", 
       FractionBox[
        SuperscriptBox["A", "2"], "Kdim"]}], ",", 
      RowBox[{"AAd", "\[Rule]", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"], "d"}], 
        RowBox[{"f", " ", "Kdim", " ", "Kd"}]]}], ",", 
      RowBox[{"AdAd", "\[Rule]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["A", "2"], 
         SuperscriptBox["d", "2"]}], 
        RowBox[{"f", " ", "g", " ", "Kdim", " ", 
         SuperscriptBox["Kd", "2"]}]]}], ",", 
      RowBox[{"Ad", "\[Rule]", 
       FractionBox[
        RowBox[{"A", " ", "d"}], "Kd"]}], ",", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"A", " ", "KA"}]}]}], "}"}], "/.", 
    RowBox[{"g", "\[Rule]", "f"}]}]}], ";", " ", 
  RowBox[{"(*", 
   RowBox[{"derived", " ", "from", " ", "equilibrium", " ", "relationships"}],
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Consrv", "[", "eqns_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"eqns", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "5", "]"}], "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"eqns", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "+", 
          RowBox[{"eqns", "[", 
           RowBox[{"[", "6", "]"}], "]"}], "+", 
          RowBox[{"eqns", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"eqns", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "5", "]"}], "]"}], "+", 
       RowBox[{"eqns", "[", 
        RowBox[{"[", "6", "]"}], "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"eqns", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ")"}]}]}], "]"}]}], "}"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{
   "conservation", " ", "relations", " ", "for", " ", "RAF", " ", "and", " ", 
    "DTOT"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"eqnsconsrv", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Consrv", "[", "vars", "]"}], "/.", "rep5"}], "]"}], 
      "\[Equal]", 
      RowBox[{"{", 
       RowBox[{"RAF", ",", "DTOT"}], "}"}]}], "]"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7692042154998837`*^9, 3.7692042369245358`*^9}, {
   3.769204285127771*^9, 3.769204341657061*^9}, {3.769204538745946*^9, 
   3.769204548488737*^9}, {3.7692045887400646`*^9, 3.7692047475109215`*^9}, {
   3.769204807283332*^9, 3.7692048197677355`*^9}, {3.7692050383825026`*^9, 
   3.769205039460601*^9}, 3.7692678297233763`*^9, {3.769267866117442*^9, 
   3.769267932844144*^9}, 3.831920876102366*^9, {3.840203420465253*^9, 
   3.8402034244005575`*^9}, {3.8402034588172636`*^9, 3.840203493631587*^9}, {
   3.8402035590005283`*^9, 3.8402036105294175`*^9}, {3.840203640947667*^9, 
   3.840203652149537*^9}, 3.8402044050372953`*^9, 3.840556372264454*^9, 
   3.8405566153999057`*^9, {3.840733139434615*^9, 3.8407331730542107`*^9}, {
   3.890675018602501*^9, 3.890675023197539*^9}, 3.890689499340227*^9, {
   3.8906900703148484`*^9, 3.8906900708781595`*^9}, {3.890690113513013*^9, 
   3.8906901232048807`*^9}, {3.8906901712157707`*^9, 3.890690171403742*^9}, 
   3.890690300397255*^9, {3.8906905194303937`*^9, 3.8906905244204683`*^9}, {
   3.890690566342193*^9, 3.8906906297019587`*^9}},
 CellLabel->
  "In[284]:=",ExpressionUUID->"84e6e251-61f9-45d0-8074-8dfb60cb940f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"A", " ", "f", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "Kd", "+", 
        RowBox[{"KA", " ", "Kd"}]}], ")"}]}], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["A", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"f", " ", "Kd"}]}], ")"}], "2"]}], 
      RowBox[{"f", " ", "Kd", " ", "Kdim"}]]}], "\[Equal]", 
    RowBox[{"f", " ", "Kd", " ", "RAF"}]}], ",", 
   RowBox[{
    RowBox[{"d", "+", 
     FractionBox[
      RowBox[{"A", " ", "d"}], "Kd"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["A", "2"], " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"f", " ", "Kd"}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["f", "2"], " ", 
       SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", "DTOT"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.84020358612233*^9, {3.8402036420185766`*^9, 3.840203652476896*^9}, {
   3.8402084225567703`*^9, 3.84020847107111*^9}, 3.840209416490608*^9, 
   3.840209908004015*^9, 3.840556307393776*^9, 3.840556616552673*^9, 
   3.8405622173626137`*^9, 3.8405635249126854`*^9, 3.8405636880528765`*^9, {
   3.8406523971563377`*^9, 3.840652418080085*^9}, {3.8407322676841116`*^9, 
   3.8407322787473526`*^9}, 3.840733146992045*^9, 3.840733179988722*^9, 
   3.8407377158640547`*^9, 3.840792418418745*^9, 3.8906898550406456`*^9, 
   3.8906900815247145`*^9, 3.8906901238147173`*^9, 3.890690172013217*^9, 
   3.8906903009597225`*^9, 3.8906905248272495`*^9, {3.8906905737070384`*^9, 
   3.890690597748309*^9}, 3.8906906314359913`*^9, 3.8906907602205086`*^9, 
   3.890690825108821*^9},
 CellLabel->
  "Out[285]=",ExpressionUUID->"e7a10446-aa26-43a1-a66d-d68074800df1"]
}, Open  ]],

Cell["\<\
A simultaneous solution to both the above conservation equations is unwieldy \
and hard to obtain. Instead, we find partial solutions for kinase protomers \
as a function of free drug and then free drug as a function of the total drug \
and the kinase protomers. The latter solution is used to numerically \
construct d vs DTOT relationship.\
\>", "Text",
 CellChangeTimes->{{3.769268480156312*^9, 3.7692685358509054`*^9}, {
  3.769268566916627*^9, 
  3.7692686085566883`*^9}},ExpressionUUID->"f5bebb76-94b3-4006-87be-\
ac56886eb848"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SimplifyPars", "[", "x_", "]"}], ":=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RAF", ">", "0"}], ",", 
       RowBox[{"DTOT", ">", "0"}], ",", 
       RowBox[{"Kd", ">", "0"}], ",", 
       RowBox[{"Kdim", ">", "0"}], ",", 
       RowBox[{"KA", ">", "0"}], ",", 
       RowBox[{"d", ">", "0"}], ",", 
       RowBox[{"f", ">", "0"}], ",", 
       RowBox[{"g", ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["d", "rel"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol5A", "=", 
   RowBox[{
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"eqnsconsrv", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "A"}], "]"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "  ", 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"sol5d", "=", 
  RowBox[{
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eqnsconsrv", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "d"}], "]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"Second", " ", "solution", " ", "is", " ", "positive"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7692048471231923`*^9, 3.769204893862154*^9}, {
   3.76920497064507*^9, 3.7692050944975214`*^9}, {3.7692051323859997`*^9, 
   3.7692051514924307`*^9}, 3.7692052273412123`*^9, {3.769265303470145*^9, 
   3.7692653221119733`*^9}, {3.769265358603253*^9, 3.769265393912998*^9}, {
   3.7692654276106925`*^9, 3.769265462871611*^9}, {3.7692660477712846`*^9, 
   3.7692660513184977`*^9}, {3.7692663939422703`*^9, 
   3.7692664234293437`*^9}, {3.7692681049231358`*^9, 3.769268105891485*^9}, {
   3.7692682434167233`*^9, 3.7692682738420897`*^9}, {3.7692683203389816`*^9, 
   3.7692683654636745`*^9}, {3.769436803124284*^9, 3.7694368039228525`*^9}, {
   3.812208796618473*^9, 3.812208800884694*^9}, {3.8402036688763957`*^9, 
   3.840203717780062*^9}, 3.8402044050482736`*^9, {3.8402086149337215`*^9, 
   3.8402086163065677`*^9}, {3.8406524039042435`*^9, 
   3.8406524114524503`*^9}, {3.840733183168522*^9, 3.840733185235975*^9}},
 CellLabel->
  "In[286]:=",ExpressionUUID->"fd44713d-796f-47a0-8952-f78129b136c4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"A", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"f", " ", "Kd", " ", "Kdim", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", "f"}], "+", 
        RowBox[{"f", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["f", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"d", "+", "Kd", "+", 
              RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"f", " ", "Kd"}]}], ")"}], "2"], " ", "RAF"}], 
           "Kdim"]}]]}], ")"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"f", " ", "Kd"}]}], ")"}], "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, {
   3.8402084253169756`*^9, 3.840208471136625*^9}, 3.8402086172796245`*^9, 
   3.8402094196491776`*^9, 3.8402099083705187`*^9, 3.8405563078312774`*^9, 
   3.840556618554001*^9, 3.8405622177162385`*^9, 3.8405635252981243`*^9, 
   3.840563688424765*^9, {3.8406523996172123`*^9, 3.8406524210731707`*^9}, {
   3.8407322681005325`*^9, 3.840732278857686*^9}, 3.8407331539434814`*^9, 
   3.84073318707836*^9, 3.8407377161550455`*^9, 3.8407924188669367`*^9, 
   3.890689872376589*^9, 3.8906900853558817`*^9, 3.890690128832232*^9, 
   3.8906901746245284`*^9, 3.8906903031327534`*^9, 3.890690536449683*^9, 
   3.8906906010788383`*^9, 3.8906908284565134`*^9},
 CellLabel->
  "Out[287]=",ExpressionUUID->"38a7628a-142d-49a2-a148-46b07b790ddf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"f", " ", "Kd", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["A", "2"]}], "+", 
        RowBox[{"A", " ", "f", " ", "Kdim"}], "+", 
        RowBox[{"f", " ", "Kd", " ", "Kdim"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["A", "2"], " ", "DTOT", " ", "Kdim"}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["A", "2"]}], "+", 
             RowBox[{"A", " ", "f", " ", "Kdim"}], "+", 
             RowBox[{"f", " ", "Kd", " ", "Kdim"}]}], ")"}], "2"]}]]}], 
       ")"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["A", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.840203686605233*^9, 3.8402037195899286`*^9}, {
   3.8402084253169756`*^9, 3.840208471136625*^9}, 3.8402086172796245`*^9, 
   3.8402094196491776`*^9, 3.8402099083705187`*^9, 3.8405563078312774`*^9, 
   3.840556618554001*^9, 3.8405622177162385`*^9, 3.8405635252981243`*^9, 
   3.840563688424765*^9, {3.8406523996172123`*^9, 3.8406524210731707`*^9}, {
   3.8407322681005325`*^9, 3.840732278857686*^9}, 3.8407331539434814`*^9, 
   3.84073318707836*^9, 3.8407377161550455`*^9, 3.8407924188669367`*^9, 
   3.890689872376589*^9, 3.8906900853558817`*^9, 3.890690128832232*^9, 
   3.8906901746245284`*^9, 3.8906903031327534`*^9, 3.890690536449683*^9, 
   3.8906906010788383`*^9, 3.8906908286441593`*^9},
 CellLabel->
  "Out[288]=",ExpressionUUID->"52b22ecc-fc97-477e-b848-57a70bbaa2ac"]
}, Open  ]],

Cell["\<\
We estimate the total activity by counting all of the drug-free protomers \
which occur within a partly active or fully active dimer. Substituting the \
above solution into the expression for Raf activity and dividing by total RAF \
concentration, we obtain the proportionate activity as a function of total \
drug and other parameters.\
\>", "Text",
 CellChangeTimes->{{3.7692051569956264`*^9, 3.7692052249831033`*^9}, {
   3.7692053058924074`*^9, 3.7692053326957016`*^9}, {3.7692665900295753`*^9, 
   3.7692665948921833`*^9}, 3.7692684645670233`*^9, {3.7692686287467785`*^9, 
   3.7692686294649706`*^9}},ExpressionUUID->"0006f8e3-0d4f-4391-9f03-\
8114fe7dd0a0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RafActivity", "[", "vars_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"vars", "[", 
     RowBox[{"[", "4", "]"}], "]"}]}], " ", "+", " ", 
   RowBox[{"vars", "[", 
    RowBox[{"[", "6", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fnActiveRAF5", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RafActivity", "[", "vars", "]"}], "/", "RAF"}], "/.", 
      "rep5"}], "/.", "sol5A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repratios", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kdim", "\[Rule]", 
      FractionBox["RAF", 
       SubscriptBox["RAF", "rel"]]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"Kd", " ", 
       SubscriptBox["d", "rel"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAF5", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"fnActiveRAF5", "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"fnActiveRAF52", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"fnActiveRAF5", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"KA", "\[Rule]", 
        RowBox[{"E1c", "-", "1", "-", 
         SubscriptBox["d", "rel"]}]}], ",", 
       RowBox[{
        SubscriptBox["RAF", "rel"], "\[Rule]", 
        RowBox[{"E2u2", " ", "*", 
         RowBox[{
          RowBox[{"f", "/", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{
              SubscriptBox["d", "rel"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{"f", " ", 
                 SubscriptBox["d", "rel"]}]}], ")"}]}]}], ")"}]}], " ", "/", 
          "8"}]}]}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.769205220141611*^9, 3.769205289672014*^9}, {
   3.769205345593025*^9, 3.769205353284094*^9}, {3.7692054655437536`*^9, 
   3.7692054685969486`*^9}, {3.769265526917851*^9, 3.7692655613369493`*^9}, {
   3.7692655940807266`*^9, 3.7692657331243925`*^9}, {3.7692657719746237`*^9, 
   3.769265864876149*^9}, {3.7692658997040854`*^9, 3.7692659006156936`*^9}, {
   3.769266749046686*^9, 3.769266750912019*^9}, {3.769268445259807*^9, 
   3.76926844899031*^9}, {3.769268639956765*^9, 3.769268644269384*^9}, {
   3.769268830483199*^9, 3.7692688709844255`*^9}, {3.7692689173114767`*^9, 
   3.769269038442933*^9}, {3.769269089183334*^9, 3.769269285211043*^9}, {
   3.7692695137259455`*^9, 3.7692695528466825`*^9}, {3.769269651781829*^9, 
   3.76926965421002*^9}, {3.7694368136077976`*^9, 3.7694368142564898`*^9}, {
   3.7694375986201754`*^9, 3.7694376029376187`*^9}, {3.7694382649841013`*^9, 
   3.769438269629182*^9}, {3.769439034726965*^9, 3.7694390745272303`*^9}, {
   3.812214333570692*^9, 3.812214391783123*^9}, {3.8123859575711336`*^9, 
   3.812386008423128*^9}, {3.8123860614959884`*^9, 3.8123861254690137`*^9}, 
   3.831474994890194*^9, {3.8319208702531366`*^9, 3.831920870955785*^9}, {
   3.8319211759273367`*^9, 3.8319211759273367`*^9}, {3.8319237689036894`*^9, 
   3.8319237970863533`*^9}, {3.831923844715188*^9, 3.831923850773985*^9}, {
   3.831924074308251*^9, 3.8319240757594156`*^9}, {3.840203742192509*^9, 
   3.8402039027208576`*^9}, {3.840203969207242*^9, 3.8402039799679236`*^9}, {
   3.840204018691835*^9, 3.840204049292286*^9}, 3.840208620490014*^9, {
   3.840556125640686*^9, 3.8405561283031545`*^9}, 3.840556621532282*^9, {
   3.8406524512431946`*^9, 3.840652459172752*^9}, {3.840652823634708*^9, 
   3.840652837369789*^9}, {3.840733194766425*^9, 3.840733297237683*^9}, {
   3.8906899105389376`*^9, 3.890689913495778*^9}, {3.890689954182922*^9, 
   3.890689959204342*^9}},
 CellLabel->
  "In[289]:=",ExpressionUUID->"cfcea57b-b8eb-4ba3-b6eb-12b24897d35f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", "KA"}], "+", 
      RowBox[{"f", " ", 
       SubscriptBox["d", "rel"]}], "-", 
      SqrtBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["f", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "KA", "+", 
            SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"f", "+", 
            SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"]}], 
  RowBox[{"8", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      SubscriptBox["d", "rel"]}], ")"}], "3"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, {3.840208455288518*^9, 
   3.8402084712106323`*^9}, 3.8402094223121557`*^9, 3.8402099121853905`*^9, 
   3.8405563102290754`*^9, 3.84055662444647*^9, 3.840562219598998*^9, 
   3.840563526960758*^9, 3.840563690214009*^9, 3.8406524691688547`*^9, {
   3.840652827519314*^9, 3.8406528378547935`*^9}, {3.8407322713626957`*^9, 
   3.8407322790738554`*^9}, 3.8407332356838193`*^9, {3.840733267430028*^9, 
   3.840733299127699*^9}, 3.8407377191773767`*^9, 3.840792421495686*^9, 
   3.890689877709708*^9, 3.8906899179823427`*^9, 3.890689965600691*^9, 
   3.890690089984103*^9, 3.8906901351458206`*^9, 3.8906901798007264`*^9, 
   3.890690307354731*^9, 3.890690558913643*^9, 3.890690831568513*^9},
 CellLabel->
  "Out[292]=",ExpressionUUID->"2e38ebdb-b4dc-4859-be78-bb5ffa4fc0b2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"f", "+", 
     RowBox[{
      SubscriptBox["d", "rel"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"f", " ", 
         SubscriptBox["d", "rel"]}]}], ")"}]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "E1c"}], " ", "f"}], "+", 
      SqrtBox[
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["E1c", "2"], " ", "f"}], "+", 
          FractionBox[
           RowBox[{"E2u2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"f", "+", 
               SubscriptBox["d", "rel"]}], ")"}], "2"]}], 
           RowBox[{"f", "+", 
            RowBox[{
             SubscriptBox["d", "rel"], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"f", " ", 
                SubscriptBox["d", "rel"]}]}], ")"}]}]}]]}], ")"}]}]]}], ")"}],
     "2"]}], 
  RowBox[{"E2u2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      SubscriptBox["d", "rel"]}], ")"}], "3"]}]]], "Output",
 CellChangeTimes->{{3.8402037426185713`*^9, 3.840203748624338*^9}, {
   3.840203800486279*^9, 3.8402038148719597`*^9}, {3.8402038610912046`*^9, 
   3.8402039034223003`*^9}, {3.840203976247012*^9, 3.84020398036878*^9}, {
   3.8402040322958746`*^9, 3.840204049793034*^9}, {3.840208455288518*^9, 
   3.8402084712106323`*^9}, 3.8402094223121557`*^9, 3.8402099121853905`*^9, 
   3.8405563102290754`*^9, 3.84055662444647*^9, 3.840562219598998*^9, 
   3.840563526960758*^9, 3.840563690214009*^9, 3.8406524691688547`*^9, {
   3.840652827519314*^9, 3.8406528378547935`*^9}, {3.8407322713626957`*^9, 
   3.8407322790738554`*^9}, 3.8407332356838193`*^9, {3.840733267430028*^9, 
   3.840733299127699*^9}, 3.8407377191773767`*^9, 3.840792421495686*^9, 
   3.890689877709708*^9, 3.8906899179823427`*^9, 3.890689965600691*^9, 
   3.890690089984103*^9, 3.8906901351458206`*^9, 3.8906901798007264`*^9, 
   3.890690307354731*^9, 3.890690558913643*^9, 3.8906908322091618`*^9},
 CellLabel->
  "Out[293]=",ExpressionUUID->"0df143a1-2efd-424d-98a0-5abe81fe62c9"]
}, Open  ]],

Cell["\<\
Note that the above equations represent the total active RAF protomers in \
proportion to the total RAF kinase as a function of unbound drug (d). In \
order to analytically establish parameter values which correspond to \
activation of the kinase, we find the first derivative of this function \
(equation 11) and search for it\[CloseCurlyQuote]s zeroes (equation 12).\
\>", "Text",
 CellChangeTimes->{{3.8314750261787057`*^9, 3.831475036190924*^9}, {
  3.8324318762945156`*^9, 
  3.832431882900982*^9}},ExpressionUUID->"14a018b4-aeb0-44c5-a292-\
b2ad7df71c42"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RafDimers", "[", "eqns_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"eqns", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "+", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fnDimers5", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RafDimers", "[", "vars", "]"}], "/", "RAF"}], "/.", 
        "rep5"}], "/.", "sol5A"}], ")"}], "/.", "repratios"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"fnDimers5", "/", "fnActiveRAF5"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8319238615172873`*^9, 3.83192390513754*^9}, {
   3.831923943703373*^9, 3.8319239810051637`*^9}, {3.83192408057911*^9, 
   3.8319240873711205`*^9}, 3.84020440505526*^9, {3.840204452736744*^9, 
   3.840204473036141*^9}, 3.840208625048671*^9, {3.840556628223157*^9, 
   3.840556661079576*^9}, {3.8407333044299984`*^9, 3.840733315215381*^9}},
 CellLabel->
  "In[294]:=",ExpressionUUID->"582ed880-a0fb-4bd3-b4bc-45828e3012da"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "f"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "KA", "+", 
        SubscriptBox["d", "rel"]}], ")"}]}], "+", 
     SqrtBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["f", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"f", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"], 
  RowBox[{"16", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840208471858531*^9, 3.840209423453854*^9, 3.840209913429438*^9, 
   3.8405563114250174`*^9, {3.8405566396889153`*^9, 3.8405566614566936`*^9}, 
   3.840562220507329*^9, 3.840563527832856*^9, 3.8405636910686436`*^9, 
   3.840652578620533*^9, {3.8407322724585733`*^9, 3.840732279151969*^9}, 
   3.840733316497733*^9, 3.8407377202995086`*^9, 3.840792422329224*^9, 
   3.890689985119215*^9, 3.890690843438586*^9},
 CellLabel->
  "Out[295]=",ExpressionUUID->"6b69b83e-11b4-4b2b-82c6-1f7acc3a53b8"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", "+", 
   SubscriptBox["d", "rel"]}], 
  RowBox[{"2", " ", "f"}]]], "Output",
 CellChangeTimes->{
  3.8402044148348308`*^9, {3.8402044667788897`*^9, 3.8402044735186605`*^9}, 
   3.840208471858531*^9, 3.840209423453854*^9, 3.840209913429438*^9, 
   3.8405563114250174`*^9, {3.8405566396889153`*^9, 3.8405566614566936`*^9}, 
   3.840562220507329*^9, 3.840563527832856*^9, 3.8405636910686436`*^9, 
   3.840652578620533*^9, {3.8407322724585733`*^9, 3.840732279151969*^9}, 
   3.840733316497733*^9, 3.8407377202995086`*^9, 3.840792422329224*^9, 
   3.890689985119215*^9, 3.890690843454241*^9},
 CellLabel->
  "Out[296]=",ExpressionUUID->"30704347-a4fb-40f5-a477-dbf8e6636371"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2. Baseline Signaling (drug - free)", "Subsubsubsection",
 CellChangeTimes->{{3.812385908612563*^9, 3.812385920080598*^9}, {
  3.833159643863964*^9, 3.8331596657361794`*^9}, {3.8406531404445868`*^9, 
  3.8406531405383387`*^9}, {3.840733085568445*^9, 
  3.8407330894138927`*^9}},ExpressionUUID->"39d11b0e-39c8-4a24-a701-\
4ff8e466a3b9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"baselineActiveRAF5", "=", 
   RowBox[{"fnActiveRAF5", "/.", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", "0"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep3b5", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["RAF", "rel"], "\[Rule]", 
     RowBox[{"E3", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "KA"}], ")"}], "2"], "/", "8"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"baselineActiveRAF15", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"baselineActiveRAF5", "/.", "rep3b5"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"SimplifyPars", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"baselineActiveRAF15", ",", "E3"}], "]"}], "/.", "rep3b5"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8123859215610027`*^9, 3.812385936919848*^9}, {
   3.8123861495330424`*^9, 3.812386224346416*^9}, {3.812386278673541*^9, 
   3.812386294471064*^9}, {3.8123863259077187`*^9, 3.8123863683020535`*^9}, {
   3.8123864109056587`*^9, 3.8123864240308285`*^9}, {3.8319211091015835`*^9, 
   3.8319211176118765`*^9}, 3.8319211759429626`*^9, {3.8402045142905054`*^9, 
   3.8402045162565413`*^9}, {3.840651651834156*^9, 3.8406516611802745`*^9}, {
   3.8407333243777637`*^9, 3.84073333577083*^9}},
 CellLabel->
  "In[297]:=",ExpressionUUID->"f45fa0b2-b161-4c98-b405-4f8d98666a8b"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", "E3"}]]}], ")"}], "2"], "E3"]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, 3.840652654930914*^9, {3.840732272543256*^9, 
   3.840732279437253*^9}, 3.840733336789935*^9, 3.840737720702987*^9, 
   3.840792422429134*^9, 3.8906899937162066`*^9, 3.890690846802308*^9},
 CellLabel->
  "Out[299]=",ExpressionUUID->"0f6f7cec-3dec-4d82-88bf-e2e73f8fb8ff"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"1", "+", "E3"}]]}], ")"}], "2"], 
  RowBox[{
   SuperscriptBox["E3", "2"], " ", 
   SqrtBox[
    RowBox[{"1", "+", "E3"}]]}]]], "Output",
 CellChangeTimes->{
  3.840204516614089*^9, 3.840652654930914*^9, {3.840732272543256*^9, 
   3.840732279437253*^9}, 3.840733336789935*^9, 3.840737720702987*^9, 
   3.840792422429134*^9, 3.8906899937162066`*^9, 3.890690846817934*^9},
 CellLabel->
  "Out[300]=",ExpressionUUID->"6c394e88-53fc-4cee-b0f0-369daccf4674"]
}, Open  ]],

Cell["\<\
The derivative of baseline signaling relative to E3 is a positive definite \
function. Therefore, baseline signaling is a monotonically proportionate to \
E3, which is in turn, monotonically proportionate to RAF concentration and \
monotonically inverse relationship to KA.\
\>", "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
  3.812386377540579*^9, 
  3.8123864833252983`*^9}},ExpressionUUID->"9346a39a-74fa-44fc-9841-\
ba25e967dc29"],

Cell[TextData[{
 "Hence in the base model, increasing KA decreases baseline signaling and \
increasing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["RAF", "rel"], " "}], TraditionalForm]],ExpressionUUID->
  "d6c9003f-176c-4f06-b609-9670cfc55403"],
 " increases baseline signaling."
}], "Text",
 CellChangeTimes->{{3.8123862441533103`*^9, 3.812386274350785*^9}, {
   3.812386377540579*^9, 3.812386508943284*^9}, 
   3.831493576900573*^9},ExpressionUUID->"4d56e3df-e42a-4b5d-a51a-\
8391534cd105"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.5.3. Conditions on parameter regions for activation in response to the drug\
\>", "Subsubsection",
 CellChangeTimes->{{3.769352693017748*^9, 3.7693527442245555`*^9}, 
   3.8319232589041615`*^9, {3.833159646729958*^9, 3.833159664629573*^9}, {
   3.8407376220691867`*^9, 3.840737622169522*^9}, {3.8448856597827635`*^9, 
   3.8448856599299173`*^9}},ExpressionUUID->"1724d10f-bdee-4134-bd0a-\
524a4217b610"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dfn5", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"fnActiveRAF5", ",", 
     SubscriptBox["d", "rel"]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.755541810342499*^9, 3.7555418608619113`*^9}, {
   3.755541978622472*^9, 3.7555419807907124`*^9}, {3.7555571218326187`*^9, 
   3.7555571219456987`*^9}, {3.7556152697929463`*^9, 3.755615271368307*^9}, {
   3.755615528332312*^9, 3.7556155322520323`*^9}, {3.755615647889366*^9, 
   3.755615736790206*^9}, {3.7556192151498156`*^9, 3.7556192592915344`*^9}, {
   3.755619311851678*^9, 3.75561931599358*^9}, {3.7556396242742844`*^9, 
   3.755639637221635*^9}, {3.7590911604934464`*^9, 3.759091242876088*^9}, {
   3.759091274647378*^9, 3.759091275112709*^9}, 3.7646075097588253`*^9, {
   3.7692693888047943`*^9, 3.769269390671215*^9}, {3.7692695640617847`*^9, 
   3.7692696334602895`*^9}, {3.7692696651592636`*^9, 3.7692696859256325`*^9}, 
   3.769436826714548*^9, {3.8129938947361474`*^9, 3.8129939100528193`*^9}, 
   3.831920887884055*^9, 3.8319211759429626`*^9, 3.8402045504842486`*^9, {
   3.8406519730045977`*^9, 3.840651976488284*^9}, {3.8407334021478467`*^9, 
   3.8407334041926975`*^9}},
 CellLabel->
  "In[301]:=",ExpressionUUID->"78c27aa1-5bad-450c-8a74-4165b072c8be"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f", " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     RowBox[{"f", " ", "KA"}], "+", 
     RowBox[{"f", " ", 
      SubscriptBox["d", "rel"]}], "-", 
     SqrtBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["f", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"f", "+", 
           SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
        SubscriptBox["RAF", "rel"]}]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "-", 
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             SubscriptBox["d", "rel"]}], ")"}], " ", 
           SubscriptBox["RAF", "rel"]}]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["f", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"f", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
             SubscriptBox["RAF", "rel"]}]}]]}]]}], ")"}]}], "-", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"f", " ", "KA"}], "+", 
        RowBox[{"f", " ", 
         SubscriptBox["d", "rel"]}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["f", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"f", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
           SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}], 
  RowBox[{"8", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f", "+", 
      SubscriptBox["d", "rel"]}], ")"}], "4"], " ", 
   SubscriptBox["RAF", "rel"]}]]], "Output",
 CellChangeTimes->{
  3.8402045507751465`*^9, 3.8402070121984787`*^9, {3.8406519699372034`*^9, 
   3.8406519771608896`*^9}, 3.840733405596839*^9, 3.8407377221922026`*^9, 
   3.84079242327765*^9, 3.8906900025201654`*^9, 3.890690854073188*^9},
 CellLabel->
  "Out[301]=",ExpressionUUID->"cff54ab7-4f2d-41e0-920d-089ee1d68243"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zeroes5", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"dfn5", "\[Equal]", "0"}], ",", 
     SubscriptBox["d", "rel"], ",", 
     RowBox[{"VerifySolutions", "\[Rule]", "True"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.755541989072197*^9, 3.7555420037094855`*^9}, {
   3.7555448520523195`*^9, 3.7555448726056957`*^9}, {3.755544917757202*^9, 
   3.755544930580393*^9}, {3.755544971180496*^9, 3.7555449951722126`*^9}, {
   3.7556152155154743`*^9, 3.7556152173406396`*^9}, {3.7556155593795424`*^9, 
   3.75561558823169*^9}, {3.7556158119219775`*^9, 3.7556158357473307`*^9}, {
   3.7556159869586897`*^9, 3.7556159923967276`*^9}, 3.7590911798731813`*^9, {
   3.7590912606104107`*^9, 3.759091312740535*^9}, 3.7646075098213253`*^9, {
   3.7692697119381285`*^9, 3.7692697289151955`*^9}, 3.76943683146959*^9, 
   3.81299392247276*^9, 3.8319209118697786`*^9, 3.840204613872306*^9, {
   3.840651998733414*^9, 3.8406520000209627`*^9}, {3.840733414658243*^9, 
   3.840733426319726*^9}},
 CellLabel->
  "In[302]:=",ExpressionUUID->"381eea59-81cf-4a21-9ad6-495c4e787364"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"f", " ", "KA"}], "+", 
          RowBox[{"8", " ", 
           SubscriptBox["RAF", "rel"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"1", "-", "f", "+", "KA"}], "]"}], " ", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["f", "2"], "+", 
             RowBox[{"6", " ", 
              SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["f", "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["d", "rel"], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"f", " ", "KA"}], "+", 
          RowBox[{"8", " ", 
           SubscriptBox["RAF", "rel"]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"1", "-", "f", "+", "KA"}], "]"}], " ", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["f", "2"], "+", 
             RowBox[{"6", " ", 
              SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["f", "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.840204636395675*^9, 3.8402070277316294`*^9, 3.8406520006358757`*^9, {
   3.8407334176534376`*^9, 3.8407334273156796`*^9}, 3.8407377225767927`*^9, 
   3.8407924235468516`*^9, 3.8906900769582925`*^9, 3.890690855839491*^9},
 CellLabel->
  "Out[302]=",ExpressionUUID->"a285ad66-edb5-4698-b5e9-492143c736e2"]
}, Open  ]],

Cell["\<\
The first solution is negative definite. Below, we derive the rules \
(expression 13) which allow the second solution to be positive\
\>", "Text",
 CellChangeTimes->{{3.759091361547437*^9, 3.7590913680495505`*^9}, {
  3.769269749681785*^9, 
  3.7692698135732317`*^9}},ExpressionUUID->"185fef26-5658-49e4-b4da-\
1f8fa13c280c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exist5", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["d", "rel"], "/.", 
         RowBox[{"zeroes5", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ")"}], ">", "0"}], ")"}], "&&", 
     RowBox[{"(", 
      RowBox[{"KA", ">", "0"}], ")"}], "&&", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["RAF", "rel"], ">", "0"}], ")"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.759091395330793*^9, 3.7590914705945797`*^9}, {
   3.759092635935361*^9, 3.759092638528202*^9}, 3.7646075098525753`*^9, {
   3.769269834345808*^9, 3.769269849315876*^9}, 3.7694368345423703`*^9, 
   3.812993929793637*^9, 3.8319209167016697`*^9, 3.840207030187523*^9, {
   3.840733423950286*^9, 3.840733448620587*^9}},
 CellLabel->
  "In[303]:=",ExpressionUUID->"c0f6a321-beda-49fc-92e4-74258f61e374"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["f", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}], ">", 
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", "KA"}], "+", 
      SubscriptBox["RAF", "rel"]}], ")"}]}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "f"}], "<", 
     RowBox[{"1", "+", "KA"}]}], "||", 
    RowBox[{
     RowBox[{"2", " ", "f"}], ">", 
     RowBox[{"3", "+", 
      RowBox[{"3", " ", "KA"}]}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.8402070305727043`*^9, 3.8406520081534395`*^9, {3.840733435509219*^9, 
   3.840733449122109*^9}, 3.8407377228168783`*^9, 3.8407924238162374`*^9, 
   3.8906908583028193`*^9},
 CellLabel->
  "Out[303]=",ExpressionUUID->"6e83aedb-98e3-4184-86cf-01e8dc2eb883"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2fn5", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{"dfn5", ",", 
     SubscriptBox["d", "rel"]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.7650568486607113`*^9, {3.7692702065179834`*^9, 3.769270223610836*^9}, 
   3.7694368388201976`*^9, 3.8129939841166162`*^9, 3.831920926762268*^9, 
   3.840207036172144*^9, {3.84065216861963*^9, 3.8406521716592636`*^9}, {
   3.8407334719541907`*^9, 3.840733475533986*^9}},
 CellLabel->
  "In[304]:=",ExpressionUUID->"90c95366-3288-4ba1-a307-887077131b29"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"f", "+", 
       SubscriptBox["d", "rel"]}], ")"}], "5"], " ", 
    SubscriptBox["RAF", "rel"]}]], 
  RowBox[{"f", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "f"}], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["f", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "f", "+", "KA"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"f", "+", 
            SubscriptBox["d", "rel"]}], ")"}], " ", 
          SubscriptBox["RAF", "rel"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["f", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"f", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
             SubscriptBox["RAF", "rel"]}]}], ")"}], 
          RowBox[{"3", "/", "2"}]]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             SubscriptBox["d", "rel"]}], ")"}], " ", 
           SubscriptBox["RAF", "rel"]}]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["f", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"f", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
             SubscriptBox["RAF", "rel"]}]}]]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"f", " ", "KA"}], "+", 
        RowBox[{"f", " ", 
         SubscriptBox["d", "rel"]}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["f", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"f", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
           SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "+", 
        SubscriptBox["d", "rel"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "-", 
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "KA", "+", 
             SubscriptBox["d", "rel"]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             SubscriptBox["d", "rel"]}], ")"}], " ", 
           SubscriptBox["RAF", "rel"]}]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["f", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"f", "+", 
                SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
             SubscriptBox["RAF", "rel"]}]}]]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"f", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"f", "-", 
           FractionBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}]}], "+", 
             RowBox[{"16", " ", 
              RowBox[{"(", 
               RowBox[{"f", "+", 
                SubscriptBox["d", "rel"]}], ")"}], " ", 
              SubscriptBox["RAF", "rel"]}]}], 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{
                SuperscriptBox["f", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", "KA", "+", 
                   SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
               RowBox[{"8", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"f", "+", 
                   SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
                SubscriptBox["RAF", "rel"]}]}]]}]]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"f", "+", 
           RowBox[{"f", " ", "KA"}], "+", 
           RowBox[{"f", " ", 
            SubscriptBox["d", "rel"]}], "-", 
           SqrtBox[
            RowBox[{
             RowBox[{
              SuperscriptBox["f", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", "KA", "+", 
                 SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"f", "+", 
                 SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
              SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"f", " ", "KA"}], "+", 
        RowBox[{"f", " ", 
         SubscriptBox["d", "rel"]}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["f", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"f", "+", 
              SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
           SubscriptBox["RAF", "rel"]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"f", "+", 
           SubscriptBox["d", "rel"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"f", "-", 
           FractionBox[
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "KA", "+", 
                SubscriptBox["d", "rel"]}], ")"}]}], "+", 
             RowBox[{"16", " ", 
              RowBox[{"(", 
               RowBox[{"f", "+", 
                SubscriptBox["d", "rel"]}], ")"}], " ", 
              SubscriptBox["RAF", "rel"]}]}], 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{
                SuperscriptBox["f", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", "KA", "+", 
                   SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
               RowBox[{"8", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"f", "+", 
                   SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
                SubscriptBox["RAF", "rel"]}]}]]}]]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"f", "+", 
           RowBox[{"f", " ", "KA"}], "+", 
           RowBox[{"f", " ", 
            SubscriptBox["d", "rel"]}], "-", 
           SqrtBox[
            RowBox[{
             RowBox[{
              SuperscriptBox["f", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", "KA", "+", 
                 SubscriptBox["d", "rel"]}], ")"}], "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"f", "+", 
                 SubscriptBox["d", "rel"]}], ")"}], "2"], " ", 
              SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.8402070371214743`*^9, {3.840652166460883*^9, 3.840652174382373*^9}, 
   3.8407334775871716`*^9, 3.8407377249784393`*^9, 3.840792425436528*^9, 
   3.8906909404622803`*^9},
 CellLabel->
  "Out[304]=",ExpressionUUID->"abb0c4b0-83ca-42a8-8213-b9e6d01cf1cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2fn5z", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"d2fn5", "/.", 
    RowBox[{"zeroes5", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.765056877442114*^9, 3.765056880938139*^9}, 
   3.7650569941039143`*^9, {3.767564894649585*^9, 3.7675648954451675`*^9}, {
   3.7692702305775337`*^9, 3.7692702775194626`*^9}, 3.769436842310711*^9, 
   3.8129940042467594`*^9, 3.8319209285682616`*^9, 3.8402070405458183`*^9, {
   3.840652177558148*^9, 3.840652180441888*^9}, {3.8407334803666797`*^9, 
   3.8407334930786276`*^9}, {3.8407338314366856`*^9, 3.840733841245682*^9}, {
   3.840733914472745*^9, 3.8407339850496006`*^9}, {3.840734058884137*^9, 
   3.8407340638785076`*^9}},
 CellLabel->
  "In[305]:=",ExpressionUUID->"d43891b0-86f4-46aa-93f2-d22b6de6c411"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"8", " ", 
               SubscriptBox["RAF", "rel"]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SubscriptBox["RAF", "rel"]}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{"f", "-", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["f", "2"], "+", 
                  RowBox[{"6", " ", 
                   SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["RAF", "rel"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", "f"}], "-", 
                RowBox[{"4", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["f", "2"], "+", 
                   RowBox[{"6", " ", 
                    SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"f", "-", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["f", "2"], "+", 
                  RowBox[{"6", " ", 
                   SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}], 
          RowBox[{"4", " ", 
           SuperscriptBox["f", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "f", "-", "KA"}], ")"}], "3"], " ", 
           SubscriptBox["RAF", "rel"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"f", "-", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["f", "2"], "+", 
                 RowBox[{"6", " ", 
                  SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}], "4"]}]]}], 
        RowBox[{"f", "\[LessEqual]", 
         RowBox[{"1", "+", "KA"}]}]},
       {
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["f", "2"], "+", 
             RowBox[{"8", " ", 
              SubscriptBox["RAF", "rel"]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", 
             SubscriptBox["RAF", "rel"]}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{"f", "-", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["f", "2"], "+", 
                 RowBox[{"6", " ", 
                  SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1296", " ", 
             SubsuperscriptBox["RAF", "rel", "2"]}], "+", 
            RowBox[{"6", " ", "f", " ", 
             SubscriptBox["RAF", "rel"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"45", " ", "f"}], "-", 
               RowBox[{"16", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["f", "2"], "+", 
                  RowBox[{"6", " ", 
                   SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}], "+", 
            RowBox[{"13", " ", 
             SuperscriptBox["f", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"f", "-", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["f", "2"], "+", 
                 RowBox[{"6", " ", 
                  SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["f", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "f", "-", "KA"}], ")"}], "3"], " ", 
          SubscriptBox["RAF", "rel"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{"2", " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["f", "2"], "+", 
                RowBox[{"6", " ", 
                 SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}], "5"]}]], 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellChangeTimes->{
  3.8402070410688686`*^9, 3.8406521836675653`*^9, {3.8407338337728443`*^9, 
   3.840733844038958*^9}, 3.8407339266516695`*^9, 3.8407339880451965`*^9, 
   3.8407340644339933`*^9, 3.8407377289549885`*^9, 3.8407924289074907`*^9, 
   3.890690943775819*^9},
 CellLabel->
  "Out[305]=",ExpressionUUID->"75e88924-ec47-4aa1-a069-07d4988d915b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d2fn5z", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8407340675470963`*^9, 3.840734106068205*^9}},
 CellLabel->
  "In[306]:=",ExpressionUUID->"bf5424b6-29c4-48f9-97a8-f55ce6578388"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["f", "2"], "+", 
       RowBox[{"8", " ", 
        SubscriptBox["RAF", "rel"]}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SubscriptBox["RAF", "rel"]}], "+", 
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{"f", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["f", "2"], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["RAF", "rel"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "f"}], "-", 
         RowBox[{"4", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["f", "2"], "+", 
            RowBox[{"6", " ", 
             SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["f", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"f", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["f", "2"], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["f", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "f", "-", "KA"}], ")"}], "3"], " ", 
    SubscriptBox["RAF", "rel"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"f", "-", 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["f", "2"], "+", 
          RowBox[{"6", " ", 
           SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}], "4"]}]]}]], "Output",
 CellChangeTimes->{{3.84073407587685*^9, 3.8407341065764046`*^9}, 
   3.840737729046525*^9, 3.840792428992155*^9, 3.8906909439922295`*^9},
 CellLabel->
  "Out[306]=",ExpressionUUID->"212aa969-8a05-4beb-b1dc-f881a17d9eca"]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.840734076193264*^9, 
  3.840734076193264*^9}},ExpressionUUID->"8c19170e-742b-4aed-a6e2-\
c94e203f79b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exist5d2", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d2fn5z", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], "<", "0"}], ")"}], "&&", 
      RowBox[{"(", 
       RowBox[{"KA", ">=", "0"}], ")"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["RAF", "rel"], ">=", "0"}], ")"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.765056913853697*^9, 3.7650569628895283`*^9}, 
   3.7650571358338194`*^9, {3.7692702714368963`*^9, 3.76927027238888*^9}, 
   3.769355075736458*^9, 3.769436845114371*^9, 3.8129940113765926`*^9, 
   3.8319209434656467`*^9, 3.8402070440950255`*^9, {3.840652186994707*^9, 
   3.840652187276284*^9}, {3.84073350404432*^9, 3.840733521965187*^9}, {
   3.8407339960901594`*^9, 3.840734001280137*^9}, 3.840734113801595*^9, {
   3.8407341950134315`*^9, 3.8407342028798676`*^9}},
 CellLabel->
  "In[307]:=",ExpressionUUID->"5aeba4ca-2f3e-4367-929d-cd9e34327c30"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "<", "1"}], "||", 
  RowBox[{
   RowBox[{"1", "+", "KA"}], ">", "f"}]}]], "Output",
 CellChangeTimes->{
  3.8402070443788004`*^9, 3.840652188458864*^9, {3.840733993321129*^9, 
   3.8407340016817026`*^9}, 3.8407341147356825`*^9, 3.8407342038383408`*^9, 
   3.8407377291646805`*^9, 3.840792429100993*^9, 3.8906909443229012`*^9},
 CellLabel->
  "Out[307]=",ExpressionUUID->"510fa4d9-4b22-4185-9d9c-12645e042439"]
}, Open  ]],

Cell["\<\
The f<1 condition comes naturally from the equations. The alternative is that \
KA>1+f so PA exists even when f>1.\
\>", "Text",
 CellChangeTimes->{{3.840734003429651*^9, 3.8407340176591425`*^9}, {
  3.84073412596181*^9, 
  3.84073414905274*^9}},ExpressionUUID->"341b0c64-055e-4ce2-8b72-\
f80492f01988"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d2fn5z", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "<", "0"}], ")"}], "&&", 
     RowBox[{"(", 
      RowBox[{"KA", ">=", "0"}], ")"}], "&&", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["RAF", "rel"], ">=", "0"}], ")"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.765056913853697*^9, 3.7650569628895283`*^9}, 
   3.7650571358338194`*^9, {3.7692702714368963`*^9, 3.76927027238888*^9}, 
   3.769355075736458*^9, 3.769436845114371*^9, 3.8129940113765926`*^9, 
   3.8319209434656467`*^9, 3.8402070440950255`*^9, {3.840652186994707*^9, 
   3.840652187276284*^9}, {3.84073350404432*^9, 3.840733521965187*^9}, {
   3.8407339960901594`*^9, 3.840734001280137*^9}, 3.840734113801595*^9, {
   3.8407341546211495`*^9, 3.8407341569674387`*^9}},
 CellLabel->
  "In[308]:=",ExpressionUUID->"637b55db-8c62-4f54-b5bd-d36ec5b3283c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "<", "1"}], "||", 
  RowBox[{
   RowBox[{"1", "+", "KA"}], ">", "f"}]}]], "Output",
 CellChangeTimes->{
  3.8402070443788004`*^9, 3.840652188458864*^9, {3.840733993321129*^9, 
   3.8407340016817026`*^9}, 3.8407341147356825`*^9, 3.840734157284154*^9, 
   3.840737729239689*^9, 3.840792429176527*^9, 3.8906909529101915`*^9},
 CellLabel->
  "Out[308]=",ExpressionUUID->"f76bc277-958e-4b11-82e9-aefc0ac56db6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exist5A", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"exist5", "&&", "exist5d2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.840734206794607*^9, 3.8407342698595448`*^9}, {
  3.8407357122129946`*^9, 3.840735716261572*^9}},
 CellLabel->
  "In[309]:=",ExpressionUUID->"98374fb9-ec06-4e8c-8561-7245dade03bd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["f", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}], ">", 
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", "KA"}], "+", 
      SubscriptBox["RAF", "rel"]}], ")"}]}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "f"}], "<", 
     RowBox[{"1", "+", "KA"}]}], "||", 
    RowBox[{
     RowBox[{"2", " ", "f"}], ">", 
     RowBox[{"3", "+", 
      RowBox[{"3", " ", "KA"}]}]}]}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"f", "<", "1"}], "||", 
    RowBox[{
     RowBox[{"1", "+", "KA"}], ">", "f"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.840734209610014*^9, 3.840734270227991*^9}, 
   3.8407357219559155`*^9, 3.8407377293711977`*^9, 3.8407924292924733`*^9, 
   3.890690959633856*^9},
 CellLabel->
  "Out[309]=",ExpressionUUID->"6465238a-648c-4b83-8962-cb38e10ab2b8"]
}, Open  ]],

Cell["\<\
These are the full set of conditions for PA to exist in the model. The \
conditions above require f<(1+KA)/2. This is because considering the last two \
\[OpenCurlyQuote]AND\[CloseCurlyQuote] conditions, if f>3/2(1+KA) it cannot \
simultaneously satisfy either of the last two conditions. Therefore, f \
<(1+KA)/2 needs to be satisfied. Under this condition, if f<1, it is \
automatically satisfied that f<(1+KA)/2 as long as KA>1. If f<(1+KA)/2, the \
last condition is automatically satisfied that f<1+KA.\
\>", "Text",
 CellChangeTimes->{{3.840734159825981*^9, 3.840734187448922*^9}, {
  3.8407343110335674`*^9, 3.84073431894665*^9}, {3.840734531806786*^9, 
  3.840734635704034*^9}, {3.840734674937955*^9, 3.840734824075968*^9}, {
  3.840734857000375*^9, 
  3.8407348628551407`*^9}},ExpressionUUID->"7bbf29bb-437e-4b9a-b18c-\
481cf9e5799f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exist5A1", "=", 
  RowBox[{"f", "<", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "KA"}], ")"}], "/", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.8407349266373405`*^9, 3.8407349450061703`*^9}, {
  3.840735661711449*^9, 3.840735662614072*^9}, {3.840735719056387*^9, 
  3.840735720377489*^9}},
 CellLabel->
  "In[310]:=",ExpressionUUID->"028a0c9c-433b-4827-b867-4f9a409b4ce4"],

Cell[BoxData[
 RowBox[{"f", "<", 
  FractionBox[
   RowBox[{"1", "+", "KA"}], "2"]}]], "Output",
 CellChangeTimes->{3.8407349455865393`*^9, 3.8407356629464617`*^9, 
  3.8407357287398796`*^9, 3.8407377294362*^9, 3.840792429361522*^9, 
  3.8906909702348876`*^9},
 CellLabel->
  "Out[310]=",ExpressionUUID->"f7fdbb95-1113-4a76-8207-33bfd2f17ffc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exist5full", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"Reduce", "[", 
    RowBox[{"exist5A", "&&", "exist5A1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.840735670906238*^9, 3.840735737427391*^9}},
 CellLabel->
  "In[311]:=",ExpressionUUID->"9d0ef70c-1e28-4a38-b5b2-41c278e6a50d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "f"}], "<", 
   RowBox[{"1", "+", "KA"}]}], "&&", 
  RowBox[{
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", "KA"}], "+", 
      SubscriptBox["RAF", "rel"]}], ")"}]}], "<", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["f", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}]}]}]], "Output",
 CellChangeTimes->{{3.840735683741767*^9, 3.840735694440055*^9}, {
   3.8407357319742937`*^9, 3.840735737953679*^9}, 3.8407377300568027`*^9, 
   3.8407924300686283`*^9, 3.8906909797436438`*^9},
 CellLabel->
  "Out[311]=",ExpressionUUID->"d9b1d7b0-fad7-472f-a480-af251163d05a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
1.5.4. Monotonic relationship between unbound (d) and total (DTOT) drug \
concentrations\
\>", "Subsubsection",
 CellChangeTimes->{{3.7692694343293085`*^9, 3.76926946891394*^9}, 
   3.7692701230017385`*^9, {3.769436773797412*^9, 3.7694367744539824`*^9}, 
   3.8319232632660522`*^9, {3.833159649860316*^9, 3.8331596633192616`*^9}, {
   3.8407376230957623`*^9, 3.84073762315576*^9}, {3.8448856609498253`*^9, 
   3.844885661071724*^9}},ExpressionUUID->"3c72aae9-13ec-43d2-981e-\
85b3423ccd99"],

Cell["\<\
The derivative of the function DTOT relative to d is the sum of the \
derivative of different terms within the second equation in expression (1). \
Among these the derivative of the first term is 1. And the derivative of the \
second and third term are shown as non-negative functions of unbound drug d, \
below.\
\>", "Text",
 CellChangeTimes->{{3.8320850810009933`*^9, 
  3.8320851682942505`*^9}},ExpressionUUID->"ce5c6401-6bdd-43eb-a5f6-\
1c8aa1dc5c21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqnsconsrv", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8407335447781963`*^9, 3.8407335487621293`*^9}, {
  3.8407343233732247`*^9, 3.8407343249572945`*^9}},
 CellLabel->
  "In[312]:=",ExpressionUUID->"bd40fd31-727c-4678-a42e-e550311a4ffb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "+", 
   FractionBox[
    RowBox[{"A", " ", "d"}], "Kd"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["A", "2"], " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"f", " ", "Kd"}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["f", "2"], " ", 
     SuperscriptBox["Kd", "2"], " ", "Kdim"}]]}], "\[Equal]", 
  "DTOT"}]], "Output",
 CellChangeTimes->{3.8407343252001843`*^9, 3.8407377302324033`*^9, 
  3.8906909919542575`*^9},
 CellLabel->
  "Out[312]=",ExpressionUUID->"2a4b3eb5-f5c0-4800-a80c-ac91a83a7f84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd511", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"A", "*", "d"}], "/.", "sol5A"}], ",", "d"}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd511", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd511", "<", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rd511s", "=", 
  RowBox[{"SimplifyPars", "[", "rd511", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.812209716555067*^9}, 3.840204651633864*^9, {3.8402070598013134`*^9, 
   3.8402070600121202`*^9}, {3.8406522082337675`*^9, 
   3.8406522331459618`*^9}, {3.84073353048035*^9, 3.8407335397667346`*^9}, {
   3.8407343467505436`*^9, 3.840734416974304*^9}},
 CellLabel->
  "In[313]:=",ExpressionUUID->"2c8e8ab6-6a7c-4098-bc2a-c7293195dc23"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", ">", 
   RowBox[{"1", "+", "KA"}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "f"}], "+", "KA"}], ")"}]}], "\[Equal]", 
     RowBox[{"f", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "KA"}], ")"}], " ", "Kd"}]}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"RAF", ">", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"d", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "f"}], "+", "KA"}], ")"}]}], "-", 
           RowBox[{"f", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "KA"}], ")"}], " ", "Kd"}]}], ")"}], " ", 
         "Kdim"}], 
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"f", " ", "Kd"}]}], ")"}]}]]}], "&&", 
      RowBox[{
       RowBox[{"f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "d"}], "+", "Kd", "+", 
          RowBox[{"KA", " ", "Kd"}]}], ")"}]}], "<", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "KA"}], ")"}]}]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.840204662010409*^9, {3.8402070557236414`*^9, 3.840207068372545*^9}, {
   3.8406522242662573`*^9, 3.84065224867375*^9}, {3.840734342082819*^9, 
   3.840734354042943*^9}, 3.8407343858046627`*^9, 3.8407344217174397`*^9, 
   3.8407377477219853`*^9, 3.890691015728544*^9},
 CellLabel->
  "Out[315]=",ExpressionUUID->"66c75b73-790e-4bb6-8454-23273a0ffb7e"]
}, Open  ]],

Cell["\<\
Note that the first condition, f be larger than 1+KA and the conditions \
derived for PA, that f<(1+KA)/2 cannot be simultaneously satisfied. \
Therefore, drugs that display PA have positive or 0 value for the derivative \
sd511.\
\>", "Text",
 CellChangeTimes->{{3.8407349921997285`*^9, 3.840735057792676*^9}, {
  3.8407361351673136`*^9, 
  3.8407361460951014`*^9}},ExpressionUUID->"e102bf18-5de0-45da-b88a-\
7f1400a4a5c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{"rd511s", "&&", "exist5A1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8407359608649693`*^9, 3.840735986724265*^9}},
 CellLabel->
  "In[316]:=",ExpressionUUID->"9e67b5e8-8167-4d9d-8628-2be16073a8bc"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.8407359768888903`*^9, 3.8407359870895786`*^9}, 
   3.8407377478879857`*^9, 3.890691015884886*^9},
 CellLabel->
  "Out[316]=",ExpressionUUID->"2d32c4c0-4628-4471-a395-61b4044529e2"]
}, Open  ]],

Cell["\<\
Therefore, when PA exists, the function sd511 cannot be negative.\
\>", "Text",
 CellChangeTimes->{{3.8407359950318193`*^9, 
  3.840736014469389*^9}},ExpressionUUID->"ce9a2ba0-ffd7-4cc6-a7ea-\
eff02989042e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sd512", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["A", "2"], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"f", " ", "Kd"}]}], ")"}]}], "/.", "sol5A"}], "]"}], ",", 
     "d"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8122086851987505`*^9, 3.8122087636088495`*^9}, {
   3.81220882189242*^9, 3.8122088231982927`*^9}, {3.8122089909630337`*^9, 
   3.8122090336547427`*^9}, {3.812209082801958*^9, 3.8122090860600348`*^9}, {
   3.8122091691400814`*^9, 3.8122091833622427`*^9}, {3.8122097087961717`*^9, 
   3.8122097406433277`*^9}, {3.812209825300347*^9, 3.8122098312563896`*^9}, {
   3.812209894920068*^9, 3.812209908923931*^9}, {3.812210163614968*^9, 
   3.8122102029627514`*^9}, 3.8129943016148033`*^9, {3.832085249170616*^9, 
   3.832085251410651*^9}, {3.8320853702376328`*^9, 3.8320853722836037`*^9}, {
   3.832085440475006*^9, 3.8320854515514917`*^9}, {3.8402070658014565`*^9, 
   3.840207066180502*^9}, 3.840652218386231*^9, {3.840735059785333*^9, 
   3.8407350753289084`*^9}},
 CellLabel->
  "In[317]:=",ExpressionUUID->"d38dbb20-6513-45e8-81a7-6e1bc1529f32"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"f", " ", "Kd"}]}], ")"}], "4"]}]], 
  RowBox[{
   SuperscriptBox["f", "2"], " ", 
   SuperscriptBox["Kd", "2"], " ", 
   SuperscriptBox["Kdim", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", " ", "f"}], "+", 
     RowBox[{"f", " ", "Kd"}], "+", 
     RowBox[{"f", " ", "KA", " ", "Kd"}], "-", 
     SqrtBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["f", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", "Kd", "+", 
           RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"]}], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"f", " ", "Kd"}]}], ")"}], "2"], " ", "RAF"}], 
        "Kdim"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"f", " ", "Kd"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "-", 
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"d", "+", "Kd", "+", 
             RowBox[{"KA", " ", "Kd"}]}], ")"}]}], "+", 
          FractionBox[
           RowBox[{"16", " ", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"f", " ", "Kd"}]}], ")"}], " ", "RAF"}], "Kdim"]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["f", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"d", "+", "Kd", "+", 
                RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"]}], "+", 
            FractionBox[
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"f", " ", "Kd"}]}], ")"}], "2"], " ", "RAF"}], 
             "Kdim"]}]]}]]}], ")"}]}], "-", 
     RowBox[{"3", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", "f"}], "+", 
        RowBox[{"f", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["f", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"d", "+", "Kd", "+", 
              RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"f", " ", "Kd"}]}], ")"}], "2"], " ", "RAF"}], 
           "Kdim"]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"f", " ", "Kd"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", "f"}], "+", 
        RowBox[{"f", " ", "Kd"}], "+", 
        RowBox[{"f", " ", "KA", " ", "Kd"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["f", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"d", "+", "Kd", "+", 
              RowBox[{"KA", " ", "Kd"}]}], ")"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"f", " ", "Kd"}]}], ")"}], "2"], " ", "RAF"}], 
           "Kdim"]}]]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.840652249702524*^9, 3.8407350791538506`*^9, 
  3.840737749864053*^9, 3.890691017931931*^9},
 CellLabel->
  "Out[317]=",ExpressionUUID->"637c5cc7-4e4c-4dee-af50-ff82ec98905a"]
}, Open  ]],

Cell["\<\
Note that the first non-trivial product term in this expression is negative \
definite as the term inside the square root is always greater than the term \
outside. So we focus on the second term.\
\>", "Text",
 CellChangeTimes->{{3.832085456271301*^9, 
  3.8320855058848753`*^9}},ExpressionUUID->"e1bb4e9c-58fe-44d0-b431-\
3706e47d9b27"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sd5121", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"sd512", "[", 
     RowBox[{"[", 
      RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rd512", "=", 
   RowBox[{"Reduce", "[", 
    RowBox[{"sd5121", ">", "0"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8320855104825225`*^9, 3.832085576939461*^9}, 
   3.8320856157697144`*^9, {3.832085673481617*^9, 3.832085684156937*^9}, {
   3.8406522428947597`*^9, 3.8406522819147463`*^9}, {3.840735092420452*^9, 
   3.8407351393498726`*^9}, 3.8407358402405343`*^9},
 CellLabel->
  "In[318]:=",ExpressionUUID->"d532eac5-642b-4d97-a9fe-7e0d9d2aa239"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rd512s", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"SimplifyPars", "[", "rd512", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.8407351602872276`*^9, {3.8407355634434795`*^9, 3.8407355675927267`*^9}},
 CellLabel->
  "In[320]:=",ExpressionUUID->"2e63f2fb-e3b6-4611-ae84-2b6184c1b84d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RAF", "<", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["d", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["f", "2"]}], "-", 
          RowBox[{"8", " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "KA"}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "d", " ", 
        SuperscriptBox["f", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "KA"}], ")"}], " ", "Kd"}], "-", 
       RowBox[{
        SuperscriptBox["f", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], " ", 
        SuperscriptBox["Kd", "2"]}]}], ")"}], " ", "Kdim"}], 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"f", " ", "Kd"}]}], ")"}], "2"]}]]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "KA"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "d"}], "+", 
      RowBox[{"f", " ", "Kd"}]}], ")"}]}], "<", 
   RowBox[{"d", " ", "f"}]}]}]], "Output",
 CellChangeTimes->{3.8407351652182074`*^9, 3.840735568912937*^9, 
  3.8407358606569643`*^9, 3.8407377753988094`*^9, 3.8906910406276703`*^9},
 CellLabel->
  "Out[320]=",ExpressionUUID->"bd9e604f-f39b-4407-990b-063f37ce2377"]
}, Open  ]],

Cell["Again, notice the second necessary condition. ", "Text",
 CellChangeTimes->{{3.84073518431179*^9, 
  3.840735192261975*^9}},ExpressionUUID->"0fa26b1d-ee23-45d5-bdb4-\
2b3e679d7a01"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SimplifyPars", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"rd512s", "[", 
     RowBox[{"[", 
      RowBox[{"-", "1"}], "]"}], "]"}], "&&", "exist5A1"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.840735627809842*^9, 3.840735636976615*^9}, {
  3.840735850188119*^9, 3.8407359008116007`*^9}},
 CellLabel->
  "In[321]:=",ExpressionUUID->"c65db9cf-54f5-4fdb-8add-8d4847b9b80d"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.840735631346098*^9, 3.840735637295081*^9}, {
   3.8407358607379274`*^9, 3.840735901251548*^9}, 3.840737775506321*^9, 
   3.8906910408620462`*^9},
 CellLabel->
  "Out[321]=",ExpressionUUID->"0535522a-d92c-45d6-83bc-e9076503b704"]
}, Open  ]],

Cell["\<\
When PA exists, the function sd5121 is never positive. And since its \
coefficient is always negative, therefore sd512 is positive or 0.\
\>", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211189353238*^9}, {3.832085645561462*^9, 3.8320857371734977`*^9}, {
  3.840652313960535*^9, 3.8406523299325*^9}, {3.8407359124438868`*^9, 
  3.840735944281356*^9}, {3.840736081401969*^9, 
  3.840736113869751*^9}},ExpressionUUID->"5390fb6a-9cab-4515-b11d-\
870bc9568eaf"],

Cell["Finally,", "Text",
 CellChangeTimes->{{3.8407360315960655`*^9, 
  3.840736034038003*^9}},ExpressionUUID->"50ffb09a-0378-4f4e-ad82-\
8a7dc79371db"],

Cell[TextData[{
 "DTOT=d+sd511/Kd+sd512/(",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["f", "2"], " ", 
   SuperscriptBox["Kd", "2"], " ", "Kdim"}]],
  CellChangeTimes->{3.8407343252001843`*^9},ExpressionUUID->
  "41efe916-ade4-48ba-b547-edb1494369af"],
 ")"
}], "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.812211207502667*^9}, {3.840736023384311*^9, 
  3.840736053488653*^9}},ExpressionUUID->"4fe83079-06f0-41fa-8c39-\
0771cbe5fcf0"],

Cell["\<\
Since all three expressions on RHS are non-negative derivatives as a function \
of unbound drug - the total drug has a non-negative derivative. Therefore, \
DTOT(d) is monotonically positive/increasing function.\
\>", "Text",
 CellChangeTimes->{{3.8122105874811697`*^9, 3.81221063342614*^9}, {
  3.812210677776366*^9, 3.8122107441216927`*^9}, {3.8122111211023817`*^9, 
  3.8122112898940353`*^9}, {3.832085750901709*^9, 3.8320858105658555`*^9}, {
  3.8524025420848894`*^9, 
  3.8524025427813654`*^9}},ExpressionUUID->"e77e1908-b317-4296-aef4-\
7fdc31cef243"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fnDTOT", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Consrv", "[", "vars", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/.", "rep5"}], "/.", "sol5A"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7585572574558153`*^9, 3.7585573278649125`*^9}, {
   3.759595163226753*^9, 3.7595951983626966`*^9}, {3.759600640284622*^9, 
   3.7596006451030445`*^9}, 3.7646075104463263`*^9, {3.7646202269105544`*^9, 
   3.764620227426238*^9}, {3.7692714662387505`*^9, 3.7692714835925064`*^9}, {
   3.76927153667768*^9, 3.769271545331811*^9}, 3.769436866848941*^9, {
   3.8402070839625173`*^9, 3.8402070841989784`*^9}, 3.840652337796776*^9, {
   3.8407361625708427`*^9, 3.8407361641006575`*^9}},
 CellLabel->
  "In[322]:=",ExpressionUUID->"e2592be1-3c57-43aa-b49f-3ece23bd1a2d"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5.5. Analytic Expressions for maximum Fold Change (FC) ", \
"Subsubsection",
 CellChangeTimes->{{3.831920558274994*^9, 3.831920568951131*^9}, {
   3.8319206099444203`*^9, 3.8319206382915373`*^9}, {3.8319228274578667`*^9, 
   3.831922828296911*^9}, {3.831923265609557*^9, 3.831923265941924*^9}, 
   3.832088767728548*^9, {3.8331596529044495`*^9, 3.8331596605908427`*^9}, {
   3.8406531434670486`*^9, 3.840653143591988*^9}, {3.840737624163411*^9, 
   3.8407376242794037`*^9}, {3.8448856622534266`*^9, 
   3.844885662338026*^9}},ExpressionUUID->"780440d5-fe35-400a-ae92-\
89cbfb39888c"],

Cell["\<\
Fold change is defined as the ratio between maximum RAF activity (no/conc of \
active protomers) to that in absence of drug\
\>", "Text",
 CellChangeTimes->{{3.8319210014332504`*^9, 
  3.831921044927513*^9}},ExpressionUUID->"77afb9fc-ddf2-4de5-9329-\
3bae3433b182"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maxActiveRAF5", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"SimplifyPars", "[", 
     RowBox[{"fnActiveRAF5", "/.", 
      RowBox[{"zeroes5", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rafFC5", "=", 
  RowBox[{"SimplifyPars", "[", 
   RowBox[{"maxActiveRAF5", "/", "baselineActiveRAF5"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8319206411308155`*^9, 3.831920654543648*^9}, {
   3.8319209514436145`*^9, 3.831920964234915*^9}, {3.8319210462861276`*^9, 
   3.8319210808824434`*^9}, {3.8319211410192847`*^9, 
   3.8319211418294463`*^9}, {3.8319212907129707`*^9, 3.831921293775152*^9}, 
   3.831929927406506*^9, {3.8320860698850856`*^9, 3.8320861755815163`*^9}, {
   3.8320864795071588`*^9, 3.8320865564244003`*^9}, {3.8320866370022855`*^9, 
   3.832086656919811*^9}, {3.8321657983699083`*^9, 3.8321657985708137`*^9}, 
   3.8402070952948265`*^9, {3.8406523549400873`*^9, 3.840652365604474*^9}, {
   3.840736355609301*^9, 3.840736366450638*^9}},
 CellLabel->
  "In[323]:=",ExpressionUUID->"4a56b380-ce30-4ce3-8a1a-51537041a1f3"],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["f", "2"], "+", 
     RowBox[{"8", " ", 
      SubscriptBox["RAF", "rel"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "f", "-", "KA"}], ")"}], " ", 
       SubscriptBox["RAF", "rel"]}], "+", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"1", "-", "f", "+", "KA"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SubscriptBox["RAF", "rel"]}], "+", 
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"f", "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"6", " ", 
               SubscriptBox["RAF", "rel"]}]}]]}], ")"}]}]}], ")"}]}]}], ")"}],
     "2"]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "f", "-", "KA"}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"1", "-", "f", "+", "KA"}], "]"}], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["f", "2"], "+", 
         RowBox[{"6", " ", 
          SubscriptBox["RAF", "rel"]}]}]]}]}], ")"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "KA", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "KA"}], ")"}], "2"], "+", 
        RowBox[{"8", " ", 
         SubscriptBox["RAF", "rel"]}]}]]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.840207096981233*^9, {3.840652351018113*^9, 3.8406523659399633`*^9}, 
   3.840736378708634*^9, 3.8407377915737233`*^9, 3.840792443190803*^9, 
   3.890691069418806*^9},
 CellLabel->
  "Out[324]=",ExpressionUUID->"6833159e-bc91-4295-8d3e-8a1021a29893"]
}, Open  ]],

Cell[TextData[{
 "When the \[OpenCurlyQuote]exist\[CloseCurlyQuote] conditions derived above \
to qualify for existence of PA within this model are satisfied, we can \
evaluate the functional dependence of the raf fold change expression on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["RAF", "rel"], TraditionalForm]],ExpressionUUID->
  "eaf51f7d-36dd-4e01-ae54-73b57153c231"],
 " and KA:"
}], "Text",
 CellChangeTimes->{{3.832087546777257*^9, 
  3.8320875941822586`*^9}},ExpressionUUID->"ce7d4a08-2c72-4d76-b8b3-\
9cb5517256bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dRAFrafFC5", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"D", "[", 
     RowBox[{"rafFC5", ",", 
      SubscriptBox["RAF", "rel"]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dKArafFC5", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"D", "[", 
     RowBox[{"rafFC5", ",", "KA"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dfrafFC5", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"D", "[", 
     RowBox[{"rafFC5", ",", "f"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.832086689751876*^9, 3.8320867350715184`*^9}, {
  3.832087084899557*^9, 3.8320870857655926`*^9}, {3.8320873820129504`*^9, 
  3.832087506095231*^9}, {3.832087718396454*^9, 3.8320877721038113`*^9}, {
  3.840736375105544*^9, 3.840736459513601*^9}, {3.840736621108224*^9, 
  3.840736622430826*^9}, {3.8407366897566032`*^9, 3.8407366918222446`*^9}},
 CellLabel->
  "In[325]:=",ExpressionUUID->"e1acf3b7-f879-4876-ad3a-091b35812904"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Reduce", "[", 
     RowBox[{"dRAFrafFC5", "<", "0"}], "]"}], "]"}], ",", "exist5A1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.840736632836911*^9, 3.840736659470927*^9}, {
  3.8407924015781093`*^9, 3.840792408730487*^9}, {3.8407934161843634`*^9, 
  3.8407934216923585`*^9}},
 CellLabel->
  "In[328]:=",ExpressionUUID->"ca75e560-ccf3-4f11-9ba3-a11d9a61447b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["f", "2"]}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}], ">", 
  RowBox[{"8", " ", 
   RowBox[{"(", 
    RowBox[{"f", "+", 
     RowBox[{"f", " ", "KA"}], "+", 
     SubscriptBox["RAF", "rel"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.840792584176451*^9, 3.8407934927525196`*^9, 
  3.890691161365908*^9},
 CellLabel->
  "Out[328]=",ExpressionUUID->"b3b53f39-2cb0-42c9-8bdb-de7f12b5c348"]
}, Open  ]],

Cell["\<\
Under typical conditions for PA, f<1 and KA>1. Therefore the above condition \
is pretty easy to satisfy with RAF<<Kdim. That is when RAF has a low \
concentration or weakly dimerizes. In that case, RAF increase reduces fold \
change.\[LineSeparator]However, with stronger dimerization or very high, \
likely super-physical RAF concentration(~100 micro-molar), it may be possible \
to invert the curve, however, the same condition is derived for PA, \
therefore, the increasing RAF concentration will keep reducing fold change \
until no PA is observed. Monotonically.\
\>", "Text",
 CellChangeTimes->{{3.840738384534241*^9, 3.840738529536186*^9}, {
  3.840796448425047*^9, 3.8407965776320877`*^9}, {3.840797931623521*^9, 
  3.840797982531557*^9}},ExpressionUUID->"e2b84ef6-e7c1-4696-bb42-\
4f4856147c30"],

Cell[CellGroupData[{

Cell[BoxData["exist5full"], "Input",
 CellChangeTimes->{{3.8407965796194277`*^9, 3.8407965867419415`*^9}},
 CellLabel->
  "In[329]:=",ExpressionUUID->"b5b9aa23-9252-4635-828f-d78d1f4ddd81"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "f"}], "<", 
   RowBox[{"1", "+", "KA"}]}], "&&", 
  RowBox[{
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"f", "+", 
      RowBox[{"f", " ", "KA"}], "+", 
      SubscriptBox["RAF", "rel"]}], ")"}]}], "<", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["f", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "KA"}], ")"}], "2"]}]}]}]}]], "Output",
 CellChangeTimes->{3.8407965871762333`*^9, 3.890691161522159*^9},
 CellLabel->
  "Out[329]=",ExpressionUUID->"7fe2a326-7a5e-458a-9724-77124d00cb4b"]
}, Open  ]],

Cell["\<\
Activating Range is defined as the lowest concentration above which the drug \
no longer acts as a paradoxical activator and becomes an inhibitor. This \
function is not easily solved analytically, and to understand its variation \
within the range of parameters defined in conditions for PA above, is \
calculated numerically.\
\>", "Text",
 CellChangeTimes->{{3.8319217033257265`*^9, 3.831921756276883*^9}, {
  3.831921925837969*^9, 
  3.831921981729839*^9}},ExpressionUUID->"6a907c67-4bf3-4a6a-b997-\
45481e1ff35d"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Descriptive, example Plots (supp text section 3)", "Section",
 CellChangeTimes->{{3.76919880174008*^9, 3.7691988613532224`*^9}, 
   3.769273566954769*^9, {3.8402032805684576`*^9, 3.840203284256183*^9}, 
   3.8402033256104307`*^9, {3.8402033853654327`*^9, 3.840203389849573*^9}, {
   3.8402083148512197`*^9, 3.8402083155050097`*^9}, {3.8407375228438597`*^9, 
   3.8407375284121733`*^9}, {3.852392646515743*^9, 
   3.852392660240362*^9}},ExpressionUUID->"e20af42b-6d40-4618-ab3e-\
7f6ee166cb23"],

Cell["\<\
Plots for individual curves. Run all 1st sub sections (*.1) for any ONE of \
sections 1-4 to get the following plots.\
\>", "Text",
 CellChangeTimes->{{3.84020821445566*^9, 3.8402082213079405`*^9}, {
  3.8407375431039133`*^9, 3.840737573656345*^9}, {3.8906910841370816`*^9, 
  3.890691086114377*^9}},ExpressionUUID->"0bb540fc-6852-4fe5-a115-\
1d8216eb6b35"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sty", "[", "x_", "]"}], ":=", 
   RowBox[{"Style", "[", 
    RowBox[{"x", ",", "22", ",", "Bold", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7641040936418867`*^9, 3.764104132748686*^9}, {
   3.7641041822807865`*^9, 3.7641041886559896`*^9}, {3.764104220390233*^9, 
   3.764104220656125*^9}, {3.7641047568773613`*^9, 3.7641047570182447`*^9}, {
   3.764616885596898*^9, 3.76461688629985*^9}, {3.7646180932440147`*^9, 
   3.76461809385308*^9}, 3.7646185102095113`*^9, 3.7646854382525063`*^9, {
   3.7668662346362467`*^9, 3.766866235337978*^9}, {3.7703904948263483`*^9, 
   3.7703904949667683`*^9}, 3.7748789044893303`*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"dbb59f42-c57e-4d9b-aff1-56c225c7c116"],

Cell[BoxData[
 RowBox[{
  RowBox[{"plfn1", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fnActiveRAFDS", "/", 
         RowBox[{"(", 
          RowBox[{"fnActiveRAFDS", "/.", 
           RowBox[{
            SubscriptBox["d", "rel"], "\[Rule]", "0"}]}], ")"}]}], ",", 
        RowBox[{"fnActiveRAFNC", "/", 
         RowBox[{"(", 
          RowBox[{"fnActiveRAFNC", "/.", 
           RowBox[{
            SubscriptBox["d", "rel"], "\[Rule]", "0"}]}], ")"}]}], ",", 
        RowBox[{"fnActiveRAFCA", "/", 
         RowBox[{"(", 
          RowBox[{"fnActiveRAFCA", "/.", 
           RowBox[{
            SubscriptBox["d", "rel"], "\[Rule]", "0"}]}], ")"}]}], ",", 
        RowBox[{"fnActiveRAF", "/", 
         RowBox[{"(", 
          RowBox[{"fnActiveRAF", "/.", 
           RowBox[{
            SubscriptBox["d", "rel"], "\[Rule]", "0"}]}], ")"}]}]}], "}"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["RAF", "rel"], "\[Rule]", 
        RowBox[{"RAF", "/", "Kdim"}]}], "}"}]}], "/.", "baseparams"}], 
    ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8402082360195827`*^9, 3.8402082381943073`*^9}, {
   3.840208405579359*^9, 3.840208410242193*^9}, {3.840208539462367*^9, 
   3.8402085430057983`*^9}, {3.8402087068420377`*^9, 
   3.8402087807914934`*^9}, {3.840208813129917*^9, 3.840208873994952*^9}, {
   3.8402089047917185`*^9, 3.8402090526816025`*^9}, {3.8402090867535133`*^9, 
   3.840209106420163*^9}, 3.8405567776264963`*^9, {3.840556813588944*^9, 
   3.840556861128626*^9}, {3.840556896095601*^9, 3.8405569493715453`*^9}, {
   3.8405569916398296`*^9, 3.840557022416102*^9}, {3.8405570557066097`*^9, 
   3.840557056081601*^9}, {3.8405570944513397`*^9, 3.8405571109416265`*^9}, {
   3.840557153090444*^9, 3.840557210420456*^9}, {3.840557304655552*^9, 
   3.840557482378258*^9}, {3.8405575157253428`*^9, 3.840557647159919*^9}, {
   3.840557695175352*^9, 3.8405577266865454`*^9}, {3.8405577707798*^9, 
   3.8405578288546886`*^9}, {3.840557859042712*^9, 3.8405579441471653`*^9}, {
   3.8405579971279793`*^9, 3.8405581247025223`*^9}, {3.8405581617955756`*^9, 
   3.8405581638234463`*^9}, {3.840558296050604*^9, 3.840558381187831*^9}, {
   3.8405584389146013`*^9, 3.8405584435246058`*^9}, {3.840559909247938*^9, 
   3.8405599755485415`*^9}, 3.840562337867453*^9, {3.8405624289230375`*^9, 
   3.8405624420056734`*^9}, {3.8405624990460777`*^9, 3.840562499500558*^9}, {
   3.840562553154029*^9, 3.840562567166497*^9}, {3.8405627905773625`*^9, 
   3.840562844332452*^9}, {3.84056295634569*^9, 3.8405629683618193`*^9}, {
   3.840563183729681*^9, 3.840563184701506*^9}, {3.844884224868947*^9, 
   3.844884224884569*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"7e4c67be-d208-417d-b3ab-54f6fb76b11f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"legendlist", " ", "=", " ", 
   RowBox[{"Sty", "[", "\"\<AK\\n\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rvals", "=", 
   RowBox[{"{", 
    RowBox[{"2.", ",", "0.03", ",", "0.07", ",", "0.02"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"{", 
    RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cols", "=", 
   RowBox[{"{", 
    RowBox[{"Blue", ",", "Orange", ",", "Green", ",", "Black"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cs", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Directive", "[", " ", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", 
        RowBox[{"cols", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rvals", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"r1", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"dashing", " ", "style", " ", "by", " ", "model"}], "*)"}]}], "\n", 
 RowBox[{"LogPlot", "[", 
  RowBox[{"plfn1", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["d", "rel"], ",", " ", "0", ",", " ", "100"}], "}"}], ",", 
   " ", 
   RowBox[{"Frame", " ", "->", " ", "True"}], ",", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"Sty", "/@", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Relative Unbound Drug Concentration\>\"", ",", 
          "\"\<RAF Complex Molecules\>\""}], "}"}]}], ")"}]}], ","}], "*)"}], 
   RowBox[{"ImageSize", " ", "->", " ", 
    RowBox[{"{", "500", "}"}]}], ",", " ", 
   RowBox[{"FrameStyle", " ", "->", " ", 
    RowBox[{"Thickness", "[", "0.004", "]"}]}], ",", " ", 
   RowBox[{"FrameTicksStyle", " ", "->", " ", 
    RowBox[{"Directive", "[", 
     RowBox[{"25", ",", " ", "Black"}], "]"}]}], ",", " ", 
   RowBox[{"PlotRange", " ", "->", " ", "Full"}], ",", " ", 
   RowBox[{"PlotStyle", " ", "\[Rule]", "cs"}], ",", " ", 
   RowBox[{"PlotLegends", " ", "->", " ", "\"\<AK\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8402082360195827`*^9, 3.8402082381943073`*^9}, {
   3.840208405579359*^9, 3.840208410242193*^9}, {3.840208539462367*^9, 
   3.8402085430057983`*^9}, {3.8402087068420377`*^9, 
   3.8402087807914934`*^9}, {3.840208813129917*^9, 3.840208873994952*^9}, {
   3.8402089047917185`*^9, 3.8402090526816025`*^9}, {3.8402090867535133`*^9, 
   3.840209106420163*^9}, 3.8405567776264963`*^9, {3.840556813588944*^9, 
   3.840556861128626*^9}, {3.840556896095601*^9, 3.8405569493715453`*^9}, {
   3.8405569916398296`*^9, 3.840557022416102*^9}, {3.8405570557066097`*^9, 
   3.840557056081601*^9}, {3.8405570944513397`*^9, 3.8405571109416265`*^9}, {
   3.840557153090444*^9, 3.840557210420456*^9}, {3.840557304655552*^9, 
   3.840557482378258*^9}, {3.8405575157253428`*^9, 3.840557647159919*^9}, {
   3.840557695175352*^9, 3.8405577266865454`*^9}, {3.8405577707798*^9, 
   3.8405578288546886`*^9}, {3.840557859042712*^9, 3.8405579441471653`*^9}, {
   3.8405579971279793`*^9, 3.8405581247025223`*^9}, {3.8405581617955756`*^9, 
   3.8405581638234463`*^9}, {3.840558296050604*^9, 3.8405583258009443`*^9}, {
   3.8405600062487173`*^9, 3.8405600359630723`*^9}, {3.84056057615057*^9, 
   3.8405606574769535`*^9}, {3.8405607820473566`*^9, 3.840560849961791*^9}, {
   3.840560925251297*^9, 3.8405609390866785`*^9}, {3.840560981506955*^9, 
   3.8405611458792834`*^9}, 3.8405626029984665`*^9, {3.8405628802625246`*^9, 
   3.8405629419979615`*^9}, {3.8405629931392293`*^9, 3.8405630527497516`*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"e6de5fbf-2f22-41ea-acfd-0d9635502999"],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          Thickness[0.01], 
          RGBColor[0, 0, 1], 
          Dashing[{2., Tiny}]], 
         LineBox[CompressedData["
1:eJwVz3k41WkbB/Ajsv8mS2V9zbEVXmU7GWOZ586effej0aKsqRBly5h4RRHx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          "]]}, Annotation[#, "Charting`Private`Tag$16009#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          Thickness[0.01], 
          RGBColor[1, 0.5, 0], 
          Dashing[{0.03, Small}]], 
         LineBox[CompressedData["
1:eJwVj2k41Osfxocsg5mJmk5ImkhFsmQ5Jfp9yU6y+yESyZQIkSVFyFIkS9IJ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          "]]}, Annotation[#, "Charting`Private`Tag$16009#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          Thickness[0.01], 
          RGBColor[0, 1, 0], 
          Dashing[{0.07, Medium}]], 
         LineBox[CompressedData["
1:eJwVlWk4lVsbx3GQCmHb5qSUIieUo5LcdyLKkLmNRIZsoUyhyJAKGY6QITI0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          "]]}, Annotation[#, "Charting`Private`Tag$16009#3"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          Thickness[0.01], 
          GrayLevel[0], 
          Dashing[{0.02, Large}]], 
         LineBox[CompressedData["
1:eJwV12k8lk8XB3Ak3GsIIXFbQ7IUiuj6ZSkUyXqHFlQkCdkKpewVCZGyFioV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          "]]}, Annotation[#, "Charting`Private`Tag$16009#4"]& ]}}, {}}, {
    DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, 
     AxesOrigin -> {0, -3.8171536123187546`}, FrameTicks -> {{Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, 
        Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "ClippingRange" -> {{{2.040816326530612*^-6, 
        99.99999795918367}, {-3.8171536123187546`, 3.7857561060165565`}}, {{
        2.040816326530612*^-6, 99.99999795918367}, {-3.8171536123187546`, 
        3.7857561060165565`}}}}, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
     BaseStyle -> {FontFamily -> "Times"}, 
     CoordinatesToolOptions -> {"DisplayFunction" -> ({
         Part[#, 1], 
         Exp[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Part[#, 1], 
         Exp[
          Part[#, 2]]}& )}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
     Thickness[0.004], 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     FrameTicksStyle -> Directive[25, 
       GrayLevel[0]], GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, PlotRange -> {{0, 100}, {-3.8171536123187546`, 
       3.7857561060165565`}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox["\"AK\"", TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.840563042107834*^9, 3.8405630531349993`*^9}, 
   3.840563117540841*^9, 3.840563256537961*^9, {3.840563368602703*^9, 
   3.8405633774873333`*^9}, 3.840563408430152*^9, 3.8405634787184863`*^9, 
   3.840563529973671*^9, 3.8405636929221077`*^9, {3.840563960906495*^9, 
   3.840563988409459*^9}, 3.8405641398656597`*^9, 3.840564210040119*^9, {
   3.840564372118889*^9, 3.840564435679576*^9}, 3.8405644681118813`*^9, 
   3.8407376896559744`*^9, 3.844945311986333*^9, 3.8449454744714236`*^9, {
   3.8449455657857013`*^9, 3.8449455816878195`*^9}, 3.844964704235731*^9, {
   3.844965776438053*^9, 3.844965798444755*^9}, {3.8449662580931425`*^9, 
   3.8449662775012*^9}},
 CellLabel->
  "Out[159]=",ExpressionUUID->"fa853207-6607-48ac-96b9-8194ecac33b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fn2part", "[", "1", "]"}], "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "a", ",", "AA", ",", "AAd", ",", "AdAd", ",", "A", ",", "Ad"}], 
            "}"}], "/.", "rep1"}], "/.", "sol1A"}], ")"}], "/", "RAF"}], "/.", 
       RowBox[{"d", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["d", "rel"], " ", "Kd"}], ")"}]}]}], ")"}], "/.", 
     "baseparams"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fn2part", "[", "2", "]"}], "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "a", ",", "AA", ",", "AAd", ",", "AdAd", ",", "A", ",", "Ad"}], 
            "}"}], "/.", "rep2"}], "/.", "sol2A"}], ")"}], "/", "RAF"}], "/.", 
       RowBox[{"d", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["d", "rel"], " ", "Kd"}], ")"}]}]}], ")"}], "/.", 
     "baseparams"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fn2part", "[", "3", "]"}], "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "a", ",", "AA", ",", "AAd", ",", "AdAd", ",", "A", ",", "Ad"}], 
            "}"}], "/.", "rep3"}], "/.", "sol3A"}], ")"}], "/", "RAF"}], "/.", 
       RowBox[{"d", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["d", "rel"], " ", "Kd"}], ")"}]}]}], ")"}], "/.", 
     "baseparams"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fn2part", "[", "4", "]"}], "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "a", ",", "AA", ",", "AAd", ",", "AdAd", ",", "A", ",", "Ad"}], 
            "}"}], "/.", "rep4"}], "/.", "sol4A"}], ")"}], "/", "RAF"}], "/.", 
       RowBox[{"d", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["d", "rel"], " ", "Kd"}], ")"}]}]}], ")"}], "/.", 
     "baseparams"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plfn", " ", "=", 
   RowBox[{"SimplifyPars", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"fn2part", "[", "i", "]"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "4"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legendlist", " ", "=", " ", 
   RowBox[{"Sty", " ", "/@", " ", 
    RowBox[{"{", " ", 
     RowBox[{
     "\"\<a\\n\>\"", ",", " ", "\"\<AA\\n\>\"", ",", " ", "\"\< AAd\\n\>\"", 
      ",", " ", "\"\< AdAd\\n\>\"", ",", " ", "\"\< A\\n\>\"", ",", " ", 
      "\"\< Ad\\n\>\""}], "}"}]}]}], ";"}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"plfn", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["d", "rel"], ",", " ", "0", ",", " ", "100"}], "}"}], ",",
      " ", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", 
     RowBox[{"ImageSize", " ", "->", " ", 
      RowBox[{"{", "500", "}"}]}], ",", " ", 
     RowBox[{"FrameStyle", " ", "->", " ", 
      RowBox[{"Thickness", "[", "0.004", "]"}]}], ",", " ", 
     RowBox[{"FrameTicksStyle", " ", "->", " ", 
      RowBox[{"Directive", "[", 
       RowBox[{"25", ",", " ", "Black"}], "]"}]}], ",", " ", 
     RowBox[{"PlotRange", " ", "->", " ", "All"}], ",", " ", 
     RowBox[{"PlotStyle", " ", "\[Rule]", "cs"}], ",", " ", 
     RowBox[{"PlotLegends", " ", "->", " ", 
      RowBox[{"legendlist", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"Length", "[", "plfn", "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8402082360195827`*^9, 3.8402082381943073`*^9}, {
   3.840208405579359*^9, 3.840208410242193*^9}, {3.840208539462367*^9, 
   3.8402085430057983`*^9}, {3.8402087068420377`*^9, 
   3.8402087807914934`*^9}, {3.840208813129917*^9, 3.840208873994952*^9}, {
   3.8402089047917185`*^9, 3.8402090526816025`*^9}, {3.8402090867535133`*^9, 
   3.840209106420163*^9}, 3.8405567776264963`*^9, {3.840556813588944*^9, 
   3.840556861128626*^9}, {3.840556896095601*^9, 3.8405569493715453`*^9}, {
   3.8405569916398296`*^9, 3.840557022416102*^9}, {3.8405570557066097`*^9, 
   3.840557056081601*^9}, {3.8405570944513397`*^9, 3.8405571109416265`*^9}, {
   3.840557153090444*^9, 3.840557210420456*^9}, {3.840557304655552*^9, 
   3.840557482378258*^9}, {3.8405575157253428`*^9, 3.840557647159919*^9}, {
   3.840557695175352*^9, 3.8405577266865454`*^9}, {3.8405577707798*^9, 
   3.8405578288546886`*^9}, {3.840557859042712*^9, 3.8405579441471653`*^9}, {
   3.8405579971279793`*^9, 3.8405581247025223`*^9}, {3.8405581617955756`*^9, 
   3.8405581638234463`*^9}, {3.840558296050604*^9, 3.8405583258009443`*^9}, {
   3.8405600062487173`*^9, 3.8405600359630723`*^9}, {3.84056057615057*^9, 
   3.8405606574769535`*^9}, {3.8405607820473566`*^9, 3.840560849961791*^9}, {
   3.840560925251297*^9, 3.8405609390866785`*^9}, {3.840560981506955*^9, 
   3.8405611458792834`*^9}, 3.8405626029984665`*^9, {3.8405628802625246`*^9, 
   3.8405629419979615`*^9}, 3.8405631465008116`*^9, {3.8405632007614336`*^9, 
   3.8405632039152093`*^9}, {3.8405633118949394`*^9, 3.840563312296713*^9}, {
   3.840563713089605*^9, 3.840563713575398*^9}, 3.8405638193713093`*^9, {
   3.840564315056228*^9, 3.8405643276125755`*^9}, {3.8449662048164234`*^9, 
   3.844966229160063*^9}, {3.8449664851939106`*^9, 3.844966488091436*^9}, {
   3.844968395091468*^9, 3.8449683966814604`*^9}, {3.844968510923204*^9, 
   3.8449685367837744`*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"4027258f-dc1d-4a0a-ac08-69e7f83f7399"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 0, 1], 
            Dashing[{2., Tiny}]], 
           LineBox[CompressedData["
1:eJxNz30s1HEcB/Afk6vWLfTgYTcPl8qZ5q5u0oVDnec77iJPY6Jzv/MQDqEu
eWhKrjwt1XCYx9jQSZJdOvMQZXT5J2xoy8NqPXjoQueqLZ9v7+29915/vi0i
E3h8bQzD2H/6d8mF6lqpqcIJ+5eunRSzeLyKuW1FemudFd4GHqQmCXTxXvAr
idJjTTAGHmbkdn8WzIBHiqeSFgVfwV5yAmdeoAGPEu126YTpOW/btZD1stHX
CMy33SDSiOZgNoX//aC7JVg2cS112N4KfNrAuk3nug1YsFlSWR9EBScMLpxo
Yx8H3w7RPayOo4Ojhq5G03A7sIJgzI0NtgfT9LPKllIY4IgVRxtOnAO4RjpA
Ut1xAnfcZUwpec7glOeOfpU+LuDekfrl/FBXsND9lFwYdAZc0UTrjI05Cy5e
kWcnprHA882pl3GRG7jfreRBTo47WMt38kNhlgcYc3mqVZ3hCb5lqGIrb3qB
E0Oi+lS53uC5bPpF5j0f8P7Sh5P5NWxwg551xlA5B6wQmbGOtviCpebVJEd/
P7BcvIHh48gW3oRfhwK54CdjlIL3E8iSwS2qeRgPXJq8FBMxjSw+YLqXHHwO
/IiyYyRlFll3VctYEe4PbqQ+zpQuIFMimznq+ADwlGe3LOATsrL2yjFm8nnw
zw6uA3kZWfNM1Jl3KRDsTXVjideQh8JshbHJQWCDKLynMhU5HK8hjqch/xDt
k9HFyJa3VBvqG8hZsl5JURkyg+DX3tmNnLcnX3uxB/mtfp+/yQtknERfz+xD
vk8zcvV4jbwaOvtuchrZ+YLxEeIMckE0L505h0xO6ifVfUTm5jXx478gVxTM
dVV9Q14sMtmtXP7vT7mk1U6F/KZ6ABOuIxs2bPHKN5EjW07Wj6qRW9sTVRoN
8m8O/xY3
            "]]}, Annotation[#, "Charting`Private`Tag$18091#1"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[1, 0.5, 0], 
            Dashing[{0.03, Small}]], 
           LineBox[CompressedData["
1:eJxNz30s1HEcB/Afk6vWLfTgYTcPl8qZ5q5u0oVDnec77iJPY6Jzv/MQDqEu
eWhKrjwt1XCYx9jQSZJdOvMQZXT5J2xoy8NqPXjoQueqLZ9v7+29915/vi0i
E3h8bQzD2H/6d8mF6lqpqcIJ+5eunRSzeLyKuW1FemudFd4GHqQmCXTxXvAr
idJjTTAGHmbkdn8WzIBHiqeSFgVfwV5yAmdeoAGPEu126YTpOW/btZD1stHX
CMy33SDSiOZgNoX//aC7JVg2cS112N4KfNrAuk3nug1YsFlSWR9EBScMLpxo
Yx8H3w7RPayOo4Ojhq5G03A7sIJgzI0NtgfT9LPKllIY4IgVRxtOnAO4RjpA
Ut1xAnfcZUwpec7glOeOfpU+LuDekfrl/FBXsND9lFwYdAZc0UTrjI05Cy5e
kWcnprHA882pl3GRG7jfreRBTo47WMt38kNhlgcYc3mqVZ3hCb5lqGIrb3qB
E0Oi+lS53uC5bPpF5j0f8P7Sh5P5NWxwg551xlA5B6wQmbGOtviCpebVJEd/
P7BcvIHh48gW3oRfhwK54CdjlIL3E8iSwS2qeRgPXJq8FBMxjSw+YLqXHHwO
/IiyYyRlFll3VctYEe4PbqQ+zpQuIFMimznq+ADwlGe3LOATsrL2yjFm8nnw
zw6uA3kZWfNM1Jl3KRDsTXVjideQh8JshbHJQWCDKLynMhU5HK8hjqch/xDt
k9HFyJa3VBvqG8hZsl5JURkyg+DX3tmNnLcnX3uxB/mtfp+/yQtknERfz+xD
vk8zcvV4jbwaOvtuchrZ+YLxEeIMckE0L505h0xO6ifVfUTm5jXx478gVxTM
dVV9Q14sMtmtXP7vT7mk1U6F/KZ6ABOuIxs2bPHKN5EjW07Wj6qRW9sTVRoN
8m8O/xY3
            "]]}, Annotation[#, "Charting`Private`Tag$18091#2"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 1, 0], 
            Dashing[{0.07, Medium}]], 
           LineBox[CompressedData["
1:eJwV02k41AsbBvAhW0WhKUKZEDOOtaRSPE/2pcKQ/igV2SoRoSRZsmUropQs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            "]]}, Annotation[#, "Charting`Private`Tag$18091#3"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            GrayLevel[0], 
            Dashing[{0.02, Large}]], 
           LineBox[CompressedData["
1:eJwVlmc4FY4fxe0kGkZUSFboJmSU0vebbJlJ1/yVPSuykkIoskeUSpS6Ri4Z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            "]]}, Annotation[#, "Charting`Private`Tag$18091#4"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {Automatic, 0}, FrameTicks -> {{Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
       DisplayFunction -> Identity, AspectRatio -> 
       NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
       AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
       BaseStyle -> {FontFamily -> "Times"}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
       Thickness[0.004], 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       FrameTicksStyle -> Directive[25, 
         GrayLevel[0]], GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}],FormBox[
      FormBox[
       StyleBox["\"a\\n\"", 22, Bold, StripOnInput -> False], 
       TraditionalForm], TraditionalForm]},
    "Legended",
    DisplayFunction->(GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ),
    Editable->True,
    InterpretationFunction->(RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )], ",", 
   TemplateBox[{GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 0, 1], 
            Dashing[{2., Tiny}]], 
           LineBox[CompressedData["
1:eJwVinc4Fe7fgI9NRhxbkt0hexPP80nISlY6iCRxzOxNlIZIVkZmssuIFIlI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            "]]}, Annotation[#, "Charting`Private`Tag$18145#1"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[1, 0.5, 0], 
            Dashing[{0.03, Small}]], 
           LineBox[CompressedData["
1:eJwVl/c7FYzfgOUcm2SPRyWbRzjGMcLnI0fZexxkSycjI5lZISSyQqEohIYt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            "]]}, Annotation[#, "Charting`Private`Tag$18145#2"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 1, 0], 
            Dashing[{0.07, Medium}]], 
           LineBox[CompressedData["
1:eJwV02k81IvbBvCxlVL/kKRD0mAauxn74HffGKmxZBlMlmyJLCVUOlGWIpQt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            "]]}, Annotation[#, "Charting`Private`Tag$18145#3"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            GrayLevel[0], 
            Dashing[{0.02, Large}]], 
           LineBox[CompressedData["
1:eJwV1Gc81Q8bBvBDREa2JNnzdMKxMn/3nVGyZx1EMg+RyKqQWSSSimRWVCQz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            "]]}, Annotation[#, "Charting`Private`Tag$18145#4"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
       DisplayFunction -> Identity, AspectRatio -> 
       NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
       AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
       BaseStyle -> {FontFamily -> "Times"}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
       Thickness[0.004], 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       FrameTicksStyle -> Directive[25, 
         GrayLevel[0]], GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}],FormBox[
      FormBox[
       StyleBox["\"AA\\n\"", 22, Bold, StripOnInput -> False], 
       TraditionalForm], TraditionalForm]},
    "Legended",
    DisplayFunction->(GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ),
    Editable->True,
    InterpretationFunction->(RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )], ",", 
   TemplateBox[{GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 0, 1], 
            Dashing[{2., Tiny}]], 
           LineBox[CompressedData["
1:eJwVlnc8FI4fximikJFESTLOyO7ybenzqZC96RChsiUlJOTOzgiV0RDRZXWO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            "]]}, Annotation[#, "Charting`Private`Tag$18199#1"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[1, 0.5, 0], 
            Dashing[{0.03, Small}]], 
           LineBox[CompressedData["
1:eJwVlnkw1Y0Xxq8iCi/ZCa9QIWtJXqVzIpQiexeRlFwkW6ToXluyJ7KVNUTX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            "]]}, Annotation[#, "Charting`Private`Tag$18199#2"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 1, 0], 
            Dashing[{0.07, Medium}]], 
           LineBox[CompressedData["
1:eJwVlnk41dsXxnGFTCUzB8eQOLkicjO1VqaSeT4URcU5pswkZOacr1KGJHMX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            "]]}, Annotation[#, "Charting`Private`Tag$18199#3"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            GrayLevel[0], 
            Dashing[{0.02, Large}]], 
           LineBox[CompressedData["
1:eJwV13k4VV8XB3BzMkWGkOFeU0iGkiSslaFBmacrZCpUVIQkhAhFb1E0oBQq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            "]]}, Annotation[#, "Charting`Private`Tag$18199#4"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
       DisplayFunction -> Identity, AspectRatio -> 
       NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
       AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
       BaseStyle -> {FontFamily -> "Times"}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
       Thickness[0.004], 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       FrameTicksStyle -> Directive[25, 
         GrayLevel[0]], GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}],FormBox[
      FormBox[
       StyleBox["\" AAd\\n\"", 22, Bold, StripOnInput -> False], 
       TraditionalForm], TraditionalForm]},
    "Legended",
    DisplayFunction->(GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ),
    Editable->True,
    InterpretationFunction->(RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )], ",", 
   TemplateBox[{GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 0, 1], 
            Dashing[{2., Tiny}]], 
           LineBox[CompressedData["
1:eJwV1Gk01QsXBnBEFO4VMhRlSqZMoVLsnakSMsVBuqWMhxBFmYfKPI+VqTSQ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            "]]}, Annotation[#, "Charting`Private`Tag$18253#1"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[1, 0.5, 0], 
            Dashing[{0.03, Small}]], 
           LineBox[CompressedData["
1:eJwVznk0FAobBvBRtkKWJCSNJWYke4rwvokS2ZfGlrHMojFTQnVFSLYs2ZcI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            "]]}, Annotation[#, "Charting`Private`Tag$18253#2"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 1, 0], 
            Dashing[{0.07, Medium}]], 
           LineBox[CompressedData["
1:eJwV1Hk81PkfB/DRxeaopESaRPk1Vq6kTXh/YjGEjKuvq3IM48oR5b5XFLnW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            "]]}, Annotation[#, "Charting`Private`Tag$18253#3"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            GrayLevel[0], 
            Dashing[{0.02, Large}]], 
           LineBox[CompressedData["
1:eJwVk2s81Ikeh7G5bMdlpYS17mz6aKMkxPx+FLmEMY31l0shDOWYxkwNIZXT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            "]]}, Annotation[#, "Charting`Private`Tag$18253#4"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
       DisplayFunction -> Identity, AspectRatio -> 
       NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
       AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
       BaseStyle -> {FontFamily -> "Times"}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
       Thickness[0.004], 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       FrameTicksStyle -> Directive[25, 
         GrayLevel[0]], GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}],FormBox[
      FormBox[
       StyleBox["\" AdAd\\n\"", 22, Bold, StripOnInput -> False], 
       TraditionalForm], TraditionalForm]},
    "Legended",
    DisplayFunction->(GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ),
    Editable->True,
    InterpretationFunction->(RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )], ",", 
   TemplateBox[{GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 0, 1], 
            Dashing[{2., Tiny}]], 
           LineBox[CompressedData["
1:eJwVlmc8FQ4bho9VRiKU8UdWVsqmrOepkAgdq4PICMdKske2bLJDhZDsg0rT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            "]]}, Annotation[#, "Charting`Private`Tag$18307#1"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[1, 0.5, 0], 
            Dashing[{0.03, Small}]], 
           LineBox[CompressedData["
1:eJwVlnc4FY4bxRFfKuomSlIJGTebVML7lpkimbfMNOyyKSrca2WGjMgoZMUl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            "]]}, Annotation[#, "Charting`Private`Tag$18307#2"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 1, 0], 
            Dashing[{0.07, Medium}]], 
           LineBox[CompressedData["
1:eJwVj2k8lAsbh0dpqIg0tpqjyVJIskVxuG+hZM1keSIthFFUhDzZholsqZCU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            "]]}, Annotation[#, "Charting`Private`Tag$18307#3"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            GrayLevel[0], 
            Dashing[{0.02, Large}]], 
           LineBox[CompressedData["
1:eJwVllk81A0bhgcjKmSNSkL2JlEIrzxPQpbsS3/EKy1ExFiSdbLLvi8Nxh6y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            "]]}, Annotation[#, "Charting`Private`Tag$18307#4"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
       DisplayFunction -> Identity, AspectRatio -> 
       NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
       AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
       BaseStyle -> {FontFamily -> "Times"}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
       Thickness[0.004], 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       FrameTicksStyle -> Directive[25, 
         GrayLevel[0]], GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}],FormBox[
      FormBox[
       StyleBox["\" A\\n\"", 22, Bold, StripOnInput -> False], 
       TraditionalForm], TraditionalForm]},
    "Legended",
    DisplayFunction->(GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ),
    Editable->True,
    InterpretationFunction->(RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )], ",", 
   TemplateBox[{GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 0, 1], 
            Dashing[{2., Tiny}]], 
           LineBox[CompressedData["
1:eJwV1nkw190XB3CKUohQqQcJ2UIIyUPnZCmUJcTXWpHsZSdR9pJdskQosiX7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            "]]}, Annotation[#, "Charting`Private`Tag$18361#1"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[1, 0.5, 0], 
            Dashing[{0.03, Small}]], 
           LineBox[CompressedData["
1:eJwV1mc41433wHEiI9y3Gwk/layQGekmnGNlRRnxjZSMiEh2SBSVkWTTQLeU
ESIqsmmISDZl850fUlJK/t//g3Od63Vd7wfn4dnles7GYxMLC0szc/5/S95c
/+/ejhY9A+uMpYGgWr1nXPI7fb3yQHVNy6J8PQ1awsoL5bwq4Kz3gcUXZ/+D
V6rnPTm8mkA3JCHV0LMKIrduPN/Ib4PAweCgqbO1kJlqrPf7xmuwKwjwadev
gzdJfaYrnj1wPjhppeBpMyzF8i6ElXyAtIFKXftTrXCxrUJ+Nf8j/MuzfzTh
dxtk4vfyrzeGwL8CRk+xvYa32lde0D0nYBcj51O3XxeU6ghG7auYBGGLp5aF
Zd3wZcw9L6hkCp7ZVBpoT76HKDGu6eX8GYiQicWgjF7IyrLyXLyxAGYqQRmz
j/vgs2b+deV4MtCoEZYvFT6C9OCXYt9YCnCVmcdpFX6ESqEMOi2cBlWp2kvN
N/qh89bYebLnIuBLV4dWvUG4np35Nk1tCcI/h33JKRwERS9wVK9Ygl/PNbSE
uYYggPNWREDJF3guKVPk+GYI/hhrNC7lf4V9pwO8nFVHoGDrJ6uUHd9Aiasl
tiJuBIzm4iZU7nyDJ/f2DBqOjEBi7BDLuawV0CxlrzgXMQoibeGGjBurcCAx
Ks7u8RjUp0r1J/H8ALHc0Ai972NwwrXLXTH+B8REMnL7dMehkHXHVZ/Yn6A/
hGWSb8dBDVveUMJ/wfZ0T/D58AnMGzit5j034G9rN/5nFROgtuG6Iry0AVLf
9MxWaBOQJHHyvZQOC3oHvxDLFZyEINe6YLt2Fsz9RHR7Wk6C0bx/e00/K35n
6TTJqp+EacanU2ErbHh0+vFEVewUDCYn1qRosaP+Hh2V/XemoFNFi7v4IjtG
J784cbp6CqrOp1eObN6MCo4HhLsnpyBmxXxDW5gDOUcdM4j90yCx/uzOuiYX
xriETFOHp0HonsfS1ggu7L7r1b9AmwYuEDRSbuLCpLvxVx79mYbFaD/aCRNu
3KzEPnxBagYa2WW0mx224DSGd0R4z4Azb+rQ5TBe/CvXn2OSmIEjj2HP7Ze8
2Fa+/UrWnxkwsmJEVbPwof/OhEDJv2ZBMcVUdvY6H2p+UHhXozgLvwU3goxz
/sLSuCe8C56z0M2nyc3uzI9cQb0XeIZmoc9CIPt9JD+qV467+s3MwnA8IZtz
hx+3q5/Kql6chdnND42Ux/lxk7lQwTznHPxe3xZNcvoHMyh1jDXNOVAgfn4v
OyaAF6m5Luopc6CqOBgXekEAresfL1Nz50DTu0rIIEcA3e3LPiU8mAODee+9
Q8MC6OrcxBZXNwfHPo/5spIEkeettKTPzBxcf98we9ReCNcI7ko9tXlI5s0N
lAgRQvpiG0ee9jykm4dsomUI4Z+ZZCW64TzkvVKWiB4QwlD5X58t7eehtjHP
qcRuK7qGyOrvC5+HufKYvj82wmigxH6ivXEeDG4aNz88LIIu7v881NZZgGjz
p8V9fiKosWuXeLDhAjRulkpbvyGCOftCJu+bL4B2JMtp2y4RTPhjPDlMWgD1
M/U8G6aiWN1zyLUqaAGkDdUc7A3EkNNaSXR/yQJwrIoT7PvEUeT9eq8VHxmM
qhKHVOzE0XHQy1NJkAyXfdeaHQPFUbbrV+cmUTL8mRlKq3wijkKVm21Spcmw
2puqdVx5O5qN0usOHiADuYQrrnr3Dhxrz1sW9iSDh8oanxqfBOb0vpQcfk6G
Q2PXHojskMDR9LpnOxvJoHFtqy6LigSOn/ygcrKNDOwTqmd7jkhg5F3fra+6
yXA/2bPTN10Cf15Ub9w3TYYJRv/Vkv/tQmfGGlcZNwWOlVVsSClI4ulUlWUP
WwogSTeL54AkDsjUtXc6UECO/Z3yVwtJNCFiQ+WPU+CH07xzq68kDhJ9T/rd
KZDJs/2lyxNJlKKuj88EU+Cjd0LY3X+lULdtvHYxkwKW8h5fhE2kcaOsQ5R3
gAJricH1n+yl0W3Yzzh2mAKPiLi4wtPSmMc9avVjjALsT4tE916Vxo7AGZH+
aQrU6ZH1LTukkdfD0MFpiQKydj6pVwxlsPDS54ryLVRguXRefQlk0brOkT9L
hwrlUzHrtYdl0eNhlEY2UMHJKPX1xZOySE+6z5FpQIVa7monnkuy6GKy5901
UyqcTf92RbZRFss7LfyM7KgwUhzaf1xnN6o+SGmQ9aFCVf/F4Lf/yqFhXI5m
VSYVHsW5u06byWH4pXLtxBwq3NO0OPzLUQ7Xe+7xn7pDhYRsEXmli3K4I/KW
Cdt9Krgdrx5PaZHDolOZwZKPqSA0SzYkmcuj4wUn895WKoR8tRVYcFLAgee2
x3joVDggoFDBfkkR+35zZ9I0afCe1fFt901F1D5ff1tAiwYuX+JnMvMV8S/l
lFv7D9AgtpeyTb5VEc+V3zoWAcw+uTjacrMSdkrte0w1YfY88jaZiUqY3VI0
7U1i9uxyK7uzlTGiw9+PPYwGnr9S7z4gqSLrJcePUlU0SLeit11wUUWb5kdP
G6pp0FxgTLX0UkXjk28O29fQQMT0h+b3UFXMt895ceU5Dd6kO/cezFLFeZs3
cT2NNJBXlmMjD6ii8s2n5orvaEBzafBSsFVD/WUeV/YZGpx7taBeYbkXd3Mz
Pob8TYdmLPNRtN+L9JzfJ+f56cBf7/9f8Ym9uE0SuuwE6FBZ8VOg8NxeNI8u
MVfeSoflbJ7l7Ft7cSi2ja1fjA4hPiqVlwf24knP3DiaDB0i+UMV7Z3V8VrT
mL3tATokOHLIrJ/VwI6mSyNGbnRwex1xWs1LEwX5B8K3PKBDC6eotc+xf9GF
f3uexzgd1P6JzqQEaeMvw4qaI/wMcPmqq2h1VgejejJLU7QZUHCvQ3z1hh5O
p3SaD7syoDpZe6zPBnGsK6GmLY4BQXW6R+4e0kdKtXvRxH0GNHU+WI53MsDe
2OBybGLAGROthjMkQ2wnqx9XHGLAnUdqNT7eRri04qNZSTDg1teGGP9QY3S+
tp+zlI2A+ZLgEK+AgxhoruWes5WA9oOp2Zcvm+CNomLDsN0EsB4enb4ZbYqM
S1saRjQJYNGvZc2/YIb0Pe9Kh4wIuL5t1bLvmjnujhA0W7QhwN/RrXX1igWW
L0qk7jlJwFSMhjtkHELaJJtQvA8BQmk5o/EFlhhWzlYyFkJAEb/Chde3rZA9
+tDh1mgCWgJ2Gu8uPYxnzUzrhhIIuCeRL65rdwT5xJX3VKUR0BC5xuLVewQ/
yE5Kzt0mYJcF528pB2u05Ve+fKiQgKc98okj/dZY5+jWU1tKQNKrP6oSzjbY
GHXB27aagLRAirfLuA16xcvq8dcRzH9tx9+Sx2xxcp1N9FgzAcXymzuDJm1x
4OKTL/2vCOD4xiracsIO9XQyarK6CHio+iTq3oId+iXH3UroI0DetcRq3fco
RicKvhEbJmDM7EXVUdpRNGuUO8L/iYC+/8KVINAec8aymzSmCfhRba0juWyP
yXlv57rmCdh4HlBz1c8BTYxlAnbSCLBQPWgcueKAIzFaYnmLBLx2VjnjE0hC
jcG8tKKvBAi4edXfDSbhe4vrms+ZPuFVwNcbSsIvUW6Db5n+HiBYpRFJwh7T
FV4G09LXV9fWY0lIvXrnqPo3AqKrmpJSMkk4+Lj4aBPT2pxHKmtekPBlvKrw
wAoBV3njN5HrSThx9BtpnukP/7TaiTWSML2qLXuVaS9xjZ9RrSQs3339b7Hv
BGSpiRiYviOhh1LDyAmmvzlNfhwdJ2GsfvTUAtN4SlSWb4KEllkOKz+YTjxt
EwZTJBS7cpBjyyoBkufbxQvnSDgj6LdTkWnrq488fAkS6g79UPZn+k7i1LO8
JRK2ZhfsiWGanCK2pW+ZhH0jnjKpTEffTirXXCVh1LvD/E+Z7srvYDnzk4SF
XwNYO5jeVvTH5vYv5j0JtYsDTLuW7n/QvU7CnRb/G5tnurzSf3Vjg4S+SwVt
q0z/Hx963l8=
            "]]}, Annotation[#, "Charting`Private`Tag$18361#2"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            RGBColor[0, 1, 0], 
            Dashing[{0.07, Medium}]], 
           LineBox[CompressedData["
1:eJwVz2k41Asbx/FRsiRPFOIkja2GYxkldYj7jkhkF3+kRzoYpMWaUjmUiFBk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            "]]}, Annotation[#, "Charting`Private`Tag$18361#3"]& ], 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Thickness[0.01], 
            GrayLevel[0], 
            Dashing[{0.02, Large}]], 
           LineBox[CompressedData["
1:eJwVlHk41Ikfx0e5Cr+EasyjnNl42pZNssLnY9ysSUhfLIuSseS2OSar7Fpq
VFiDX9JUlKMootw5QlaOyTlH4ucsFVqkTPOzf7ye9/P66/3fS90v1Nl/E4lE
itjg39W4Irydv6fZTPdwvxelIcXssbSO6hn6DfBpY4e2dPtDc0xZwT56Oeyr
rKrLkYyGdr3wAEl6E7h1UG8aNCQBY4foiYjdChnDR94tC/8EVoaV2XpaB3Re
LIkwl2VCJ5NjuxzQC3EBhxXCB9Jh4XfZmZiSftBu3hmlw86Ec63lOqvsl9Cl
2adG+ikLWLhS9jFtGE49PXK1qDgHnhsn1cwHjEGviJmVUJsPpSaKCYfKX0N+
lu0ee0U2LPJO3YgqGQf8g3pe8xkbEijSE0vs/0Eo8/42y923IDubFvAhbQZC
UxrIWwsLoCudFz4b8AGsLwSbeBsUQ0oO63mm/gL4UYTzIfXFsJ8OHgfLF0Cq
9LNBDrUEIqTS4yNKFmHm3KaJeLtS+Gpl0LjA/ghqWy9dpFrcB3JrnMW7tFW4
rSm6JxX7AOwbpGjTASKgqN5/9qKhEvRFfss7F0SQ+WbQwXupEphqP/dompDw
iZSHcpz2I4jyq412bSMhWnVPeqU9AsvpsLaqATFsDM3OVnargol3At+Y5c0Y
Z1udYzxYDWrCx3lCQ2kM7vM+25tVA0r5/gs74qVRY00mn9FUA9KgaHmgSRpV
Cxrd52Zr4ENiyFtvmy3YeysoTOJILTSK7zV+emIrunl9fOPLrwUv2YzhCzGy
GPu+apCuVA8v5Ay3iHvJ48pO/E+pdyNwHBRyehjyuLv15f743xphJPW9dm6e
PA4Y9iRrsxthUuKu5QG+PN4STZyTH2+EdeGuRMJzO97zKZcz8W0C3fdrK/fc
FXCQunKR/e1TSOlpmDzupoRr16acKCrNQL1i9fTuUTIG8G44TfW3QKL9o2JO
CBmNfhAfZ71qgUYJzUxhGhnHDpFDzd62gDGDdNqlm4zLD6V7QsVb4WBgnYzI
VhkVH69f9jJsBS0L/RNuVAo6MTbrReW0guSqynvxQypIkS2rXz/eBv7ffZbT
l1PDTx17PUNrnoGjjv/iThst9HT543mMfydUDJyLfm60D4sOiZxy07vgiIJu
ufhv+7GL7Fz2sKgbAr5kXC8k9HC72OG96ok9ENo+c7Dc8Xs0nr2T7CPdBxc9
JPcKgw2Q9WBKta+3D052xJ/Wpxti/2yw89/x/dAspXwsyN0I1a0dU6bJHNDf
nsiaizLGBaNkhd1POODz0XQ/LdgE61c0jDwsXsLN/Gcqq2lmqMWIzbXsfwmV
l415HGdEvltve4jrAETVmjpd/9EcITOKZtA5AE1dhUupnlTUVP5vlQMMQqDN
Dw2BhAUeZNSQ5ooGIa9IvyroF0uszpZjDe4YgvSPDefDzlrh6HRQ+d34IZgu
if6VHmGNYuGazSFDQ9BmnZFz4YIN/tVNM80zGAaxo9yJK4m2eKvnJ4fhlGEg
mVeLsWPt0IX5KllvZBhSdq06cv60x5yses6U7giEeZxsWU1yQIpSK3VP9AiM
nzc4BVk/on5Xd15qywgoZeZyU2864s7AFKX7MqNwR143tuMaDVUWObMMx1Fo
jlC1+qb0KB5kRn7xyxiFfDW2iqmrE0ar8ZST+kahgfGZRO9zQlrkFalYGS6o
O0ita544hoLZTtopOy486tW5NDpwDOcm+UzX81xgtn/VU/NyRtuko36K9VzI
jJz7xYfvjBrG5vami9yNnu3ZpuHugmOYa8rV5EGxjkRX1GsXfGDa/krLnQeS
/4gpN3u74u4sD1FYKg/u6j1MyJ9xxZ/NYjJs63mg41dCE545jnQZT/XmeR7w
7Goqjr89jlnmvm31ZD5wbsd9C5FuuKZbwdKy4cOnymMmGktuWNOWevNoOB9E
TyKqkkNO4ADvcmZeLh8c9KytGMsn8Jv2zbZGbXzo8PouMCiSQPOhAPW1N3xQ
OEmvux5N4IpXh2TBWz5402/K9Z0lUHpL5ihtng8rEYoVBgwCs+7H2xS844NW
yupn4e8E0qjzlrQFPiRWNDGvsgis/ov8PH+ZD8ZSTg+qagicLZ+U/Z4kgGTZ
1E2zdQS6B30q5G54//YWV0ojgcEfBPuTxARAVzFYS2gh8FeOrvjAJgFk65Op
tn8T2OyjORolIYB/PF+/5PIJPC1lq1q5VQDoq6wtN0agNvcdy0NGAJdOO8fA
+Mafeva6mKwANMLbVAqmCPTyJWU4yQngWHKR/5n3BGrdS5qa3yaAvEvjj28s
EJhgdO1FprwAZq9StnKWCMTOntvG2wWQeI1ZZrhK4CddFiVFQQDd7GekwDUC
75L16g4oCmDXna/O174QuBuW7AY33K/0cOELIYHjxWPt8UoCKHsQtioSEdh0
8ou+xg4B/B9qhmAu
            "]]}, Annotation[#, "Charting`Private`Tag$18361#4"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
       DisplayFunction -> Identity, AspectRatio -> 
       NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
       AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
       BaseStyle -> {FontFamily -> "Times"}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
       Thickness[0.004], 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       FrameTicksStyle -> Directive[25, 
         GrayLevel[0]], GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> {500}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}],FormBox[
      FormBox[
       StyleBox["\" Ad\\n\"", 22, Bold, StripOnInput -> False], 
       TraditionalForm], TraditionalForm]},
    "Legended",
    DisplayFunction->(GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ),
    Editable->True,
    InterpretationFunction->(RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]}], "}"}]], "Output",
 CellChangeTimes->{{3.8402087943857527`*^9, 3.840208874502217*^9}, 
   3.840208907699273*^9, {3.840208938817314*^9, 3.8402089662926397`*^9}, 
   3.840208999636104*^9, {3.840209039065221*^9, 3.8402090541097217`*^9}, 
   3.8402091075077076`*^9, 3.840209185536828*^9, 3.8402092832946343`*^9, 
   3.8402094303401566`*^9, {3.8402094701303296`*^9, 3.8402095095215044`*^9}, 
   3.840209738664837*^9, 3.840209917760785*^9, 3.8405571571878147`*^9, 
   3.840557212358683*^9, 3.840557648871916*^9, {3.840557699912783*^9, 
   3.8405577320904083`*^9}, {3.840557796075451*^9, 3.8405578322718916`*^9}, {
   3.840557936379157*^9, 3.840557947609147*^9}, 3.8405584010377893`*^9, 
   3.840559872987736*^9, {3.840559953837962*^9, 3.8405599782849164`*^9}, 
   3.8405600104415145`*^9, {3.8405605817682805`*^9, 3.840560618005868*^9}, 
   3.840560658015097*^9, 3.8405607433599844`*^9, {3.8405607825701084`*^9, 
   3.84056085113509*^9}, {3.8405609310559044`*^9, 3.8405609399069157`*^9}, {
   3.8405610330803385`*^9, 3.840561146512432*^9}, 3.8405622448575263`*^9, 
   3.840562306046056*^9, 3.8405626064707537`*^9, {3.840562822836877*^9, 
   3.840562846509075*^9}, {3.840562888609126*^9, 3.8405629426209383`*^9}, {
   3.8405631420529537`*^9, 3.8405631489792957`*^9}, 3.840563226628457*^9, 
   3.8405632611390896`*^9, 3.8405633824487486`*^9, 3.840563412879217*^9, 
   3.840563483383315*^9, 3.8405635371294312`*^9, {3.840563697970135*^9, 
   3.840563716560364*^9}, {3.8405639657342525`*^9, 3.8405639937073135`*^9}, 
   3.840564144465184*^9, 3.840564214654072*^9, 3.8405642623770423`*^9, {
   3.8405642975692687`*^9, 3.8405643308059363`*^9}, {3.840564376752177*^9, 
   3.840564440822036*^9}, 3.840564473447872*^9, 3.840737694868531*^9, 
   3.8449453225151052`*^9, {3.8449454709767084`*^9, 3.844945478318095*^9}, {
   3.844945569818131*^9, 3.844945586050886*^9}, 3.844964708557616*^9, {
   3.844965780495682*^9, 3.844965803691998*^9}, 3.8449661920432673`*^9, 
   3.8449662323193097`*^9, 3.844966281130165*^9, 3.8449664907837534`*^9, 
   3.8449683992728977`*^9, 3.8449685417711377`*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"43a6e364-4429-4736-aba1-d443e1c84184"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{638, 668},
WindowMargins->{{-7, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
Magnification:>1.4 Inherited,
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "Preprint.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 119, 3, 39, "Text",ExpressionUUID->"3f2048e1-a330-4ae8-b6ee-fa9307b20e45"],
Cell[CellGroupData[{
Cell[702, 27, 433, 10, 67, "Input",ExpressionUUID->"de37deb7-7626-43b7-8ac4-82899f29a343"],
Cell[1138, 39, 213, 3, 41, "Output",ExpressionUUID->"d1bc0aaf-984e-4ed7-9529-3d05b6619ff9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1388, 47, 227, 4, 70, "Subtitle",ExpressionUUID->"a433517c-f554-4ea8-a67e-eaed72c059ba"],
Cell[1618, 53, 2451, 41, 92, "Input",ExpressionUUID->"85be83ef-dee6-420b-b284-800acb342fd8"],
Cell[CellGroupData[{
Cell[4094, 98, 417, 6, 135, "Section",ExpressionUUID->"8339e549-a61a-4bef-b426-1d8f9a6db9b3"],
Cell[4514, 106, 199, 3, 41, "Input",ExpressionUUID->"f6703684-f41a-4cbb-ba18-db4410003c7e"],
Cell[CellGroupData[{
Cell[4738, 113, 394, 6, 36, "Subsubsection",ExpressionUUID->"3ebbc829-ac63-4d88-b00e-2626264f778e"],
Cell[5135, 121, 784, 13, 86, "Text",ExpressionUUID->"cee0b026-1f77-4e18-9234-d634864d569f"],
Cell[CellGroupData[{
Cell[5944, 138, 4197, 110, 223, "Input",ExpressionUUID->"b27594b2-3328-4515-a770-ff8cf15cf958"],
Cell[10144, 250, 1703, 40, 75, "Output",ExpressionUUID->"5cc72e61-8a37-4fd7-9b84-c97c5c53783b"]
}, Open  ]],
Cell[11862, 293, 668, 11, 86, "Text",ExpressionUUID->"2251075d-d5de-49ef-bdae-29a0f5988bc4"],
Cell[CellGroupData[{
Cell[12555, 308, 2487, 57, 92, "Input",ExpressionUUID->"6c56d9b5-ff63-4ade-acb0-ddb5a27f4c02"],
Cell[15045, 367, 2089, 48, 86, "Output",ExpressionUUID->"7e3fba42-c9a3-4abf-ba3d-2dee47f246c8"],
Cell[17137, 417, 1719, 38, 79, "Output",ExpressionUUID->"5337e15a-07c5-432b-933c-468f7facc6ac"]
}, Open  ]],
Cell[18871, 458, 673, 11, 63, "Text",ExpressionUUID->"1f7f02c7-2bdf-4345-bfcb-5176b8813e31"],
Cell[CellGroupData[{
Cell[19569, 473, 4872, 101, 210, "Input",ExpressionUUID->"82f29254-105e-4d43-a7bb-4589b92ba9fe"],
Cell[24444, 576, 2476, 56, 82, "Output",ExpressionUUID->"bb6110d6-91fa-47a2-b3e6-15ab737d7f76"],
Cell[26923, 634, 1942, 42, 84, "Output",ExpressionUUID->"1e5d0f8e-faac-449d-b378-469d4797daf3"]
}, Open  ]],
Cell[28880, 679, 673, 11, 86, "Text",ExpressionUUID->"51773d8e-ed7f-4ebd-8421-d1e8c1433dd1"],
Cell[29556, 692, 396, 8, 39, "Text",ExpressionUUID->"868df680-48c7-40dc-8e13-99cbca882402"],
Cell[CellGroupData[{
Cell[29977, 704, 1415, 33, 92, "Input",ExpressionUUID->"885c8a21-7b55-471d-ba00-ead600613c39"],
Cell[31395, 739, 1843, 45, 81, "Output",ExpressionUUID->"ad04d51a-cc29-47cc-8115-b3827ef0f956"],
Cell[33241, 786, 1126, 23, 65, "Output",ExpressionUUID->"fd93ad65-1120-4298-b85f-8eaaf911b561"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34416, 815, 287, 4, 26, "Subsubsection",ExpressionUUID->"74e2ad52-b3ff-4ee1-b099-cb44eae2345d"],
Cell[CellGroupData[{
Cell[34728, 823, 1159, 23, 67, "Input",ExpressionUUID->"865403cb-3294-412f-89b4-03418b4fce05"],
Cell[35890, 848, 757, 18, 70, "Output",ExpressionUUID->"14c9c3e3-a5a4-4d69-9b53-72b4190db019"],
Cell[36650, 868, 869, 22, 70, "Output",ExpressionUUID->"e44a4934-4a23-4c3e-b2da-bc971044a0d2"]
}, Open  ]],
Cell[37534, 893, 805, 18, 63, "Text",ExpressionUUID->"48905c9e-1437-480a-a669-046d84cba7c5"],
Cell[38342, 913, 635, 14, 39, "Text",ExpressionUUID->"41655097-1be6-40db-a179-aac69eeabe24"]
}, Closed]],
Cell[CellGroupData[{
Cell[39014, 932, 363, 7, 47, "Subsubsection",ExpressionUUID->"0fe2acce-8a85-4b6e-a315-83eea93ccf3a"],
Cell[CellGroupData[{
Cell[39402, 943, 1243, 19, 41, "Input",ExpressionUUID->"f6e18b61-0dca-45de-b934-eb117728eb8e"],
Cell[40648, 964, 4550, 139, 263, "Output",ExpressionUUID->"c0f78e60-322f-4548-bd0a-1176a7531857"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45235, 1108, 505, 9, 41, "Input",ExpressionUUID->"dd19bc0a-bd97-4a2e-90d5-7782d45fdfe4"],
Cell[45743, 1119, 3773, 109, 70, "Output",ExpressionUUID->"a0b5c974-5f8c-4be1-aacc-ed3ab5379200"]
}, Open  ]],
Cell[49531, 1231, 503, 9, 39, "Text",ExpressionUUID->"7f0c2200-0553-4b67-a494-c35cbd9bfaea"],
Cell[CellGroupData[{
Cell[50059, 1244, 375, 8, 41, "Input",ExpressionUUID->"c87db696-04c5-4ca6-b35f-ea9031104adb"],
Cell[50437, 1254, 1556, 45, 70, "Output",ExpressionUUID->"83f562ba-8223-485f-a3fd-e42d8fdb22f9"]
}, Open  ]],
Cell[52008, 1302, 597, 10, 63, "Text",ExpressionUUID->"30791d99-5caf-4ac6-8203-6577e4585885"],
Cell[52608, 1314, 343, 7, 39, "Text",ExpressionUUID->"fe89cd92-ca04-4900-a937-d08e9e99ea96"],
Cell[CellGroupData[{
Cell[52976, 1325, 463, 12, 41, "Input",ExpressionUUID->"9195e0b1-cb56-4518-9f61-c36b36ae9f80"],
Cell[53442, 1339, 1026, 30, 62, "Output",ExpressionUUID->"58e57a75-6833-4145-942c-82065dc31446"]
}, Open  ]],
Cell[54483, 1372, 539, 10, 63, "Text",ExpressionUUID->"040c1850-bc86-4d71-8314-bc2dad28feee"],
Cell[CellGroupData[{
Cell[55047, 1386, 283, 5, 41, "Input",ExpressionUUID->"8bd4d828-2a2c-41d5-a0cf-3c35780a0d31"],
Cell[55333, 1393, 322, 8, 41, "Output",ExpressionUUID->"2cdbf8fc-1637-460b-a743-c1e0e5f1c240"]
}, Open  ]],
Cell[55670, 1404, 1207, 25, 132, "Text",ExpressionUUID->"083ab68a-95f6-4477-9708-f781d792feab"],
Cell[56880, 1431, 566, 10, 86, "Text",ExpressionUUID->"63379602-4ce2-43f2-bc46-53ae78521334"]
}, Closed]],
Cell[CellGroupData[{
Cell[57483, 1446, 451, 9, 47, "Subsubsection",ExpressionUUID->"74e2a222-c776-4787-ac90-c0ce9cfa9513"],
Cell[57937, 1457, 278, 6, 39, "Text",ExpressionUUID->"b6694f68-5f92-44d1-8d1b-e64ea9ac20f6"],
Cell[CellGroupData[{
Cell[58240, 1467, 235, 4, 41, "Input",ExpressionUUID->"8ef732bd-85cb-446e-a7f5-ddf2aec74a77"],
Cell[58478, 1473, 557, 15, 66, "Output",ExpressionUUID->"92269618-d152-4d09-83db-e78c895b8b36"]
}, Open  ]],
Cell[59050, 1491, 521, 10, 63, "Text",ExpressionUUID->"57b21d77-b8d9-4e30-95d7-d008271a1e57"],
Cell[CellGroupData[{
Cell[59596, 1505, 1012, 21, 92, "Input",ExpressionUUID->"341ebc5c-9ee4-40ee-9a09-fb54e34dd28a"],
Cell[60611, 1528, 350, 5, 41, "Output",ExpressionUUID->"ee35e12e-cc4e-4d62-822d-76b9791fea21"]
}, Open  ]],
Cell[60976, 1536, 185, 3, 39, "Text",ExpressionUUID->"8a0e952d-db16-470f-81d6-ba07185cf988"],
Cell[CellGroupData[{
Cell[61186, 1543, 1139, 22, 46, "Input",ExpressionUUID->"49ecb16e-6066-4ef7-9cfa-aad45f9a87b9"],
Cell[62328, 1567, 6190, 177, 310, "Output",ExpressionUUID->"6a2a4d41-9063-450d-b10e-586d18261a16"]
}, Open  ]],
Cell[68533, 1747, 421, 8, 39, "Text",ExpressionUUID->"d6628e93-9b95-4723-b10e-8654ea9d5959"],
Cell[CellGroupData[{
Cell[68979, 1759, 670, 15, 92, "Input",ExpressionUUID->"b495ae07-b582-422d-801e-a90de1868dea"],
Cell[69652, 1776, 233, 3, 41, "Output",ExpressionUUID->"dd55b333-6d78-4bb3-a6db-bfcd131f1a6d"]
}, Open  ]],
Cell[69900, 1782, 651, 11, 63, "Text",ExpressionUUID->"c740681e-cf82-47e5-91a7-e7a3c012d834"],
Cell[70554, 1795, 258, 4, 39, "Text",ExpressionUUID->"80f5c64f-6d66-40ec-b0de-08dc0da31ea2"],
Cell[70815, 1801, 673, 12, 63, "Text",ExpressionUUID->"7643025b-c049-4a17-be9c-4af9f64d3160"],
Cell[CellGroupData[{
Cell[71513, 1817, 808, 16, 41, "Input",ExpressionUUID->"efb92fb1-1aec-4c64-9a11-756d08a0386b"],
Cell[72324, 1835, 2639, 76, 165, "Output",ExpressionUUID->"c8cacd6d-1f51-4e7c-a9a0-7ebe9974b203"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75000, 1916, 5455, 131, 264, "Input",ExpressionUUID->"5a15040c-b22f-44b8-98c0-7d06e7c097a0"],
Cell[80458, 2049, 77044, 1517, 500, "Output",ExpressionUUID->"c5d5967f-fce0-4ba1-b0fc-bc0c0227ca7e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[157551, 3572, 491, 8, 26, "Subsubsection",ExpressionUUID->"56ac3ecf-0453-4e4f-a8ea-4f7885edeca7"],
Cell[158045, 3582, 317, 7, 39, "Text",ExpressionUUID->"b71310fa-47b9-44db-a4f2-fdef5ec1c6a7"],
Cell[CellGroupData[{
Cell[158387, 3593, 807, 12, 41, "Input",ExpressionUUID->"6d1325ce-593a-48f2-98b2-9532f80e6da3"],
Cell[159197, 3607, 1532, 48, 90, "Output",ExpressionUUID->"74ace51e-6f0d-4041-b616-f05c22a7d7eb"]
}, Open  ]],
Cell[160744, 3658, 528, 10, 63, "Text",ExpressionUUID->"3661432a-e614-4446-bbdf-72d7b7d7bbbd"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[161321, 3674, 423, 6, 99, "Section",ExpressionUUID->"d7ff5b79-c4e9-4160-bc58-e2ff5db2174c"],
Cell[161747, 3682, 199, 3, 41, "Input",ExpressionUUID->"38333c1b-dc5a-42ce-a106-7515c5802c02"],
Cell[CellGroupData[{
Cell[161971, 3689, 444, 6, 36, "Subsubsection",ExpressionUUID->"d64f97bc-9a70-47d5-813c-a1c296d9f00f"],
Cell[162418, 3697, 728, 12, 63, "Text",ExpressionUUID->"d92db8b4-0eb2-4ccd-826f-465f6aaafe80"],
Cell[CellGroupData[{
Cell[163171, 3713, 3762, 99, 173, "Input",ExpressionUUID->"817691c6-ca38-4c28-b3d3-024cc6ddddef"],
Cell[166936, 3814, 1430, 37, 75, "Output",ExpressionUUID->"523ffc19-8cde-4086-b2bd-d58ad919e7e8"]
}, Open  ]],
Cell[168381, 3854, 544, 10, 63, "Text",ExpressionUUID->"52239470-3bad-456b-a447-6b1c2f6ac5cc"],
Cell[CellGroupData[{
Cell[168950, 3868, 2445, 57, 92, "Input",ExpressionUUID->"ebc9bc83-e02e-4ced-9ecf-ba28f20458cb"],
Cell[171398, 3927, 1691, 41, 110, "Output",ExpressionUUID->"7c8fbab3-4b30-417d-bf52-69df1a05bbab"],
Cell[173092, 3970, 1428, 35, 106, "Output",ExpressionUUID->"1803ee89-4062-4c92-bee2-49aa73136090"]
}, Open  ]],
Cell[174535, 4008, 673, 11, 63, "Text",ExpressionUUID->"9a4fad16-4886-4b98-9719-bfd93fa8dd28"],
Cell[CellGroupData[{
Cell[175233, 4023, 3863, 81, 171, "Input",ExpressionUUID->"16a4f37d-cc66-477f-974f-b6a58180704a"],
Cell[179099, 4106, 1848, 44, 112, "Output",ExpressionUUID->"68269cc3-3fcf-4825-a4de-fd894aaf8fb5"],
Cell[180950, 4152, 1316, 28, 106, "Output",ExpressionUUID->"8b25b237-da68-479b-ae5e-92dee3b2b660"]
}, Open  ]],
Cell[182281, 4183, 591, 10, 63, "Text",ExpressionUUID->"b848f17c-ee20-429b-acf6-01946e865880"],
Cell[CellGroupData[{
Cell[182897, 4197, 1438, 33, 92, "Input",ExpressionUUID->"32739ff3-926e-46c4-a502-ea36af6febd4"],
Cell[184338, 4232, 1483, 36, 112, "Output",ExpressionUUID->"d5f8c037-bd77-4707-be57-9e977622ece4"],
Cell[185824, 4270, 896, 18, 67, "Output",ExpressionUUID->"28de2892-a589-4315-9c7e-1ae422295386"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[186769, 4294, 337, 5, 26, "Subsubsection",ExpressionUUID->"15ca7b6b-4abc-4edd-89dd-b918be2f3710"],
Cell[CellGroupData[{
Cell[187131, 4303, 912, 16, 67, "Input",ExpressionUUID->"7744aafb-34f1-4cfe-884b-4bdf1a8db257"],
Cell[188046, 4321, 546, 15, 74, "Output",ExpressionUUID->"16ab5423-2658-486f-a016-b55fe8921e54"],
Cell[188595, 4338, 681, 20, 81, "Output",ExpressionUUID->"3ef173cd-b1b4-465e-a7f7-c72950dc91ed"]
}, Open  ]],
Cell[189291, 4361, 795, 20, 39, "Text",ExpressionUUID->"2e1ea1e4-b7de-461f-9dcf-c4530fc07346"]
}, Closed]],
Cell[CellGroupData[{
Cell[190123, 4386, 415, 7, 26, "Subsubsection",ExpressionUUID->"b5bcc4d3-6dae-4e66-913c-7d7af9530db2"],
Cell[CellGroupData[{
Cell[190563, 4397, 1270, 20, 41, "Input",ExpressionUUID->"90848e76-0424-416f-9aa5-51530d31daf1"],
Cell[191836, 4419, 4385, 127, 265, "Output",ExpressionUUID->"b46ae39c-0bd6-4628-9579-cb34b6ec34af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196258, 4551, 580, 11, 41, "Input",ExpressionUUID->"6e0898da-0581-4d4c-a1cf-0a5b85887e14"],
Cell[196841, 4564, 376, 5, 41, "Output",ExpressionUUID->"b90c5b77-c9f3-484f-b75a-3036497167d5"]
}, Open  ]],
Cell[197232, 4572, 645, 13, 39, "Text",ExpressionUUID->"cbbbc5e4-0cd1-4e8d-b031-59dd0c1777c9"]
}, Closed]],
Cell[CellGroupData[{
Cell[197914, 4590, 539, 8, 26, "Subsubsection",ExpressionUUID->"35e80607-04c2-48ef-94c8-da6cda04703c"],
Cell[198456, 4600, 275, 6, 39, "Text",ExpressionUUID->"f35a1d20-9afc-4bbf-a252-16fa75bfe488"],
Cell[CellGroupData[{
Cell[198756, 4610, 965, 17, 67, "Input",ExpressionUUID->"b96ced7a-d61c-4e53-9a2a-816669f64f80"],
Cell[199724, 4629, 1378, 42, 116, "Output",ExpressionUUID->"fce580bc-3a2d-4888-8803-b50061b0ca6f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201139, 4676, 993, 24, 117, "Input",ExpressionUUID->"f0b1eeee-25ad-4d37-8964-5789af8ed38b"],
Cell[202135, 4702, 467, 7, 41, "Output",ExpressionUUID->"741f29df-ad90-468d-b88c-3f93694b62a1"],
Cell[202605, 4711, 451, 6, 41, "Output",ExpressionUUID->"770fdb74-ac4c-43df-bd45-8f328de68cd5"]
}, Open  ]],
Cell[203071, 4720, 821, 15, 63, "Text",ExpressionUUID->"9afe74c5-e4d4-414b-bbd0-eba044b30b21"],
Cell[203895, 4737, 549, 10, 63, "Text",ExpressionUUID->"96dab82c-4d00-4c04-8aaa-f1520dea301d"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[204493, 4753, 500, 7, 99, "Section",ExpressionUUID->"4378eacf-defd-4bd9-84a4-11a9f19bafdc"],
Cell[204996, 4762, 199, 3, 41, "Input",ExpressionUUID->"a1f4172a-8b71-44be-b407-9885a9e549f9"],
Cell[CellGroupData[{
Cell[205220, 4769, 441, 6, 36, "Subsubsection",ExpressionUUID->"9ad30ae3-023e-42c3-82f7-93a33d5cd2f5"],
Cell[205664, 4777, 899, 14, 109, "Text",ExpressionUUID->"cab4411e-ab1f-4622-a317-f91b3e023e2d"],
Cell[CellGroupData[{
Cell[206588, 4795, 3910, 104, 198, "Input",ExpressionUUID->"08bc4639-0467-4935-832f-99f6dc437dbe"],
Cell[210501, 4901, 1503, 38, 70, "Output",ExpressionUUID->"dd1e283b-5fc9-4b77-a139-04523ed6d3ed"]
}, Open  ]],
Cell[212019, 4942, 544, 10, 63, "Text",ExpressionUUID->"e991cd86-41c3-4b63-acd2-ef684e8f803f"],
Cell[CellGroupData[{
Cell[212588, 4956, 2207, 52, 92, "Input",ExpressionUUID->"848cec35-acef-42f9-8e4e-eafe8844686d"],
Cell[214798, 5010, 1414, 34, 70, "Output",ExpressionUUID->"daac0413-05b7-4303-8c7a-fa0453bc3815"],
Cell[216215, 5046, 1375, 32, 70, "Output",ExpressionUUID->"77074133-4088-4aa9-9af5-e9ecb983ba36"]
}, Open  ]],
Cell[217605, 5081, 673, 11, 63, "Text",ExpressionUUID->"46fc7494-f096-442f-b4f4-d6212fda1e73"],
Cell[CellGroupData[{
Cell[218303, 5096, 3657, 78, 171, "Input",ExpressionUUID->"7b0dff14-b4c6-493f-a667-527995c2f6e8"],
Cell[221963, 5176, 1562, 35, 70, "Output",ExpressionUUID->"a4ed6177-3bc6-4432-9b07-5d62ddee9a15"],
Cell[223528, 5213, 1159, 23, 70, "Output",ExpressionUUID->"94158ba7-6724-45c7-b67e-70880af48d5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224724, 5241, 352, 7, 36, "Subsubsubsection",ExpressionUUID->"dcd7c124-94cd-4797-b158-5b5e96269f53"],
Cell[CellGroupData[{
Cell[225101, 5252, 2375, 66, 160, "Input",ExpressionUUID->"e4045351-3b81-4d66-926d-78b9646727bb"],
Cell[227479, 5320, 4858, 125, 70, "Output",ExpressionUUID->"5f54d472-0e64-4b79-9c78-e0af7dc8ba5a"]
}, Open  ]],
Cell[232352, 5448, 571, 10, 63, "Text",ExpressionUUID->"1a3bd1e1-5675-4826-b078-7b329977f1fc"],
Cell[CellGroupData[{
Cell[232948, 5462, 1367, 32, 92, "Input",ExpressionUUID->"8e04afcc-0aa2-4c47-8141-84916abe08a2"],
Cell[234318, 5496, 1368, 33, 70, "Output",ExpressionUUID->"d009250f-305b-44c0-be37-280ae8d640de"],
Cell[235689, 5531, 811, 15, 70, "Output",ExpressionUUID->"b0ea706c-591a-4101-bd9b-e20b9c58b5a9"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[236561, 5553, 340, 5, 26, "Subsubsection",ExpressionUUID->"a8b7c0a0-3d32-4d90-a231-3e15a5e2d7b0"],
Cell[CellGroupData[{
Cell[236926, 5562, 1466, 35, 123, "Input",ExpressionUUID->"1cba30c8-a29f-4f85-9c9e-3a8c883a4e8d"],
Cell[238395, 5599, 526, 13, 70, "Output",ExpressionUUID->"069f02fd-8f3d-461e-bca1-cab47b6b0b57"],
Cell[238924, 5614, 613, 17, 70, "Output",ExpressionUUID->"0231bd9b-e107-47d0-8099-7ae772c76193"]
}, Open  ]],
Cell[239552, 5634, 476, 9, 63, "Text",ExpressionUUID->"96d7147e-955d-4411-b01e-11fd3a688747"],
Cell[240031, 5645, 507, 13, 39, "Text",ExpressionUUID->"9436439d-2246-4463-9cba-24cf225804d1"]
}, Closed]],
Cell[CellGroupData[{
Cell[240575, 5663, 413, 7, 26, "Subsubsection",ExpressionUUID->"1d33ca09-a76a-4a40-bfde-a60b6acbb261"],
Cell[CellGroupData[{
Cell[241013, 5674, 1218, 19, 41, "Input",ExpressionUUID->"654db261-2074-4acb-8797-0434f967aa1d"],
Cell[242234, 5695, 2480, 73, 144, "Output",ExpressionUUID->"d4cbbe74-b45f-4355-b442-1003ec843d1a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[244751, 5773, 1261, 33, 46, "Input",ExpressionUUID->"37d92b4f-ee9d-42f6-9af2-c3cee7cdc1e8"],
Cell[246015, 5808, 1626, 47, 84, "Output",ExpressionUUID->"ab39ce02-cc52-46c3-b9a1-3ca557b21dc5"]
}, Open  ]],
Cell[247656, 5858, 346, 7, 39, "Text",ExpressionUUID->"74d83c06-8c17-4867-89ae-0e099d1cd289"],
Cell[CellGroupData[{
Cell[248027, 5869, 1083, 19, 41, "Input",ExpressionUUID->"9f410a57-87f3-48bc-ab75-6ce77bfa833b"],
Cell[249113, 5890, 1312, 38, 69, "Output",ExpressionUUID->"a68b3043-a74d-481e-9ece-e2a3f446eec5"]
}, Open  ]],
Cell[250440, 5931, 335, 7, 39, "Text",ExpressionUUID->"961a221b-155c-4d78-b1bb-2cdbb8d67e73"],
Cell[CellGroupData[{
Cell[250800, 5942, 828, 20, 41, "Input",ExpressionUUID->"9a8212ea-7073-4aa9-b673-81e9e75f5203"],
Cell[251631, 5964, 597, 16, 60, "Output",ExpressionUUID->"35a4d9b8-2794-4516-834c-92747988d271"]
}, Open  ]],
Cell[252243, 5983, 359, 7, 63, "Text",ExpressionUUID->"e1f08b8b-7c61-4f2c-93f7-a0ff89d534b3"],
Cell[252605, 5992, 526, 9, 63, "Text",ExpressionUUID->"bc119c3f-e36a-45e3-b81c-71a7e8a95fd1"],
Cell[253134, 6003, 519, 10, 63, "Text",ExpressionUUID->"bfdecca9-5475-4a2d-9945-c4b147735601"],
Cell[CellGroupData[{
Cell[253678, 6017, 497, 10, 41, "Input",ExpressionUUID->"9a58a91a-25bf-4029-bf93-cb24088b4d79"],
Cell[254178, 6029, 8044, 235, 1109, "Output",ExpressionUUID->"ca997acd-168f-4933-8743-2cf150a8481e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[262259, 6269, 770, 17, 67, "Input",ExpressionUUID->"87ccd942-2004-487a-bf14-ce4747353e16"],
Cell[263032, 6288, 1108, 34, 100, "Output",ExpressionUUID->"b09385b5-2465-4c66-b8d5-d927435040f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264177, 6327, 765, 23, 80, "Input",ExpressionUUID->"f14aaa02-a21c-4c35-99e1-9581da58c95e"],
Cell[264945, 6352, 663, 21, 60, "Output",ExpressionUUID->"1c2ef5cf-d0fc-4608-ac18-3932cd03d6bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[265645, 6378, 674, 15, 41, "Input",ExpressionUUID->"cfa66477-7416-4d66-b5c9-c832e99ca06e"],
Cell[266322, 6395, 370, 8, 41, "Output",ExpressionUUID->"c15d864b-517b-43bd-a1d9-b5f922672f8e"]
}, Open  ]],
Cell[266707, 6406, 471, 9, 109, "Text",ExpressionUUID->"1e3c3ca2-b864-42d5-974e-cb19b8d75379"]
}, Open  ]],
Cell[CellGroupData[{
Cell[267215, 6420, 497, 9, 57, "Subsubsection",ExpressionUUID->"fe2a04ae-5791-47ef-a84a-c516c6441850"],
Cell[267715, 6431, 491, 9, 63, "Text",ExpressionUUID->"7f4166d4-b0e7-497e-a19b-0dfe99db5ef3"],
Cell[CellGroupData[{
Cell[268231, 6444, 1022, 22, 92, "Input",ExpressionUUID->"b5007838-fb74-41e1-9f87-6eb59928947d"],
Cell[269256, 6468, 1577, 50, 63, "Output",ExpressionUUID->"25e1d2a2-36ee-4672-98aa-5e9b691d7ff4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[270870, 6523, 1164, 23, 46, "Input",ExpressionUUID->"edae4c81-98fb-4170-8baf-a6c26157f69e"],
Cell[272037, 6548, 3257, 99, 168, "Output",ExpressionUUID->"7f3d682c-a825-4929-8acb-be245efea358"]
}, Open  ]],
Cell[275309, 6650, 348, 7, 39, "Text",ExpressionUUID->"173c5d03-7769-47de-bc8e-c7b642ddbad2"],
Cell[CellGroupData[{
Cell[275682, 6661, 720, 17, 92, "Input",ExpressionUUID->"4691977a-e34b-445b-9d91-6cb242f81779"],
Cell[276405, 6680, 1678, 54, 72, "Output",ExpressionUUID->"8c594ec1-e0f7-4a41-a57b-0450551943bc"]
}, Open  ]],
Cell[278098, 6737, 729, 12, 63, "Text",ExpressionUUID->"a0b156c3-68fd-4c4a-9f43-fe754bb22afc"],
Cell[278830, 6751, 258, 4, 39, "Text",ExpressionUUID->"97538cf5-cd1e-4a81-b975-5663f45f61ca"],
Cell[279091, 6757, 603, 10, 63, "Text",ExpressionUUID->"d2a25e4c-e5a6-4e03-96f3-c9a8b3d2af10"],
Cell[279697, 6769, 808, 17, 41, "Input",ExpressionUUID->"5f1ee64e-3847-4d35-9c17-7c1e8dc7d360"],
Cell[CellGroupData[{
Cell[280530, 6790, 5749, 143, 294, "Input",ExpressionUUID->"22040dfe-f604-4cf5-a887-798c75943143"],
Cell[286282, 6935, 76948, 1515, 500, "Output",ExpressionUUID->"2d3de93f-aea2-451b-b49c-50ddd0b9a27c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[363279, 8456, 541, 8, 26, "Subsubsection",ExpressionUUID->"9a1e0050-330b-4829-8b75-904554714e4e"],
Cell[363823, 8466, 275, 6, 39, "Text",ExpressionUUID->"1e932f9b-de9c-47b8-b721-2a28605fd63a"],
Cell[CellGroupData[{
Cell[364123, 8476, 1115, 22, 67, "Input",ExpressionUUID->"dbdb16eb-db63-44fa-b9da-e4d4c5d1fb9f"],
Cell[365241, 8500, 1099, 34, 96, "Output",ExpressionUUID->"6bfec464-55d4-4725-99c3-882e965d6c3e"]
}, Open  ]],
Cell[366355, 8537, 529, 12, 63, "Text",ExpressionUUID->"2a8eee47-e26e-4e61-bcc2-65b9868530f7"],
Cell[CellGroupData[{
Cell[366909, 8553, 955, 23, 117, "Input",ExpressionUUID->"0bb3208e-5af5-4e8b-a557-f46c5be4feaa"],
Cell[367867, 8578, 2399, 73, 128, "Output",ExpressionUUID->"ad71f2ba-9ad3-45ef-9dbb-d4f9a7dc31ab"],
Cell[370269, 8653, 1857, 57, 108, "Output",ExpressionUUID->"9628f40a-49fc-49bf-98dd-25cc3a375b78"],
Cell[372129, 8712, 454, 7, 41, "Output",ExpressionUUID->"dffdd323-792d-423e-ba98-83822cab76c9"],
Cell[372586, 8721, 456, 7, 41, "Output",ExpressionUUID->"e2acd11e-fe95-490a-983e-4d56ff8ab6b6"]
}, Open  ]],
Cell[373057, 8731, 728, 12, 109, "Text",ExpressionUUID->"51eb8cd6-e68d-4061-b7d9-6a83afd2dfb7"],
Cell[CellGroupData[{
Cell[373810, 8747, 501, 9, 41, "Input",ExpressionUUID->"8e19d870-4a56-4f8d-97f0-ad604fe63d4c"],
Cell[374314, 8758, 1342, 40, 86, "Output",ExpressionUUID->"2212dae8-d190-481e-bca7-dfc6390f5321"]
}, Open  ]],
Cell[375671, 8801, 592, 10, 63, "Text",ExpressionUUID->"c875d813-5cd6-4488-ae15-a458080f794b"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[376312, 8817, 373, 6, 99, "Section",ExpressionUUID->"16346496-a787-4b87-bd4e-2f260596ec56"],
Cell[376688, 8825, 199, 3, 41, "Input",ExpressionUUID->"a4a5fd6e-6a56-40aa-a338-632b95775732"],
Cell[CellGroupData[{
Cell[376912, 8832, 442, 6, 36, "Subsubsection",ExpressionUUID->"ec7c3265-99b5-40b3-955d-940ab57786ab"],
Cell[377357, 8840, 416, 6, 39, "Text",ExpressionUUID->"cc58651c-9334-46ab-8394-65cf4a55198e"],
Cell[CellGroupData[{
Cell[377798, 8850, 3663, 98, 173, "Input",ExpressionUUID->"269adec3-0804-44e3-9bcc-1ca71755f339"],
Cell[381464, 8950, 1740, 42, 75, "Output",ExpressionUUID->"7f9a85d5-4046-4704-a776-c2c095e8695e"]
}, Open  ]],
Cell[383219, 8995, 544, 10, 63, "Text",ExpressionUUID->"3f68c915-08aa-4863-9c3f-a5b3502133bd"],
Cell[CellGroupData[{
Cell[383788, 9009, 2399, 56, 92, "Input",ExpressionUUID->"c7ff7298-e82f-47f0-90b8-0f1e40759a1b"],
Cell[386190, 9067, 1835, 40, 113, "Output",ExpressionUUID->"05d812f4-a7de-4b47-a511-cb96580a21f6"],
Cell[388028, 9109, 1696, 38, 106, "Output",ExpressionUUID->"c72c74fc-5bf6-40d8-8b84-4054a7a5f7ef"]
}, Open  ]],
Cell[389739, 9150, 717, 12, 86, "Text",ExpressionUUID->"3a913887-8fd8-439d-95e7-28c129c79fe7"],
Cell[CellGroupData[{
Cell[390481, 9166, 3663, 80, 171, "Input",ExpressionUUID->"a79bac88-6a6e-48e0-872b-019a995410f0"],
Cell[394147, 9248, 2050, 49, 112, "Output",ExpressionUUID->"2f6494d2-92fa-468a-8cde-c31a999e496e"],
Cell[396200, 9299, 1448, 33, 84, "Output",ExpressionUUID->"1f7a588d-87f6-460f-aff8-5f9c0623fc78"]
}, Open  ]],
Cell[397663, 9335, 591, 10, 63, "Text",ExpressionUUID->"63a8061e-fd9d-4bb3-aa0a-a783572a4eeb"],
Cell[CellGroupData[{
Cell[398279, 9349, 1205, 31, 92, "Input",ExpressionUUID->"a844e2bf-e030-4381-96dc-475e4ff850db"],
Cell[399487, 9382, 1659, 41, 112, "Output",ExpressionUUID->"29883c21-8ce2-43f0-928d-3219e34f2093"],
Cell[401149, 9425, 985, 21, 67, "Output",ExpressionUUID->"0a126919-f289-40f3-ae6a-463aa6f78d3a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[402183, 9452, 338, 5, 26, "Subsubsection",ExpressionUUID->"a81dec3d-af14-4eef-b5c2-f23c62d97577"],
Cell[CellGroupData[{
Cell[402546, 9461, 1339, 34, 123, "Input",ExpressionUUID->"9bd773d7-3e17-47e0-848f-cdf55228ccf0"],
Cell[403888, 9497, 502, 13, 71, "Output",ExpressionUUID->"3fddebc5-e142-4cb0-8cf7-ec02ce27daed"],
Cell[404393, 9512, 589, 17, 78, "Output",ExpressionUUID->"1a622938-51b1-475e-bb4d-d842fe803e79"]
}, Open  ]],
Cell[404997, 9532, 476, 9, 63, "Text",ExpressionUUID->"11213e4d-f8c6-4296-b6b5-6e73de66c9dd"],
Cell[405476, 9543, 670, 15, 63, "Text",ExpressionUUID->"89bae1f5-d0c8-4cb3-a078-39ae09be6a93"]
}, Closed]],
Cell[CellGroupData[{
Cell[406183, 9563, 411, 7, 47, "Subsubsection",ExpressionUUID->"6c57ebcb-dc85-49fb-a1aa-c8d30ff04c79"],
Cell[CellGroupData[{
Cell[406619, 9574, 1272, 21, 41, "Input",ExpressionUUID->"0ec49ffb-69b9-4354-8376-09e2d5487a4f"],
Cell[407894, 9597, 4650, 132, 331, "Output",ExpressionUUID->"956ae98e-bc8f-4622-92da-65c326a44960"]
}, Open  ]],
Cell[412559, 9732, 685, 16, 44, "Text",ExpressionUUID->"a1f3a16f-ffa1-4e2a-8b8e-46aa676f0fbd"],
Cell[CellGroupData[{
Cell[413269, 9752, 252, 6, 41, "Input",ExpressionUUID->"f5e8b412-80ca-4700-96eb-348b3c551309"],
Cell[413524, 9760, 3139, 95, 234, "Output",ExpressionUUID->"7699d386-997f-48c4-9bac-023bf440b991"]
}, Open  ]],
Cell[CellGroupData[{
Cell[416700, 9860, 863, 19, 67, "Input",ExpressionUUID->"20e63737-d488-4c67-bded-3adbd8c6c570"],
Cell[417566, 9881, 7551, 200, 239, "Output",ExpressionUUID->"90431863-1b8b-4e65-8966-511e92303ad2"]
}, Open  ]],
Cell[425132, 10084, 419, 8, 39, "Text",ExpressionUUID->"b0bc8c19-8f15-4c90-be43-77a7a9dfaa10"],
Cell[CellGroupData[{
Cell[425576, 10096, 661, 15, 41, "Input",ExpressionUUID->"37d291df-e62f-4f18-91c8-4bf0388ff618"],
Cell[426240, 10113, 5545, 152, 202, "Output",ExpressionUUID->"76d6120d-f475-44ca-b1ba-83b26200c421"]
}, Open  ]],
Cell[431800, 10268, 340, 7, 39, "Text",ExpressionUUID->"03b3db4d-4e5a-445f-a265-0c009639e965"],
Cell[432143, 10277, 564, 16, 39, "Text",ExpressionUUID->"4e587fb5-1dd8-4723-9f17-73e904ebe161"],
Cell[CellGroupData[{
Cell[432732, 10297, 437, 10, 41, "Input",ExpressionUUID->"af5f0fe1-e781-4280-aa34-572a98187c30"],
Cell[433172, 10309, 773, 23, 41, "Output",ExpressionUUID->"011c004d-4e7b-4343-854f-0faae51c82c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[433982, 10337, 268, 6, 41, "Input",ExpressionUUID->"8d13bbb0-a043-4edb-adcd-7e6e0ec2d45f"],
Cell[434253, 10345, 814, 25, 60, "Output",ExpressionUUID->"7915bed4-855c-4f00-bc66-fa8553eefafb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[435104, 10375, 602, 16, 60, "Input",ExpressionUUID->"9b902620-3fe2-4528-bc25-24030b547d3b"],
Cell[435709, 10393, 678, 18, 60, "Output",ExpressionUUID->"1284dd60-948e-4337-9758-795755b35f8b"]
}, Open  ]],
Cell[436402, 10414, 490, 9, 63, "Text",ExpressionUUID->"b194a8cd-acf4-44fe-a3ef-ac11a896d770"],
Cell[436895, 10425, 227, 5, 39, "Text",ExpressionUUID->"aa198fa3-b5e4-4218-952c-10a327ebe85d"],
Cell[437125, 10432, 451, 8, 63, "Text",ExpressionUUID->"a517b73d-d2bf-4f81-a74f-2bf3a352fe37"]
}, Closed]],
Cell[CellGroupData[{
Cell[437613, 10445, 497, 9, 47, "Subsubsection",ExpressionUUID->"9ed3376b-0dce-4d26-b408-009d9a7609d3"],
Cell[CellGroupData[{
Cell[438135, 10458, 239, 5, 41, "Input",ExpressionUUID->"8fd7da1d-5429-420a-9409-d6b58ae28166"],
Cell[438377, 10465, 619, 17, 68, "Output",ExpressionUUID->"b7b46eb8-4c87-4bd2-889d-595b179909ad"]
}, Open  ]],
Cell[439011, 10485, 521, 10, 63, "Text",ExpressionUUID->"b58f3a2e-d880-45c9-a322-35f0813ed990"],
Cell[CellGroupData[{
Cell[439557, 10499, 1068, 23, 92, "Input",ExpressionUUID->"c6dcbb55-aa15-42dc-b7e7-cdc08eb8cbc7"],
Cell[440628, 10524, 384, 7, 41, "Output",ExpressionUUID->"102f21af-9c4d-4d95-a8b5-d9da1f02babf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[441049, 10536, 1232, 24, 46, "Input",ExpressionUUID->"18d77e13-d91a-447d-8207-cd3921755cba"],
Cell[442284, 10562, 5467, 153, 430, "Output",ExpressionUUID->"e3a7b0b3-49bc-49df-a9b5-9e8bc8d2a5d2"]
}, Open  ]],
Cell[447766, 10718, 348, 7, 39, "Text",ExpressionUUID->"7c2ee777-60f7-454c-bf56-ba693d761c64"],
Cell[CellGroupData[{
Cell[448139, 10729, 692, 16, 92, "Input",ExpressionUUID->"a83bee54-19f7-431f-804c-03de4a22a0b4"],
Cell[448834, 10747, 14199, 415, 529, "Output",ExpressionUUID->"c9523fc5-6572-4da2-948d-ec3f4953f8a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[463070, 11167, 331, 6, 41, "Input",ExpressionUUID->"3683d30c-a9fb-4d02-b2fc-5ee6eff1f92f"],
Cell[463404, 11175, 230, 4, 41, "Output",ExpressionUUID->"edfcbebb-b169-43a7-9be4-9806dcc5a849"]
}, Open  ]],
Cell[463649, 11182, 428, 6, 39, "Text",ExpressionUUID->"34af0427-1731-459a-a026-8724520095ba"],
Cell[464080, 11190, 258, 4, 39, "Text",ExpressionUUID->"70e66af9-0a71-422d-b794-7ef770cdda29"],
Cell[CellGroupData[{
Cell[464363, 11198, 863, 18, 41, "Input",ExpressionUUID->"c231e28d-407f-40af-8a47-94242b64621a"],
Cell[465229, 11218, 2422, 64, 142, "Output",ExpressionUUID->"b1118c7c-1b40-42cc-876a-43ae06d24a91"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467688, 11287, 5405, 131, 264, "Input",ExpressionUUID->"795991e9-c991-4b29-9e3b-5cbee1bd16cc"],
Cell[473096, 11420, 76984, 1517, 500, "Output",ExpressionUUID->"541a1811-1d01-4432-85a0-6b24d498b254"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[550129, 12943, 537, 8, 26, "Subsubsection",ExpressionUUID->"b280461f-9f56-4f1d-aa3d-31ede6df9b6a"],
Cell[550669, 12953, 275, 6, 39, "Text",ExpressionUUID->"e3cbcad8-35da-4dcd-97f9-72e35b9feb2b"],
Cell[CellGroupData[{
Cell[550969, 12963, 837, 14, 41, "Input",ExpressionUUID->"430b95cf-ba36-4e79-9e43-8f52c0dbcdea"],
Cell[551809, 12979, 1554, 48, 128, "Output",ExpressionUUID->"833f5031-771d-482b-9ac8-4a2e6af87e17"]
}, Open  ]],
Cell[553378, 13030, 528, 10, 63, "Text",ExpressionUUID->"e029c8cf-0707-4a0a-bcbc-f56a0c53a2b6"]
}, Closed]],
Cell[CellGroupData[{
Cell[553943, 13045, 494, 10, 26, "Subsubsection",ExpressionUUID->"162df404-efdf-4373-b147-74849dec5015"],
Cell[554440, 13057, 798, 17, 31, "Equation",ExpressionUUID->"8d152330-b189-4049-a7e3-09ac738ddc85"],
Cell[555241, 13076, 872, 18, 31, "Equation",ExpressionUUID->"8622f49a-39b4-4c17-9b55-d6dd1f7f4395"],
Cell[556116, 13096, 262, 6, 39, "Text",ExpressionUUID->"105f5074-c65e-4ae0-82e4-139f2b9fb310"],
Cell[CellGroupData[{
Cell[556403, 13106, 185, 2, 41, "Input",ExpressionUUID->"a0c6cdcb-328c-4949-97eb-f135a69daf38"],
Cell[556591, 13110, 1133, 33, 75, "Output",ExpressionUUID->"7b9b09f6-da2f-4ef7-8880-c49ec4ff154e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[557761, 13148, 322, 7, 41, "Input",ExpressionUUID->"0af04c4f-09e5-4df5-9a4d-327c7a91e5d0"],
Cell[558086, 13157, 463, 10, 41, "Output",ExpressionUUID->"9111f275-2be5-4c93-bb42-ec7e133e6863"]
}, Open  ]],
Cell[CellGroupData[{
Cell[558586, 13172, 1476, 26, 67, "Input",ExpressionUUID->"adcd7a26-7ec3-4e0c-ac2e-475fb8cae040"],
Cell[560065, 13200, 1385, 39, 112, "Output",ExpressionUUID->"c789442c-cbaf-4830-96ec-b776741f828d"],
Cell[561453, 13241, 762, 20, 70, "Output",ExpressionUUID->"3fdcf883-bbb7-40cc-ab37-7a831eb36ca9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[562252, 13266, 4860, 115, 292, "Input",ExpressionUUID->"c8633a90-3a95-4c5b-9e9f-98b6b88d7d58"],
Cell[567115, 13383, 901, 13, 41, "Output",ExpressionUUID->"ab566221-e8f8-4818-b130-b218ff957dcf"],
Cell[568019, 13398, 1258, 17, 117, "Output",ExpressionUUID->"5dc5ced0-6b32-483a-b803-bf18fe3bfaf1"],
Cell[569280, 13417, 875, 11, 40, "Output",ExpressionUUID->"030b9995-ab5d-49b7-80a8-74d5e146218c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[570192, 13433, 1116, 27, 119, "Input",ExpressionUUID->"a7004a1d-906a-42b2-98cd-5d67d5976763"],
Cell[571311, 13462, 556, 8, 67, "Output",ExpressionUUID->"3e543919-b2a6-4e51-b85c-ab49b42d16ce"],
Cell[571870, 13472, 388, 5, 40, "Output",ExpressionUUID->"91382f02-0a0f-4e5b-b32b-b98083b0c440"]
}, Open  ]],
Cell[CellGroupData[{
Cell[572295, 13482, 494, 13, 40, "Input",ExpressionUUID->"a6aed713-b6e0-46b0-9e7a-2c74b799627a"],
Cell[572792, 13497, 218, 2, 40, "Output",ExpressionUUID->"326b03a8-6c88-45ea-9462-783b27cbe0b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[573047, 13504, 1566, 40, 144, "Input",ExpressionUUID->"4173856d-a832-4452-ab03-72bb6aa25396"],
Cell[574616, 13546, 1364, 19, 221, "Output",ExpressionUUID->"69797233-a8a5-4569-9a25-daaf04ac4997"],
Cell[575983, 13567, 213, 2, 40, "Output",ExpressionUUID->"226cd914-04d8-44c6-bec9-103d19be83ad"]
}, Open  ]],
Cell[576211, 13572, 265, 6, 37, "Text",ExpressionUUID->"25e7cf92-ccd8-429c-8298-88f45b496f77"]
}, Closed]],
Cell[CellGroupData[{
Cell[576513, 13583, 719, 11, 65, "Subsection",ExpressionUUID->"49b79216-cf44-491a-9767-a58cf0b584ac"],
Cell[577235, 13596, 203, 4, 41, "Input",ExpressionUUID->"80e4128c-1195-467d-ae99-4c5e3d21a220"],
Cell[CellGroupData[{
Cell[577463, 13604, 491, 7, 36, "Subsubsection",ExpressionUUID->"ccc2ae3c-d859-48c6-a5e0-1c5c57602d0d"],
Cell[577957, 13613, 909, 14, 86, "Text",ExpressionUUID->"371afa2c-3d88-4db2-a050-7d08248f3497"],
Cell[CellGroupData[{
Cell[578891, 13631, 4064, 103, 173, "Input",ExpressionUUID->"84e6e251-61f9-45d0-8074-8dfb60cb940f"],
Cell[582958, 13736, 1832, 45, 66, "Output",ExpressionUUID->"e7a10446-aa26-43a1-a66d-d68074800df1"]
}, Open  ]],
Cell[584805, 13784, 544, 10, 63, "Text",ExpressionUUID->"f5bebb76-94b3-4006-87be-ac56886eb848"],
Cell[CellGroupData[{
Cell[585374, 13798, 2454, 58, 92, "Input",ExpressionUUID->"fd44713d-796f-47a0-8952-f78129b136c4"],
Cell[587831, 13858, 1776, 42, 109, "Output",ExpressionUUID->"38a7628a-142d-49a2-a148-46b07b790ddf"],
Cell[589610, 13902, 1650, 37, 79, "Output",ExpressionUUID->"52b22ecc-fc97-477e-b848-57a70bbaa2ac"]
}, Open  ]],
Cell[591275, 13942, 673, 11, 63, "Text",ExpressionUUID->"0006f8e3-0d4f-4391-9f03-8114fe7dd0a0"],
Cell[CellGroupData[{
Cell[591973, 13957, 3817, 82, 166, "Input",ExpressionUUID->"cfcea57b-b8eb-4ba3-b6eb-12b24897d35f"],
Cell[595793, 14041, 1897, 43, 46, "Output",ExpressionUUID->"2e38ebdb-b4dc-4859-be78-bb5ffa4fc0b2"],
Cell[597693, 14086, 2209, 55, 81, "Output",ExpressionUUID->"0df143a1-2efd-424d-98a0-5abe81fe62c9"]
}, Open  ]],
Cell[599917, 14144, 571, 10, 63, "Text",ExpressionUUID->"14a018b4-aeb0-44c5-a292-b2ad7df71c42"],
Cell[CellGroupData[{
Cell[600513, 14158, 1256, 31, 92, "Input",ExpressionUUID->"582ed880-a0fb-4bd3-b4bc-45828e3012da"],
Cell[601772, 14191, 1453, 39, 62, "Output",ExpressionUUID->"6b69b83e-11b4-4b2b-82c6-1f7acc3a53b8"],
Cell[603228, 14232, 713, 14, 62, "Output",ExpressionUUID->"30704347-a4fb-40f5-a477-dbf8e6636371"]
}, Open  ]],
Cell[CellGroupData[{
Cell[603978, 14251, 343, 5, 36, "Subsubsubsection",ExpressionUUID->"39d11b0e-39c8-4a24-a701-4ff8e466a3b9"],
Cell[CellGroupData[{
Cell[604346, 14260, 1398, 35, 123, "Input",ExpressionUUID->"f45fa0b2-b161-4c98-b405-4f8d98666a8b"],
Cell[605747, 14297, 502, 13, 71, "Output",ExpressionUUID->"0f6f7cec-3dec-4d82-88bf-e2e73f8fb8ff"],
Cell[606252, 14312, 589, 17, 78, "Output",ExpressionUUID->"6c394e88-53fc-4cee-b0f0-369daccf4674"]
}, Open  ]],
Cell[606856, 14332, 476, 9, 63, "Text",ExpressionUUID->"9346a39a-74fa-44fc-9841-ba25e967dc29"],
Cell[607335, 14343, 507, 13, 63, "Text",ExpressionUUID->"4d56e3df-e42a-4b5d-a51a-8391534cd105"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[607891, 14362, 415, 7, 47, "Subsubsection",ExpressionUUID->"1724d10f-bdee-4134-bd0a-524a4217b610"],
Cell[CellGroupData[{
Cell[608331, 14373, 1275, 21, 41, "Input",ExpressionUUID->"78c27aa1-5bad-450c-8a74-4165b072c8be"],
Cell[609609, 14396, 2984, 88, 97, "Output",ExpressionUUID->"cff54ab7-4f2d-41e0-920d-089ee1d68243"]
}, Open  ]],
Cell[CellGroupData[{
Cell[612630, 14489, 1138, 21, 41, "Input",ExpressionUUID->"381eea59-81cf-4a21-9ad6-495c4e787364"],
Cell[613771, 14512, 1877, 54, 89, "Output",ExpressionUUID->"a285ad66-edb5-4698-b5e9-492143c736e2"]
}, Open  ]],
Cell[615663, 14569, 335, 7, 39, "Text",ExpressionUUID->"185fef26-5658-49e4-b4da-1f8fa13c280c"],
Cell[CellGroupData[{
Cell[616023, 14580, 941, 24, 41, "Input",ExpressionUUID->"c0f6a321-beda-49fc-92e4-74258f61e374"],
Cell[616967, 14606, 912, 29, 41, "Output",ExpressionUUID->"6e83aedb-98e3-4184-86cf-01e8dc2eb883"]
}, Open  ]],
Cell[CellGroupData[{
Cell[617916, 14640, 553, 12, 41, "Input",ExpressionUUID->"90c95366-3288-4ba1-a307-887077131b29"],
Cell[618472, 14654, 9122, 260, 354, "Output",ExpressionUUID->"abb0c4b0-83ca-42a8-8213-b9e6d01cf1cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[627631, 14919, 817, 15, 41, "Input",ExpressionUUID->"d43891b0-86f4-46aa-93f2-d22b6de6c411"],
Cell[628451, 14936, 5870, 164, 155, "Output",ExpressionUUID->"75e88924-ec47-4aa1-a069-07d4988d915b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[634358, 15105, 309, 8, 41, "Input",ExpressionUUID->"bf5424b6-29c4-48f9-97a8-f55ce6578388"],
Cell[634670, 15115, 1954, 63, 167, "Output",ExpressionUUID->"212aa969-8a05-4beb-b1dc-f881a17d9eca"]
}, Open  ]],
Cell[636639, 15181, 142, 3, 39, "Text",ExpressionUUID->"8c19170e-742b-4aed-a6e2-c94e203f79b0"],
Cell[CellGroupData[{
Cell[636806, 15188, 1151, 27, 117, "Input",ExpressionUUID->"5aeba4ca-2f3e-4367-929d-cd9e34327c30"],
Cell[637960, 15217, 448, 10, 41, "Output",ExpressionUUID->"510fa4d9-4b22-4185-9d9c-12645e042439"]
}, Open  ]],
Cell[638423, 15230, 313, 7, 63, "Text",ExpressionUUID->"341b0c64-055e-4ce2-8b72-f80492f01988"],
Cell[CellGroupData[{
Cell[638761, 15241, 1011, 23, 67, "Input",ExpressionUUID->"637b55db-8c62-4f54-b5bd-d36ec5b3283c"],
Cell[639775, 15266, 444, 10, 41, "Output",ExpressionUUID->"f76bc277-958e-4b11-82e9-aefc0ac56db6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[640256, 15281, 333, 7, 41, "Input",ExpressionUUID->"98374fb9-ec06-4e8c-8561-7245dade03bd"],
Cell[640592, 15290, 1019, 33, 67, "Output",ExpressionUUID->"6465238a-648c-4b83-8962-cb38e10ab2b8"]
}, Open  ]],
Cell[641626, 15326, 853, 14, 132, "Text",ExpressionUUID->"7bbf29bb-437e-4b9a-b18c-481cf9e5799f"],
Cell[CellGroupData[{
Cell[642504, 15344, 406, 10, 41, "Input",ExpressionUUID->"028a0c9c-433b-4827-b867-4f9a409b4ce4"],
Cell[642913, 15356, 343, 8, 60, "Output",ExpressionUUID->"f7fdbb95-1113-4a76-8207-33bfd2f17ffc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[643293, 15369, 319, 7, 41, "Input",ExpressionUUID->"9d0ef70c-1e28-4a38-b5b2-41c278e6a50d"],
Cell[643615, 15378, 750, 22, 41, "Output",ExpressionUUID->"d9b1d7b0-fad7-472f-a480-af251163d05a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[644414, 15406, 500, 9, 47, "Subsubsection",ExpressionUUID->"3c72aae9-13ec-43d2-981e-85b3423ccd99"],
Cell[644917, 15417, 466, 9, 63, "Text",ExpressionUUID->"ce5c6401-6bdd-43eb-a5f6-1c8aa1dc5c21"],
Cell[CellGroupData[{
Cell[645408, 15430, 292, 6, 41, "Input",ExpressionUUID->"bd40fd31-727c-4678-a42e-e550311a4ffb"],
Cell[645703, 15438, 591, 18, 66, "Output",ExpressionUUID->"2a4b3eb5-f5c0-4800-a80c-ac91a83a7f84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[646331, 15461, 1153, 25, 92, "Input",ExpressionUUID->"2c8e8ab6-6a7c-4098-bc2a-c7293195dc23"],
Cell[647487, 15488, 1706, 50, 65, "Output",ExpressionUUID->"66c75b73-790e-4bb6-8454-23273a0ffb7e"]
}, Open  ]],
Cell[649208, 15541, 434, 9, 39, "Text",ExpressionUUID->"e102bf18-5de0-45da-b88a-7f1400a4a5c3"],
Cell[CellGroupData[{
Cell[649667, 15554, 286, 6, 41, "Input",ExpressionUUID->"9e67b5e8-8167-4d9d-8628-2be16073a8bc"],
Cell[649956, 15562, 235, 4, 41, "Output",ExpressionUUID->"2d32c4c0-4628-4471-a395-61b4044529e2"]
}, Open  ]],
Cell[650206, 15569, 217, 5, 39, "Text",ExpressionUUID->"ce9a2ba0-ffd7-4cc6-a7ea-eff02989042e"],
Cell[CellGroupData[{
Cell[650448, 15578, 1247, 25, 46, "Input",ExpressionUUID->"d38dbb20-6513-45e8-81a7-6e1bc1529f32"],
Cell[651698, 15605, 3819, 116, 265, "Output",ExpressionUUID->"637c5cc7-4e4c-4dee-af50-ff82ec98905a"]
}, Open  ]],
Cell[655532, 15724, 348, 7, 39, "Text",ExpressionUUID->"e1bb4e9c-58fe-44d0-b431-3706e47d9b27"],
Cell[655883, 15733, 687, 16, 67, "Input",ExpressionUUID->"d532eac5-642b-4d97-a9fe-7e0d9d2aa239"],
Cell[CellGroupData[{
Cell[656595, 15753, 317, 7, 41, "Input",ExpressionUUID->"2e63f2fb-e3b6-4611-ae84-2b6184c1b84d"],
Cell[656915, 15762, 1549, 47, 72, "Output",ExpressionUUID->"bd9e604f-f39b-4407-990b-063f37ce2377"]
}, Open  ]],
Cell[658479, 15812, 187, 3, 39, "Text",ExpressionUUID->"0fa26b1d-ee23-45d5-bdb4-2b3e679d7a01"],
Cell[CellGroupData[{
Cell[658691, 15819, 416, 11, 41, "Input",ExpressionUUID->"c65db9cf-54f5-4fdb-8add-8d4847b9b80d"],
Cell[659110, 15832, 283, 5, 41, "Output",ExpressionUUID->"0535522a-d92c-45d6-83bc-e9076503b704"]
}, Open  ]],
Cell[659408, 15840, 581, 10, 39, "Text",ExpressionUUID->"5390fb6a-9cab-4515-b11d-870bc9568eaf"],
Cell[659992, 15852, 152, 3, 39, "Text",ExpressionUUID->"50ffb09a-0378-4f4e-ad82-8a7dc79371db"],
Cell[660147, 15857, 546, 14, 40, "Text",ExpressionUUID->"4fe83079-06f0-41fa-8c39-0771cbe5fcf0"],
Cell[660696, 15873, 567, 10, 39, "Text",ExpressionUUID->"e77e1908-b317-4296-aef4-7fdc31cef243"],
Cell[661266, 15885, 862, 18, 41, "Input",ExpressionUUID->"e2592be1-3c57-43aa-b49f-3ece23bd1a2d"]
}, Closed]],
Cell[CellGroupData[{
Cell[662165, 15908, 591, 9, 26, "Subsubsection",ExpressionUUID->"780440d5-fe35-400a-ae92-89cbfb39888c"],
Cell[662759, 15919, 275, 6, 39, "Text",ExpressionUUID->"77afb9fc-ddf2-4de5-9329-3bae3433b182"],
Cell[CellGroupData[{
Cell[663059, 15929, 1133, 22, 67, "Input",ExpressionUUID->"4a56b380-ce30-4ce3-8a1a-51537041a1f3"],
Cell[664195, 15953, 1968, 63, 110, "Output",ExpressionUUID->"6833159e-bc91-4295-8d3e-8a1021a29893"]
}, Open  ]],
Cell[666178, 16019, 529, 12, 39, "Text",ExpressionUUID->"ce7d4a08-2c72-4d76-b8b3-9cb5517256bb"],
Cell[666710, 16033, 1018, 25, 92, "Input",ExpressionUUID->"e1acf3b7-f879-4876-ad3a-091b35812904"],
Cell[CellGroupData[{
Cell[667753, 16062, 457, 11, 41, "Input",ExpressionUUID->"ca75e560-ccf3-4f11-9ba3-a11d9a61447b"],
Cell[668213, 16075, 539, 17, 41, "Output",ExpressionUUID->"b3b53f39-2cb0-42c9-8bdb-de7f12b5c348"]
}, Open  ]],
Cell[668767, 16095, 815, 13, 109, "Text",ExpressionUUID->"e2b84ef6-e7c1-4696-bb42-4f4856147c30"],
Cell[CellGroupData[{
Cell[669607, 16112, 189, 3, 41, "Input",ExpressionUUID->"b5b9aa23-9252-4635-828f-d78d1f4ddd81"],
Cell[669799, 16117, 622, 20, 41, "Output",ExpressionUUID->"7fe2a326-7a5e-458a-9724-77124d00cb4b"]
}, Open  ]],
Cell[670436, 16140, 528, 10, 63, "Text",ExpressionUUID->"6a907c67-4bf3-4a6a-b997-45481e1ff35d"]
}, Closed]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[671025, 16157, 499, 7, 99, "Section",ExpressionUUID->"e20af42b-6d40-4618-ab3e-7f6ee166cb23"],
Cell[671527, 16166, 367, 7, 39, "Text",ExpressionUUID->"0bb540fc-6852-4fe5-a115-1d8216eb6b35"],
Cell[671897, 16175, 817, 15, 41, "Input",ExpressionUUID->"dbb59f42-c57e-4d9b-aff1-56c225c7c116"],
Cell[672717, 16192, 2776, 56, 92, "Input",ExpressionUUID->"7e4c67be-d208-417d-b3ab-54f6fb76b11f"],
Cell[CellGroupData[{
Cell[675518, 16252, 3951, 87, 192, "Input",ExpressionUUID->"e6de5fbf-2f22-41ea-acfd-0d9635502999"],
Cell[679472, 16341, 21755, 396, 456, "Output",ExpressionUUID->"fa853207-6607-48ac-96b9-8194ecac33b1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[701264, 16742, 6319, 156, 217, "Input",ExpressionUUID->"4027258f-dc1d-4a0a-ac08-69e7f83f7399"],
Cell[707586, 16900, 120496, 2156, 2877, "Output",ExpressionUUID->"43a6e364-4429-4736-aba1-d443e1c84184"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

