library(qtl)

#############
# READ DATA #
#############


args(read.cross)
mydata <- read.cross ("csv","", "SupplFile_1_rQTL_Input.csv", crosstype = "f2", file, genfile, mapfile, phefile, chridfile, mnamesfile, na.strings="NA", genotypes=c("AA", "AB", "BB"), alleles= c("A","B"), estimate.map= TRUE, convertXdata = TRUE, map.function = c("kosambi"))



##############
# CHECK DATA #
##############

# basic checks

listmap <- pull.map(mydata)
plot(listmap)
geno.image(mydata)
rf <- est.rf(mydata)
checkAlleles(rf)
plotRF(rf, alternate.chrid = TRUE)


#ripple markers to infer correct order

rip_countxo_chr1 <- ripple(mydata, chr = 1, window = 10, method= "countxo")
summary(rip_countxo_chr1)
head(rip_countxo_chr1,20)
mydata_new_marker_order <- switch.order (mydata, chr=1, rip_countxo_chr1[2,])

rip_countxo_chr2 <- ripple(mydata_new_marker_order, chr = 2, window = 10, method= "countxo")
summary(rip_countxo_chr2)
mydata_new_marker_order <- switch.order (mydata_new_marker_order, chr=2, rip_countxo_chr2[2,])

rip_countxo_chr3 <- ripple(mydata, chr = 3, window = 10, method= "countxo")
summary(rip_countxo_chr3)



# check again after rippling

rf_new_marker_order <- est.rf(mydata_new_marker_order)
plot(rf_new_marker_order)
newmap <- est.map (mydata_new_marker_order, error.prob = 0.001) 
plot.map(mydata_new_marker_order, newmap) 
mydata_new_marker_order <- calc.errorlod (mydata_new_marker_order, error.prob = 0.001) 
top <- top.errorlod(mydata_new_marker_order, cutoff = 5) 
nxo <- countXO(mydata_new_marker_order)
plot(nxo, ylab = "No.crossovers")
mean(nxo)
#quartz("",20,28)
#par(oma=c(5,5,5,5))
plotGeno(mydata_new_marker_order, chr=1)
plotGeno(mydata_new_marker_order, chr=2)
plotGeno(mydata_new_marker_order, chr=3)
plotInfo(mydata_new_marker_order)
out.mr <- scanone(mydata_new_marker_order, pheno=1, method= "mr")
plot(out.mr)


#calculate genotype probabilities, simulate, impute

mydata_prob <- calc.genoprob(mydata_new_marker_order, step = 1, error.prob = 0.01)
mydata_sim <- sim.geno (mydata_new_marker_order, step=1, n.draws = 50, error.prob = 0.01)
out.imp <- scanone (mydata_sim, method = "imp")
plot(out.imp)




##################
# QTL FOR TIMING #
##################



# stepwiseqtl
#############

out2.perm <- scantwo(mydata_prob, pheno.col=1, n.perm=1000, model="normal", method="em")
pen <- calc.penalties(out2.perm, alpha=0.05)

step.out <- stepwiseqtl(mydata_sim, additive.only=F, max.qtl=4, penalties=pen, verbose=T, model="normal")
step.frame <- as.data.frame(summary(step.out))
step.qtl <- makeqtl(mydata_sim, chr= step.frame$chr, pos=step.frame$pos)
step.refine <- refineqtl(mydata_sim, qtl=step.qtl, formula=attr(step.out, "formula"), verbose=T)
step.fit <- fitqtl(mydata_sim, qtl=step.qtl, formula=attr(step.out, "formula"), pheno.col = 1, model="normal")

step.fitresult <- summary(step.fit)
plotLodProfile(step.refine)




# simple single QTL scans - scanone (NOT USED)
##############################################

#out.em <- scanone(mydata_prob, pheno.col=1, model="normal", method="em")
#out.hk <- scanone(mydata_prob, pheno.col=1, model="normal", method="hk") # hk does not work with np
#out.ehk <- scanone(mydata_prob, pheno.col=1, model="normal", method="ehk")

#operm <- scanone (mydata_prob, n.perm = 1000, verbose = FALSE, model="np" )
#plot(operm)
#one.percent <- summary (operm, alpha = 0.01)
#five.percent <- summary (operm, alpha = 0.05)


#plot LOD & QTL intervals

#quartz("",8,6)
#plot(out.hk, out.em, out.ehk, col=c("red","blue","green"), ylab="LOD score")
#arrows(-100,five.percent,1000, five.percent)
#qtl.chr1 <- lodint(out.em, chr=1, qtl.index=2, drop=1)
#qtl.chr2 <- lodint(out.em, chr=2, drop=1)
#qtl.chr3 <- lodint(out.em, chr=3, drop=1)
#qtl.chr1 <- bayesint(out.em, chr=1, prob=0.99)
#qtl.chr2 <- bayesint(out.em, chr=2, prob=0.95)
#qtl.chr3 <- bayesint(out.em, chr=3, prob=0.95)
#points(qtl.chr1[2,2],0, pch=18, col="blue", cex=1.5)
#arrows(qtl.chr1[1,2],0,qtl.chr1[3,2],0, length=0, col="blue")
#points(130+qtl.chr2[2,2],0, pch=18, col="blue", cex=1.5)
#arrows(130+qtl.chr2[1,2],0,130+qtl.chr2[3,2],0, length=0, col="blue")
#points(256+qtl.chr3[2,2],0, pch=18, col="blue", cex=1.5)
#arrows(256+qtl.chr3[1,2],0,256+qtl.chr3[3,2],0, length=0, col="blue")


# plot genotype effects
#quartz("", 11, 3,5)
#par(mfrow=c(1,4))
#mydata_simulated_missingGT <- sim.geno (mydata_new_marker_order, n.draws=16, error.prob=0.001)
#effectplot (mydata_simulated_missingGT, mname1 = QTL.chr1.em.marker)
#plotPXG (mydata_simulated_missingGT, marker = "Set6Fam1_c1s17p218989")
#plotPXG (mydata_simulated_missingGT, marker = "LP_c1_25495114")
#effectplot (mydata_simulated_missingGT, mname1 = QTL.chr2.em.marker)
#plotPXG (mydata_simulated_missingGT, marker = "Set2Fam2_c2s50p1574694")
#plotPXG (mydata_simulated_missingGT, marker = "Set4Fam2_c3s49p1469338")





# scan for interacting qtl - scantwo
####################################

out2 <- scantwo(mydata_prob, pheno.col = 1, model = "normal")

#out2.perm <- scantwo(mydata_prob, n.perm=1000, pheno.col=1, model="normal") #already done above for stepwiseqtl
summary(out2.perm )
summary(out2, perms=out2.perm , alphas=c(0.05,0.5,0,0.05,0.05), pvalues=T)

quartz()

plot(out2, lower="add", upper="full")

quartz()
par(mfrow=c(2,2))
effectplot (mydata_simulated_missingGT, mname1 = "Set6Fam1_c1s17p218989", mname2="Set3Hex2_c2s47Dp910701")
effectplot (mydata_simulated_missingGT, mname1 = "Set6Fam1_c1s17p218989", mname2="Set4Fam2_c3s49p1469338")
effectplot (mydata_simulated_missingGT, mname1 = "Set3Hex2_c2s47Dp910701", mname2="Set6Fam1_c1s17p218989")
effectplot (mydata_simulated_missingGT, mname1 = "Set3Hex2_c2s47Dp910701", mname2="Set4Fam2_c3s49p1469338")



# Final model in fitqtl 
# 4 QTL - additive only based on stepwiseqtl
############################################


qtl.scan1 <- makeqtl(mydata_sim, chr=c(1,1,2,3), pos=c(12.5,85,71,0))

qtl.refine <- refineqtl(mydata_sim, qtl=qtl.scan1, formula=y~Q1+Q2+Q3+Q4, verbose=T)
fit <- fitqtl(mydata_sim, qtl=qtl.refine, formula=y~Q1+Q2+Q3+Q4, pheno.col = 1, model="normal", get.ests=T)
fitresult <- summary(fit)

#plot
plotLodProfile(qtl.refine, ylim=c(-2,15))
int1 <- bayesint(qtl.refine,qtl.index=1, prob=0.95)
arrows(int1$pos[1],-0.6,int1$pos[3],-0.6,length=0)
points(int1[2,2],-0.6, pch=18, col="black", cex=1.5)
int2 <- bayesint(qtl.refine,qtl.index=2, prob=0.95)
arrows(int2$pos[1],-0.6,int2$pos[3],-0.6,length=0)
points(int2[2,2],-0.6, pch=18, col="black", cex=1.5)
int3 <- bayesint(qtl.refine,qtl.index=3, prob=0.95)
arrows(130+int3$pos[1],-0.6,130+int3$pos[3],-0.6,length=0)
points(130+int3[2,2],-0.6, pch=18, col="black", cex=1.5)
int4 <- bayesint(qtl.refine,qtl.index=4, prob=0.95)
arrows(256+int4$pos[1],-0.6,256+int4$pos[3],-0.6,length=0)
points(256+int4[2,2],-0.6, pch=18, col="black", cex=1.5)

#add intervals from CIM; QTL cartographer, backward selection, 10 covariates, 10cM interval
points(12.4,-1, pch=18, col="grey70", cex=1.5)
arrows(4.3,-1,16.4,-1, length=0, col="grey70")
points(93.1,-1, pch=18, col="grey70", cex=1.5)
arrows(80.2,-1,102.1,-1, length=0, col="grey70")
points(130+74.0,-1, pch=18, col="grey70", cex=1.5)
arrows(130+68.5,-1,130+80.7,-1, length=0, col="grey70")
points(130+90.8,-1, pch=18, col="grey70", cex=1.5)
arrows(130+86.8,-1,130+96.8,-1, length=0, col="grey70")
points(256+25,-1, pch=18, col="grey70", cex=1.5)
arrows(256+19,-1,256+31.5,-1, length=0, col="grey70")
text( 310,-0.6,"MQM", cex=0.7)
#text( -3,0.3,"1QTL", col="grey40",cex=0.7)
text( 310.5,-1,"CIM", col="grey70", cex=0.7)

