####
# bedgraph to long range for washU browser
####

# set path of the pipeline
bdir=`dirname $0`

# set par
input=$1
bg=${input}/${input}.merged.RPM.smooth.bedGraph
vp_id=${input/*ND/ND}
vp_id=${vp_id/_*/}
vp_bed=viewpoint.bed
vp=`grep $vp_id $vp_bed |cut -f1-3`
vp=${vp/\r/}

# make long range
awk -v V=$vp_id 'NR==FNR {M=int(($2+$3)/2); a[$4] = $1"\t"M"\t"M+1} NR>FNR {M=int(($2+$3)/2); print a[V]"\t"$1":"M"-"M+1","$4"\t"FNR"\t."}' $vp_bed $bg |bgzip > ${bg}.lr.gz
tabix -p bed ${bg}.lr.gz

