
install.packages("scatterplot3d")
install.packages("plotrix")
library(scatterplot3d)
library(plotrix)



###########################################################
control <- read.csv('control.csv')

#colors <- c('#3a8df2','#c2590e')

z <- control$Mean.Temp
x <- control$Mean.Velocity
y <- control$Mean.Zone.Tran

# gropus <- as.factor(control$Category)
# shapes <- shapes[as.numeric(control$Category)]
# #shapes <- as.factor(control$Category)
 ?scatterplot3d
S3D <- scatterplot3d(x, y, z,
                     #main = 'Control',
                     xlab = 'Mean velocity in cm/s',
                     ylab = 'No. of zone transitions',
                     #ylab = "",
                     zlab = 'Mean temperature in \u00B0C',
                     #pch = 25,
                     pch = 21,
                     cex.symbols = 2,
                     #cex.symbols = rescale(control$Mean.Temp,c(2, 4)),
                     #highlight.3d = TRUE,
                     #color = colors[group],
                     color = 'gray',
                     #color=grey(25:1/40),
                     #pch = shapes, 
                     xlim = c(0,3.5),
                     ylim = c(5,150),
                     zlim = c(21,26),
                     type = 'h',
                     lty.hplot = 1,
                     bg = 'green',
                     angle = 45,
                     #lwd = 2,
                     #mar = c(5,5,4,3),
                     col.axis = 'grey65',
                     lty.axis = 1,
                     )
#text(50,1, "No. zone trans", srt = 45)


###########################################################
aero <- read.csv('aeromonas.csv')
#colors <- c('#3a8df2','#c2590e')

z <- aero$Mean.Temp
x <- aero$Mean.Velocity
y <- aero$Mean.Zone.Tran

#gropus <- as.factor(aero$Category)
#shapes <- shapes[as.numeric(aero$Category)]
#shapes <- as.factor(control$Category)
?scatterplot3d
S3D <- scatterplot3d(x, y, z,
                     #main = 'Control',
                     xlab = 'Mean velocity in cm/s',
                     ylab = 'No. of zone transitions',
                     zlab = 'Mean temperature in \u00B0C',
                     #pch = 25,
                     pch = 21,
                     cex.symbols = 2,
                     #cex.symbols = rescale(aero$Mean.Temp,c(1, 3)),
                     #highlight.3d = TRUE,
                     #color = colors[group],
                     color = 'grey',
                     #pch = shapes, 
                     xlim = c(0.5,3.5),
                     ylim = c(5,150),
                     zlim = c(21,26),
                     type = 'h',
                     lty.hplot = 1,
                     bg = 'mediumorchid3',
                     angle = 45,
                     #lwd = 2,
                     #mar = c(1,3,5,7),
                     col.axis = 'grey65',
                     lty.axis = 1,
                     #grid = FALSE
                  )


###########################################################
all <- read.csv('aeromonasPlusControl.csv')

#colors <- c('#3a8df2','#c2590e')

z <- all$Mean.Temp
x <- all$Mean.Velocity
y <- all$Mean.Zone.Tran

colors <- c('mediumorchid3','green')
group <- as.factor(all$Category)
#shapes <- c(17,18)
#shapes <- shapes[as.numeric(all$Category)]
#shapes
#shapes <- as.factor(control$Category)
?scatterplot3d
S3D <- scatterplot3d(x, y, z,
                     #main = 'Control',
                     xlab = 'Mean velocity in cm/s',
                     ylab = 'No. of zone transitions',
                     zlab = 'Mean temperature in \u00B0C',
                     #pch = 25,
                     pch = 21,
                     #pch = shape,
                     cex.symbols = 2,
                    
                     #cex.symbols = rescale(all$Mean.Temp,c(1, 3)),
                    
                     #highlight.3d = TRUE,
                     #color = colors[group],
                     color = 'grey',
                     
                     #xlim = c(0.5,3.5),
                     ylim = c(5,140),
                     #zlim = c(21,26),
                     type = 'h',
                     lty.hplot = 1,
                     bg = colors[group],
                     angle = 45,
                     #lwd = 2,
                     #mar = c(5,5,4,3),
                     col.axis = 'grey65',
                     lty.axis = 1,
            
                    
)


legend("topleft", legend = levels(as.factor(all$Category)),
       col =  c('mediumorchid3','green'), 
       pch = 19, 
       bty = "n",
       cex = 1,
       #bg = colors[group]
       #inset = 0.25, 
       xpd = TRUE,
       #horiz = TRUE
       )



  