function [sigConc, xPos, yPos, actConc, inhConc, chemSens, cellDir, cellSpeed]=get_IC(p)
%{
Defines initial conditions for the cell-signalling model (see main_Dicty)

Input
p .. parameters structure

Output
see main_Dicty for variable explanations

optICcells and optICsig allows to decide for different options of ICs, here
only the ICs used in the publication are included

Written 12/2021 by Angelika Manhart
%}

%% Prepare

%% Define ICS

% Set ICs for cell properties
switch p.optICcells
    
    case 0 % linear wave
        
        xPos=p.Lx*(rand(p.N,1)-0.5);
        yPos=p.Ly*(rand(p.N,1)-0.5);
        
        cellSpeed=0*ones(p.N,1);
        cellDir=2*pi*rand(p.N,1);
        
        stripeWidth=p.Lx/10;
        expon=1;
        inhMax=2.5;
        
        actConc=zeros(p.N,1);
        actConc(abs(xPos)<=stripeWidth/2)=2;
        
        inhConc=(xPos/p.Lx).^expon*inhMax;
        inhConc(xPos<0)=((xPos(xPos<0)+p.Lx)/p.Lx).^expon*inhMax;
        
        chemSens=zeros(p.N,1);
        
end

% Set ICs for signal properties
switch p.optICsig    
    
    case 0 % constant external signal
         
         sigConcVal=0;

         sigConc = sigConcVal*ones(length(p.xVals), length(p.yVals))';
  
end

end

