function make_plot(sigConc, xPos, yPos, actConc, inhConc, chemSens, cellDir, cellSpeed, dxSigConc, dySigConc, p,time)

%{
Plots current state of system
Written 12/2021 by Angelika Manhart
%}

xVals=p.xVals;
yVals=p.yVals;
Lx=p.Lx;
Ly=p.Ly;

%% Plot
if time==0; clf; end
colormap jet


% use only a subset of cells for plotting
isUse=1:5000; 

subplot(2,2,1)
    cla; hold on
    pcolor(xVals,yVals, sigConc); shading flat
    colorbar
    axis equal
    xlim([-1 1]*Lx/2); ylim([-1 1]*Ly/2);
    title(strcat('Time:', num2str(time, '%.2f'),', ext cAMP'))

subplot(2,2,2)
    cla; hold on
    scatter(xPos(isUse), yPos(isUse), 2, actConc(isUse), 'filled')
    colorbar
    caxis([-2 2])
    axis equal
    xlim([-1 1]*Lx/2); ylim([-1 1]*Ly/2);
    title('Cell Activity')

subplot(2,2,3)
    cla; hold on

    cellPosDir=mod(atan2(yPos(isUse), xPos(isUse)),2*pi);           
    isInward=-cos(cellPosDir-cellDir(isUse));          
    scatter(xPos(isUse), yPos(isUse), 2, isInward, 'filled')
    colorbar
    title('Movement Direction')
    axis equal
    xlim([-1 1]*Lx/2); ylim([-1 1]*Ly/2);

subplot(2,2,4)
    cla; hold on
    scatter(xPos(isUse), yPos(isUse), 2, cellSpeed(isUse), 'filled')
    colorbar
    axis equal
    xlim([-1 1]*Lx/2); ylim([-1 1]*Ly/2);
    title('Cells Speed')

