function sigConcPerCell=get_sigConcPerCell(sigConc, xPos, yPos,p)


    if p.optBC==0 % periodic BC
        
        % account for periodicity
        sigConc2=[sigConc sigConc(:,end)];
        sigConc2=[sigConc2; sigConc2(end,:)];

        [x,y] = meshgrid(p.xVals,p.yVals);

        x2=[x x(:,end)+p.dx];
        x2=[x2; x2(end,:)];

        y2=[y y(:,end)];
        y2=[y2; y2(end,:)+p.dy];
    
    elseif p.optBC==1 % no-flux BC
        
        sigConc2=sigConc;
        [x2,y2] = meshgrid(p.xVals,p.yVals);        
        
    end 
    
    % interpolate
    sigConcPerCell=interp2(x2,y2,sigConc2, xPos, yPos);
end