function dydt=RHS_modFHN(t,y,sigConcPerCell, p)
%{
Solves the FitzHugh-Naguma type model used to model the cAMP signalling
dynamics for Dictystelium

used in main_Dicty.m

actConc .. activator value
inhConc .. inhibitor value

Written 12/2021 by Angelika Manhart
%}

% number of cells
N=length(sigConcPerCell);

% a function modelling pre-processing of signal
preProc=@(z) p.preA*log(1+z/p.preKd);

actConc=y(1:N);
inhConc=y(N+1:end);

% the differential equations
dAct=(actConc-1/3*actConc.^3-inhConc+preProc(sigConcPerCell))/p.intTimeScale;
dInh=p.epsi*(actConc-p.inhDecay*inhConc+p.inhBasal)/p.intTimeScale;

dydt=[dAct;dInh];

