#load libraries
library("readxl")	#reading in excel files
library("dplyr")
library("ggplot2")	#plotting
library("ggsignif")
library("patchwork")
library("patchwork")
library("ggalt")	#ggdumbbell plots
library("itsadug")

#set path and working directory
PATH = "/your/path/here/AlvarezBuylla_ABG_SI_DataDryad/Figure2_FigureS2/plotting_and_analysis/"
setwd(PATH)

#load proteomics data - spectral counts across conditions
sc_df <- read.csv(file ="noncontaminants_counts_comparison_across_conditions.csv")

#turn NAs into 0s
sc_df[is.na(sc_df)] = 0

#average across PB conditions (cols 3 & 4) and create new column (pb_avg)
sc_df$pb_avg <- rowMeans(sc_df[ , c(3,4)])

#average across PB + PTX conditions (cols 5 & 6) and create new column (pb_avg)
sc_df$pbptx_avg <- rowMeans(sc_df[ , c(5,6)])

#average across PB + PTX conditions (cols 5 & 6) and create new column (pb_avg)
sc_df$ctrl_avg <- rowMeans(sc_df[ , c(7,8)])

#drop rows where PB avg value is 0
sc_df <- sc_df[sc_df$pb_avg != 0, ]

#normalize values to sc in control, if negative then replace with 0
sc_df$pb_avg_norm <- sc_df$pb_avg - sc_df$ctrl_avg
sc_df$pb_avg_norm[sc_df$pb_avg_norm < 0] <- 0

sc_df$pbptx_avg_norm <- sc_df$pbptx_avg - sc_df$ctrl_avg
sc_df$pbptx_avg_norm[sc_df$pbptx_avg_norm < 0] <- 0

#create percent competed column (1-pbptx/pb)
sc_df$percentcompeted <- 100 - 100*(sc_df$pbptx_avg/(sc_df$pb_avg))

#make all negative values 0
sc_df$percentcompeted[sc_df$percentcompeted < 0] <- 0 

#set the theme
theme_aab <- function() {
	theme_bw() +

    theme(
    	#legend.position = "none",
    	legend.text = element_text(size = 10), 
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_rect(size = 1, color = "black"),
        plot.title = element_text(
        				size = 20, 
        				hjust = 0.5,
        				vjust = 0.5),
        axis.title = element_text(size = 15, color = "black"),
        axis.text = element_text(size = 13, color = "black"))
}


#make the scatter plot
a <- ggplot(sc_df, aes(x=percentcompeted, y=pb_avg)) + 
	geom_point(colour = "black", size = 5) + 
	theme_aab() + 
	xlab("% competition") + 
    ylab("average spectral counts (photoprobe)") + 
    xlim(0, 100)

ggsave("percentcompetition_vs_spectralcounts.pdf", plot = a, width = 15, height = 15, units = 'cm')

##### MAKING BARPLOT #####
#load proteomics data - spectral counts across conditions
pbg_df <- read.csv(file ="justPBG_counts_comparison_across_conditions.csv")

pbg_df$group <- factor(pbg_df$group,levels = c("PB", "PBPTX", "CTRL"))

#make the bar plot
b <- ggplot(pbg_df, aes(fill=group, y=sc, x=group, group = R)) + 
    geom_bar(position="dodge", stat="identity", colour = "white", size = 0.7) + 
    scale_fill_manual(values = c("darkgreen", "dodgerblue2", "darkorange1")) + 
    xlab("") + 
    ylab("spectral counts") + 
    theme_aab()

ggsave("barplot_PBG.pdf", plot = b, width = 13, height = 15, units = 'cm')


##### MAKING DUMBBELL PLOT #####
#make the dumbbell plot for showing the coverage of peptides over the gene

#load peptide data - position and number of counts of each peptide
up_df <- read.csv(file ="Oopsyl4765_PBG_peptides_map.csv")

#create a color range
fun_color_range <- colorRampPalette(c("gray80", "gray18"))
my_colors <- fun_color_range(220)

#add color column to up_df
up_df$color = my_colors[up_df$X..copies]

# doing it based by color
# c <- ggplot(up_df, aes(y=X., x=start_pos, xend=end_pos)) +
#   geom_dumbbell(size=0.7, color=up_df$color,
#   				size_x = 0, size_xend = 0, 
#                 #colour_x = "#5b8124", colour_xend = "#bad744",
#                 dot_guide=FALSE, dot_guide_size=0.25) +
#   labs(x=NULL, y=NULL, title="ggplot2 geom_dumbbell with dot guide") +
#   theme_aab()

# doing it based on repeats
c <- ggplot(up_df, aes(y=num, x=start_pos, xend=end_pos)) +
  geom_dumbbell(size=0.3, color="gray50",
  				size_x = 0, size_xend = 0, 
                colour_x = "gray50", colour_xend = "gray50", alpha = 0.3,
                dot_guide=FALSE, dot_guide_size=0.25) +
  labs(x=NULL, y=NULL, title="") +
  theme_aab()

ggsave("peptides_PBG.pdf", plot = c, width = 30, height = 7, units = 'cm')

