# -*- coding: utf-8 -*-
"""
@author: nbcs
"""

import seaborn as sns
import pandas as pd

#Select color of choice
colors=["#5b9bd5ff","#c1d63dff","#fe9118ff"]
sns.set_palette(sns.color_palette(colors))

#Import data from a txt file (copied from excel table)
data=pd.read_csv("....python.txt",sep='\t')

#Transform data from Excel table to fit Seaborn data shape
#Here an example with 3 Arabiodpsis lines : Col0, AHA and PP2C
data2=pd.melt(data, 'd')
data2 = data2.astype({"variable": int})

#Extract value for each lines in control and auxin treatment
Col=data2.loc[data2["d"].isin(['col_cm', 'col_iaa'])]
aha=data2.loc[data2["d"].isin(['aha_cm', 'aha_iaa'])]
pp2c=data2.loc[data2["d"].isin(['pp2c_cm', 'pp2c_iaa'])]

#Extract value for the control condition
controls=data2.loc[data2["d"].isin(['col_cm', 'aha_cm','pp2c_cm'])]

#Line plot with cloud errors bars for Col0
a=sns.relplot(x="variable", y="value", kind="line", ci="sd", data=Col,hue='d')
axes = a.axes
axes[0,0].set_ylim(0.8,1.5)
axes[0,0].set_xlim(0,800)
a.savefig('...Col0_line.svg')

#Line plot with cloud errors bars for aha
a=sns.relplot(x="variable", y="value", kind="line", ci="sd", data=aha,hue='d')
axes = a.axes
axes[0,0].set_ylim(0.8,1.5)
axes[0,0].set_xlim(0,800)
a.savefig('...aha_line.svg')

#Line plot with cloud errors bars for pp2c
a=sns.relplot(x="variable", y="value", kind="line", ci="sd", data=pp2c,hue='d')
axes = a.axes
axes[0,0].set_ylim(0.8,1.5)
axes[0,0].set_xlim(0,800)
a.savefig('...pp2c_line.svg')

#Line plot with cloud errors bars for compararison of each line in control condition
a=sns.relplot(x="variable", y="value", kind="line", ci="sd", data=controls,hue='d',linewidth = 4)
axes = a.axes
axes[0,0].set_ylim(0.8,1.1)
axes[0,0].set_xlim(0,800)
a.savefig('...averages_fluo_control.svg')


####Calculation and ploting of the alkalinization factor by IAA
#Import data from a txt file (copied from excel table)
data=pd.read_csv("F:/pH paper/Experiments/Agar/SAC series sept 2021/SAC1/delta_compile.txt",sep='\t')

#Transform data from Excel table to fit Seaborn data shape
data2=pd.melt(data, 'd')
data2 = data2.astype({"variable": int})

#Pass the delta ratios in percentages
data2['value']=data2['value']*100

#Plot
a=sns.relplot(x="variable", y="value", kind="line", ci="sd", data=data2,hue="d",linewidth = 4)
axes = a.axes
axes[0,0].set_ylim(-20,20)
axes[0,0].set_xlim(0,800)

#Export
a.savefig('D:/Work2/Paper/pH paper/Experiments/Agar/SAC series sept 2021/SAC1/averages_deltas.svg')
