#Import libraries
library(nparcomp)
library(stringr)
library(rcompanion)

#############Plotting elongation as boxplots and associated statistics
#Importing txt file (tab delimited)
growth <- read.delim("...r.txt", stringsAsFactors=TRUE)

#Print name of the lines x conditions to reorder them
print(levels(growth[,2]))

#Reordering names (R puts everything in alphabetical order)
order=c("col_cm","col_iaa","aha_cm","aha_iaa","pp2c_cm","pp2c_iaa")
growth[,2]<-factor(growth[,2],levels=order)

#Choose color for boxplots
colors=c("#5b9bd5ff","#c1d63dff")

#Plotting
boxplot(growth[,4]~growth[,2],ylim=c(0,5),cex.lab=1.5, cex.axis=1.5, 
        cex.main=1.5, cex.sub=1.5,las=1,xlab="",ylab="",frame=F,col=colors)  

#Adding individual points on boxplot
stripchart(growth[,4]~growth[,2], vertical = TRUE, data = growth, add = TRUE, 
           pch = 20, col = "grey",method = "jitter",cex=1.5)

#Non parametric test
a=nparcomp(growth[,4]~growth[,2],data=growth,type = "Tukey")
summary(a)

#Transform comparison p-value from previous test into a compact letter display to assign
#conditions to statistical groups represented by letters
aa <- a$connames
ii=1
aa2=vector()
for (i in aa){
  i=str_remove_all(i, "[p( ]")
  i=str_remove_all(i, "[)]")
  i=str_replace_all(i,","," - ")
  i=str_replace_all(i,"_","")
  aa2[ii]=i
  ii=ii+1
}
pv <- a$Analysis$p.Value
cldList(comparison=aa2,p.value=pv)