#Import libraries
library(nparcomp)
library(stringr)
library(rcompanion)

#Compare line plots (here fluorescence pH ratio along the root)
growth <- read.delim("...python.txt", stringsAsFactors=TRUE)

#This tests was carried out to compare several genotypes in one condition (e.g. control or IAA)
#And for one genotype in control and IAA treatment

#Script exemplified with the control condition for col0, aha and pp2cd triple mutant
#Extraction of the control conditions
order=c("col_cm","aha_cm","pp2c_cm")
growth[,1]<-factor(growth[,1],levels=order)

#Script to perform repetitive non parametric t test on every root position between the two genotypes
test=growth
yy=2
listp_aha=c()
listp_pp2c=c()
liststars_aha=c()
liststars_pp2c=c()
while( yy<=ncol(test)){
  a=nparcomp(test[,yy]~test[,1],data=test,type = "Dunnett")
  print(a$Analysis$p.Value)
  listp_aha=c(listp_aha,a$Analysis$p.Value[1])
  listp_pp2c=c(listp_pp2c,a$Analysis$p.Value[2])
  if(a$Analysis$p.Value[1]<0.05){
    liststars_aha=c(liststars_aha,"*")
  }else{
    liststars_aha=c(liststars_aha,"NS")
  }
  if(a$Analysis$p.Value[2]<0.05){
    liststars_pp2c=c(liststars_pp2c,"*")
  }else{
    liststars_pp2c=c(liststars_pp2c,"NS")
  }
  yy=yy+1
}
listp_aha
liststars_aha
listp_pp2c
liststars_pp2c
listd=colnames(test)
listd=listd[-1]
final=data.frame(listd,listp_aha,liststars_aha,listp_pp2c,liststars_pp2c)
#Output a table with the list of distance from the root tip, list of the p-values for each test, list of stars (*,** or ***)
#Also output the difference between conditions
listp_aha
liststars_aha
listp_pp2c
liststars_pp2c
listd=colnames(test)
listd=listd[-1]
final=data.frame(listd,listp_aha,liststars_aha,listp_pp2c,liststars_pp2c)
write.table(final,"...cm_statlines.txt",sep="\t",row.names=FALSE)