#Import libraries
library(nparcomp)
library(stringr)
library(rcompanion)

#Compare line plots (here fluorescence pH ratio along the root)
growth <- read.delim("...python.txt", stringsAsFactors=TRUE)

#This tests was carried out to compare several genotypes in one condition (e.g. control or IAA)
#And for one genotype in control and IAA treatment

#Script exemplified with the control condition for col0 and tir triple mutant
#Extraction of the control conditions
order=c("col_cm","tir_cm")
growth[,1]<-factor(growth[,1],levels=order)

#Script to perform repetitive non parametric t test on every root position between the two genotypes
test=growth
yy=2
listp=c()
liststars=c()
listdelta=c()
while( yy<=ncol(test)){
  a=npar.t.test(test[,yy]~test[,1],data=test)
  print(a$Analysis$p.Value)
  listp=c(listp,a$Analysis$p.Value)
  if(a$Analysis$p.Value<0.05){
    liststars=c(liststars,"*")
  }else{
    liststars=c(liststars,"NS")
  }
  b=aggregate(test[,yy], list(test[,1]), FUN=mean)
  listdelta=c(listdelta,sqrt((b$x[1]-b$x[2])^2))
  yy=yy+1
}
#Output a table with the list of distance from the root tip, list of the p-values for each test, list of stars (*,** or ***)
#Also output the difference between conditions
listp
liststars
listd=colnames(test)
listd=listd[-1]
final=data.frame(listd,listp,liststars,listdelta)
write.table(final,"...cm_statlines.txt",sep="\t",row.names=FALSE)