dir = getDirectory ("Choose a directory");
newfilelist = getFileList(dir);
run("Set Measurements...", "area mean fit perimeter redirect=None decimal=3");
// build array containing valid filenames only (ending with .tif)
numvalidfiles=0;
for (c=0; c<newfilelist.length; c++) {
	if (endsWith(newfilelist[c], ".tif")) {
		numvalidfiles++;
	}
}
if (numvalidfiles==0) {
	showMessage("Fail - could not find any valid Image files (ending with .tif)!");
	close();
}
filelist = newArray(numvalidfiles);
fileIDx=0;
for (c=0; c<newfilelist.length; c++) {
	if (endsWith(newfilelist[c], ".tif")) {
		filelist[fileIDx]=newfilelist[c];
		fileIDx++;
	}
}
//iterating valid files.
for (c=0; c<filelist.length; c++) {
	//creates output folder and converts tif to 8-bits
	print(" ");
	print("Analysis of wing " + c+1);
	print(" ");
	print("Order of points: ACV L4; end L4; PCV L4; end L3 ; end L5; PCV L5;  Hinge L4");
	print(" ");
	open(dir + filelist[c]);
	run("8-bit");
	//gets image dimensions of original tif
	width = getWidth();
	height = getHeight(); //verschiebt ursprüngliches tif nach outputdirectory
	//sets backgroundcolor to app. the right grey value 
	makeRectangle(0,height*0.75,50,50);
	getStatistics(area, mean);
	setBackgroundColor(mean,mean,mean);
	do {
		//gets points on wings
		leftButton=16;
		rightButton = 4;
		insideROI = 32;
		ctrl = 2;
		x2=-1; y2=-1; z2=-1; flags2=-1;
		printed = false;
		currentpoint=0;
		maxpoints=4;
		xCoords = newArray(maxpoints);
		yCoords = newArray(maxpoints);
		while (currentpoint<maxpoints){
			if (!printed){
				print("Please select point " + (currentpoint+1));
				printed = true;	
			}
			getCursorLoc(x,y,z,flags);
			if (x!=x2 || y!=y2 || z!=z2 || flags!=flags2) {
				if (flags&leftButton!=0){
					print(x+" "+y+" "+z+" "+flags);
					xCoords[currentpoint] = x;
					yCoords[currentpoint] = y;	
					printed = false;
					currentpoint++;
				}	
			}
			x2=x; y2=y; z2=z; flags2=flags;
			//print(currentpoint);
		}
		
		wait(200);	//necessary, otherwise picture does not get rotated
		//Berechnung des Winkels der L4 Vene
		L4vectorx = xCoords[1]-xCoords[0];
		L4vectory = yCoords[1]-yCoords[0];
		L4vectorlength = sqrt(L4vectorx*L4vectorx+L4vectory*L4vectory);
		L4uniformvectorx = L4vectorx / L4vectorlength;
		L4uniformvectory = L4vectory / L4vectorlength;
		horizontalx = 1;
		horizontaly = 0;
		L4angleradians = acos(L4uniformvectorx * horizontalx + L4uniformvectory * horizontaly);
		L4angledeg = L4angleradians * 180 / PI;
		if (yCoords[0] < yCoords[1]) {
			L4angledeg = -L4angledeg;
			L4angleradians = -L4angleradians;
		}
		print("Rotation angle =" + L4angledeg);
		//Berechnung des Drehpunktes des ursprünglichen Bildes
		rotationcenterx = width / 2;
		rotationcentery = height / 2;
		//Rotation des Bildes
		print(getTitle());
		run("Rotate... ", "angle=&L4angledeg grid=1 interpolation=Bilinear fill enlarge");	
		//Berechnung des neuen Bildmittelpunktes
		widthnew = getWidth();
		heightnew = getHeight();
		rotationcenternewx = widthnew / 2;
		rotationcenternewy = heightnew / 2;
		for (i=0; i<maxpoints; i++){
			//Verschiebung des Rotationszentrums zum Ursprung
			x = (xCoords[i]-rotationcenterx);
			y = (yCoords[i]-rotationcentery);
			//Rotation der Koordinaten im alten Koordinatensystem
			xnew = x * cos(L4angleradians) - y * sin(L4angleradians);
			ynew = x * sin(L4angleradians) + y * cos(L4angleradians);
			//Rückverschiebung der Koordinaten
			xCoords[i] = xnew + rotationcenternewx;
			yCoords[i] = ynew + rotationcenternewy;	
			print("i: "+i + " x: " + xCoords[i] + " y: " + yCoords[i]);	
		}
		
		if (yCoords[3]<yCoords[0]){
			print("Turning image around");
			run("Flip Vertically");
			for (i=0; i<maxpoints; i++){
				yCoords[i] = abs(yCoords[i]-heightnew);
				print("i: "+i + " x: " + xCoords[i] + " y: " + yCoords[i]);		
			}		
		}
	} while (getBoolean("Rotation OK?")==0);	
//creates mask for wings

	currentMaskPoint=0;
	maxMaskPoints=200;
	xCoordsMask = newArray(maxMaskPoints);
	yCoordsMask = newArray(maxMaskPoints);
	runvariable = 0;
	//gets coordinates of wing outline for mask
	print("Please outline wing! Right click to proceed with analysis!");
	String.resetBuffer;
	while (currentMaskPoint < maxMaskPoints){
		if (!printed){
			print("Please select point " + (currentMaskPoint+1));
			printed = true;	
		}
		getCursorLoc(x,y,z,flags);
		if (x!=x2 || y!=y2 || z!=z2 || flags!=flags2) {
			leftbuttonpressed = flags&leftButton != 0;   
			// gets left mouse click/home/andreas/Desktop/60_pk_b_UAS-fj_dpp-Gal4_females with flags = 16
			isinsideROI = flags&insideROI != 0; 
			// creation of points creates ROI; filtered out in if clause below
			if (leftbuttonpressed && !isinsideROI){
				print(x+" "+y+" "+z+" "+flags);
				xCoordsMask[currentMaskPoint] = x;
				yCoordsMask[currentMaskPoint] = y;
				if (currentMaskPoint < 2){
					makeSelection("point", xCoordsMask, yCoordsMask);
				}
				if (currentMaskPoint >=2){
					String.resetBuffer;
					for (i=0; i < runvariable + 1; i++){
						if (i>0) {
							String.append(xCoordsMask[i-1] + "," + yCoordsMask[i-1] + ",");
						}
					String.append(xCoordsMask[i] + "," + yCoordsMask[i] + ",");
					}
					linearCoords = String.buffer;
					lengthlinearCoords = lengthOf(linearCoords);
					linearCoords = substring(linearCoords , 0 , lengthlinearCoords - 1);
					//eval("makePolygon("+ linearCoords +");");
					eval("makeLine("+ linearCoords +");");	
				}
				//setKeyDown("shift"); makePoint(x, y);	
				printed = false;
				currentMaskPoint++;
				runvariable++;
			}
			
			//rightButton click exits point selection tool for drawing the mask
			
			else if (flags&rightButton!=0){
				print("Please indicate region with distal hair orientation !");
				x2=-1; y2=-1; z2=-1; flags2=-1;
				while (currentMaskPoint < maxMaskPoints){
					getCursorLoc(x,y,z,flags);
					if (x!=x2 || y!=y2 || z!=z2 || flags!=flags2) {
						if (flags&leftButton != 0) {
							bluex = x;
							bluey = y;
							currentMaskPoint = maxMaskPoints;
						}
					}
				}	
			}
			
		}
		
		x2=x; y2=y; z2=z; flags2=flags;
	}
//trims coordinate arrays to number of really chosen points 

	xCoordsMask=Array.trim(xCoordsMask,runvariable);
	yCoordsMask=Array.trim(yCoordsMask,runvariable);
	
// creates coordinates for later cropping
	
	xmin = 0; ymin = 0; xmax = 0; ymax = 0;
	for (i = 1; i < runvariable; i++) {
		if (i==1) {
			xmin = minOf(xCoordsMask[i-1] , xCoordsMask[i]);
			ymin = minOf(yCoordsMask[i-1] , yCoordsMask[i]);
			xmax = maxOf(xCoordsMask[i-1] , xCoordsMask[i]);
			ymax = maxOf(yCoordsMask[i-1] , yCoordsMask[i]);	
		}
		if (i>1) {
			xmin = minOf(xmin , xCoordsMask[i]);
			ymin = minOf(ymin , yCoordsMask[i]);
			xmax = maxOf(xmax , xCoordsMask[i]);
			ymax = maxOf(ymax , yCoordsMask[i]);	 
		}
	}
	
// rescaling of coordinates to 300 pixels +/- the minimal and maximal chosen pixels

	if (xmin > 300) {
		xmin = xmin - 300;
	}
	else {xmin = 0;}
	if (widthnew - xmax > 300) {
		xmax = xmax + 300; 
	}
	else {xmax = widthnew;}
	if (ymin > 300) {
		ymin = ymin - 300;
	}
	else {ymin = 0;}
	if (heightnew - ymax > 300) {
		ymax = ymax + 300; 
	}
	else {ymax = heightnew;}

	setBatchMode(true);	

//crops image based on wing outline generated above

	print("Crop image at position " + xmin + " " + ymin + " " + xmax + " " + ymax);	
	makeRectangle(xmin , ymin , xmax - xmin , ymax - ymin);
	run("Crop");
	newname = File.nameWithoutExtension();
	outputdirectory = dir + "/" + newname;
	File.makeDirectory(outputdirectory);
	
//saves and closes rotated and cropped image as 8bit PNG
	
	
//compensates mask coordinates for image cropping

	for (i=0; i<xCoordsMask.length; i++) {
		xCoordsMask[i] = xCoordsMask[i] - xmin;
		yCoordsMask[i] = yCoordsMask[i] - ymin;
	}
	bluex = bluex - xmin;
	bluey = bluey - ymin;

	
	
	//moves original tif-image into outputdirectory
	File.rename(dir + "/" + filelist[c], outputdirectory + "/" + filelist[c]);
	//save after every iteration
		String.resetBuffer;
	for (i=0; i<xCoordsMask.length; i++){
		String.append(xCoordsMask[i] + "," + yCoordsMask[i]);
		if (i<xCoordsMask.length-1){
			String.append(",");
		}
	}
	linearCoords = String.buffer;
	//makes polygon according to the points selected previously
	eval("makePolygon("+ linearCoords +");");//interprets string as ImageJ Macro
	run("Measure");
	wait(200);
	saveAs("PNG", outputdirectory + "/wing");
	close();
	saveResults(filelist[c]);
	//runs analysis of wing hairs (program of Matthias)

	setBatchMode(false);
}
function getCVS(xCoords,yCoords) {
	dxCoords=xCoords[0] - xCoords[2];
	dyCoords=yCoords[0]-yCoords[2];
	cvs = sqrt((dxCoords*dxCoords) + (dyCoords*dyCoords));
	return round(cvs);
}
//calculate hinge anterior cross vein distance
function getHACVD(xCoords,yCoords) {
	dxCoords=xCoords[3] - xCoords[0];
	dyCoords=yCoords[3] - yCoords[0];
	hacvd = sqrt((dxCoords*dxCoords) + (dyCoords*dyCoords));
	return round(hacvd);
}
//calculate posterior cross vein - end L4 acvdd = posterior cross vein... did not rename
function getACVDD(xCoords,yCoords) {
	dxCoords=xCoords[3] - xCoords[1];
	dyCoords=yCoords[3]-yCoords[1];
	acvdd = sqrt((dxCoords*dxCoords) + (dyCoords*dyCoords));
	return round(acvdd);
}
//calculate distance from end of L5 to intersection of PCV and L5 only .... CAUTION !!!! ONLY renamed header later (not the function), when building results
function getLL3(xCoords,yCoords) {
	dxCoords=xCoords[2]-xCoords[3];
	dyCoords=yCoords[2]-yCoords[3];
	LL3 = sqrt((dxCoords*dxCoords) + (dyCoords*dyCoords));
	return round(LL3);
}
//calculate get length of L4 vein
function getLL4(xCoords,yCoords) {
	dxCoords=xCoords[2] - xCoords[1];
	dyCoords=yCoords[3]-yCoords[1];
	LL4 = sqrt((dxCoords*dxCoords) + (dyCoords*dyCoords));
	return round(LL4);
}
function getGender(filename) {
	m2=lastIndexOf(filename,".")-1;
	m3=lastIndexOf(filename,".")-2;
	m4=lastIndexOf(filename,".")-3;
	//determine gender of animal based on filename
	if ((substring(filename,m3,m2)=="F") || (substring(filename,m4,m3)=="F"))
	{	
		return "Female";
	}
	else if ((substring(filename,m3,m2)=="M") || (substring(filename,m4,m3)=="M"))
	{	
		return "Male";
	}
	else
	{
		return "NA";
	}		
}
function buildResult (start, filename) {
	header=newArray("Area", "Mean", "Perim.", "Major", "Minor", "Angle");
	//add new header elements in extraheader
	extraheader=newArray("Gender", "CVS", "HiBiACV", "ACVdiT", "PCV_eL5", "Length_L4");
	result="";
	//create header
	if (start<2){
		result="File";
		for (i=0; i<header.length; i++){
			result=result + " " + header[i];
		}
		for (i=0; i<extraheader.length; i++){
			result=result + " " + extraheader[i];
		}
		result=result + "\n";
	}
	//create entries
	for (i=0; i<nResults; i++)
	{	
		line= "" + filename;
		//iterate header elements but last one
		for (j=0; j<header.length; j++)
		{	
			res=getResult(header[j],i);
			line=line + " " + res;
		}
		//create last element invidividually, expects one results entry for each filelist entry
		line = line + " " + getGender(filename) + " " + getCVS(xCoords,yCoords) + " " + getHACVD(xCoords,yCoords) + " " 
		+ getACVDD(xCoords,yCoords) + " " + getLL3(xCoords,yCoords) + " " + getLL4(xCoords,yCoords);
		result=result+line+"\n";
		start++;
	}
	print(result);
	return result;
}	
//saves measurements area mean fit
function saveResults(filename) {
	pathf= dir + "Results.txt";
	if (File.exists(pathf)) 
	{	
		content=File.openAsString(pathf);
		lines=split(content,"\n");
		start=lines.length;
		result=buildResult(start, filename);
		result=content+result;	
		File.saveString(result, pathf);
	}
	else
	{
		result=buildResult(1, filename);
		File.saveString(result, pathf);
	}
	selectWindow("Results");
	run("Close");
}
print("Romina is finished");
