//@File (style="directory") dir

/* Macro written by R. Piscitello
 * The macro is used to recusively draw kymographs of the ablation movies .tifs.
 * This macro opens .tif files from a given dir.
 * The user must draw a line that will be used to draw a kymograph.
 * The ROI of the kymograph will be automatically saved with the image name.
 * The kymograph will also be saved in the same dir.
 */

print("\\Clear");

// Get list of files in a given dir
list = getFileList(dir);

// Go recusively through these files
for (i=0; i < list.length; i++){
	name = list[i];
	dir_analyse = dir + "/" + name;
	
	// Identify .tif files in dir
	if (endsWith(name, ".tif") == 1){
		open(dir_analyse);

		// Store file name
		file_name = File.name;
		
		//setTool("line");
		// Ask user to draw the kymograph
		waitForUser("Draw line for kymograph");  //wait for user action
		run("Multi Kymograph", "linewidth=1"); // show the kymograph

		// Fix the brightness/contrast of the image to highlight the membranes
		//run("Brightness/Contrast...");
		waitForUser("Adjust contrast");  //wait for user action
		run("Rotate 90 Degrees Left"); // rotate kymograph
		// Save kymograph in the same dir
		saveAs("Jpeg", dir + "/Kymograph_" + substring(name, 0, (lengthOf(file_name)-4)) + ".jpg");
		//run("Save", "save=[" + dir + "/" + "Kymograph_" + file_name + "]");
		close();

		// Add the ROI of the kymograph to the ROIManager
		roiManager("Add");
		length_roi = roiManager("count") - 1;
		roiManager("Select", length_roi);
		// Change the name of the ROI depending on the file name
		name_kymograph_roi = "kymograph_" + substring(name, 0, (lengthOf(file_name)-4));
		roiManager("Rename", name_kymograph_roi);

		roiManager("Deselect");
		// Save ROI Manager
		roiManager("Save", dir + "/RoiSet.zip");

		run("Close All");
		}
}

selectWindow("ROI Manager");
run("Close");

print("DONE!");