%%
clc;
clear;

%%
%Specify folder where kymographs have been saved with draw_kymographs.ijm
%macro
read_folder = '/Volumes/project_romina_wing/laser_cuts_pk_stbm_wt_fmi/pupal_wing_line_cuts/APoriented_analyzed_cuts/10um_BladeControlAndpkRNAi_oneplane_2003and04and08and10/10um_nabGal4_EcadGFP_UASpkRNAi11099_28hAPF_oneplane_201015';
genotype = '201015_nabGal4_EcadGFP_UASpkRNAi11099_28hAPF_';
% 10um_MTdp_20hAPF_oneplane_200211

cd(read_folder);
%Ablation_files = dir('');
kymo_files = dir('Kymograph_*.jpg');
%kymo_files = dir('Kymograph_*.tif');
%after_ellipse_file1s = dir('*after*.tif');
pixel = 0.21;
%loop time of the image acquisiton
dt = 0.085;

N = numel(kymo_files);

for i=1:N
    Maj = imread(kymo_files(i).name);
    %E = imread(after_ellipse_files(i).name);
    % Maj axis velocity
    %Maj1 = imadjust(Maj);
    imshow(Maj,[]);
    h1 = imline(gca,[]);
    api = iptgetapi(h1);
    pos1 = api.getPosition();
    x1 = pos1(1,1);
    x2 = pos1(2,1);
    y1 = pos1(1,2);
    y2 = pos1(2,2);
    vel1 = abs(((y2-y1)*pixel)/((x2-x1)*dt));
    
    %Min axis Velocity
    %Min1 = imadjust(Min);
    imshow(Maj,[]);
    h2 = imline(gca,[]);
    api = iptgetapi(h2);
    pos2 = api.getPosition();
    x1 = pos2(1,1);
    x2 = pos2(2,1);
    y1 = pos2(1,2);
    y2 = pos2(2,2);
    vel2 = abs(((y2-y1)*pixel)/((x2-x1)*dt));
    
    % Maj and minor axis lengths
    %E1 = ~E;
    %stat = regionprops(E1,'Area','Centroid','MajorAxisLength','MinorAxisLength','Orientation');
    %maj_axis = (stat.MajorAxisLength)*pixel;
    %min_axis = (stat.MinorAxisLength)*pixel;
    %Ang = stat.Orientation;
    
    % Iso and Aniso Vel
    rec_vel = 0.5*(vel1+vel2);
    
    filename = strcat(genotype,kymo_files(i).name,'.mat');
    %save(filename,'maj_axis','min_axis','Ang','vel_maj','vel_min','vel_maj_norm','vel_min_norm','v_iso','v_aniso');
    save(filename,'vel1','vel2','rec_vel');
end

disp("DONE!!!!")