##### Figure 4 - Source code 1
import matplotlib.pyplot as plt
import cv2
from skimage import morphology
import matplotlib.colors as colors
import pandas as pd
import seaborn as sns
from scipy import stats

grid = plt.GridSpec(36, 7, wspace = 0.5, hspace = 0.1)
plt.figure(figsize = (6,10))


import numpy as np
import matplotlib.pyplot as plt
L0_ss, L0_over = (0.44833031967705606, 0.47600903235641023)
L0 = (L0_ss + L0_over)/2
Lambda_ss, Lambda_over = (8.054018483265969, 10.373640081366128)
A_ss, k_ss, n_ss = 0.29090909, 0.04479021, 6.8
A_over, k_over, n_over = 0.23718732, 0.04830006, 4.62115618


def signal2fit(Hh, A, k, n):
    return A/(np.power(k/Hh, n)+ 1)
def Hh2fit(x, L0, Lambda):
    return L0*np.exp(-x/Lambda)
h, l = 80, 100
x = np.array([i for i in range(l)])

Hh_ss = Hh2fit(x, L0, Lambda_ss)
Hh_over = Hh2fit(x, L0, Lambda_over)

# figura 4A
ax1 = plt.subplot(grid[0:6,0:3])
plt.plot(Hh_ss)

plt.plot([34],[Hh_ss[34]], "r.")

m2 = (Hh_ss[35] - Hh_ss[33])/2
x2 = np.linspace(25,45, 10)
y2 = m2*(x2 - 34) + Hh_ss[34]
plt.plot(x2, y2, "r")
plt.plot([34,34], [-0.05,Hh_ss[34]], "--r")

plt.xlabel("x $(\mu m)$")
plt.ylabel("[Hh]")
plt.title("Hh Steady State")
plt.ylim(-0.03,0.5)
plt.text(22, -0.12, "dpp" )


# figura 4B
ax2 = plt.subplot(grid[0:6,4:7])
plt.plot(Hh_over)

plt.plot([34],[Hh_over[34]], "r.")

m1 = (Hh_over[35] - Hh_over[33])/2
x1 = np.linspace(25,45, 10)
y1 = m1*(x1 - 34) + Hh_over[34]

plt.plot(x1, y1, "r")
plt.plot([34,34], [-0.05,Hh_over[34]], "--r")
plt.ylim(-0.03,0.5)
plt.xlabel("x $(\mu m)$")
plt.ylabel("[Hh]")
plt.title("Hh Overshoot")
plt.text(22, -0.12, "dpp" )




# figura 4C
ax3 = plt.subplot(grid[9:15,0:7])
img = cv2.imread("def_SD.png")
img = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
plt.imshow(img, interpolation='nearest')
plt.axis("off")

# figura 4D
ax4 = plt.subplot(grid[16:22,0:2])
img_col = cv2.imread(r"MAX_C1-Hh2X_12_col.tif", cv2.IMREAD_ANYDEPTH)

mygreens = colors.LinearSegmentedColormap.from_list('mygreens', ['#000000', '#00FF00'])
myreds = colors.LinearSegmentedColormap.from_list('mygreens', ['#000000', '#FF0000'])

footprint = morphology.disk(3)
res = morphology.white_tophat(img_col, footprint)
img_col = img_col - res
img_col = img_col[520:790, 400:550]
plt.imshow(img_col, cmap = mygreens)
plt.axis("off")


# figura 4E
ax5 = plt.subplot(grid[23:29,0:2])
img_dpp = cv2.imread(r"MAX_C2-Hh2X_12_dpp.tif", cv2.IMREAD_ANYDEPTH)
footprint = morphology.disk(3)
res = morphology.white_tophat(img_dpp, footprint)
img_dpp = img_dpp - res
img_dpp = img_dpp[520:790, 400:550]
plt.imshow(img_dpp, cmap = myreds) 
plt.axis("off")


# figura 4F
ax6 = plt.subplot(grid[30:36,0:7])
datos2 = pd.read_csv("datos_SD_WT_simulaciones_filtrados.csv")
my_pal = {"col(hh+/+)":"green", "col2x_sim":"green", "dpp(hh+/+)":"red" , "dpp2x_ss_sim":"red", "dpp2x_over_sim":"red"}
sns.boxplot(data = datos2, x = "case", y = "SD", order = ["col(hh+/+)", "col2x_sim", "dpp(hh+/+)","dpp2x_over_sim", "dpp2x_ss_sim"] ,showfliers = False,  palette = my_pal)
plt.ylabel("$\sigma_x$ $(\mu m)$")
plt.xlabel("")
plt.xticks([0,1,2,3,4], ["exp", "over-SS", "exp", "over", "SS"])


col_exp = datos2[datos2["case"] == "col(hh+/+)"]["SD"]
col_sim = datos2[datos2["case"] == "col2x_sim"]["SD"]
dpp_exp = datos2[datos2["case"] == "dpp(hh+/+)"]["SD"]
dpp_over_sim = datos2[datos2["case"] == "dpp2x_over_sim"]["SD"]
dpp_ss_sim = datos2[datos2["case"] == "dpp2x_ss_sim"]["SD"]

p_col = stats.mannwhitneyu(col_exp, col_sim)[1]
p_dpp_over = stats.mannwhitneyu(dpp_exp, dpp_over_sim)[1]
p_dpp_ss = stats.mannwhitneyu(dpp_exp, dpp_ss_sim)[1]

p_dpp_col_exp = stats.mannwhitneyu(col_exp, dpp_exp)[1]
p_dppOver_colExp = stats.mannwhitneyu(dpp_over_sim, col_exp)[1]

median_col_exp = np.median(col_exp)
median_col_sim = np.median(col_sim)

median_dpp_exp = np.median(dpp_exp)
median_dpp_over_sim = np.median(dpp_over_sim)
median_dpp_ss_sim = np.median(dpp_ss_sim)

# diferencia entre medianas
plt.plot([4.7,4.7], [median_dpp_exp, median_dpp_ss_sim], "k")
plt.plot([4.6, 4.7], [median_dpp_exp, median_dpp_exp], "k")
plt.plot([4.6, 4.7], [median_dpp_ss_sim, median_dpp_ss_sim], "k")

plt.plot([3.7, 3.7], [median_dpp_over_sim, median_dpp_exp], "k")
plt.plot([3.6, 3.7], [median_dpp_exp, median_dpp_exp], "k")
plt.plot([3.6, 3.7], [median_dpp_over_sim, median_dpp_over_sim], "k")

plt.text(4.8, 5, "$\Delta x$" )
plt.text(4.8, 3.0, "1.96")
plt.text(3.8, 1.6, "0.77")

#plt.plot([-0.7, -0.7], [median_col_sim, median_col_exp], "k")
#plt.plot([-0.7, -0.6], [median_col_sim, median_col_sim], "k")
#plt.plot([-0.7, -0.6], [median_col_exp, median_col_exp], "k")

#plt.text(-1.1, 1.8, "0.16")



print("p_col = ", p_col)
print("p_dpp_over = ", p_dpp_over)
print("p_dpp_ss = ", p_dpp_ss)

print("p_dpp_col_exp = ", p_dpp_col_exp)
print("p_dppOver_colExp = ", p_dppOver_colExp)

print("shapiro col_exp = ", stats.shapiro(col_exp))
print("shapiro col_sim = ", stats.shapiro(col_sim))


print("shapiro dpp_exp = ", stats.shapiro(dpp_exp))
print("shapiro dpp_over_sim = ", stats.shapiro(dpp_over_sim))
print("shapiro dpp_ss_sim = ", stats.shapiro(dpp_ss_sim))

plt.plot([0,1],[2.4,2.4], "k")
plt.text(0.3, 2.8, "ns")

plt.plot([2,3], [5.4,5.4], "k")
plt.text(2.3, 5.5, "**")

plt.plot([2,4], [6.4, 6.4], "k")
plt.text(3, 6.8, "**")

plt.ylim(0, 8)
plt.xlim(-0.6,5.4)
plt.xticks([0,1,2,3,4], ["exp", "sim", "exp", "", ""])
plt.text(3.24, -1.58, "sim")
plt.text(2.7, -2.9, "over")
plt.text(3.9, -2.9, "ss")
ax2 = plt.axes([0,0,1,1], facecolor=(1,1,1,0))
ax2.axis("off")
