

using Plots, StatsBase, Statistics, DelimitedFiles

N_C = 118
N_F = 19

N1 = N_C + N_F

Next=103

epsi=1e-3

xF = 0.5636
xC = 0.5636

lambda=3

pdF = 2.4e-6

pdC = 5.0e-5

pdCplus = 2.0e-4

sigma=3

pF = 0.0

pC = 5e-5
#pC = 0.0

pCsF = 2.0e-4
#pCsF = 1.25e-2

pistaF = 9.12e-5
pistaC = 0.0140
piexaF = 2.2e-3
piexaC = 0.0
#teta = 1.1e-4
NiexaF = 1

test1, test2 = true, true


function distance(p::Int, q::Int, r::Int, s::Int)::Int
    return Int(floor(sqrt((r-p)^2+(s-q)^2)))
end

function fF(i::Int)::Float64
    if i==4 || i ==5
        return 1
    else
        return epsi
    end
end

function fC(i::Int)::Float64
    if i==4 || i ==5
        return 1
    else
        return epsi
    end
end

function b_member(p::Int, q::Int)::Bool
    if  38 <= distance(p,q,52,52) <= 50
        return true
    else
        return false
    end
end

function num2col(i)
    if i == 1
        return colorant"green"
    elseif i == 11
        return colorant"chartreuse"
    elseif i == 2
        return colorant"indianred"
    elseif i == 22
        return colorant"firebrick3"
    elseif i == 3
        return colorant"cyan2"
    else
       return colorant"white" 
    end
end


function _neighbor_countF(i::Int,j::Int)::Int
    return count(x->(x==1 || x==11), [A[i-1,j-1],A[i-1,j],A[i-1,j+1],A[i,j-1],A[i,j+1],A[i+1,j-1],A[i+1,j],A[i+1,j+1]])
end

function _neighbor_countC(i::Int,j::Int)::Int
    return count(x->(x==2 || x==22), [A[i-1,j-1],A[i-1,j],A[i-1,j+1],A[i,j-1],A[i,j+1],A[i+1,j-1],A[i+1,j],A[i+1,j+1]])
end

function _neighbor_count(i::Int,j::Int)::Int
    return count(x->(x==1 || x==2|| x==11 || x==22), [A[i-1,j-1],A[i-1,j],A[i-1,j+1],A[i,j-1],A[i,j+1],A[i+1,j-1],A[i+1,j],A[i+1,j+1]])
end

function random_peribr2()
    cpt=0
    M=zeros(Next,Next);
    while cpt < N_F
        p, q = rand(1:Next), rand(1:Next)
        if b_member(p,q) && M[p,q]==0
            M[p,q] =1
            cpt+=1
        end
    end
    cpt=0
    while cpt < N_C
        p, q = rand(1:Next), rand(1:Next)
        if b_member(p,q) && M[p,q]==0
            M[p,q] =2
            cpt+=1
        end
    end    
    for k=1:Next, l=1:Next
        if !b_member(k,l)
            M[k,l]=7
        end
    end
    return Int.(M)
end

function moveF(i::Int,j::Int)
#    Dictio=Dict((i,j)=>x_F);
    Dictio=Dict();
    for p=i-1:i+1, q=j-1:j+1
        if A[p,q]==0
            push!(Dictio,(p,q)=>fF(count(x->(x==2 || x==22), [A[p-1,q-1],A[p-1,q],A[p-1,q+1],A[p,q-1],A[p,q+1],A[p+1,q-1],A[p+1,q],A[p+1,q+1]])))
        end
    end
    if ~isempty(Dictio)
        x_F = ((1-0.9342)/0.9342)*sum(values(Dictio))
        push!(Dictio,(i,j)=>x_F)
#    c=1/sum(values(Dictio))
#    [Dictio[key]*=c for key in keys(Dictio)]
        (p,q)=sample(collect(keys(Dictio)),Weights(Float64.(collect(values(Dictio)))))
        A[i,j], A[p,q] = 0, 1
    end
end

function moveC(i::Int,j::Int)
#    Dictio=Dict((i,j)=>x_C);
    Dictio=Dict();
    for p=i-1:i+1, q=j-1:j+1
        if A[p,q]==0 
            push!(Dictio,(p,q)=>fC(count(x->(x==1 || x==2|| x==11 || x==22), [A[p-1,q-1],A[p-1,q],A[p-1,q+1],A[p,q-1],A[p,q+1],A[p+1,q-1],A[p+1,q],A[p+1,q+1]])))
        end
    end
    if ~isempty(Dictio)
        x_C = ((1-0.9342)/0.9342)*sum(values(Dictio))
        push!(Dictio,(i,j)=>x_C)
#    c=1/sum(values(Dictio))
#    [Dictio[key]*=c for key in keys(Dictio)]
        (p,q)=sample(collect(keys(Dictio)),Weights(Float64.(collect(values(Dictio)))))
        A[i,j], A[p,q] = 0, 2 
    end
end

function listMoore(i,j)
tab=[]
for k=i-1:i+1
    for l=j-1:j+1
        if ((k,l) != (i,j)) && (A[k,l]==1 || A[k,l]==2)
            push!(tab,(k,l))
        end
    end
end
return tab
end

function connectedCells(i,j)
tab=[]
push!(tab,(i,j))
tab1=listMoore(i,j)
for k=1:size(tab1,1)
    push!(tab,tab1[k])
end
sizetest=0
while size(tab,1) > sizetest
    sizetest = size(tab,1)
    for k=1:size(tab,1)
        tab1=listMoore(tab[k][1],tab[k][2])  
        for l=1:size(tab1,1)
            push!(tab,(tab1[l][1],tab1[l][2]))
        end
    end
    tab=unique!(tab)
end
return tab
end


function numberOfClusters(A)
sociableCells = Dict()
for k=1:Next, l=1:Next
    if A[k,l] ==1 || A[k,l] == 2
        if length(listMoore(k,l)) >= 1
            sociableCells[(k,l)]=A[k,l]
        end
    end
end
sociableCells2 = copy(sociableCells)
A2 = copy(A)
listClusters=[]
while !isempty(sociableCells)
    tmp=rand(keys(sociableCells))
    push!(listClusters,connectedCells(tmp[1],tmp[2]))
    tab=connectedCells(tmp[1],tmp[2])
    for k=1:length(tab)
        if tab[k] in keys(sociableCells)
            pop!(sociableCells,tab[k])
        end
    end
end
return length(listClusters)
end

function listOfCluster(A)
sociableCells = Dict()
for k=1:Next, l=1:Next
    if A[k,l] ==1 || A[k,l] == 2
        if length(listMoore(k,l)) >= 1
            sociableCells[(k,l)]=A[k,l]
        end
    end
end
sociableCells2 = copy(sociableCells)
A2 = copy(A)
listClusters=[]
while !isempty(sociableCells)
    tmp=rand(keys(sociableCells))
    push!(listClusters,connectedCells(tmp[1],tmp[2]))
    tab=connectedCells(tmp[1],tmp[2])
    for k=1:length(tab)
        if tab[k] in keys(sociableCells)
            pop!(sociableCells,tab[k])
        end
    end
end
return listClusters
end

numFile = parse(Int64,ARGS[1])

A = random_peribr2()

insidePeribronch = []
for k=1:Next, l=1:Next
    if b_member(k,l)
        push!(insidePeribronch,(k,l))
    end
end


#nbrePeriods = 862500
#nbrePeriods = 3504000
nbrePeriods = 3504000




histoN1 = Array{Int64}(undef, nbrePeriods)

#@elapsed for k=1:10
cptMortF=0
cptMortCsimple, cptMortCinduite = 0, 0
cptInfiltrF=0
cptInfiltrC=0
cptDuplbasale, cptDuplinduite = 0, 0
cptMortCinfSigma=0
cptMortCsupSigma=0
numClusters=0
numberF_clusters=0
numberC_clusters=0
numberMixed_clusters=0
cptExacerbF=0
mortC = true


start = time()
#anim = @animate for k=1:960

for k=1:nbrePeriods
#println("k=$k, N1=$N1, N_C=$N_C, cptInfiltrC=$cptInfiltrC, cptDupl=$cptDupl, cptMortC=$cptMortC, cptInfiltrF=$cptInfiltrF, cptMortF=$cptMortF, numClusters=$numClusters, numberF_clusters=$numberF_clusters, numberC_clusters=$numberC_clusters, numberMixed_clusters=$numberMixed_clusters")
println("k=$k, N_C=$N_C")
#println("k=$k")
# Exacerbation (cellules F)
    if (k==1 || mod(k,175200)==0) &&  k < nbrePeriods
        if rand() <= piexaF
            for l = 1:NiexaF
                global cptExacerbF+=1
                (p1,q1)=sample(insidePeribronch)
                while A[p1,q1] != 0
                    (p1,q1)=sample(insidePeribronch)
                end
                A[p1,q1]=11
            end
        end
    end
# Infiltration d'une cellule F (état stable)
        if rand() <= pistaF
            global cptInfiltrF+=1
            (p1,q1)=sample(insidePeribronch)
            while A[p1,q1] != 0
                (p1,q1)=sample(insidePeribronch)
            end
            A[p1,q1]=11
        end 
# Infiltration d'une cellule C (état stable)
        if rand() <= pistaC
            global cptInfiltrC+=1
            (p1,q1)=sample(insidePeribronch)
            while A[p1,q1] != 0
                (p1,q1)=sample(insidePeribronch)
            end
            A[p1,q1]=22
        end       

# Boucle des N1 sous-périodes

    for l=1:N1
# Mort, duplication, déplacement d'une cellule
##############################################
# Maintenant, on tire une cellule de type F (étiquette 1) ou C (étiquette 2) ou morte (étiquette 3)
#   Elle va peut-être mourir, se dupliquer ou se déplacer.
        (p1,q1)=sample(insidePeribronch)
        while A[p1,q1] ∉ (1,2,3)
            (p1,q1)=sample(insidePeribronch)
        end
        if A[p1,q1] == 1
            if rand() <= pdF
                global cptMortF+=1
                A[p1,q1] = 3
            else
                moveF(p1,q1)
            end
        elseif A[p1,q1] == 2
            if _neighbor_countC(p1,q1) < sigma
                if rand() <= pdC
                    global cptMortCsimple+=1
                    A[p1,q1] = 3
                end
            else 
                if rand() <= pdCplus
                    println("mort pdCplus")
                    global cptMortCinduite+=1
                    A[p1,q1] = 3
                end
            end
            if A[p1,q1] == 2 # on vérifie ici que la cellule C n'est pas morte à l'étape précédente
                B=A[p1-1:p1+1,q1-1:q1+1]
                Aindex = findall(B.==0)
                global test1  = true
                if size(Aindex,1)!=0
                    for k1 in p1-1:p1+1
                        for k2 in q1-1:q1+1
                            if test1 && A[k1,k2]==0 && _neighbor_countC(k1,k2) < lambda
                                global test1 = false
                                if _neighbor_countF(p1,q1) > 0
                                   if rand() <= pCsF
                                        println("on duplique !!")
                                        T2=sample(Aindex)
                                        B[2,2], B[T2[1],T2[2]] = 22, 22
                                        global cptDuplinduite+=1
                                        A[p1-1:p1+1,q1-1:q1+1] = B
                                    else
                                        moveC(p1,q1)
                                    end
                                elseif _neighbor_countF(p1,q1) == 0
                                   if rand() <= pC
                                        println("on duplique !!")
                                        T2=sample(Aindex)
                                        B[2,2], B[T2[1],T2[2]] = 22, 22
                                        global cptDuplbasale+=1
                                        A[p1-1:p1+1,q1-1:q1+1] = B
                                    else
                                        moveC(p1,q1)
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end

# Transformation des 3, 11, 22 ... en 0, 1, 2...  et mise à jour de N1
    A[findall(A.==3)] .= 0
    A[findall(A.==11)] .= 1
    A[findall(A.==22)] .= 2
    global N1 = size(union(findall(A.==1),findall(A.==2)),1)
    
    global numClusters=numberOfClusters(A)
    
    global numberF_clusters=0
    global numberC_clusters=0
    global numberMixed_clusters=0
    
    clusters = listOfCluster(A)
    
    for k1=1:length(clusters)
        nn1, nn2 = 0, 0
        for l1=1:length(clusters[k1])
            if A[clusters[k1][l1][1],clusters[k1][l1][2]]==1
                nn1+=1
            elseif A[clusters[k1][l1][1],clusters[k1][l1][2]]==2
                nn2+=1
            end
        end
        if nn1 >= 1 && nn2 == 0
            global numberF_clusters+=1
        elseif nn1 == 0 && nn2 >= 1
            global numberC_clusters+=1
        elseif nn1 >= 1 && nn2 >= 1
            global numberMixed_clusters+=1
        end
    end
    histoN1[k]=N1
    
    global N_F = size(findall(A.==1),1)
    global N_C = size(findall(A.==2),1)
    
 #   display(plot(num2col.(A),axis=false,title = "k = $k N1=$N1 Dupl=$cptDupl InfiltrF=$cptInfiltrF InfiltrC=$cptInfiltrC\n MortF=$cptMortF MortC=$cptMortC numClusters=$numClusters")) 
    
    f1=open("resCompletTemporel$numFile.txt","a+");
    println(f1,"$N1\t$N_C\t$cptInfiltrC\t$cptDuplbasale\t$cptDuplinduite\t$cptMortCsimple\t$cptMortCinduite\t$N_F\t$cptInfiltrF\t$cptMortF\t$numClusters\t$numberF_clusters\t$numberC_clusters\t$numberMixed_clusters\t$cptExacerbF")
    close(f1)
end

Mean=mean(histoN1)
println("Mean N1 : $Mean")

#f1=open("res.txt","a+");
#println(f1,"N1=$N1, cptInfiltrC=$cptInfiltrC, cptDupl=$cptDupl, cptMortC=$cptMortC, #cptInfiltrF=$cptInfiltrF, cptMortF=$cptMortF\n meanN1=$Mean")
#close(f1)


elapsed = time() - start
println("elapsed = $elapsed")
#display(plot(num2col.(A),axis=false,title = "Healthy, $nbrePeriods N1=$N1 Dupl=$cptDupl InfilF=$cptInfiltrF InfiltrC=$cptInfiltrC\n MortF=$cptMortF MortC=$cptMortC ( < sigma=$cptMortCinfSigma, >= sigma=$cptMortCsupSigma)")) 

#display(histogram(histoN1))
open("A$numFile.txt", "w") do io
       writedlm(io, A)
end

