##
## Status and physiological significance of circulating adiponectin in the very old and centenarians: an observational study
## Sasaki et al.
##

library(ggplot2)
library(dplyr)
library (exactRankTests)

## Fig.1d

## import data 
data <- read.csv("Figs1-3_SourceData1.csv")
## define data type
data$sex <- as.factor (data$sex)
xtabs (~group+sex, data)
summary (data)
## extract Very Old data
tmp <- data %>% dplyr::filter (group == "Cent") %>% select (sex, Adiponectin) %>% na.omit

## draw fig
g <- ggplot(tmp, aes(x=sex, y=Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/4), scale="area") 
g <- g + geom_boxplot (width=.1,fill=c("blue","red"), outlier.colour = NA)  # #008000 == green
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha=0.3)
g <- g + scale_x_discrete (labels=c ("men", "women"),limits = c("0","1"))
g <- g + scale_y_continuous (limits = c(0.1,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("sex")
g <- g + ggtitle ("The very old (85-89yo)")
plot(g) ## 500x800

## wilcox.exact
vx <- tmp$Adiponectin [tmp$sex == "0" ]
vy <- tmp$Adiponectin [tmp$sex == "1" ]
wilcox.exact(x=vx,y=vy,paired=F)


