##
## Status and physiological significance of circulating adiponectin in the very old and centenarians: an observational study
## Sasaki et al.
##

library(ggplot2)
library (dplyr)
library (exactRankTests)

## Fig.2d

## import data 
data <- read.csv("Figs1-3_SourceData1.csv")
## define data type
data$sex <- as.factor (data$sex)
xtabs (~group+sex, data)
summary (data)


##
## CDH13 (rs4783244)
## Fig.2d
##

## very old men
tmp <- data %>% dplyr::filter ((sex== "0") & (group == "VeryOld")) %>% select (rs4783244_num, Adiponectin) %>% na.omit
tmp$rs4783244_num <- as.factor (tmp$rs4783244_num)
xtabs (~rs4783244_num, tmp)

g <- ggplot(tmp , aes(rs4783244_num, Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="blue", alpha=I(1/3), outlier.color = NA)  
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("G/G", "G/T","T/T"),limits = c("0","1","2"))
g <- g + scale_y_continuous(limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("rs4783244")
g <- g + ggtitle ("Very old men")
plot(g)

vx <- tmp$Adiponectin [tmp$rs4783244_num == "0" ] 
vy <- tmp$Adiponectin [tmp$rs4783244_num == "1" ] 
vz <- tmp$Adiponectin [tmp$rs4783244_num == "2" ] 
length (vx)
length (vy)
length (vz)
wilcox.exact(x=vx,y=vy,paired=F)
wilcox.exact(x=vx,y=vz,paired=F)
wilcox.exact(x=vy,y=vz,paired=F)


## very old women
tmp <- data %>% dplyr::filter ((sex== "1") & (group == "VeryOld")) %>% select (rs4783244_num, Adiponectin) %>% na.omit
tmp$rs4783244_num <- as.factor (tmp$rs4783244_num)
xtabs (~rs4783244_num, tmp)

g <- ggplot(tmp , aes(rs4783244_num, Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="red", alpha=I(1/3),outlier.color = NA) 
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("G/G", "G/T","T/T"),limits = c("0","1","2"))
g <- g + scale_y_continuous(limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("rs4783244")
g <- g + ggtitle ("Very old women")
plot(g)

vx <- tmp$Adiponectin [tmp$rs4783244_num == "0" ] 
vy <- tmp$Adiponectin [tmp$rs4783244_num == "1" ] 
vz <- tmp$Adiponectin [tmp$rs4783244_num == "2" ] 
length (vx)
length (vy)
length (vz)
wilcox.exact(x=vx,y=vy,paired=F)
wilcox.exact(x=vx,y=vz,paired=F)
wilcox.exact(x=vy,y=vz,paired=F)


## Centenarian men
tmp <- data %>% dplyr::filter ((sex== "0") & (group == "Cent")) %>% select (rs4783244_num, Adiponectin) %>% na.omit
tmp$rs4783244_num <- as.factor (tmp$rs4783244_num)
xtabs (~rs4783244_num, tmp)

g <- ggplot(tmp , aes(rs4783244_num, Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="blue", alpha=I(1/3), outlier.color = NA) 
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("G/G", "G/T","T/T"),limits = c("0","1","2"))
g <- g + scale_y_continuous(limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("rs4783244")
g <- g + ggtitle ("Centenarian men")
plot(g)

vx <- tmp$Adiponectin [tmp$rs4783244_num == "0" ] 
vy <- tmp$Adiponectin [tmp$rs4783244_num == "1" ] 
vz <- tmp$Adiponectin [tmp$rs4783244_num == "2" ] 
length (vx)
length (vy)
length (vz)
wilcox.exact(x=vx,y=vy,paired=F)
wilcox.exact(x=vx,y=vz,paired=F)
wilcox.exact(x=vy,y=vz,paired=F)



## Centenarian women
tmp <- data %>% dplyr::filter ((sex== "1") & (group == "Cent")) %>% select (rs4783244_num, Adiponectin) %>% na.omit
tmp$rs4783244_num <- as.factor (tmp$rs4783244_num)
xtabs (~rs4783244_num, tmp)

g <- ggplot(tmp , aes(rs4783244_num, Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="red", alpha=I(1/3), outlier.color = NA) 
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("G/G", "G/T","T/T"),limits = c("0","1","2"))
g <- g + scale_y_continuous(limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("rs4783244")
g <- g + ggtitle ("Centenarian women")
plot(g)

vx <- tmp$Adiponectin [tmp$rs4783244_num == "0" ] 
vy <- tmp$Adiponectin [tmp$rs4783244_num == "1" ] 
vz <- tmp$Adiponectin [tmp$rs4783244_num == "2" ] 
length (vx)
length (vy)
length (vz)
wilcox.exact(x=vx,y=vy,paired=F)
wilcox.exact(x=vx,y=vz,paired=F)
wilcox.exact(x=vy,y=vz,paired=F)


