##
## Status and physiological significance of circulating adiponectin in the very old and centenarians: an observational study
## Sasaki et al.
##

library(ggplot2)
library (dplyr)
library (exactRankTests)

## Fig3cdef

## import data 
data <- read.csv("Figs1-3_SourceData1.csv")
## define data type
data$sex <- as.factor (data$sex)
xtabs (~group+sex, data)
summary (data)


##
## Adiponectin vs HDLC
## Fig. 3c,d
##

## Fig.3c
tmp <- data %>% dplyr::filter (group == "VeryOld") %>% select (HDLC, Adiponectin,sex) %>% na.omit
xtabs (~sex, tmp)

g <- ggplot(tmp, aes(x=HDLC, y=Adiponectin, color = sex))
g <- g + stat_smooth(method = "lm", se = T,  size = 1)
g <- g + geom_point(size=0.5, alpha=0.5) 
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + scale_x_continuous(limits = c(25,125))
g <- g + scale_color_manual(values = c("blue", "red"))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + xlab ("HDLC")
g <- g + ylab ("cHMW adiponectin")
g <- g + ggtitle ("Very old")
plot(g) 


tmp.male <- tmp %>%  dplyr::filter (sex == 0)
male.res <- cor.test (tmp.male$HDLC,tmp.male$Adiponectin)
tmp.female <- tmp %>%  dplyr::filter (sex == 1)
female.res <- cor.test (tmp.female$HDLC,tmp.female$Adiponectin) 

male.res$estimate
male.res$p.value
female.res$estimate
female.res$p.value


## Fig.3d
tmp <- data %>% dplyr::filter (group == "Cent") %>% select (HDLC, Adiponectin,sex) %>% na.omit
xtabs (~sex, tmp)

g <- ggplot(tmp, aes(x=HDLC, y=Adiponectin, color = sex))
g <- g + stat_smooth(method = "lm", se = T,  size = 1)
g <- g + geom_point(size=0.5, alpha=0.5) 
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + scale_x_continuous(limits = c(25,125))
g <- g + scale_color_manual(values = c("blue", "red"))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + xlab ("HDLC")
g <- g + ylab ("cHMW adiponectin")
g <- g + ggtitle ("Centenarian")
plot(g) 

tmp.male <- tmp %>%  dplyr::filter (sex == 0)
male.res <- cor.test (tmp.male$HDLC,tmp.male$Adiponectin)
tmp.female <- tmp %>%  dplyr::filter (sex == 1)
female.res <- cor.test (tmp.female$HDLC,tmp.female$Adiponectin) 

male.res$estimate
male.res$p.value
female.res$estimate
female.res$p.value


##
## Adiponectin vs BMI
## Fig. 3e,f
##

## Fig3e
tmp <- data %>% dplyr::filter (group == "VeryOld") %>% select (BMI, Adiponectin,sex) %>% na.omit
xtabs (~sex, tmp)

g <- ggplot(tmp, aes(x=BMI, y=Adiponectin, color = sex))
g <- g + stat_smooth(method = "lm", se = T,  size = 1)
g <- g + geom_point(size=0.5, alpha=0.5) 
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + scale_x_continuous (limits = c(10,40))
g <- g + scale_color_manual(values = c("blue", "red"))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + xlab ("BMI")
g <- g + ylab ("cHMW adiponectin")
g <- g + ggtitle ("Very old")
plot(g) 

tmp.male <- tmp %>%  dplyr::filter (sex == 0)
male.res <- cor.test (tmp.male$BMI,tmp.male$Adiponectin)
tmp.female <- tmp %>%  dplyr::filter (sex == 1)
female.res <- cor.test (tmp.female$BMI,tmp.female$Adiponectin) 

male.res$estimate
male.res$p.value
female.res$estimate
female.res$p.value


## Fig3f
tmp <- data %>% dplyr::filter (group == "Cent") %>% select (BMI, Adiponectin,sex) %>% na.omit
xtabs (~sex, tmp)

g <- ggplot(tmp, aes(x=BMI, y=Adiponectin, color = sex))
g <- g + stat_smooth(method = "lm", se = T,  size = 1)
g <- g + geom_point(size=0.5, alpha=0.5) 
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + scale_x_continuous (limits = c(10,40))
g <- g + scale_color_manual(values = c("blue", "red"))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + xlab ("BMI")
g <- g + ylab ("cHMW adiponectin")
g <- g + ggtitle ("Centenarian")
plot(g) 

tmp.male <- tmp %>%  dplyr::filter (sex == 0)
male.res <- cor.test (tmp.male$BMI,tmp.male$Adiponectin)
tmp.female <- tmp %>%  dplyr::filter (sex == 1)
female.res <- cor.test (tmp.female$BMI,tmp.female$Adiponectin) 

male.res$estimate
male.res$p.value
female.res$estimate
female.res$p.value
