exchange_simulation <- function(normalized.data, Entropy, IEG_mean_total, GeneName = IEG$GeneName, 
                                size, ex, ex2, mode, n_meta, col_name, plot_str, seeds, 
                                meta_cell_order = "Original"){
	rs <- seeds
	
	#Entropy dataframe
	Entropy_mat <- as.data.frame(Entropy)
	t <- normalized.data[c('Ccnd1','Prom1', as.character(GeneName)), rownames(Entropy_mat)]
	t <- as.data.frame(t(t))
	dat <- merge(Entropy_mat, t, by = 0)
	rownames(dat) <- dat$Row.names
	dat <- dat[, -1]
	dat <- dat[order(dat$Entropy, decreasing = T),]
	
	#Simulation
	entropy_sim <- data.frame()
	n <- length(Entropy) %/% size
	for (i in 1:n){
		t <- rs[(size*i-size+1):(size*i)]
		t <- dat[t,]
		if (mode==0){
      for (j in 4:15){
        if(max(t[,j])!=0){
          m <- round(mean(t[,j]))
          t[,j] <- rep(m, size)
        }
      }
    }
		if (mode==1){
      for (j in 4:15){
        if(max(t[,j])!=0){
          m <- which.max(t[,j])
          t[-m,j] <- t[-m,j] + ex*t[m,j]
          t[m,j] <- t[m,j]*(1-(size-1)*ex)
          t[,j] <- round(t[,j])
        }
      }
		}
    if (mode==2){
      for (j in 4:15){
        if(max(t[,j])!=0){
          m <- which.max(t[,j])
          t[-m,j] <- t[-m,j] + ex*t[m,j]
          t[,j] <- round(t[,j])
        }
      }
    }
		if (mode==3){
		  for (j in 4:15){
		    if(max(t[,j])!=0){
		      m <- which.max(t[,j])
		      t[-m,j] <- t[-m,j] + ex*t[m,j]
		      t[m,j] <- t[m,j]*(1-(size-1)*ex)
		    }
		    if(max(t[,j])!=0){
		      m <- which.max(t[,j])
		      t[-m,j] <- t[-m,j] + ex2*t[m,j]
		      t[m,j] <- t[m,j]*(1-(size-1)*ex2)
		      t[,j] <- round(t[,j])
		    }
		  }
		}
    if (mode==4){
      for (j in 4:15){
        if(max(t[,j])!=0){
          m <- which.max(t[,j])
          mm <- max(t[,j])
          temp <- t
          temp[m,j] <- -1
          m2 <- which.max(temp[,j])
          mm2 <- max(temp[,j])
          t[-c(m,m2),j] <- t[-c(m,m2),j] + ex*mm + ex2*mm2
          t[m,j] <- mm*(1-(size-1)*ex)
          t[m2,j] <- mm2*(1-(size-1)*ex2)
          t[,j] <- round(t[,j])
        }
      }
    }
		if (mode==5){
		  for (j in 4:15){
        if(max(t[,j])!=0){
          m <- which.max(t[,j])
          mm <- max(t[,j])
          temp <- t
          temp[m,j] <- -1
          m2 <- which.max(temp[,j])
          mm2 <- max(temp[,j])
          t[-c(m,m2),j] <- t[-c(m,m2),j] + ex*mm + ex2*mm2
          t[m,j] <- mm*(1-(size-1)*ex) + ex2*mm2
          t[m2,j] <- mm2*(1-(size-1)*ex2) + ex*mm
          t[,j] <- round(t[,j])
        }
		  }
		}
		entropy_sim <- rbind(entropy_sim, t)
	}
	entropy_sim <- rbind(entropy_sim, dat[rs[(size*n+1):length(Entropy)],])
	entropy_sim <- entropy_sim[rownames(dat),]
	
	# Entropy for simulated cells
	data_LG <- t(entropy_sim[,4:15])
	for (i in 1:12){
        	data_LG[i,] <- data_LG[i,]/IEG_mean_total$zinb_mu[i]
    	}
	p <- sweep(data_LG, 2, colSums(data_LG), '/')
	entropy_sim$entropy <- -colSums(p*log(p, base = 2), na.rm = T)
	
	# Entropy vs mean in meta cell: ordered by original entropy
	mu_entropy <- c()
  mu_Ccnd1 <- c()
  mu_Prom1 <- c()
  mu_expression <- c()
	for (i in 1:n_meta){
        	if (i!=n_meta){
           		t1 <- entropy_sim[((i-1)*5+1):((i+3)*5),] 
        	}
        	else t1 <- entropy_sim[((i-1)*5+1):length(Entropy),]
        	mu_entropy <- c(mu_entropy, mean(t1$entropy))
        	t <- suppressWarnings(ZINB_mu(data_LG = t(t1[,c(2:15)])))
        	mu_Ccnd1 <- c(mu_Ccnd1, t$zinb_mu[1])
        	mu_Prom1 <- c(mu_Prom1, col_name)
        	mu_expression <- c(mu_expression, mean(log2(t$zinb_mu[c(-1,-2)]/IEG_mean_total$zinb_mu+0.001)))
  }
	res_sim_1 <- data.frame(Entropy=mu_entropy, CyclinD1=mu_Ccnd1, CD133=mu_Prom1, IEG=mu_expression)
	if(meta_cell_order == "Original"){
	  return(res_sim_1)
	}
	
	# Entropy vs mean in meta cell: ordered by entropy after simulation
	entropy_sim <- entropy_sim[order(entropy_sim$entropy, decreasing = T),]
	mu_entropy <- c()
  mu_Ccnd1 <- c()
  mu_Prom1 <- c()
  mu_expression <- c()
	for (i in 1:n_meta){
                if (i!=n_meta){
                        t1 <- entropy_sim[((i-1)*5+1):((i+3)*5),]
                }
                else t1 <- entropy_sim[((i-1)*5+1):length(Entropy),]
                mu_entropy <- c(mu_entropy, mean(t1$entropy))
                t <- suppressWarnings(ZINB_mu(data_LG = t(t1[,c(2:15)])))
                mu_Ccnd1 <- c(mu_Ccnd1, t$zinb_mu[1])
                mu_Prom1 <- c(mu_Prom1, col_name)
                mu_expression <- c(mu_expression, mean(log2(t$zinb_mu[c(-1,-2)]/IEG_mean_total$zinb_mu+0.001)))
        }
	res_sim_2 <- data.frame(Entropy=mu_entropy, CyclinD1=mu_Ccnd1, CD133=mu_Prom1, IEG=mu_expression)
	
	if(meta_cell_order == "Both"){
	  return(list(res_sim_1, res_sim_2))
	}else if(meta_cell_order == "Simulation"){
	  return(res_sim_2)
	}else{
	  return(NULL)
	}
}


#Fit ZINB model for each gene
ZINB_fit <- function(counts_1){
  require(gamlss)
  require(pscl)
  require(maxLik)
  results_gene <- data.frame(zinb_mu = NA, zinb_var = NA, zinb_pos = NA,
                             pos = NA, mu = NA, theta = NA, prob = NA, size = NA,
                             Remark = NA)
  zinb_try <- try(zeroinfl(formula = counts_1 ~ 1 | 1, dist = "negbin"), silent = TRUE)
  if (sum(counts_1 == 0) == length(counts_1)) {  ###all zero
    theta_1 <- 1
    mu_1 <- 0
    size_1 <- 1
    prob_1 <- size_1/(size_1 + mu_1)
  }
  else{
    if ("try-error" %in% class(zinb_try)){
      zinb_try_twice <- try(gamlssML(counts_1, family = "ZINBI"), silent = TRUE)
      if ("try-error" %in% class(zinb_try_twice)){
        results_gene[1, 'Remark'] <- 'ZINB failed'
      }
      else {
        zinb_1 <- zinb_try_twice
        theta_1 <- zinb_1$nu
        names(theta_1) <- NULL
        mu_1 <- zinb_1$mu
        names(mu_1) <- NULL
        size_1 <- 1/zinb_1$sigma
        names(size_1) <- NULL
        prob_1 <- size_1/(size_1 + mu_1)
        names(prob_1) <- NULL
      }
    }
    else {
      zinb_1 <- zinb_try
      theta_1 <- plogis(zinb_1$coefficients$zero)
      names(theta_1) <- NULL
      mu_1 <- exp(zinb_1$coefficients$count)
      names(mu_1) <- NULL
      size_1 <- zinb_1$theta
      names(size_1) <- NULL
      prob_1 <- size_1/(size_1 + mu_1)
      names(prob_1) <- NULL
    }
  }
  
  results_gene[1, 'zinb_mu'] <- mu_1*(1-theta_1)
  results_gene[1, 'zinb_var'] <- mu_1*(1-theta_1)*(1+ mu_1*theta_1 + mu_1/size_1)
  results_gene[1, 'zinb_pos'] <- 1-theta_1
  results_gene[1, 'pos'] <- sum(counts_1 > 0)/length(counts_1)
  results_gene[1, 'mu'] <- mu_1
  results_gene[1, 'theta'] <- theta_1
  results_gene[1, 'prob'] <- prob_1
  results_gene[1, 'size'] <- size_1
  
  return(results_gene)
}


# Function: ZINB fitting for a list of genes; return zinb mu for each gene
ZINB_mu <- function(data_LG){
  data_LG <- as.matrix(data_LG)
  L <- data.frame(GeneName = NA, zinb_mu = NA)
  for (i in 1:dim(data_LG)[1]){
    L[i,1] <- rownames(data_LG)[i]
    L[i,2] <- ZINB_fit(counts_1=data_LG[i,])$zinb_mu
  }
  return(L)
}

