%%%%%%%%%%%%%%%%Traveling wave state
clc
clear all
close all
%%%%%%%%%%%%%%%%Parameters Settings
N = 512;
J0 = 1/N*512;
a = 0.4;
tau = 3;
tau_v = 144;
dt = tau / 10;
m = 0;%50 * tau/tau_v;
k = 5/N*512;% global inhibition factor
%%%%%%%%%%%%%%%%%%Matrix Construction
J = zeros(N, 1);
Iext = zeros(N, 1);
U = zeros(N, 1);
V = zeros(N, 1);
r = zeros(N, 1);
% Map all neurons to [-pi, pi)
x=linspace(-pi, pi, N+1);
pos = x(1: N);
for i = 1: N
		dx = min(pos(i)-pos(1), pi-pos(i));
		% choose the weight matrix to be a 2D Gaussian Distribution
		J(i) = J0/(sqrt(2*pi)*a) * exp(-(dx^2)/(2*a^2));
end
Jfft = fft(J);
%%%%%%%%%%%%%%
Alpha = 0.19;%8*1e-3;
pos=pos';
v = a/tau_v*0.55;
T = 8*pi/v;
loc = -3;
centerx_U = zeros(1,length(T/dt));
centerx_I = zeros(1,length(T/dt));
j=1;
t = 0;
r_t = zeros(N,length(T/dt));
U_t = zeros(N,length(T/dt));
I_t = zeros(N,length(T/dt));
% m.*U

% tic
while t < T
        loc = loc + v * dt;
    if loc >= pi
        loc = loc - 2 * pi;
    end

    dis = min(abs(pos - loc), 2 * pi - abs(pos - loc));
    noise = Alpha/5.*randn(N,1);
    Iext = Alpha  * exp(-(dis.^2/(4*a^2)));
    Irec=ifft(Jfft.*fft(r));%;
    dU = dt * (-U - V + Iext+Irec+noise)/tau;
	U = U + dU;
	dV = dt * (-V + m.*U) / tau_v;
	V = V + dV;
	U = max(U, 0);
	r = U.^2./(1+k.*sum(U(:).^2));
    
    if t>T/4*3
        centerx_I(1,j)=loc;
        maxp = angle(exp(-1i.*pos)'*r);
        if loc > pi - 4*a && maxp < -pi+4*a
            maxp = maxp + 2 * pi;
        end

        if maxp > pi - 4*a && loc < -pi+4*a
            maxp = maxp - 2 * pi;
        end
        centerx_U(1,j)=maxp;
        r_t(:,j)=r(:);
        U_t(:,j) = U(:);
        I_t(:,j) = Iext;
        Ar(j) = max(r);
        j=j+1;
    end
	t = t + dt;
%     disp(t/T)
end
% toc

time = 1:10:length(centerx_U)*0.6;
%%%%%%%%colormap of U

start_time = floor(length(centerx_U)/10+650);

idx = 1:N;
[Time, Idx] = meshgrid(time,idx);
% surf(Time.*dt.*3,Idx,U_t(:,time+start_time)),hold on
% plot3(time.*dt.*3,(centerx_I(time)+pi)./2/pi.*N+80,ones(1,length(time)),'w--','linewidth',5)
surf(Time.*dt.*3.*1e-3-0.44,Idx,r_t(:,time+start_time).*5000),hold on
plot3(time.*dt.*3.*1e-3-0.44,(centerx_I(time+start_time)+pi)./2/pi.*N,18.*ones(1,length(time)),'w','linewidth',1.5)
shading flat
colormap jet
box on
colorbar
caxis([0 15])
axis([0 1-0.44 1 N])
   set(gca,'YTick',0:125:N);
% caxis([0 25])
view([0 0 1])
xlabel('Time(s)')
ylabel('Cell index')
set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');
set(gcf,'unit','centimeters','position',[25,17,15,12])
%%
%%%%%%%%%%%%%%%%Traveling wave state

%%%%%%%%%%%%%%%%Parameters Settings
N = 512;
J0 = 1/N*512;
a = 0.4;
tau = 3;
tau_v = 144;
dt = tau / 10;
m = 0.31;%50 * tau/tau_v;
k = 5/N*512;% global inhibition factor
%%%%%%%%%%%%%%%%%%Matrix Construction
J = zeros(N, 1);
Iext = zeros(N, 1);
U = zeros(N, 1);
V = zeros(N, 1);
r = zeros(N, 1);
% Map all neurons to [-pi, pi)
x=linspace(-pi, pi, N+1);
pos = x(1: N);
for i = 1: N
		dx = min(pos(i)-pos(1), pi-pos(i));
		% choose the weight matrix to be a 2D Gaussian Distribution
		J(i) = J0/(sqrt(2*pi)*a) * exp(-(dx^2)/(2*a^2));
end
Jfft = fft(J);
%%%%%%%%%%%%%%
Alpha = 0.19;%8*1e-3;
pos=pos';
v = a/tau_v*0.55;
T = 8*pi/v;
loc = -3;
centerx_U = zeros(1,length(T/dt));
centerx_I = zeros(1,length(T/dt));
j=1;
t = 0;
r_t = zeros(N,length(T/dt));
U_t = zeros(N,length(T/dt));
I_t = zeros(N,length(T/dt));
% m.*U

% tic
while t < T
        loc = loc + v * dt;
    if loc >= pi
        loc = loc - 2 * pi;
    end
    
    if t>100
        Alpha = 0;
    end
        
    dis = min(abs(pos - loc), 2 * pi - abs(pos - loc));
    noise = Alpha/5.*randn(N,1);
    Iext = Alpha  * exp(-(dis.^2/(4*a^2)));

    Irec=ifft(Jfft.*fft(r));%;
    dU = dt * (-U - V + Irec+Iext+noise)/tau;
	U = U + dU;
	dV = dt * (-V + m.*U) / tau_v;
	V = V + dV;
	U = max(U, 0);
	r = U.^2./(1+k.*sum(U(:).^2));
    
    if t>T/4*3
        centerx_I(1,j)=loc;
        maxp = angle(exp(-1i.*pos)'*r);
        if loc > pi - 4*a && maxp < -pi+4*a
            maxp = maxp + 2 * pi;
        end

        if maxp > pi - 4*a && loc < -pi+4*a
            maxp = maxp - 2 * pi;
        end
        centerx_U(1,j)=maxp;
        r_t(:,j)=r(:);
        U_t(:,j) = U(:);
        I_t(:,j) = Iext;
        Ar(j) = max(r);
        j=j+1;
    end
	t = t + dt;
%     disp(t/T)
end
% toc

time = 1:10:length(centerx_U)*0.6;
%%%%%%%%colormap of U

start_time = floor(length(centerx_U)/10+650);

idx = 1:N;
[Time, Idx] = meshgrid(time,idx);
time_offset = 0.65;
% surf(Time.*dt.*3,Idx,U_t(:,time+start_time)),hold on
% plot3(time.*dt.*3,(centerx_I(time)+pi)./2/pi.*N+80,ones(1,length(time)),'w--','linewidth',5)
surf(Time.*dt.*3.*1e-3-time_offset,Idx,r_t(:,time+start_time).*5000),hold on
plot3(time.*dt.*3.*1e-3-time_offset,(centerx_I(time+start_time)+pi)./2/pi.*N,18.*ones(1,length(time)),'w','linewidth',1.5)
shading flat
colormap jet
box on
colorbar
caxis([0 15])
axis([0 1 1 N])
   set(gca,'YTick',0:125:N);
% caxis([0 25])
view([0 0 1])
xlabel('Time(s)')
ylabel('Cell index')
set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');
set(gcf,'unit','centimeters','position',[25,17,15,12])
