clc
close all
clear all
Mbar = 0:0.05:5;
alpha = 0.5;
N = 512;
density = N / (2*pi);
k= 5;% global inhibition factor
a = 0.4;
J0 = 1;
tau = 3;
tau_v = 144;
dt = tau/10;
%%%%%%%%%%%%%%%%%%Matrix Construction
J = zeros(N, 1);
% Map all neurons to [-pi, pi)
x=linspace(-pi, pi, N+1);
pos = x(1: N);
for i = 1: N
		dx = min(pos(i)-pos(1), pi-pos(i));
		% choose the weight matrix to be a 2D Gaussian Distribution
		J(i) = J0/(sqrt(2*pi)*a) * exp(-(dx^2)/(2*a^2));
end
Jfft = fft(J);
pos=pos';
poss = linspace(-pi,pi,N+1)';
poss = poss(1:N);
exppos = exp(1i*poss');
%以上是设定网络参数，按照
%mbar=10;

v_int_s = zeros(1,length(Mbar));
v_int = zeros(1,length(Mbar));

for ii=1:length(Mbar)
    m = Mbar(ii)* tau/tau_v;
    v_int(ii)=2*a/tau_v*sqrt(Mbar(ii)-sqrt(Mbar(ii)));
    v=v_int(ii)/10;
    if Mbar(ii) > 1
        T = 100+ 6*pi/v_int(ii);
        centerx_U=zeros(1,length(T/dt));
        centerx_I=zeros(1,length(T/dt));
        j=1;
        t = 0;
        U = zeros(N, 1);
        V = zeros(N, 1);
        r = zeros(N, 1);
        loc=-(pi/2+pi/8);
        while t<T
            if t< 100
                loc = loc + v * dt;
                if loc >= pi
                    loc = loc - 2 * pi;
                end
                loc_cal = loc;
                dis = min(abs(pos - loc_cal), 2 * pi - abs(pos - loc_cal));
                Iext = alpha  * exp(-(dis.^2/(4*a^2)));
                else
                    Iext=zeros(N,1);
            end
            dU = dt * (-U + ifft(Jfft.*fft(r(:))) - V + Iext)/tau;
            dV = dt * (-V + m*U) / tau_v;
            U = U + dU;
            V = V + dV;
            U = max(U, 0);
            r(:) = U.^2./(1+k*sum(U(:).^2));
            centerx_U(1,j)=angle(exppos*r);%expectationOd(pos,r);
            
            j=j+1;
            t = t + dt;
        end
    end
    
    if j>2
        T_pi=pi/v_int(ii);
        Lc=length(centerx_U);
        timestamp=linspace(0,t,Lc);
        L=centerx_U;
        [~,pos_max]=findpeaks(L);
        pos_max=pos_max(end);
        v_int_s(ii)=(L(pos_max)-L(pos_max-floor(2*pi/v_int(ii)/dt)))/(2*pi/v_int(ii));
    end
     ii/length(Mbar)
end
%%
figure
plot(Mbar.*tau/tau_v,v_int_s*1000,'b','linewidth',1),hold on;
plot([tau/tau_v tau/tau_v],[-10 100],'k--','linewidth',1)
%plot(Mbar/60,real(v_int),'linewidth',3)
axis([0 max(Mbar)*tau/tau_v -2 10])
set(gca,'YTick',0:5:30);
set(gca,'XTick',0:0.05:1);
xlabel('feedback inh. stre. m','fontname','Arial')
ylabel('intrinsic speed v_{int}','fontname','Arial')
set(gcf,'unit','centimeters','position',[25,17,15,12])
% text(-0.009,28,'1e^{-3}','color','k','fontsize',10,'fontname','Arial')
%axis([0 0.045 0 0.015])
%legend('simulation result','theoretical result')
grid off
box off
set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');