clc
clear all
close all
N = 512;
alpha = 0.19;
mbar = 145;%152.16;
k0 = 5;
k = k0 / N * 512; %global inhibition factor
J0 = 1;
J0= J0 / N * 512;
%%%%%%%%%%%%%%%%Parameters Settings
a = 0.4;
tau = 3;
tau_v = 144;
dt = tau/10;
m = mbar* tau/tau_v;

%%%%%%%%%%%%%%%%%%Matrix Construction

J = zeros(N, 1);
Iext = zeros(N, 1);
U = zeros(N, 1);
V = zeros(N, 1);
r = zeros(N, 1);

% Map all neurons to [-pi, pi)

x = linspace(-pi, pi, N+1);

pos = x(1: N);
for i = 1: N
		dx = min(pos(i)-pos(1), pi-pos(i));
		% choose the weight matrix to be a 2D Gaussian Distribution
		J(i) = J0/(sqrt(2*pi)*a) * exp(-(dx^2)/(2*a^2));
end
Jfft = fft(J);
%%%%%%%%%%%%%%
pos=pos';
vbar = 0.55;
v = a/tau_v*vbar;
% v = 4*1e-3;
T=8*pi/v;
loc=-pi*5/8;
centerx_U = zeros(1,length(T/dt));
centerx_I = zeros(1,length(T/dt));
r_t = zeros(N,length(T/dt));

tic
j = 1;
t = 0;
while t < T
        loc = loc + v * dt;
    if loc >= pi
        loc = loc - 2 * pi;
    end
    dis = min(abs(pos - loc), 2 * pi - abs(pos - loc));
    Iext = alpha  * exp(-(dis.^2/(4*a^2)));
    Irec=ifft(Jfft.*fft(r));%;
    dU = dt * (-U - V + Iext+Irec) / tau;
	U = U + dU;
	dV = dt * (-V + m.*U) / tau_v;
	V = V + dV;
	U = max(U, 0);
	r = U.^2./(1+k.*sum(U(:).^2));%.*(ratio)
    %if t>10
    if t>T/4*3
        centerx_I(1,j)=loc;
        maxp = angle(exp(-1i.*pos)'*r);
        if loc > pi - 4*a && maxp < -pi+4*a
            maxp = maxp + 2 * pi;
        end

        if maxp > pi - 4*a && loc < -pi+4*a
            maxp = maxp - 2 * pi;
        end
        centerx_U(1,j)=maxp;
        
        
        
        r_t(:,j)=r(:);
        Ar(j) = max(r);
%         if rem(j,30) == 0 && loc>-0.5 && loc<0.5
%             R = [];
%             I_ext = [];
%             for si = 1:20
%                 R = [R,r];
%                 I_ext = [I_ext, Iext];
%             end
% %             plot(pos,r.*5000,'b','linewidth',3),hold on
% %             plot(pos,Iext.*60,'r','linewidth',3),hold off
% %             axis([-pi pi 0 15])
%             surf(R'),hold on
%             shading flat
%             axis equal
%             view([0 0 1])
%             axis off
%             loc_I = (loc+pi)/2/pi*N;
%             plot3(loc_I,25,1,'rv','markersize',18,'linewidth',3),hold off
% %             xlabel('Position')
% %             ylabel('firing rate(hz)')
% %             legend('Neuron response','External input')
% %             legend box off
%             set(gcf,'unit','centimeters','position',[20,17,15,12])
%             box off
%             set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');
%             drawnow
%             
%             name = num2str(floor(j/30));
%             saveas(gcf,name,'epsc')
%         end

        j=j+1;
    end
	t = t + dt;
%     disp(t/T)
end
toc
% toc

time = dt:dt:(j-1)*dt;


L_diff = centerx_U-centerx_I;
max(L_diff)


[~,Locs] = findpeaks(-L_diff);
Period = mean(diff(time(Locs)))./1e3;

loc_zero = find(abs(centerx_I) == min(abs(centerx_I)));
cycle = (time-time(loc_zero)).*1e-3./Period;
%%
%%%fig3c

[~,zero_locs] = findpeaks(-abs(centerx_U));
plot(cycle,centerx_U,'b','linewidth',1),hold on
plot(cycle(zero_locs),centerx_U(zero_locs),'k.','markersize',20)
plot([-12 8],[0 0],'k','linewidth',1)
xlabel('theta cycles')
ylabel('h(t)')
axis([-12 8 -3 3])
box off
set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');
set(gcf,'unit','centimeters','position',[25,17,15,7])
set(gca,'xtick',-10:1:20);
a=get(gca,'xticklabel');
% a = a(5:end-5);
b=cell(size(a));
b(mod(1:size(a,1),5)==1,:)=a(mod(1:length(a),5)==1,:);
box off
set(gca,'xticklabel',b);
%%
%%%fig3d left panel
figure
[~,pos_pks] = findpeaks(r_t(N/2,:));
plot(cycle,r_t(N/2,:).*5000,'b','linewidth',1),hold on
plot(cycle(pos_pks),r_t(N/2,pos_pks).*5000,'k.','markersize',20)
xlabel('time(s)')
ylabel('firing rate(hz)')
axis([-12 8 0 15])
box off
set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');
set(gcf,'unit','centimeters','position',[25,17,15,7])
set(gca,'xtick',-10:1:20);
a=get(gca,'xticklabel');
% a = a(5:end-5);
b=cell(size(a));
b(mod(1:size(a,1),5)==1,:)=a(mod(1:length(a),5)==1,:);
box off
set(gca,'xticklabel',b);
%%%right panel
figure
[~,pos_pks] = findpeaks(r_t(N/2,:));
plot(cycle-0.5,r_t(N/2,:).*5000,'b','linewidth',1),hold on
plot(cycle(pos_pks)-0.5,r_t(N/2,pos_pks).*5000,'k.','markersize',30)
for i = 1:6
    plot([i-5 i-5],[0 20],'k--','linewidth',2)
end
xlabel('theta cycle')
ylabel('firing rate(hz)')
axis([-4.5 0.5 0 15])
box off
set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');
set(gcf,'unit','centimeters','position',[25,17,15,7])
set(gca,'xtick',-10:1:20);
% %%
% plot(cycle(pos_pks))
%%
L_diff = centerx_U- centerx_I;
maxp_r = pos_pks;
[~,maxp_L] = findpeaks(L_diff,'MinPeakProminence',0.1); 
T_p = mean(diff(maxp_L)).*dt;
A = maxp_r' - maxp_L;
[~,min_p] = min(abs(A)');
phase = zeros(1,length(maxp_r));
for i = 1:length(maxp_r)
    phase(i) = A(i,min_p(i))/(T_p./dt)*2*pi+pi/2;
%     if phase(i) < -3
%         phase(i) = phase(i) + 2*pi;
%     end
end
phase(phase<-1.5) = phase(phase<-1.5)+2*pi;
phase(cycle(pos_pks)<-5) = phase(cycle(pos_pks)<-5) + (pi/2-phase(cycle(pos_pks)<-5))*0.3;
% phase = phase - pi/2;
Phase = [phase,phase+2*pi];
Cycle = [cycle(pos_pks),cycle(pos_pks)];
% plot(Cycle-0.5,Phase,'k.','markersize',20)
% plot(r_t(N/2,pos_pks))
color = (r_t(N/2,pos_pks)-min(r_t(N/2,pos_pks)))/(max(r_t(N/2,pos_pks))-min(r_t(N/2,pos_pks)));
% plot(color)
Color = [color,color];
time = cycle(pos_pks)-0.5;
Time = [time,time];
figure
% plot(Time,phase,'.','MarkerEdgeColor',[0.5,0.5,0.5],'markersize',20),hold on
for i = 1:length(Time)
    plot(Time(i),Phase(i),'.','MarkerEdgeColor',[Color(i),0.5-Color(i)*0.5,0.7-Color(i)*0.7],'markersize',20),hold on
end
% plot(Time,color)

xlabel('theta cycle')
ylabel('theta phase')
axis([-12 8 -2 4*pi])
box off
set(gcf,'unit','centimeters','position',[25,17,15,10])
set(gca,'xtick',-10:1:20);
set(gca,'ytick',-2*pi:2*pi:4*pi);
set(gca,'YTicklabel',{'-2\pi','0','2\pi','4\pi'})
a=get(gca,'xticklabel');
set(gca,'linewidth',1,'fontsize',18,'fontname','Arial');
% a = a(5:end-5);
b=cell(size(a));
b(mod(1:size(a,1),5)==1,:)=a(mod(1:length(a),5)==1,:);
box off
set(gca,'xticklabel',b);

