clc
clear all
close all
N = 512;
alpha = 0.19;
k0 = 5;
k = k0 / N * 512; %global inhibition factor
J0 = 1;
J0= J0 / N * 512;
%%%%%%%%%%%%%%%%Parameters Settings
a = 0.4;
tau = 3;
tau_v = 144;
dt = tau/10;



%%%%%%%%%%%%%%%%%%Connection Matrix Construction

J = zeros(N, 1);
x = linspace(-pi, pi, N+1);

pos = x(1: N);
for i = 1: N
		dx = min(pos(i)-pos(1), pi-pos(i));
		% choose the weight matrix to be a 2D Gaussian Distribution
		J(i) = J0/(sqrt(2*pi)*a) * exp(-(dx^2)/(2*a^2));
end
Jfft = fft(J);
%%%%%%%%%%%%%%
pos=pos';
vbar = 0.55;
v = a/tau_v*vbar;
T=8*pi/v;
%%%Initialize the network
tic
m_n = 55;
f_A = zeros(1,m_n);
r_A = zeros(1,m_n);
mbar = linspace(145,155,m_n);
m_p = mbar.*tau./tau_v;
for mi = 1:m_n
    m = mbar(mi)* tau/tau_v;
    Iext = zeros(N, 1);
    U = zeros(N, 1);
    V = zeros(N, 1);
    r = zeros(N, 1);
    loc=-pi*5/8;
    centerx_U = zeros(1,length(T/dt));
    centerx_I = zeros(1,length(T/dt));
    Ar = zeros(1,length(T/dt));
    j = 1;
    t = 0;
    while t < T
            loc = loc + v * dt;
        if loc >= pi
            loc = loc - 2 * pi;
        end
        dis = min(abs(pos - loc), 2 * pi - abs(pos - loc));
        Iext = alpha  * exp(-(dis.^2/(4*a^2)));
        Irec=ifft(Jfft.*fft(r));%;
        dU = dt * (-U - V + Iext+Irec) / tau;
        U = U + dU;
        dV = dt * (-V + m.*U) / tau_v;
        V = V + dV;
        U = max(U, 0);
        r = U.^2./(1+k.*sum(U(:).^2));%.*(ratio)
        %if t>10
        if t>T/4*3
            centerx_I(1,j)=loc;
            maxp = angle(exp(-1i.*pos)'*r);
            if loc > pi - 4*a && maxp < -pi+4*a
                maxp = maxp + 2 * pi;
            end

            if maxp > pi - 4*a && loc < -pi+4*a
                maxp = maxp - 2 * pi;
            end
            centerx_U(1,j)=maxp;
            r_t(:,j)=r(:);
            Ar(j) = max(r);

            j=j+1;
        end
        t = t + dt;
    %     disp(t/T)
    end
    L_diff = centerx_U-centerx_I;
    [f_A(mi),r_A(mi)] = Ar_ratio(Ar,L_diff);
    disp(mi/m_n);
end
toc

figure
plot(m_p,f_A,'b','linewidth',1),hold on
plot(m_p,r_A,'r','linewidth',1)
legend('forward window','reverse window')
xlabel('Feedback inh. stre. m')
ylabel('Average bump height')
legend location best
legend box off
% axis([3 3.25 0 12])
box off
set(gca,'linewidth',1,'fontsize',15,'fontname','Arial');
set(gcf,'unit','centimeters','position',[25,17,15,12])