function dVesdt = DualsensorODE(t,Ves,CaSignal,par)
                                                                             
%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)                    
                                
%% This scripts contains the differential equations describing the model

%input parameters:
%t - time step
%Ves - current state of the system
% CaSignal - matrix with the calcium signal used to run the model and the
% corresponding time vector. 
% par - structure containing all parameters used in the model

%output parameters:
% dVesdt - Change in the state of the system (vector)

%%

%extract model parameters
kon1   = par.kon1;  % 1/(uM*s)
koff1  = par.koff1; % 1/s
f1     = par.f1;
b1     = par.b1;
kon7   = par.kon7;  % 1/(uM*s)
koff7  = par.koff7; % 1/s
f7     = par.f7;
b7     = par.b7;
kon2   = par.kon2;  % 1/(uM*s)
koff2  = par.koff2; % 1/s
f2     = par.f2;
b2     = par.b2;
nsites = par.nsites;
K = par.K; %docking rate
Kun = par.Kun; %undocking rate
Ktether = par.Ktether;
Kuntether = par.Kuntether;
lplus = par.lplus; % 1/s

%Get current calcium concentration
Ca = interp1(CaSignal(:,1), CaSignal(:,2), t);

%differential equations:

%creat vectors
dVesdt = zeros(28,1);    % a column vector
n = repmat([0:5]', 3,1); %number of syt1 bound to calcium
m= repmat([0:2], 6,1); m=m(:); %number of doc2 bound to calcium

fusionrate = lplus*f1.^n.*f2.^m;

%States for empty release sites (1-3)
dVesdt(1) = - Ktether*Ves(1) + Kuntether*Ves(4) + sum(fusionrate(1:6).* Ves(7:12)) + koff2*Ves(2) - 2*Ca*kon2*Ves(1); 
dVesdt(2) = - Ktether*Ves(2) + Kuntether*Ves(5) + sum(fusionrate(7:12).* Ves(13:18)) + 2*b2*koff2*Ves(3) + 2*Ca*kon2*Ves(1) - (Ca*kon2 + koff2)*Ves(2);
dVesdt(3) = - Ktether*Ves(3) + Kuntether*Ves(6) + sum(fusionrate(13:18).* Ves(19:24))  + Ca*kon2*Ves(2) - 2*b2*koff2*Ves(3);

%States for tethered vesicles (4-6)
dVesdt(4) = Ktether*Ves(1) +Kun*sum(sum(f7.^[0;1;2].*Ves(26:28)).*Ves(7:12)) - (Kuntether + K*sum(f7.^[0;1;2].*Ves(26:28)))*Ves(4)+ koff2*Ves(5) - 2*Ca*kon2*Ves(4); 
dVesdt(5) = Ktether*Ves(2) +Kun*sum(sum(f7.^[0;1;2].*Ves(26:28)).*Ves(13:18)) - (Kuntether + K*sum(f7.^[0;1;2].*Ves(26:28)))*Ves(5)+ 2*b2*koff2*Ves(6) + 2*Ca*kon2*Ves(4) - (Ca*kon2 + koff2)*Ves(5); 
dVesdt(6) = Ktether*Ves(3) +Kun*sum(sum(f7.^[0;1;2].*Ves(26:28)).*Ves(19:24)) - (Kuntether + K*sum(f7.^[0;1;2].*Ves(26:28)))*Ves(6)+ Ca*kon2*Ves(5) - 2*b2*koff2*Ves(6); 

%States for docked vesicles (7:24)
    dVesdt(7:24) = + max(0, 5-(n+m-1))*Ca*kon1 .* [0; Ves(7:11); 0; Ves(13:17); 0; Ves(19:23)] ...
               - max(0, 5-(n+m))*Ca*kon1  .* Ves(7:24)... 
               + (n+1) .* b1.^n * koff1 .* [Ves(8:12);0;Ves(14:18);0;Ves(20:24);0]...
               - n .*b1.^(n-1) * koff1 .* Ves(7:24) ...
               + min(max(0, 2-(m-1)),max(0, 5-(n+m-1)))*Ca*kon2 .*[zeros(6,1); Ves(7:18)] ...
               - min(max(0, 2-m),max(0, 5-(n+m)))*Ca*kon2 .* Ves(7:24) ...
               + (m+1).*b2.^m *koff2 .* [Ves(13:24); zeros(6,1)] ... 
               - m.*b2.^(m-1)*koff2 .* Ves(7:24) ...
               - fusionrate .* Ves(7:24) ...
              - Kun*sum(f7.^[0;1;2].*Ves(26:28)).*Ves(7:24);

%add docking reaction
dVesdt(7) = dVesdt(7) + K*sum(f7.^[0;1;2].*Ves(26:28))*Ves(4);
dVesdt(13) = dVesdt(13) + K*sum(f7.^[0;1;2].*Ves(26:28))*Ves(5);
dVesdt(19) = dVesdt(19) + K*sum(f7.^[0;1;2].*Ves(26:28))*Ves(6);

%States for fused vesicles (25)
dVesdt(25) = sum(fusionrate.* Ves(7:24));

%States for syt7 (26-28)
dVesdt(26) = koff7    *Ves(27) - (2*kon7*Ca)*Ves(26);
dVesdt(27) = 2*kon7*Ca*Ves(26) + 2*koff7*b7  *Ves(28) - (koff7       + 1*kon7*Ca)*Ves(27);
dVesdt(28) = 1*kon7*Ca*Ves(27)                        - (2*koff7*b7)*Ves(28);
