function [L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par_list, KO_IO, basename)

%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)         

%% This function qunatifies the results of the model simulation obtained with different combinations of model parameters

%input:
%Parvlues - values of the parameters that need to be varied as a cell
%par_indx - index of the parameters that need to be varied
%par_list - array of parameter values
%KO_IO - whether or not to evaluate the KO condition
%basename - folder path

%output: 
%L - matrix with the different parameter combinations tested
%Async_... - cumulative asynchronous release after 1st, 2nd and 10th AP
%docked_... - number of docked vesicles at 0,5e-3, 11e-3, 15e-3s
%Amplitude_... - peak fusion rate after 1st, 2nd and 10th AP

%% calculate different parameter combinations
L = Parvalues;
n = length(L);
[L{:}] = ndgrid(L{end:-1:1});
L = cat(n+1,L{:});
L = fliplr(reshape(L,[],n));

%% loop over the different paramter combinations
 for i = 1:length(L)
    
     %load files
    wt = load([basename, 'Workspace_varypar_', num2str(par_indx), 'testsettings', num2str(i), '_WT.mat']);
    if KO_IO
    syt7KO = load([basename, 'Workspace_varypar_', num2str(par_indx), 'testsettings', num2str(i), '_Syt7KO.mat']);
    Doc2KO = load([basename, 'Workspace_varypar_', num2str(par_indx), 'testsettings', num2str(i), '_Doc2KO.mat']);
    end 
 
    %Extract asynchronous release
    fusion = diff(wt.y(:,25));
    t_int_high = [50e-3:50e-3:2.5];
    t_int_low_5 = [5e-3:50e-3:2.5];
    for j = 1:length(t_int_low_5)
        Intervalsum_fusion_5(j) = sum(fusion(wt.x>t_int_low_5(j)&wt.x<t_int_high(j)));
    end
    cumsum_fusion_5 = cumsum(Intervalsum_fusion_5);

    Async_wt(i,:) = cumsum_fusion_5([1,2,10]);

    if KO_IO
    fusion = diff(syt7KO.y(:,25));
    for j = 1:length(t_int_low_5)
        Intervalsum_fusion_5(j) = sum(fusion(syt7KO.x>t_int_low_5(j)&syt7KO.x<t_int_high(j)));
    end
    cumsum_fusion_5 = cumsum(Intervalsum_fusion_5);
    Async_syt7KO(i,:) = cumsum_fusion_5([1,2,10]);

    fusion = diff(Doc2KO.y(:,25));
    for j = 1:length(t_int_low_5)
        Intervalsum_fusion_5(j) = sum(fusion(Doc2KO.x>t_int_low_5(j)&Doc2KO.x<t_int_high(j)));
    end
    cumsum_fusion_5 = cumsum(Intervalsum_fusion_5);
    Async_Doc2KO(i,:) = cumsum_fusion_5([1,2,10]);
    end

    % Extract number of docked vesicles
    docked_wt(i, :) = interp1(wt.x, sum(wt.y(:,7:24),2), [0,5e-3, 11e-3, 15e-3]);
    
    if KO_IO
    docked_syt7KO(i, :) = interp1(syt7KO.x, sum(syt7KO.y(:,7:24),2), [0,5e-3, 11e-3, 15e-3]);
    docked_doc2KO(i, :) = interp1(Doc2KO.x, sum(Doc2KO.y(:,7:24),2), [0,5e-3, 11e-3, 15e-3]);
    end


    % Extract amplitudes of responses
    sampling_rate=50e3; 
    end_time= 10*1/20;
    time_sample=0:1/sampling_rate:end_time;
    fused_cum = interp1(wt.x, wt.y(:,25),time_sample);
    fused = diff(fused_cum,1)*sampling_rate;    
    Amplitutde_wt(i,:) = [max(fused(time_sample>0 & time_sample<0.05)), max(fused(time_sample>50e-3 & time_sample<100e-3)), max(fused(time_sample>0.45 & time_sample<0.5))];

    if KO_IO
    fused_cum = interp1(syt7KO.x, syt7KO.y(:,25),time_sample);
    fused = diff(fused_cum,1)*sampling_rate;
    Amplitutde_Syt7KO(i,:) = [max(fused(time_sample>0 & time_sample<50e-3)), max(fused(time_sample>50e-3 & time_sample<100e-3)), max(fused(time_sample>0.45 & time_sample<0.5))];
    
    fused_cum = interp1(Doc2KO.x, Doc2KO.y(:,25),time_sample);
    fused = diff(fused_cum,1)*sampling_rate;
    Amplitutde_Doc2KO(i,:) = [max(fused(time_sample>0 & time_sample<50e-3)), max(fused(time_sample>50e-3 & time_sample<100e-3)), max(fused(time_sample>0.45 & time_sample<0.5))];   
    end
end

%generate parameters if not generated above
   if ~KO_IO
        Amplitutde_Doc2KO = [];
        Amplitutde_Syt7KO = [];
        docked_syt7KO = [];
        docked_doc2KO =[];
        Async_Doc2KO = [];
        Async_syt7KO = [];
   end
    
  