function [t, Y] = MainModel_dualsensor(Casignal, par,YSS, opt)

%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk) 
                               
%% This scripts solves the differential equations described in DualsensorODE numerically over time.

%inputparameters: 
% Yss - Initial condition of the system
% CaSignal - matrix with the calcium signal used to run the model and the
% corresponding time vector. 
% par - structure containing all parameters used in the model
% opt - vector containing the options of the ode15s. 

%output parameters:
% t - time vector
% Y - population of the different release site states at each timepoint in
% vector t.

%%
tspan =Casignal(:,1);
[t, Y] = ode15s(@(t, Y) DualsensorODE(t,Y,Casignal, par), tspan, YSS, opt);
end