%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)         

%% This script plots the results from the parameter space exploration
% parameter space exploration is performed using Run_varyparameters.m

%change the name of the files in line 23 and 83 to those files you want to
%plot the results from 

%first part of the script plots the results for parameters evaluated
%one-by-one
%the second part of the script generates plots for space evaluation of two
%pairs of parameters. 

%% plot results individual changes model parameters

load('20220803_Varyf2_extractedparameters.mat') %change file according to the parameter you want to evaluate
xval = 'f2';
x_selected = L(10);
figure()
semilogx(L, Async_wt(:,3), '-ok')
hold on
semilogx(L, Async_Doc2KO(:,3), '-om')
semilogx(L, Async_syt7KO(:,3), '-oc')
xlabel(xval)
ylabel(' Cumulative asynchronous release')
legend('wt', 'doc2ko', 'syt7ko')
set(gca,'TickDir','out');
box off
ylim([0 100])
xlim([min(L), max(L)])
xticks([x_selected/10 x_selected x_selected*10])

figure()
semilogx(L, Amplitutde_wt(:,3)./Amplitutde_wt(:,1), '-ok')
hold on
semilogx(L, Amplitutde_Doc2KO(:,3)./Amplitutde_Doc2KO(:,1), '-om')
semilogx(L, Amplitutde_Syt7KO(:,3)./Amplitutde_Syt7KO(:,1), '-oc')
xlabel(xval)
ylabel('Amplitude 10th/1st')
legend('wt', 'doc2ko', 'syt7ko')
set(gca,'TickDir','out');
box off
ylim([0 1.2])
xlim([min(L), max(L)])
xticks([x_selected/10 x_selected x_selected*10])

figure()
semilogx(L, docked_wt(:,4)- docked_wt(:,2), '-ok')
hold on
semilogx(L, docked_doc2KO(:,4)- docked_doc2KO(:,2), '-om')
semilogx(L, docked_syt7KO(:,4)- docked_syt7KO(:,2), '-oc')
xlabel(xval)
ylabel('#docked vesicles 15 ms - 5ms')
legend('wt', 'doc2ko', 'syt7ko')
set(gca,'TickDir','out');
box off
ylim([-2 12])
xlim([min(L), max(L)])
xticks([x_selected/10 x_selected x_selected*10])

figure()
semilogx(L, Amplitutde_wt(:,1), '-ok')
hold on
semilogx(L, Amplitutde_Doc2KO(:,1), '-om')
semilogx(L, Amplitutde_Syt7KO(:,1), '-oc')
xlabel(xval)
ylabel('Amplitude 1st')
legend('wt', 'doc2ko', 'syt7ko')
set(gca,'TickDir','out');
box off
ylim([2e4, 7e4])
xlim([min(L), max(L)])
xticks([x_selected/10 x_selected x_selected*10])

%% 3Dplots
load('20220803_ktetandresidualamplitude_extractedparameters.mat') %change
%file according to the parameters that you want to evaluate
 
xval = 'f2';
yval = 'residual caamplitude';
x = reshape(L(:,1), [19, 19]); %rewrite the combinations parameter values into a matrix
y = reshape(L(:,2), [19, 19]);

%plot cumulative asynchronous release
z = Async_wt(:,3); %extract information
z = reshape(z, [19,19]); %reshape results into matrix

figure()
surf(x, y, z)
xlabel(xval)
ylabel(yval)
zlabel('Cumulative Asyn')
h = gca;
set(h,'xscale','log')
set(h,'yscale','log')

%plot amplitude 10th/1st
z = Amplitutde_wt(:,3)./Amplitutde_wt(:,1);
z = reshape(z, [19,19]);

figure()
surf(x, y, z)
xlabel(xval)
ylabel(yval)
zlabel('Amplitude 10th/1st')
h = gca;
set(h,'xscale','log')
set(h,'yscale','log')

%plot number of docked vesicles between 15 and 5ms
z = docked_wt(:,4)- docked_wt(:,2);
z = reshape(z, [19,19]);

figure()
surf(x, y, z)
xlabel(xval)
ylabel(yval)
zlabel('#docked vesicles 15 ms - 5ms')
h = gca;
set(h,'xscale','log')
set(h,'yscale','log')

z = Amplitutde_wt(:,1);
z = reshape(z, [19,19]);

figure()
surf(x, y, z)
xlabel(xval)
ylabel(yval)
zlabel('Amplitude 1st')
h = gca;
set(h,'xscale','log')
set(h,'yscale','log')

%% plot heatmaps

xval = 'f2';
yval = 'residual amplitude';
x_selected = 16;
y_selected = 0.75; 

x = reshape(L(:,1), [19, 19]);
y = reshape(L(:,2), [19, 19]);

 
f = figure(); %asyn
z = Async_wt(:,3);
z = reshape(z, [19,19]);
%heatmap(unique(x), unique(y), z)
surf(x,y, z)
view(0,90)
set(gca, 'XScale','log', 'YScale', 'log')
axis('tight')
a =colorbar('southoutside');
a.Label.String = 'Cumulative Asyn';
xlabel(xval)
ylabel(yval)
zlabel('Cumulative Asyn')
%a.Ticks = sort([linspace(0, 80, 9), asyn_wt, asyn_syt7, asyn_Doc2]) ; %Create 8 ticks from zero to 1
xticks([x_selected/10 x_selected x_selected*10])
yticks([y_selected/10 y_selected y_selected*10])
set(gca,'Xdir','normal', 'Ydir', 'normal')
set(gca,'TickDir','out');
f.Renderer = 'painters';

f=figure(); %docked
z = docked_wt(:,4)- docked_wt(:,2);
z = reshape(z, [19,19]);
surfc(x,y, z)
view(0,90)
set(gca, 'XScale','log', 'YScale', 'log')
axis('tight')
a =colorbar('southoutside');
a.Label.String = 'Docked (15-5ms)';
xlabel(xval)
ylabel(yval)
%zlabel('Cumulative Asyn')
%a.Ticks = sort([linspace(0, 8, 9), Docked_wt, Docked_syt7, Docked_Doc2]) ; %Create 8 ticks from zero to 1
xticks([x_selected/10 x_selected x_selected*10])
yticks([y_selected/10 y_selected y_selected*10])
set(gca,'Xdir','normal', 'Ydir', 'normal')
set(gca,'TickDir','out');
f.Renderer = 'painters';

f =figure(); %1st
z =  Amplitutde_wt(:,1);
z = reshape(z, [19,19]);
surfc(x,y, z)
view(0,90)
set(gca, 'XScale','log', 'YScale', 'log')
axis('tight')
a =colorbar('southoutside');
a.Label.String = 'Amplitude 1st';
xlabel(xval)
ylabel(yval)
%zlabel('Cumulative Asyn')
%a.Ticks = sort([0:3:21, A1st_wt, A1st_syt7, A1st_Doc2]) ; %Create 8 ticks from zero to 1
xticks([x_selected/10 x_selected x_selected*10])
yticks([y_selected/10 y_selected y_selected*10])
set(gca,'Xdir','normal', 'Ydir', 'normal')
set(gca,'TickDir','out');
f.Renderer = 'painters';

f=figure(); %Amplitude 10th/1st
z =  Amplitutde_wt(:,3)./Amplitutde_wt(:,1);
z = reshape(z, [19,19]);
surfc(x,y, z)
view(0,90)
set(gca, 'XScale','log', 'YScale', 'log')
axis('tight')
a =colorbar('southoutside');
a.Label.String = 'Amplitude 10th/1st';
xlabel(xval)
ylabel(yval)
%zlabel('Cumulative Asyn')
%a.Ticks = sort([0:3:21, A10th_wt, A10th_syt7, A10th_Doc2]) ; %Create 8 ticks from zero to 1
xticks([x_selected/10 x_selected x_selected*10])
yticks([y_selected/10 y_selected y_selected*10])
set(gca,'Xdir','normal', 'Ydir', 'normal')
set(gca,'TickDir','out');
f.Renderer = 'painters';






