function Plotresults()
%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)         

%% This function plots the results saved in the workspaces
%this script opens the workspaces generated using
%run_dual_differentsettings.m

%% load workspaces
i = 1608; 
WT = load(['Workspace_220803_testsettings', num2str(i), '_WT.mat']);
Syt7KO = load(['Workspace_220803_testsettings', num2str(i), '_Syt7KO.mat']);
Doc2KO = load(['Workspace_220726_testsettings', num2str(i), '_Doc2KO.mat']);

%% plot number of docked vesicles
figure()
plot(WT.x, [sum(WT.y(:,7:24),2)], 'k', 'LineWidth', 2)
hold on
plot(Syt7KO.x, [sum(Syt7KO.y(:,7:24),2)], 'c', 'LineWidth', 2)
plot(Doc2KO.x, [sum(Doc2KO.y(:,7:24),2)], 'm', 'LineWidth', 2)
legend('WT', 'Syt7KO' , 'Doc2KO')
xlabel('time (s)')
ylabel('number of docked vesicles')
set(gca,'TickDir','out');
box off

%% plot asynchronouos release

fusion = diff(WT.y(:,25));
t_int_high = [50e-3:50e-3:2.5];
t_int_low_5 = [5e-3:50e-3:2.5];
for i = 1:length(t_int_low_5)
    Intervalsum_fusion_5(i) = sum(fusion(WT.x>t_int_low_5(i)&WT.x<t_int_high(i)));
end
WT.cumsum_fusion_5 = cumsum(Intervalsum_fusion_5);

fusion = diff(Syt7KO.y(:,25));
for i = 1:length(t_int_low_5)
    Intervalsum_fusion_5(i) = sum(fusion(Syt7KO.x>t_int_low_5(i)&Syt7KO.x<t_int_high(i)));
end
Syt7KO.cumsum_fusion_5 = cumsum(Intervalsum_fusion_5);

fusion = diff(Doc2KO.y(:,25));
for i = 1:length(t_int_low_5)
    Intervalsum_fusion_5(i) = sum(fusion(Doc2KO.x>t_int_low_5(i)&Doc2KO.x<t_int_high(i)));
end
Doc2KO.cumsum_fusion_5 = cumsum(Intervalsum_fusion_5);

figure(); plot([1:50], WT.cumsum_fusion_5,'-ok', 'LineWidth', 2); hold on
plot([1:50], Syt7KO.cumsum_fusion_5,'-oc', 'LineWidth', 2);
plot([1:50], Doc2KO.cumsum_fusion_5,'-om', 'LineWidth', 2);
legend('WT', 'Syt7KO' , 'Doc2KO')
xlabel('stimulation number')
ylabel('Cumulative asynchronous (>5ms)')
xlim([1 10])
set(gca,'TickDir','out');
box off

%% Plot fusion rate over time
sampling_rate=50e3; 
end_time=0.5;
time_sample=0:1/sampling_rate:end_time;
fused_cum = interp1(WT.x, WT.y(:,25),time_sample);
WT.fused = diff(fused_cum,1)*sampling_rate;
fused_cum = interp1(Doc2KO.x, Doc2KO.y(:,25),time_sample);
Doc2KO.fused = diff(fused_cum,1)*sampling_rate;
fused_cum = interp1(Syt7KO.x, Syt7KO.y(:,25),time_sample);
Syt7KO.fused = diff(fused_cum,1)*sampling_rate;


figure(); plot(time_sample(1:end-1), WT.fused, 'k', 'LineWidth', 2); 
xlabel('time (s)'); ylabel('fusion rate (vesicles/s)'); title('WT')
set(gca,'TickDir','out');
box off
hold on
plot([0.3 0.4], [3e4, 3e4], 'k')
plot([0.3 0.3], [3e4, 5e4], 'k')
figure(); plot(time_sample(1:end-1), Syt7KO.fused, 'c', 'LineWidth', 2); 
xlabel('time (s)'); ylabel('fusion rate (vesicles/s)'); title('Syt7KO')
set(gca,'TickDir','out');
box off
figure(); plot(time_sample(1:end-1), Doc2KO.fused, 'm', 'LineWidth', 2); 
xlabel('time (s)'); ylabel('fusion rate (vesicles/s)'); title('Doc2KO')
set(gca,'TickDir','out');
box off
%% plot zoom-in fusion rate over time
figure()
hold on
 plot(time_sample(1:end-1), Syt7KO.fused, 'c', 'LineWidth', 2);
 ylim([0 400])
 for i = 1:length(t_int_low_5);xline(t_int_low_5(i));end
xlim([ 0 0.5])
for i = 1:length(t_int_low_5);xline(t_int_high(i));end

 figure()
hold on
 plot(time_sample(1:end-1), Doc2KO.fused, 'm', 'LineWidth', 2);
 ylim([0 400])
 for i = 1:length(t_int_low_5);xline(t_int_low_5(i));end
xlim([ 0 0.5])
for i = 1:length(t_int_low_5);xline(t_int_high(i));end

 figure()
hold on
 plot(time_sample(1:end-1), WT.fused, 'k', 'LineWidth', 2); 
 ylim([0 400])
 for i = 1:length(t_int_low_5);xline(t_int_low_5(i));end
xlim([ 0 0.5])
for i = 1:length(t_int_low_5);xline(t_int_high(i));end
% plot([0.3 0.4], [3e4, 3e4], 'k')
% plot([0.3 0.3], [3e4, 5e4], 'k')

 xlabel('time (s)'); ylabel('fusion rate (vesicles/s)');

 set(gca,'TickDir','out');

 
%% plot peak release rates
 % peak rates
 t_int_high = [50e-3:50e-3:0.5];
t_int_low_5 = [0:50e-3:0.45];
for i = 1:length(t_int_low_5)
    WT.amplitude(i) = max(WT.fused(time_sample>t_int_low_5(i)&time_sample<t_int_high(i)));
    Doc2KO.amplitude(i) = max(Doc2KO.fused(time_sample>t_int_low_5(i)&time_sample<t_int_high(i)));
    Syt7KO.amplitude(i) = max(Syt7KO.fused(time_sample>t_int_low_5(i)&time_sample<t_int_high(i)));
   DKO.amplitude(i) = max(DKO.fused(time_sample>t_int_low_5(i)&time_sample<t_int_high(i)));    
end

figure()
 plot([1:10], WT.amplitude,'-ok', 'LineWidth', 2); hold on
plot([1:10], Syt7KO.amplitude,'-oc', 'LineWidth', 2);
plot([1:10], Doc2KO.amplitude,'-om', 'LineWidth', 2);
plot([1:10], DKO.amplitude,'-ob', 'LineWidth', 2);
legend('WT', 'Syt7KO' , 'Doc2KO')
xlabel('stimulation number')
ylabel('Peak release rate (ves/s)')

 set(gca,'TickDir','out');
ylim([0 5e4])
box off

%% Calcium transient
freq = 20;
no = 10;

x = [0:1e-6:1/freq];
%y = normpdf(x,1.5e-3,4e-4);
y = normpdf(x,1.5e-3,2e-4);
y = y/max(y)*30;

time = [0:1e-6:1/freq*no];
Ca= repmat(y, no);


Casignal = [time; Ca(1,1:length(time))]';
Casignal(:,2)= Casignal(:,2) + 0.05;

t0 = [1.6e-3:1/freq:1/freq*no]; t= Casignal(:,1);
tau2 = 0.2;A = 0.75;
y1 =  exp(-((t-t0)./tau2))*A.*(t>=t0);
km = 0.0001;
y2 = (-t0+t)./(-t0+t+km);
%Casignal(:,2) = Casignal(:,2) + sum(y1,2); 
Casignal(:,2) = Casignal(:,2) + sum(y1.*y2,2); 

f = figure(); plot(Casignal(:,1), Casignal(:,2)); hold on
%ylim([ 0 50])
%plot([0.1 0.1], [35, 45], 'k')
%axis off
 xlabel('time (s)')
 ylabel('[Ca]')
 
 
 %% Ca2+ binding to syt7/Doc2/Syt1
 
avg_CatoSyt7 =  mean(WT.y(:,26:28)*[0; 1; 2],2);

doc2(:,1) = sum(WT.y(:,[1,4,7:12]),2); %0 Ca
doc2(:,2) = sum(WT.y(:,[2,5,13:18]),2);
doc2(:,3) = sum(WT.y(:,[3,6,19:24]),2);

doc2 = doc2./sum(doc2,2);
avg_CatoDoc2 = mean(doc2*[0;1;2],2);

syt1(:,1) = sum(WT.y(:, [7 13 19]),2);
syt1(:,2) = sum(WT.y(:, [8 14 20]),2);
syt1(:,3) = sum(WT.y(:, [9 15 21]),2);
syt1(:,4) = sum(WT.y(:, [10 16 22]),2);
syt1(:,5) = sum(WT.y(:, [11 17 23]),2);
syt1(:,6) = sum(WT.y(:, [12 18 24]),2);

syt1 = syt1./sum(syt1,2);
avg_CatoSyt1 = mean(syt1*[0;1;2;3;4;5],2);

figure()
plot(WT.x, avg_CatoSyt1, 'b')
hold on
plot(WT.x, avg_CatoDoc2, 'g')
plot(WT.x, avg_CatoSyt7, 'r')
xlabel('time (s)')
ylabel('avg number of Ca2+ ions bound')
legend('syt1', 'doc2', 'syt7')

%% plot fraction asynchronous

fusion = diff(WT.y(:,25));
t_int_high = [50e-3:50e-3:2.5];
t_int_low_5 = [10e-3:50e-3:2.5];
t_int_low = [0e-3:50e-3:2.5];
for i = 1:length(t_int_low_5)
    Intervalsum_fusion_5(i) = sum(fusion(WT.x>t_int_low_5(i)&WT.x<t_int_high(i)));
    Intervalsum_total(i) = sum(fusion(WT.x>t_int_low(i)&WT.x<t_int_high(i)));
end
WT.cumsum_fusion_5 = Intervalsum_fusion_5;%cumsum(Intervalsum_fusion_5);
WT.cumsum_fusion = Intervalsum_total;%cumsum(Intervalsum_total);

fusion = diff(Syt7KO.y(:,25));
for i = 1:length(t_int_low_5)
    Intervalsum_fusion_5(i) = sum(fusion(Syt7KO.x>t_int_low_5(i)&Syt7KO.x<t_int_high(i)));
 Intervalsum_total(i) = sum(fusion(Syt7KO.x>t_int_low(i)&Syt7KO.x<t_int_high(i)));
end
Syt7KO.cumsum_fusion_5 = Intervalsum_fusion_5;%cumsum(Intervalsum_fusion_5);
Syt7KO.cumsum_fusion = Intervalsum_total;%cumsum(Intervalsum_total);


fusion = diff(Doc2KO.y(:,25));
for i = 1:length(t_int_low_5)
    Intervalsum_fusion_5(i) = sum(fusion(Doc2KO.x>t_int_low_5(i)&Doc2KO.x<t_int_high(i)));
     Intervalsum_total(i) = sum(fusion(Doc2KO.x>t_int_low(i)&Doc2KO.x<t_int_high(i)));
end
Doc2KO.cumsum_fusion_5 = Intervalsum_fusion_5; %cumsum(Intervalsum_fusion_5);
Doc2KO.cumsum_fusion = Intervalsum_total;%cumsum(Intervalsum_total);


figure(); plot([1:50], WT.cumsum_fusion_5./WT.cumsum_fusion,'-ok', 'LineWidth', 2); hold on
plot([1:50], Syt7KO.cumsum_fusion_5./Syt7KO.cumsum_fusion,'-oc', 'LineWidth', 2);
plot([1:50], Doc2KO.cumsum_fusion_5./Doc2KO.cumsum_fusion ,'-om', 'LineWidth', 2);
legend('WT', 'Syt7KO' , 'Doc2KO')
xlabel('stimulation number')
ylabel('Fraction asynchronous (>5ms)')
xlim([1 10])
set(gca,'TickDir','out');
box off
%%
X = categorical({'WT','Doc2aKO','Syt7KO'});
X = reordercats(X,{'WT','Doc2aKO','Syt7KO'});
Y = [sum(WT.cumsum_fusion_5), sum(Doc2KO.cumsum_fusion_5), sum(Syt7KO.cumsum_fusion_5)];
figure();bar(X,Y)
box off

set(gca,'TickDir','out');





